import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityMonitoringFilterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The filtered data type. Valid values are `logs`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#filtered_data_type SecurityMonitoringFilter#filtered_data_type}
    */
    readonly filteredDataType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#id SecurityMonitoringFilter#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether the security filter is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#is_enabled SecurityMonitoringFilter#is_enabled}
    */
    readonly isEnabled: boolean | cdktf.IResolvable;
    /**
    * The name of the security filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#name SecurityMonitoringFilter#name}
    */
    readonly name: string;
    /**
    * The query of the security filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#query SecurityMonitoringFilter#query}
    */
    readonly query: string;
    /**
    * exclusion_filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#exclusion_filter SecurityMonitoringFilter#exclusion_filter}
    */
    readonly exclusionFilter?: SecurityMonitoringFilterExclusionFilter[] | cdktf.IResolvable;
}
export interface SecurityMonitoringFilterExclusionFilter {
    /**
    * Exclusion filter name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#name SecurityMonitoringFilter#name}
    */
    readonly name: string;
    /**
    * Exclusion filter query. Logs that match this query are excluded from the security filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter#query SecurityMonitoringFilter#query}
    */
    readonly query: string;
}
export declare function securityMonitoringFilterExclusionFilterToTerraform(struct?: SecurityMonitoringFilterExclusionFilter | cdktf.IResolvable): any;
export declare class SecurityMonitoringFilterExclusionFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityMonitoringFilterExclusionFilter | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityMonitoringFilterExclusionFilter | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class SecurityMonitoringFilterExclusionFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityMonitoringFilterExclusionFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityMonitoringFilterExclusionFilterOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter datadog_security_monitoring_filter}
*/
export declare class SecurityMonitoringFilter extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_security_monitoring_filter";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_filter datadog_security_monitoring_filter} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityMonitoringFilterConfig
    */
    constructor(scope: Construct, id: string, config: SecurityMonitoringFilterConfig);
    private _filteredDataType?;
    get filteredDataType(): string;
    set filteredDataType(value: string);
    resetFilteredDataType(): void;
    get filteredDataTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    get version(): number;
    private _exclusionFilter;
    get exclusionFilter(): SecurityMonitoringFilterExclusionFilterList;
    putExclusionFilter(value: SecurityMonitoringFilterExclusionFilter[] | cdktf.IResolvable): void;
    resetExclusionFilter(): void;
    get exclusionFilterInput(): cdktf.IResolvable | SecurityMonitoringFilterExclusionFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
