import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityMonitoringRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether the rule is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#enabled SecurityMonitoringRule#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Whether the notifications include the triggering group-by values in their title.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#has_extended_title SecurityMonitoringRule#has_extended_title}
    */
    readonly hasExtendedTitle?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#id SecurityMonitoringRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Message for generated signals.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#message SecurityMonitoringRule#message}
    */
    readonly message: string;
    /**
    * The name of the rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#name SecurityMonitoringRule#name}
    */
    readonly name: string;
    /**
    * Tags for generated signals.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#tags SecurityMonitoringRule#tags}
    */
    readonly tags?: string[];
    /**
    * The rule type. Valid values are `log_detection`, `workload_security`, `signal_correlation`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#type SecurityMonitoringRule#type}
    */
    readonly type?: string;
    /**
    * case block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#case SecurityMonitoringRule#case}
    */
    readonly case: SecurityMonitoringRuleCase[] | cdktf.IResolvable;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#filter SecurityMonitoringRule#filter}
    */
    readonly filter?: SecurityMonitoringRuleFilter[] | cdktf.IResolvable;
    /**
    * options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#options SecurityMonitoringRule#options}
    */
    readonly options?: SecurityMonitoringRuleOptions;
    /**
    * query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#query SecurityMonitoringRule#query}
    */
    readonly query?: SecurityMonitoringRuleQuery[] | cdktf.IResolvable;
    /**
    * signal_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#signal_query SecurityMonitoringRule#signal_query}
    */
    readonly signalQuery?: SecurityMonitoringRuleSignalQuery[] | cdktf.IResolvable;
}
export interface SecurityMonitoringRuleCase {
    /**
    * A rule case contains logical operations (`>`,`>=`, `&&`, `||`) to determine if a signal should be generated based on the event counts in the previously defined queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#condition SecurityMonitoringRule#condition}
    */
    readonly condition?: string;
    /**
    * Name of the case.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#name SecurityMonitoringRule#name}
    */
    readonly name?: string;
    /**
    * Notification targets for each rule case.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#notifications SecurityMonitoringRule#notifications}
    */
    readonly notifications?: string[];
    /**
    * Severity of the Security Signal. Valid values are `info`, `low`, `medium`, `high`, `critical`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#status SecurityMonitoringRule#status}
    */
    readonly status: string;
}
export declare function securityMonitoringRuleCaseToTerraform(struct?: SecurityMonitoringRuleCase | cdktf.IResolvable): any;
export declare class SecurityMonitoringRuleCaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityMonitoringRuleCase | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityMonitoringRuleCase | cdktf.IResolvable | undefined);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _notifications?;
    get notifications(): string[];
    set notifications(value: string[]);
    resetNotifications(): void;
    get notificationsInput(): string[] | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    get statusInput(): string | undefined;
}
export declare class SecurityMonitoringRuleCaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityMonitoringRuleCase[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityMonitoringRuleCaseOutputReference;
}
export interface SecurityMonitoringRuleFilter {
    /**
    * The type of filtering action. Valid values are `require`, `suppress`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#action SecurityMonitoringRule#action}
    */
    readonly action: string;
    /**
    * Query for selecting logs to apply the filtering action.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#query SecurityMonitoringRule#query}
    */
    readonly query: string;
}
export declare function securityMonitoringRuleFilterToTerraform(struct?: SecurityMonitoringRuleFilter | cdktf.IResolvable): any;
export declare class SecurityMonitoringRuleFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityMonitoringRuleFilter | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityMonitoringRuleFilter | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class SecurityMonitoringRuleFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityMonitoringRuleFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityMonitoringRuleFilterOutputReference;
}
export interface SecurityMonitoringRuleOptionsImpossibleTravelOptions {
    /**
    * If true, signals are suppressed for the first 24 hours. During that time, Datadog learns the user's regular access locations. This can be helpful to reduce noise and infer VPN usage or credentialed API access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#baseline_user_locations SecurityMonitoringRule#baseline_user_locations}
    */
    readonly baselineUserLocations?: boolean | cdktf.IResolvable;
}
export declare function securityMonitoringRuleOptionsImpossibleTravelOptionsToTerraform(struct?: SecurityMonitoringRuleOptionsImpossibleTravelOptionsOutputReference | SecurityMonitoringRuleOptionsImpossibleTravelOptions): any;
export declare class SecurityMonitoringRuleOptionsImpossibleTravelOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityMonitoringRuleOptionsImpossibleTravelOptions | undefined;
    set internalValue(value: SecurityMonitoringRuleOptionsImpossibleTravelOptions | undefined);
    private _baselineUserLocations?;
    get baselineUserLocations(): boolean | cdktf.IResolvable;
    set baselineUserLocations(value: boolean | cdktf.IResolvable);
    resetBaselineUserLocations(): void;
    get baselineUserLocationsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SecurityMonitoringRuleOptionsNewValueOptions {
    /**
    * The duration in days after which a learned value is forgotten. Valid values are `1`, `2`, `7`, `14`, `21`, `28`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#forget_after SecurityMonitoringRule#forget_after}
    */
    readonly forgetAfter: number;
    /**
    * The duration in days during which values are learned, and after which signals will be generated for values that weren't learned. If set to 0, a signal will be generated for all new values after the first value is learned. Valid values are `0`, `1`, `7`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#learning_duration SecurityMonitoringRule#learning_duration}
    */
    readonly learningDuration?: number;
    /**
    * The learning method used to determine when signals should be generated for values that weren't learned. Valid values are `duration`, `threshold`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#learning_method SecurityMonitoringRule#learning_method}
    */
    readonly learningMethod?: string;
    /**
    * A number of occurrences after which signals are generated for values that weren't learned. Valid values are `0`, `1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#learning_threshold SecurityMonitoringRule#learning_threshold}
    */
    readonly learningThreshold?: number;
}
export declare function securityMonitoringRuleOptionsNewValueOptionsToTerraform(struct?: SecurityMonitoringRuleOptionsNewValueOptionsOutputReference | SecurityMonitoringRuleOptionsNewValueOptions): any;
export declare class SecurityMonitoringRuleOptionsNewValueOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityMonitoringRuleOptionsNewValueOptions | undefined;
    set internalValue(value: SecurityMonitoringRuleOptionsNewValueOptions | undefined);
    private _forgetAfter?;
    get forgetAfter(): number;
    set forgetAfter(value: number);
    get forgetAfterInput(): number | undefined;
    private _learningDuration?;
    get learningDuration(): number;
    set learningDuration(value: number);
    resetLearningDuration(): void;
    get learningDurationInput(): number | undefined;
    private _learningMethod?;
    get learningMethod(): string;
    set learningMethod(value: string);
    resetLearningMethod(): void;
    get learningMethodInput(): string | undefined;
    private _learningThreshold?;
    get learningThreshold(): number;
    set learningThreshold(value: number);
    resetLearningThreshold(): void;
    get learningThresholdInput(): number | undefined;
}
export interface SecurityMonitoringRuleOptions {
    /**
    * If true, signals in non-production environments have a lower severity than what is defined by the rule case, which can reduce noise. The decrement is applied when the environment tag of the signal starts with `staging`, `test`, or `dev`. Only available when the rule type is `log_detection`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#decrease_criticality_based_on_env SecurityMonitoringRule#decrease_criticality_based_on_env}
    */
    readonly decreaseCriticalityBasedOnEnv?: boolean | cdktf.IResolvable;
    /**
    * The detection method. Valid values are `threshold`, `new_value`, `anomaly_detection`, `impossible_travel`, `hardcoded`, `third_party`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#detection_method SecurityMonitoringRule#detection_method}
    */
    readonly detectionMethod?: string;
    /**
    * A time window is specified to match when at least one of the cases matches true. This is a sliding window and evaluates in real time. Valid values are `0`, `60`, `300`, `600`, `900`, `1800`, `3600`, `7200`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#evaluation_window SecurityMonitoringRule#evaluation_window}
    */
    readonly evaluationWindow?: number;
    /**
    * Once a signal is generated, the signal will remain “open” if a case is matched at least once within this keep alive window. Valid values are `0`, `60`, `300`, `600`, `900`, `1800`, `3600`, `7200`, `10800`, `21600`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#keep_alive SecurityMonitoringRule#keep_alive}
    */
    readonly keepAlive: number;
    /**
    * A signal will “close” regardless of the query being matched once the time exceeds the maximum duration. This time is calculated from the first seen timestamp. Valid values are `0`, `60`, `300`, `600`, `900`, `1800`, `3600`, `7200`, `10800`, `21600`, `43200`, `86400`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#max_signal_duration SecurityMonitoringRule#max_signal_duration}
    */
    readonly maxSignalDuration: number;
    /**
    * impossible_travel_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#impossible_travel_options SecurityMonitoringRule#impossible_travel_options}
    */
    readonly impossibleTravelOptions?: SecurityMonitoringRuleOptionsImpossibleTravelOptions;
    /**
    * new_value_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#new_value_options SecurityMonitoringRule#new_value_options}
    */
    readonly newValueOptions?: SecurityMonitoringRuleOptionsNewValueOptions;
}
export declare function securityMonitoringRuleOptionsToTerraform(struct?: SecurityMonitoringRuleOptionsOutputReference | SecurityMonitoringRuleOptions): any;
export declare class SecurityMonitoringRuleOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityMonitoringRuleOptions | undefined;
    set internalValue(value: SecurityMonitoringRuleOptions | undefined);
    private _decreaseCriticalityBasedOnEnv?;
    get decreaseCriticalityBasedOnEnv(): boolean | cdktf.IResolvable;
    set decreaseCriticalityBasedOnEnv(value: boolean | cdktf.IResolvable);
    resetDecreaseCriticalityBasedOnEnv(): void;
    get decreaseCriticalityBasedOnEnvInput(): boolean | cdktf.IResolvable | undefined;
    private _detectionMethod?;
    get detectionMethod(): string;
    set detectionMethod(value: string);
    resetDetectionMethod(): void;
    get detectionMethodInput(): string | undefined;
    private _evaluationWindow?;
    get evaluationWindow(): number;
    set evaluationWindow(value: number);
    resetEvaluationWindow(): void;
    get evaluationWindowInput(): number | undefined;
    private _keepAlive?;
    get keepAlive(): number;
    set keepAlive(value: number);
    get keepAliveInput(): number | undefined;
    private _maxSignalDuration?;
    get maxSignalDuration(): number;
    set maxSignalDuration(value: number);
    get maxSignalDurationInput(): number | undefined;
    private _impossibleTravelOptions;
    get impossibleTravelOptions(): SecurityMonitoringRuleOptionsImpossibleTravelOptionsOutputReference;
    putImpossibleTravelOptions(value: SecurityMonitoringRuleOptionsImpossibleTravelOptions): void;
    resetImpossibleTravelOptions(): void;
    get impossibleTravelOptionsInput(): SecurityMonitoringRuleOptionsImpossibleTravelOptions | undefined;
    private _newValueOptions;
    get newValueOptions(): SecurityMonitoringRuleOptionsNewValueOptionsOutputReference;
    putNewValueOptions(value: SecurityMonitoringRuleOptionsNewValueOptions): void;
    resetNewValueOptions(): void;
    get newValueOptionsInput(): SecurityMonitoringRuleOptionsNewValueOptions | undefined;
}
export interface SecurityMonitoringRuleQueryAgentRule {
    /**
    * **Deprecated**. It won't be applied anymore.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#agent_rule_id SecurityMonitoringRule#agent_rule_id}
    */
    readonly agentRuleId: string;
    /**
    * **Deprecated**. It won't be applied anymore.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#expression SecurityMonitoringRule#expression}
    */
    readonly expression: string;
}
export declare function securityMonitoringRuleQueryAgentRuleToTerraform(struct?: SecurityMonitoringRuleQueryAgentRule | cdktf.IResolvable): any;
export declare class SecurityMonitoringRuleQueryAgentRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityMonitoringRuleQueryAgentRule | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityMonitoringRuleQueryAgentRule | cdktf.IResolvable | undefined);
    private _agentRuleId?;
    get agentRuleId(): string;
    set agentRuleId(value: string);
    get agentRuleIdInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
}
export declare class SecurityMonitoringRuleQueryAgentRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityMonitoringRuleQueryAgentRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityMonitoringRuleQueryAgentRuleOutputReference;
}
export interface SecurityMonitoringRuleQuery {
    /**
    * The aggregation type. For Signal Correlation rules, it must be event_count. Valid values are `count`, `cardinality`, `sum`, `max`, `new_value`, `geo_data`, `event_count`, `none`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#aggregation SecurityMonitoringRule#aggregation}
    */
    readonly aggregation?: string;
    /**
    * Field for which the cardinality is measured. Sent as an array.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#distinct_fields SecurityMonitoringRule#distinct_fields}
    */
    readonly distinctFields?: string[];
    /**
    * Fields to group by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#group_by_fields SecurityMonitoringRule#group_by_fields}
    */
    readonly groupByFields?: string[];
    /**
    * The target field to aggregate over when using the `sum`, `max`, or `geo_data` aggregations. **Deprecated.** Configure `metrics` instead. This attribute will be removed in the next major version of the provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#metric SecurityMonitoringRule#metric}
    */
    readonly metric?: string;
    /**
    * Group of target fields to aggregate over when using the `sum`, `max`, `geo_data`, or `new_value` aggregations. The `sum`, `max`, and `geo_data` aggregations only accept one value in this list, whereas the `new_value` aggregation accepts up to five values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#metrics SecurityMonitoringRule#metrics}
    */
    readonly metrics?: string[];
    /**
    * Name of the query. Not compatible with `new_value` aggregations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#name SecurityMonitoringRule#name}
    */
    readonly name?: string;
    /**
    * Query to run on logs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#query SecurityMonitoringRule#query}
    */
    readonly query: string;
    /**
    * agent_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#agent_rule SecurityMonitoringRule#agent_rule}
    */
    readonly agentRule?: SecurityMonitoringRuleQueryAgentRule[] | cdktf.IResolvable;
}
export declare function securityMonitoringRuleQueryToTerraform(struct?: SecurityMonitoringRuleQuery | cdktf.IResolvable): any;
export declare class SecurityMonitoringRuleQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityMonitoringRuleQuery | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityMonitoringRuleQuery | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    resetAggregation(): void;
    get aggregationInput(): string | undefined;
    private _distinctFields?;
    get distinctFields(): string[];
    set distinctFields(value: string[]);
    resetDistinctFields(): void;
    get distinctFieldsInput(): string[] | undefined;
    private _groupByFields?;
    get groupByFields(): string[];
    set groupByFields(value: string[]);
    resetGroupByFields(): void;
    get groupByFieldsInput(): string[] | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _metrics?;
    get metrics(): string[];
    set metrics(value: string[]);
    resetMetrics(): void;
    get metricsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _agentRule;
    get agentRule(): SecurityMonitoringRuleQueryAgentRuleList;
    putAgentRule(value: SecurityMonitoringRuleQueryAgentRule[] | cdktf.IResolvable): void;
    resetAgentRule(): void;
    get agentRuleInput(): cdktf.IResolvable | SecurityMonitoringRuleQueryAgentRule[] | undefined;
}
export declare class SecurityMonitoringRuleQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityMonitoringRuleQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityMonitoringRuleQueryOutputReference;
}
export interface SecurityMonitoringRuleSignalQuery {
    /**
    * The aggregation type. For Signal Correlation rules, it must be event_count. Valid values are `count`, `cardinality`, `sum`, `max`, `new_value`, `geo_data`, `event_count`, `none`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#aggregation SecurityMonitoringRule#aggregation}
    */
    readonly aggregation?: string;
    /**
    * Fields to correlate by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#correlated_by_fields SecurityMonitoringRule#correlated_by_fields}
    */
    readonly correlatedByFields?: string[];
    /**
    * Index of the rule query used to retrieve the correlated field. An empty string applies correlation on the non-projected per query attributes of the rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#correlated_query_index SecurityMonitoringRule#correlated_query_index}
    */
    readonly correlatedQueryIndex?: string;
    /**
    * Default Rule ID of the signal to correlate. This value is READ-ONLY.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#default_rule_id SecurityMonitoringRule#default_rule_id}
    */
    readonly defaultRuleId?: string;
    /**
    * Name of the query. Not compatible with `new_value` aggregations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#name SecurityMonitoringRule#name}
    */
    readonly name?: string;
    /**
    * Rule ID of the signal to correlate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule#rule_id SecurityMonitoringRule#rule_id}
    */
    readonly ruleId: string;
}
export declare function securityMonitoringRuleSignalQueryToTerraform(struct?: SecurityMonitoringRuleSignalQuery | cdktf.IResolvable): any;
export declare class SecurityMonitoringRuleSignalQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityMonitoringRuleSignalQuery | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityMonitoringRuleSignalQuery | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    resetAggregation(): void;
    get aggregationInput(): string | undefined;
    private _correlatedByFields?;
    get correlatedByFields(): string[];
    set correlatedByFields(value: string[]);
    resetCorrelatedByFields(): void;
    get correlatedByFieldsInput(): string[] | undefined;
    private _correlatedQueryIndex?;
    get correlatedQueryIndex(): string;
    set correlatedQueryIndex(value: string);
    resetCorrelatedQueryIndex(): void;
    get correlatedQueryIndexInput(): string | undefined;
    private _defaultRuleId?;
    get defaultRuleId(): string;
    set defaultRuleId(value: string);
    resetDefaultRuleId(): void;
    get defaultRuleIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _ruleId?;
    get ruleId(): string;
    set ruleId(value: string);
    get ruleIdInput(): string | undefined;
}
export declare class SecurityMonitoringRuleSignalQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityMonitoringRuleSignalQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityMonitoringRuleSignalQueryOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule datadog_security_monitoring_rule}
*/
export declare class SecurityMonitoringRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_security_monitoring_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule datadog_security_monitoring_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityMonitoringRuleConfig
    */
    constructor(scope: Construct, id: string, config: SecurityMonitoringRuleConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hasExtendedTitle?;
    get hasExtendedTitle(): boolean | cdktf.IResolvable;
    set hasExtendedTitle(value: boolean | cdktf.IResolvable);
    resetHasExtendedTitle(): void;
    get hasExtendedTitleInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _message?;
    get message(): string;
    set message(value: string);
    get messageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _case;
    get case(): SecurityMonitoringRuleCaseList;
    putCase(value: SecurityMonitoringRuleCase[] | cdktf.IResolvable): void;
    get caseInput(): cdktf.IResolvable | SecurityMonitoringRuleCase[] | undefined;
    private _filter;
    get filter(): SecurityMonitoringRuleFilterList;
    putFilter(value: SecurityMonitoringRuleFilter[] | cdktf.IResolvable): void;
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | SecurityMonitoringRuleFilter[] | undefined;
    private _options;
    get options(): SecurityMonitoringRuleOptionsOutputReference;
    putOptions(value: SecurityMonitoringRuleOptions): void;
    resetOptions(): void;
    get optionsInput(): SecurityMonitoringRuleOptions | undefined;
    private _query;
    get query(): SecurityMonitoringRuleQueryList;
    putQuery(value: SecurityMonitoringRuleQuery[] | cdktf.IResolvable): void;
    resetQuery(): void;
    get queryInput(): cdktf.IResolvable | SecurityMonitoringRuleQuery[] | undefined;
    private _signalQuery;
    get signalQuery(): SecurityMonitoringRuleSignalQueryList;
    putSignalQuery(value: SecurityMonitoringRuleSignalQuery[] | cdktf.IResolvable): void;
    resetSignalQuery(): void;
    get signalQueryInput(): cdktf.IResolvable | SecurityMonitoringRuleSignalQuery[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
