import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether the service account is disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_account#disabled ServiceAccount#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Email of the associated user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_account#email ServiceAccount#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_account#id ServiceAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name for the service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_account#name ServiceAccount#name}
    */
    readonly name?: string;
    /**
    * A list a role IDs to assign to the service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_account#roles ServiceAccount#roles}
    */
    readonly roles?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/service_account datadog_service_account}
*/
export declare class ServiceAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_service_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/service_account datadog_service_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceAccountConfig
    */
    constructor(scope: Construct, id: string, config: ServiceAccountConfig);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    resetRoles(): void;
    get rolesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
