import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceDefinitionYamlConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_definition_yaml#id ServiceDefinitionYaml#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The YAML/JSON formatted definition of the service
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_definition_yaml#service_definition ServiceDefinitionYaml#service_definition}
    */
    readonly serviceDefinition: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/service_definition_yaml datadog_service_definition_yaml}
*/
export declare class ServiceDefinitionYaml extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_service_definition_yaml";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/service_definition_yaml datadog_service_definition_yaml} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceDefinitionYamlConfig
    */
    constructor(scope: Construct, id: string, config: ServiceDefinitionYamlConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _serviceDefinition?;
    get serviceDefinition(): string;
    set serviceDefinition(value: string);
    get serviceDefinitionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
