import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceLevelObjectiveConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of this service level objective.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#description ServiceLevelObjective#description}
    */
    readonly description?: string;
    /**
    * A boolean indicating whether this monitor can be deleted even if it’s referenced by other resources (e.g. dashboards).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#force_delete ServiceLevelObjective#force_delete}
    */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
    * A static set of groups to filter monitor-based SLOs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#groups ServiceLevelObjective#groups}
    */
    readonly groups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#id ServiceLevelObjective#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A static set of monitor IDs to use as part of the SLO
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#monitor_ids ServiceLevelObjective#monitor_ids}
    */
    readonly monitorIds?: number[];
    /**
    * Name of Datadog service level objective
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#name ServiceLevelObjective#name}
    */
    readonly name: string;
    /**
    * A list of tags to associate with your service level objective. This can help you categorize and filter service level objectives in the service level objectives page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#tags ServiceLevelObjective#tags}
    */
    readonly tags?: string[];
    /**
    * The objective's target in `(0,100)`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#target_threshold ServiceLevelObjective#target_threshold}
    */
    readonly targetThreshold?: number;
    /**
    * The time frame for the objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API documentation page. Valid values are `7d`, `30d`, `90d`, `custom`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#timeframe ServiceLevelObjective#timeframe}
    */
    readonly timeframe?: string;
    /**
    * The type of the service level objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API [documentation page](https://docs.datadoghq.com/api/v1/service-level-objectives/#create-a-slo-object). Valid values are `metric`, `monitor`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#type ServiceLevelObjective#type}
    */
    readonly type: string;
    /**
    * Whether or not to validate the SLO.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#validate ServiceLevelObjective#validate}
    */
    readonly validate?: boolean | cdktf.IResolvable;
    /**
    * The objective's warning value in `(0,100)`. This must be greater than the target value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#warning_threshold ServiceLevelObjective#warning_threshold}
    */
    readonly warningThreshold?: number;
    /**
    * query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#query ServiceLevelObjective#query}
    */
    readonly query?: ServiceLevelObjectiveQuery;
    /**
    * thresholds block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#thresholds ServiceLevelObjective#thresholds}
    */
    readonly thresholds: ServiceLevelObjectiveThresholds[] | cdktf.IResolvable;
}
export interface ServiceLevelObjectiveQuery {
    /**
    * The sum of the `total` events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#denominator ServiceLevelObjective#denominator}
    */
    readonly denominator: string;
    /**
    * The sum of all the `good` events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#numerator ServiceLevelObjective#numerator}
    */
    readonly numerator: string;
}
export declare function serviceLevelObjectiveQueryToTerraform(struct?: ServiceLevelObjectiveQueryOutputReference | ServiceLevelObjectiveQuery): any;
export declare class ServiceLevelObjectiveQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceLevelObjectiveQuery | undefined;
    set internalValue(value: ServiceLevelObjectiveQuery | undefined);
    private _denominator?;
    get denominator(): string;
    set denominator(value: string);
    get denominatorInput(): string | undefined;
    private _numerator?;
    get numerator(): string;
    set numerator(value: string);
    get numeratorInput(): string | undefined;
}
export interface ServiceLevelObjectiveThresholds {
    /**
    * The objective's target in `(0,100)`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#target ServiceLevelObjective#target}
    */
    readonly target: number;
    /**
    * The time frame for the objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API documentation page. Valid values are `7d`, `30d`, `90d`, `custom`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#timeframe ServiceLevelObjective#timeframe}
    */
    readonly timeframe: string;
    /**
    * The objective's warning value in `(0,100)`. This must be greater than the target value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective#warning ServiceLevelObjective#warning}
    */
    readonly warning?: number;
}
export declare function serviceLevelObjectiveThresholdsToTerraform(struct?: ServiceLevelObjectiveThresholds | cdktf.IResolvable): any;
export declare class ServiceLevelObjectiveThresholdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceLevelObjectiveThresholds | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceLevelObjectiveThresholds | cdktf.IResolvable | undefined);
    private _target?;
    get target(): number;
    set target(value: number);
    get targetInput(): number | undefined;
    get targetDisplay(): string;
    private _timeframe?;
    get timeframe(): string;
    set timeframe(value: string);
    get timeframeInput(): string | undefined;
    private _warning?;
    get warning(): number;
    set warning(value: number);
    resetWarning(): void;
    get warningInput(): number | undefined;
    get warningDisplay(): string;
}
export declare class ServiceLevelObjectiveThresholdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServiceLevelObjectiveThresholds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceLevelObjectiveThresholdsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective datadog_service_level_objective}
*/
export declare class ServiceLevelObjective extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_service_level_objective";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/service_level_objective datadog_service_level_objective} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceLevelObjectiveConfig
    */
    constructor(scope: Construct, id: string, config: ServiceLevelObjectiveConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _forceDelete?;
    get forceDelete(): boolean | cdktf.IResolvable;
    set forceDelete(value: boolean | cdktf.IResolvable);
    resetForceDelete(): void;
    get forceDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    resetGroups(): void;
    get groupsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _monitorIds?;
    get monitorIds(): number[];
    set monitorIds(value: number[]);
    resetMonitorIds(): void;
    get monitorIdsInput(): number[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetThreshold?;
    get targetThreshold(): number;
    set targetThreshold(value: number);
    resetTargetThreshold(): void;
    get targetThresholdInput(): number | undefined;
    private _timeframe?;
    get timeframe(): string;
    set timeframe(value: string);
    resetTimeframe(): void;
    get timeframeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _validate?;
    get validate(): boolean | cdktf.IResolvable;
    set validate(value: boolean | cdktf.IResolvable);
    resetValidate(): void;
    get validateInput(): boolean | cdktf.IResolvable | undefined;
    private _warningThreshold?;
    get warningThreshold(): number;
    set warningThreshold(value: number);
    resetWarningThreshold(): void;
    get warningThresholdInput(): number | undefined;
    private _query;
    get query(): ServiceLevelObjectiveQueryOutputReference;
    putQuery(value: ServiceLevelObjectiveQuery): void;
    resetQuery(): void;
    get queryInput(): ServiceLevelObjectiveQuery | undefined;
    private _thresholds;
    get thresholds(): ServiceLevelObjectiveThresholdsList;
    putThresholds(value: ServiceLevelObjectiveThresholds[] | cdktf.IResolvable): void;
    get thresholdsInput(): cdktf.IResolvable | ServiceLevelObjectiveThresholds[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
