import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SloCorrectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Category the SLO correction belongs to. Valid values are `Scheduled Maintenance`, `Outside Business Hours`, `Deployment`, `Other`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#category SloCorrection#category}
    */
    readonly category: string;
    /**
    * Description of the correction being made.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#description SloCorrection#description}
    */
    readonly description?: string;
    /**
    * Length of time in seconds for a specified `rrule` recurring SLO correction (required if specifying `rrule`)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#duration SloCorrection#duration}
    */
    readonly duration?: number;
    /**
    * Ending time of the correction in epoch seconds. Required for one time corrections, but optional if `rrule` is specified
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#end SloCorrection#end}
    */
    readonly end?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#id SloCorrection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Recurrence rules as defined in the iCalendar RFC 5545. Supported rules for SLO corrections are `FREQ`, `INTERVAL`, `COUNT` and `UNTIL`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#rrule SloCorrection#rrule}
    */
    readonly rrule?: string;
    /**
    * ID of the SLO that this correction will be applied to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#slo_id SloCorrection#slo_id}
    */
    readonly sloId: string;
    /**
    * Starting time of the correction in epoch seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#start SloCorrection#start}
    */
    readonly start: number;
    /**
    * The timezone to display in the UI for the correction times (defaults to "UTC")
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction#timezone SloCorrection#timezone}
    */
    readonly timezone?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction datadog_slo_correction}
*/
export declare class SloCorrection extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_slo_correction";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction datadog_slo_correction} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SloCorrectionConfig
    */
    constructor(scope: Construct, id: string, config: SloCorrectionConfig);
    private _category?;
    get category(): string;
    set category(value: string);
    get categoryInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _duration?;
    get duration(): number;
    set duration(value: number);
    resetDuration(): void;
    get durationInput(): number | undefined;
    private _end?;
    get end(): number;
    set end(value: number);
    resetEnd(): void;
    get endInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _rrule?;
    get rrule(): string;
    set rrule(value: string);
    resetRrule(): void;
    get rruleInput(): string | undefined;
    private _sloId?;
    get sloId(): string;
    set sloId(value: string);
    get sloIdInput(): string | undefined;
    private _start?;
    get start(): number;
    set start(value: number);
    get startInput(): number | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
