import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SyntheticsGlobalVariableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the global variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#description SyntheticsGlobalVariable#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#id SyntheticsGlobalVariable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Synthetics global variable name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#name SyntheticsGlobalVariable#name}
    */
    readonly name: string;
    /**
    * Id of the Synthetics test to use for a variable from test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#parse_test_id SyntheticsGlobalVariable#parse_test_id}
    */
    readonly parseTestId?: string;
    /**
    * A list of role identifiers to associate with the Synthetics global variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#restricted_roles SyntheticsGlobalVariable#restricted_roles}
    */
    readonly restrictedRoles?: string[];
    /**
    * If set to true, the value of the global variable is hidden. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#secure SyntheticsGlobalVariable#secure}
    */
    readonly secure?: boolean | cdktf.IResolvable;
    /**
    * A list of tags to associate with your synthetics global variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#tags SyntheticsGlobalVariable#tags}
    */
    readonly tags?: string[];
    /**
    * The value of the global variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#value SyntheticsGlobalVariable#value}
    */
    readonly value: string;
    /**
    * options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#options SyntheticsGlobalVariable#options}
    */
    readonly options?: SyntheticsGlobalVariableOptions;
    /**
    * parse_test_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#parse_test_options SyntheticsGlobalVariable#parse_test_options}
    */
    readonly parseTestOptions?: SyntheticsGlobalVariableParseTestOptions;
}
export interface SyntheticsGlobalVariableOptionsTotpParameters {
    /**
    * Number of digits for the OTP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#digits SyntheticsGlobalVariable#digits}
    */
    readonly digits: number;
    /**
    * Interval for which to refresh the token (in seconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#refresh_interval SyntheticsGlobalVariable#refresh_interval}
    */
    readonly refreshInterval: number;
}
export declare function syntheticsGlobalVariableOptionsTotpParametersToTerraform(struct?: SyntheticsGlobalVariableOptionsTotpParametersOutputReference | SyntheticsGlobalVariableOptionsTotpParameters): any;
export declare class SyntheticsGlobalVariableOptionsTotpParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsGlobalVariableOptionsTotpParameters | undefined;
    set internalValue(value: SyntheticsGlobalVariableOptionsTotpParameters | undefined);
    private _digits?;
    get digits(): number;
    set digits(value: number);
    get digitsInput(): number | undefined;
    private _refreshInterval?;
    get refreshInterval(): number;
    set refreshInterval(value: number);
    get refreshIntervalInput(): number | undefined;
}
export interface SyntheticsGlobalVariableOptions {
    /**
    * totp_parameters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#totp_parameters SyntheticsGlobalVariable#totp_parameters}
    */
    readonly totpParameters?: SyntheticsGlobalVariableOptionsTotpParameters;
}
export declare function syntheticsGlobalVariableOptionsToTerraform(struct?: SyntheticsGlobalVariableOptionsOutputReference | SyntheticsGlobalVariableOptions): any;
export declare class SyntheticsGlobalVariableOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsGlobalVariableOptions | undefined;
    set internalValue(value: SyntheticsGlobalVariableOptions | undefined);
    private _totpParameters;
    get totpParameters(): SyntheticsGlobalVariableOptionsTotpParametersOutputReference;
    putTotpParameters(value: SyntheticsGlobalVariableOptionsTotpParameters): void;
    resetTotpParameters(): void;
    get totpParametersInput(): SyntheticsGlobalVariableOptionsTotpParameters | undefined;
}
export interface SyntheticsGlobalVariableParseTestOptionsParser {
    /**
    * Type of parser to extract the value. Valid values are `raw`, `json_path`, `regex`, `x_path`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#type SyntheticsGlobalVariable#type}
    */
    readonly type: string;
    /**
    * Value for the parser to use, required for type `json_path` or `regex`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#value SyntheticsGlobalVariable#value}
    */
    readonly value?: string;
}
export declare function syntheticsGlobalVariableParseTestOptionsParserToTerraform(struct?: SyntheticsGlobalVariableParseTestOptionsParserOutputReference | SyntheticsGlobalVariableParseTestOptionsParser): any;
export declare class SyntheticsGlobalVariableParseTestOptionsParserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsGlobalVariableParseTestOptionsParser | undefined;
    set internalValue(value: SyntheticsGlobalVariableParseTestOptionsParser | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface SyntheticsGlobalVariableParseTestOptions {
    /**
    * Required when type = `http_header`. Defines the header to use to extract the value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#field SyntheticsGlobalVariable#field}
    */
    readonly field?: string;
    /**
    * When type is `local_variable`, name of the local variable to use to extract the value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#local_variable_name SyntheticsGlobalVariable#local_variable_name}
    */
    readonly localVariableName?: string;
    /**
    * Defines the source to use to extract the value. Valid values are `http_body`, `http_header`, `local_variable`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#type SyntheticsGlobalVariable#type}
    */
    readonly type: string;
    /**
    * parser block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable#parser SyntheticsGlobalVariable#parser}
    */
    readonly parser?: SyntheticsGlobalVariableParseTestOptionsParser;
}
export declare function syntheticsGlobalVariableParseTestOptionsToTerraform(struct?: SyntheticsGlobalVariableParseTestOptionsOutputReference | SyntheticsGlobalVariableParseTestOptions): any;
export declare class SyntheticsGlobalVariableParseTestOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsGlobalVariableParseTestOptions | undefined;
    set internalValue(value: SyntheticsGlobalVariableParseTestOptions | undefined);
    private _field?;
    get field(): string;
    set field(value: string);
    resetField(): void;
    get fieldInput(): string | undefined;
    private _localVariableName?;
    get localVariableName(): string;
    set localVariableName(value: string);
    resetLocalVariableName(): void;
    get localVariableNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _parser;
    get parser(): SyntheticsGlobalVariableParseTestOptionsParserOutputReference;
    putParser(value: SyntheticsGlobalVariableParseTestOptionsParser): void;
    resetParser(): void;
    get parserInput(): SyntheticsGlobalVariableParseTestOptionsParser | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable datadog_synthetics_global_variable}
*/
export declare class SyntheticsGlobalVariable extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_synthetics_global_variable";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_global_variable datadog_synthetics_global_variable} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SyntheticsGlobalVariableConfig
    */
    constructor(scope: Construct, id: string, config: SyntheticsGlobalVariableConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parseTestId?;
    get parseTestId(): string;
    set parseTestId(value: string);
    resetParseTestId(): void;
    get parseTestIdInput(): string | undefined;
    private _restrictedRoles?;
    get restrictedRoles(): string[];
    set restrictedRoles(value: string[]);
    resetRestrictedRoles(): void;
    get restrictedRolesInput(): string[] | undefined;
    private _secure?;
    get secure(): boolean | cdktf.IResolvable;
    set secure(value: boolean | cdktf.IResolvable);
    resetSecure(): void;
    get secureInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _options;
    get options(): SyntheticsGlobalVariableOptionsOutputReference;
    putOptions(value: SyntheticsGlobalVariableOptions): void;
    resetOptions(): void;
    get optionsInput(): SyntheticsGlobalVariableOptions | undefined;
    private _parseTestOptions;
    get parseTestOptions(): SyntheticsGlobalVariableParseTestOptionsOutputReference;
    putParseTestOptions(value: SyntheticsGlobalVariableParseTestOptions): void;
    resetParseTestOptions(): void;
    get parseTestOptionsInput(): SyntheticsGlobalVariableParseTestOptions | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
