import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SyntheticsPrivateLocationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the private location.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location#description SyntheticsPrivateLocation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location#id SyntheticsPrivateLocation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Synthetics private location name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location#name SyntheticsPrivateLocation#name}
    */
    readonly name: string;
    /**
    * A list of tags to associate with your synthetics private location.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location#tags SyntheticsPrivateLocation#tags}
    */
    readonly tags?: string[];
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location#metadata SyntheticsPrivateLocation#metadata}
    */
    readonly metadata?: SyntheticsPrivateLocationMetadata;
}
export interface SyntheticsPrivateLocationMetadata {
    /**
    * A list of role identifiers pulled from the Roles API to restrict read and write access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location#restricted_roles SyntheticsPrivateLocation#restricted_roles}
    */
    readonly restrictedRoles?: string[];
}
export declare function syntheticsPrivateLocationMetadataToTerraform(struct?: SyntheticsPrivateLocationMetadataOutputReference | SyntheticsPrivateLocationMetadata): any;
export declare class SyntheticsPrivateLocationMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsPrivateLocationMetadata | undefined;
    set internalValue(value: SyntheticsPrivateLocationMetadata | undefined);
    private _restrictedRoles?;
    get restrictedRoles(): string[];
    set restrictedRoles(value: string[]);
    resetRestrictedRoles(): void;
    get restrictedRolesInput(): string[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location datadog_synthetics_private_location}
*/
export declare class SyntheticsPrivateLocation extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_synthetics_private_location";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location datadog_synthetics_private_location} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SyntheticsPrivateLocationConfig
    */
    constructor(scope: Construct, id: string, config: SyntheticsPrivateLocationConfig);
    get config(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _metadata;
    get metadata(): SyntheticsPrivateLocationMetadataOutputReference;
    putMetadata(value: SyntheticsPrivateLocationMetadata): void;
    resetMetadata(): void;
    get metadataInput(): SyntheticsPrivateLocationMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
