import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SyntheticsTestConfig extends cdktf.TerraformMetaArguments {
    /**
    * Required if `type = "browser"`. Array with the different device IDs used to run the test. Valid values are `laptop_large`, `tablet`, `mobile_small`, `chrome.laptop_large`, `chrome.tablet`, `chrome.mobile_small`, `firefox.laptop_large`, `firefox.tablet`, `firefox.mobile_small`, `edge.laptop_large`, `edge.tablet`, `edge.mobile_small`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#device_ids SyntheticsTest#device_ids}
    */
    readonly deviceIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#id SyntheticsTest#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Array of locations used to run the test. Refer to [the Datadog Synthetics location data source](https://registry.terraform.io/providers/DataDog/datadog/latest/docs/data-sources/synthetics_locations) to retrieve the list of locations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#locations SyntheticsTest#locations}
    */
    readonly locations: string[];
    /**
    * A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#message SyntheticsTest#message}
    */
    readonly message?: string;
    /**
    * Name of Datadog synthetics test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
    */
    readonly name: string;
    /**
    * Header name and value map.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_headers SyntheticsTest#request_headers}
    */
    readonly requestHeaders?: {
        [key: string]: string;
    };
    /**
    * Query arguments name and value map.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_query SyntheticsTest#request_query}
    */
    readonly requestQuery?: {
        [key: string]: string;
    };
    /**
    * Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#set_cookie SyntheticsTest#set_cookie}
    */
    readonly setCookie?: string;
    /**
    * Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#status SyntheticsTest#status}
    */
    readonly status: string;
    /**
    * The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#subtype SyntheticsTest#subtype}
    */
    readonly subtype?: string;
    /**
    * A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#tags SyntheticsTest#tags}
    */
    readonly tags?: string[];
    /**
    * Synthetics test type. Valid values are `api`, `browser`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
    */
    readonly type: string;
    /**
    * api_step block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#api_step SyntheticsTest#api_step}
    */
    readonly apiStep?: SyntheticsTestApiStep[] | cdktf.IResolvable;
    /**
    * assertion block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#assertion SyntheticsTest#assertion}
    */
    readonly assertion?: SyntheticsTestAssertion[] | cdktf.IResolvable;
    /**
    * browser_step block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#browser_step SyntheticsTest#browser_step}
    */
    readonly browserStep?: SyntheticsTestBrowserStep[] | cdktf.IResolvable;
    /**
    * browser_variable block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#browser_variable SyntheticsTest#browser_variable}
    */
    readonly browserVariable?: SyntheticsTestBrowserVariable[] | cdktf.IResolvable;
    /**
    * config_variable block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#config_variable SyntheticsTest#config_variable}
    */
    readonly configVariable?: SyntheticsTestConfigVariable[] | cdktf.IResolvable;
    /**
    * options_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#options_list SyntheticsTest#options_list}
    */
    readonly optionsList?: SyntheticsTestOptionsList;
    /**
    * request_basicauth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_basicauth SyntheticsTest#request_basicauth}
    */
    readonly requestBasicauth?: SyntheticsTestRequestBasicauth;
    /**
    * request_client_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_client_certificate SyntheticsTest#request_client_certificate}
    */
    readonly requestClientCertificate?: SyntheticsTestRequestClientCertificate;
    /**
    * request_definition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_definition SyntheticsTest#request_definition}
    */
    readonly requestDefinition?: SyntheticsTestRequestDefinition;
    /**
    * request_proxy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_proxy SyntheticsTest#request_proxy}
    */
    readonly requestProxy?: SyntheticsTestRequestProxy;
}
export interface SyntheticsTestApiStepAssertionTargetjsonpath {
    /**
    * The JSON path to assert.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#jsonpath SyntheticsTest#jsonpath}
    */
    readonly jsonpath: string;
    /**
    * The specific operator to use on the path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#operator SyntheticsTest#operator}
    */
    readonly operator: string;
    /**
    * Expected matching value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#targetvalue SyntheticsTest#targetvalue}
    */
    readonly targetvalue: string;
}
export declare function syntheticsTestApiStepAssertionTargetjsonpathToTerraform(struct?: SyntheticsTestApiStepAssertionTargetjsonpathOutputReference | SyntheticsTestApiStepAssertionTargetjsonpath): any;
export declare class SyntheticsTestApiStepAssertionTargetjsonpathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestApiStepAssertionTargetjsonpath | undefined;
    set internalValue(value: SyntheticsTestApiStepAssertionTargetjsonpath | undefined);
    private _jsonpath?;
    get jsonpath(): string;
    set jsonpath(value: string);
    get jsonpathInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _targetvalue?;
    get targetvalue(): string;
    set targetvalue(value: string);
    get targetvalueInput(): string | undefined;
}
export interface SyntheticsTestApiStepAssertionTargetxpath {
    /**
    * The specific operator to use on the path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#operator SyntheticsTest#operator}
    */
    readonly operator: string;
    /**
    * Expected matching value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#targetvalue SyntheticsTest#targetvalue}
    */
    readonly targetvalue: string;
    /**
    * The xpath to assert.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#xpath SyntheticsTest#xpath}
    */
    readonly xpath: string;
}
export declare function syntheticsTestApiStepAssertionTargetxpathToTerraform(struct?: SyntheticsTestApiStepAssertionTargetxpathOutputReference | SyntheticsTestApiStepAssertionTargetxpath): any;
export declare class SyntheticsTestApiStepAssertionTargetxpathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestApiStepAssertionTargetxpath | undefined;
    set internalValue(value: SyntheticsTestApiStepAssertionTargetxpath | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _targetvalue?;
    get targetvalue(): string;
    set targetvalue(value: string);
    get targetvalueInput(): string | undefined;
    private _xpath?;
    get xpath(): string;
    set xpath(value: string);
    get xpathInput(): string | undefined;
}
export interface SyntheticsTestApiStepAssertion {
    /**
    * Assertion operator. **Note** Only some combinations of `type` and `operator` are valid (please refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#operator SyntheticsTest#operator}
    */
    readonly operator: string;
    /**
    * If assertion type is `header`, this is the header name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#property SyntheticsTest#property}
    */
    readonly property?: string;
    /**
    * Expected value. Depends on the assertion type, refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test) for details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#target SyntheticsTest#target}
    */
    readonly target?: string;
    /**
    * Type of assertion. **Note** Only some combinations of `type` and `operator` are valid (please refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test)). Valid values are `body`, `header`, `statusCode`, `certificate`, `responseTime`, `property`, `recordEvery`, `recordSome`, `tlsVersion`, `minTlsVersion`, `latency`, `packetLossPercentage`, `packetsReceived`, `networkHop`, `receivedMessage`, `grpcHealthcheckStatus`, `connection`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
    */
    readonly type: string;
    /**
    * targetjsonpath block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#targetjsonpath SyntheticsTest#targetjsonpath}
    */
    readonly targetjsonpath?: SyntheticsTestApiStepAssertionTargetjsonpath;
    /**
    * targetxpath block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#targetxpath SyntheticsTest#targetxpath}
    */
    readonly targetxpath?: SyntheticsTestApiStepAssertionTargetxpath;
}
export declare function syntheticsTestApiStepAssertionToTerraform(struct?: SyntheticsTestApiStepAssertion | cdktf.IResolvable): any;
export declare class SyntheticsTestApiStepAssertionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SyntheticsTestApiStepAssertion | cdktf.IResolvable | undefined;
    set internalValue(value: SyntheticsTestApiStepAssertion | cdktf.IResolvable | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _property?;
    get property(): string;
    set property(value: string);
    resetProperty(): void;
    get propertyInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _targetjsonpath;
    get targetjsonpath(): SyntheticsTestApiStepAssertionTargetjsonpathOutputReference;
    putTargetjsonpath(value: SyntheticsTestApiStepAssertionTargetjsonpath): void;
    resetTargetjsonpath(): void;
    get targetjsonpathInput(): SyntheticsTestApiStepAssertionTargetjsonpath | undefined;
    private _targetxpath;
    get targetxpath(): SyntheticsTestApiStepAssertionTargetxpathOutputReference;
    putTargetxpath(value: SyntheticsTestApiStepAssertionTargetxpath): void;
    resetTargetxpath(): void;
    get targetxpathInput(): SyntheticsTestApiStepAssertionTargetxpath | undefined;
}
export declare class SyntheticsTestApiStepAssertionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SyntheticsTestApiStepAssertion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SyntheticsTestApiStepAssertionOutputReference;
}
export interface SyntheticsTestApiStepExtractedValueParser {
    /**
    * Type of parser for a Synthetics global variable from a synthetics test. Valid values are `raw`, `json_path`, `regex`, `x_path`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
    */
    readonly type: string;
    /**
    * Regex or JSON path used for the parser. Not used with type `raw`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#value SyntheticsTest#value}
    */
    readonly value?: string;
}
export declare function syntheticsTestApiStepExtractedValueParserToTerraform(struct?: SyntheticsTestApiStepExtractedValueParserOutputReference | SyntheticsTestApiStepExtractedValueParser): any;
export declare class SyntheticsTestApiStepExtractedValueParserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestApiStepExtractedValueParser | undefined;
    set internalValue(value: SyntheticsTestApiStepExtractedValueParser | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface SyntheticsTestApiStepExtractedValue {
    /**
    * When type is `http_header`, name of the header to use to extract the value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#field SyntheticsTest#field}
    */
    readonly field?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
    */
    readonly name: string;
    /**
    * Property of the Synthetics Test Response to use for the variable. Valid values are `http_body`, `http_header`, `local_variable`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
    */
    readonly type: string;
    /**
    * parser block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#parser SyntheticsTest#parser}
    */
    readonly parser: SyntheticsTestApiStepExtractedValueParser;
}
export declare function syntheticsTestApiStepExtractedValueToTerraform(struct?: SyntheticsTestApiStepExtractedValue | cdktf.IResolvable): any;
export declare class SyntheticsTestApiStepExtractedValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SyntheticsTestApiStepExtractedValue | cdktf.IResolvable | undefined;
    set internalValue(value: SyntheticsTestApiStepExtractedValue | cdktf.IResolvable | undefined);
    private _field?;
    get field(): string;
    set field(value: string);
    resetField(): void;
    get fieldInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _parser;
    get parser(): SyntheticsTestApiStepExtractedValueParserOutputReference;
    putParser(value: SyntheticsTestApiStepExtractedValueParser): void;
    get parserInput(): SyntheticsTestApiStepExtractedValueParser | undefined;
}
export declare class SyntheticsTestApiStepExtractedValueList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SyntheticsTestApiStepExtractedValue[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SyntheticsTestApiStepExtractedValueOutputReference;
}
export interface SyntheticsTestApiStepRequestBasicauth {
    /**
    * Access key for `SIGV4` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#access_key SyntheticsTest#access_key}
    */
    readonly accessKey?: string;
    /**
    * Access token url for `oauth-client` or `oauth-rop` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#access_token_url SyntheticsTest#access_token_url}
    */
    readonly accessTokenUrl?: string;
    /**
    * Audience for `oauth-client` or `oauth-rop` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#audience SyntheticsTest#audience}
    */
    readonly audience?: string;
    /**
    * Client ID for `oauth-client` or `oauth-rop` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#client_id SyntheticsTest#client_id}
    */
    readonly clientId?: string;
    /**
    * Client secret for `oauth-client` or `oauth-rop` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#client_secret SyntheticsTest#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Domain for `ntlm` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#domain SyntheticsTest#domain}
    */
    readonly domain?: string;
    /**
    * Password for authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#password SyntheticsTest#password}
    */
    readonly password?: string;
    /**
    * Region for `SIGV4` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#region SyntheticsTest#region}
    */
    readonly region?: string;
    /**
    * Resource for `oauth-client` or `oauth-rop` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#resource SyntheticsTest#resource}
    */
    readonly resource?: string;
    /**
    * Scope for `oauth-client` or `oauth-rop` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#scope SyntheticsTest#scope}
    */
    readonly scope?: string;
    /**
    * Secret key for `SIGV4` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#secret_key SyntheticsTest#secret_key}
    */
    readonly secretKey?: string;
    /**
    * Service name for `SIGV4` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#service_name SyntheticsTest#service_name}
    */
    readonly serviceName?: string;
    /**
    * Session token for `SIGV4` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#session_token SyntheticsTest#session_token}
    */
    readonly sessionToken?: string;
    /**
    * Token API Authentication for `oauth-client` or `oauth-rop` authentication. Valid values are `header`, `body`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#token_api_authentication SyntheticsTest#token_api_authentication}
    */
    readonly tokenApiAuthentication?: string;
    /**
    * Type of basic authentication to use when performing the test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
    */
    readonly type?: string;
    /**
    * Username for authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#username SyntheticsTest#username}
    */
    readonly username?: string;
    /**
    * Workstation for `ntlm` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#workstation SyntheticsTest#workstation}
    */
    readonly workstation?: string;
}
export declare function syntheticsTestApiStepRequestBasicauthToTerraform(struct?: SyntheticsTestApiStepRequestBasicauthOutputReference | SyntheticsTestApiStepRequestBasicauth): any;
export declare class SyntheticsTestApiStepRequestBasicauthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestApiStepRequestBasicauth | undefined;
    set internalValue(value: SyntheticsTestApiStepRequestBasicauth | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    resetAccessKey(): void;
    get accessKeyInput(): string | undefined;
    private _accessTokenUrl?;
    get accessTokenUrl(): string;
    set accessTokenUrl(value: string);
    resetAccessTokenUrl(): void;
    get accessTokenUrlInput(): string | undefined;
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    resetResource(): void;
    get resourceInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _secretKey?;
    get secretKey(): string;
    set secretKey(value: string);
    resetSecretKey(): void;
    get secretKeyInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _sessionToken?;
    get sessionToken(): string;
    set sessionToken(value: string);
    resetSessionToken(): void;
    get sessionTokenInput(): string | undefined;
    private _tokenApiAuthentication?;
    get tokenApiAuthentication(): string;
    set tokenApiAuthentication(value: string);
    resetTokenApiAuthentication(): void;
    get tokenApiAuthenticationInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _workstation?;
    get workstation(): string;
    set workstation(value: string);
    resetWorkstation(): void;
    get workstationInput(): string | undefined;
}
export interface SyntheticsTestApiStepRequestClientCertificateCert {
    /**
    * Content of the certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#content SyntheticsTest#content}
    */
    readonly content: string;
    /**
    * File name for the certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#filename SyntheticsTest#filename}
    */
    readonly filename?: string;
}
export declare function syntheticsTestApiStepRequestClientCertificateCertToTerraform(struct?: SyntheticsTestApiStepRequestClientCertificateCertOutputReference | SyntheticsTestApiStepRequestClientCertificateCert): any;
export declare class SyntheticsTestApiStepRequestClientCertificateCertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestApiStepRequestClientCertificateCert | undefined;
    set internalValue(value: SyntheticsTestApiStepRequestClientCertificateCert | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    resetFilename(): void;
    get filenameInput(): string | undefined;
}
export interface SyntheticsTestApiStepRequestClientCertificateKey {
    /**
    * Content of the certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#content SyntheticsTest#content}
    */
    readonly content: string;
    /**
    * File name for the certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#filename SyntheticsTest#filename}
    */
    readonly filename?: string;
}
export declare function syntheticsTestApiStepRequestClientCertificateKeyToTerraform(struct?: SyntheticsTestApiStepRequestClientCertificateKeyOutputReference | SyntheticsTestApiStepRequestClientCertificateKey): any;
export declare class SyntheticsTestApiStepRequestClientCertificateKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestApiStepRequestClientCertificateKey | undefined;
    set internalValue(value: SyntheticsTestApiStepRequestClientCertificateKey | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    resetFilename(): void;
    get filenameInput(): string | undefined;
}
export interface SyntheticsTestApiStepRequestClientCertificate {
    /**
    * cert block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#cert SyntheticsTest#cert}
    */
    readonly cert: SyntheticsTestApiStepRequestClientCertificateCert;
    /**
    * key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#key SyntheticsTest#key}
    */
    readonly key: SyntheticsTestApiStepRequestClientCertificateKey;
}
export declare function syntheticsTestApiStepRequestClientCertificateToTerraform(struct?: SyntheticsTestApiStepRequestClientCertificateOutputReference | SyntheticsTestApiStepRequestClientCertificate): any;
export declare class SyntheticsTestApiStepRequestClientCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestApiStepRequestClientCertificate | undefined;
    set internalValue(value: SyntheticsTestApiStepRequestClientCertificate | undefined);
    private _cert;
    get cert(): SyntheticsTestApiStepRequestClientCertificateCertOutputReference;
    putCert(value: SyntheticsTestApiStepRequestClientCertificateCert): void;
    get certInput(): SyntheticsTestApiStepRequestClientCertificateCert | undefined;
    private _key;
    get key(): SyntheticsTestApiStepRequestClientCertificateKeyOutputReference;
    putKey(value: SyntheticsTestApiStepRequestClientCertificateKey): void;
    get keyInput(): SyntheticsTestApiStepRequestClientCertificateKey | undefined;
}
export interface SyntheticsTestApiStepRequestDefinition {
    /**
    * Allows loading insecure content for an HTTP test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#allow_insecure SyntheticsTest#allow_insecure}
    */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
    * The request body.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#body SyntheticsTest#body}
    */
    readonly body?: string;
    /**
    * Type of the request body. Valid values are `text/plain`, `application/json`, `text/xml`, `text/html`, `application/x-www-form-urlencoded`, `graphql`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#body_type SyntheticsTest#body_type}
    */
    readonly bodyType?: string;
    /**
    * The type of gRPC call to perform. Valid values are `healthcheck`, `unary`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#call_type SyntheticsTest#call_type}
    */
    readonly callType?: string;
    /**
    * By default, the client certificate is applied on the domain of the starting URL for browser tests. If you want your client certificate to be applied on other domains instead, add them in `certificate_domains`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#certificate_domains SyntheticsTest#certificate_domains}
    */
    readonly certificateDomains?: string[];
    /**
    * DNS server to use for DNS tests (`subtype = "dns"`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#dns_server SyntheticsTest#dns_server}
    */
    readonly dnsServer?: string;
    /**
    * DNS server port to use for DNS tests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#dns_server_port SyntheticsTest#dns_server_port}
    */
    readonly dnsServerPort?: number;
    /**
    * Determines whether or not the API HTTP test should follow redirects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#follow_redirects SyntheticsTest#follow_redirects}
    */
    readonly followRedirects?: boolean | cdktf.IResolvable;
    /**
    * Host name to perform the test with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#host SyntheticsTest#host}
    */
    readonly host?: string;
    /**
    * For UDP and websocket tests, message to send with the request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#message SyntheticsTest#message}
    */
    readonly message?: string;
    /**
    * Either the HTTP method/verb to use or a gRPC method available on the service set in the `service` field. Required if `subtype` is `HTTP` or if `subtype` is `grpc` and `callType` is `unary`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#method SyntheticsTest#method}
    */
    readonly method?: string;
    /**
    * Determines whether or not to save the response body.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#no_saving_response_body SyntheticsTest#no_saving_response_body}
    */
    readonly noSavingResponseBody?: boolean | cdktf.IResolvable;
    /**
    * Number of pings to use per test for ICMP tests (`subtype = "icmp"`) between 0 and 10.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#number_of_packets SyntheticsTest#number_of_packets}
    */
    readonly numberOfPackets?: number;
    /**
    * Port to use when performing the test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#port SyntheticsTest#port}
    */
    readonly port?: number;
    /**
    * For SSL tests, it specifies on which server you want to initiate the TLS handshake, allowing the server to present one of multiple possible certificates on the same IP address and TCP port number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#servername SyntheticsTest#servername}
    */
    readonly servername?: string;
    /**
    * The gRPC service on which you want to perform the gRPC call.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#service SyntheticsTest#service}
    */
    readonly service?: string;
    /**
    * This will turn on a traceroute probe to discover all gateways along the path to the host destination. For ICMP tests (`subtype = "icmp"`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#should_track_hops SyntheticsTest#should_track_hops}
    */
    readonly shouldTrackHops?: boolean | cdktf.IResolvable;
    /**
    * Timeout in seconds for the test. Defaults to `60`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#timeout SyntheticsTest#timeout}
    */
    readonly timeout?: number;
    /**
    * The URL to send the request to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#url SyntheticsTest#url}
    */
    readonly url?: string;
}
export declare function syntheticsTestApiStepRequestDefinitionToTerraform(struct?: SyntheticsTestApiStepRequestDefinitionOutputReference | SyntheticsTestApiStepRequestDefinition): any;
export declare class SyntheticsTestApiStepRequestDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestApiStepRequestDefinition | undefined;
    set internalValue(value: SyntheticsTestApiStepRequestDefinition | undefined);
    private _allowInsecure?;
    get allowInsecure(): boolean | cdktf.IResolvable;
    set allowInsecure(value: boolean | cdktf.IResolvable);
    resetAllowInsecure(): void;
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _body?;
    get body(): string;
    set body(value: string);
    resetBody(): void;
    get bodyInput(): string | undefined;
    private _bodyType?;
    get bodyType(): string;
    set bodyType(value: string);
    resetBodyType(): void;
    get bodyTypeInput(): string | undefined;
    private _callType?;
    get callType(): string;
    set callType(value: string);
    resetCallType(): void;
    get callTypeInput(): string | undefined;
    private _certificateDomains?;
    get certificateDomains(): string[];
    set certificateDomains(value: string[]);
    resetCertificateDomains(): void;
    get certificateDomainsInput(): string[] | undefined;
    private _dnsServer?;
    get dnsServer(): string;
    set dnsServer(value: string);
    resetDnsServer(): void;
    get dnsServerInput(): string | undefined;
    private _dnsServerPort?;
    get dnsServerPort(): number;
    set dnsServerPort(value: number);
    resetDnsServerPort(): void;
    get dnsServerPortInput(): number | undefined;
    private _followRedirects?;
    get followRedirects(): boolean | cdktf.IResolvable;
    set followRedirects(value: boolean | cdktf.IResolvable);
    resetFollowRedirects(): void;
    get followRedirectsInput(): boolean | cdktf.IResolvable | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _message?;
    get message(): string;
    set message(value: string);
    resetMessage(): void;
    get messageInput(): string | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _noSavingResponseBody?;
    get noSavingResponseBody(): boolean | cdktf.IResolvable;
    set noSavingResponseBody(value: boolean | cdktf.IResolvable);
    resetNoSavingResponseBody(): void;
    get noSavingResponseBodyInput(): boolean | cdktf.IResolvable | undefined;
    private _numberOfPackets?;
    get numberOfPackets(): number;
    set numberOfPackets(value: number);
    resetNumberOfPackets(): void;
    get numberOfPacketsInput(): number | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _servername?;
    get servername(): string;
    set servername(value: string);
    resetServername(): void;
    get servernameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _shouldTrackHops?;
    get shouldTrackHops(): boolean | cdktf.IResolvable;
    set shouldTrackHops(value: boolean | cdktf.IResolvable);
    resetShouldTrackHops(): void;
    get shouldTrackHopsInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
}
export interface SyntheticsTestApiStepRequestProxy {
    /**
    * Header name and value map.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#headers SyntheticsTest#headers}
    */
    readonly headers?: {
        [key: string]: string;
    };
    /**
    * URL of the proxy to perform the test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#url SyntheticsTest#url}
    */
    readonly url: string;
}
export declare function syntheticsTestApiStepRequestProxyToTerraform(struct?: SyntheticsTestApiStepRequestProxyOutputReference | SyntheticsTestApiStepRequestProxy): any;
export declare class SyntheticsTestApiStepRequestProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestApiStepRequestProxy | undefined;
    set internalValue(value: SyntheticsTestApiStepRequestProxy | undefined);
    private _headers?;
    get headers(): {
        [key: string]: string;
    };
    set headers(value: {
        [key: string]: string;
    });
    resetHeaders(): void;
    get headersInput(): {
        [key: string]: string;
    } | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface SyntheticsTestApiStepRetry {
    /**
    * Number of retries needed to consider a location as failed before sending a notification alert.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#count SyntheticsTest#count}
    */
    readonly count?: number;
    /**
    * Interval between a failed test and the next retry in milliseconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#interval SyntheticsTest#interval}
    */
    readonly interval?: number;
}
export declare function syntheticsTestApiStepRetryToTerraform(struct?: SyntheticsTestApiStepRetryOutputReference | SyntheticsTestApiStepRetry): any;
export declare class SyntheticsTestApiStepRetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestApiStepRetry | undefined;
    set internalValue(value: SyntheticsTestApiStepRetry | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface SyntheticsTestApiStep {
    /**
    * Determines whether or not to continue with test if this step fails.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#allow_failure SyntheticsTest#allow_failure}
    */
    readonly allowFailure?: boolean | cdktf.IResolvable;
    /**
    * Determines whether or not to consider the entire test as failed if this step fails. Can be used only if `allow_failure` is `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#is_critical SyntheticsTest#is_critical}
    */
    readonly isCritical?: boolean | cdktf.IResolvable;
    /**
    * The name of the step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
    */
    readonly name: string;
    /**
    * Header name and value map.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_headers SyntheticsTest#request_headers}
    */
    readonly requestHeaders?: {
        [key: string]: string;
    };
    /**
    * Query arguments name and value map.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_query SyntheticsTest#request_query}
    */
    readonly requestQuery?: {
        [key: string]: string;
    };
    /**
    * The subtype of the Synthetic multistep API test step. Valid values are `http`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#subtype SyntheticsTest#subtype}
    */
    readonly subtype?: string;
    /**
    * assertion block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#assertion SyntheticsTest#assertion}
    */
    readonly assertion?: SyntheticsTestApiStepAssertion[] | cdktf.IResolvable;
    /**
    * extracted_value block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#extracted_value SyntheticsTest#extracted_value}
    */
    readonly extractedValue?: SyntheticsTestApiStepExtractedValue[] | cdktf.IResolvable;
    /**
    * request_basicauth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_basicauth SyntheticsTest#request_basicauth}
    */
    readonly requestBasicauth?: SyntheticsTestApiStepRequestBasicauth;
    /**
    * request_client_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_client_certificate SyntheticsTest#request_client_certificate}
    */
    readonly requestClientCertificate?: SyntheticsTestApiStepRequestClientCertificate;
    /**
    * request_definition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_definition SyntheticsTest#request_definition}
    */
    readonly requestDefinition?: SyntheticsTestApiStepRequestDefinition;
    /**
    * request_proxy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request_proxy SyntheticsTest#request_proxy}
    */
    readonly requestProxy?: SyntheticsTestApiStepRequestProxy;
    /**
    * retry block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#retry SyntheticsTest#retry}
    */
    readonly retry?: SyntheticsTestApiStepRetry;
}
export declare function syntheticsTestApiStepToTerraform(struct?: SyntheticsTestApiStep | cdktf.IResolvable): any;
export declare class SyntheticsTestApiStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SyntheticsTestApiStep | cdktf.IResolvable | undefined;
    set internalValue(value: SyntheticsTestApiStep | cdktf.IResolvable | undefined);
    private _allowFailure?;
    get allowFailure(): boolean | cdktf.IResolvable;
    set allowFailure(value: boolean | cdktf.IResolvable);
    resetAllowFailure(): void;
    get allowFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _isCritical?;
    get isCritical(): boolean | cdktf.IResolvable;
    set isCritical(value: boolean | cdktf.IResolvable);
    resetIsCritical(): void;
    get isCriticalInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _requestHeaders?;
    get requestHeaders(): {
        [key: string]: string;
    };
    set requestHeaders(value: {
        [key: string]: string;
    });
    resetRequestHeaders(): void;
    get requestHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _requestQuery?;
    get requestQuery(): {
        [key: string]: string;
    };
    set requestQuery(value: {
        [key: string]: string;
    });
    resetRequestQuery(): void;
    get requestQueryInput(): {
        [key: string]: string;
    } | undefined;
    private _subtype?;
    get subtype(): string;
    set subtype(value: string);
    resetSubtype(): void;
    get subtypeInput(): string | undefined;
    private _assertion;
    get assertion(): SyntheticsTestApiStepAssertionList;
    putAssertion(value: SyntheticsTestApiStepAssertion[] | cdktf.IResolvable): void;
    resetAssertion(): void;
    get assertionInput(): cdktf.IResolvable | SyntheticsTestApiStepAssertion[] | undefined;
    private _extractedValue;
    get extractedValue(): SyntheticsTestApiStepExtractedValueList;
    putExtractedValue(value: SyntheticsTestApiStepExtractedValue[] | cdktf.IResolvable): void;
    resetExtractedValue(): void;
    get extractedValueInput(): cdktf.IResolvable | SyntheticsTestApiStepExtractedValue[] | undefined;
    private _requestBasicauth;
    get requestBasicauth(): SyntheticsTestApiStepRequestBasicauthOutputReference;
    putRequestBasicauth(value: SyntheticsTestApiStepRequestBasicauth): void;
    resetRequestBasicauth(): void;
    get requestBasicauthInput(): SyntheticsTestApiStepRequestBasicauth | undefined;
    private _requestClientCertificate;
    get requestClientCertificate(): SyntheticsTestApiStepRequestClientCertificateOutputReference;
    putRequestClientCertificate(value: SyntheticsTestApiStepRequestClientCertificate): void;
    resetRequestClientCertificate(): void;
    get requestClientCertificateInput(): SyntheticsTestApiStepRequestClientCertificate | undefined;
    private _requestDefinition;
    get requestDefinition(): SyntheticsTestApiStepRequestDefinitionOutputReference;
    putRequestDefinition(value: SyntheticsTestApiStepRequestDefinition): void;
    resetRequestDefinition(): void;
    get requestDefinitionInput(): SyntheticsTestApiStepRequestDefinition | undefined;
    private _requestProxy;
    get requestProxy(): SyntheticsTestApiStepRequestProxyOutputReference;
    putRequestProxy(value: SyntheticsTestApiStepRequestProxy): void;
    resetRequestProxy(): void;
    get requestProxyInput(): SyntheticsTestApiStepRequestProxy | undefined;
    private _retry;
    get retry(): SyntheticsTestApiStepRetryOutputReference;
    putRetry(value: SyntheticsTestApiStepRetry): void;
    resetRetry(): void;
    get retryInput(): SyntheticsTestApiStepRetry | undefined;
}
export declare class SyntheticsTestApiStepList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SyntheticsTestApiStep[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SyntheticsTestApiStepOutputReference;
}
export interface SyntheticsTestAssertionTargetjsonpath {
    /**
    * The JSON path to assert.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#jsonpath SyntheticsTest#jsonpath}
    */
    readonly jsonpath: string;
    /**
    * The specific operator to use on the path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#operator SyntheticsTest#operator}
    */
    readonly operator: string;
    /**
    * Expected matching value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#targetvalue SyntheticsTest#targetvalue}
    */
    readonly targetvalue: string;
}
export declare function syntheticsTestAssertionTargetjsonpathToTerraform(struct?: SyntheticsTestAssertionTargetjsonpathOutputReference | SyntheticsTestAssertionTargetjsonpath): any;
export declare class SyntheticsTestAssertionTargetjsonpathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestAssertionTargetjsonpath | undefined;
    set internalValue(value: SyntheticsTestAssertionTargetjsonpath | undefined);
    private _jsonpath?;
    get jsonpath(): string;
    set jsonpath(value: string);
    get jsonpathInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _targetvalue?;
    get targetvalue(): string;
    set targetvalue(value: string);
    get targetvalueInput(): string | undefined;
}
export interface SyntheticsTestAssertionTargetxpath {
    /**
    * The specific operator to use on the path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#operator SyntheticsTest#operator}
    */
    readonly operator: string;
    /**
    * Expected matching value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#targetvalue SyntheticsTest#targetvalue}
    */
    readonly targetvalue: string;
    /**
    * The xpath to assert.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#xpath SyntheticsTest#xpath}
    */
    readonly xpath: string;
}
export declare function syntheticsTestAssertionTargetxpathToTerraform(struct?: SyntheticsTestAssertionTargetxpathOutputReference | SyntheticsTestAssertionTargetxpath): any;
export declare class SyntheticsTestAssertionTargetxpathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestAssertionTargetxpath | undefined;
    set internalValue(value: SyntheticsTestAssertionTargetxpath | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _targetvalue?;
    get targetvalue(): string;
    set targetvalue(value: string);
    get targetvalueInput(): string | undefined;
    private _xpath?;
    get xpath(): string;
    set xpath(value: string);
    get xpathInput(): string | undefined;
}
export interface SyntheticsTestAssertion {
    /**
    * Assertion operator. **Note** Only some combinations of `type` and `operator` are valid (please refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#operator SyntheticsTest#operator}
    */
    readonly operator: string;
    /**
    * If assertion type is `header`, this is the header name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#property SyntheticsTest#property}
    */
    readonly property?: string;
    /**
    * Expected value. Depends on the assertion type, refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test) for details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#target SyntheticsTest#target}
    */
    readonly target?: string;
    /**
    * Type of assertion. **Note** Only some combinations of `type` and `operator` are valid (please refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test)). Valid values are `body`, `header`, `statusCode`, `certificate`, `responseTime`, `property`, `recordEvery`, `recordSome`, `tlsVersion`, `minTlsVersion`, `latency`, `packetLossPercentage`, `packetsReceived`, `networkHop`, `receivedMessage`, `grpcHealthcheckStatus`, `connection`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
    */
    readonly type: string;
    /**
    * targetjsonpath block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#targetjsonpath SyntheticsTest#targetjsonpath}
    */
    readonly targetjsonpath?: SyntheticsTestAssertionTargetjsonpath;
    /**
    * targetxpath block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#targetxpath SyntheticsTest#targetxpath}
    */
    readonly targetxpath?: SyntheticsTestAssertionTargetxpath;
}
export declare function syntheticsTestAssertionToTerraform(struct?: SyntheticsTestAssertion | cdktf.IResolvable): any;
export declare class SyntheticsTestAssertionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SyntheticsTestAssertion | cdktf.IResolvable | undefined;
    set internalValue(value: SyntheticsTestAssertion | cdktf.IResolvable | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _property?;
    get property(): string;
    set property(value: string);
    resetProperty(): void;
    get propertyInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _targetjsonpath;
    get targetjsonpath(): SyntheticsTestAssertionTargetjsonpathOutputReference;
    putTargetjsonpath(value: SyntheticsTestAssertionTargetjsonpath): void;
    resetTargetjsonpath(): void;
    get targetjsonpathInput(): SyntheticsTestAssertionTargetjsonpath | undefined;
    private _targetxpath;
    get targetxpath(): SyntheticsTestAssertionTargetxpathOutputReference;
    putTargetxpath(value: SyntheticsTestAssertionTargetxpath): void;
    resetTargetxpath(): void;
    get targetxpathInput(): SyntheticsTestAssertionTargetxpath | undefined;
}
export declare class SyntheticsTestAssertionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SyntheticsTestAssertion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SyntheticsTestAssertionOutputReference;
}
export interface SyntheticsTestBrowserStepParamsElementUserLocatorValue {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#value SyntheticsTest#value}
    */
    readonly value: string;
}
export declare function syntheticsTestBrowserStepParamsElementUserLocatorValueToTerraform(struct?: SyntheticsTestBrowserStepParamsElementUserLocatorValueOutputReference | SyntheticsTestBrowserStepParamsElementUserLocatorValue): any;
export declare class SyntheticsTestBrowserStepParamsElementUserLocatorValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestBrowserStepParamsElementUserLocatorValue | undefined;
    set internalValue(value: SyntheticsTestBrowserStepParamsElementUserLocatorValue | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface SyntheticsTestBrowserStepParamsElementUserLocator {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#fail_test_on_cannot_locate SyntheticsTest#fail_test_on_cannot_locate}
    */
    readonly failTestOnCannotLocate?: boolean | cdktf.IResolvable;
    /**
    * value block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#value SyntheticsTest#value}
    */
    readonly value: SyntheticsTestBrowserStepParamsElementUserLocatorValue;
}
export declare function syntheticsTestBrowserStepParamsElementUserLocatorToTerraform(struct?: SyntheticsTestBrowserStepParamsElementUserLocatorOutputReference | SyntheticsTestBrowserStepParamsElementUserLocator): any;
export declare class SyntheticsTestBrowserStepParamsElementUserLocatorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestBrowserStepParamsElementUserLocator | undefined;
    set internalValue(value: SyntheticsTestBrowserStepParamsElementUserLocator | undefined);
    private _failTestOnCannotLocate?;
    get failTestOnCannotLocate(): boolean | cdktf.IResolvable;
    set failTestOnCannotLocate(value: boolean | cdktf.IResolvable);
    resetFailTestOnCannotLocate(): void;
    get failTestOnCannotLocateInput(): boolean | cdktf.IResolvable | undefined;
    private _value;
    get value(): SyntheticsTestBrowserStepParamsElementUserLocatorValueOutputReference;
    putValue(value: SyntheticsTestBrowserStepParamsElementUserLocatorValue): void;
    get valueInput(): SyntheticsTestBrowserStepParamsElementUserLocatorValue | undefined;
}
export interface SyntheticsTestBrowserStepParamsVariable {
    /**
    * Example of the extracted variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#example SyntheticsTest#example}
    */
    readonly example?: string;
    /**
    * Name of the extracted variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
    */
    readonly name?: string;
}
export declare function syntheticsTestBrowserStepParamsVariableToTerraform(struct?: SyntheticsTestBrowserStepParamsVariableOutputReference | SyntheticsTestBrowserStepParamsVariable): any;
export declare class SyntheticsTestBrowserStepParamsVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestBrowserStepParamsVariable | undefined;
    set internalValue(value: SyntheticsTestBrowserStepParamsVariable | undefined);
    private _example?;
    get example(): string;
    set example(value: string);
    resetExample(): void;
    get exampleInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface SyntheticsTestBrowserStepParams {
    /**
    * Name of the attribute to use for an "assert attribute" step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#attribute SyntheticsTest#attribute}
    */
    readonly attribute?: string;
    /**
    * Check type to use for an assertion step. Valid values are `equals`, `notEquals`, `contains`, `notContains`, `startsWith`, `notStartsWith`, `greater`, `lower`, `greaterEquals`, `lowerEquals`, `matchRegex`, `between`, `isEmpty`, `notIsEmpty`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#check SyntheticsTest#check}
    */
    readonly check?: string;
    /**
    * Type of click to use for a "click" step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#click_type SyntheticsTest#click_type}
    */
    readonly clickType?: string;
    /**
    * Javascript code to use for the step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#code SyntheticsTest#code}
    */
    readonly code?: string;
    /**
    * Delay between each key stroke for a "type test" step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#delay SyntheticsTest#delay}
    */
    readonly delay?: number;
    /**
    * Element to use for the step, json encoded string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#element SyntheticsTest#element}
    */
    readonly element?: string;
    /**
    * Details of the email for an "assert email" step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#email SyntheticsTest#email}
    */
    readonly email?: string;
    /**
    * For an "assert download" step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#file SyntheticsTest#file}
    */
    readonly file?: string;
    /**
    * Details of the files for an "upload files" step, json encoded string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#files SyntheticsTest#files}
    */
    readonly files?: string;
    /**
    * Modifier to use for a "press key" step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#modifiers SyntheticsTest#modifiers}
    */
    readonly modifiers?: string[];
    /**
    * ID of the tab to play the subtest.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#playing_tab_id SyntheticsTest#playing_tab_id}
    */
    readonly playingTabId?: string;
    /**
    * Request for an API step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#request SyntheticsTest#request}
    */
    readonly request?: string;
    /**
    * ID of the Synthetics test to use as subtest.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#subtest_public_id SyntheticsTest#subtest_public_id}
    */
    readonly subtestPublicId?: string;
    /**
    * Value of the step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#value SyntheticsTest#value}
    */
    readonly value?: string;
    /**
    * For "file upload" steps.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#with_click SyntheticsTest#with_click}
    */
    readonly withClick?: boolean | cdktf.IResolvable;
    /**
    * X coordinates for a "scroll step".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#x SyntheticsTest#x}
    */
    readonly x?: number;
    /**
    * Y coordinates for a "scroll step".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#y SyntheticsTest#y}
    */
    readonly y?: number;
    /**
    * element_user_locator block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#element_user_locator SyntheticsTest#element_user_locator}
    */
    readonly elementUserLocator?: SyntheticsTestBrowserStepParamsElementUserLocator;
    /**
    * variable block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#variable SyntheticsTest#variable}
    */
    readonly variable?: SyntheticsTestBrowserStepParamsVariable;
}
export declare function syntheticsTestBrowserStepParamsToTerraform(struct?: SyntheticsTestBrowserStepParamsOutputReference | SyntheticsTestBrowserStepParams): any;
export declare class SyntheticsTestBrowserStepParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestBrowserStepParams | undefined;
    set internalValue(value: SyntheticsTestBrowserStepParams | undefined);
    private _attribute?;
    get attribute(): string;
    set attribute(value: string);
    resetAttribute(): void;
    get attributeInput(): string | undefined;
    private _check?;
    get check(): string;
    set check(value: string);
    resetCheck(): void;
    get checkInput(): string | undefined;
    private _clickType?;
    get clickType(): string;
    set clickType(value: string);
    resetClickType(): void;
    get clickTypeInput(): string | undefined;
    private _code?;
    get code(): string;
    set code(value: string);
    resetCode(): void;
    get codeInput(): string | undefined;
    private _delay?;
    get delay(): number;
    set delay(value: number);
    resetDelay(): void;
    get delayInput(): number | undefined;
    private _element?;
    get element(): string;
    set element(value: string);
    resetElement(): void;
    get elementInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _file?;
    get file(): string;
    set file(value: string);
    resetFile(): void;
    get fileInput(): string | undefined;
    private _files?;
    get files(): string;
    set files(value: string);
    resetFiles(): void;
    get filesInput(): string | undefined;
    private _modifiers?;
    get modifiers(): string[];
    set modifiers(value: string[]);
    resetModifiers(): void;
    get modifiersInput(): string[] | undefined;
    private _playingTabId?;
    get playingTabId(): string;
    set playingTabId(value: string);
    resetPlayingTabId(): void;
    get playingTabIdInput(): string | undefined;
    private _request?;
    get request(): string;
    set request(value: string);
    resetRequest(): void;
    get requestInput(): string | undefined;
    private _subtestPublicId?;
    get subtestPublicId(): string;
    set subtestPublicId(value: string);
    resetSubtestPublicId(): void;
    get subtestPublicIdInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _withClick?;
    get withClick(): boolean | cdktf.IResolvable;
    set withClick(value: boolean | cdktf.IResolvable);
    resetWithClick(): void;
    get withClickInput(): boolean | cdktf.IResolvable | undefined;
    private _x?;
    get x(): number;
    set x(value: number);
    resetX(): void;
    get xInput(): number | undefined;
    private _y?;
    get y(): number;
    set y(value: number);
    resetY(): void;
    get yInput(): number | undefined;
    private _elementUserLocator;
    get elementUserLocator(): SyntheticsTestBrowserStepParamsElementUserLocatorOutputReference;
    putElementUserLocator(value: SyntheticsTestBrowserStepParamsElementUserLocator): void;
    resetElementUserLocator(): void;
    get elementUserLocatorInput(): SyntheticsTestBrowserStepParamsElementUserLocator | undefined;
    private _variable;
    get variable(): SyntheticsTestBrowserStepParamsVariableOutputReference;
    putVariable(value: SyntheticsTestBrowserStepParamsVariable): void;
    resetVariable(): void;
    get variableInput(): SyntheticsTestBrowserStepParamsVariable | undefined;
}
export interface SyntheticsTestBrowserStep {
    /**
    * Determines if the step should be allowed to fail.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#allow_failure SyntheticsTest#allow_failure}
    */
    readonly allowFailure?: boolean | cdktf.IResolvable;
    /**
    * Force update of the "element" parameter for the step
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#force_element_update SyntheticsTest#force_element_update}
    */
    readonly forceElementUpdate?: boolean | cdktf.IResolvable;
    /**
    * Determines whether or not to consider the entire test as failed if this step fails. Can be used only if `allow_failure` is `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#is_critical SyntheticsTest#is_critical}
    */
    readonly isCritical?: boolean | cdktf.IResolvable;
    /**
    * Name of the step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
    */
    readonly name: string;
    /**
    * Used to override the default timeout of a step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#timeout SyntheticsTest#timeout}
    */
    readonly timeout?: number;
    /**
    * Type of the step. Valid values are `assertCurrentUrl`, `assertElementAttribute`, `assertElementContent`, `assertElementPresent`, `assertEmail`, `assertFileDownload`, `assertFromJavascript`, `assertPageContains`, `assertPageLacks`, `click`, `extractFromJavascript`, `extractVariable`, `goToEmailLink`, `goToUrl`, `goToUrlAndMeasureTti`, `hover`, `playSubTest`, `pressKey`, `refresh`, `runApiTest`, `scroll`, `selectOption`, `typeText`, `uploadFiles`, `wait`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
    */
    readonly type: string;
    /**
    * params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#params SyntheticsTest#params}
    */
    readonly params: SyntheticsTestBrowserStepParams;
}
export declare function syntheticsTestBrowserStepToTerraform(struct?: SyntheticsTestBrowserStep | cdktf.IResolvable): any;
export declare class SyntheticsTestBrowserStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SyntheticsTestBrowserStep | cdktf.IResolvable | undefined;
    set internalValue(value: SyntheticsTestBrowserStep | cdktf.IResolvable | undefined);
    private _allowFailure?;
    get allowFailure(): boolean | cdktf.IResolvable;
    set allowFailure(value: boolean | cdktf.IResolvable);
    resetAllowFailure(): void;
    get allowFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _forceElementUpdate?;
    get forceElementUpdate(): boolean | cdktf.IResolvable;
    set forceElementUpdate(value: boolean | cdktf.IResolvable);
    resetForceElementUpdate(): void;
    get forceElementUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _isCritical?;
    get isCritical(): boolean | cdktf.IResolvable;
    set isCritical(value: boolean | cdktf.IResolvable);
    resetIsCritical(): void;
    get isCriticalInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _params;
    get params(): SyntheticsTestBrowserStepParamsOutputReference;
    putParams(value: SyntheticsTestBrowserStepParams): void;
    get paramsInput(): SyntheticsTestBrowserStepParams | undefined;
}
export declare class SyntheticsTestBrowserStepList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SyntheticsTestBrowserStep[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SyntheticsTestBrowserStepOutputReference;
}
export interface SyntheticsTestBrowserVariable {
    /**
    * Example for the variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#example SyntheticsTest#example}
    */
    readonly example?: string;
    /**
    * ID of the global variable to use. This is actually only used (and required) in the case of using a variable of type `global`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#id SyntheticsTest#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
    */
    readonly name: string;
    /**
    * Pattern of the variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#pattern SyntheticsTest#pattern}
    */
    readonly pattern?: string;
    /**
    * Type of browser test variable. Valid values are `element`, `email`, `global`, `javascript`, `text`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
    */
    readonly type: string;
}
export declare function syntheticsTestBrowserVariableToTerraform(struct?: SyntheticsTestBrowserVariable | cdktf.IResolvable): any;
export declare class SyntheticsTestBrowserVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SyntheticsTestBrowserVariable | cdktf.IResolvable | undefined;
    set internalValue(value: SyntheticsTestBrowserVariable | cdktf.IResolvable | undefined);
    private _example?;
    get example(): string;
    set example(value: string);
    resetExample(): void;
    get exampleInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    resetPattern(): void;
    get patternInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class SyntheticsTestBrowserVariableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SyntheticsTestBrowserVariable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SyntheticsTestBrowserVariableOutputReference;
}
export interface SyntheticsTestConfigVariable {
    /**
    * Example for the variable. This value is not returned by the api when `secure = true`. Avoid drift by only making updates to this value from within Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#example SyntheticsTest#example}
    */
    readonly example?: string;
    /**
    * When type = `global`, ID of the global variable to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#id SyntheticsTest#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#name SyntheticsTest#name}
    */
    readonly name: string;
    /**
    * Pattern of the variable. This value is not returned by the api when `secure = true`. Avoid drift by only making updates to this value from within Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#pattern SyntheticsTest#pattern}
    */
    readonly pattern?: string;
    /**
    * Whether the value of this variable will be obfuscated in test results.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#secure SyntheticsTest#secure}
    */
    readonly secure?: boolean | cdktf.IResolvable;
    /**
    * Type of test configuration variable. Valid values are `global`, `text`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
    */
    readonly type: string;
}
export declare function syntheticsTestConfigVariableToTerraform(struct?: SyntheticsTestConfigVariable | cdktf.IResolvable): any;
export declare class SyntheticsTestConfigVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SyntheticsTestConfigVariable | cdktf.IResolvable | undefined;
    set internalValue(value: SyntheticsTestConfigVariable | cdktf.IResolvable | undefined);
    private _example?;
    get example(): string;
    set example(value: string);
    resetExample(): void;
    get exampleInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    resetPattern(): void;
    get patternInput(): string | undefined;
    private _secure?;
    get secure(): boolean | cdktf.IResolvable;
    set secure(value: boolean | cdktf.IResolvable);
    resetSecure(): void;
    get secureInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class SyntheticsTestConfigVariableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SyntheticsTestConfigVariable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SyntheticsTestConfigVariableOutputReference;
}
export interface SyntheticsTestOptionsListCi {
    /**
    * Execution rule for a Synthetics test. Valid values are `blocking`, `non_blocking`, `skipped`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#execution_rule SyntheticsTest#execution_rule}
    */
    readonly executionRule?: string;
}
export declare function syntheticsTestOptionsListCiToTerraform(struct?: SyntheticsTestOptionsListCiOutputReference | SyntheticsTestOptionsListCi): any;
export declare class SyntheticsTestOptionsListCiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestOptionsListCi | undefined;
    set internalValue(value: SyntheticsTestOptionsListCi | undefined);
    private _executionRule?;
    get executionRule(): string;
    set executionRule(value: string);
    resetExecutionRule(): void;
    get executionRuleInput(): string | undefined;
}
export interface SyntheticsTestOptionsListMonitorOptions {
    /**
    * Specify a renotification frequency.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#renotify_interval SyntheticsTest#renotify_interval}
    */
    readonly renotifyInterval?: number;
}
export declare function syntheticsTestOptionsListMonitorOptionsToTerraform(struct?: SyntheticsTestOptionsListMonitorOptionsOutputReference | SyntheticsTestOptionsListMonitorOptions): any;
export declare class SyntheticsTestOptionsListMonitorOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestOptionsListMonitorOptions | undefined;
    set internalValue(value: SyntheticsTestOptionsListMonitorOptions | undefined);
    private _renotifyInterval?;
    get renotifyInterval(): number;
    set renotifyInterval(value: number);
    resetRenotifyInterval(): void;
    get renotifyIntervalInput(): number | undefined;
}
export interface SyntheticsTestOptionsListRetry {
    /**
    * Number of retries needed to consider a location as failed before sending a notification alert.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#count SyntheticsTest#count}
    */
    readonly count?: number;
    /**
    * Interval between a failed test and the next retry in milliseconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#interval SyntheticsTest#interval}
    */
    readonly interval?: number;
}
export declare function syntheticsTestOptionsListRetryToTerraform(struct?: SyntheticsTestOptionsListRetryOutputReference | SyntheticsTestOptionsListRetry): any;
export declare class SyntheticsTestOptionsListRetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestOptionsListRetry | undefined;
    set internalValue(value: SyntheticsTestOptionsListRetry | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface SyntheticsTestOptionsListRumSettings {
    /**
    * RUM application ID used to collect RUM data for the browser test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#application_id SyntheticsTest#application_id}
    */
    readonly applicationId?: string;
    /**
    * RUM application API key ID used to collect RUM data for the browser test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#client_token_id SyntheticsTest#client_token_id}
    */
    readonly clientTokenId?: number;
    /**
    * Determines whether RUM data is collected during test runs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#is_enabled SyntheticsTest#is_enabled}
    */
    readonly isEnabled: boolean | cdktf.IResolvable;
}
export declare function syntheticsTestOptionsListRumSettingsToTerraform(struct?: SyntheticsTestOptionsListRumSettingsOutputReference | SyntheticsTestOptionsListRumSettings): any;
export declare class SyntheticsTestOptionsListRumSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestOptionsListRumSettings | undefined;
    set internalValue(value: SyntheticsTestOptionsListRumSettings | undefined);
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    resetApplicationId(): void;
    get applicationIdInput(): string | undefined;
    private _clientTokenId?;
    get clientTokenId(): number;
    set clientTokenId(value: number);
    resetClientTokenId(): void;
    get clientTokenIdInput(): number | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SyntheticsTestOptionsList {
    /**
    * For SSL test, whether or not the test should allow self signed certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#accept_self_signed SyntheticsTest#accept_self_signed}
    */
    readonly acceptSelfSigned?: boolean | cdktf.IResolvable;
    /**
    * Allows loading insecure content for an HTTP test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#allow_insecure SyntheticsTest#allow_insecure}
    */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
    * For SSL test, whether or not the test should fail on revoked certificate in stapled OCSP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#check_certificate_revocation SyntheticsTest#check_certificate_revocation}
    */
    readonly checkCertificateRevocation?: boolean | cdktf.IResolvable;
    /**
    * Disable Cross-Origin Resource Sharing for browser tests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#disable_cors SyntheticsTest#disable_cors}
    */
    readonly disableCors?: boolean | cdktf.IResolvable;
    /**
    * Disable Content Security Policy for browser tests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#disable_csp SyntheticsTest#disable_csp}
    */
    readonly disableCsp?: boolean | cdktf.IResolvable;
    /**
    * Determines whether or not the API HTTP test should follow redirects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#follow_redirects SyntheticsTest#follow_redirects}
    */
    readonly followRedirects?: boolean | cdktf.IResolvable;
    /**
    * HTTP version to use for a Synthetics API test. Valid values are `http1`, `http2`, `any`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#http_version SyntheticsTest#http_version}
    */
    readonly httpVersion?: string;
    /**
    * Ignore server certificate error.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#ignore_server_certificate_error SyntheticsTest#ignore_server_certificate_error}
    */
    readonly ignoreServerCertificateError?: boolean | cdktf.IResolvable;
    /**
    * Timeout before declaring the initial step as failed (in seconds) for browser tests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#initial_navigation_timeout SyntheticsTest#initial_navigation_timeout}
    */
    readonly initialNavigationTimeout?: number;
    /**
    * Minimum amount of time in failure required to trigger an alert. Default is `0`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#min_failure_duration SyntheticsTest#min_failure_duration}
    */
    readonly minFailureDuration?: number;
    /**
    * Minimum number of locations in failure required to trigger an alert. Default is `1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#min_location_failed SyntheticsTest#min_location_failed}
    */
    readonly minLocationFailed?: number;
    /**
    * The monitor name is used for the alert title as well as for all monitor dashboard widgets and SLOs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#monitor_name SyntheticsTest#monitor_name}
    */
    readonly monitorName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#monitor_priority SyntheticsTest#monitor_priority}
    */
    readonly monitorPriority?: number;
    /**
    * Prevents saving screenshots of the steps.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#no_screenshot SyntheticsTest#no_screenshot}
    */
    readonly noScreenshot?: boolean | cdktf.IResolvable;
    /**
    * A list of role identifiers pulled from the Roles API to restrict read and write access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#restricted_roles SyntheticsTest#restricted_roles}
    */
    readonly restrictedRoles?: string[];
    /**
    * How often the test should run (in seconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#tick_every SyntheticsTest#tick_every}
    */
    readonly tickEvery: number;
    /**
    * ci block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#ci SyntheticsTest#ci}
    */
    readonly ci?: SyntheticsTestOptionsListCi;
    /**
    * monitor_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#monitor_options SyntheticsTest#monitor_options}
    */
    readonly monitorOptions?: SyntheticsTestOptionsListMonitorOptions;
    /**
    * retry block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#retry SyntheticsTest#retry}
    */
    readonly retry?: SyntheticsTestOptionsListRetry;
    /**
    * rum_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#rum_settings SyntheticsTest#rum_settings}
    */
    readonly rumSettings?: SyntheticsTestOptionsListRumSettings;
}
export declare function syntheticsTestOptionsListToTerraform(struct?: SyntheticsTestOptionsListOutputReference | SyntheticsTestOptionsList): any;
export declare class SyntheticsTestOptionsListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestOptionsList | undefined;
    set internalValue(value: SyntheticsTestOptionsList | undefined);
    private _acceptSelfSigned?;
    get acceptSelfSigned(): boolean | cdktf.IResolvable;
    set acceptSelfSigned(value: boolean | cdktf.IResolvable);
    resetAcceptSelfSigned(): void;
    get acceptSelfSignedInput(): boolean | cdktf.IResolvable | undefined;
    private _allowInsecure?;
    get allowInsecure(): boolean | cdktf.IResolvable;
    set allowInsecure(value: boolean | cdktf.IResolvable);
    resetAllowInsecure(): void;
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _checkCertificateRevocation?;
    get checkCertificateRevocation(): boolean | cdktf.IResolvable;
    set checkCertificateRevocation(value: boolean | cdktf.IResolvable);
    resetCheckCertificateRevocation(): void;
    get checkCertificateRevocationInput(): boolean | cdktf.IResolvable | undefined;
    private _disableCors?;
    get disableCors(): boolean | cdktf.IResolvable;
    set disableCors(value: boolean | cdktf.IResolvable);
    resetDisableCors(): void;
    get disableCorsInput(): boolean | cdktf.IResolvable | undefined;
    private _disableCsp?;
    get disableCsp(): boolean | cdktf.IResolvable;
    set disableCsp(value: boolean | cdktf.IResolvable);
    resetDisableCsp(): void;
    get disableCspInput(): boolean | cdktf.IResolvable | undefined;
    private _followRedirects?;
    get followRedirects(): boolean | cdktf.IResolvable;
    set followRedirects(value: boolean | cdktf.IResolvable);
    resetFollowRedirects(): void;
    get followRedirectsInput(): boolean | cdktf.IResolvable | undefined;
    private _httpVersion?;
    get httpVersion(): string;
    set httpVersion(value: string);
    resetHttpVersion(): void;
    get httpVersionInput(): string | undefined;
    private _ignoreServerCertificateError?;
    get ignoreServerCertificateError(): boolean | cdktf.IResolvable;
    set ignoreServerCertificateError(value: boolean | cdktf.IResolvable);
    resetIgnoreServerCertificateError(): void;
    get ignoreServerCertificateErrorInput(): boolean | cdktf.IResolvable | undefined;
    private _initialNavigationTimeout?;
    get initialNavigationTimeout(): number;
    set initialNavigationTimeout(value: number);
    resetInitialNavigationTimeout(): void;
    get initialNavigationTimeoutInput(): number | undefined;
    private _minFailureDuration?;
    get minFailureDuration(): number;
    set minFailureDuration(value: number);
    resetMinFailureDuration(): void;
    get minFailureDurationInput(): number | undefined;
    private _minLocationFailed?;
    get minLocationFailed(): number;
    set minLocationFailed(value: number);
    resetMinLocationFailed(): void;
    get minLocationFailedInput(): number | undefined;
    private _monitorName?;
    get monitorName(): string;
    set monitorName(value: string);
    resetMonitorName(): void;
    get monitorNameInput(): string | undefined;
    private _monitorPriority?;
    get monitorPriority(): number;
    set monitorPriority(value: number);
    resetMonitorPriority(): void;
    get monitorPriorityInput(): number | undefined;
    private _noScreenshot?;
    get noScreenshot(): boolean | cdktf.IResolvable;
    set noScreenshot(value: boolean | cdktf.IResolvable);
    resetNoScreenshot(): void;
    get noScreenshotInput(): boolean | cdktf.IResolvable | undefined;
    private _restrictedRoles?;
    get restrictedRoles(): string[];
    set restrictedRoles(value: string[]);
    resetRestrictedRoles(): void;
    get restrictedRolesInput(): string[] | undefined;
    private _tickEvery?;
    get tickEvery(): number;
    set tickEvery(value: number);
    get tickEveryInput(): number | undefined;
    private _ci;
    get ci(): SyntheticsTestOptionsListCiOutputReference;
    putCi(value: SyntheticsTestOptionsListCi): void;
    resetCi(): void;
    get ciInput(): SyntheticsTestOptionsListCi | undefined;
    private _monitorOptions;
    get monitorOptions(): SyntheticsTestOptionsListMonitorOptionsOutputReference;
    putMonitorOptions(value: SyntheticsTestOptionsListMonitorOptions): void;
    resetMonitorOptions(): void;
    get monitorOptionsInput(): SyntheticsTestOptionsListMonitorOptions | undefined;
    private _retry;
    get retry(): SyntheticsTestOptionsListRetryOutputReference;
    putRetry(value: SyntheticsTestOptionsListRetry): void;
    resetRetry(): void;
    get retryInput(): SyntheticsTestOptionsListRetry | undefined;
    private _rumSettings;
    get rumSettings(): SyntheticsTestOptionsListRumSettingsOutputReference;
    putRumSettings(value: SyntheticsTestOptionsListRumSettings): void;
    resetRumSettings(): void;
    get rumSettingsInput(): SyntheticsTestOptionsListRumSettings | undefined;
}
export interface SyntheticsTestRequestBasicauth {
    /**
    * Access key for `SIGV4` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#access_key SyntheticsTest#access_key}
    */
    readonly accessKey?: string;
    /**
    * Access token url for `oauth-client` or `oauth-rop` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#access_token_url SyntheticsTest#access_token_url}
    */
    readonly accessTokenUrl?: string;
    /**
    * Audience for `oauth-client` or `oauth-rop` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#audience SyntheticsTest#audience}
    */
    readonly audience?: string;
    /**
    * Client ID for `oauth-client` or `oauth-rop` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#client_id SyntheticsTest#client_id}
    */
    readonly clientId?: string;
    /**
    * Client secret for `oauth-client` or `oauth-rop` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#client_secret SyntheticsTest#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Domain for `ntlm` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#domain SyntheticsTest#domain}
    */
    readonly domain?: string;
    /**
    * Password for authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#password SyntheticsTest#password}
    */
    readonly password?: string;
    /**
    * Region for `SIGV4` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#region SyntheticsTest#region}
    */
    readonly region?: string;
    /**
    * Resource for `oauth-client` or `oauth-rop` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#resource SyntheticsTest#resource}
    */
    readonly resource?: string;
    /**
    * Scope for `oauth-client` or `oauth-rop` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#scope SyntheticsTest#scope}
    */
    readonly scope?: string;
    /**
    * Secret key for `SIGV4` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#secret_key SyntheticsTest#secret_key}
    */
    readonly secretKey?: string;
    /**
    * Service name for `SIGV4` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#service_name SyntheticsTest#service_name}
    */
    readonly serviceName?: string;
    /**
    * Session token for `SIGV4` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#session_token SyntheticsTest#session_token}
    */
    readonly sessionToken?: string;
    /**
    * Token API Authentication for `oauth-client` or `oauth-rop` authentication. Valid values are `header`, `body`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#token_api_authentication SyntheticsTest#token_api_authentication}
    */
    readonly tokenApiAuthentication?: string;
    /**
    * Type of basic authentication to use when performing the test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#type SyntheticsTest#type}
    */
    readonly type?: string;
    /**
    * Username for authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#username SyntheticsTest#username}
    */
    readonly username?: string;
    /**
    * Workstation for `ntlm` authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#workstation SyntheticsTest#workstation}
    */
    readonly workstation?: string;
}
export declare function syntheticsTestRequestBasicauthToTerraform(struct?: SyntheticsTestRequestBasicauthOutputReference | SyntheticsTestRequestBasicauth): any;
export declare class SyntheticsTestRequestBasicauthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestRequestBasicauth | undefined;
    set internalValue(value: SyntheticsTestRequestBasicauth | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    resetAccessKey(): void;
    get accessKeyInput(): string | undefined;
    private _accessTokenUrl?;
    get accessTokenUrl(): string;
    set accessTokenUrl(value: string);
    resetAccessTokenUrl(): void;
    get accessTokenUrlInput(): string | undefined;
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    resetResource(): void;
    get resourceInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _secretKey?;
    get secretKey(): string;
    set secretKey(value: string);
    resetSecretKey(): void;
    get secretKeyInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _sessionToken?;
    get sessionToken(): string;
    set sessionToken(value: string);
    resetSessionToken(): void;
    get sessionTokenInput(): string | undefined;
    private _tokenApiAuthentication?;
    get tokenApiAuthentication(): string;
    set tokenApiAuthentication(value: string);
    resetTokenApiAuthentication(): void;
    get tokenApiAuthenticationInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _workstation?;
    get workstation(): string;
    set workstation(value: string);
    resetWorkstation(): void;
    get workstationInput(): string | undefined;
}
export interface SyntheticsTestRequestClientCertificateCert {
    /**
    * Content of the certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#content SyntheticsTest#content}
    */
    readonly content: string;
    /**
    * File name for the certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#filename SyntheticsTest#filename}
    */
    readonly filename?: string;
}
export declare function syntheticsTestRequestClientCertificateCertToTerraform(struct?: SyntheticsTestRequestClientCertificateCertOutputReference | SyntheticsTestRequestClientCertificateCert): any;
export declare class SyntheticsTestRequestClientCertificateCertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestRequestClientCertificateCert | undefined;
    set internalValue(value: SyntheticsTestRequestClientCertificateCert | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    resetFilename(): void;
    get filenameInput(): string | undefined;
}
export interface SyntheticsTestRequestClientCertificateKey {
    /**
    * Content of the certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#content SyntheticsTest#content}
    */
    readonly content: string;
    /**
    * File name for the certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#filename SyntheticsTest#filename}
    */
    readonly filename?: string;
}
export declare function syntheticsTestRequestClientCertificateKeyToTerraform(struct?: SyntheticsTestRequestClientCertificateKeyOutputReference | SyntheticsTestRequestClientCertificateKey): any;
export declare class SyntheticsTestRequestClientCertificateKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestRequestClientCertificateKey | undefined;
    set internalValue(value: SyntheticsTestRequestClientCertificateKey | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    resetFilename(): void;
    get filenameInput(): string | undefined;
}
export interface SyntheticsTestRequestClientCertificate {
    /**
    * cert block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#cert SyntheticsTest#cert}
    */
    readonly cert: SyntheticsTestRequestClientCertificateCert;
    /**
    * key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#key SyntheticsTest#key}
    */
    readonly key: SyntheticsTestRequestClientCertificateKey;
}
export declare function syntheticsTestRequestClientCertificateToTerraform(struct?: SyntheticsTestRequestClientCertificateOutputReference | SyntheticsTestRequestClientCertificate): any;
export declare class SyntheticsTestRequestClientCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestRequestClientCertificate | undefined;
    set internalValue(value: SyntheticsTestRequestClientCertificate | undefined);
    private _cert;
    get cert(): SyntheticsTestRequestClientCertificateCertOutputReference;
    putCert(value: SyntheticsTestRequestClientCertificateCert): void;
    get certInput(): SyntheticsTestRequestClientCertificateCert | undefined;
    private _key;
    get key(): SyntheticsTestRequestClientCertificateKeyOutputReference;
    putKey(value: SyntheticsTestRequestClientCertificateKey): void;
    get keyInput(): SyntheticsTestRequestClientCertificateKey | undefined;
}
export interface SyntheticsTestRequestDefinition {
    /**
    * The request body.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#body SyntheticsTest#body}
    */
    readonly body?: string;
    /**
    * Type of the request body. Valid values are `text/plain`, `application/json`, `text/xml`, `text/html`, `application/x-www-form-urlencoded`, `graphql`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#body_type SyntheticsTest#body_type}
    */
    readonly bodyType?: string;
    /**
    * The type of gRPC call to perform. Valid values are `healthcheck`, `unary`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#call_type SyntheticsTest#call_type}
    */
    readonly callType?: string;
    /**
    * By default, the client certificate is applied on the domain of the starting URL for browser tests. If you want your client certificate to be applied on other domains instead, add them in `certificate_domains`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#certificate_domains SyntheticsTest#certificate_domains}
    */
    readonly certificateDomains?: string[];
    /**
    * DNS server to use for DNS tests (`subtype = "dns"`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#dns_server SyntheticsTest#dns_server}
    */
    readonly dnsServer?: string;
    /**
    * DNS server port to use for DNS tests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#dns_server_port SyntheticsTest#dns_server_port}
    */
    readonly dnsServerPort?: number;
    /**
    * Host name to perform the test with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#host SyntheticsTest#host}
    */
    readonly host?: string;
    /**
    * For UDP and websocket tests, message to send with the request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#message SyntheticsTest#message}
    */
    readonly message?: string;
    /**
    * Either the HTTP method/verb to use or a gRPC method available on the service set in the `service` field. Required if `subtype` is `HTTP` or if `subtype` is `grpc` and `callType` is `unary`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#method SyntheticsTest#method}
    */
    readonly method?: string;
    /**
    * Determines whether or not to save the response body.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#no_saving_response_body SyntheticsTest#no_saving_response_body}
    */
    readonly noSavingResponseBody?: boolean | cdktf.IResolvable;
    /**
    * Number of pings to use per test for ICMP tests (`subtype = "icmp"`) between 0 and 10.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#number_of_packets SyntheticsTest#number_of_packets}
    */
    readonly numberOfPackets?: number;
    /**
    * Port to use when performing the test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#port SyntheticsTest#port}
    */
    readonly port?: number;
    /**
    * For SSL tests, it specifies on which server you want to initiate the TLS handshake, allowing the server to present one of multiple possible certificates on the same IP address and TCP port number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#servername SyntheticsTest#servername}
    */
    readonly servername?: string;
    /**
    * The gRPC service on which you want to perform the gRPC call.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#service SyntheticsTest#service}
    */
    readonly service?: string;
    /**
    * This will turn on a traceroute probe to discover all gateways along the path to the host destination. For ICMP tests (`subtype = "icmp"`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#should_track_hops SyntheticsTest#should_track_hops}
    */
    readonly shouldTrackHops?: boolean | cdktf.IResolvable;
    /**
    * Timeout in seconds for the test. Defaults to `60`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#timeout SyntheticsTest#timeout}
    */
    readonly timeout?: number;
    /**
    * The URL to send the request to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#url SyntheticsTest#url}
    */
    readonly url?: string;
}
export declare function syntheticsTestRequestDefinitionToTerraform(struct?: SyntheticsTestRequestDefinitionOutputReference | SyntheticsTestRequestDefinition): any;
export declare class SyntheticsTestRequestDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestRequestDefinition | undefined;
    set internalValue(value: SyntheticsTestRequestDefinition | undefined);
    private _body?;
    get body(): string;
    set body(value: string);
    resetBody(): void;
    get bodyInput(): string | undefined;
    private _bodyType?;
    get bodyType(): string;
    set bodyType(value: string);
    resetBodyType(): void;
    get bodyTypeInput(): string | undefined;
    private _callType?;
    get callType(): string;
    set callType(value: string);
    resetCallType(): void;
    get callTypeInput(): string | undefined;
    private _certificateDomains?;
    get certificateDomains(): string[];
    set certificateDomains(value: string[]);
    resetCertificateDomains(): void;
    get certificateDomainsInput(): string[] | undefined;
    private _dnsServer?;
    get dnsServer(): string;
    set dnsServer(value: string);
    resetDnsServer(): void;
    get dnsServerInput(): string | undefined;
    private _dnsServerPort?;
    get dnsServerPort(): number;
    set dnsServerPort(value: number);
    resetDnsServerPort(): void;
    get dnsServerPortInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _message?;
    get message(): string;
    set message(value: string);
    resetMessage(): void;
    get messageInput(): string | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _noSavingResponseBody?;
    get noSavingResponseBody(): boolean | cdktf.IResolvable;
    set noSavingResponseBody(value: boolean | cdktf.IResolvable);
    resetNoSavingResponseBody(): void;
    get noSavingResponseBodyInput(): boolean | cdktf.IResolvable | undefined;
    private _numberOfPackets?;
    get numberOfPackets(): number;
    set numberOfPackets(value: number);
    resetNumberOfPackets(): void;
    get numberOfPacketsInput(): number | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _servername?;
    get servername(): string;
    set servername(value: string);
    resetServername(): void;
    get servernameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _shouldTrackHops?;
    get shouldTrackHops(): boolean | cdktf.IResolvable;
    set shouldTrackHops(value: boolean | cdktf.IResolvable);
    resetShouldTrackHops(): void;
    get shouldTrackHopsInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
}
export interface SyntheticsTestRequestProxy {
    /**
    * Header name and value map.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#headers SyntheticsTest#headers}
    */
    readonly headers?: {
        [key: string]: string;
    };
    /**
    * URL of the proxy to perform the test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test#url SyntheticsTest#url}
    */
    readonly url: string;
}
export declare function syntheticsTestRequestProxyToTerraform(struct?: SyntheticsTestRequestProxyOutputReference | SyntheticsTestRequestProxy): any;
export declare class SyntheticsTestRequestProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SyntheticsTestRequestProxy | undefined;
    set internalValue(value: SyntheticsTestRequestProxy | undefined);
    private _headers?;
    get headers(): {
        [key: string]: string;
    };
    set headers(value: {
        [key: string]: string;
    });
    resetHeaders(): void;
    get headersInput(): {
        [key: string]: string;
    } | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test datadog_synthetics_test}
*/
export declare class SyntheticsTest extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_synthetics_test";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test datadog_synthetics_test} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SyntheticsTestConfig
    */
    constructor(scope: Construct, id: string, config: SyntheticsTestConfig);
    private _deviceIds?;
    get deviceIds(): string[];
    set deviceIds(value: string[]);
    resetDeviceIds(): void;
    get deviceIdsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _locations?;
    get locations(): string[];
    set locations(value: string[]);
    get locationsInput(): string[] | undefined;
    private _message?;
    get message(): string;
    set message(value: string);
    resetMessage(): void;
    get messageInput(): string | undefined;
    get monitorId(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _requestHeaders?;
    get requestHeaders(): {
        [key: string]: string;
    };
    set requestHeaders(value: {
        [key: string]: string;
    });
    resetRequestHeaders(): void;
    get requestHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _requestQuery?;
    get requestQuery(): {
        [key: string]: string;
    };
    set requestQuery(value: {
        [key: string]: string;
    });
    resetRequestQuery(): void;
    get requestQueryInput(): {
        [key: string]: string;
    } | undefined;
    private _setCookie?;
    get setCookie(): string;
    set setCookie(value: string);
    resetSetCookie(): void;
    get setCookieInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    get statusInput(): string | undefined;
    private _subtype?;
    get subtype(): string;
    set subtype(value: string);
    resetSubtype(): void;
    get subtypeInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _apiStep;
    get apiStep(): SyntheticsTestApiStepList;
    putApiStep(value: SyntheticsTestApiStep[] | cdktf.IResolvable): void;
    resetApiStep(): void;
    get apiStepInput(): cdktf.IResolvable | SyntheticsTestApiStep[] | undefined;
    private _assertion;
    get assertion(): SyntheticsTestAssertionList;
    putAssertion(value: SyntheticsTestAssertion[] | cdktf.IResolvable): void;
    resetAssertion(): void;
    get assertionInput(): cdktf.IResolvable | SyntheticsTestAssertion[] | undefined;
    private _browserStep;
    get browserStep(): SyntheticsTestBrowserStepList;
    putBrowserStep(value: SyntheticsTestBrowserStep[] | cdktf.IResolvable): void;
    resetBrowserStep(): void;
    get browserStepInput(): cdktf.IResolvable | SyntheticsTestBrowserStep[] | undefined;
    private _browserVariable;
    get browserVariable(): SyntheticsTestBrowserVariableList;
    putBrowserVariable(value: SyntheticsTestBrowserVariable[] | cdktf.IResolvable): void;
    resetBrowserVariable(): void;
    get browserVariableInput(): cdktf.IResolvable | SyntheticsTestBrowserVariable[] | undefined;
    private _configVariable;
    get configVariable(): SyntheticsTestConfigVariableList;
    putConfigVariable(value: SyntheticsTestConfigVariable[] | cdktf.IResolvable): void;
    resetConfigVariable(): void;
    get configVariableInput(): cdktf.IResolvable | SyntheticsTestConfigVariable[] | undefined;
    private _optionsList;
    get optionsList(): SyntheticsTestOptionsListOutputReference;
    putOptionsList(value: SyntheticsTestOptionsList): void;
    resetOptionsList(): void;
    get optionsListInput(): SyntheticsTestOptionsList | undefined;
    private _requestBasicauth;
    get requestBasicauth(): SyntheticsTestRequestBasicauthOutputReference;
    putRequestBasicauth(value: SyntheticsTestRequestBasicauth): void;
    resetRequestBasicauth(): void;
    get requestBasicauthInput(): SyntheticsTestRequestBasicauth | undefined;
    private _requestClientCertificate;
    get requestClientCertificate(): SyntheticsTestRequestClientCertificateOutputReference;
    putRequestClientCertificate(value: SyntheticsTestRequestClientCertificate): void;
    resetRequestClientCertificate(): void;
    get requestClientCertificateInput(): SyntheticsTestRequestClientCertificate | undefined;
    private _requestDefinition;
    get requestDefinition(): SyntheticsTestRequestDefinitionOutputReference;
    putRequestDefinition(value: SyntheticsTestRequestDefinition): void;
    resetRequestDefinition(): void;
    get requestDefinitionInput(): SyntheticsTestRequestDefinition | undefined;
    private _requestProxy;
    get requestProxy(): SyntheticsTestRequestProxyOutputReference;
    putRequestProxy(value: SyntheticsTestRequestProxy): void;
    resetRequestProxy(): void;
    get requestProxyInput(): SyntheticsTestRequestProxy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
