import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WebhookCustomVariableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook_custom_variable#id WebhookCustomVariable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether the custom variable is secret or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook_custom_variable#is_secret WebhookCustomVariable#is_secret}
    */
    readonly isSecret: boolean | cdktf.IResolvable;
    /**
    * The name of the variable. It corresponds with `<CUSTOM_VARIABLE_NAME>`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook_custom_variable#name WebhookCustomVariable#name}
    */
    readonly name: string;
    /**
    * The value of the custom variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook_custom_variable#value WebhookCustomVariable#value}
    */
    readonly value: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/webhook_custom_variable datadog_webhook_custom_variable}
*/
export declare class WebhookCustomVariable extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_webhook_custom_variable";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/webhook_custom_variable datadog_webhook_custom_variable} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WebhookCustomVariableConfig
    */
    constructor(scope: Construct, id: string, config: WebhookCustomVariableConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isSecret?;
    get isSecret(): boolean | cdktf.IResolvable;
    set isSecret(value: boolean | cdktf.IResolvable);
    get isSecretInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
