import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WebhookConfig extends cdktf.TerraformMetaArguments {
    /**
    * The headers attached to the webhook.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook#custom_headers Webhook#custom_headers}
    */
    readonly customHeaders?: string;
    /**
    * Encoding type. Valid values are `json`, `form`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook#encode_as Webhook#encode_as}
    */
    readonly encodeAs?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook#id Webhook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the webhook. It corresponds with `<WEBHOOK_NAME>`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook#name Webhook#name}
    */
    readonly name: string;
    /**
    * The payload of the webhook.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook#payload Webhook#payload}
    */
    readonly payload?: string;
    /**
    * The URL of the webhook.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/webhook#url Webhook#url}
    */
    readonly url: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/webhook datadog_webhook}
*/
export declare class Webhook extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_webhook";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/webhook datadog_webhook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WebhookConfig
    */
    constructor(scope: Construct, id: string, config: WebhookConfig);
    private _customHeaders?;
    get customHeaders(): string;
    set customHeaders(value: string);
    resetCustomHeaders(): void;
    get customHeadersInput(): string | undefined;
    private _encodeAs?;
    get encodeAs(): string;
    set encodeAs(value: string);
    resetEncodeAs(): void;
    get encodeAsInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _payload?;
    get payload(): string;
    set payload(value: string);
    resetPayload(): void;
    get payloadInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
