'''
# `datadog_dashboard`

Refer to the Terraform Registory for docs: [`datadog_dashboard`](https://www.terraform.io/docs/providers/datadog/r/dashboard).
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdktf as _cdktf_9a9027ec
import constructs as _constructs_77d1e7e8


class Dashboard(
    _cdktf_9a9027ec.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.Dashboard",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/datadog/r/dashboard datadog_dashboard}.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id_: builtins.str,
        *,
        layout_type: builtins.str,
        title: builtins.str,
        dashboard_lists: typing.Optional[typing.Sequence[jsii.Number]] = None,
        description: typing.Optional[builtins.str] = None,
        id: typing.Optional[builtins.str] = None,
        is_read_only: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        notify_list: typing.Optional[typing.Sequence[builtins.str]] = None,
        reflow_type: typing.Optional[builtins.str] = None,
        restricted_roles: typing.Optional[typing.Sequence[builtins.str]] = None,
        template_variable: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardTemplateVariable", typing.Dict[builtins.str, typing.Any]]]]] = None,
        template_variable_preset: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardTemplateVariablePreset", typing.Dict[builtins.str, typing.Any]]]]] = None,
        url: typing.Optional[builtins.str] = None,
        widget: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidget", typing.Dict[builtins.str, typing.Any]]]]] = None,
        connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
        for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/datadog/r/dashboard datadog_dashboard} Resource.

        :param scope: The scope in which to define this construct.
        :param id_: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param layout_type: The layout type of the dashboard. Valid values are ``ordered``, ``free``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#layout_type Dashboard#layout_type}
        :param title: The title of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param dashboard_lists: A list of dashboard lists this dashboard belongs to. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#dashboard_lists Dashboard#dashboard_lists}
        :param description: The description of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#description Dashboard#description}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#id Dashboard#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param is_read_only: Whether this dashboard is read-only. **Deprecated.** Prefer using ``restricted_roles`` to define which roles are required to edit the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_read_only Dashboard#is_read_only}
        :param notify_list: The list of handles for the users to notify when changes are made to this dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#notify_list Dashboard#notify_list}
        :param reflow_type: The reflow type of a new dashboard layout. Set this only when layout type is ``ordered``. If set to ``fixed``, the dashboard expects all widgets to have a layout, and if it's set to ``auto``, widgets should not have layouts. Valid values are ``auto``, ``fixed``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#reflow_type Dashboard#reflow_type}
        :param restricted_roles: UUIDs of roles whose associated users are authorized to edit the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#restricted_roles Dashboard#restricted_roles}
        :param template_variable: template_variable block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
        :param template_variable_preset: template_variable_preset block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable_preset Dashboard#template_variable_preset}
        :param url: The URL of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#url Dashboard#url}
        :param widget: widget block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget Dashboard#widget}
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__efaa170390123cc89677dd355b0eb61814ea381545662d082c35bd946f88a736)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id_", value=id_, expected_type=type_hints["id_"])
        config = DashboardConfig(
            layout_type=layout_type,
            title=title,
            dashboard_lists=dashboard_lists,
            description=description,
            id=id,
            is_read_only=is_read_only,
            notify_list=notify_list,
            reflow_type=reflow_type,
            restricted_roles=restricted_roles,
            template_variable=template_variable,
            template_variable_preset=template_variable_preset,
            url=url,
            widget=widget,
            connection=connection,
            count=count,
            depends_on=depends_on,
            for_each=for_each,
            lifecycle=lifecycle,
            provider=provider,
            provisioners=provisioners,
        )

        jsii.create(self.__class__, self, [scope, id_, config])

    @jsii.member(jsii_name="putTemplateVariable")
    def put_template_variable(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardTemplateVariable", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf6843348688414b7dc841e857f62e753fe9c307c3e6eb23d7f8cb9e126694e4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putTemplateVariable", [value]))

    @jsii.member(jsii_name="putTemplateVariablePreset")
    def put_template_variable_preset(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardTemplateVariablePreset", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a564bc1e50018f469d9ac23d26bb197bbb8fd7ef8b132afbaf445e34e7f43cce)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putTemplateVariablePreset", [value]))

    @jsii.member(jsii_name="putWidget")
    def put_widget(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidget", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1ecb1e05e1058805ecbc3f6c6c22c3e8ce138f02cab1521745cf4ca55a58231e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putWidget", [value]))

    @jsii.member(jsii_name="resetDashboardLists")
    def reset_dashboard_lists(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDashboardLists", []))

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDescription", []))

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetIsReadOnly")
    def reset_is_read_only(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsReadOnly", []))

    @jsii.member(jsii_name="resetNotifyList")
    def reset_notify_list(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetNotifyList", []))

    @jsii.member(jsii_name="resetReflowType")
    def reset_reflow_type(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetReflowType", []))

    @jsii.member(jsii_name="resetRestrictedRoles")
    def reset_restricted_roles(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRestrictedRoles", []))

    @jsii.member(jsii_name="resetTemplateVariable")
    def reset_template_variable(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTemplateVariable", []))

    @jsii.member(jsii_name="resetTemplateVariablePreset")
    def reset_template_variable_preset(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTemplateVariablePreset", []))

    @jsii.member(jsii_name="resetUrl")
    def reset_url(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUrl", []))

    @jsii.member(jsii_name="resetWidget")
    def reset_widget(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetWidget", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property
    @jsii.member(jsii_name="dashboardListsRemoved")
    def dashboard_lists_removed(self) -> typing.List[jsii.Number]:
        return typing.cast(typing.List[jsii.Number], jsii.get(self, "dashboardListsRemoved"))

    @builtins.property
    @jsii.member(jsii_name="templateVariable")
    def template_variable(self) -> "DashboardTemplateVariableList":
        return typing.cast("DashboardTemplateVariableList", jsii.get(self, "templateVariable"))

    @builtins.property
    @jsii.member(jsii_name="templateVariablePreset")
    def template_variable_preset(self) -> "DashboardTemplateVariablePresetList":
        return typing.cast("DashboardTemplateVariablePresetList", jsii.get(self, "templateVariablePreset"))

    @builtins.property
    @jsii.member(jsii_name="widget")
    def widget(self) -> "DashboardWidgetList":
        return typing.cast("DashboardWidgetList", jsii.get(self, "widget"))

    @builtins.property
    @jsii.member(jsii_name="dashboardListsInput")
    def dashboard_lists_input(self) -> typing.Optional[typing.List[jsii.Number]]:
        return typing.cast(typing.Optional[typing.List[jsii.Number]], jsii.get(self, "dashboardListsInput"))

    @builtins.property
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "descriptionInput"))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="isReadOnlyInput")
    def is_read_only_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "isReadOnlyInput"))

    @builtins.property
    @jsii.member(jsii_name="layoutTypeInput")
    def layout_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "layoutTypeInput"))

    @builtins.property
    @jsii.member(jsii_name="notifyListInput")
    def notify_list_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "notifyListInput"))

    @builtins.property
    @jsii.member(jsii_name="reflowTypeInput")
    def reflow_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "reflowTypeInput"))

    @builtins.property
    @jsii.member(jsii_name="restrictedRolesInput")
    def restricted_roles_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "restrictedRolesInput"))

    @builtins.property
    @jsii.member(jsii_name="templateVariableInput")
    def template_variable_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardTemplateVariable"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardTemplateVariable"]]], jsii.get(self, "templateVariableInput"))

    @builtins.property
    @jsii.member(jsii_name="templateVariablePresetInput")
    def template_variable_preset_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardTemplateVariablePreset"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardTemplateVariablePreset"]]], jsii.get(self, "templateVariablePresetInput"))

    @builtins.property
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property
    @jsii.member(jsii_name="urlInput")
    def url_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "urlInput"))

    @builtins.property
    @jsii.member(jsii_name="widgetInput")
    def widget_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidget"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidget"]]], jsii.get(self, "widgetInput"))

    @builtins.property
    @jsii.member(jsii_name="dashboardLists")
    def dashboard_lists(self) -> typing.List[jsii.Number]:
        return typing.cast(typing.List[jsii.Number], jsii.get(self, "dashboardLists"))

    @dashboard_lists.setter
    def dashboard_lists(self, value: typing.List[jsii.Number]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__176c0613c139890116a802aeb9123f1abbe95522dfc16062c31e354e44cb18bd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dashboardLists", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "description"))

    @description.setter
    def description(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d852c283196b7a0cc8c30579c2ba57b9525526972443b8a55a337970507ae51b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @id.setter
    def id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf70b7d2029acef243a5c947918013659745262797d34975efbe43cbe4a3a78a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="isReadOnly")
    def is_read_only(self) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "isReadOnly"))

    @is_read_only.setter
    def is_read_only(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d4fbd3f6bfd25f03ba1e93e3b7f6675951ea9b83100f8fc80f72bbe0a56f53ca)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "isReadOnly", value)

    @builtins.property
    @jsii.member(jsii_name="layoutType")
    def layout_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "layoutType"))

    @layout_type.setter
    def layout_type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d197793569f702660170d56f013943fc8a2a0154639af09e0043d6cb6c01fba8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "layoutType", value)

    @builtins.property
    @jsii.member(jsii_name="notifyList")
    def notify_list(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "notifyList"))

    @notify_list.setter
    def notify_list(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c980f50bf31118affe25e34137c07cc17c34abb9e0ac593291cb49903432e5c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "notifyList", value)

    @builtins.property
    @jsii.member(jsii_name="reflowType")
    def reflow_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "reflowType"))

    @reflow_type.setter
    def reflow_type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c3bf2876e8e664c23508307f8276a052eee4aa48a6fb926ddb7934cc1d25d63)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "reflowType", value)

    @builtins.property
    @jsii.member(jsii_name="restrictedRoles")
    def restricted_roles(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "restrictedRoles"))

    @restricted_roles.setter
    def restricted_roles(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8be1adb7b2413f7020d6687510598f778f030d0a207ab6cb11ad8aa68161fdcd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "restrictedRoles", value)

    @builtins.property
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__da71ee14603e4f88ff7554c522ed1c4fb17e0c1a7360a6f7b8ecbdc4eb9634d8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "title", value)

    @builtins.property
    @jsii.member(jsii_name="url")
    def url(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "url"))

    @url.setter
    def url(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__26a729f5c3629cb1dfe2fea7b50ce2521cbb31ab36d7107ea803e514e54f58c4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "url", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardConfig",
    jsii_struct_bases=[_cdktf_9a9027ec.TerraformMetaArguments],
    name_mapping={
        "connection": "connection",
        "count": "count",
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "provisioners": "provisioners",
        "layout_type": "layoutType",
        "title": "title",
        "dashboard_lists": "dashboardLists",
        "description": "description",
        "id": "id",
        "is_read_only": "isReadOnly",
        "notify_list": "notifyList",
        "reflow_type": "reflowType",
        "restricted_roles": "restrictedRoles",
        "template_variable": "templateVariable",
        "template_variable_preset": "templateVariablePreset",
        "url": "url",
        "widget": "widget",
    },
)
class DashboardConfig(_cdktf_9a9027ec.TerraformMetaArguments):
    def __init__(
        self,
        *,
        connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
        for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
        layout_type: builtins.str,
        title: builtins.str,
        dashboard_lists: typing.Optional[typing.Sequence[jsii.Number]] = None,
        description: typing.Optional[builtins.str] = None,
        id: typing.Optional[builtins.str] = None,
        is_read_only: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        notify_list: typing.Optional[typing.Sequence[builtins.str]] = None,
        reflow_type: typing.Optional[builtins.str] = None,
        restricted_roles: typing.Optional[typing.Sequence[builtins.str]] = None,
        template_variable: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardTemplateVariable", typing.Dict[builtins.str, typing.Any]]]]] = None,
        template_variable_preset: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardTemplateVariablePreset", typing.Dict[builtins.str, typing.Any]]]]] = None,
        url: typing.Optional[builtins.str] = None,
        widget: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidget", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        :param layout_type: The layout type of the dashboard. Valid values are ``ordered``, ``free``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#layout_type Dashboard#layout_type}
        :param title: The title of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param dashboard_lists: A list of dashboard lists this dashboard belongs to. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#dashboard_lists Dashboard#dashboard_lists}
        :param description: The description of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#description Dashboard#description}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#id Dashboard#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param is_read_only: Whether this dashboard is read-only. **Deprecated.** Prefer using ``restricted_roles`` to define which roles are required to edit the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_read_only Dashboard#is_read_only}
        :param notify_list: The list of handles for the users to notify when changes are made to this dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#notify_list Dashboard#notify_list}
        :param reflow_type: The reflow type of a new dashboard layout. Set this only when layout type is ``ordered``. If set to ``fixed``, the dashboard expects all widgets to have a layout, and if it's set to ``auto``, widgets should not have layouts. Valid values are ``auto``, ``fixed``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#reflow_type Dashboard#reflow_type}
        :param restricted_roles: UUIDs of roles whose associated users are authorized to edit the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#restricted_roles Dashboard#restricted_roles}
        :param template_variable: template_variable block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
        :param template_variable_preset: template_variable_preset block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable_preset Dashboard#template_variable_preset}
        :param url: The URL of the dashboard. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#url Dashboard#url}
        :param widget: widget block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget Dashboard#widget}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = _cdktf_9a9027ec.TerraformResourceLifecycle(**lifecycle)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f51472b928582e13d7002e59cc0a7c73a4b79173cbf4ac50d909db2de0b074bf)
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument provisioners", value=provisioners, expected_type=type_hints["provisioners"])
            check_type(argname="argument layout_type", value=layout_type, expected_type=type_hints["layout_type"])
            check_type(argname="argument title", value=title, expected_type=type_hints["title"])
            check_type(argname="argument dashboard_lists", value=dashboard_lists, expected_type=type_hints["dashboard_lists"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument is_read_only", value=is_read_only, expected_type=type_hints["is_read_only"])
            check_type(argname="argument notify_list", value=notify_list, expected_type=type_hints["notify_list"])
            check_type(argname="argument reflow_type", value=reflow_type, expected_type=type_hints["reflow_type"])
            check_type(argname="argument restricted_roles", value=restricted_roles, expected_type=type_hints["restricted_roles"])
            check_type(argname="argument template_variable", value=template_variable, expected_type=type_hints["template_variable"])
            check_type(argname="argument template_variable_preset", value=template_variable_preset, expected_type=type_hints["template_variable_preset"])
            check_type(argname="argument url", value=url, expected_type=type_hints["url"])
            check_type(argname="argument widget", value=widget, expected_type=type_hints["widget"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "layout_type": layout_type,
            "title": title,
        }
        if connection is not None:
            self._values["connection"] = connection
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if provisioners is not None:
            self._values["provisioners"] = provisioners
        if dashboard_lists is not None:
            self._values["dashboard_lists"] = dashboard_lists
        if description is not None:
            self._values["description"] = description
        if id is not None:
            self._values["id"] = id
        if is_read_only is not None:
            self._values["is_read_only"] = is_read_only
        if notify_list is not None:
            self._values["notify_list"] = notify_list
        if reflow_type is not None:
            self._values["reflow_type"] = reflow_type
        if restricted_roles is not None:
            self._values["restricted_roles"] = restricted_roles
        if template_variable is not None:
            self._values["template_variable"] = template_variable
        if template_variable_preset is not None:
            self._values["template_variable_preset"] = template_variable_preset
        if url is not None:
            self._values["url"] = url
        if widget is not None:
            self._values["widget"] = widget

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, _cdktf_9a9027ec.WinrmProvisionerConnection]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, _cdktf_9a9027ec.WinrmProvisionerConnection]], result)

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(
        self,
    ) -> typing.Optional[typing.List[_cdktf_9a9027ec.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[_cdktf_9a9027ec.ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[_cdktf_9a9027ec.ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.ITerraformIterator], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[_cdktf_9a9027ec.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[_cdktf_9a9027ec.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.TerraformProvider], result)

    @builtins.property
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[_cdktf_9a9027ec.FileProvisioner, _cdktf_9a9027ec.LocalExecProvisioner, _cdktf_9a9027ec.RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provisioners")
        return typing.cast(typing.Optional[typing.List[typing.Union[_cdktf_9a9027ec.FileProvisioner, _cdktf_9a9027ec.LocalExecProvisioner, _cdktf_9a9027ec.RemoteExecProvisioner]]], result)

    @builtins.property
    def layout_type(self) -> builtins.str:
        '''The layout type of the dashboard. Valid values are ``ordered``, ``free``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#layout_type Dashboard#layout_type}
        '''
        result = self._values.get("layout_type")
        assert result is not None, "Required property 'layout_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def title(self) -> builtins.str:
        '''The title of the dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        assert result is not None, "Required property 'title' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def dashboard_lists(self) -> typing.Optional[typing.List[jsii.Number]]:
        '''A list of dashboard lists this dashboard belongs to.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#dashboard_lists Dashboard#dashboard_lists}
        '''
        result = self._values.get("dashboard_lists")
        return typing.cast(typing.Optional[typing.List[jsii.Number]], result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''The description of the dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#description Dashboard#description}
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#id Dashboard#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def is_read_only(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        '''Whether this dashboard is read-only. **Deprecated.** Prefer using ``restricted_roles`` to define which roles are required to edit the dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_read_only Dashboard#is_read_only}
        '''
        result = self._values.get("is_read_only")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], result)

    @builtins.property
    def notify_list(self) -> typing.Optional[typing.List[builtins.str]]:
        '''The list of handles for the users to notify when changes are made to this dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#notify_list Dashboard#notify_list}
        '''
        result = self._values.get("notify_list")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reflow_type(self) -> typing.Optional[builtins.str]:
        '''The reflow type of a new dashboard layout.

        Set this only when layout type is ``ordered``. If set to ``fixed``, the dashboard expects all widgets to have a layout, and if it's set to ``auto``, widgets should not have layouts. Valid values are ``auto``, ``fixed``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#reflow_type Dashboard#reflow_type}
        '''
        result = self._values.get("reflow_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def restricted_roles(self) -> typing.Optional[typing.List[builtins.str]]:
        '''UUIDs of roles whose associated users are authorized to edit the dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#restricted_roles Dashboard#restricted_roles}
        '''
        result = self._values.get("restricted_roles")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def template_variable(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardTemplateVariable"]]]:
        '''template_variable block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
        '''
        result = self._values.get("template_variable")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardTemplateVariable"]]], result)

    @builtins.property
    def template_variable_preset(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardTemplateVariablePreset"]]]:
        '''template_variable_preset block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable_preset Dashboard#template_variable_preset}
        '''
        result = self._values.get("template_variable_preset")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardTemplateVariablePreset"]]], result)

    @builtins.property
    def url(self) -> typing.Optional[builtins.str]:
        '''The URL of the dashboard.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#url Dashboard#url}
        '''
        result = self._values.get("url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def widget(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidget"]]]:
        '''widget block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget Dashboard#widget}
        '''
        result = self._values.get("widget")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidget"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardTemplateVariable",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "available_values": "availableValues",
        "default": "default",
        "defaults": "defaults",
        "prefix": "prefix",
    },
)
class DashboardTemplateVariable:
    def __init__(
        self,
        *,
        name: builtins.str,
        available_values: typing.Optional[typing.Sequence[builtins.str]] = None,
        default: typing.Optional[builtins.str] = None,
        defaults: typing.Optional[typing.Sequence[builtins.str]] = None,
        prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: The name of the variable. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param available_values: The list of values that the template variable drop-down is be limited to. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#available_values Dashboard#available_values}
        :param default: The default value for the template variable on dashboard load. Cannot be used in conjunction with ``defaults``. **Deprecated.** Use ``defaults`` instead. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#default Dashboard#default}
        :param defaults: One or many default values for template variables on load. If more than one default is specified, they will be unioned together with ``OR``. Cannot be used in conjunction with ``default``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#defaults Dashboard#defaults}
        :param prefix: The tag prefix associated with the variable. Only tags with this prefix appear in the variable dropdown. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#prefix Dashboard#prefix}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf19ef94c22e2b4d7985e85abe0a4717cf5fe29f34ff33e680565a0cc0d9fc1e)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument available_values", value=available_values, expected_type=type_hints["available_values"])
            check_type(argname="argument default", value=default, expected_type=type_hints["default"])
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if available_values is not None:
            self._values["available_values"] = available_values
        if default is not None:
            self._values["default"] = default
        if defaults is not None:
            self._values["defaults"] = defaults
        if prefix is not None:
            self._values["prefix"] = prefix

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the variable.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def available_values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''The list of values that the template variable drop-down is be limited to.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#available_values Dashboard#available_values}
        '''
        result = self._values.get("available_values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def default(self) -> typing.Optional[builtins.str]:
        '''The default value for the template variable on dashboard load.

        Cannot be used in conjunction with ``defaults``. **Deprecated.** Use ``defaults`` instead.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#default Dashboard#default}
        '''
        result = self._values.get("default")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def defaults(self) -> typing.Optional[typing.List[builtins.str]]:
        '''One or many default values for template variables on load.

        If more than one default is specified, they will be unioned together with ``OR``. Cannot be used in conjunction with ``default``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#defaults Dashboard#defaults}
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''The tag prefix associated with the variable. Only tags with this prefix appear in the variable dropdown.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#prefix Dashboard#prefix}
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardTemplateVariable(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardTemplateVariableList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardTemplateVariableList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ef77ef59c304b3c4cd5c382c222370842bc469f2cb101ea00cad0e04a3a44262)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "DashboardTemplateVariableOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af57cc4305442e22476e2176e419456e5603ac84d0abc6a3e88abcfeb5f67757)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardTemplateVariableOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ec2ea454748e46fa9b63b0ae5e049ba6744908155177ffc7c9fc567fc6227217)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__74591b4daff015be6c164d705666f8299795f203708c000e4591e829b92c3fac)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__770674dc0f88d735dfee17e380f429c7ad574af4e017b19597b51a5910346e63)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardTemplateVariable]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardTemplateVariable]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardTemplateVariable]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4f305cc1361470fa2891f322f75bb21acad22367563f69849e300d8f8ce2bebf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardTemplateVariableOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardTemplateVariableOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4a79cc3b37ed213ba4e19d2087ca108d60df3a42f9825a559f205f1203403855)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetAvailableValues")
    def reset_available_values(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAvailableValues", []))

    @jsii.member(jsii_name="resetDefault")
    def reset_default(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDefault", []))

    @jsii.member(jsii_name="resetDefaults")
    def reset_defaults(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDefaults", []))

    @jsii.member(jsii_name="resetPrefix")
    def reset_prefix(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrefix", []))

    @builtins.property
    @jsii.member(jsii_name="availableValuesInput")
    def available_values_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "availableValuesInput"))

    @builtins.property
    @jsii.member(jsii_name="defaultInput")
    def default_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "defaultInput"))

    @builtins.property
    @jsii.member(jsii_name="defaultsInput")
    def defaults_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "defaultsInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="prefixInput")
    def prefix_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "prefixInput"))

    @builtins.property
    @jsii.member(jsii_name="availableValues")
    def available_values(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "availableValues"))

    @available_values.setter
    def available_values(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f3209e1f27a7c0f0731601a571b366368616ed1c941f1cf86ca18d83b24f9a77)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "availableValues", value)

    @builtins.property
    @jsii.member(jsii_name="default")
    def default(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "default"))

    @default.setter
    def default(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dba9ddcc5465fbc28ba8156757c1ad24aba040794f8f3ef22a10282e9f1bbf08)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "default", value)

    @builtins.property
    @jsii.member(jsii_name="defaults")
    def defaults(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "defaults"))

    @defaults.setter
    def defaults(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__21ee30ffb5a0a27ccde1ae4c7a8bbc5955e91de84f78d0e59adbcdb318262794)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "defaults", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__076b34768774d5b960671aa7edb6c4047520bd1c60f5e945aeb8daf4852f50fc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="prefix")
    def prefix(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "prefix"))

    @prefix.setter
    def prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a78f41f834577909a474fee2b41afcb80b6233b02dc0f24e27098e7dce285700)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "prefix", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardTemplateVariable, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardTemplateVariable, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardTemplateVariable, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1488b83625c78d4cbb188c5b31316a4a140ec8ecc258db2c70c9e89ea69c5dd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardTemplateVariablePreset",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "template_variable": "templateVariable"},
)
class DashboardTemplateVariablePreset:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        template_variable: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardTemplateVariablePresetTemplateVariable", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param name: The name of the preset. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param template_variable: template_variable block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2bc5486dcf1539ec7b8d42eaa0f7a95f64ccaf711e5b166ceec6405fdaccc2ae)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument template_variable", value=template_variable, expected_type=type_hints["template_variable"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if template_variable is not None:
            self._values["template_variable"] = template_variable

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the preset.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def template_variable(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardTemplateVariablePresetTemplateVariable"]]]:
        '''template_variable block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
        '''
        result = self._values.get("template_variable")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardTemplateVariablePresetTemplateVariable"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardTemplateVariablePreset(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardTemplateVariablePresetList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardTemplateVariablePresetList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__92134cd04010baaced49b5e3291214f19cf3c9c21dc46f8582bb35adfef1f981)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardTemplateVariablePresetOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c3b730faff139c3af48ce5a63a556d940f0c725a57fb75104afea231c5172b4)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardTemplateVariablePresetOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__468a332fedb87667be898aeaa46db558ee6f3a4dfe9c503335cfa5518f7d2907)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__250b7128ec71d2ebfaeb5c73c84e369a5dad2b040bf05b5461854ec7f5dc9aa2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0cb5548d1cdc814a97c16b48fcd2bf9a4326b8cfb27cbd866ff47a588d712431)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardTemplateVariablePreset]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardTemplateVariablePreset]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardTemplateVariablePreset]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__847cb4d19bc9981280bf3d6a9f231a65e5d4753633dfbc22466b6230308cea5c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardTemplateVariablePresetOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardTemplateVariablePresetOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff080e4b1fa4ea4cea598ecd98c17cefece18e5e379c9dc17f8a392a47532d32)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putTemplateVariable")
    def put_template_variable(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardTemplateVariablePresetTemplateVariable", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__291fe449b9d1c5480f19b35b80b293938315873eb1e1459de049970131ef8fb1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putTemplateVariable", [value]))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetTemplateVariable")
    def reset_template_variable(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTemplateVariable", []))

    @builtins.property
    @jsii.member(jsii_name="templateVariable")
    def template_variable(
        self,
    ) -> "DashboardTemplateVariablePresetTemplateVariableList":
        return typing.cast("DashboardTemplateVariablePresetTemplateVariableList", jsii.get(self, "templateVariable"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="templateVariableInput")
    def template_variable_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardTemplateVariablePresetTemplateVariable"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardTemplateVariablePresetTemplateVariable"]]], jsii.get(self, "templateVariableInput"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7518b58b3f7a7c06374f7b9b26094334c651862010e1ad1314ff0805a831129e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardTemplateVariablePreset, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardTemplateVariablePreset, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardTemplateVariablePreset, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c675f81d6349bc4454d30f5e107d611f33467a7dc6694257958906e11dfaca51)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardTemplateVariablePresetTemplateVariable",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value", "values": "values"},
)
class DashboardTemplateVariablePresetTemplateVariable:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        value: typing.Optional[builtins.str] = None,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param name: The name of the template variable. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param value: The value that should be assumed by the template variable in this preset. Cannot be used in conjunction with ``values``. **Deprecated.** Use ``values`` instead. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
        :param values: One or many template variable values within the saved view, which will be unioned together using ``OR`` if more than one is specified. Cannot be used in conjunction with ``value``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#values Dashboard#values}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20581ce0c03d8e49b6e088768074180a8bd0c007c527a55378559897352076b9)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if value is not None:
            self._values["value"] = value
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the template variable.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''The value that should be assumed by the template variable in this preset.

        Cannot be used in conjunction with ``values``. **Deprecated.** Use ``values`` instead.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''One or many template variable values within the saved view, which will be unioned together using ``OR`` if more than one is specified.

        Cannot be used in conjunction with ``value``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#values Dashboard#values}
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardTemplateVariablePresetTemplateVariable(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardTemplateVariablePresetTemplateVariableList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardTemplateVariablePresetTemplateVariableList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fe5dd64f262a917d4dbe8d508f0a20609e398fb34ac44ce41e0e3394c933c0a1)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardTemplateVariablePresetTemplateVariableOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d84567fa9ecf65da101f284572e925e8f80d1e80c0bdc20e93700970f01bd783)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardTemplateVariablePresetTemplateVariableOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__765a0e3a89af159a34c7f9bb22920a3face95772871720b5209190d0899cb58b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__18210f7eba6fdc3ff303d0bf73c0d51662eaac9aab941155b30afc7005015c9c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aa3a55669dd0d265c0de5f57d72b3a852074973516cf4c171982f84bec3b5849)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardTemplateVariablePresetTemplateVariable]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardTemplateVariablePresetTemplateVariable]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardTemplateVariablePresetTemplateVariable]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__90297e93545bb97018d40f6adc7301ae38b42deea3a6d959041f55bc2d578464)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardTemplateVariablePresetTemplateVariableOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardTemplateVariablePresetTemplateVariableOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a3f23c616bfeec079efdfc2fc36765c44d13f52c32671f56f463ea23b501f11)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetValue")
    def reset_value(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetValue", []))

    @jsii.member(jsii_name="resetValues")
    def reset_values(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetValues", []))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="valueInput")
    def value_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "valueInput"))

    @builtins.property
    @jsii.member(jsii_name="valuesInput")
    def values_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "valuesInput"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46913c08e55431dda7da6025fe9efd495d5e496cdaef428ceca26ff83e0e4813)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "value"))

    @value.setter
    def value(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__229552154a308434fb790c1046e977824a9a8ff0a1c86947a231ee6afa89b8e2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "value", value)

    @builtins.property
    @jsii.member(jsii_name="values")
    def values(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "values"))

    @values.setter
    def values(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__48da7af46004f5e6074d5e17637c8bd40ddfbfb2f7e61823f67a0f78704fa9d2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "values", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardTemplateVariablePresetTemplateVariable, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardTemplateVariablePresetTemplateVariable, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardTemplateVariablePresetTemplateVariable, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f2c8d75359dc3d8337a357d5f32834250bf123849d945fa22ee5e9c90bf373d7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidget",
    jsii_struct_bases=[],
    name_mapping={
        "alert_graph_definition": "alertGraphDefinition",
        "alert_value_definition": "alertValueDefinition",
        "change_definition": "changeDefinition",
        "check_status_definition": "checkStatusDefinition",
        "distribution_definition": "distributionDefinition",
        "event_stream_definition": "eventStreamDefinition",
        "event_timeline_definition": "eventTimelineDefinition",
        "free_text_definition": "freeTextDefinition",
        "geomap_definition": "geomapDefinition",
        "group_definition": "groupDefinition",
        "heatmap_definition": "heatmapDefinition",
        "hostmap_definition": "hostmapDefinition",
        "iframe_definition": "iframeDefinition",
        "image_definition": "imageDefinition",
        "list_stream_definition": "listStreamDefinition",
        "log_stream_definition": "logStreamDefinition",
        "manage_status_definition": "manageStatusDefinition",
        "note_definition": "noteDefinition",
        "query_table_definition": "queryTableDefinition",
        "query_value_definition": "queryValueDefinition",
        "scatterplot_definition": "scatterplotDefinition",
        "service_level_objective_definition": "serviceLevelObjectiveDefinition",
        "servicemap_definition": "servicemapDefinition",
        "slo_list_definition": "sloListDefinition",
        "sunburst_definition": "sunburstDefinition",
        "timeseries_definition": "timeseriesDefinition",
        "toplist_definition": "toplistDefinition",
        "topology_map_definition": "topologyMapDefinition",
        "trace_service_definition": "traceServiceDefinition",
        "treemap_definition": "treemapDefinition",
        "widget_layout": "widgetLayout",
    },
)
class DashboardWidget:
    def __init__(
        self,
        *,
        alert_graph_definition: typing.Optional[typing.Union["DashboardWidgetAlertGraphDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        alert_value_definition: typing.Optional[typing.Union["DashboardWidgetAlertValueDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        change_definition: typing.Optional[typing.Union["DashboardWidgetChangeDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        check_status_definition: typing.Optional[typing.Union["DashboardWidgetCheckStatusDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        distribution_definition: typing.Optional[typing.Union["DashboardWidgetDistributionDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        event_stream_definition: typing.Optional[typing.Union["DashboardWidgetEventStreamDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        event_timeline_definition: typing.Optional[typing.Union["DashboardWidgetEventTimelineDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        free_text_definition: typing.Optional[typing.Union["DashboardWidgetFreeTextDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        geomap_definition: typing.Optional[typing.Union["DashboardWidgetGeomapDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        group_definition: typing.Optional[typing.Union["DashboardWidgetGroupDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        heatmap_definition: typing.Optional[typing.Union["DashboardWidgetHeatmapDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        hostmap_definition: typing.Optional[typing.Union["DashboardWidgetHostmapDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        iframe_definition: typing.Optional[typing.Union["DashboardWidgetIframeDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        image_definition: typing.Optional[typing.Union["DashboardWidgetImageDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        list_stream_definition: typing.Optional[typing.Union["DashboardWidgetListStreamDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        log_stream_definition: typing.Optional[typing.Union["DashboardWidgetLogStreamDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        manage_status_definition: typing.Optional[typing.Union["DashboardWidgetManageStatusDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        note_definition: typing.Optional[typing.Union["DashboardWidgetNoteDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        query_table_definition: typing.Optional[typing.Union["DashboardWidgetQueryTableDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        query_value_definition: typing.Optional[typing.Union["DashboardWidgetQueryValueDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        scatterplot_definition: typing.Optional[typing.Union["DashboardWidgetScatterplotDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        service_level_objective_definition: typing.Optional[typing.Union["DashboardWidgetServiceLevelObjectiveDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        servicemap_definition: typing.Optional[typing.Union["DashboardWidgetServicemapDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        slo_list_definition: typing.Optional[typing.Union["DashboardWidgetSloListDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        sunburst_definition: typing.Optional[typing.Union["DashboardWidgetSunburstDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        timeseries_definition: typing.Optional[typing.Union["DashboardWidgetTimeseriesDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        toplist_definition: typing.Optional[typing.Union["DashboardWidgetToplistDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        topology_map_definition: typing.Optional[typing.Union["DashboardWidgetTopologyMapDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        trace_service_definition: typing.Optional[typing.Union["DashboardWidgetTraceServiceDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        treemap_definition: typing.Optional[typing.Union["DashboardWidgetTreemapDefinition", typing.Dict[builtins.str, typing.Any]]] = None,
        widget_layout: typing.Optional[typing.Union["DashboardWidgetWidgetLayout", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param alert_graph_definition: alert_graph_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_graph_definition Dashboard#alert_graph_definition}
        :param alert_value_definition: alert_value_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_value_definition Dashboard#alert_value_definition}
        :param change_definition: change_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_definition Dashboard#change_definition}
        :param check_status_definition: check_status_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check_status_definition Dashboard#check_status_definition}
        :param distribution_definition: distribution_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#distribution_definition Dashboard#distribution_definition}
        :param event_stream_definition: event_stream_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_stream_definition Dashboard#event_stream_definition}
        :param event_timeline_definition: event_timeline_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_timeline_definition Dashboard#event_timeline_definition}
        :param free_text_definition: free_text_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#free_text_definition Dashboard#free_text_definition}
        :param geomap_definition: geomap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#geomap_definition Dashboard#geomap_definition}
        :param group_definition: group_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_definition Dashboard#group_definition}
        :param heatmap_definition: heatmap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#heatmap_definition Dashboard#heatmap_definition}
        :param hostmap_definition: hostmap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hostmap_definition Dashboard#hostmap_definition}
        :param iframe_definition: iframe_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#iframe_definition Dashboard#iframe_definition}
        :param image_definition: image_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_definition Dashboard#image_definition}
        :param list_stream_definition: list_stream_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#list_stream_definition Dashboard#list_stream_definition}
        :param log_stream_definition: log_stream_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_stream_definition Dashboard#log_stream_definition}
        :param manage_status_definition: manage_status_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#manage_status_definition Dashboard#manage_status_definition}
        :param note_definition: note_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#note_definition Dashboard#note_definition}
        :param query_table_definition: query_table_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query_table_definition Dashboard#query_table_definition}
        :param query_value_definition: query_value_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query_value_definition Dashboard#query_value_definition}
        :param scatterplot_definition: scatterplot_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#scatterplot_definition Dashboard#scatterplot_definition}
        :param service_level_objective_definition: service_level_objective_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service_level_objective_definition Dashboard#service_level_objective_definition}
        :param servicemap_definition: servicemap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#servicemap_definition Dashboard#servicemap_definition}
        :param slo_list_definition: slo_list_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#slo_list_definition Dashboard#slo_list_definition}
        :param sunburst_definition: sunburst_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sunburst_definition Dashboard#sunburst_definition}
        :param timeseries_definition: timeseries_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeseries_definition Dashboard#timeseries_definition}
        :param toplist_definition: toplist_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#toplist_definition Dashboard#toplist_definition}
        :param topology_map_definition: topology_map_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#topology_map_definition Dashboard#topology_map_definition}
        :param trace_service_definition: trace_service_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#trace_service_definition Dashboard#trace_service_definition}
        :param treemap_definition: treemap_definition block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#treemap_definition Dashboard#treemap_definition}
        :param widget_layout: widget_layout block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget_layout Dashboard#widget_layout}
        '''
        if isinstance(alert_graph_definition, dict):
            alert_graph_definition = DashboardWidgetAlertGraphDefinition(**alert_graph_definition)
        if isinstance(alert_value_definition, dict):
            alert_value_definition = DashboardWidgetAlertValueDefinition(**alert_value_definition)
        if isinstance(change_definition, dict):
            change_definition = DashboardWidgetChangeDefinition(**change_definition)
        if isinstance(check_status_definition, dict):
            check_status_definition = DashboardWidgetCheckStatusDefinition(**check_status_definition)
        if isinstance(distribution_definition, dict):
            distribution_definition = DashboardWidgetDistributionDefinition(**distribution_definition)
        if isinstance(event_stream_definition, dict):
            event_stream_definition = DashboardWidgetEventStreamDefinition(**event_stream_definition)
        if isinstance(event_timeline_definition, dict):
            event_timeline_definition = DashboardWidgetEventTimelineDefinition(**event_timeline_definition)
        if isinstance(free_text_definition, dict):
            free_text_definition = DashboardWidgetFreeTextDefinition(**free_text_definition)
        if isinstance(geomap_definition, dict):
            geomap_definition = DashboardWidgetGeomapDefinition(**geomap_definition)
        if isinstance(group_definition, dict):
            group_definition = DashboardWidgetGroupDefinition(**group_definition)
        if isinstance(heatmap_definition, dict):
            heatmap_definition = DashboardWidgetHeatmapDefinition(**heatmap_definition)
        if isinstance(hostmap_definition, dict):
            hostmap_definition = DashboardWidgetHostmapDefinition(**hostmap_definition)
        if isinstance(iframe_definition, dict):
            iframe_definition = DashboardWidgetIframeDefinition(**iframe_definition)
        if isinstance(image_definition, dict):
            image_definition = DashboardWidgetImageDefinition(**image_definition)
        if isinstance(list_stream_definition, dict):
            list_stream_definition = DashboardWidgetListStreamDefinition(**list_stream_definition)
        if isinstance(log_stream_definition, dict):
            log_stream_definition = DashboardWidgetLogStreamDefinition(**log_stream_definition)
        if isinstance(manage_status_definition, dict):
            manage_status_definition = DashboardWidgetManageStatusDefinition(**manage_status_definition)
        if isinstance(note_definition, dict):
            note_definition = DashboardWidgetNoteDefinition(**note_definition)
        if isinstance(query_table_definition, dict):
            query_table_definition = DashboardWidgetQueryTableDefinition(**query_table_definition)
        if isinstance(query_value_definition, dict):
            query_value_definition = DashboardWidgetQueryValueDefinition(**query_value_definition)
        if isinstance(scatterplot_definition, dict):
            scatterplot_definition = DashboardWidgetScatterplotDefinition(**scatterplot_definition)
        if isinstance(service_level_objective_definition, dict):
            service_level_objective_definition = DashboardWidgetServiceLevelObjectiveDefinition(**service_level_objective_definition)
        if isinstance(servicemap_definition, dict):
            servicemap_definition = DashboardWidgetServicemapDefinition(**servicemap_definition)
        if isinstance(slo_list_definition, dict):
            slo_list_definition = DashboardWidgetSloListDefinition(**slo_list_definition)
        if isinstance(sunburst_definition, dict):
            sunburst_definition = DashboardWidgetSunburstDefinition(**sunburst_definition)
        if isinstance(timeseries_definition, dict):
            timeseries_definition = DashboardWidgetTimeseriesDefinition(**timeseries_definition)
        if isinstance(toplist_definition, dict):
            toplist_definition = DashboardWidgetToplistDefinition(**toplist_definition)
        if isinstance(topology_map_definition, dict):
            topology_map_definition = DashboardWidgetTopologyMapDefinition(**topology_map_definition)
        if isinstance(trace_service_definition, dict):
            trace_service_definition = DashboardWidgetTraceServiceDefinition(**trace_service_definition)
        if isinstance(treemap_definition, dict):
            treemap_definition = DashboardWidgetTreemapDefinition(**treemap_definition)
        if isinstance(widget_layout, dict):
            widget_layout = DashboardWidgetWidgetLayout(**widget_layout)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c927b912fe0ea401fdb411a843da4d568c3f508764fbc256a5e1e164217eab4)
            check_type(argname="argument alert_graph_definition", value=alert_graph_definition, expected_type=type_hints["alert_graph_definition"])
            check_type(argname="argument alert_value_definition", value=alert_value_definition, expected_type=type_hints["alert_value_definition"])
            check_type(argname="argument change_definition", value=change_definition, expected_type=type_hints["change_definition"])
            check_type(argname="argument check_status_definition", value=check_status_definition, expected_type=type_hints["check_status_definition"])
            check_type(argname="argument distribution_definition", value=distribution_definition, expected_type=type_hints["distribution_definition"])
            check_type(argname="argument event_stream_definition", value=event_stream_definition, expected_type=type_hints["event_stream_definition"])
            check_type(argname="argument event_timeline_definition", value=event_timeline_definition, expected_type=type_hints["event_timeline_definition"])
            check_type(argname="argument free_text_definition", value=free_text_definition, expected_type=type_hints["free_text_definition"])
            check_type(argname="argument geomap_definition", value=geomap_definition, expected_type=type_hints["geomap_definition"])
            check_type(argname="argument group_definition", value=group_definition, expected_type=type_hints["group_definition"])
            check_type(argname="argument heatmap_definition", value=heatmap_definition, expected_type=type_hints["heatmap_definition"])
            check_type(argname="argument hostmap_definition", value=hostmap_definition, expected_type=type_hints["hostmap_definition"])
            check_type(argname="argument iframe_definition", value=iframe_definition, expected_type=type_hints["iframe_definition"])
            check_type(argname="argument image_definition", value=image_definition, expected_type=type_hints["image_definition"])
            check_type(argname="argument list_stream_definition", value=list_stream_definition, expected_type=type_hints["list_stream_definition"])
            check_type(argname="argument log_stream_definition", value=log_stream_definition, expected_type=type_hints["log_stream_definition"])
            check_type(argname="argument manage_status_definition", value=manage_status_definition, expected_type=type_hints["manage_status_definition"])
            check_type(argname="argument note_definition", value=note_definition, expected_type=type_hints["note_definition"])
            check_type(argname="argument query_table_definition", value=query_table_definition, expected_type=type_hints["query_table_definition"])
            check_type(argname="argument query_value_definition", value=query_value_definition, expected_type=type_hints["query_value_definition"])
            check_type(argname="argument scatterplot_definition", value=scatterplot_definition, expected_type=type_hints["scatterplot_definition"])
            check_type(argname="argument service_level_objective_definition", value=service_level_objective_definition, expected_type=type_hints["service_level_objective_definition"])
            check_type(argname="argument servicemap_definition", value=servicemap_definition, expected_type=type_hints["servicemap_definition"])
            check_type(argname="argument slo_list_definition", value=slo_list_definition, expected_type=type_hints["slo_list_definition"])
            check_type(argname="argument sunburst_definition", value=sunburst_definition, expected_type=type_hints["sunburst_definition"])
            check_type(argname="argument timeseries_definition", value=timeseries_definition, expected_type=type_hints["timeseries_definition"])
            check_type(argname="argument toplist_definition", value=toplist_definition, expected_type=type_hints["toplist_definition"])
            check_type(argname="argument topology_map_definition", value=topology_map_definition, expected_type=type_hints["topology_map_definition"])
            check_type(argname="argument trace_service_definition", value=trace_service_definition, expected_type=type_hints["trace_service_definition"])
            check_type(argname="argument treemap_definition", value=treemap_definition, expected_type=type_hints["treemap_definition"])
            check_type(argname="argument widget_layout", value=widget_layout, expected_type=type_hints["widget_layout"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if alert_graph_definition is not None:
            self._values["alert_graph_definition"] = alert_graph_definition
        if alert_value_definition is not None:
            self._values["alert_value_definition"] = alert_value_definition
        if change_definition is not None:
            self._values["change_definition"] = change_definition
        if check_status_definition is not None:
            self._values["check_status_definition"] = check_status_definition
        if distribution_definition is not None:
            self._values["distribution_definition"] = distribution_definition
        if event_stream_definition is not None:
            self._values["event_stream_definition"] = event_stream_definition
        if event_timeline_definition is not None:
            self._values["event_timeline_definition"] = event_timeline_definition
        if free_text_definition is not None:
            self._values["free_text_definition"] = free_text_definition
        if geomap_definition is not None:
            self._values["geomap_definition"] = geomap_definition
        if group_definition is not None:
            self._values["group_definition"] = group_definition
        if heatmap_definition is not None:
            self._values["heatmap_definition"] = heatmap_definition
        if hostmap_definition is not None:
            self._values["hostmap_definition"] = hostmap_definition
        if iframe_definition is not None:
            self._values["iframe_definition"] = iframe_definition
        if image_definition is not None:
            self._values["image_definition"] = image_definition
        if list_stream_definition is not None:
            self._values["list_stream_definition"] = list_stream_definition
        if log_stream_definition is not None:
            self._values["log_stream_definition"] = log_stream_definition
        if manage_status_definition is not None:
            self._values["manage_status_definition"] = manage_status_definition
        if note_definition is not None:
            self._values["note_definition"] = note_definition
        if query_table_definition is not None:
            self._values["query_table_definition"] = query_table_definition
        if query_value_definition is not None:
            self._values["query_value_definition"] = query_value_definition
        if scatterplot_definition is not None:
            self._values["scatterplot_definition"] = scatterplot_definition
        if service_level_objective_definition is not None:
            self._values["service_level_objective_definition"] = service_level_objective_definition
        if servicemap_definition is not None:
            self._values["servicemap_definition"] = servicemap_definition
        if slo_list_definition is not None:
            self._values["slo_list_definition"] = slo_list_definition
        if sunburst_definition is not None:
            self._values["sunburst_definition"] = sunburst_definition
        if timeseries_definition is not None:
            self._values["timeseries_definition"] = timeseries_definition
        if toplist_definition is not None:
            self._values["toplist_definition"] = toplist_definition
        if topology_map_definition is not None:
            self._values["topology_map_definition"] = topology_map_definition
        if trace_service_definition is not None:
            self._values["trace_service_definition"] = trace_service_definition
        if treemap_definition is not None:
            self._values["treemap_definition"] = treemap_definition
        if widget_layout is not None:
            self._values["widget_layout"] = widget_layout

    @builtins.property
    def alert_graph_definition(
        self,
    ) -> typing.Optional["DashboardWidgetAlertGraphDefinition"]:
        '''alert_graph_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_graph_definition Dashboard#alert_graph_definition}
        '''
        result = self._values.get("alert_graph_definition")
        return typing.cast(typing.Optional["DashboardWidgetAlertGraphDefinition"], result)

    @builtins.property
    def alert_value_definition(
        self,
    ) -> typing.Optional["DashboardWidgetAlertValueDefinition"]:
        '''alert_value_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_value_definition Dashboard#alert_value_definition}
        '''
        result = self._values.get("alert_value_definition")
        return typing.cast(typing.Optional["DashboardWidgetAlertValueDefinition"], result)

    @builtins.property
    def change_definition(self) -> typing.Optional["DashboardWidgetChangeDefinition"]:
        '''change_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_definition Dashboard#change_definition}
        '''
        result = self._values.get("change_definition")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinition"], result)

    @builtins.property
    def check_status_definition(
        self,
    ) -> typing.Optional["DashboardWidgetCheckStatusDefinition"]:
        '''check_status_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check_status_definition Dashboard#check_status_definition}
        '''
        result = self._values.get("check_status_definition")
        return typing.cast(typing.Optional["DashboardWidgetCheckStatusDefinition"], result)

    @builtins.property
    def distribution_definition(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinition"]:
        '''distribution_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#distribution_definition Dashboard#distribution_definition}
        '''
        result = self._values.get("distribution_definition")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinition"], result)

    @builtins.property
    def event_stream_definition(
        self,
    ) -> typing.Optional["DashboardWidgetEventStreamDefinition"]:
        '''event_stream_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_stream_definition Dashboard#event_stream_definition}
        '''
        result = self._values.get("event_stream_definition")
        return typing.cast(typing.Optional["DashboardWidgetEventStreamDefinition"], result)

    @builtins.property
    def event_timeline_definition(
        self,
    ) -> typing.Optional["DashboardWidgetEventTimelineDefinition"]:
        '''event_timeline_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_timeline_definition Dashboard#event_timeline_definition}
        '''
        result = self._values.get("event_timeline_definition")
        return typing.cast(typing.Optional["DashboardWidgetEventTimelineDefinition"], result)

    @builtins.property
    def free_text_definition(
        self,
    ) -> typing.Optional["DashboardWidgetFreeTextDefinition"]:
        '''free_text_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#free_text_definition Dashboard#free_text_definition}
        '''
        result = self._values.get("free_text_definition")
        return typing.cast(typing.Optional["DashboardWidgetFreeTextDefinition"], result)

    @builtins.property
    def geomap_definition(self) -> typing.Optional["DashboardWidgetGeomapDefinition"]:
        '''geomap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#geomap_definition Dashboard#geomap_definition}
        '''
        result = self._values.get("geomap_definition")
        return typing.cast(typing.Optional["DashboardWidgetGeomapDefinition"], result)

    @builtins.property
    def group_definition(self) -> typing.Optional["DashboardWidgetGroupDefinition"]:
        '''group_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_definition Dashboard#group_definition}
        '''
        result = self._values.get("group_definition")
        return typing.cast(typing.Optional["DashboardWidgetGroupDefinition"], result)

    @builtins.property
    def heatmap_definition(self) -> typing.Optional["DashboardWidgetHeatmapDefinition"]:
        '''heatmap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#heatmap_definition Dashboard#heatmap_definition}
        '''
        result = self._values.get("heatmap_definition")
        return typing.cast(typing.Optional["DashboardWidgetHeatmapDefinition"], result)

    @builtins.property
    def hostmap_definition(self) -> typing.Optional["DashboardWidgetHostmapDefinition"]:
        '''hostmap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hostmap_definition Dashboard#hostmap_definition}
        '''
        result = self._values.get("hostmap_definition")
        return typing.cast(typing.Optional["DashboardWidgetHostmapDefinition"], result)

    @builtins.property
    def iframe_definition(self) -> typing.Optional["DashboardWidgetIframeDefinition"]:
        '''iframe_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#iframe_definition Dashboard#iframe_definition}
        '''
        result = self._values.get("iframe_definition")
        return typing.cast(typing.Optional["DashboardWidgetIframeDefinition"], result)

    @builtins.property
    def image_definition(self) -> typing.Optional["DashboardWidgetImageDefinition"]:
        '''image_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_definition Dashboard#image_definition}
        '''
        result = self._values.get("image_definition")
        return typing.cast(typing.Optional["DashboardWidgetImageDefinition"], result)

    @builtins.property
    def list_stream_definition(
        self,
    ) -> typing.Optional["DashboardWidgetListStreamDefinition"]:
        '''list_stream_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#list_stream_definition Dashboard#list_stream_definition}
        '''
        result = self._values.get("list_stream_definition")
        return typing.cast(typing.Optional["DashboardWidgetListStreamDefinition"], result)

    @builtins.property
    def log_stream_definition(
        self,
    ) -> typing.Optional["DashboardWidgetLogStreamDefinition"]:
        '''log_stream_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_stream_definition Dashboard#log_stream_definition}
        '''
        result = self._values.get("log_stream_definition")
        return typing.cast(typing.Optional["DashboardWidgetLogStreamDefinition"], result)

    @builtins.property
    def manage_status_definition(
        self,
    ) -> typing.Optional["DashboardWidgetManageStatusDefinition"]:
        '''manage_status_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#manage_status_definition Dashboard#manage_status_definition}
        '''
        result = self._values.get("manage_status_definition")
        return typing.cast(typing.Optional["DashboardWidgetManageStatusDefinition"], result)

    @builtins.property
    def note_definition(self) -> typing.Optional["DashboardWidgetNoteDefinition"]:
        '''note_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#note_definition Dashboard#note_definition}
        '''
        result = self._values.get("note_definition")
        return typing.cast(typing.Optional["DashboardWidgetNoteDefinition"], result)

    @builtins.property
    def query_table_definition(
        self,
    ) -> typing.Optional["DashboardWidgetQueryTableDefinition"]:
        '''query_table_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query_table_definition Dashboard#query_table_definition}
        '''
        result = self._values.get("query_table_definition")
        return typing.cast(typing.Optional["DashboardWidgetQueryTableDefinition"], result)

    @builtins.property
    def query_value_definition(
        self,
    ) -> typing.Optional["DashboardWidgetQueryValueDefinition"]:
        '''query_value_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query_value_definition Dashboard#query_value_definition}
        '''
        result = self._values.get("query_value_definition")
        return typing.cast(typing.Optional["DashboardWidgetQueryValueDefinition"], result)

    @builtins.property
    def scatterplot_definition(
        self,
    ) -> typing.Optional["DashboardWidgetScatterplotDefinition"]:
        '''scatterplot_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#scatterplot_definition Dashboard#scatterplot_definition}
        '''
        result = self._values.get("scatterplot_definition")
        return typing.cast(typing.Optional["DashboardWidgetScatterplotDefinition"], result)

    @builtins.property
    def service_level_objective_definition(
        self,
    ) -> typing.Optional["DashboardWidgetServiceLevelObjectiveDefinition"]:
        '''service_level_objective_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service_level_objective_definition Dashboard#service_level_objective_definition}
        '''
        result = self._values.get("service_level_objective_definition")
        return typing.cast(typing.Optional["DashboardWidgetServiceLevelObjectiveDefinition"], result)

    @builtins.property
    def servicemap_definition(
        self,
    ) -> typing.Optional["DashboardWidgetServicemapDefinition"]:
        '''servicemap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#servicemap_definition Dashboard#servicemap_definition}
        '''
        result = self._values.get("servicemap_definition")
        return typing.cast(typing.Optional["DashboardWidgetServicemapDefinition"], result)

    @builtins.property
    def slo_list_definition(
        self,
    ) -> typing.Optional["DashboardWidgetSloListDefinition"]:
        '''slo_list_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#slo_list_definition Dashboard#slo_list_definition}
        '''
        result = self._values.get("slo_list_definition")
        return typing.cast(typing.Optional["DashboardWidgetSloListDefinition"], result)

    @builtins.property
    def sunburst_definition(
        self,
    ) -> typing.Optional["DashboardWidgetSunburstDefinition"]:
        '''sunburst_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sunburst_definition Dashboard#sunburst_definition}
        '''
        result = self._values.get("sunburst_definition")
        return typing.cast(typing.Optional["DashboardWidgetSunburstDefinition"], result)

    @builtins.property
    def timeseries_definition(
        self,
    ) -> typing.Optional["DashboardWidgetTimeseriesDefinition"]:
        '''timeseries_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeseries_definition Dashboard#timeseries_definition}
        '''
        result = self._values.get("timeseries_definition")
        return typing.cast(typing.Optional["DashboardWidgetTimeseriesDefinition"], result)

    @builtins.property
    def toplist_definition(self) -> typing.Optional["DashboardWidgetToplistDefinition"]:
        '''toplist_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#toplist_definition Dashboard#toplist_definition}
        '''
        result = self._values.get("toplist_definition")
        return typing.cast(typing.Optional["DashboardWidgetToplistDefinition"], result)

    @builtins.property
    def topology_map_definition(
        self,
    ) -> typing.Optional["DashboardWidgetTopologyMapDefinition"]:
        '''topology_map_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#topology_map_definition Dashboard#topology_map_definition}
        '''
        result = self._values.get("topology_map_definition")
        return typing.cast(typing.Optional["DashboardWidgetTopologyMapDefinition"], result)

    @builtins.property
    def trace_service_definition(
        self,
    ) -> typing.Optional["DashboardWidgetTraceServiceDefinition"]:
        '''trace_service_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#trace_service_definition Dashboard#trace_service_definition}
        '''
        result = self._values.get("trace_service_definition")
        return typing.cast(typing.Optional["DashboardWidgetTraceServiceDefinition"], result)

    @builtins.property
    def treemap_definition(self) -> typing.Optional["DashboardWidgetTreemapDefinition"]:
        '''treemap_definition block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#treemap_definition Dashboard#treemap_definition}
        '''
        result = self._values.get("treemap_definition")
        return typing.cast(typing.Optional["DashboardWidgetTreemapDefinition"], result)

    @builtins.property
    def widget_layout(self) -> typing.Optional["DashboardWidgetWidgetLayout"]:
        '''widget_layout block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget_layout Dashboard#widget_layout}
        '''
        result = self._values.get("widget_layout")
        return typing.cast(typing.Optional["DashboardWidgetWidgetLayout"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidget(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetAlertGraphDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "alert_id": "alertId",
        "viz_type": "vizType",
        "live_span": "liveSpan",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetAlertGraphDefinition:
    def __init__(
        self,
        *,
        alert_id: builtins.str,
        viz_type: builtins.str,
        live_span: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alert_id: The ID of the monitor used by the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
        :param viz_type: Type of visualization to use when displaying the widget. Valid values are ``timeseries``, ``toplist``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#viz_type Dashboard#viz_type}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e91ac4e74e701c5db48dc3a419c2855bf6c217808e345e223ca678bd501ab0c0)
            check_type(argname="argument alert_id", value=alert_id, expected_type=type_hints["alert_id"])
            check_type(argname="argument viz_type", value=viz_type, expected_type=type_hints["viz_type"])
            check_type(argname="argument live_span", value=live_span, expected_type=type_hints["live_span"])
            check_type(argname="argument title", value=title, expected_type=type_hints["title"])
            check_type(argname="argument title_align", value=title_align, expected_type=type_hints["title_align"])
            check_type(argname="argument title_size", value=title_size, expected_type=type_hints["title_size"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "alert_id": alert_id,
            "viz_type": viz_type,
        }
        if live_span is not None:
            self._values["live_span"] = live_span
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def alert_id(self) -> builtins.str:
        '''The ID of the monitor used by the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
        '''
        result = self._values.get("alert_id")
        assert result is not None, "Required property 'alert_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def viz_type(self) -> builtins.str:
        '''Type of visualization to use when displaying the widget. Valid values are ``timeseries``, ``toplist``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#viz_type Dashboard#viz_type}
        '''
        result = self._values.get("viz_type")
        assert result is not None, "Required property 'viz_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetAlertGraphDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetAlertGraphDefinitionOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetAlertGraphDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9b7ffd2b46491452ac4893e619f82980ea50b2da589930be365e6ced3c183665)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property
    @jsii.member(jsii_name="alertIdInput")
    def alert_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "alertIdInput"))

    @builtins.property
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property
    @jsii.member(jsii_name="vizTypeInput")
    def viz_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "vizTypeInput"))

    @builtins.property
    @jsii.member(jsii_name="alertId")
    def alert_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "alertId"))

    @alert_id.setter
    def alert_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8c2dafd4431f38b83cb4cb8ca24f582a3e98dddc4b1962ca7c9fc454361a7cd5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "alertId", value)

    @builtins.property
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8115220e99660c7ea27c7c3d557b9e7326cc691175b1dce462d3e53fc4c04a2a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "liveSpan", value)

    @builtins.property
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ae949a8de6b3019f8383795da330d454b46f5268beac57d3328b897ee6829db)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "title", value)

    @builtins.property
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f48631ed4bb9217343ea4b439fbeca8c16deea24f7a506ad2ee4c9b212e49163)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "titleAlign", value)

    @builtins.property
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c5e737182d9a867b3c36245853e3b93f5afb7e8f913f8c38ebc637fa4bf56b4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "titleSize", value)

    @builtins.property
    @jsii.member(jsii_name="vizType")
    def viz_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "vizType"))

    @viz_type.setter
    def viz_type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__69f5d804e948d8afa5e7ffb0716240e082d2d75ae8fea72fa462581e3790857e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vizType", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetAlertGraphDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetAlertGraphDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetAlertGraphDefinition],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff4d0e8605f809dd92f334b82a03d854882b422231c3147e570325c391a1d2a9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetAlertValueDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "alert_id": "alertId",
        "precision": "precision",
        "text_align": "textAlign",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
        "unit": "unit",
    },
)
class DashboardWidgetAlertValueDefinition:
    def __init__(
        self,
        *,
        alert_id: builtins.str,
        precision: typing.Optional[jsii.Number] = None,
        text_align: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
        unit: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alert_id: The ID of the monitor used by the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
        :param precision: The precision to use when displaying the value. Use ``*`` for maximum precision. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#precision Dashboard#precision}
        :param text_align: The alignment of the text in the widget. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        :param unit: The unit for the value displayed in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#unit Dashboard#unit}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9992c9212cacf89d5877da9b632a6319472ef14811d6805246c2d1709e75cb0a)
            check_type(argname="argument alert_id", value=alert_id, expected_type=type_hints["alert_id"])
            check_type(argname="argument precision", value=precision, expected_type=type_hints["precision"])
            check_type(argname="argument text_align", value=text_align, expected_type=type_hints["text_align"])
            check_type(argname="argument title", value=title, expected_type=type_hints["title"])
            check_type(argname="argument title_align", value=title_align, expected_type=type_hints["title_align"])
            check_type(argname="argument title_size", value=title_size, expected_type=type_hints["title_size"])
            check_type(argname="argument unit", value=unit, expected_type=type_hints["unit"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "alert_id": alert_id,
        }
        if precision is not None:
            self._values["precision"] = precision
        if text_align is not None:
            self._values["text_align"] = text_align
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size
        if unit is not None:
            self._values["unit"] = unit

    @builtins.property
    def alert_id(self) -> builtins.str:
        '''The ID of the monitor used by the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
        '''
        result = self._values.get("alert_id")
        assert result is not None, "Required property 'alert_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def precision(self) -> typing.Optional[jsii.Number]:
        '''The precision to use when displaying the value. Use ``*`` for maximum precision.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#precision Dashboard#precision}
        '''
        result = self._values.get("precision")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def text_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the text in the widget. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
        '''
        result = self._values.get("text_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unit(self) -> typing.Optional[builtins.str]:
        '''The unit for the value displayed in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#unit Dashboard#unit}
        '''
        result = self._values.get("unit")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetAlertValueDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetAlertValueDefinitionOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetAlertValueDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__edff53fc88fd93c4387acaa581bd83ed718581e647fa66a4cfb1e0639c58aebc)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetPrecision")
    def reset_precision(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrecision", []))

    @jsii.member(jsii_name="resetTextAlign")
    def reset_text_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTextAlign", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @jsii.member(jsii_name="resetUnit")
    def reset_unit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUnit", []))

    @builtins.property
    @jsii.member(jsii_name="alertIdInput")
    def alert_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "alertIdInput"))

    @builtins.property
    @jsii.member(jsii_name="precisionInput")
    def precision_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "precisionInput"))

    @builtins.property
    @jsii.member(jsii_name="textAlignInput")
    def text_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "textAlignInput"))

    @builtins.property
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property
    @jsii.member(jsii_name="unitInput")
    def unit_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "unitInput"))

    @builtins.property
    @jsii.member(jsii_name="alertId")
    def alert_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "alertId"))

    @alert_id.setter
    def alert_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0cec9496542245761504112d6d269fd06865e2056e3da6806553227f6b1dd863)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "alertId", value)

    @builtins.property
    @jsii.member(jsii_name="precision")
    def precision(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "precision"))

    @precision.setter
    def precision(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__113c451549bc95fc803cb9364774f5d41ef263f520f0c64d334c62e604d1a703)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "precision", value)

    @builtins.property
    @jsii.member(jsii_name="textAlign")
    def text_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "textAlign"))

    @text_align.setter
    def text_align(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0d0586dd6f58a75c8b05a78cf421688a4cf7af22027dca447589e9e68adba07c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "textAlign", value)

    @builtins.property
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3fbac8aa4bcf45824442c09b6f35ad31e4e0ce6b3145410bb6f4dc4c1b8c738c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "title", value)

    @builtins.property
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__21c5f1489ce1d80383dc884eca96428bfd92b0611e9072712d29bcf1deee5a0d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "titleAlign", value)

    @builtins.property
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b409e4da2bd1b5f542307d2ab7062d79dbc081d7704c22c2a6e9f71ea8ec7914)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "titleSize", value)

    @builtins.property
    @jsii.member(jsii_name="unit")
    def unit(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "unit"))

    @unit.setter
    def unit(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f0f54d2f812738ec396eae0851f3cf50b5cba8b723767e9ac5eebe1dee5e078a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "unit", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetAlertValueDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetAlertValueDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetAlertValueDefinition],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__921d305901c933a60c9cc9368836ebc6a80fb9d2677f7832497797c589112451)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "custom_link": "customLink",
        "live_span": "liveSpan",
        "request": "request",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetChangeDefinition:
    def __init__(
        self,
        *,
        custom_link: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionCustomLink", typing.Dict[builtins.str, typing.Any]]]]] = None,
        live_span: typing.Optional[builtins.str] = None,
        request: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequest", typing.Dict[builtins.str, typing.Any]]]]] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param custom_link: custom_link block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param request: request block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__524dd694d18c6c398b50afec55031cabb69e4057157ec7610807d21ce112678f)
            check_type(argname="argument custom_link", value=custom_link, expected_type=type_hints["custom_link"])
            check_type(argname="argument live_span", value=live_span, expected_type=type_hints["live_span"])
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
            check_type(argname="argument title", value=title, expected_type=type_hints["title"])
            check_type(argname="argument title_align", value=title_align, expected_type=type_hints["title_align"])
            check_type(argname="argument title_size", value=title_size, expected_type=type_hints["title_size"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if custom_link is not None:
            self._values["custom_link"] = custom_link
        if live_span is not None:
            self._values["live_span"] = live_span
        if request is not None:
            self._values["request"] = request
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def custom_link(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionCustomLink"]]]:
        '''custom_link block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
        '''
        result = self._values.get("custom_link")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionCustomLink"]]], result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def request(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequest"]]]:
        '''request block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
        '''
        result = self._values.get("request")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequest"]]], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionCustomLink",
    jsii_struct_bases=[],
    name_mapping={
        "is_hidden": "isHidden",
        "label": "label",
        "link": "link",
        "override_label": "overrideLabel",
    },
)
class DashboardWidgetChangeDefinitionCustomLink:
    def __init__(
        self,
        *,
        is_hidden: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        label: typing.Optional[builtins.str] = None,
        link: typing.Optional[builtins.str] = None,
        override_label: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param is_hidden: The flag for toggling context menu link visibility. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
        :param label: The label for the custom link URL. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
        :param link: The URL of the custom link. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
        :param override_label: The label id that refers to a context menu link item. When override_label is provided, the client request omits the label field. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8fb687bf97464318982df7c5bd462c52a80a43caa1a017067c972c5390a0aba1)
            check_type(argname="argument is_hidden", value=is_hidden, expected_type=type_hints["is_hidden"])
            check_type(argname="argument label", value=label, expected_type=type_hints["label"])
            check_type(argname="argument link", value=link, expected_type=type_hints["link"])
            check_type(argname="argument override_label", value=override_label, expected_type=type_hints["override_label"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if is_hidden is not None:
            self._values["is_hidden"] = is_hidden
        if label is not None:
            self._values["label"] = label
        if link is not None:
            self._values["link"] = link
        if override_label is not None:
            self._values["override_label"] = override_label

    @builtins.property
    def is_hidden(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        '''The flag for toggling context menu link visibility.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
        '''
        result = self._values.get("is_hidden")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], result)

    @builtins.property
    def label(self) -> typing.Optional[builtins.str]:
        '''The label for the custom link URL.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
        '''
        result = self._values.get("label")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def link(self) -> typing.Optional[builtins.str]:
        '''The URL of the custom link.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
        '''
        result = self._values.get("link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def override_label(self) -> typing.Optional[builtins.str]:
        '''The label id that refers to a context menu link item.

        When override_label is provided, the client request omits the label field.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
        '''
        result = self._values.get("override_label")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionCustomLink(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionCustomLinkList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionCustomLinkList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ead8dfd6ed645d66d20a2500316aa3406efa7ba1edc7a6723fb3ed18700b7bea)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionCustomLinkOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b4f23f7ed3fc631ea751f36d6127fda06dd0a172822438a6bd12b1200577694e)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionCustomLinkOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ab83580e8efa969866059eaa8b437346eda941f876c4e06d31e2a64988ae8085)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b14863effcb9efd6b46ae3932713576ce1f2a02b30c86e46197421cb0200007e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1387c317e36d287141c7d10ce3b485cf5e41e12abce229bb76e7dd0e85af254d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionCustomLink]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionCustomLink]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionCustomLink]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8aa23eab5a1a42e2e7830ffa8af58d3c570338c6375adc8454eef6d527bb1f0e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionCustomLinkOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionCustomLinkOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f37a4aab5b3a642eef829d35b7e22b98bd80cd9a4d4d7ad9ea03789e90ad3f52)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetIsHidden")
    def reset_is_hidden(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsHidden", []))

    @jsii.member(jsii_name="resetLabel")
    def reset_label(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLabel", []))

    @jsii.member(jsii_name="resetLink")
    def reset_link(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLink", []))

    @jsii.member(jsii_name="resetOverrideLabel")
    def reset_override_label(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOverrideLabel", []))

    @builtins.property
    @jsii.member(jsii_name="isHiddenInput")
    def is_hidden_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "isHiddenInput"))

    @builtins.property
    @jsii.member(jsii_name="labelInput")
    def label_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "labelInput"))

    @builtins.property
    @jsii.member(jsii_name="linkInput")
    def link_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "linkInput"))

    @builtins.property
    @jsii.member(jsii_name="overrideLabelInput")
    def override_label_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "overrideLabelInput"))

    @builtins.property
    @jsii.member(jsii_name="isHidden")
    def is_hidden(self) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "isHidden"))

    @is_hidden.setter
    def is_hidden(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4b68fefd51939254236d1cbc0f022d2ee0b352514546935fba18a1b756c9dbb8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "isHidden", value)

    @builtins.property
    @jsii.member(jsii_name="label")
    def label(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "label"))

    @label.setter
    def label(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4758b6dff12203faacd72c190afbfd55121ff958ae78b6bcfb5d30556bb4b29b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "label", value)

    @builtins.property
    @jsii.member(jsii_name="link")
    def link(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "link"))

    @link.setter
    def link(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c1fe43aaef89f9d390bf199914e30c453ac8837d7c77ceac56c662e85eee286)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "link", value)

    @builtins.property
    @jsii.member(jsii_name="overrideLabel")
    def override_label(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "overrideLabel"))

    @override_label.setter
    def override_label(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__781a3193c577d112e0d09a306e1382ced82d4979e3b4cb72b136cb566634ab41)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "overrideLabel", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionCustomLink, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionCustomLink, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionCustomLink, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__db10695145249e1998acd7a7b9c7f66a923ecd933559921141ab9e1705efcbcd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ad64c5f6b847b6146ae15949f3e77d2579eeeccf959bae9bf8f3006a1fc9e8a7)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putCustomLink")
    def put_custom_link(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionCustomLink, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__14e10527224fa451888117c87b5077f31d2bcf5c604b1294fd628f7167e2f3c7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putCustomLink", [value]))

    @jsii.member(jsii_name="putRequest")
    def put_request(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequest", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__25216cfdd7a3c8c055041d27e937d0eab95ebc8f909fbfe0d81407d57813f6cc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putRequest", [value]))

    @jsii.member(jsii_name="resetCustomLink")
    def reset_custom_link(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCustomLink", []))

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetRequest")
    def reset_request(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRequest", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property
    @jsii.member(jsii_name="customLink")
    def custom_link(self) -> DashboardWidgetChangeDefinitionCustomLinkList:
        return typing.cast(DashboardWidgetChangeDefinitionCustomLinkList, jsii.get(self, "customLink"))

    @builtins.property
    @jsii.member(jsii_name="request")
    def request(self) -> "DashboardWidgetChangeDefinitionRequestList":
        return typing.cast("DashboardWidgetChangeDefinitionRequestList", jsii.get(self, "request"))

    @builtins.property
    @jsii.member(jsii_name="customLinkInput")
    def custom_link_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionCustomLink]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionCustomLink]]], jsii.get(self, "customLinkInput"))

    @builtins.property
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property
    @jsii.member(jsii_name="requestInput")
    def request_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequest"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequest"]]], jsii.get(self, "requestInput"))

    @builtins.property
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e190a6227c6c79075f60643f9b123435bffccd9868b4428b6f4531a325220c20)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "liveSpan", value)

    @builtins.property
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e24986fb7596f3eea4d1c1ab0039fa03431247ec0cedfe946ec1881423182222)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "title", value)

    @builtins.property
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f2650cb1394d743947c87d546b1c819a7d38a341362268382aae2171ebd7e9c2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "titleAlign", value)

    @builtins.property
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2642842d77ab42f2be2761fbfdcd01b18a550adb6ad430cace8df03557cf86fa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "titleSize", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetChangeDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinition],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a17e9312fbd4a252974d407a79468b70615d771fae3cdb95ef1cdee1cad4486f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequest",
    jsii_struct_bases=[],
    name_mapping={
        "apm_query": "apmQuery",
        "change_type": "changeType",
        "compare_to": "compareTo",
        "formula": "formula",
        "increase_good": "increaseGood",
        "log_query": "logQuery",
        "order_by": "orderBy",
        "order_dir": "orderDir",
        "process_query": "processQuery",
        "q": "q",
        "query": "query",
        "rum_query": "rumQuery",
        "security_query": "securityQuery",
        "show_present": "showPresent",
    },
)
class DashboardWidgetChangeDefinitionRequest:
    def __init__(
        self,
        *,
        apm_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestApmQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        change_type: typing.Optional[builtins.str] = None,
        compare_to: typing.Optional[builtins.str] = None,
        formula: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestFormula", typing.Dict[builtins.str, typing.Any]]]]] = None,
        increase_good: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        log_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestLogQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        order_by: typing.Optional[builtins.str] = None,
        order_dir: typing.Optional[builtins.str] = None,
        process_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestProcessQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        q: typing.Optional[builtins.str] = None,
        query: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestQuery", typing.Dict[builtins.str, typing.Any]]]]] = None,
        rum_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestRumQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        security_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestSecurityQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        show_present: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
    ) -> None:
        '''
        :param apm_query: apm_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
        :param change_type: Whether to show absolute or relative change. Valid values are ``absolute``, ``relative``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_type Dashboard#change_type}
        :param compare_to: Choose from when to compare current data to. Valid values are ``hour_before``, ``day_before``, ``week_before``, ``month_before``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compare_to Dashboard#compare_to}
        :param formula: formula block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
        :param increase_good: A Boolean indicating whether an increase in the value is good (displayed in green) or not (displayed in red). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#increase_good Dashboard#increase_good}
        :param log_query: log_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
        :param order_by: What to order by. Valid values are ``change``, ``name``, ``present``, ``past``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_by Dashboard#order_by}
        :param order_dir: Widget sorting method. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_dir Dashboard#order_dir}
        :param process_query: process_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        :param q: The metric query to use for this widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
        :param query: query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        :param rum_query: rum_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
        :param security_query: security_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
        :param show_present: If set to ``true``, displays the current value. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_present Dashboard#show_present}
        '''
        if isinstance(apm_query, dict):
            apm_query = DashboardWidgetChangeDefinitionRequestApmQuery(**apm_query)
        if isinstance(log_query, dict):
            log_query = DashboardWidgetChangeDefinitionRequestLogQuery(**log_query)
        if isinstance(process_query, dict):
            process_query = DashboardWidgetChangeDefinitionRequestProcessQuery(**process_query)
        if isinstance(rum_query, dict):
            rum_query = DashboardWidgetChangeDefinitionRequestRumQuery(**rum_query)
        if isinstance(security_query, dict):
            security_query = DashboardWidgetChangeDefinitionRequestSecurityQuery(**security_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__86ec9cadb55f6352720c7e1f38ff78e319949fb7f86a0ededbe5d2e4a511e33e)
            check_type(argname="argument apm_query", value=apm_query, expected_type=type_hints["apm_query"])
            check_type(argname="argument change_type", value=change_type, expected_type=type_hints["change_type"])
            check_type(argname="argument compare_to", value=compare_to, expected_type=type_hints["compare_to"])
            check_type(argname="argument formula", value=formula, expected_type=type_hints["formula"])
            check_type(argname="argument increase_good", value=increase_good, expected_type=type_hints["increase_good"])
            check_type(argname="argument log_query", value=log_query, expected_type=type_hints["log_query"])
            check_type(argname="argument order_by", value=order_by, expected_type=type_hints["order_by"])
            check_type(argname="argument order_dir", value=order_dir, expected_type=type_hints["order_dir"])
            check_type(argname="argument process_query", value=process_query, expected_type=type_hints["process_query"])
            check_type(argname="argument q", value=q, expected_type=type_hints["q"])
            check_type(argname="argument query", value=query, expected_type=type_hints["query"])
            check_type(argname="argument rum_query", value=rum_query, expected_type=type_hints["rum_query"])
            check_type(argname="argument security_query", value=security_query, expected_type=type_hints["security_query"])
            check_type(argname="argument show_present", value=show_present, expected_type=type_hints["show_present"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if apm_query is not None:
            self._values["apm_query"] = apm_query
        if change_type is not None:
            self._values["change_type"] = change_type
        if compare_to is not None:
            self._values["compare_to"] = compare_to
        if formula is not None:
            self._values["formula"] = formula
        if increase_good is not None:
            self._values["increase_good"] = increase_good
        if log_query is not None:
            self._values["log_query"] = log_query
        if order_by is not None:
            self._values["order_by"] = order_by
        if order_dir is not None:
            self._values["order_dir"] = order_dir
        if process_query is not None:
            self._values["process_query"] = process_query
        if q is not None:
            self._values["q"] = q
        if query is not None:
            self._values["query"] = query
        if rum_query is not None:
            self._values["rum_query"] = rum_query
        if security_query is not None:
            self._values["security_query"] = security_query
        if show_present is not None:
            self._values["show_present"] = show_present

    @builtins.property
    def apm_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestApmQuery"]:
        '''apm_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
        '''
        result = self._values.get("apm_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestApmQuery"], result)

    @builtins.property
    def change_type(self) -> typing.Optional[builtins.str]:
        '''Whether to show absolute or relative change. Valid values are ``absolute``, ``relative``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_type Dashboard#change_type}
        '''
        result = self._values.get("change_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def compare_to(self) -> typing.Optional[builtins.str]:
        '''Choose from when to compare current data to. Valid values are ``hour_before``, ``day_before``, ``week_before``, ``month_before``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compare_to Dashboard#compare_to}
        '''
        result = self._values.get("compare_to")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def formula(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestFormula"]]]:
        '''formula block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
        '''
        result = self._values.get("formula")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestFormula"]]], result)

    @builtins.property
    def increase_good(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        '''A Boolean indicating whether an increase in the value is good (displayed in green) or not (displayed in red).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#increase_good Dashboard#increase_good}
        '''
        result = self._values.get("increase_good")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], result)

    @builtins.property
    def log_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestLogQuery"]:
        '''log_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
        '''
        result = self._values.get("log_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestLogQuery"], result)

    @builtins.property
    def order_by(self) -> typing.Optional[builtins.str]:
        '''What to order by. Valid values are ``change``, ``name``, ``present``, ``past``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_by Dashboard#order_by}
        '''
        result = self._values.get("order_by")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def order_dir(self) -> typing.Optional[builtins.str]:
        '''Widget sorting method. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_dir Dashboard#order_dir}
        '''
        result = self._values.get("order_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def process_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestProcessQuery"]:
        '''process_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        '''
        result = self._values.get("process_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestProcessQuery"], result)

    @builtins.property
    def q(self) -> typing.Optional[builtins.str]:
        '''The metric query to use for this widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
        '''
        result = self._values.get("q")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def query(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQuery"]]]:
        '''query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        result = self._values.get("query")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQuery"]]], result)

    @builtins.property
    def rum_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestRumQuery"]:
        '''rum_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
        '''
        result = self._values.get("rum_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestRumQuery"], result)

    @builtins.property
    def security_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQuery"]:
        '''security_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
        '''
        result = self._values.get("security_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQuery"], result)

    @builtins.property
    def show_present(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        '''If set to ``true``, displays the current value.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_present Dashboard#show_present}
        '''
        result = self._values.get("show_present")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequest(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestApmQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetChangeDefinitionRequestApmQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestApmQueryGroupBy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute", typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery(**compute_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c8d8bc7a2dc9422ecf34fc2435b0c146d3ad4a26e8f5cbc879d16f737917c2b)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
            check_type(argname="argument compute_query", value=compute_query, expected_type=type_hints["compute_query"])
            check_type(argname="argument group_by", value=group_by, expected_type=type_hints["group_by"])
            check_type(argname="argument multi_compute", value=multi_compute, expected_type=type_hints["multi_compute"])
            check_type(argname="argument search_query", value=search_query, expected_type=type_hints["search_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestApmQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestApmQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestApmQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__047aa1d6c5b4087a83d06ec5fd65de7ffd574133f3610eb649e96ba3d66123f8)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c7d6780142afaf6738d3cb0a45ea23b8856aac890328f1cccbd22700bbc4430)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e901dd2e51489bc7dc87cec66b31eb80bd44ab920f65269f269b83e013f14097)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__caf51ff22b55f0563a8f1b6ddf01d27cbce4adaca73ede67444829e5e46b79db)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6f0cc73b69221e90fe470934fe539ecdad1e1bf47243a98a652c25ba2f3157cf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2a5ee5457ce06392df6d23b7bfbdbff00c0d05f4213dcd7a4a744ec3baaa6b9a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestApmQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetChangeDefinitionRequestApmQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery(**sort_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eea6adca4a48a6524ae20c054eac89600f741313940450deeec1061297a1f197)
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument sort_query", value=sort_query, expected_type=type_hints["sort_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestApmQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestApmQueryGroupByList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestApmQueryGroupByList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__037a67ea7b26e9bacf9f59cdeb9edb759452a63dbf888eb19de72d5afe47ccc7)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestApmQueryGroupByOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a3e021336aecc5eb5708bf71503e0ba32b8b649a8d0cb9ba7b11ab40a96d1f7d)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestApmQueryGroupByOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__429e5a2614b0bd47f8e02311859c4bc02e832d452c7de538da22d9353fd04953)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__28c29b63c229258770a3f329826b4e3ff26853ecb9462407a396a50a1dc0b7c3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__41ac62f39c169ee6307a6649944417d00f2bf892d8062e240db6d275c3075d82)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__090c3fba06f202c055f043be0753efafc988b776c8957a36550927e0e2827850)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestApmQueryGroupByOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestApmQueryGroupByOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01aac91617a6a586e745357deb2d1f0e7d220f7c90056e5e65b28aa6b857781f)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putSortQuery")
    def put_sort_query(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        value = DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery(
            aggregation=aggregation, order=order, facet=facet
        )

        return typing.cast(None, jsii.invoke(self, "putSortQuery", [value]))

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSortQuery")
    def reset_sort_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSortQuery", []))

    @builtins.property
    @jsii.member(jsii_name="sortQuery")
    def sort_query(
        self,
    ) -> "DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference":
        return typing.cast("DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference", jsii.get(self, "sortQuery"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property
    @jsii.member(jsii_name="sortQueryInput")
    def sort_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery"], jsii.get(self, "sortQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3171ca9b664d69b9db6504caad8f1683cda3cc200643bc9faaba03663143be60)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7b70f4b18371cbbbd8f28fcd3ddf5bc513aad498bb5c7d53170d19c9ab2b370b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "limit", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__880882ea8dfe9a6edc476ffaa02ffccfc4dbfffb7a16d450d700cd9168b3ca4c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c73997b2915205914f6ca5ac737b905d681623d7f34070434972a99184ca8a5)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument order", value=order, expected_type=type_hints["order"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d095252529a942d32c48c4b37b49c5e7fa64303628dde06f35e1146abb690077)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7d7d9eee90ce57209a0b6349b19d38407fe24d4b9a0a2652e8cc2af29bfa7da6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ba7444199d09c46a83419cbd89094d8e4d4c809630d421be7aeb5a6f09e9e8e3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2e8b33271b864e37f61c0dbce7aa193f70c27b5a9aa16c58fd658f941566b423)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "order", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d776b8e0027ba98666909bbdb21d62fd73408564a3afc1b4d9f0b85ca1cb199)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e13ecdcf8a686bcedcf6c8f1349ae481a2dcdf052f4aad30cc271e428593ce64)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestApmQueryMultiComputeList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestApmQueryMultiComputeList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__daad0c132016ffd76b4cf2c052ad0ada7c16b63fc61003f9df8c07a7af2538a4)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestApmQueryMultiComputeOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1841c46db6eea4f362e00924c8c1d9226974915c6a403698a9c7cc02552eeb1c)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestApmQueryMultiComputeOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c13474bc8a5563141aacb93b066c44b8bfc47d157adf1a0eecdb5eabc5990351)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb74ea21749e5a747900696b9e72f9009b3dc9f1c85815e8af51828c1704c063)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__310e738568276b50312e4dfa7523b7deb566c6fcb3b07eb72496a298b370beb7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8326d416b2e19e8fbc07a49601f6bff1ddce19bab5364d3a3aba211f118f1735)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestApmQueryMultiComputeOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestApmQueryMultiComputeOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__122bd1adafb2cbea2e1359dc44938ad61db3789ac1d6a951c6cb922e8225e7d4)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3e9c1571a423c8c0ac2d75b461391178c0a0dd28c39e56f2426b1993463480f4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__67793d71fcbfe66620b41093b40e678071cafd6149363615130321d547b76585)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__731654755a4b2ece9444635ef089080a3c12f6782d76b377694bd52e2003f31b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d080cd7ce9a28fba9787701e98f690cd0cb8c4de71524e3263dca4d331021f29)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestApmQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestApmQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a0ec5b7d681d4d0d3e7b082f300db94469b9d3183d64529c6315ee5f7684918a)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="putGroupBy")
    def put_group_by(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3fefd8a35fce645855731b6218e433b4e2ec33cdd6b03236674f8b1276ee9ecd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putGroupBy", [value]))

    @jsii.member(jsii_name="putMultiCompute")
    def put_multi_compute(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fbc2b0d05dfadace695361a43e7c7b78289e180b51efd0ac37468003fb98662f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putMultiCompute", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property
    @jsii.member(jsii_name="groupBy")
    def group_by(self) -> DashboardWidgetChangeDefinitionRequestApmQueryGroupByList:
        return typing.cast(DashboardWidgetChangeDefinitionRequestApmQueryGroupByList, jsii.get(self, "groupBy"))

    @builtins.property
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestApmQueryMultiComputeList:
        return typing.cast(DashboardWidgetChangeDefinitionRequestApmQueryMultiComputeList, jsii.get(self, "multiCompute"))

    @builtins.property
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__52229c2d853841bafed1a80bdbaf475e108f16ddd005d151898cac467d8ba9e7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "index", value)

    @builtins.property
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c5600a958388bd0eb4da03395d18fb797d6394a05fcc9d2e7535602a6739850c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "searchQuery", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestApmQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestApmQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestApmQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__656e15c70a43aac998f9f2ab0c32f6e36662844cc2715caffe25fc098050ff86)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestFormula",
    jsii_struct_bases=[],
    name_mapping={
        "formula_expression": "formulaExpression",
        "alias": "alias",
        "cell_display_mode": "cellDisplayMode",
        "conditional_formats": "conditionalFormats",
        "limit": "limit",
        "style": "style",
    },
)
class DashboardWidgetChangeDefinitionRequestFormula:
    def __init__(
        self,
        *,
        formula_expression: builtins.str,
        alias: typing.Optional[builtins.str] = None,
        cell_display_mode: typing.Optional[builtins.str] = None,
        conditional_formats: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats", typing.Dict[builtins.str, typing.Any]]]]] = None,
        limit: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestFormulaLimit", typing.Dict[builtins.str, typing.Any]]] = None,
        style: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestFormulaStyle", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param formula_expression: A string expression built from queries, formulas, and functions. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
        :param alias: An expression alias. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
        :param cell_display_mode: A list of display modes for each table cell. Valid values are ``number``, ``bar``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
        :param conditional_formats: conditional_formats block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
        :param limit: limit block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param style: style block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
        '''
        if isinstance(limit, dict):
            limit = DashboardWidgetChangeDefinitionRequestFormulaLimit(**limit)
        if isinstance(style, dict):
            style = DashboardWidgetChangeDefinitionRequestFormulaStyle(**style)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__419b34d9e048b41dac653cf48e16e761418d98ea8e86a3d2ebe35d2f87729c83)
            check_type(argname="argument formula_expression", value=formula_expression, expected_type=type_hints["formula_expression"])
            check_type(argname="argument alias", value=alias, expected_type=type_hints["alias"])
            check_type(argname="argument cell_display_mode", value=cell_display_mode, expected_type=type_hints["cell_display_mode"])
            check_type(argname="argument conditional_formats", value=conditional_formats, expected_type=type_hints["conditional_formats"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument style", value=style, expected_type=type_hints["style"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "formula_expression": formula_expression,
        }
        if alias is not None:
            self._values["alias"] = alias
        if cell_display_mode is not None:
            self._values["cell_display_mode"] = cell_display_mode
        if conditional_formats is not None:
            self._values["conditional_formats"] = conditional_formats
        if limit is not None:
            self._values["limit"] = limit
        if style is not None:
            self._values["style"] = style

    @builtins.property
    def formula_expression(self) -> builtins.str:
        '''A string expression built from queries, formulas, and functions.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
        '''
        result = self._values.get("formula_expression")
        assert result is not None, "Required property 'formula_expression' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alias(self) -> typing.Optional[builtins.str]:
        '''An expression alias.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
        '''
        result = self._values.get("alias")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cell_display_mode(self) -> typing.Optional[builtins.str]:
        '''A list of display modes for each table cell. Valid values are ``number``, ``bar``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
        '''
        result = self._values.get("cell_display_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def conditional_formats(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats"]]]:
        '''conditional_formats block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
        '''
        result = self._values.get("conditional_formats")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats"]]], result)

    @builtins.property
    def limit(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestFormulaLimit"]:
        '''limit block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestFormulaLimit"], result)

    @builtins.property
    def style(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestFormulaStyle"]:
        '''style block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
        '''
        result = self._values.get("style")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestFormulaStyle"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestFormula(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats",
    jsii_struct_bases=[],
    name_mapping={
        "comparator": "comparator",
        "palette": "palette",
        "value": "value",
        "custom_bg_color": "customBgColor",
        "custom_fg_color": "customFgColor",
        "hide_value": "hideValue",
        "image_url": "imageUrl",
        "metric": "metric",
        "timeframe": "timeframe",
    },
)
class DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats:
    def __init__(
        self,
        *,
        comparator: builtins.str,
        palette: builtins.str,
        value: jsii.Number,
        custom_bg_color: typing.Optional[builtins.str] = None,
        custom_fg_color: typing.Optional[builtins.str] = None,
        hide_value: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        image_url: typing.Optional[builtins.str] = None,
        metric: typing.Optional[builtins.str] = None,
        timeframe: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param comparator: The comparator to use. Valid values are ``>``, ``>=``, ``<``, ``<=``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
        :param palette: The color palette to apply. Valid values are ``blue``, ``custom_bg``, ``custom_image``, ``custom_text``, ``gray_on_white``, ``grey``, ``green``, ``orange``, ``red``, ``red_on_white``, ``white_on_gray``, ``white_on_green``, ``green_on_white``, ``white_on_red``, ``white_on_yellow``, ``yellow_on_white``, ``black_on_light_yellow``, ``black_on_light_green``, ``black_on_light_red``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        :param value: A value for the comparator. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
        :param custom_bg_color: The color palette to apply to the background, same values available as palette. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
        :param custom_fg_color: The color palette to apply to the foreground, same values available as palette. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
        :param hide_value: Setting this to True hides values. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
        :param image_url: Displays an image as the background. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
        :param metric: The metric from the request to correlate with this conditional format. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param timeframe: Defines the displayed timeframe. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__03971f58a918812de2e92fc68e58827f78e54c0ab851b578478559057c8a49d9)
            check_type(argname="argument comparator", value=comparator, expected_type=type_hints["comparator"])
            check_type(argname="argument palette", value=palette, expected_type=type_hints["palette"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument custom_bg_color", value=custom_bg_color, expected_type=type_hints["custom_bg_color"])
            check_type(argname="argument custom_fg_color", value=custom_fg_color, expected_type=type_hints["custom_fg_color"])
            check_type(argname="argument hide_value", value=hide_value, expected_type=type_hints["hide_value"])
            check_type(argname="argument image_url", value=image_url, expected_type=type_hints["image_url"])
            check_type(argname="argument metric", value=metric, expected_type=type_hints["metric"])
            check_type(argname="argument timeframe", value=timeframe, expected_type=type_hints["timeframe"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "comparator": comparator,
            "palette": palette,
            "value": value,
        }
        if custom_bg_color is not None:
            self._values["custom_bg_color"] = custom_bg_color
        if custom_fg_color is not None:
            self._values["custom_fg_color"] = custom_fg_color
        if hide_value is not None:
            self._values["hide_value"] = hide_value
        if image_url is not None:
            self._values["image_url"] = image_url
        if metric is not None:
            self._values["metric"] = metric
        if timeframe is not None:
            self._values["timeframe"] = timeframe

    @builtins.property
    def comparator(self) -> builtins.str:
        '''The comparator to use. Valid values are ``>``, ``>=``, ``<``, ``<=``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
        '''
        result = self._values.get("comparator")
        assert result is not None, "Required property 'comparator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def palette(self) -> builtins.str:
        '''The color palette to apply.

        Valid values are ``blue``, ``custom_bg``, ``custom_image``, ``custom_text``, ``gray_on_white``, ``grey``, ``green``, ``orange``, ``red``, ``red_on_white``, ``white_on_gray``, ``white_on_green``, ``green_on_white``, ``white_on_red``, ``white_on_yellow``, ``yellow_on_white``, ``black_on_light_yellow``, ``black_on_light_green``, ``black_on_light_red``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        '''
        result = self._values.get("palette")
        assert result is not None, "Required property 'palette' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> jsii.Number:
        '''A value for the comparator.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def custom_bg_color(self) -> typing.Optional[builtins.str]:
        '''The color palette to apply to the background, same values available as palette.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
        '''
        result = self._values.get("custom_bg_color")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def custom_fg_color(self) -> typing.Optional[builtins.str]:
        '''The color palette to apply to the foreground, same values available as palette.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
        '''
        result = self._values.get("custom_fg_color")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def hide_value(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        '''Setting this to True hides values.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
        '''
        result = self._values.get("hide_value")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], result)

    @builtins.property
    def image_url(self) -> typing.Optional[builtins.str]:
        '''Displays an image as the background.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
        '''
        result = self._values.get("image_url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def metric(self) -> typing.Optional[builtins.str]:
        '''The metric from the request to correlate with this conditional format.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def timeframe(self) -> typing.Optional[builtins.str]:
        '''Defines the displayed timeframe.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
        '''
        result = self._values.get("timeframe")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8bf41609d9acd6817685a9a8bc3d0112402bfe04fac6a301d13394a5d86e055f)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c49f0c46a9ab1693fe928931ba2767cd246b5ca0ce919fe6e32bbe6d125fecd1)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8734b53182b948dff79d4fcccb1efd957a5ab2dc855bbf3be25793f505fbb74a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3e6f0b41bd0e40677e0c5990760a15557d11644c3a97f2d1f606adc304af4c5d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0fc077c0ded2c7a2f64b03ae04c10dd24a84422762c6d635cbecc45bd660a769)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__577f4f9ee79a1c64945e9ff9f2d1effada6470654b9f311246402e267c65c5b6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__454650d65412e4005d1ba22b07fe79ab5fdafb68c9d2d09ac4d87d63d3a797e5)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetCustomBgColor")
    def reset_custom_bg_color(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCustomBgColor", []))

    @jsii.member(jsii_name="resetCustomFgColor")
    def reset_custom_fg_color(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCustomFgColor", []))

    @jsii.member(jsii_name="resetHideValue")
    def reset_hide_value(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetHideValue", []))

    @jsii.member(jsii_name="resetImageUrl")
    def reset_image_url(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetImageUrl", []))

    @jsii.member(jsii_name="resetMetric")
    def reset_metric(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMetric", []))

    @jsii.member(jsii_name="resetTimeframe")
    def reset_timeframe(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTimeframe", []))

    @builtins.property
    @jsii.member(jsii_name="comparatorInput")
    def comparator_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "comparatorInput"))

    @builtins.property
    @jsii.member(jsii_name="customBgColorInput")
    def custom_bg_color_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "customBgColorInput"))

    @builtins.property
    @jsii.member(jsii_name="customFgColorInput")
    def custom_fg_color_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "customFgColorInput"))

    @builtins.property
    @jsii.member(jsii_name="hideValueInput")
    def hide_value_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "hideValueInput"))

    @builtins.property
    @jsii.member(jsii_name="imageUrlInput")
    def image_url_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "imageUrlInput"))

    @builtins.property
    @jsii.member(jsii_name="metricInput")
    def metric_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "metricInput"))

    @builtins.property
    @jsii.member(jsii_name="paletteInput")
    def palette_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "paletteInput"))

    @builtins.property
    @jsii.member(jsii_name="timeframeInput")
    def timeframe_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "timeframeInput"))

    @builtins.property
    @jsii.member(jsii_name="valueInput")
    def value_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "valueInput"))

    @builtins.property
    @jsii.member(jsii_name="comparator")
    def comparator(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "comparator"))

    @comparator.setter
    def comparator(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0cad1efef40385888a209a1a53da226b4ea80d00eaf2d27dfa68c7810eb85a2e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "comparator", value)

    @builtins.property
    @jsii.member(jsii_name="customBgColor")
    def custom_bg_color(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "customBgColor"))

    @custom_bg_color.setter
    def custom_bg_color(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d6bdc218463aa868eb88882629c9cf4dba54fba6789874169fe940247c6dc8d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "customBgColor", value)

    @builtins.property
    @jsii.member(jsii_name="customFgColor")
    def custom_fg_color(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "customFgColor"))

    @custom_fg_color.setter
    def custom_fg_color(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0335fd893eb9c388a74b53890531789f03510ae8651b2b6fb398266cdea21d1b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "customFgColor", value)

    @builtins.property
    @jsii.member(jsii_name="hideValue")
    def hide_value(self) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "hideValue"))

    @hide_value.setter
    def hide_value(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ee6397cbf2e56a84494db92ffeebd36d7951a1a2e425b48711a14550688674e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "hideValue", value)

    @builtins.property
    @jsii.member(jsii_name="imageUrl")
    def image_url(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "imageUrl"))

    @image_url.setter
    def image_url(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d1b47f1897cd5bf36b5082b007f73dad18a78c3665b817e19abf008972f001a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageUrl", value)

    @builtins.property
    @jsii.member(jsii_name="metric")
    def metric(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "metric"))

    @metric.setter
    def metric(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9a4899ad49f34919f703178e179544eb9baa6b38f9db16d655515c878732290f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "metric", value)

    @builtins.property
    @jsii.member(jsii_name="palette")
    def palette(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "palette"))

    @palette.setter
    def palette(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c3b5385cf1233c287c15b9d0c3827ae3a5b5d83fbb114a7ebe3127f9e8abcfc0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "palette", value)

    @builtins.property
    @jsii.member(jsii_name="timeframe")
    def timeframe(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "timeframe"))

    @timeframe.setter
    def timeframe(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9570f4a1a46f368e7d9a8c99b607f0aa9e1e528fc2908958b25804022a7f496b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "timeframe", value)

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "value"))

    @value.setter
    def value(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af1e726d3d5254ada06c33a4cf735585b5429cad6f869d04975d516130a9a840)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "value", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6c6f9d34a4319ba5ec3af395b11381d8a83176056ac2140bf117fb6f5a4b53c5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestFormulaLimit",
    jsii_struct_bases=[],
    name_mapping={"count": "count", "order": "order"},
)
class DashboardWidgetChangeDefinitionRequestFormulaLimit:
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        order: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param count: The number of results to return. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
        :param order: The direction of the sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fcd431bf2b7f325cffc169fc4802bccf8ac04958292a6e5ce3a6cad5850bc690)
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument order", value=order, expected_type=type_hints["order"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if count is not None:
            self._values["count"] = count
        if order is not None:
            self._values["order"] = order

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''The number of results to return.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def order(self) -> typing.Optional[builtins.str]:
        '''The direction of the sort. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestFormulaLimit(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestFormulaLimitOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestFormulaLimitOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__004535ecb22f1cdc70ef4a817cadd6a1cb0a12518f1244f8a838e140e9ee4de8)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetCount")
    def reset_count(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCount", []))

    @jsii.member(jsii_name="resetOrder")
    def reset_order(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOrder", []))

    @builtins.property
    @jsii.member(jsii_name="countInput")
    def count_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "countInput"))

    @builtins.property
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property
    @jsii.member(jsii_name="count")
    def count(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "count"))

    @count.setter
    def count(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5494e6e53c350681cb3f87025162927b61624b6b6d670ab51107b3f8144176ac)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "count", value)

    @builtins.property
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bd219f917f1d6662f2fa54fe73c54ba8a012f45c79875372bbd9ac06eb20b73d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "order", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestFormulaLimit]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestFormulaLimit], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestFormulaLimit],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__19220a3c4efa6367dc34251f5e397e70e9a971cced44077d280ca8dc931a0761)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestFormulaList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestFormulaList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__505987c85453166513cf0f0c8418fba15d627556f0bbd16a93e69904cca372c5)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestFormulaOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c329dc9c6e4aac21247164db7ddec1029c66513090ab4940da794886fbd4bfee)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestFormulaOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__74edbb2b95fb527d474da2805734195dafcff9f16c2b9b1f833196fb11766117)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ad8ad8ec6614106892f412a9edc01e0148a4040d7cdd99ba2f38d5a12121085e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__016c556b268d6511a56ed59286170121d8244cea398c865764d0a078c3759a9c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestFormula]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestFormula]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestFormula]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b0920529693ba2856a9067a7aec8c012b456723f2f0d82a54f297a60466b574)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestFormulaOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestFormulaOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bdd7ac0c5ccb36bedcf6837672ca294b847445f98ecf3d03169bc0a28eb4fb45)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putConditionalFormats")
    def put_conditional_formats(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__258104e00c15a97d11c36de5d078fad83dffefd3f6158ca712198860bc0b5742)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putConditionalFormats", [value]))

    @jsii.member(jsii_name="putLimit")
    def put_limit(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        order: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param count: The number of results to return. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
        :param order: The direction of the sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        value = DashboardWidgetChangeDefinitionRequestFormulaLimit(
            count=count, order=order
        )

        return typing.cast(None, jsii.invoke(self, "putLimit", [value]))

    @jsii.member(jsii_name="putStyle")
    def put_style(
        self,
        *,
        palette: typing.Optional[builtins.str] = None,
        palette_index: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param palette: The color palette used to display the formula. A guide to the available color palettes can be found at https://docs.datadoghq.com/dashboards/guide/widget_colors Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        :param palette_index: Index specifying which color to use within the palette. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_index Dashboard#palette_index}
        '''
        value = DashboardWidgetChangeDefinitionRequestFormulaStyle(
            palette=palette, palette_index=palette_index
        )

        return typing.cast(None, jsii.invoke(self, "putStyle", [value]))

    @jsii.member(jsii_name="resetAlias")
    def reset_alias(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAlias", []))

    @jsii.member(jsii_name="resetCellDisplayMode")
    def reset_cell_display_mode(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCellDisplayMode", []))

    @jsii.member(jsii_name="resetConditionalFormats")
    def reset_conditional_formats(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetConditionalFormats", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetStyle")
    def reset_style(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetStyle", []))

    @builtins.property
    @jsii.member(jsii_name="conditionalFormats")
    def conditional_formats(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsList:
        return typing.cast(DashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsList, jsii.get(self, "conditionalFormats"))

    @builtins.property
    @jsii.member(jsii_name="limit")
    def limit(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestFormulaLimitOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestFormulaLimitOutputReference, jsii.get(self, "limit"))

    @builtins.property
    @jsii.member(jsii_name="style")
    def style(
        self,
    ) -> "DashboardWidgetChangeDefinitionRequestFormulaStyleOutputReference":
        return typing.cast("DashboardWidgetChangeDefinitionRequestFormulaStyleOutputReference", jsii.get(self, "style"))

    @builtins.property
    @jsii.member(jsii_name="aliasInput")
    def alias_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aliasInput"))

    @builtins.property
    @jsii.member(jsii_name="cellDisplayModeInput")
    def cell_display_mode_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "cellDisplayModeInput"))

    @builtins.property
    @jsii.member(jsii_name="conditionalFormatsInput")
    def conditional_formats_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats]]], jsii.get(self, "conditionalFormatsInput"))

    @builtins.property
    @jsii.member(jsii_name="formulaExpressionInput")
    def formula_expression_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "formulaExpressionInput"))

    @builtins.property
    @jsii.member(jsii_name="limitInput")
    def limit_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestFormulaLimit]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestFormulaLimit], jsii.get(self, "limitInput"))

    @builtins.property
    @jsii.member(jsii_name="styleInput")
    def style_input(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestFormulaStyle"]:
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestFormulaStyle"], jsii.get(self, "styleInput"))

    @builtins.property
    @jsii.member(jsii_name="alias")
    def alias(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "alias"))

    @alias.setter
    def alias(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7b0ceda3a00c8cedbd9c35506891191ed559830fedcb191a1f59e6bcd9dc9945)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "alias", value)

    @builtins.property
    @jsii.member(jsii_name="cellDisplayMode")
    def cell_display_mode(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "cellDisplayMode"))

    @cell_display_mode.setter
    def cell_display_mode(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a31c724511767e53cce0dc26cdc93612fcac2a34206c71af35ee072de6d23f25)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "cellDisplayMode", value)

    @builtins.property
    @jsii.member(jsii_name="formulaExpression")
    def formula_expression(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "formulaExpression"))

    @formula_expression.setter
    def formula_expression(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f9bdb126ffb0269b16313cee5396c584181bdfc7d8b297637fd5bae27887cd77)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "formulaExpression", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestFormula, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestFormula, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestFormula, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__479ef28c630c4a0c12dda6a3befb08f39d272070cf9e5982144e963bac852eef)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestFormulaStyle",
    jsii_struct_bases=[],
    name_mapping={"palette": "palette", "palette_index": "paletteIndex"},
)
class DashboardWidgetChangeDefinitionRequestFormulaStyle:
    def __init__(
        self,
        *,
        palette: typing.Optional[builtins.str] = None,
        palette_index: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param palette: The color palette used to display the formula. A guide to the available color palettes can be found at https://docs.datadoghq.com/dashboards/guide/widget_colors Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        :param palette_index: Index specifying which color to use within the palette. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_index Dashboard#palette_index}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6ac9f203e0622d8695a2da83e7d61af1bdfbeafe640c2843f39f89cca4ece081)
            check_type(argname="argument palette", value=palette, expected_type=type_hints["palette"])
            check_type(argname="argument palette_index", value=palette_index, expected_type=type_hints["palette_index"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if palette is not None:
            self._values["palette"] = palette
        if palette_index is not None:
            self._values["palette_index"] = palette_index

    @builtins.property
    def palette(self) -> typing.Optional[builtins.str]:
        '''The color palette used to display the formula.

        A guide to the available color palettes can be found at https://docs.datadoghq.com/dashboards/guide/widget_colors

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        '''
        result = self._values.get("palette")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def palette_index(self) -> typing.Optional[jsii.Number]:
        '''Index specifying which color to use within the palette.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_index Dashboard#palette_index}
        '''
        result = self._values.get("palette_index")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestFormulaStyle(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestFormulaStyleOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestFormulaStyleOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__efaf4f7b6b1be17df6ae3e9e561648bc89f0fb853e62173ee238a415d30a92be)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetPalette")
    def reset_palette(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPalette", []))

    @jsii.member(jsii_name="resetPaletteIndex")
    def reset_palette_index(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPaletteIndex", []))

    @builtins.property
    @jsii.member(jsii_name="paletteIndexInput")
    def palette_index_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "paletteIndexInput"))

    @builtins.property
    @jsii.member(jsii_name="paletteInput")
    def palette_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "paletteInput"))

    @builtins.property
    @jsii.member(jsii_name="palette")
    def palette(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "palette"))

    @palette.setter
    def palette(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fcfe060c7251a83a03931972d437769abcdbad49da850d2253097a04379b242d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "palette", value)

    @builtins.property
    @jsii.member(jsii_name="paletteIndex")
    def palette_index(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "paletteIndex"))

    @palette_index.setter
    def palette_index(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c03b6301b02eba1d6882e0a0135e260d4403011e0dc465c188b971284031129e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "paletteIndex", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestFormulaStyle]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestFormulaStyle], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestFormulaStyle],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__54c54e25f57055195cbe1393332576ccb73a1e078c10db68c6bf59b81f50d58c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df18b9da20be748d7f1f889d294fdef9d4735c0135ea97c00bd44f27c1e7c84f)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__40987fde013b14e0069e9fae88773ad34611f30ade72a85818a4af43d63c9dda)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c8906a4b5cb70a8e5b0e164657955ced689dc0f0bc29b53fb43038b95b7d430)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__16277979d19157baf11958ad24bb45046e999b839c14624d4bc58cdb1a5aa1f9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b45374be0ca3838db4603c17aa8d8eb17d367fe9388d394b7ea17b01d111e390)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequest]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequest]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequest]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8146089dce3e9a0ed36e48a1decabd30a4f059efb24c4eaafb7a3921471d509a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestLogQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetChangeDefinitionRequestLogQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestLogQueryGroupBy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute", typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery(**compute_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e019d10cc05199e967c111268942889dd85d45476c60945b612fe78487b0a969)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
            check_type(argname="argument compute_query", value=compute_query, expected_type=type_hints["compute_query"])
            check_type(argname="argument group_by", value=group_by, expected_type=type_hints["group_by"])
            check_type(argname="argument multi_compute", value=multi_compute, expected_type=type_hints["multi_compute"])
            check_type(argname="argument search_query", value=search_query, expected_type=type_hints["search_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestLogQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestLogQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestLogQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c56bb85a18b5d71012fe08e80f870ad8f77f369567913e8cfcf34e840e062cd)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c6972b3b39b2ee68892ee9ecde7e9b383c6a4962060de39ceed5dae584c614c)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__34778d4290620c3035f579aa32e86ae0ce91d62105b32760023e22fe2a494eaf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__11225cf68f08df2ee0e38b5d9cef479baa155479f0ef31f46abe271129d86193)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b66570c6d51d9cb86e3c6d1112475b7bfddc4c65c06dcdf5d836d9e6a87176fe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a89be0100444d51a9e4b398d62d30e365d69941b086e39f9cdcf493971d0a35)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestLogQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetChangeDefinitionRequestLogQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery(**sort_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fff57e84b4286cf0cc57f043b875b77464c2b381eb9d2af54eaf196d05204617)
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument sort_query", value=sort_query, expected_type=type_hints["sort_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestLogQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestLogQueryGroupByList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestLogQueryGroupByList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c7be386db57094bf0243c9c3d42e3d72b445e012c89753085545b9758baf44e5)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestLogQueryGroupByOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a1ea28cb158e58d866ea5191df4d06d6c4b4d751eb12a48b0bd3123d7bcad89)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestLogQueryGroupByOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d8ba6867c745939e84d1ec36372713937c85d103c058ce4c6e1b0cfa786c2cbb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0346a5e1cdc5b5c89c87871168e4e6bb0735caa1b3e88603445950b8c64f7a17)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b24c8faf71a4b0a42dc8b9bee57f1fe4e40e5a00012b76a137320ff59ff88da)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ebf4ffdcfe36a91ea0b61addfd1ad3d46a456aa4f221f55a3b293efe975802d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestLogQueryGroupByOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestLogQueryGroupByOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f854f8f797597f28a9c759913ee3f764adad670009c302fbdf374ec273747780)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putSortQuery")
    def put_sort_query(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        value = DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery(
            aggregation=aggregation, order=order, facet=facet
        )

        return typing.cast(None, jsii.invoke(self, "putSortQuery", [value]))

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSortQuery")
    def reset_sort_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSortQuery", []))

    @builtins.property
    @jsii.member(jsii_name="sortQuery")
    def sort_query(
        self,
    ) -> "DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference":
        return typing.cast("DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference", jsii.get(self, "sortQuery"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property
    @jsii.member(jsii_name="sortQueryInput")
    def sort_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery"], jsii.get(self, "sortQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f070dbc2c1adc21d43d565b76e4ee64a2d649e1cf4f260c84bdfcebad8b8cbf6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6e2315fa1c5ee44053e129c7856225ff4a59322064ffa52d21f59175ab01bd91)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "limit", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f41c57774a1a1183894c72c1cdeb5789659ccdb7f8279c15741eb3b624918b26)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8e3b078b7c86bd9c8e3e91a8753c271443c234333d4616e4fbf389892635a37d)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument order", value=order, expected_type=type_hints["order"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1d2bc3f22ccdf1d859509bd7fd719c577c7a4305d1f7e972443e8cae7245bf2a)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc6e7b0cb06354a328a6c10ba9f4e571134d950994f170f70558a4349b376507)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__269fe347c82154cc37c79618e7c3439d436c4cb8586ff2007b61523b58a807a7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__307ef077ad5c946283eea3799f2ab532e0a51972e597e28e67942f1df08c3fdb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "order", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__984b7ac77a89a076e4c7e5d71654c1e85960daabf3b2e54868e68fefb33e3f15)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e936eb28a7d8bad85fa0c39ca898836bdef7a0bc3910daefa7263f350962cea2)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestLogQueryMultiComputeList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestLogQueryMultiComputeList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__89e3e5264f0c51346cecbe1b0c873cb257dff5ea0ee55e8c7ab9dbf9caea38fc)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestLogQueryMultiComputeOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bbd3a4308f6501b4698810eec383c23d00ca5aef8f9b20d3cb9d91b7d4ead149)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestLogQueryMultiComputeOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__396af2baab0c903f755802b9b2252aa76c0ba39319c1ab709c05528337a5239e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__54ca01766d963610a7a631c9b25816eb85e34ad809d05c62e46e1dcfc32ae58a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8972e3f4fe4edd7282c06fba58429e6275a450c4ec50077188aa2fa3c4fee7ef)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__59d2b32231d92af793db2e603bdcf2bbfd47d2364b4b4372c34f0daef97e3f98)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestLogQueryMultiComputeOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestLogQueryMultiComputeOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c0099ce13783de2095cc0362dfde0780232728b452f24689cc0c09b9dff72890)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4951367a748ab625de9e2b3355a31c838698a2c1f42e490d6351dd3ddce67f88)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29624bfaa27c25b0435331abc9cb63ab46056a5705184fed3318b121b33cafef)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__72b7283f591ec4da00260972f1c5b617396c282e237b4044ff120decaa9db627)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__800ac879b3a8b69be65d013e3ac212920bc38a6d362a2c31b261e6b022288fce)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestLogQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestLogQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__45bc0efc6005624fb87f8e0996d9c6e8122f2a3280c0036368e31e408d5b3b30)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="putGroupBy")
    def put_group_by(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ad630cf2297e5023ba69ef696bb348d243ee2663b8ecf8365223df2f6ee8bf9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putGroupBy", [value]))

    @jsii.member(jsii_name="putMultiCompute")
    def put_multi_compute(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6841e507b1f6fdb8612da091d73f7f677fe5faf332e006b848c88b27d02b5a58)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putMultiCompute", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property
    @jsii.member(jsii_name="groupBy")
    def group_by(self) -> DashboardWidgetChangeDefinitionRequestLogQueryGroupByList:
        return typing.cast(DashboardWidgetChangeDefinitionRequestLogQueryGroupByList, jsii.get(self, "groupBy"))

    @builtins.property
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestLogQueryMultiComputeList:
        return typing.cast(DashboardWidgetChangeDefinitionRequestLogQueryMultiComputeList, jsii.get(self, "multiCompute"))

    @builtins.property
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ad161cb3ee05a6a7d09c8ae92f06ca968ea4ab863c05974282da264e1ef89e8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "index", value)

    @builtins.property
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__abe1f4cf8063befbbc347ae2d9729ba1308beee1509da26f4468f063be2ebc22)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "searchQuery", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestLogQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestLogQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestLogQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ae1b149420ebbe5c692ca11dca72e3aafe22ac8724bb2ba4c1f8343fbf31eb0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__64ac6087694552a54daad987a6fe436093bc5a87918008de3c6d889c6406e889)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putApmQuery")
    def put_apm_query(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery, typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestApmQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute, typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        value = DashboardWidgetChangeDefinitionRequestApmQuery(
            index=index,
            compute_query=compute_query,
            group_by=group_by,
            multi_compute=multi_compute,
            search_query=search_query,
        )

        return typing.cast(None, jsii.invoke(self, "putApmQuery", [value]))

    @jsii.member(jsii_name="putFormula")
    def put_formula(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestFormula, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__22a5f453e0b60946cbc2fbc4bd22c53e7989f9af043594c8878b39e802929771)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putFormula", [value]))

    @jsii.member(jsii_name="putLogQuery")
    def put_log_query(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery, typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestLogQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute, typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        value = DashboardWidgetChangeDefinitionRequestLogQuery(
            index=index,
            compute_query=compute_query,
            group_by=group_by,
            multi_compute=multi_compute,
            search_query=search_query,
        )

        return typing.cast(None, jsii.invoke(self, "putLogQuery", [value]))

    @jsii.member(jsii_name="putProcessQuery")
    def put_process_query(
        self,
        *,
        metric: builtins.str,
        filter_by: typing.Optional[typing.Sequence[builtins.str]] = None,
        limit: typing.Optional[jsii.Number] = None,
        search_by: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric: Your chosen metric. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param filter_by: A list of processes. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
        :param limit: The max number of items in the filter list. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param search_by: Your chosen search term. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
        '''
        value = DashboardWidgetChangeDefinitionRequestProcessQuery(
            metric=metric, filter_by=filter_by, limit=limit, search_by=search_by
        )

        return typing.cast(None, jsii.invoke(self, "putProcessQuery", [value]))

    @jsii.member(jsii_name="putQuery")
    def put_query(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestQuery", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f2265cdf648f22822c309f6a6de0b69b2be92805466b121f33b2e13b2a061b93)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putQuery", [value]))

    @jsii.member(jsii_name="putRumQuery")
    def put_rum_query(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestRumQueryGroupBy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute", typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        value = DashboardWidgetChangeDefinitionRequestRumQuery(
            index=index,
            compute_query=compute_query,
            group_by=group_by,
            multi_compute=multi_compute,
            search_query=search_query,
        )

        return typing.cast(None, jsii.invoke(self, "putRumQuery", [value]))

    @jsii.member(jsii_name="putSecurityQuery")
    def put_security_query(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute", typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        value = DashboardWidgetChangeDefinitionRequestSecurityQuery(
            index=index,
            compute_query=compute_query,
            group_by=group_by,
            multi_compute=multi_compute,
            search_query=search_query,
        )

        return typing.cast(None, jsii.invoke(self, "putSecurityQuery", [value]))

    @jsii.member(jsii_name="resetApmQuery")
    def reset_apm_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetApmQuery", []))

    @jsii.member(jsii_name="resetChangeType")
    def reset_change_type(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetChangeType", []))

    @jsii.member(jsii_name="resetCompareTo")
    def reset_compare_to(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCompareTo", []))

    @jsii.member(jsii_name="resetFormula")
    def reset_formula(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFormula", []))

    @jsii.member(jsii_name="resetIncreaseGood")
    def reset_increase_good(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIncreaseGood", []))

    @jsii.member(jsii_name="resetLogQuery")
    def reset_log_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLogQuery", []))

    @jsii.member(jsii_name="resetOrderBy")
    def reset_order_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOrderBy", []))

    @jsii.member(jsii_name="resetOrderDir")
    def reset_order_dir(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOrderDir", []))

    @jsii.member(jsii_name="resetProcessQuery")
    def reset_process_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetProcessQuery", []))

    @jsii.member(jsii_name="resetQ")
    def reset_q(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetQ", []))

    @jsii.member(jsii_name="resetQuery")
    def reset_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetQuery", []))

    @jsii.member(jsii_name="resetRumQuery")
    def reset_rum_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRumQuery", []))

    @jsii.member(jsii_name="resetSecurityQuery")
    def reset_security_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSecurityQuery", []))

    @jsii.member(jsii_name="resetShowPresent")
    def reset_show_present(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShowPresent", []))

    @builtins.property
    @jsii.member(jsii_name="apmQuery")
    def apm_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestApmQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestApmQueryOutputReference, jsii.get(self, "apmQuery"))

    @builtins.property
    @jsii.member(jsii_name="formula")
    def formula(self) -> DashboardWidgetChangeDefinitionRequestFormulaList:
        return typing.cast(DashboardWidgetChangeDefinitionRequestFormulaList, jsii.get(self, "formula"))

    @builtins.property
    @jsii.member(jsii_name="logQuery")
    def log_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestLogQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestLogQueryOutputReference, jsii.get(self, "logQuery"))

    @builtins.property
    @jsii.member(jsii_name="processQuery")
    def process_query(
        self,
    ) -> "DashboardWidgetChangeDefinitionRequestProcessQueryOutputReference":
        return typing.cast("DashboardWidgetChangeDefinitionRequestProcessQueryOutputReference", jsii.get(self, "processQuery"))

    @builtins.property
    @jsii.member(jsii_name="query")
    def query(self) -> "DashboardWidgetChangeDefinitionRequestQueryList":
        return typing.cast("DashboardWidgetChangeDefinitionRequestQueryList", jsii.get(self, "query"))

    @builtins.property
    @jsii.member(jsii_name="rumQuery")
    def rum_query(
        self,
    ) -> "DashboardWidgetChangeDefinitionRequestRumQueryOutputReference":
        return typing.cast("DashboardWidgetChangeDefinitionRequestRumQueryOutputReference", jsii.get(self, "rumQuery"))

    @builtins.property
    @jsii.member(jsii_name="securityQuery")
    def security_query(
        self,
    ) -> "DashboardWidgetChangeDefinitionRequestSecurityQueryOutputReference":
        return typing.cast("DashboardWidgetChangeDefinitionRequestSecurityQueryOutputReference", jsii.get(self, "securityQuery"))

    @builtins.property
    @jsii.member(jsii_name="apmQueryInput")
    def apm_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestApmQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestApmQuery], jsii.get(self, "apmQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="changeTypeInput")
    def change_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "changeTypeInput"))

    @builtins.property
    @jsii.member(jsii_name="compareToInput")
    def compare_to_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "compareToInput"))

    @builtins.property
    @jsii.member(jsii_name="formulaInput")
    def formula_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestFormula]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestFormula]]], jsii.get(self, "formulaInput"))

    @builtins.property
    @jsii.member(jsii_name="increaseGoodInput")
    def increase_good_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "increaseGoodInput"))

    @builtins.property
    @jsii.member(jsii_name="logQueryInput")
    def log_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestLogQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestLogQuery], jsii.get(self, "logQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="orderByInput")
    def order_by_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderByInput"))

    @builtins.property
    @jsii.member(jsii_name="orderDirInput")
    def order_dir_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderDirInput"))

    @builtins.property
    @jsii.member(jsii_name="processQueryInput")
    def process_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestProcessQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestProcessQuery"], jsii.get(self, "processQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="qInput")
    def q_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "qInput"))

    @builtins.property
    @jsii.member(jsii_name="queryInput")
    def query_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQuery"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQuery"]]], jsii.get(self, "queryInput"))

    @builtins.property
    @jsii.member(jsii_name="rumQueryInput")
    def rum_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestRumQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestRumQuery"], jsii.get(self, "rumQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="securityQueryInput")
    def security_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQuery"], jsii.get(self, "securityQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="showPresentInput")
    def show_present_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "showPresentInput"))

    @builtins.property
    @jsii.member(jsii_name="changeType")
    def change_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "changeType"))

    @change_type.setter
    def change_type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c7d0ee3b33f834778cb3354f0ab9f3cb96224384bb6b81e8ae0567b9429dc6a3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "changeType", value)

    @builtins.property
    @jsii.member(jsii_name="compareTo")
    def compare_to(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "compareTo"))

    @compare_to.setter
    def compare_to(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__489f10c06ccd807c95dedc350902d51e48fa4413d634c3cc7d598b477bfacc06)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "compareTo", value)

    @builtins.property
    @jsii.member(jsii_name="increaseGood")
    def increase_good(self) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "increaseGood"))

    @increase_good.setter
    def increase_good(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7aaa1b59fe6576871b62b698015b287e2f03ee5bbd01524b1c202b5b323540f2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "increaseGood", value)

    @builtins.property
    @jsii.member(jsii_name="orderBy")
    def order_by(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "orderBy"))

    @order_by.setter
    def order_by(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__81f6db80f921c77697917b1964254672642ca366fd5e6824145ad577bcfa676e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "orderBy", value)

    @builtins.property
    @jsii.member(jsii_name="orderDir")
    def order_dir(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "orderDir"))

    @order_dir.setter
    def order_dir(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b7cd2ee0fc5639632557e58e0dbedc48ce9f4beea85e303d0d3e288b1a9ee60f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "orderDir", value)

    @builtins.property
    @jsii.member(jsii_name="q")
    def q(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "q"))

    @q.setter
    def q(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__218182ac0356329a30c9a01a69856698eebe2014717c5dddf639714a842d8415)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "q", value)

    @builtins.property
    @jsii.member(jsii_name="showPresent")
    def show_present(self) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "showPresent"))

    @show_present.setter
    def show_present(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1959d5715f1794408548ccf7bcacdf21138b4a5b45062a43a1e952fb9ca141c1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "showPresent", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequest, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequest, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequest, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7a920f99788850ba11fe67c08ea45552cdca93811c33966a53a4e4d694346e8e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestProcessQuery",
    jsii_struct_bases=[],
    name_mapping={
        "metric": "metric",
        "filter_by": "filterBy",
        "limit": "limit",
        "search_by": "searchBy",
    },
)
class DashboardWidgetChangeDefinitionRequestProcessQuery:
    def __init__(
        self,
        *,
        metric: builtins.str,
        filter_by: typing.Optional[typing.Sequence[builtins.str]] = None,
        limit: typing.Optional[jsii.Number] = None,
        search_by: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric: Your chosen metric. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param filter_by: A list of processes. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
        :param limit: The max number of items in the filter list. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param search_by: Your chosen search term. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea4782a72142b367513d343ad7308f204f7bfeda741def16cfcaf4660035eca4)
            check_type(argname="argument metric", value=metric, expected_type=type_hints["metric"])
            check_type(argname="argument filter_by", value=filter_by, expected_type=type_hints["filter_by"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument search_by", value=search_by, expected_type=type_hints["search_by"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "metric": metric,
        }
        if filter_by is not None:
            self._values["filter_by"] = filter_by
        if limit is not None:
            self._values["limit"] = limit
        if search_by is not None:
            self._values["search_by"] = search_by

    @builtins.property
    def metric(self) -> builtins.str:
        '''Your chosen metric.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def filter_by(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of processes.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
        '''
        result = self._values.get("filter_by")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The max number of items in the filter list.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def search_by(self) -> typing.Optional[builtins.str]:
        '''Your chosen search term.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
        '''
        result = self._values.get("search_by")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestProcessQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestProcessQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestProcessQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__db4abe5ca9917fa680094f21f03dbe33fa64db92fa894d4b282b858c27013ac6)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFilterBy")
    def reset_filter_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFilterBy", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSearchBy")
    def reset_search_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchBy", []))

    @builtins.property
    @jsii.member(jsii_name="filterByInput")
    def filter_by_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "filterByInput"))

    @builtins.property
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property
    @jsii.member(jsii_name="metricInput")
    def metric_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "metricInput"))

    @builtins.property
    @jsii.member(jsii_name="searchByInput")
    def search_by_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchByInput"))

    @builtins.property
    @jsii.member(jsii_name="filterBy")
    def filter_by(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "filterBy"))

    @filter_by.setter
    def filter_by(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c2e6359fb1a5fed5c46d5ed463d85cad8ca14b00a555162f1c5d6e153623af98)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "filterBy", value)

    @builtins.property
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a666edcd854698f65aa979ac8e3203acb2ed86d0033a65693eefe2aca0e250c4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "limit", value)

    @builtins.property
    @jsii.member(jsii_name="metric")
    def metric(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "metric"))

    @metric.setter
    def metric(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b91a444fc940db99326471af89c9e174ecb5d79a8e78a17c078ec1d041a75fbd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "metric", value)

    @builtins.property
    @jsii.member(jsii_name="searchBy")
    def search_by(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchBy"))

    @search_by.setter
    def search_by(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77f606fc85daf67f3ab814659f1136214db05c8bf1e69b939f751448ba95f678)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "searchBy", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestProcessQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestProcessQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestProcessQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f326a879ad5edac4e93e91a86f07b24a6b11f292b951d25e6e377fa55d9d8fd3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQuery",
    jsii_struct_bases=[],
    name_mapping={
        "apm_dependency_stats_query": "apmDependencyStatsQuery",
        "apm_resource_stats_query": "apmResourceStatsQuery",
        "event_query": "eventQuery",
        "metric_query": "metricQuery",
        "process_query": "processQuery",
    },
)
class DashboardWidgetChangeDefinitionRequestQuery:
    def __init__(
        self,
        *,
        apm_dependency_stats_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        apm_resource_stats_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        event_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestQueryEventQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        metric_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestQueryMetricQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        process_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestQueryProcessQuery", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param apm_dependency_stats_query: apm_dependency_stats_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
        :param apm_resource_stats_query: apm_resource_stats_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
        :param event_query: event_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
        :param metric_query: metric_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
        :param process_query: process_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        '''
        if isinstance(apm_dependency_stats_query, dict):
            apm_dependency_stats_query = DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery(**apm_dependency_stats_query)
        if isinstance(apm_resource_stats_query, dict):
            apm_resource_stats_query = DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery(**apm_resource_stats_query)
        if isinstance(event_query, dict):
            event_query = DashboardWidgetChangeDefinitionRequestQueryEventQuery(**event_query)
        if isinstance(metric_query, dict):
            metric_query = DashboardWidgetChangeDefinitionRequestQueryMetricQuery(**metric_query)
        if isinstance(process_query, dict):
            process_query = DashboardWidgetChangeDefinitionRequestQueryProcessQuery(**process_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__00f7942ab0276e26dc7f3f851b566ee32deba778e541eb2b90042acf106de045)
            check_type(argname="argument apm_dependency_stats_query", value=apm_dependency_stats_query, expected_type=type_hints["apm_dependency_stats_query"])
            check_type(argname="argument apm_resource_stats_query", value=apm_resource_stats_query, expected_type=type_hints["apm_resource_stats_query"])
            check_type(argname="argument event_query", value=event_query, expected_type=type_hints["event_query"])
            check_type(argname="argument metric_query", value=metric_query, expected_type=type_hints["metric_query"])
            check_type(argname="argument process_query", value=process_query, expected_type=type_hints["process_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if apm_dependency_stats_query is not None:
            self._values["apm_dependency_stats_query"] = apm_dependency_stats_query
        if apm_resource_stats_query is not None:
            self._values["apm_resource_stats_query"] = apm_resource_stats_query
        if event_query is not None:
            self._values["event_query"] = event_query
        if metric_query is not None:
            self._values["metric_query"] = metric_query
        if process_query is not None:
            self._values["process_query"] = process_query

    @builtins.property
    def apm_dependency_stats_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery"]:
        '''apm_dependency_stats_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
        '''
        result = self._values.get("apm_dependency_stats_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery"], result)

    @builtins.property
    def apm_resource_stats_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery"]:
        '''apm_resource_stats_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
        '''
        result = self._values.get("apm_resource_stats_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery"], result)

    @builtins.property
    def event_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuery"]:
        '''event_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
        '''
        result = self._values.get("event_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuery"], result)

    @builtins.property
    def metric_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryMetricQuery"]:
        '''metric_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
        '''
        result = self._values.get("metric_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryMetricQuery"], result)

    @builtins.property
    def process_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryProcessQuery"]:
        '''process_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        '''
        result = self._values.get("process_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryProcessQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery",
    jsii_struct_bases=[],
    name_mapping={
        "data_source": "dataSource",
        "env": "env",
        "name": "name",
        "operation_name": "operationName",
        "resource_name": "resourceName",
        "service": "service",
        "stat": "stat",
        "is_upstream": "isUpstream",
        "primary_tag_name": "primaryTagName",
        "primary_tag_value": "primaryTagValue",
    },
)
class DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery:
    def __init__(
        self,
        *,
        data_source: builtins.str,
        env: builtins.str,
        name: builtins.str,
        operation_name: builtins.str,
        resource_name: builtins.str,
        service: builtins.str,
        stat: builtins.str,
        is_upstream: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        primary_tag_name: typing.Optional[builtins.str] = None,
        primary_tag_value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param data_source: The data source for APM Dependency Stats queries. Valid values are ``apm_dependency_stats``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param env: APM Environment. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param operation_name: Name of operation on service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        :param resource_name: APM resource. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        :param service: APM service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        :param stat: APM statistic. Valid values are ``avg_duration``, ``avg_root_duration``, ``avg_spans_per_trace``, ``error_rate``, ``pct_exec_time``, ``pct_of_traces``, ``total_traces_count``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        :param is_upstream: Determines whether stats for upstream or downstream dependencies should be queried. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
        :param primary_tag_name: The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        :param primary_tag_value: Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2d8731fc3fb0d4044dc3300f436e3817f4cf1c655de5330640da985151709d60)
            check_type(argname="argument data_source", value=data_source, expected_type=type_hints["data_source"])
            check_type(argname="argument env", value=env, expected_type=type_hints["env"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument operation_name", value=operation_name, expected_type=type_hints["operation_name"])
            check_type(argname="argument resource_name", value=resource_name, expected_type=type_hints["resource_name"])
            check_type(argname="argument service", value=service, expected_type=type_hints["service"])
            check_type(argname="argument stat", value=stat, expected_type=type_hints["stat"])
            check_type(argname="argument is_upstream", value=is_upstream, expected_type=type_hints["is_upstream"])
            check_type(argname="argument primary_tag_name", value=primary_tag_name, expected_type=type_hints["primary_tag_name"])
            check_type(argname="argument primary_tag_value", value=primary_tag_value, expected_type=type_hints["primary_tag_value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "data_source": data_source,
            "env": env,
            "name": name,
            "operation_name": operation_name,
            "resource_name": resource_name,
            "service": service,
            "stat": stat,
        }
        if is_upstream is not None:
            self._values["is_upstream"] = is_upstream
        if primary_tag_name is not None:
            self._values["primary_tag_name"] = primary_tag_name
        if primary_tag_value is not None:
            self._values["primary_tag_value"] = primary_tag_value

    @builtins.property
    def data_source(self) -> builtins.str:
        '''The data source for APM Dependency Stats queries. Valid values are ``apm_dependency_stats``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        assert result is not None, "Required property 'data_source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def env(self) -> builtins.str:
        '''APM Environment.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        '''
        result = self._values.get("env")
        assert result is not None, "Required property 'env' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operation_name(self) -> builtins.str:
        '''Name of operation on service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        '''
        result = self._values.get("operation_name")
        assert result is not None, "Required property 'operation_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_name(self) -> builtins.str:
        '''APM resource.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        '''
        result = self._values.get("resource_name")
        assert result is not None, "Required property 'resource_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def service(self) -> builtins.str:
        '''APM service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        '''
        result = self._values.get("service")
        assert result is not None, "Required property 'service' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def stat(self) -> builtins.str:
        '''APM statistic. Valid values are ``avg_duration``, ``avg_root_duration``, ``avg_spans_per_trace``, ``error_rate``, ``pct_exec_time``, ``pct_of_traces``, ``total_traces_count``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        '''
        result = self._values.get("stat")
        assert result is not None, "Required property 'stat' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def is_upstream(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        '''Determines whether stats for upstream or downstream dependencies should be queried.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
        '''
        result = self._values.get("is_upstream")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], result)

    @builtins.property
    def primary_tag_name(self) -> typing.Optional[builtins.str]:
        '''The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        '''
        result = self._values.get("primary_tag_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def primary_tag_value(self) -> typing.Optional[builtins.str]:
        '''Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        '''
        result = self._values.get("primary_tag_value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__31fb400f0d31f600cb229c830cce6b811c325424daaa3f738aaec444aa7c244c)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetIsUpstream")
    def reset_is_upstream(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsUpstream", []))

    @jsii.member(jsii_name="resetPrimaryTagName")
    def reset_primary_tag_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrimaryTagName", []))

    @jsii.member(jsii_name="resetPrimaryTagValue")
    def reset_primary_tag_value(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrimaryTagValue", []))

    @builtins.property
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property
    @jsii.member(jsii_name="envInput")
    def env_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "envInput"))

    @builtins.property
    @jsii.member(jsii_name="isUpstreamInput")
    def is_upstream_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "isUpstreamInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="operationNameInput")
    def operation_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "operationNameInput"))

    @builtins.property
    @jsii.member(jsii_name="primaryTagNameInput")
    def primary_tag_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagNameInput"))

    @builtins.property
    @jsii.member(jsii_name="primaryTagValueInput")
    def primary_tag_value_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagValueInput"))

    @builtins.property
    @jsii.member(jsii_name="resourceNameInput")
    def resource_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceNameInput"))

    @builtins.property
    @jsii.member(jsii_name="serviceInput")
    def service_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "serviceInput"))

    @builtins.property
    @jsii.member(jsii_name="statInput")
    def stat_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "statInput"))

    @builtins.property
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ad559f53502602eeb2f172338c409f404d3768206cde3f414c3b6ec1ab563774)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataSource", value)

    @builtins.property
    @jsii.member(jsii_name="env")
    def env(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "env"))

    @env.setter
    def env(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3b139cbbe3514b79d2be648243710602179c482501ba158f900abe248223bfbd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "env", value)

    @builtins.property
    @jsii.member(jsii_name="isUpstream")
    def is_upstream(self) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "isUpstream"))

    @is_upstream.setter
    def is_upstream(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__575e8e5b5ab7e075d0913a03aa5a53e4802b0b3eb77b8d1060ba0231ba7ae006)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "isUpstream", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c6e271b3415ccac06a9875dbbe209894165f92f6a29370237148a8f2ff08ba8d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="operationName")
    def operation_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "operationName"))

    @operation_name.setter
    def operation_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__852f279e3d7cc8a09152c4d0bbc8422fdd76e83573ee171f7f58df272b8bd015)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "operationName", value)

    @builtins.property
    @jsii.member(jsii_name="primaryTagName")
    def primary_tag_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTagName"))

    @primary_tag_name.setter
    def primary_tag_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b695ec5a3684d6b6e45a93bc2fa42c22773b41ece00a234616ebef6f82d99e0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "primaryTagName", value)

    @builtins.property
    @jsii.member(jsii_name="primaryTagValue")
    def primary_tag_value(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTagValue"))

    @primary_tag_value.setter
    def primary_tag_value(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a60f6aa9058bc3fb2d0c0801b0822b6db610cd149d5bae86e6063c032c262ec8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "primaryTagValue", value)

    @builtins.property
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resourceName"))

    @resource_name.setter
    def resource_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e66872a2e16e1b614baceac087afb2b37be70860d3356ed969aaafa7f031d768)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "resourceName", value)

    @builtins.property
    @jsii.member(jsii_name="service")
    def service(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "service"))

    @service.setter
    def service(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b6a0962867958e6b4feef81659fc5c33f983cb6025f6f4db8a17b882a121e24a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "service", value)

    @builtins.property
    @jsii.member(jsii_name="stat")
    def stat(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "stat"))

    @stat.setter
    def stat(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f760836565e2d900d0785536700b8ade41d395feb8317599672ef526401e06f8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "stat", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ff2a123c7321545afa9b1651fb448e91f4f6b2673c0e0e03e1305f2126f87d6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery",
    jsii_struct_bases=[],
    name_mapping={
        "data_source": "dataSource",
        "env": "env",
        "name": "name",
        "service": "service",
        "stat": "stat",
        "group_by": "groupBy",
        "operation_name": "operationName",
        "primary_tag_name": "primaryTagName",
        "primary_tag_value": "primaryTagValue",
        "resource_name": "resourceName",
    },
)
class DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery:
    def __init__(
        self,
        *,
        data_source: builtins.str,
        env: builtins.str,
        name: builtins.str,
        service: builtins.str,
        stat: builtins.str,
        group_by: typing.Optional[typing.Sequence[builtins.str]] = None,
        operation_name: typing.Optional[builtins.str] = None,
        primary_tag_name: typing.Optional[builtins.str] = None,
        primary_tag_value: typing.Optional[builtins.str] = None,
        resource_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param data_source: The data source for APM Resource Stats queries. Valid values are ``apm_resource_stats``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param env: APM Environment. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param service: APM service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        :param stat: APM statistic. Valid values are ``errors``, ``error_rate``, ``hits``, ``latency_avg``, ``latency_distribution``, ``latency_max``, ``latency_p50``, ``latency_p75``, ``latency_p90``, ``latency_p95``, ``latency_p99``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        :param group_by: Array of fields to group results by. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param operation_name: Name of operation on service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        :param primary_tag_name: The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        :param primary_tag_value: Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        :param resource_name: APM resource. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__86ac1279ba6b8ad497529535b2a6bf62c5db769eefde18d0e642081532f24503)
            check_type(argname="argument data_source", value=data_source, expected_type=type_hints["data_source"])
            check_type(argname="argument env", value=env, expected_type=type_hints["env"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument service", value=service, expected_type=type_hints["service"])
            check_type(argname="argument stat", value=stat, expected_type=type_hints["stat"])
            check_type(argname="argument group_by", value=group_by, expected_type=type_hints["group_by"])
            check_type(argname="argument operation_name", value=operation_name, expected_type=type_hints["operation_name"])
            check_type(argname="argument primary_tag_name", value=primary_tag_name, expected_type=type_hints["primary_tag_name"])
            check_type(argname="argument primary_tag_value", value=primary_tag_value, expected_type=type_hints["primary_tag_value"])
            check_type(argname="argument resource_name", value=resource_name, expected_type=type_hints["resource_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "data_source": data_source,
            "env": env,
            "name": name,
            "service": service,
            "stat": stat,
        }
        if group_by is not None:
            self._values["group_by"] = group_by
        if operation_name is not None:
            self._values["operation_name"] = operation_name
        if primary_tag_name is not None:
            self._values["primary_tag_name"] = primary_tag_name
        if primary_tag_value is not None:
            self._values["primary_tag_value"] = primary_tag_value
        if resource_name is not None:
            self._values["resource_name"] = resource_name

    @builtins.property
    def data_source(self) -> builtins.str:
        '''The data source for APM Resource Stats queries. Valid values are ``apm_resource_stats``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        assert result is not None, "Required property 'data_source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def env(self) -> builtins.str:
        '''APM Environment.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        '''
        result = self._values.get("env")
        assert result is not None, "Required property 'env' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def service(self) -> builtins.str:
        '''APM service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        '''
        result = self._values.get("service")
        assert result is not None, "Required property 'service' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def stat(self) -> builtins.str:
        '''APM statistic. Valid values are ``errors``, ``error_rate``, ``hits``, ``latency_avg``, ``latency_distribution``, ``latency_max``, ``latency_p50``, ``latency_p75``, ``latency_p90``, ``latency_p95``, ``latency_p99``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        '''
        result = self._values.get("stat")
        assert result is not None, "Required property 'stat' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def group_by(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Array of fields to group results by.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def operation_name(self) -> typing.Optional[builtins.str]:
        '''Name of operation on service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        '''
        result = self._values.get("operation_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def primary_tag_name(self) -> typing.Optional[builtins.str]:
        '''The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        '''
        result = self._values.get("primary_tag_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def primary_tag_value(self) -> typing.Optional[builtins.str]:
        '''Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        '''
        result = self._values.get("primary_tag_value")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def resource_name(self) -> typing.Optional[builtins.str]:
        '''APM resource.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        '''
        result = self._values.get("resource_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20ccf85dae3544b048bbf5082bef4c081f20cc6ed58989c06687c85dfc8d6bfd)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetOperationName")
    def reset_operation_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOperationName", []))

    @jsii.member(jsii_name="resetPrimaryTagName")
    def reset_primary_tag_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrimaryTagName", []))

    @jsii.member(jsii_name="resetPrimaryTagValue")
    def reset_primary_tag_value(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPrimaryTagValue", []))

    @jsii.member(jsii_name="resetResourceName")
    def reset_resource_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetResourceName", []))

    @builtins.property
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property
    @jsii.member(jsii_name="envInput")
    def env_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "envInput"))

    @builtins.property
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "groupByInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="operationNameInput")
    def operation_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "operationNameInput"))

    @builtins.property
    @jsii.member(jsii_name="primaryTagNameInput")
    def primary_tag_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagNameInput"))

    @builtins.property
    @jsii.member(jsii_name="primaryTagValueInput")
    def primary_tag_value_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagValueInput"))

    @builtins.property
    @jsii.member(jsii_name="resourceNameInput")
    def resource_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceNameInput"))

    @builtins.property
    @jsii.member(jsii_name="serviceInput")
    def service_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "serviceInput"))

    @builtins.property
    @jsii.member(jsii_name="statInput")
    def stat_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "statInput"))

    @builtins.property
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae862f4e2fbc85b3f67f24a7a46370feab17b2e71c06bd3657bfa6e764b12c9c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataSource", value)

    @builtins.property
    @jsii.member(jsii_name="env")
    def env(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "env"))

    @env.setter
    def env(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cccee583337d813e24763af1e99853f257bcc0ede83425d66ed82df7db0eda05)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "env", value)

    @builtins.property
    @jsii.member(jsii_name="groupBy")
    def group_by(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__388d957058dfd80af2802ebfc6f9b94ca6bbdec3c77ebce10f34a2129776a4e2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "groupBy", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf60923661e6de494aca863ca7315ecfa12af9785e1c19e96fedc8b3765fc853)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="operationName")
    def operation_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "operationName"))

    @operation_name.setter
    def operation_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__149de37519dd488ebc52a4328429a42b4bf7ee8224bdf01539b63b9f44959121)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "operationName", value)

    @builtins.property
    @jsii.member(jsii_name="primaryTagName")
    def primary_tag_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTagName"))

    @primary_tag_name.setter
    def primary_tag_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ba6d56cca219aba3c6794833ab62d7e68c72d861e32747fbf0678250c21d35e6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "primaryTagName", value)

    @builtins.property
    @jsii.member(jsii_name="primaryTagValue")
    def primary_tag_value(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTagValue"))

    @primary_tag_value.setter
    def primary_tag_value(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__60135b7a5a6e7841fe10e6800b1c4b31b47356ad1b5c891fc6819a5316aa796a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "primaryTagValue", value)

    @builtins.property
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resourceName"))

    @resource_name.setter
    def resource_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f55a5f308e7eb898d82722480e79b35886fa08bb1c3cf7c9bd96db4db3810c09)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "resourceName", value)

    @builtins.property
    @jsii.member(jsii_name="service")
    def service(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "service"))

    @service.setter
    def service(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__023d29533865faab3d0fb590d5ae59ec5d580ac198c31afa1f5d1da1419c55d3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "service", value)

    @builtins.property
    @jsii.member(jsii_name="stat")
    def stat(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "stat"))

    @stat.setter
    def stat(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f7ca1b5f3a4d000175b1a898b028a0107872343240fc244c9f2643cb9925be01)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "stat", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__83bb1a7cd1027376540fdc5237bfe4fe8b805a81f66b767a6b12e54fae1a68d5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryEventQuery",
    jsii_struct_bases=[],
    name_mapping={
        "compute": "compute",
        "data_source": "dataSource",
        "name": "name",
        "group_by": "groupBy",
        "indexes": "indexes",
        "search": "search",
        "storage": "storage",
    },
)
class DashboardWidgetChangeDefinitionRequestQueryEventQuery:
    def __init__(
        self,
        *,
        compute: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute", typing.Dict[builtins.str, typing.Any]]]],
        data_source: builtins.str,
        name: builtins.str,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        indexes: typing.Optional[typing.Sequence[builtins.str]] = None,
        search: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch", typing.Dict[builtins.str, typing.Any]]] = None,
        storage: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param compute: compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
        :param data_source: The data source for event platform-based queries. Valid values are ``logs``, ``spans``, ``network``, ``rum``, ``security_signals``, ``profiles``, ``audit``, ``events``, ``ci_tests``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param indexes: An array of index names to query in the stream. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
        :param search: search block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
        :param storage: Storage location (private beta). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#storage Dashboard#storage}
        '''
        if isinstance(search, dict):
            search = DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch(**search)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f86c0246aa40f9693b6f8441b8d46b95948890a0db0fb129bf9bb344b3f8654f)
            check_type(argname="argument compute", value=compute, expected_type=type_hints["compute"])
            check_type(argname="argument data_source", value=data_source, expected_type=type_hints["data_source"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument group_by", value=group_by, expected_type=type_hints["group_by"])
            check_type(argname="argument indexes", value=indexes, expected_type=type_hints["indexes"])
            check_type(argname="argument search", value=search, expected_type=type_hints["search"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "compute": compute,
            "data_source": data_source,
            "name": name,
        }
        if group_by is not None:
            self._values["group_by"] = group_by
        if indexes is not None:
            self._values["indexes"] = indexes
        if search is not None:
            self._values["search"] = search
        if storage is not None:
            self._values["storage"] = storage

    @builtins.property
    def compute(
        self,
    ) -> typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute"]]:
        '''compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
        '''
        result = self._values.get("compute")
        assert result is not None, "Required property 'compute' is missing"
        return typing.cast(typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute"]], result)

    @builtins.property
    def data_source(self) -> builtins.str:
        '''The data source for event platform-based queries. Valid values are ``logs``, ``spans``, ``network``, ``rum``, ``security_signals``, ``profiles``, ``audit``, ``events``, ``ci_tests``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        assert result is not None, "Required property 'data_source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy"]]], result)

    @builtins.property
    def indexes(self) -> typing.Optional[typing.List[builtins.str]]:
        '''An array of index names to query in the stream.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
        '''
        result = self._values.get("indexes")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def search(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch"]:
        '''search block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
        '''
        result = self._values.get("search")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch"], result)

    @builtins.property
    def storage(self) -> typing.Optional[builtins.str]:
        '''Storage location (private beta).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#storage Dashboard#storage}
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryEventQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "interval": "interval",
        "metric": "metric",
    },
)
class DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        interval: typing.Optional[jsii.Number] = None,
        metric: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation methods for event platform queries. Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param interval: A time interval in milliseconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        :param metric: The measurable attribute to compute. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d2fe442adc6fa90d821137403d24177ec6498d7f8ea3d6d6c190f94bc1baaaee)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
            check_type(argname="argument metric", value=metric, expected_type=type_hints["metric"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if interval is not None:
            self._values["interval"] = interval
        if metric is not None:
            self._values["metric"] = metric

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation methods for event platform queries.

        Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''A time interval in milliseconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def metric(self) -> typing.Optional[builtins.str]:
        '''The measurable attribute to compute.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryEventQueryComputeList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryEventQueryComputeList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ba9e8a9b036bd012a553633e6ba1337945199ff45313c7e7d4cae20d85d85e20)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestQueryEventQueryComputeOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bab1bf41a9b73ae61b5ea7f389ccaa2e25d9e04d762a3d28eaaef0fb2fb579d6)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestQueryEventQueryComputeOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0a15399b0fa20c82d13f4dc7f73777c2e0e71298dffdd8e067bcbd60740d3a14)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a71f24f6ef6fa69bb08da254af24ac7083b92c18cdcfa87ec408dc811dd2b73)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8d629e27516b68f4bda22568290a768aa92f6a5440b09b274e4c5d871e0268c3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ca2bfd6d80abbaec49993d016571e392fd1d47a469222b3691b532c0c16da28e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestQueryEventQueryComputeOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryEventQueryComputeOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78a7369a9a3b83f19f99695b615e836cd19a2d9b178a2a2cfbd25f6e2733f9d8)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @jsii.member(jsii_name="resetMetric")
    def reset_metric(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMetric", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="metricInput")
    def metric_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "metricInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__00a896bec669c23539458980e1ee2450f3b7e3e747faa1f87ddb9a4088cd4fc4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5b7b765a059a0bdd5f1673188d3784e9c3044c04a38e7e6b0fd1f3ee17c60ae1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="metric")
    def metric(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "metric"))

    @metric.setter
    def metric(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6339385fea630140f72c98e845844ef239dc3c459189aac1d9b2c403e21dccce)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "metric", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__495e46ed30efc032edd95339e266494be1ab5128570cbde7ad6b5624111becff)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort": "sort"},
)
class DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy:
    def __init__(
        self,
        *,
        facet: builtins.str,
        limit: typing.Optional[jsii.Number] = None,
        sort: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param facet: The event facet. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The number of groups to return. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort: sort block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        '''
        if isinstance(sort, dict):
            sort = DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort(**sort)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1983ece773d27d75e947910eacde9f2c129e0b4e9eae1d8f5fe6bef046a3d685)
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument sort", value=sort, expected_type=type_hints["sort"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "facet": facet,
        }
        if limit is not None:
            self._values["limit"] = limit
        if sort is not None:
            self._values["sort"] = sort

    @builtins.property
    def facet(self) -> builtins.str:
        '''The event facet.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        assert result is not None, "Required property 'facet' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The number of groups to return.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort"]:
        '''sort block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        '''
        result = self._values.get("sort")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f9cd768fcb4f6e85cf446a36d05fce01fb9a5c35efe3fda7ae1b499aeeb6b14f)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff1c4ecbc282bea06d56bc8ee80262ad5bf3c3220bd9f244e84cbc73850f490f)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__50b89eb8102c160689ee7676f1f6c9d97aba60d653d2cefb4771210efc9adee6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9fa77a22996a3d39a21d72430ba36d1b9b7bb730d68ec6db2da2616478cbd9d9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__073beba042791951ea5083b0c88418dcd57f5370e8954e4961e2568b9816acc3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea045ddd474bec85e18e62946a6a788e37842621803e18d1c223d8d03cc4fdae)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__313a3a042ceec4dae06145fbf0c6ee20d00d35e9284a723c767d7620aa7dc7d0)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putSort")
    def put_sort(
        self,
        *,
        aggregation: builtins.str,
        metric: typing.Optional[builtins.str] = None,
        order: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation methods for the event platform queries. Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param metric: The metric used for sorting group by results. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param order: Direction of sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        value = DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort(
            aggregation=aggregation, metric=metric, order=order
        )

        return typing.cast(None, jsii.invoke(self, "putSort", [value]))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSort")
    def reset_sort(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSort", []))

    @builtins.property
    @jsii.member(jsii_name="sort")
    def sort(
        self,
    ) -> "DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference":
        return typing.cast("DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference", jsii.get(self, "sort"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property
    @jsii.member(jsii_name="sortInput")
    def sort_input(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort"]:
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort"], jsii.get(self, "sortInput"))

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01bd2a78e40ff4965a0c3f0b34749059c83bd58cff649d4aef0e2252203017fc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3fadafd117ec0366482662fd7d218460eb87a36b4a4444151fdfa5dadb162fb6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "limit", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__61debd3f2827cf2d22b798e1bf41f498ee838e004f546400cdddc2802488cd00)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "metric": "metric", "order": "order"},
)
class DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        metric: typing.Optional[builtins.str] = None,
        order: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation methods for the event platform queries. Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param metric: The metric used for sorting group by results. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param order: Direction of sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a60883148295807bb38adae91ab5e6ec73374d2ff5c276570531af75e7d6dc91)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument metric", value=metric, expected_type=type_hints["metric"])
            check_type(argname="argument order", value=order, expected_type=type_hints["order"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if metric is not None:
            self._values["metric"] = metric
        if order is not None:
            self._values["order"] = order

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation methods for the event platform queries.

        Valid values are ``count``, ``cardinality``, ``median``, ``pc75``, ``pc90``, ``pc95``, ``pc98``, ``pc99``, ``sum``, ``min``, ``max``, ``avg``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def metric(self) -> typing.Optional[builtins.str]:
        '''The metric used for sorting group by results.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def order(self) -> typing.Optional[builtins.str]:
        '''Direction of sort. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__be804536e8b3a69db9ce6db825a529d0f33fc6ab3f5c3027a56e38dee2012b80)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetMetric")
    def reset_metric(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMetric", []))

    @jsii.member(jsii_name="resetOrder")
    def reset_order(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOrder", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="metricInput")
    def metric_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "metricInput"))

    @builtins.property
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e2d563efdb0afd11fd681ab035fed5ac6e4f0d9b6194a3cadf9162012e2c2979)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="metric")
    def metric(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "metric"))

    @metric.setter
    def metric(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e2b882f9348efcbf4ceeaf9a8eccf4b8bfb019d2286ea8b5381a7c3f058be48f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "metric", value)

    @builtins.property
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__05b4c91c0de004b79ec21ea8eba63ec7ff844a577b0da26a4a430ce61edaaf2e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "order", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__16018fcd98093a42636cc3d23d34431745c9470ae9356d8c29ffbfae2a66ac66)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestQueryEventQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryEventQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b336e6efee6f49f35e952dbf89fed8fc5807c817be8ec9671d268cfcc014fd05)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putCompute")
    def put_compute(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bde41fb20a3bacdcef754875ee994d201747533dff39f5f63874ddecd329013a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putCompute", [value]))

    @jsii.member(jsii_name="putGroupBy")
    def put_group_by(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__152f5dbf4fb22b335703bb5424eb819f6f5938bb49c369d0d31737bf76fde64c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putGroupBy", [value]))

    @jsii.member(jsii_name="putSearch")
    def put_search(self, *, query: builtins.str) -> None:
        '''
        :param query: The events search string. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        value = DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch(
            query=query
        )

        return typing.cast(None, jsii.invoke(self, "putSearch", [value]))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetIndexes")
    def reset_indexes(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIndexes", []))

    @jsii.member(jsii_name="resetSearch")
    def reset_search(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearch", []))

    @jsii.member(jsii_name="resetStorage")
    def reset_storage(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetStorage", []))

    @builtins.property
    @jsii.member(jsii_name="compute")
    def compute(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestQueryEventQueryComputeList:
        return typing.cast(DashboardWidgetChangeDefinitionRequestQueryEventQueryComputeList, jsii.get(self, "compute"))

    @builtins.property
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByList:
        return typing.cast(DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByList, jsii.get(self, "groupBy"))

    @builtins.property
    @jsii.member(jsii_name="search")
    def search(
        self,
    ) -> "DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference":
        return typing.cast("DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference", jsii.get(self, "search"))

    @builtins.property
    @jsii.member(jsii_name="computeInput")
    def compute_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute]]], jsii.get(self, "computeInput"))

    @builtins.property
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property
    @jsii.member(jsii_name="indexesInput")
    def indexes_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "indexesInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="searchInput")
    def search_input(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch"]:
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch"], jsii.get(self, "searchInput"))

    @builtins.property
    @jsii.member(jsii_name="storageInput")
    def storage_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "storageInput"))

    @builtins.property
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e04a77d5abeaae91ed21ce8fe9667aec32c31bf1d840db61a232d929a2cbbb7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataSource", value)

    @builtins.property
    @jsii.member(jsii_name="indexes")
    def indexes(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "indexes"))

    @indexes.setter
    def indexes(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6b838e8c899d4ab560fc5292b394110dd51e7b222a4d6fb3f0a16e9da1527a68)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "indexes", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20a3a434ef59b0a14b79ea67778457df87c307f57f4b7091ffcd977d85ad69c8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="storage")
    def storage(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "storage"))

    @storage.setter
    def storage(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aede3f93d0e0c941bcfb48553e49eac35d2aa2217e5bab320bc5c505ed387888)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "storage", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f20c562f91e310cb2f782c0b8847ce4bebdc2da6782710c0ff6ca68f030ffea)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch",
    jsii_struct_bases=[],
    name_mapping={"query": "query"},
)
class DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch:
    def __init__(self, *, query: builtins.str) -> None:
        '''
        :param query: The events search string. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2530397a1730dc1d8bad60867de1077dd1c667a3654b7292c30eb41f044ec6b6)
            check_type(argname="argument query", value=query, expected_type=type_hints["query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "query": query,
        }

    @builtins.property
    def query(self) -> builtins.str:
        '''The events search string.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        result = self._values.get("query")
        assert result is not None, "Required property 'query' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7906c2a2464fe3e8786b44fb90673f107e45cd2554fa5b8d9124ab101c0e9b26)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property
    @jsii.member(jsii_name="queryInput")
    def query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "queryInput"))

    @builtins.property
    @jsii.member(jsii_name="query")
    def query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "query"))

    @query.setter
    def query(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5cb49310520c70c62b28f9a352243a1b8495d32e60952983144786fb2776dc7b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "query", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1241aea8397613d00a05e784fa4e905be1f6e85236f950cec55ba99487b650ee)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestQueryList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1fc37501a877770f64d9dc3d494b38c0fc588118acfcc67a8c7f42c8d424e7ac)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestQueryOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__16c626cb72955c00ef7bb482d17b559eeddb5bd100ac00a1f3c8324fad473b36)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestQueryOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01c14020f33f8cc44c97c7b2e0263a4eccdb56150b32182152522c166e5115d0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__abb411f6d543379166a5de3001a371e1e27a41d07403bede5c33887e25c4d7a2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f299a295c1650ae1f5c333df47b1705a3303b045428179ec6f448e799a341c3a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQuery]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQuery]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestQuery]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bd5ab6e5db1e034952ab60f4c25163e494bda5d216d0384efb5d6564705f7b95)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryMetricQuery",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "query": "query",
        "aggregator": "aggregator",
        "data_source": "dataSource",
    },
)
class DashboardWidgetChangeDefinitionRequestQueryMetricQuery:
    def __init__(
        self,
        *,
        name: builtins.str,
        query: builtins.str,
        aggregator: typing.Optional[builtins.str] = None,
        data_source: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: The name of the query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param query: The metrics query definition. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        :param aggregator: The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        :param data_source: The data source for metrics queries. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4100208924b617506c145d1a9ba63023981da115c9d5dc1303068d5126ebfabf)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument query", value=query, expected_type=type_hints["query"])
            check_type(argname="argument aggregator", value=aggregator, expected_type=type_hints["aggregator"])
            check_type(argname="argument data_source", value=data_source, expected_type=type_hints["data_source"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "query": query,
        }
        if aggregator is not None:
            self._values["aggregator"] = aggregator
        if data_source is not None:
            self._values["data_source"] = data_source

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def query(self) -> builtins.str:
        '''The metrics query definition.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        '''
        result = self._values.get("query")
        assert result is not None, "Required property 'query' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def aggregator(self) -> typing.Optional[builtins.str]:
        '''The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        '''
        result = self._values.get("aggregator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def data_source(self) -> typing.Optional[builtins.str]:
        '''The data source for metrics queries.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryMetricQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryMetricQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryMetricQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__23226e8ac43d0c225137d7b17731ed80af0ba839b3cdbaf628043f8400abf12e)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetAggregator")
    def reset_aggregator(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAggregator", []))

    @jsii.member(jsii_name="resetDataSource")
    def reset_data_source(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDataSource", []))

    @builtins.property
    @jsii.member(jsii_name="aggregatorInput")
    def aggregator_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregatorInput"))

    @builtins.property
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="queryInput")
    def query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "queryInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregator")
    def aggregator(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregator"))

    @aggregator.setter
    def aggregator(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__354a4df99cb71651169e33435e843b12e1253d5935084503173fac32fea32962)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregator", value)

    @builtins.property
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__30e9ca702b1d3e7f37bb5d318655d425a7385868eace2ed724c144681cadfdc3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataSource", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d7b9462dda715d5a0474d262b6892f444969b78cd0985dc841fa3d203a4d2f5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="query")
    def query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "query"))

    @query.setter
    def query(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4635b81f367d146e9ae99cd7dbba738912487a099f225ec1884534efd96931f3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "query", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryMetricQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryMetricQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryMetricQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99348aa4fe28fd653bea61c6846dd10ea37ef49418916b69f83055460769bdfc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__22c4ecf1b8610b6d95f728e960d33a5c997a74f019c66dc9384c5993d1b8e132)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putApmDependencyStatsQuery")
    def put_apm_dependency_stats_query(
        self,
        *,
        data_source: builtins.str,
        env: builtins.str,
        name: builtins.str,
        operation_name: builtins.str,
        resource_name: builtins.str,
        service: builtins.str,
        stat: builtins.str,
        is_upstream: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        primary_tag_name: typing.Optional[builtins.str] = None,
        primary_tag_value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param data_source: The data source for APM Dependency Stats queries. Valid values are ``apm_dependency_stats``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param env: APM Environment. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param operation_name: Name of operation on service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        :param resource_name: APM resource. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        :param service: APM service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        :param stat: APM statistic. Valid values are ``avg_duration``, ``avg_root_duration``, ``avg_spans_per_trace``, ``error_rate``, ``pct_exec_time``, ``pct_of_traces``, ``total_traces_count``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        :param is_upstream: Determines whether stats for upstream or downstream dependencies should be queried. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
        :param primary_tag_name: The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        :param primary_tag_value: Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        '''
        value = DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery(
            data_source=data_source,
            env=env,
            name=name,
            operation_name=operation_name,
            resource_name=resource_name,
            service=service,
            stat=stat,
            is_upstream=is_upstream,
            primary_tag_name=primary_tag_name,
            primary_tag_value=primary_tag_value,
        )

        return typing.cast(None, jsii.invoke(self, "putApmDependencyStatsQuery", [value]))

    @jsii.member(jsii_name="putApmResourceStatsQuery")
    def put_apm_resource_stats_query(
        self,
        *,
        data_source: builtins.str,
        env: builtins.str,
        name: builtins.str,
        service: builtins.str,
        stat: builtins.str,
        group_by: typing.Optional[typing.Sequence[builtins.str]] = None,
        operation_name: typing.Optional[builtins.str] = None,
        primary_tag_name: typing.Optional[builtins.str] = None,
        primary_tag_value: typing.Optional[builtins.str] = None,
        resource_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param data_source: The data source for APM Resource Stats queries. Valid values are ``apm_resource_stats``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param env: APM Environment. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param service: APM service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        :param stat: APM statistic. Valid values are ``errors``, ``error_rate``, ``hits``, ``latency_avg``, ``latency_distribution``, ``latency_max``, ``latency_p50``, ``latency_p75``, ``latency_p90``, ``latency_p95``, ``latency_p99``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
        :param group_by: Array of fields to group results by. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param operation_name: Name of operation on service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
        :param primary_tag_name: The name of the second primary tag used within APM; required when ``primary_tag_value`` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
        :param primary_tag_value: Filter APM data by the second primary tag. ``primary_tag_name`` must also be specified. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
        :param resource_name: APM resource. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
        '''
        value = DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery(
            data_source=data_source,
            env=env,
            name=name,
            service=service,
            stat=stat,
            group_by=group_by,
            operation_name=operation_name,
            primary_tag_name=primary_tag_name,
            primary_tag_value=primary_tag_value,
            resource_name=resource_name,
        )

        return typing.cast(None, jsii.invoke(self, "putApmResourceStatsQuery", [value]))

    @jsii.member(jsii_name="putEventQuery")
    def put_event_query(
        self,
        *,
        compute: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute, typing.Dict[builtins.str, typing.Any]]]],
        data_source: builtins.str,
        name: builtins.str,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]]] = None,
        indexes: typing.Optional[typing.Sequence[builtins.str]] = None,
        search: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch, typing.Dict[builtins.str, typing.Any]]] = None,
        storage: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param compute: compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
        :param data_source: The data source for event platform-based queries. Valid values are ``logs``, ``spans``, ``network``, ``rum``, ``security_signals``, ``profiles``, ``audit``, ``events``, ``ci_tests``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param indexes: An array of index names to query in the stream. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
        :param search: search block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
        :param storage: Storage location (private beta). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#storage Dashboard#storage}
        '''
        value = DashboardWidgetChangeDefinitionRequestQueryEventQuery(
            compute=compute,
            data_source=data_source,
            name=name,
            group_by=group_by,
            indexes=indexes,
            search=search,
            storage=storage,
        )

        return typing.cast(None, jsii.invoke(self, "putEventQuery", [value]))

    @jsii.member(jsii_name="putMetricQuery")
    def put_metric_query(
        self,
        *,
        name: builtins.str,
        query: builtins.str,
        aggregator: typing.Optional[builtins.str] = None,
        data_source: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: The name of the query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param query: The metrics query definition. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
        :param aggregator: The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        :param data_source: The data source for metrics queries. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        value = DashboardWidgetChangeDefinitionRequestQueryMetricQuery(
            name=name, query=query, aggregator=aggregator, data_source=data_source
        )

        return typing.cast(None, jsii.invoke(self, "putMetricQuery", [value]))

    @jsii.member(jsii_name="putProcessQuery")
    def put_process_query(
        self,
        *,
        data_source: builtins.str,
        metric: builtins.str,
        name: builtins.str,
        aggregator: typing.Optional[builtins.str] = None,
        is_normalized_cpu: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort: typing.Optional[builtins.str] = None,
        tag_filters: typing.Optional[typing.Sequence[builtins.str]] = None,
        text_filter: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param data_source: The data source for process queries. Valid values are ``process``, ``container``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param metric: The process metric name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param aggregator: The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        :param is_normalized_cpu: Whether to normalize the CPU percentages. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
        :param limit: The number of hits to return. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort: The direction of the sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        :param tag_filters: An array of tags to filter by. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
        :param text_filter: The text to use as a filter. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
        '''
        value = DashboardWidgetChangeDefinitionRequestQueryProcessQuery(
            data_source=data_source,
            metric=metric,
            name=name,
            aggregator=aggregator,
            is_normalized_cpu=is_normalized_cpu,
            limit=limit,
            sort=sort,
            tag_filters=tag_filters,
            text_filter=text_filter,
        )

        return typing.cast(None, jsii.invoke(self, "putProcessQuery", [value]))

    @jsii.member(jsii_name="resetApmDependencyStatsQuery")
    def reset_apm_dependency_stats_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetApmDependencyStatsQuery", []))

    @jsii.member(jsii_name="resetApmResourceStatsQuery")
    def reset_apm_resource_stats_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetApmResourceStatsQuery", []))

    @jsii.member(jsii_name="resetEventQuery")
    def reset_event_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEventQuery", []))

    @jsii.member(jsii_name="resetMetricQuery")
    def reset_metric_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMetricQuery", []))

    @jsii.member(jsii_name="resetProcessQuery")
    def reset_process_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetProcessQuery", []))

    @builtins.property
    @jsii.member(jsii_name="apmDependencyStatsQuery")
    def apm_dependency_stats_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference, jsii.get(self, "apmDependencyStatsQuery"))

    @builtins.property
    @jsii.member(jsii_name="apmResourceStatsQuery")
    def apm_resource_stats_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference, jsii.get(self, "apmResourceStatsQuery"))

    @builtins.property
    @jsii.member(jsii_name="eventQuery")
    def event_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestQueryEventQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestQueryEventQueryOutputReference, jsii.get(self, "eventQuery"))

    @builtins.property
    @jsii.member(jsii_name="metricQuery")
    def metric_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestQueryMetricQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestQueryMetricQueryOutputReference, jsii.get(self, "metricQuery"))

    @builtins.property
    @jsii.member(jsii_name="processQuery")
    def process_query(
        self,
    ) -> "DashboardWidgetChangeDefinitionRequestQueryProcessQueryOutputReference":
        return typing.cast("DashboardWidgetChangeDefinitionRequestQueryProcessQueryOutputReference", jsii.get(self, "processQuery"))

    @builtins.property
    @jsii.member(jsii_name="apmDependencyStatsQueryInput")
    def apm_dependency_stats_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery], jsii.get(self, "apmDependencyStatsQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="apmResourceStatsQueryInput")
    def apm_resource_stats_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery], jsii.get(self, "apmResourceStatsQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="eventQueryInput")
    def event_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryEventQuery], jsii.get(self, "eventQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="metricQueryInput")
    def metric_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryMetricQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryMetricQuery], jsii.get(self, "metricQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="processQueryInput")
    def process_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestQueryProcessQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestQueryProcessQuery"], jsii.get(self, "processQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestQuery, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestQuery, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestQuery, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b0e05d9e9649960daeb0d4e7e861db5f023d7495a6761759d55915acebe1bfe6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryProcessQuery",
    jsii_struct_bases=[],
    name_mapping={
        "data_source": "dataSource",
        "metric": "metric",
        "name": "name",
        "aggregator": "aggregator",
        "is_normalized_cpu": "isNormalizedCpu",
        "limit": "limit",
        "sort": "sort",
        "tag_filters": "tagFilters",
        "text_filter": "textFilter",
    },
)
class DashboardWidgetChangeDefinitionRequestQueryProcessQuery:
    def __init__(
        self,
        *,
        data_source: builtins.str,
        metric: builtins.str,
        name: builtins.str,
        aggregator: typing.Optional[builtins.str] = None,
        is_normalized_cpu: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort: typing.Optional[builtins.str] = None,
        tag_filters: typing.Optional[typing.Sequence[builtins.str]] = None,
        text_filter: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param data_source: The data source for process queries. Valid values are ``process``, ``container``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        :param metric: The process metric name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param name: The name of query for use in formulas. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param aggregator: The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        :param is_normalized_cpu: Whether to normalize the CPU percentages. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
        :param limit: The number of hits to return. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort: The direction of the sort. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        :param tag_filters: An array of tags to filter by. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
        :param text_filter: The text to use as a filter. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__740cdad4ef3bf84ee468648f8c5cd5fe23bc24306d446a9f0f5d372d65459e95)
            check_type(argname="argument data_source", value=data_source, expected_type=type_hints["data_source"])
            check_type(argname="argument metric", value=metric, expected_type=type_hints["metric"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument aggregator", value=aggregator, expected_type=type_hints["aggregator"])
            check_type(argname="argument is_normalized_cpu", value=is_normalized_cpu, expected_type=type_hints["is_normalized_cpu"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument sort", value=sort, expected_type=type_hints["sort"])
            check_type(argname="argument tag_filters", value=tag_filters, expected_type=type_hints["tag_filters"])
            check_type(argname="argument text_filter", value=text_filter, expected_type=type_hints["text_filter"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "data_source": data_source,
            "metric": metric,
            "name": name,
        }
        if aggregator is not None:
            self._values["aggregator"] = aggregator
        if is_normalized_cpu is not None:
            self._values["is_normalized_cpu"] = is_normalized_cpu
        if limit is not None:
            self._values["limit"] = limit
        if sort is not None:
            self._values["sort"] = sort
        if tag_filters is not None:
            self._values["tag_filters"] = tag_filters
        if text_filter is not None:
            self._values["text_filter"] = text_filter

    @builtins.property
    def data_source(self) -> builtins.str:
        '''The data source for process queries. Valid values are ``process``, ``container``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
        '''
        result = self._values.get("data_source")
        assert result is not None, "Required property 'data_source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def metric(self) -> builtins.str:
        '''The process metric name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of query for use in formulas.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def aggregator(self) -> typing.Optional[builtins.str]:
        '''The aggregation methods available for metrics queries. Valid values are ``avg``, ``min``, ``max``, ``sum``, ``last``, ``area``, ``l2norm``, ``percentile``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
        '''
        result = self._values.get("aggregator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def is_normalized_cpu(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        '''Whether to normalize the CPU percentages.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
        '''
        result = self._values.get("is_normalized_cpu")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The number of hits to return.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort(self) -> typing.Optional[builtins.str]:
        '''The direction of the sort. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
        '''
        result = self._values.get("sort")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tag_filters(self) -> typing.Optional[typing.List[builtins.str]]:
        '''An array of tags to filter by.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
        '''
        result = self._values.get("tag_filters")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def text_filter(self) -> typing.Optional[builtins.str]:
        '''The text to use as a filter.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
        '''
        result = self._values.get("text_filter")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestQueryProcessQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestQueryProcessQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestQueryProcessQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ab39578cac7e6a70fd2720eb4344731674ec3ec6ab8de5f919fd3578939db0c3)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetAggregator")
    def reset_aggregator(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAggregator", []))

    @jsii.member(jsii_name="resetIsNormalizedCpu")
    def reset_is_normalized_cpu(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsNormalizedCpu", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSort")
    def reset_sort(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSort", []))

    @jsii.member(jsii_name="resetTagFilters")
    def reset_tag_filters(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTagFilters", []))

    @jsii.member(jsii_name="resetTextFilter")
    def reset_text_filter(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTextFilter", []))

    @builtins.property
    @jsii.member(jsii_name="aggregatorInput")
    def aggregator_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregatorInput"))

    @builtins.property
    @jsii.member(jsii_name="dataSourceInput")
    def data_source_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "dataSourceInput"))

    @builtins.property
    @jsii.member(jsii_name="isNormalizedCpuInput")
    def is_normalized_cpu_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "isNormalizedCpuInput"))

    @builtins.property
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property
    @jsii.member(jsii_name="metricInput")
    def metric_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "metricInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="sortInput")
    def sort_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "sortInput"))

    @builtins.property
    @jsii.member(jsii_name="tagFiltersInput")
    def tag_filters_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "tagFiltersInput"))

    @builtins.property
    @jsii.member(jsii_name="textFilterInput")
    def text_filter_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "textFilterInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregator")
    def aggregator(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregator"))

    @aggregator.setter
    def aggregator(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4596c81945bd5d8e2cfb24bb4552ebde66c0be130eb94bb82c42fc45b494d624)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregator", value)

    @builtins.property
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "dataSource"))

    @data_source.setter
    def data_source(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eedffcc580fe629c98ece69d4e40d079b0ee9ae6d73a2d39bd7048e4d75beb82)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataSource", value)

    @builtins.property
    @jsii.member(jsii_name="isNormalizedCpu")
    def is_normalized_cpu(
        self,
    ) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "isNormalizedCpu"))

    @is_normalized_cpu.setter
    def is_normalized_cpu(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b9839b4f7411412a7454fc96784f8fd6349cf57cafa37ed600b7917edbfceb20)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "isNormalizedCpu", value)

    @builtins.property
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c941d4863ead925675d6400590884630f23366e14b500bf092330c57a6739ff)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "limit", value)

    @builtins.property
    @jsii.member(jsii_name="metric")
    def metric(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "metric"))

    @metric.setter
    def metric(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7f9cbc3fe8b6c9617e80543c9e7339cb042dc8bdb2b29c3f5002973ad59f1f1c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "metric", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a5a6daba5166c60361b94ee499e073c0baebc5c9e0bbe4186f0efafc884e34c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="sort")
    def sort(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "sort"))

    @sort.setter
    def sort(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a277ca6d54e0b43c33232f4f657fea2f1f374ffb97da3908b2274efc2d55895c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "sort", value)

    @builtins.property
    @jsii.member(jsii_name="tagFilters")
    def tag_filters(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "tagFilters"))

    @tag_filters.setter
    def tag_filters(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1434dd84684cfa6c02795ac3ca142bc9824e1d026c6d608f7579a938087bf318)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagFilters", value)

    @builtins.property
    @jsii.member(jsii_name="textFilter")
    def text_filter(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "textFilter"))

    @text_filter.setter
    def text_filter(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0115a33ff90c301988db3dea4ee0427c33e6197fb6df78cc2253ef36f5a084f0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "textFilter", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestQueryProcessQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestQueryProcessQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestQueryProcessQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__752c6d851d28d877e397293290aa0e002da146ecadb5bc915ed9160738c98862)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestRumQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetChangeDefinitionRequestRumQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestRumQueryGroupBy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute", typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery(**compute_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8bb3bdba988f83eeb3331f57ba720d67477ec59c7642ad3a3f9ee4e384eac119)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
            check_type(argname="argument compute_query", value=compute_query, expected_type=type_hints["compute_query"])
            check_type(argname="argument group_by", value=group_by, expected_type=type_hints["group_by"])
            check_type(argname="argument multi_compute", value=multi_compute, expected_type=type_hints["multi_compute"])
            check_type(argname="argument search_query", value=search_query, expected_type=type_hints["search_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestRumQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestRumQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestRumQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ef7b7daec9cb63c9bc52ea97b8f84782e6eb22c6a1927a05deca9b61c6806d6)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c66db95f1436a572aa09bd27e5ae7bf98376f8b528e1c72760d2f8978514ba53)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d7cf43204e4c84300589831cac30f5bf87f30575dd5a023d8a300665c24d0204)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c4d8ef819bc0fea61c271a1e5337b6bc2941865f2e6b3e74761d9a676d5bb5f2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c034a3cc77204693aab3a21c50f4af82973ecc9af665c9b5434c4d98186aa19)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__edd59450de19af6cfdab8494f55571abde47a72725956de12309fbc6e7015156)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestRumQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetChangeDefinitionRequestRumQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery(**sort_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__18e303d3315a6dc6224cad9a20ca3ae35db854a67e7bcf8f1b35b24ab4e979be)
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument sort_query", value=sort_query, expected_type=type_hints["sort_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestRumQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestRumQueryGroupByList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestRumQueryGroupByList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46e79484083f8ce970b291e4544ba5d9c05963e582326590ae187847f9693e7d)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestRumQueryGroupByOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3337f56bf22cd11418aac8a7629ba1a7c894bfbcadf72b327bd2e060a64dc2c4)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestRumQueryGroupByOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dab5107b812e5165eb59cfd6c41944f4102928ec0771b9d3bc95a5f7c5fcc944)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dcd809d8db06d51ca852b5cff1046f21a3eb448100424f23fdd09c8e07dc2e2f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c515864efda6b15172e0dd8af770cfba3d51892893331147c7f7cc729043010f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__feb7b524d4bfbb7e177bfae3e66b39a105114fd2dae36a9367a796258ff48aa3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestRumQueryGroupByOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestRumQueryGroupByOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__748f6fadf7a498f0f04f0adafb3814d846bc7b0e1bfa787bfe612b87815979ed)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putSortQuery")
    def put_sort_query(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        value = DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery(
            aggregation=aggregation, order=order, facet=facet
        )

        return typing.cast(None, jsii.invoke(self, "putSortQuery", [value]))

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSortQuery")
    def reset_sort_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSortQuery", []))

    @builtins.property
    @jsii.member(jsii_name="sortQuery")
    def sort_query(
        self,
    ) -> "DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference":
        return typing.cast("DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference", jsii.get(self, "sortQuery"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property
    @jsii.member(jsii_name="sortQueryInput")
    def sort_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery"], jsii.get(self, "sortQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8255c36e8e5cedc5839a65486bb967a36db0d2877a6b1fd979a16d97777a2f34)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f59552e031ce5f00a96aac5581d0bd2273d3a4150ed33a0a035b230c9574e396)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "limit", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f4004b3fe56bc5d3112ac181dec2272edd5d75d12952bf5fdc1a33853868993f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e8c7d777b6ffd71e5ac8de0392b19e279575ddc5e1b06b74c19bb213ab59e574)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument order", value=order, expected_type=type_hints["order"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__74ea0adaafec2af854756aa28db6dc13f5fe79de357dfc7240cc373450cac337)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__63ca247e54460dacb041ef408ae950bb10f01ae2c17da31dc796dd63a56fe698)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ecc494c8f8c5c364a79537b40e0df9cc7ac76dd85f60bbe07862a349101dfe5f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ab0159ec538a3abb58fd1fd2f2f51c9e300506fb2dc9bf4519e9a065226504f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "order", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a3f58f1795ee0b448e5f0466b740b117c42e4e21084fd9c5b796d32f5cdc29f6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9319772f7188e2cc7eca9ac4aee0155d34836bd817fe7f3dc84cd50648f71298)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestRumQueryMultiComputeList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestRumQueryMultiComputeList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6b82648e69cfdc8ffb4736bac9f81401051f103414a3d594a909067bd18f67d6)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestRumQueryMultiComputeOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__afb7a925491ce1ebe7a372c87802d927993a406d6baf71f5cf1ad8fbe81f14a7)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestRumQueryMultiComputeOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f990e53f27d965b4904a533ad3642da252e9133e80b9d926b094fc29faa1540f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf2792f56e6a5c0da8bf819de6e83d06cb23796e07eb38d58e2457e99bcdc0a6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__58f28734cd9587db4ac78671156541c6839a40057b1d6810286c754dfcde6a7d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1920c2cd984c74d472b917ae0ce79900ad0c551ea3417faf34d6197999e13e00)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestRumQueryMultiComputeOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestRumQueryMultiComputeOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f105ae284f556dcd43891257f0f8d43af1430953378c6f8e0bd8d3addc18e6d0)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__110bf2dfb2048500ce84c57b7cca1310e534e57d65375892a34b1a3e246aab8d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f11b6a1159fe6b0456b34aad3df65a9a75e236102aebf46fc845ea093767a8df)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d6a13396470e405397142764ba2287460e3c19a59cea381c25ab64c91c45f7c1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f175454f28676acd393dcc535b935325b11d8b8c28f24364b8527f91c0abe78b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestRumQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestRumQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fee9b074a4fbe49b5e76453ec6fff11e9302a65e7cac562578d37eb7abd856f9)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="putGroupBy")
    def put_group_by(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71c04c30a65d922e743b487742c1e30f0442ce1a19e12d3845e1914b441d7827)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putGroupBy", [value]))

    @jsii.member(jsii_name="putMultiCompute")
    def put_multi_compute(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1a26f2e43c3e58bafcc219744960d4fcba788b6606a7358d7d35d003fe2938f3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putMultiCompute", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property
    @jsii.member(jsii_name="groupBy")
    def group_by(self) -> DashboardWidgetChangeDefinitionRequestRumQueryGroupByList:
        return typing.cast(DashboardWidgetChangeDefinitionRequestRumQueryGroupByList, jsii.get(self, "groupBy"))

    @builtins.property
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestRumQueryMultiComputeList:
        return typing.cast(DashboardWidgetChangeDefinitionRequestRumQueryMultiComputeList, jsii.get(self, "multiCompute"))

    @builtins.property
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0da97b8770c7b4233775519294fb2163173b4261e112590d4ae7e14f95d841fb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "index", value)

    @builtins.property
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2921f9750cae8475cbd61ed947f61d2ed66a7cf78dd30664e0a416686c6900ac)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "searchQuery", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestRumQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestRumQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestRumQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__449e20d112814ebe3700ca260a31dec5619c017fc858c073ada8c965ea96aa28)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestSecurityQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetChangeDefinitionRequestSecurityQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute", typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery(**compute_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ca55a42f80b0fcb99874a21bde7045e7cf1d694e6ac572f7c2c57631e75c24e)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
            check_type(argname="argument compute_query", value=compute_query, expected_type=type_hints["compute_query"])
            check_type(argname="argument group_by", value=group_by, expected_type=type_hints["group_by"])
            check_type(argname="argument multi_compute", value=multi_compute, expected_type=type_hints["multi_compute"])
            check_type(argname="argument search_query", value=search_query, expected_type=type_hints["search_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestSecurityQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e0e57c954126f314ce4da01bde512aa8a9df4365627d399a2900d6b21e1f733d)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1010505fb4392e7f3bdf375519193a88fd24baa4189d3e1bf4cf84617b4a9a53)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a5434576ce219a0b8bc465f6c82f8d4b4ae5d353b7f73f7502fda939ad8c0e57)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5b22a947b5b67286773f4c8e5b1285e19f02d33ef6f363cba0ab76fcee20e799)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__61de15de6263f0ec2d16ad3daeaa307be1d20842068c2483f42aa6092fc9783b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a2004019787274da5d6c2eaaeeaa859c70e9c27010ac45142730ab8896edc114)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional[typing.Union["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery(**sort_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2eb24222840d0506d868b1986e09ebb36897b3bca6079ef231deedfd94d79a52)
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument sort_query", value=sort_query, expected_type=type_hints["sort_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupByList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestSecurityQueryGroupByList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4977ed283fb973a3da5bf6fb877c6ac7a1b1174b0a549fe0a63ead7c1c4582eb)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestSecurityQueryGroupByOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c10e090ab339bf6d9da76425370b97188dbbfccf5d889b68923bde8ce698b09b)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestSecurityQueryGroupByOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__888b54f53e8774d77da0964dbc33bc98cebb85f56871c01fac32667b88e23b91)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ee52c55b574449a6a5ba93d0421923c66a922fbc12df74072e53df66354da72)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__90baeb955243c9258043dc1f8401ee59ad23a8133b99b3bc16c9f649af95e01e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__020a9c668ce5129f20685d5ef24356627d7e5cd8d21c3ed5f15198db61a8b9bd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupByOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestSecurityQueryGroupByOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b006e013f17efc102aae1ff9ffba6f2218a662d448f9b979ea43ceaa9c9d8398)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putSortQuery")
    def put_sort_query(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        value = DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery(
            aggregation=aggregation, order=order, facet=facet
        )

        return typing.cast(None, jsii.invoke(self, "putSortQuery", [value]))

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSortQuery")
    def reset_sort_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSortQuery", []))

    @builtins.property
    @jsii.member(jsii_name="sortQuery")
    def sort_query(
        self,
    ) -> "DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference":
        return typing.cast("DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference", jsii.get(self, "sortQuery"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property
    @jsii.member(jsii_name="sortQueryInput")
    def sort_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery"], jsii.get(self, "sortQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c260cdb5b99b7ce1d4d20f6bfc45855bd37263b21caa37d34234a8486ff9fb0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cd8fdb45dd4e0066910a044a4accb0a05b22996e5b5e92ad22e614a4c4353c03)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "limit", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__96f055aad3e5b69e06dcb6a602acce289849a9fddf223f68f8ed3c0c822eb8b8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__531fdfe28d7841a574fa872d7e9fd48f11d43b7bb263d6d80eea1ea1e4d4e3d5)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument order", value=order, expected_type=type_hints["order"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c08ddd53f46ab2918c48c5fbc284a2de476a4986d67a4b9b9728d41e05c4dc9)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a8ab32d9ee2cc4b2e4dc1be45216c51204cc7508e302e8f8bd3be04c35b8ef53)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fe6fdcc654807ca450f492e81afe2b8de121cc81460d9af445fe502e626f58ad)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0a407e62a0bf26ad2ddfcfe8f21f413f10509765caca67f3c5ac567ae07595a5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "order", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f7a6baf5e86b60659b82fba9477f836b8c844e4908f82d94bca5aec38d2985ec)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d05f54c2bced99e05caa3e80dae32356768e10aacff5308ca60cf87dce49a00)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7ee332768d7df57f1d127a7075113f04b93cde19dcfd3b9b35450c0f9ae9810e)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a991cb7b1505fda0bf3922972dec77194eaada0a6354aae3b7f8f088424dbc85)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a72ee2111ebd3bb86932bf63bea9ae068f0e5f9167603703d8ed05a7cf0ded4a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a22234692d08a51726ed1b74e66271093f4f7a9dab4a434ed33c4bb36be1bc1e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__27a43c08f9fd7042b7edc2d322fae5f1557c661c911bb45bbb1a037c3fe6d673)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d8cf8448846a87039f1d82ff48e4903c321cc9265f40e3f6aa8af559ea436b17)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5bc0baea36b635bdf52c5d226bbb14bd4866635169745c5586e1ba1c1c8d6e7a)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c39309b21e0dd0135c6ea964799ee4fb519c1776310e28d9d472d2d2ef9450c4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0be95533bdc1b005a8bd54e4562d21d4630a14795a0d11e644cd763457038a52)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3db8f27c675a2c4c663871fba538c8caa398437401392ef31a18586569189386)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d9b566ac1160e574d5837159fd4b0d90505f22715698cfa63d96face39a5d3c8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetChangeDefinitionRequestSecurityQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetChangeDefinitionRequestSecurityQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6917c7198ab3f1ed14f459305892067c2e54aa909872063b88540fca837049b3)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="putGroupBy")
    def put_group_by(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__55c365022fb9b9cec43be0ba2ed99edfff783c133ea86a634b1470e88ebb0565)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putGroupBy", [value]))

    @jsii.member(jsii_name="putMultiCompute")
    def put_multi_compute(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e59077f401a1a4b62e28bc1287ab707671652f04780d8b1885d4a54afaaab20c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putMultiCompute", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestSecurityQueryGroupByList:
        return typing.cast(DashboardWidgetChangeDefinitionRequestSecurityQueryGroupByList, jsii.get(self, "groupBy"))

    @builtins.property
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> DashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeList:
        return typing.cast(DashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeList, jsii.get(self, "multiCompute"))

    @builtins.property
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7edceb74b71c5a5d29b8759db424b9445e9fafb14f73327f799c0bf4632b5373)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "index", value)

    @builtins.property
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__35c37792d3c9d996ffeb214fe5d07eec2da48c43caaddc1939c483f118d8c9dc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "searchQuery", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQuery]:
        return typing.cast(typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetChangeDefinitionRequestSecurityQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e6d32cbaab27e3296399a3ad4052298f7527596674f8e8e8e8ddb1f6df1203c0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetCheckStatusDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "check": "check",
        "grouping": "grouping",
        "group": "group",
        "group_by": "groupBy",
        "live_span": "liveSpan",
        "tags": "tags",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetCheckStatusDefinition:
    def __init__(
        self,
        *,
        check: builtins.str,
        grouping: builtins.str,
        group: typing.Optional[builtins.str] = None,
        group_by: typing.Optional[typing.Sequence[builtins.str]] = None,
        live_span: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param check: The check to use in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check Dashboard#check}
        :param grouping: The kind of grouping to use. Valid values are ``check``, ``cluster``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#grouping Dashboard#grouping}
        :param group: The check group to use in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group Dashboard#group}
        :param group_by: When ``grouping = "cluster"``, indicates a list of tags to use for grouping. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param tags: A list of tags to use in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags Dashboard#tags}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ade8ddd62e1e4899fde8d88668269ab82926b0bf2a29f01941b6d03606d68b88)
            check_type(argname="argument check", value=check, expected_type=type_hints["check"])
            check_type(argname="argument grouping", value=grouping, expected_type=type_hints["grouping"])
            check_type(argname="argument group", value=group, expected_type=type_hints["group"])
            check_type(argname="argument group_by", value=group_by, expected_type=type_hints["group_by"])
            check_type(argname="argument live_span", value=live_span, expected_type=type_hints["live_span"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
            check_type(argname="argument title", value=title, expected_type=type_hints["title"])
            check_type(argname="argument title_align", value=title_align, expected_type=type_hints["title_align"])
            check_type(argname="argument title_size", value=title_size, expected_type=type_hints["title_size"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "check": check,
            "grouping": grouping,
        }
        if group is not None:
            self._values["group"] = group
        if group_by is not None:
            self._values["group_by"] = group_by
        if live_span is not None:
            self._values["live_span"] = live_span
        if tags is not None:
            self._values["tags"] = tags
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def check(self) -> builtins.str:
        '''The check to use in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check Dashboard#check}
        '''
        result = self._values.get("check")
        assert result is not None, "Required property 'check' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def grouping(self) -> builtins.str:
        '''The kind of grouping to use. Valid values are ``check``, ``cluster``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#grouping Dashboard#grouping}
        '''
        result = self._values.get("grouping")
        assert result is not None, "Required property 'grouping' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def group(self) -> typing.Optional[builtins.str]:
        '''The check group to use in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group Dashboard#group}
        '''
        result = self._values.get("group")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def group_by(self) -> typing.Optional[typing.List[builtins.str]]:
        '''When ``grouping = "cluster"``, indicates a list of tags to use for grouping.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of tags to use in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags Dashboard#tags}
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetCheckStatusDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetCheckStatusDefinitionOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetCheckStatusDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2bff9eb79c17be93a5af85361971e97b7f9889de22b6051b43b27aed664cbe88)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetGroup")
    def reset_group(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroup", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTags", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property
    @jsii.member(jsii_name="checkInput")
    def check_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "checkInput"))

    @builtins.property
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "groupByInput"))

    @builtins.property
    @jsii.member(jsii_name="groupingInput")
    def grouping_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "groupingInput"))

    @builtins.property
    @jsii.member(jsii_name="groupInput")
    def group_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "groupInput"))

    @builtins.property
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "tagsInput"))

    @builtins.property
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property
    @jsii.member(jsii_name="check")
    def check(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "check"))

    @check.setter
    def check(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea9ec2707d50a4c2527606eebcf6f0ee6965d8d6ff83d0a6af27fd3c5863d6cc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "check", value)

    @builtins.property
    @jsii.member(jsii_name="group")
    def group(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "group"))

    @group.setter
    def group(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6cc84bf421f76200674bf10fe1a309e4af391c6d02aa00ae5ba7201a3a356879)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "group", value)

    @builtins.property
    @jsii.member(jsii_name="groupBy")
    def group_by(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "groupBy"))

    @group_by.setter
    def group_by(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3b1c3bf9e62d12b324dd44ad2ac084ac5b10d5af76e163af472261832f9717bb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "groupBy", value)

    @builtins.property
    @jsii.member(jsii_name="grouping")
    def grouping(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "grouping"))

    @grouping.setter
    def grouping(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__468627742b5ce18601b21b99afa8f69849824608916a62b57a0b5faddc9d4593)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "grouping", value)

    @builtins.property
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eea2471be9a3db5044b7f56eda35feb0f393c2617a1862e10a47253b24ac2423)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "liveSpan", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "tags"))

    @tags.setter
    def tags(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b70539db8ce37c92cf60eb0617aab85a0c6ebb0c7e9604b826d6125b77a04cc2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__769bc355592c23bfa13fe94a473904d2900af5c5cfff7aca1cc2a3ee87adf278)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "title", value)

    @builtins.property
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ded99c919f0ea75c0233cfcb157675b3f9da9fe0a992b52ef1ce3c1899d78ae7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "titleAlign", value)

    @builtins.property
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__602a4ba51240d63eebc8039280e2ecc2c014023cae6f3218a46c62a2c1252c26)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "titleSize", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetCheckStatusDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetCheckStatusDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetCheckStatusDefinition],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__832ef3f7f116fe26fbb449affe32ff5e8cba30cdb326a6543c426eda34bd41e0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "legend_size": "legendSize",
        "live_span": "liveSpan",
        "request": "request",
        "show_legend": "showLegend",
        "title": "title",
        "title_align": "titleAlign",
        "title_size": "titleSize",
    },
)
class DashboardWidgetDistributionDefinition:
    def __init__(
        self,
        *,
        legend_size: typing.Optional[builtins.str] = None,
        live_span: typing.Optional[builtins.str] = None,
        request: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequest", typing.Dict[builtins.str, typing.Any]]]]] = None,
        show_legend: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        title: typing.Optional[builtins.str] = None,
        title_align: typing.Optional[builtins.str] = None,
        title_size: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param legend_size: The size of the legend displayed in the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#legend_size Dashboard#legend_size}
        :param live_span: The timeframe to use when displaying the widget. Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        :param request: request block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
        :param show_legend: Whether or not to show the legend on this widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_legend Dashboard#show_legend}
        :param title: The title of the widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        :param title_align: The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        :param title_size: The size of the widget's title (defaults to 16). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a1759bb4115cb65424085f14f81f4c7070966284edd0978843810eb14103a5e5)
            check_type(argname="argument legend_size", value=legend_size, expected_type=type_hints["legend_size"])
            check_type(argname="argument live_span", value=live_span, expected_type=type_hints["live_span"])
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
            check_type(argname="argument show_legend", value=show_legend, expected_type=type_hints["show_legend"])
            check_type(argname="argument title", value=title, expected_type=type_hints["title"])
            check_type(argname="argument title_align", value=title_align, expected_type=type_hints["title_align"])
            check_type(argname="argument title_size", value=title_size, expected_type=type_hints["title_size"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if legend_size is not None:
            self._values["legend_size"] = legend_size
        if live_span is not None:
            self._values["live_span"] = live_span
        if request is not None:
            self._values["request"] = request
        if show_legend is not None:
            self._values["show_legend"] = show_legend
        if title is not None:
            self._values["title"] = title
        if title_align is not None:
            self._values["title_align"] = title_align
        if title_size is not None:
            self._values["title_size"] = title_size

    @builtins.property
    def legend_size(self) -> typing.Optional[builtins.str]:
        '''The size of the legend displayed in the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#legend_size Dashboard#legend_size}
        '''
        result = self._values.get("legend_size")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def live_span(self) -> typing.Optional[builtins.str]:
        '''The timeframe to use when displaying the widget.

        Valid values are ``1m``, ``5m``, ``10m``, ``15m``, ``30m``, ``1h``, ``4h``, ``1d``, ``2d``, ``1w``, ``1mo``, ``3mo``, ``6mo``, ``1y``, ``alert``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
        '''
        result = self._values.get("live_span")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def request(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequest"]]]:
        '''request block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
        '''
        result = self._values.get("request")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequest"]]], result)

    @builtins.property
    def show_legend(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        '''Whether or not to show the legend on this widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_legend Dashboard#show_legend}
        '''
        result = self._values.get("show_legend")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''The title of the widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_align(self) -> typing.Optional[builtins.str]:
        '''The alignment of the widget's title. Valid values are ``center``, ``left``, ``right``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
        '''
        result = self._values.get("title_align")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title_size(self) -> typing.Optional[builtins.str]:
        '''The size of the widget's title (defaults to 16).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
        '''
        result = self._values.get("title_size")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1ed5a42421e38689d37e87ed7ee919a73696399aeaac159a49acc7450564d5c1)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putRequest")
    def put_request(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequest", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71a7a5597989e1cb2eb604b6ae2b97781ca0d576e04d907b9334916626399f96)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putRequest", [value]))

    @jsii.member(jsii_name="resetLegendSize")
    def reset_legend_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLegendSize", []))

    @jsii.member(jsii_name="resetLiveSpan")
    def reset_live_span(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLiveSpan", []))

    @jsii.member(jsii_name="resetRequest")
    def reset_request(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRequest", []))

    @jsii.member(jsii_name="resetShowLegend")
    def reset_show_legend(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShowLegend", []))

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitle", []))

    @jsii.member(jsii_name="resetTitleAlign")
    def reset_title_align(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleAlign", []))

    @jsii.member(jsii_name="resetTitleSize")
    def reset_title_size(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTitleSize", []))

    @builtins.property
    @jsii.member(jsii_name="request")
    def request(self) -> "DashboardWidgetDistributionDefinitionRequestList":
        return typing.cast("DashboardWidgetDistributionDefinitionRequestList", jsii.get(self, "request"))

    @builtins.property
    @jsii.member(jsii_name="legendSizeInput")
    def legend_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "legendSizeInput"))

    @builtins.property
    @jsii.member(jsii_name="liveSpanInput")
    def live_span_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "liveSpanInput"))

    @builtins.property
    @jsii.member(jsii_name="requestInput")
    def request_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequest"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequest"]]], jsii.get(self, "requestInput"))

    @builtins.property
    @jsii.member(jsii_name="showLegendInput")
    def show_legend_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "showLegendInput"))

    @builtins.property
    @jsii.member(jsii_name="titleAlignInput")
    def title_align_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleAlignInput"))

    @builtins.property
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleInput"))

    @builtins.property
    @jsii.member(jsii_name="titleSizeInput")
    def title_size_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "titleSizeInput"))

    @builtins.property
    @jsii.member(jsii_name="legendSize")
    def legend_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "legendSize"))

    @legend_size.setter
    def legend_size(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e255bac785336ba39d5c61d86f432dad3f0ce958cd08d30a79dd6d5098e4821a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "legendSize", value)

    @builtins.property
    @jsii.member(jsii_name="liveSpan")
    def live_span(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "liveSpan"))

    @live_span.setter
    def live_span(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c575f1f4e94fea430a9c4e05663f747feafdae6831bbf941b412479b70f40cb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "liveSpan", value)

    @builtins.property
    @jsii.member(jsii_name="showLegend")
    def show_legend(self) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "showLegend"))

    @show_legend.setter
    def show_legend(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8c0fc557bb0fe67ad4892d3cf27ed440492b467803fdc0eb01655553fc84e8e7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "showLegend", value)

    @builtins.property
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "title"))

    @title.setter
    def title(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4396b0be99d5b3d516a121902cd3bcc961f98965ed1c638ae1891ce78a0571cd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "title", value)

    @builtins.property
    @jsii.member(jsii_name="titleAlign")
    def title_align(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleAlign"))

    @title_align.setter
    def title_align(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9510e453e556437f8598a3d0979f5886d6a234ea8fe94a4567146cb2434f6200)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "titleAlign", value)

    @builtins.property
    @jsii.member(jsii_name="titleSize")
    def title_size(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "titleSize"))

    @title_size.setter
    def title_size(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eebbfeca371aadfce5558092055f5c5f09907a4edc2733bc4b0b9397eaf7e7da)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "titleSize", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[DashboardWidgetDistributionDefinition]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinition], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinition],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__456a784626e9355ee6b7d4717a0394109ffa81411c6b19c81db43db5b6f1281a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequest",
    jsii_struct_bases=[],
    name_mapping={
        "apm_query": "apmQuery",
        "apm_stats_query": "apmStatsQuery",
        "log_query": "logQuery",
        "process_query": "processQuery",
        "q": "q",
        "rum_query": "rumQuery",
        "security_query": "securityQuery",
        "style": "style",
    },
)
class DashboardWidgetDistributionDefinitionRequest:
    def __init__(
        self,
        *,
        apm_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestApmQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        apm_stats_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestApmStatsQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        log_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestLogQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        process_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestProcessQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        q: typing.Optional[builtins.str] = None,
        rum_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestRumQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        security_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestSecurityQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        style: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestStyle", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param apm_query: apm_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
        :param apm_stats_query: apm_stats_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_stats_query Dashboard#apm_stats_query}
        :param log_query: log_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
        :param process_query: process_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        :param q: The metric query to use for this widget. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
        :param rum_query: rum_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
        :param security_query: security_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
        :param style: style block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
        '''
        if isinstance(apm_query, dict):
            apm_query = DashboardWidgetDistributionDefinitionRequestApmQuery(**apm_query)
        if isinstance(apm_stats_query, dict):
            apm_stats_query = DashboardWidgetDistributionDefinitionRequestApmStatsQuery(**apm_stats_query)
        if isinstance(log_query, dict):
            log_query = DashboardWidgetDistributionDefinitionRequestLogQuery(**log_query)
        if isinstance(process_query, dict):
            process_query = DashboardWidgetDistributionDefinitionRequestProcessQuery(**process_query)
        if isinstance(rum_query, dict):
            rum_query = DashboardWidgetDistributionDefinitionRequestRumQuery(**rum_query)
        if isinstance(security_query, dict):
            security_query = DashboardWidgetDistributionDefinitionRequestSecurityQuery(**security_query)
        if isinstance(style, dict):
            style = DashboardWidgetDistributionDefinitionRequestStyle(**style)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71b739eb88b45e098dfdd9cbbb00a9c13c2c394d41e7cfc2b3819f253b3c9596)
            check_type(argname="argument apm_query", value=apm_query, expected_type=type_hints["apm_query"])
            check_type(argname="argument apm_stats_query", value=apm_stats_query, expected_type=type_hints["apm_stats_query"])
            check_type(argname="argument log_query", value=log_query, expected_type=type_hints["log_query"])
            check_type(argname="argument process_query", value=process_query, expected_type=type_hints["process_query"])
            check_type(argname="argument q", value=q, expected_type=type_hints["q"])
            check_type(argname="argument rum_query", value=rum_query, expected_type=type_hints["rum_query"])
            check_type(argname="argument security_query", value=security_query, expected_type=type_hints["security_query"])
            check_type(argname="argument style", value=style, expected_type=type_hints["style"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if apm_query is not None:
            self._values["apm_query"] = apm_query
        if apm_stats_query is not None:
            self._values["apm_stats_query"] = apm_stats_query
        if log_query is not None:
            self._values["log_query"] = log_query
        if process_query is not None:
            self._values["process_query"] = process_query
        if q is not None:
            self._values["q"] = q
        if rum_query is not None:
            self._values["rum_query"] = rum_query
        if security_query is not None:
            self._values["security_query"] = security_query
        if style is not None:
            self._values["style"] = style

    @builtins.property
    def apm_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQuery"]:
        '''apm_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
        '''
        result = self._values.get("apm_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQuery"], result)

    @builtins.property
    def apm_stats_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestApmStatsQuery"]:
        '''apm_stats_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_stats_query Dashboard#apm_stats_query}
        '''
        result = self._values.get("apm_stats_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestApmStatsQuery"], result)

    @builtins.property
    def log_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQuery"]:
        '''log_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
        '''
        result = self._values.get("log_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQuery"], result)

    @builtins.property
    def process_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestProcessQuery"]:
        '''process_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
        '''
        result = self._values.get("process_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestProcessQuery"], result)

    @builtins.property
    def q(self) -> typing.Optional[builtins.str]:
        '''The metric query to use for this widget.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
        '''
        result = self._values.get("q")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def rum_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQuery"]:
        '''rum_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
        '''
        result = self._values.get("rum_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQuery"], result)

    @builtins.property
    def security_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQuery"]:
        '''security_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
        '''
        result = self._values.get("security_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQuery"], result)

    @builtins.property
    def style(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestStyle"]:
        '''style block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
        '''
        result = self._values.get("style")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestStyle"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequest(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetDistributionDefinitionRequestApmQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute", typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery(**compute_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e639404138570598e876f181fdcb040ba7092cd796b5b4be7872fc3a99baad15)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
            check_type(argname="argument compute_query", value=compute_query, expected_type=type_hints["compute_query"])
            check_type(argname="argument group_by", value=group_by, expected_type=type_hints["group_by"])
            check_type(argname="argument multi_compute", value=multi_compute, expected_type=type_hints["multi_compute"])
            check_type(argname="argument search_query", value=search_query, expected_type=type_hints["search_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestApmQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3dacb786167d811e1d716882bdaaf2df893fff428e01c9229d628cc29f00503e)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__41605cb29a97075982fa773044786eace1e94571c9311c65eb2e2fab9de26253)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__24881a0adf554a389c95abb4e44e5e2aeacf1c34cc60f1d55a904c7bc6978f99)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__625135bceb3c3027ea00b91af52c73409f765788e9cf5d93b313ba4f8e2aee86)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__12dd97b6b596f0f3c25f86991e3d54444ca6c8febd30aeb1328c295724b340f9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ba794d7304005017758ac5f3862b27966845360048a11d4e34919f65cccf365)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery(**sort_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__273aa08703e11cae971a924542a3c467f644bf8da26cf804040739b5ef6d00d6)
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument sort_query", value=sort_query, expected_type=type_hints["sort_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestApmQueryGroupByList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmQueryGroupByList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3c28d96ace911a7029f30c8b8c0507754ca28177d6c1219f40ebf47e8d568382)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetDistributionDefinitionRequestApmQueryGroupByOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bf1c4f7a67e3cbf7fbe8745fc1eff2e09bcca28f2cf8e1e351e737350ad900dc)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetDistributionDefinitionRequestApmQueryGroupByOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a726d302ea1ba2976364475953c5417b10d04dd2faf033813b300b6e81f638d0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed2821a9c1e779266c32c0e9c3a5aff49b02e569af313fa195fe811ec0ad0a44)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c9ea437dded6b45e4844e8af6bdcf02776f014c5f736dccdb2d64ba6733c55d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b136e1d1794d94fa6a0451f720cda1f3ae6717d5c06f97f89732161f38ca90c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestApmQueryGroupByOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmQueryGroupByOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__603f605f207fcf53de38da7cb52f5945b5195601a255fa6d25514e74efb200b5)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putSortQuery")
    def put_sort_query(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        value = DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery(
            aggregation=aggregation, order=order, facet=facet
        )

        return typing.cast(None, jsii.invoke(self, "putSortQuery", [value]))

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSortQuery")
    def reset_sort_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSortQuery", []))

    @builtins.property
    @jsii.member(jsii_name="sortQuery")
    def sort_query(
        self,
    ) -> "DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference":
        return typing.cast("DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference", jsii.get(self, "sortQuery"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property
    @jsii.member(jsii_name="sortQueryInput")
    def sort_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery"], jsii.get(self, "sortQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__51dfe76ffc90e5ea54b56fdf4656efb4502608e5d0a84085327edcd46b84cafc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ce874991dc2226ae502d8904a0fcee8e51d2acd6bab263d30947b60e4a1a6fa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "limit", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5fd184e26c96d9f183dc59ee43c58025fb3e43556f8207301c8ac989094e9209)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__860f7df8919a8fc6de1e08f7889bbbfef68ff960ae242905e1a66caac0e0f08b)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument order", value=order, expected_type=type_hints["order"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d68b3484f30b4cc1c8a9a2677b0001e82045540df16ffad651924fa07e5b59ef)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9f3f7f7bd7c3e4327c68672b0e45bd00c812e8e3af563ade6b70fa2ab9bc22b7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0cbc9037c55b53e4862e49febd48e91731c87ea357f79f762941219bbf3ac125)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__85850c22ef41c2b3ffb497c86252d529d566d4b529aa6b2dab29cf7db480e6e4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "order", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c845308dbbfef4229c2938b259146bc2818821d0b2df78c1861ea5148c168dee)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1bfa5a10f265004a0a82991659477ab5fb3d996ef4bf93f2bf28bc36357d06c3)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4856b66b2e83827f841fdc28330c848c3d97f860b7a19da7b830eb36b9f15c56)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b39af8b8755bb42ac34396c93134e1d4b6b088bbca38aa201d296c21a19c8972)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2da16af436774f7a1d406bb2a0001c95e1d344c930b974fd0ae94838443ed282)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77b363312c41de0075a5a8a934c323a64e4e9885521367055998a72b5e9a6ebb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7ff6fa5a14fa9798457e4af0ef1374e700634b7bfc9f8c981bdfe774e9215ce3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b51a7134d5b34a1b877d9487a38c876291cdce5d5fc27303dd0a887b8d99945)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d00823e05fca0597eb8ad5fcfea80e43e416e9156f0563c526fb9b938637a63)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__80a597b4a9547e1a9730d981f720f3506405c7e18bde9716639b396c66dee897)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1bbff4e0e607e11a2bee1467b8fbf9a26d3182ecfa6b896dbc17afb1263e2cf0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fb9162ccfea41cc4b9c3265923267064d12107d78cc9e8c9296014f2ab5b7b10)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__de9544fed0a295aabe306375f6a6c3cc4ef76a2c5381aec9b28eb9ec45a5e9c4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestApmQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cc13ab1c6b849882d1010c10c7027cbac7158e46137ff090de0c8e164c86fda8)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="putGroupBy")
    def put_group_by(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a34bedb449a7e2e431114866968f1e84835cac911b9cb53643735dfc0e56c4f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putGroupBy", [value]))

    @jsii.member(jsii_name="putMultiCompute")
    def put_multi_compute(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ecdc4da902337b08fd0a940c5af0b7dbc97758b571638876d5845ec5f345c315)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putMultiCompute", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestApmQueryGroupByList:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestApmQueryGroupByList, jsii.get(self, "groupBy"))

    @builtins.property
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeList:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeList, jsii.get(self, "multiCompute"))

    @builtins.property
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7bcf8b4e49e55936b5e659f94c0514f410c74e5695727858efb4f8f6b1d9f77f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "index", value)

    @builtins.property
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__092e8d19440112e3e393ff074c97e42fa60c1ff4e52d31de2c7d4fdc880a305c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "searchQuery", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb2e4e5ceede5dec385da24f13c893f1539d92b86e172ff7d78ef87f12be8182)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmStatsQuery",
    jsii_struct_bases=[],
    name_mapping={
        "env": "env",
        "name": "name",
        "primary_tag": "primaryTag",
        "row_type": "rowType",
        "service": "service",
        "columns": "columns",
        "resource": "resource",
    },
)
class DashboardWidgetDistributionDefinitionRequestApmStatsQuery:
    def __init__(
        self,
        *,
        env: builtins.str,
        name: builtins.str,
        primary_tag: builtins.str,
        row_type: builtins.str,
        service: builtins.str,
        columns: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns", typing.Dict[builtins.str, typing.Any]]]]] = None,
        resource: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param env: The environment name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        :param name: The operation name associated with the service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param primary_tag: The organization's host group name and value. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag Dashboard#primary_tag}
        :param row_type: The level of detail for the request. Valid values are ``service``, ``resource``, ``span``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#row_type Dashboard#row_type}
        :param service: The service name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        :param columns: columns block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#columns Dashboard#columns}
        :param resource: The resource name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource Dashboard#resource}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3375ead69e6d9b946e2019fc1e2e565c07e86ff33559213aa3a3850090c51a95)
            check_type(argname="argument env", value=env, expected_type=type_hints["env"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument primary_tag", value=primary_tag, expected_type=type_hints["primary_tag"])
            check_type(argname="argument row_type", value=row_type, expected_type=type_hints["row_type"])
            check_type(argname="argument service", value=service, expected_type=type_hints["service"])
            check_type(argname="argument columns", value=columns, expected_type=type_hints["columns"])
            check_type(argname="argument resource", value=resource, expected_type=type_hints["resource"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "env": env,
            "name": name,
            "primary_tag": primary_tag,
            "row_type": row_type,
            "service": service,
        }
        if columns is not None:
            self._values["columns"] = columns
        if resource is not None:
            self._values["resource"] = resource

    @builtins.property
    def env(self) -> builtins.str:
        '''The environment name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        '''
        result = self._values.get("env")
        assert result is not None, "Required property 'env' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The operation name associated with the service.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def primary_tag(self) -> builtins.str:
        '''The organization's host group name and value.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag Dashboard#primary_tag}
        '''
        result = self._values.get("primary_tag")
        assert result is not None, "Required property 'primary_tag' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def row_type(self) -> builtins.str:
        '''The level of detail for the request. Valid values are ``service``, ``resource``, ``span``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#row_type Dashboard#row_type}
        '''
        result = self._values.get("row_type")
        assert result is not None, "Required property 'row_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def service(self) -> builtins.str:
        '''The service name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        '''
        result = self._values.get("service")
        assert result is not None, "Required property 'service' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def columns(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns"]]]:
        '''columns block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#columns Dashboard#columns}
        '''
        result = self._values.get("columns")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns"]]], result)

    @builtins.property
    def resource(self) -> typing.Optional[builtins.str]:
        '''The resource name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource Dashboard#resource}
        '''
        result = self._values.get("resource")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestApmStatsQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "alias": "alias",
        "cell_display_mode": "cellDisplayMode",
        "order": "order",
    },
)
class DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns:
    def __init__(
        self,
        *,
        name: builtins.str,
        alias: typing.Optional[builtins.str] = None,
        cell_display_mode: typing.Optional[builtins.str] = None,
        order: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: The column name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param alias: A user-assigned alias for the column. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
        :param cell_display_mode: A list of display modes for each table cell. Valid values are ``number``, ``bar``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20323cac118de09e0af4a1b1bb552edaf166c8c7ff3ba34216d127553a16206c)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument alias", value=alias, expected_type=type_hints["alias"])
            check_type(argname="argument cell_display_mode", value=cell_display_mode, expected_type=type_hints["cell_display_mode"])
            check_type(argname="argument order", value=order, expected_type=type_hints["order"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if alias is not None:
            self._values["alias"] = alias
        if cell_display_mode is not None:
            self._values["cell_display_mode"] = cell_display_mode
        if order is not None:
            self._values["order"] = order

    @builtins.property
    def name(self) -> builtins.str:
        '''The column name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alias(self) -> typing.Optional[builtins.str]:
        '''A user-assigned alias for the column.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
        '''
        result = self._values.get("alias")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cell_display_mode(self) -> typing.Optional[builtins.str]:
        '''A list of display modes for each table cell. Valid values are ``number``, ``bar``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
        '''
        result = self._values.get("cell_display_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def order(self) -> typing.Optional[builtins.str]:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c17d40ef5b16c6112324938957866c86a6884ddc1a265940adeac25a65aa7f9e)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9bd608a2f6fc081b3f2b118b45a02ca2e6ccdc43a7e38d684bfc7543116f76d9)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8e5f0e9ca09c2deaa16308f41576dd08c84c028aafe0ed0f6a66cf1d873fbf2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0508f870a4665670753ac8592fc7beef6845e47981764b664913aa0c0a8c6098)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c7cbb7ef4d71c38fe15374c024e5f9d8d94eb0443cfab29fb28a44b0edcf92b9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d16b3f2b2b9d53bc9752970aa9339c83111a3bf51031f402702164a6f5a8efe3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__326253b2029d59d3ce9b4dc6774e9fd3efd67946327f3ade8e32e27c809541d6)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetAlias")
    def reset_alias(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAlias", []))

    @jsii.member(jsii_name="resetCellDisplayMode")
    def reset_cell_display_mode(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCellDisplayMode", []))

    @jsii.member(jsii_name="resetOrder")
    def reset_order(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOrder", []))

    @builtins.property
    @jsii.member(jsii_name="aliasInput")
    def alias_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aliasInput"))

    @builtins.property
    @jsii.member(jsii_name="cellDisplayModeInput")
    def cell_display_mode_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "cellDisplayModeInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property
    @jsii.member(jsii_name="alias")
    def alias(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "alias"))

    @alias.setter
    def alias(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1ee7b68ed97dfb3896766132e7d26d324f5f720e1326331bb326013a952bc9f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "alias", value)

    @builtins.property
    @jsii.member(jsii_name="cellDisplayMode")
    def cell_display_mode(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "cellDisplayMode"))

    @cell_display_mode.setter
    def cell_display_mode(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b951cb4344df1fc300b74e7f0cb20c79e1af93a2b564c714fec6934b241d5c76)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "cellDisplayMode", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__acd268da8186d63156bd3a197cbd70b5bdac07a0a497f9296c1e028f4738fde5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__537e6aae98fc608c15a6e44ceba76aa187e52602ea6aed1a10864fe7e3f9aae4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "order", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6c7352ab2bf83f261c6213832b73c6b8fdc6a2f3e35111a9eca2ed965d706f3e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestApmStatsQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestApmStatsQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__17b9f1a0d177afe9beb673e5bec2bcb61bffea548246d2fe0ad3f99b1409391a)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putColumns")
    def put_columns(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d7170ed99612aec709a48aae5ddb65296e2feda78077da0221446907459103e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putColumns", [value]))

    @jsii.member(jsii_name="resetColumns")
    def reset_columns(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetColumns", []))

    @jsii.member(jsii_name="resetResource")
    def reset_resource(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetResource", []))

    @builtins.property
    @jsii.member(jsii_name="columns")
    def columns(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsList:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsList, jsii.get(self, "columns"))

    @builtins.property
    @jsii.member(jsii_name="columnsInput")
    def columns_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns]]], jsii.get(self, "columnsInput"))

    @builtins.property
    @jsii.member(jsii_name="envInput")
    def env_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "envInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="primaryTagInput")
    def primary_tag_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "primaryTagInput"))

    @builtins.property
    @jsii.member(jsii_name="resourceInput")
    def resource_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceInput"))

    @builtins.property
    @jsii.member(jsii_name="rowTypeInput")
    def row_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "rowTypeInput"))

    @builtins.property
    @jsii.member(jsii_name="serviceInput")
    def service_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "serviceInput"))

    @builtins.property
    @jsii.member(jsii_name="env")
    def env(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "env"))

    @env.setter
    def env(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__be9e051d2c5f4a398a44127d1e97ee1aa49fbbb6bd001579e05be0053dba8842)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "env", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6e6858a2f6c43e8a9a6fb3ba6d24ca250b281a06bf284c97e7d2784320bacc5f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="primaryTag")
    def primary_tag(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "primaryTag"))

    @primary_tag.setter
    def primary_tag(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cc882d0489e6e6e08b657e838ccfe833d4493d2f67a633c9dd0c8245381aa933)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "primaryTag", value)

    @builtins.property
    @jsii.member(jsii_name="resource")
    def resource(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resource"))

    @resource.setter
    def resource(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__87ebeecfc922f5347c9694bc786226ee0e4d936dd03ec8b3cdd45ec7d08a03ab)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "resource", value)

    @builtins.property
    @jsii.member(jsii_name="rowType")
    def row_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "rowType"))

    @row_type.setter
    def row_type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d4f83d46b335115c99c68a47baf85e23c0775351493cb33b0a268ac26dee72d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "rowType", value)

    @builtins.property
    @jsii.member(jsii_name="service")
    def service(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "service"))

    @service.setter
    def service(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__106507197e7030216968a241b2cee8870e07474de65b8a281f79c50c864ecf05)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "service", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestApmStatsQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestApmStatsQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestApmStatsQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__49652d2e21c8273f25e39d40ee5523001f671b615f308b8085b3de4032c9aec7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0739501b179ec7e545898db4398e61e2f708341fdf8632263b55fc31e8e566c1)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetDistributionDefinitionRequestOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__270ee7f02ceb1c2cf911f7211a504962c4b9998eb32fafef88c772df44f474f8)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetDistributionDefinitionRequestOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__313cdd0fa3cec112869854d09bf01d4fb8a613024e3dab4c1ced8da59c2278cc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__008a4c0ed87d957888371eaa89383fdd644d6e5e315542d4eab733d8dd1a9a22)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c7d45b2490b66063aaee36e86933af15fd6206d156c7b66ebac1ae6ebcc904b5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequest]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequest]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequest]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8567d6fa42c79f63fe57bd08eb61336ed0a2358c147caf45459ff5ce866368f8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestLogQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetDistributionDefinitionRequestLogQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute", typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery(**compute_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__95065e935dba6cdd43e02cc9c957a8294339e66076d80d876fb1dbaa8a2b7695)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
            check_type(argname="argument compute_query", value=compute_query, expected_type=type_hints["compute_query"])
            check_type(argname="argument group_by", value=group_by, expected_type=type_hints["group_by"])
            check_type(argname="argument multi_compute", value=multi_compute, expected_type=type_hints["multi_compute"])
            check_type(argname="argument search_query", value=search_query, expected_type=type_hints["search_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestLogQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f0b879f8f0ae448024976b2aac0a9ba8cabfbc4f45ee3b0b456f62f623c1a530)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6e8e4944f59df7b604714a63b6f1f57c0b0f15d11972ed356a42ccc162c3bd34)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c2136a4cdd0d8d6c2ad41b413d2e157961f63979c305b72d360e520f65090c96)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d6c14958125fef3fa260819a1b1a994fed0803587410766560f26a75fc8eedf0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8f21301fcb19f0e984c006317c1b3a53077ce9160b321f0e8b91d2908bdfb35)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__421defff165b5d92cfd0e38819958dd5c3f15d2a86c84c0f6827c2799e0379cf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery(**sort_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b01d2b45d5b1d013926e30448daf4ee458415acac1762a7d440f12f36a71fd7)
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument sort_query", value=sort_query, expected_type=type_hints["sort_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestLogQueryGroupByList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestLogQueryGroupByList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d84c657f60a377d9950084a314dd9f43dfcc111b91ee05fec3a6ddce293f0b01)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetDistributionDefinitionRequestLogQueryGroupByOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__432704bb823acb550fe8b2bec86f68571ce53857559499b3bc7d2f3e6e60a2de)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetDistributionDefinitionRequestLogQueryGroupByOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ba1d516d8a39319e4fa832f0f11423e5d308efa8e550ec5b10a702d3dfc9bbe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1d7de4888fd21d40b72df3911ac8a2868c487f27076ab7a7ded8c667ab3096b4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__32b0d1f8eeb4172c8c3e98ffb03012e2fa4d6e5186f6d1a23134c40628e26fd0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8aa3181beb7b32c7a0879fe89c6486f4c392736eed2144f49db10ce50d7a0bb4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestLogQueryGroupByOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestLogQueryGroupByOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b59a2845f957efc4651a91784bc674f025252a114e377b2954681c01e2da167c)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putSortQuery")
    def put_sort_query(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        value = DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery(
            aggregation=aggregation, order=order, facet=facet
        )

        return typing.cast(None, jsii.invoke(self, "putSortQuery", [value]))

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSortQuery")
    def reset_sort_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSortQuery", []))

    @builtins.property
    @jsii.member(jsii_name="sortQuery")
    def sort_query(
        self,
    ) -> "DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference":
        return typing.cast("DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference", jsii.get(self, "sortQuery"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property
    @jsii.member(jsii_name="sortQueryInput")
    def sort_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery"], jsii.get(self, "sortQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d88ee41f357075a01269e40341b08cd8315653db55bdea9478290e6c9d26202)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb0e52a694a2ee46f2010ab07af217ee8959b0a49dab6e05b9feb214b4e073d4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "limit", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed6844fdace6c0d09b388bdb241c4377d9d8f19f310d217398c4c9a4d7bc0abf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__275e07e67aa6cfaebd32814d945d861c18777a8452840a8f39775c5d3882044b)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument order", value=order, expected_type=type_hints["order"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__febccdc710068a7bf0f5646f61f1a7bc89560da1c07972652a0c3cdcf2ccbaf0)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__57fff7d16e2583dd8605415f184f2a8f0748a306be6f5d6978c8475c43409639)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__788009f3369207fbb28ac58a35ad33a0eddc2af44c6603a17816021344e3d2df)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70e15287abba53db9606167c08031ce94ae635e8a2d9cea7f6efab64a2ecd579)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "order", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__31aa263c06686a772a6bc730410762cf20665d0ae65425b2265fa408dcdb0811)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff97e70695fb65b2631a551c01754a289b01a26eaccc5cf5b93ee11432a642a1)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9fdcc3cf2b3424f607a0c9929b43d96a8382e39a7b2372b2bef4d5cc96c4e51a)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__62c8211e85ed22539b9907a4c35389dc7e77021cb01c7c9df826f08edaece410)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3a76feb16bfb7226e5bd4d957e4bd1a855310968015b7a4d558d996a4ef0143a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6834cd88458ffdba13e9833550ce5349f227656bd77a98e0641ad18de688e3ef)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__464359a4ed547c82d63a2e330282e05ebcc25ea6b7f8b05174506074a03f0b89)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ca93d6d8217eedf50c9c25be5a85d0338743ffae98d1fa20f62ed611542fb339)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77f8b30f0d47d6d281716981cda79788693f47f57e2f83b700fd933827405804)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0efdcdf36682d4a22a42e6c33d1fdca0e0c2136b975b1a4b0da6682de6ada306)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__49166deb5f8861f489abc3a7c9310a50940d870020019f68fed8316490eaecc2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__45eaa0ed4278da5fa036964c3785b4a7b169458f8d91f50f72c09e5e393e1123)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bed92905404ea61df07b99e3737359f5c5458341a92f74237e346000ea3d07b8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestLogQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestLogQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3b1df810e806a9a1e81f0f7cb860735f1039d33551a132e9511e681b58390c61)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="putGroupBy")
    def put_group_by(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__879ad8cf8ff2f61bbcb213906904c8da57213d6bb18b2b476b4614754bc37d9b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putGroupBy", [value]))

    @jsii.member(jsii_name="putMultiCompute")
    def put_multi_compute(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__347762d14222c02bccf56d2a93c0efbdd53dfa37de2c9e7dd950b13899986af1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putMultiCompute", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestLogQueryGroupByList:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestLogQueryGroupByList, jsii.get(self, "groupBy"))

    @builtins.property
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeList:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeList, jsii.get(self, "multiCompute"))

    @builtins.property
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c10ca8cd5e7d3fdb800edc3c7340f8bb92d43517c1be46abe6a16564010c3290)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "index", value)

    @builtins.property
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__289bf5345c67d7c362f670aecc8464be115c349b8a95a1f537c7a295bcf96e2b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "searchQuery", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6aadc8dfdc39b507eb06531f6a4f5a4825acaaf8e466cbabe6bd22ca6ae9d4f1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eb597b6d2a06a086089fd5dc82d2bb993d1b970a1eccd5330ec2beec441fefe9)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putApmQuery")
    def put_apm_query(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery, typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute, typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        value = DashboardWidgetDistributionDefinitionRequestApmQuery(
            index=index,
            compute_query=compute_query,
            group_by=group_by,
            multi_compute=multi_compute,
            search_query=search_query,
        )

        return typing.cast(None, jsii.invoke(self, "putApmQuery", [value]))

    @jsii.member(jsii_name="putApmStatsQuery")
    def put_apm_stats_query(
        self,
        *,
        env: builtins.str,
        name: builtins.str,
        primary_tag: builtins.str,
        row_type: builtins.str,
        service: builtins.str,
        columns: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns, typing.Dict[builtins.str, typing.Any]]]]] = None,
        resource: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param env: The environment name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
        :param name: The operation name associated with the service. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
        :param primary_tag: The organization's host group name and value. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag Dashboard#primary_tag}
        :param row_type: The level of detail for the request. Valid values are ``service``, ``resource``, ``span``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#row_type Dashboard#row_type}
        :param service: The service name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
        :param columns: columns block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#columns Dashboard#columns}
        :param resource: The resource name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource Dashboard#resource}
        '''
        value = DashboardWidgetDistributionDefinitionRequestApmStatsQuery(
            env=env,
            name=name,
            primary_tag=primary_tag,
            row_type=row_type,
            service=service,
            columns=columns,
            resource=resource,
        )

        return typing.cast(None, jsii.invoke(self, "putApmStatsQuery", [value]))

    @jsii.member(jsii_name="putLogQuery")
    def put_log_query(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery, typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute, typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        value = DashboardWidgetDistributionDefinitionRequestLogQuery(
            index=index,
            compute_query=compute_query,
            group_by=group_by,
            multi_compute=multi_compute,
            search_query=search_query,
        )

        return typing.cast(None, jsii.invoke(self, "putLogQuery", [value]))

    @jsii.member(jsii_name="putProcessQuery")
    def put_process_query(
        self,
        *,
        metric: builtins.str,
        filter_by: typing.Optional[typing.Sequence[builtins.str]] = None,
        limit: typing.Optional[jsii.Number] = None,
        search_by: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric: Your chosen metric. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param filter_by: A list of processes. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
        :param limit: The max number of items in the filter list. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param search_by: Your chosen search term. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
        '''
        value = DashboardWidgetDistributionDefinitionRequestProcessQuery(
            metric=metric, filter_by=filter_by, limit=limit, search_by=search_by
        )

        return typing.cast(None, jsii.invoke(self, "putProcessQuery", [value]))

    @jsii.member(jsii_name="putRumQuery")
    def put_rum_query(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute", typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        value = DashboardWidgetDistributionDefinitionRequestRumQuery(
            index=index,
            compute_query=compute_query,
            group_by=group_by,
            multi_compute=multi_compute,
            search_query=search_query,
        )

        return typing.cast(None, jsii.invoke(self, "putRumQuery", [value]))

    @jsii.member(jsii_name="putSecurityQuery")
    def put_security_query(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute", typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        value = DashboardWidgetDistributionDefinitionRequestSecurityQuery(
            index=index,
            compute_query=compute_query,
            group_by=group_by,
            multi_compute=multi_compute,
            search_query=search_query,
        )

        return typing.cast(None, jsii.invoke(self, "putSecurityQuery", [value]))

    @jsii.member(jsii_name="putStyle")
    def put_style(self, *, palette: typing.Optional[builtins.str] = None) -> None:
        '''
        :param palette: A color palette to apply to the widget. The available options are available at: https://docs.datadoghq.com/dashboards/widgets/timeseries/#appearance. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
        '''
        value = DashboardWidgetDistributionDefinitionRequestStyle(palette=palette)

        return typing.cast(None, jsii.invoke(self, "putStyle", [value]))

    @jsii.member(jsii_name="resetApmQuery")
    def reset_apm_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetApmQuery", []))

    @jsii.member(jsii_name="resetApmStatsQuery")
    def reset_apm_stats_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetApmStatsQuery", []))

    @jsii.member(jsii_name="resetLogQuery")
    def reset_log_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLogQuery", []))

    @jsii.member(jsii_name="resetProcessQuery")
    def reset_process_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetProcessQuery", []))

    @jsii.member(jsii_name="resetQ")
    def reset_q(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetQ", []))

    @jsii.member(jsii_name="resetRumQuery")
    def reset_rum_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRumQuery", []))

    @jsii.member(jsii_name="resetSecurityQuery")
    def reset_security_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSecurityQuery", []))

    @jsii.member(jsii_name="resetStyle")
    def reset_style(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetStyle", []))

    @builtins.property
    @jsii.member(jsii_name="apmQuery")
    def apm_query(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestApmQueryOutputReference:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestApmQueryOutputReference, jsii.get(self, "apmQuery"))

    @builtins.property
    @jsii.member(jsii_name="apmStatsQuery")
    def apm_stats_query(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestApmStatsQueryOutputReference:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestApmStatsQueryOutputReference, jsii.get(self, "apmStatsQuery"))

    @builtins.property
    @jsii.member(jsii_name="logQuery")
    def log_query(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestLogQueryOutputReference:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestLogQueryOutputReference, jsii.get(self, "logQuery"))

    @builtins.property
    @jsii.member(jsii_name="processQuery")
    def process_query(
        self,
    ) -> "DashboardWidgetDistributionDefinitionRequestProcessQueryOutputReference":
        return typing.cast("DashboardWidgetDistributionDefinitionRequestProcessQueryOutputReference", jsii.get(self, "processQuery"))

    @builtins.property
    @jsii.member(jsii_name="rumQuery")
    def rum_query(
        self,
    ) -> "DashboardWidgetDistributionDefinitionRequestRumQueryOutputReference":
        return typing.cast("DashboardWidgetDistributionDefinitionRequestRumQueryOutputReference", jsii.get(self, "rumQuery"))

    @builtins.property
    @jsii.member(jsii_name="securityQuery")
    def security_query(
        self,
    ) -> "DashboardWidgetDistributionDefinitionRequestSecurityQueryOutputReference":
        return typing.cast("DashboardWidgetDistributionDefinitionRequestSecurityQueryOutputReference", jsii.get(self, "securityQuery"))

    @builtins.property
    @jsii.member(jsii_name="style")
    def style(
        self,
    ) -> "DashboardWidgetDistributionDefinitionRequestStyleOutputReference":
        return typing.cast("DashboardWidgetDistributionDefinitionRequestStyleOutputReference", jsii.get(self, "style"))

    @builtins.property
    @jsii.member(jsii_name="apmQueryInput")
    def apm_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestApmQuery], jsii.get(self, "apmQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="apmStatsQueryInput")
    def apm_stats_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestApmStatsQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestApmStatsQuery], jsii.get(self, "apmStatsQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="logQueryInput")
    def log_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestLogQuery], jsii.get(self, "logQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="processQueryInput")
    def process_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestProcessQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestProcessQuery"], jsii.get(self, "processQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="qInput")
    def q_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "qInput"))

    @builtins.property
    @jsii.member(jsii_name="rumQueryInput")
    def rum_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQuery"], jsii.get(self, "rumQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="securityQueryInput")
    def security_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestSecurityQuery"], jsii.get(self, "securityQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="styleInput")
    def style_input(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestStyle"]:
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestStyle"], jsii.get(self, "styleInput"))

    @builtins.property
    @jsii.member(jsii_name="q")
    def q(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "q"))

    @q.setter
    def q(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea7b38755e9d512f8e455c64c8d80040db7918da7fd673e584b7054ae0e0688b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "q", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequest, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequest, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequest, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__696fb66adc48592bb633daf7a2639ed8dcdc807f0314f11eddffc7573f6c4331)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestProcessQuery",
    jsii_struct_bases=[],
    name_mapping={
        "metric": "metric",
        "filter_by": "filterBy",
        "limit": "limit",
        "search_by": "searchBy",
    },
)
class DashboardWidgetDistributionDefinitionRequestProcessQuery:
    def __init__(
        self,
        *,
        metric: builtins.str,
        filter_by: typing.Optional[typing.Sequence[builtins.str]] = None,
        limit: typing.Optional[jsii.Number] = None,
        search_by: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric: Your chosen metric. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        :param filter_by: A list of processes. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
        :param limit: The max number of items in the filter list. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param search_by: Your chosen search term. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46873aa9883cc3b5dfbc1ec5da3ec83366ba3227e668d633ab559342472074d7)
            check_type(argname="argument metric", value=metric, expected_type=type_hints["metric"])
            check_type(argname="argument filter_by", value=filter_by, expected_type=type_hints["filter_by"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument search_by", value=search_by, expected_type=type_hints["search_by"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "metric": metric,
        }
        if filter_by is not None:
            self._values["filter_by"] = filter_by
        if limit is not None:
            self._values["limit"] = limit
        if search_by is not None:
            self._values["search_by"] = search_by

    @builtins.property
    def metric(self) -> builtins.str:
        '''Your chosen metric.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def filter_by(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of processes.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
        '''
        result = self._values.get("filter_by")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The max number of items in the filter list.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def search_by(self) -> typing.Optional[builtins.str]:
        '''Your chosen search term.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
        '''
        result = self._values.get("search_by")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestProcessQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestProcessQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestProcessQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f92a7ed8cc57da51af9456edafa917686b6934b7c5cb43bffd440d19e512c994)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFilterBy")
    def reset_filter_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFilterBy", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSearchBy")
    def reset_search_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchBy", []))

    @builtins.property
    @jsii.member(jsii_name="filterByInput")
    def filter_by_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "filterByInput"))

    @builtins.property
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property
    @jsii.member(jsii_name="metricInput")
    def metric_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "metricInput"))

    @builtins.property
    @jsii.member(jsii_name="searchByInput")
    def search_by_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchByInput"))

    @builtins.property
    @jsii.member(jsii_name="filterBy")
    def filter_by(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "filterBy"))

    @filter_by.setter
    def filter_by(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__721f7e7efd8a29c1306f78ba211a3d82596144e11c2e64f9a4e7f64801e976d8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "filterBy", value)

    @builtins.property
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__60cee97f5c3e7f529d425ffcb70ca6f39e0a2e8947a7e9c95c9c05bbcedc93c9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "limit", value)

    @builtins.property
    @jsii.member(jsii_name="metric")
    def metric(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "metric"))

    @metric.setter
    def metric(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c9476c3194e984221fb8f5162c12458fd159201811e8fa1af5875248e0a48e52)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "metric", value)

    @builtins.property
    @jsii.member(jsii_name="searchBy")
    def search_by(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchBy"))

    @search_by.setter
    def search_by(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a7e1988cc311e029625ddfb8d60b080367e5621f63ac7602f1b0b2a410132fbe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "searchBy", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestProcessQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestProcessQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestProcessQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c971c38c451123de2954511451c55c06d2a7e07054906598dc3e8ccd279fdaf4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestRumQuery",
    jsii_struct_bases=[],
    name_mapping={
        "index": "index",
        "compute_query": "computeQuery",
        "group_by": "groupBy",
        "multi_compute": "multiCompute",
        "search_query": "searchQuery",
    },
)
class DashboardWidgetDistributionDefinitionRequestRumQuery:
    def __init__(
        self,
        *,
        index: builtins.str,
        compute_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery", typing.Dict[builtins.str, typing.Any]]] = None,
        group_by: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        multi_compute: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute", typing.Dict[builtins.str, typing.Any]]]]] = None,
        search_query: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param index: The name of the index to query. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        :param compute_query: compute_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        :param group_by: group_by block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        :param multi_compute: multi_compute block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        :param search_query: The search query to use. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        if isinstance(compute_query, dict):
            compute_query = DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery(**compute_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cc2903e456b61b8b95a125c1cfd2d7cf1d71268b4d290c799e2114aa5becac65)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
            check_type(argname="argument compute_query", value=compute_query, expected_type=type_hints["compute_query"])
            check_type(argname="argument group_by", value=group_by, expected_type=type_hints["group_by"])
            check_type(argname="argument multi_compute", value=multi_compute, expected_type=type_hints["multi_compute"])
            check_type(argname="argument search_query", value=search_query, expected_type=type_hints["search_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "index": index,
        }
        if compute_query is not None:
            self._values["compute_query"] = compute_query
        if group_by is not None:
            self._values["group_by"] = group_by
        if multi_compute is not None:
            self._values["multi_compute"] = multi_compute
        if search_query is not None:
            self._values["search_query"] = search_query

    @builtins.property
    def index(self) -> builtins.str:
        '''The name of the index to query.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
        '''
        result = self._values.get("index")
        assert result is not None, "Required property 'index' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def compute_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery"]:
        '''compute_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
        '''
        result = self._values.get("compute_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery"], result)

    @builtins.property
    def group_by(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy"]]]:
        '''group_by block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
        '''
        result = self._values.get("group_by")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy"]]], result)

    @builtins.property
    def multi_compute(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute"]]]:
        '''multi_compute block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
        '''
        result = self._values.get("multi_compute")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute"]]], result)

    @builtins.property
    def search_query(self) -> typing.Optional[builtins.str]:
        '''The search query to use.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
        '''
        result = self._values.get("search_query")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestRumQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__45f157fa89bfd3fb47cf137737e9cef50753b7f006a3bcc200054d35231f5989)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3039994b7322f08925625f06e92a74b38b52ba306fa7e84ac9ca5ec6c459de2f)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cadc3ba3a50039aae9773ec8e396a583c753589f60a1c26d5df718c5f784313a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b3375ad6d749957ae4eeff135170301eb12e0d11c3f74afe2d5cd163e4e8f6b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1ebceb45ab2c8b3c376db3b5f85d8114f44348eb1848b7dce19f44933d88133c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c98b8aac6190df3fb9b6fba2ee43fb393be3e67e7d2a8d983960c85ca39ace5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy",
    jsii_struct_bases=[],
    name_mapping={"facet": "facet", "limit": "limit", "sort_query": "sortQuery"},
)
class DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy:
    def __init__(
        self,
        *,
        facet: typing.Optional[builtins.str] = None,
        limit: typing.Optional[jsii.Number] = None,
        sort_query: typing.Optional[typing.Union["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param limit: The maximum number of items in the group. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        :param sort_query: sort_query block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        if isinstance(sort_query, dict):
            sort_query = DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery(**sort_query)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7b608feb06a4b24690910ea297df9e7dc2da40b642bac9f61157f53c8ebe29a8)
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument sort_query", value=sort_query, expected_type=type_hints["sort_query"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if facet is not None:
            self._values["facet"] = facet
        if limit is not None:
            self._values["limit"] = limit
        if sort_query is not None:
            self._values["sort_query"] = sort_query

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        '''The maximum number of items in the group.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
        '''
        result = self._values.get("limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sort_query(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery"]:
        '''sort_query block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
        '''
        result = self._values.get("sort_query")
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestRumQueryGroupByList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestRumQueryGroupByList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5970a51fa96b82b65c5dada6953b378695484926db6343ef370cf84985274de2)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetDistributionDefinitionRequestRumQueryGroupByOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c963dad83c7f8cf8e5293c7eee84c4e173e8d665a54322185fc2a2e51af6cca5)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetDistributionDefinitionRequestRumQueryGroupByOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f530713883c3269d38f02dc9016d9c3ca2fa1d10ac450cbbd3290d676dd7d4cd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8cc74582791b94ea115cb5589f87dfe4bc08ab61f081069b36738ca0f27a3141)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__89eb4383abc49ca9919ff3c21f3089cb4d38c70c86e9ed7175530eec86108f3a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fd9f152807f137330f368ba16965eba79c664ca399309aee7a0c294ecd7c05c5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestRumQueryGroupByOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestRumQueryGroupByOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__58dffa7617e1b537a9cf7e39e0561d7256e96d278bf5ca5b10bf1297dca2b35e)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putSortQuery")
    def put_sort_query(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        value = DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery(
            aggregation=aggregation, order=order, facet=facet
        )

        return typing.cast(None, jsii.invoke(self, "putSortQuery", [value]))

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetLimit")
    def reset_limit(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetLimit", []))

    @jsii.member(jsii_name="resetSortQuery")
    def reset_sort_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSortQuery", []))

    @builtins.property
    @jsii.member(jsii_name="sortQuery")
    def sort_query(
        self,
    ) -> "DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference":
        return typing.cast("DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference", jsii.get(self, "sortQuery"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="limitInput")
    def limit_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "limitInput"))

    @builtins.property
    @jsii.member(jsii_name="sortQueryInput")
    def sort_query_input(
        self,
    ) -> typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery"]:
        return typing.cast(typing.Optional["DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery"], jsii.get(self, "sortQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__62d4839a0b0bc6cab32f3529d8ad034a64a0d6adf6582643332c416ae45973db)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="limit")
    def limit(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "limit"))

    @limit.setter
    def limit(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c968618dbf05b86bc2ba6bb8b23ca940e53baa765c5277985930b885221d04e4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "limit", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e29ee73026032f4a63ecbc9561671aa212e2a17d59a26b446c42c8b39c3a6528)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery",
    jsii_struct_bases=[],
    name_mapping={"aggregation": "aggregation", "order": "order", "facet": "facet"},
)
class DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        order: builtins.str,
        facet: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param order: Widget sorting methods. Valid values are ``asc``, ``desc``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4a2756b90007f32227b68cf8a0e4e41cf32851bb166020c981165462459b8f53)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument order", value=order, expected_type=type_hints["order"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
            "order": order,
        }
        if facet is not None:
            self._values["facet"] = facet

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def order(self) -> builtins.str:
        '''Widget sorting methods. Valid values are ``asc``, ``desc``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
        '''
        result = self._values.get("order")
        assert result is not None, "Required property 'order' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3de86b78138dbd5fd015311aa766140ff439f3f6eadab5e611aaf8d6e979e473)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="orderInput")
    def order_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "orderInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5f0678e4fa8b47da33d2b448083a1f7158c9ab5296b1aebe00f17420c57d8572)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f753dae31fcc0290f3ab9bcc9c482b96d23367f45887081a1121fdc8cd1cfac)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="order")
    def order(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "order"))

    @order.setter
    def order(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0d503f6100816cd830a8d7046abe889e9a51a70cfe91ef493d82ccbd638c0914)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "order", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2a9fa78190a6331a42f82f3fc7b9b733da0ea485cde3e7d557e54937cf616de1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation": "aggregation",
        "facet": "facet",
        "interval": "interval",
    },
)
class DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute:
    def __init__(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__67e2a1d1b4d0044039c4e99ecd7d2681a53eb312e16f09227e4618f2108a4973)
            check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
            check_type(argname="argument facet", value=facet, expected_type=type_hints["facet"])
            check_type(argname="argument interval", value=interval, expected_type=type_hints["interval"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "aggregation": aggregation,
        }
        if facet is not None:
            self._values["facet"] = facet
        if interval is not None:
            self._values["interval"] = interval

    @builtins.property
    def aggregation(self) -> builtins.str:
        '''The aggregation method.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        '''
        result = self._values.get("aggregation")
        assert result is not None, "Required property 'aggregation' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def facet(self) -> typing.Optional[builtins.str]:
        '''The facet name.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        '''
        result = self._values.get("facet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        '''Define the time interval in seconds.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        result = self._values.get("interval")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8f41cb56b390be7015027aff799f60ce6f31832c1835a6c0df852f3daade8143)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "DashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c2144d324548038db25a67b65298b85df5e25af372f1eb639d505428ceec609)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("DashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fedd8e18ac820cef06364dccbad40285b52ecb4d46b0585669df99ad64b37342)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__756051c7cafa630d4a70294a1b3a629fc4ebc0a8b2c72e45e48a3cf0baa1baf5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f948239049d24dbf15be6c66fb51312a4bf2fed3435b63395647a6b5c7eb5b58)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b1effe6b144eddcd4856609989d70811601f7294a1c66257a66a033c7b08057)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f9189174f50db120f1dfc6da516e0f9faba9dd21bc61a33df2601abd99242b92)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetFacet")
    def reset_facet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFacet", []))

    @jsii.member(jsii_name="resetInterval")
    def reset_interval(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetInterval", []))

    @builtins.property
    @jsii.member(jsii_name="aggregationInput")
    def aggregation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "aggregationInput"))

    @builtins.property
    @jsii.member(jsii_name="facetInput")
    def facet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "facetInput"))

    @builtins.property
    @jsii.member(jsii_name="intervalInput")
    def interval_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "intervalInput"))

    @builtins.property
    @jsii.member(jsii_name="aggregation")
    def aggregation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "aggregation"))

    @aggregation.setter
    def aggregation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__88fb5fcfe54a6ea5263416ff1bab17c91fe91cb9e19083b07918160cfd8ee480)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aggregation", value)

    @builtins.property
    @jsii.member(jsii_name="facet")
    def facet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "facet"))

    @facet.setter
    def facet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6f04127eace194b252243c8d2bda825a5cea4fa243f385bb3a7665081ced5867)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "facet", value)

    @builtins.property
    @jsii.member(jsii_name="interval")
    def interval(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "interval"))

    @interval.setter
    def interval(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e6864ef4f9316daa870c2019d62c53aad5202d0496a5ba74f67a87de17948148)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "interval", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0fa33917ded6f57ee7f13d0a2a45a3d743f00a258a24c2957237cf9066373961)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class DashboardWidgetDistributionDefinitionRequestRumQueryOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.dashboard.DashboardWidgetDistributionDefinitionRequestRumQueryOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ee48f10e8b168c9cccc501308d5f773a7c9c9dc871d5617c90d339e8626865dd)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="putComputeQuery")
    def put_compute_query(
        self,
        *,
        aggregation: builtins.str,
        facet: typing.Optional[builtins.str] = None,
        interval: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param aggregation: The aggregation method. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
        :param facet: The facet name. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
        :param interval: Define the time interval in seconds. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
        '''
        value = DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery(
            aggregation=aggregation, facet=facet, interval=interval
        )

        return typing.cast(None, jsii.invoke(self, "putComputeQuery", [value]))

    @jsii.member(jsii_name="putGroupBy")
    def put_group_by(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c6cad3e65ef7b9a48a30409cbd3fe1670943122e0bb4ff81d90ea13414f8d7e0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putGroupBy", [value]))

    @jsii.member(jsii_name="putMultiCompute")
    def put_multi_compute(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29bfa10f6e2b63683fe531c742856a47d65ff1dcad8131052a0370faf9413d86)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putMultiCompute", [value]))

    @jsii.member(jsii_name="resetComputeQuery")
    def reset_compute_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetComputeQuery", []))

    @jsii.member(jsii_name="resetGroupBy")
    def reset_group_by(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGroupBy", []))

    @jsii.member(jsii_name="resetMultiCompute")
    def reset_multi_compute(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMultiCompute", []))

    @jsii.member(jsii_name="resetSearchQuery")
    def reset_search_query(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSearchQuery", []))

    @builtins.property
    @jsii.member(jsii_name="computeQuery")
    def compute_query(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference, jsii.get(self, "computeQuery"))

    @builtins.property
    @jsii.member(jsii_name="groupBy")
    def group_by(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestRumQueryGroupByList:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestRumQueryGroupByList, jsii.get(self, "groupBy"))

    @builtins.property
    @jsii.member(jsii_name="multiCompute")
    def multi_compute(
        self,
    ) -> DashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeList:
        return typing.cast(DashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeList, jsii.get(self, "multiCompute"))

    @builtins.property
    @jsii.member(jsii_name="computeQueryInput")
    def compute_query_input(
        self,
    ) -> typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery]:
        return typing.cast(typing.Optional[DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery], jsii.get(self, "computeQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="groupByInput")
    def group_by_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy]]], jsii.get(self, "groupByInput"))

    @builtins.property
    @jsii.member(jsii_name="indexInput")
    def index_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "indexInput"))

    @builtins.property
    @jsii.member(jsii_name="multiComputeInput")
    def multi_compute_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute]]], jsii.get(self, "multiComputeInput"))

    @builtins.property
    @jsii.member(jsii_name="searchQueryInput")
    def search_query_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "searchQueryInput"))

    @builtins.property
    @jsii.member(jsii_name="index")
    def index(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "index"))

    @index.setter
    def index(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ab5f881fbfbbfed732adf5e8c249c90955b045613cbc7ce41c0f4647ba3d493)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "index", value)

    @builtins.property
    @jsii.member(jsii_name="searchQuery")
    def search_query(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "searchQuery"))

    @search_query.setter
    def search_query(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__505bfa11b58a0546c000b975b0c76658d42fe0c474a7c0ba0f7b4aeaa1830ac6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "searchQuery", value)

    @builtins.property
    @jsii.member(jsii_name="int