'''
# `datadog_monitor_config_policy`

Refer to the Terraform Registory for docs: [`datadog_monitor_config_policy`](https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy).
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdktf as _cdktf_9a9027ec
import constructs as _constructs_77d1e7e8


class MonitorConfigPolicy(
    _cdktf_9a9027ec.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.monitorConfigPolicy.MonitorConfigPolicy",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy datadog_monitor_config_policy}.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id_: builtins.str,
        *,
        policy_type: builtins.str,
        id: typing.Optional[builtins.str] = None,
        tag_policy: typing.Optional[typing.Union["MonitorConfigPolicyTagPolicy", typing.Dict[builtins.str, typing.Any]]] = None,
        connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
        for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy datadog_monitor_config_policy} Resource.

        :param scope: The scope in which to define this construct.
        :param id_: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param policy_type: The monitor config policy type Valid values are ``tag``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#policy_type MonitorConfigPolicy#policy_type}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#id MonitorConfigPolicy#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param tag_policy: tag_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#tag_policy MonitorConfigPolicy#tag_policy}
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__efe9473f7c74ee713bf2b9d392c6be2c3fe55c724e9779c4e5f59a863dc83d11)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id_", value=id_, expected_type=type_hints["id_"])
        config = MonitorConfigPolicyConfig(
            policy_type=policy_type,
            id=id,
            tag_policy=tag_policy,
            connection=connection,
            count=count,
            depends_on=depends_on,
            for_each=for_each,
            lifecycle=lifecycle,
            provider=provider,
            provisioners=provisioners,
        )

        jsii.create(self.__class__, self, [scope, id_, config])

    @jsii.member(jsii_name="putTagPolicy")
    def put_tag_policy(
        self,
        *,
        tag_key: builtins.str,
        tag_key_required: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
        valid_tag_values: typing.Sequence[builtins.str],
    ) -> None:
        '''
        :param tag_key: The key of the tag. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#tag_key MonitorConfigPolicy#tag_key}
        :param tag_key_required: If a tag key is required for monitor creation. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#tag_key_required MonitorConfigPolicy#tag_key_required}
        :param valid_tag_values: Valid values for the tag. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#valid_tag_values MonitorConfigPolicy#valid_tag_values}
        '''
        value = MonitorConfigPolicyTagPolicy(
            tag_key=tag_key,
            tag_key_required=tag_key_required,
            valid_tag_values=valid_tag_values,
        )

        return typing.cast(None, jsii.invoke(self, "putTagPolicy", [value]))

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetTagPolicy")
    def reset_tag_policy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTagPolicy", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property
    @jsii.member(jsii_name="tagPolicy")
    def tag_policy(self) -> "MonitorConfigPolicyTagPolicyOutputReference":
        return typing.cast("MonitorConfigPolicyTagPolicyOutputReference", jsii.get(self, "tagPolicy"))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="policyTypeInput")
    def policy_type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "policyTypeInput"))

    @builtins.property
    @jsii.member(jsii_name="tagPolicyInput")
    def tag_policy_input(self) -> typing.Optional["MonitorConfigPolicyTagPolicy"]:
        return typing.cast(typing.Optional["MonitorConfigPolicyTagPolicy"], jsii.get(self, "tagPolicyInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @id.setter
    def id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70541a6e299078795e82333e9ee391be37ca64eeccab835001ddd5cf75f08ac5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="policyType")
    def policy_type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "policyType"))

    @policy_type.setter
    def policy_type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__14d9aa39cbdce49e9198d20f50a7ca6a3d9c79c2c3a178a58886ab10b2e24f07)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "policyType", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.monitorConfigPolicy.MonitorConfigPolicyConfig",
    jsii_struct_bases=[_cdktf_9a9027ec.TerraformMetaArguments],
    name_mapping={
        "connection": "connection",
        "count": "count",
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "provisioners": "provisioners",
        "policy_type": "policyType",
        "id": "id",
        "tag_policy": "tagPolicy",
    },
)
class MonitorConfigPolicyConfig(_cdktf_9a9027ec.TerraformMetaArguments):
    def __init__(
        self,
        *,
        connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
        for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
        policy_type: builtins.str,
        id: typing.Optional[builtins.str] = None,
        tag_policy: typing.Optional[typing.Union["MonitorConfigPolicyTagPolicy", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        :param policy_type: The monitor config policy type Valid values are ``tag``. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#policy_type MonitorConfigPolicy#policy_type}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#id MonitorConfigPolicy#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param tag_policy: tag_policy block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#tag_policy MonitorConfigPolicy#tag_policy}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = _cdktf_9a9027ec.TerraformResourceLifecycle(**lifecycle)
        if isinstance(tag_policy, dict):
            tag_policy = MonitorConfigPolicyTagPolicy(**tag_policy)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5b9a7277e6638b4cb9c312cafee84351151d893c11c2cb958ba31be5775b3fca)
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument provisioners", value=provisioners, expected_type=type_hints["provisioners"])
            check_type(argname="argument policy_type", value=policy_type, expected_type=type_hints["policy_type"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument tag_policy", value=tag_policy, expected_type=type_hints["tag_policy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "policy_type": policy_type,
        }
        if connection is not None:
            self._values["connection"] = connection
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if provisioners is not None:
            self._values["provisioners"] = provisioners
        if id is not None:
            self._values["id"] = id
        if tag_policy is not None:
            self._values["tag_policy"] = tag_policy

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, _cdktf_9a9027ec.WinrmProvisionerConnection]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, _cdktf_9a9027ec.WinrmProvisionerConnection]], result)

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(
        self,
    ) -> typing.Optional[typing.List[_cdktf_9a9027ec.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[_cdktf_9a9027ec.ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[_cdktf_9a9027ec.ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.ITerraformIterator], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[_cdktf_9a9027ec.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[_cdktf_9a9027ec.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.TerraformProvider], result)

    @builtins.property
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[_cdktf_9a9027ec.FileProvisioner, _cdktf_9a9027ec.LocalExecProvisioner, _cdktf_9a9027ec.RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provisioners")
        return typing.cast(typing.Optional[typing.List[typing.Union[_cdktf_9a9027ec.FileProvisioner, _cdktf_9a9027ec.LocalExecProvisioner, _cdktf_9a9027ec.RemoteExecProvisioner]]], result)

    @builtins.property
    def policy_type(self) -> builtins.str:
        '''The monitor config policy type Valid values are ``tag``.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#policy_type MonitorConfigPolicy#policy_type}
        '''
        result = self._values.get("policy_type")
        assert result is not None, "Required property 'policy_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#id MonitorConfigPolicy#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tag_policy(self) -> typing.Optional["MonitorConfigPolicyTagPolicy"]:
        '''tag_policy block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#tag_policy MonitorConfigPolicy#tag_policy}
        '''
        result = self._values.get("tag_policy")
        return typing.cast(typing.Optional["MonitorConfigPolicyTagPolicy"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MonitorConfigPolicyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-datadog.monitorConfigPolicy.MonitorConfigPolicyTagPolicy",
    jsii_struct_bases=[],
    name_mapping={
        "tag_key": "tagKey",
        "tag_key_required": "tagKeyRequired",
        "valid_tag_values": "validTagValues",
    },
)
class MonitorConfigPolicyTagPolicy:
    def __init__(
        self,
        *,
        tag_key: builtins.str,
        tag_key_required: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
        valid_tag_values: typing.Sequence[builtins.str],
    ) -> None:
        '''
        :param tag_key: The key of the tag. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#tag_key MonitorConfigPolicy#tag_key}
        :param tag_key_required: If a tag key is required for monitor creation. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#tag_key_required MonitorConfigPolicy#tag_key_required}
        :param valid_tag_values: Valid values for the tag. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#valid_tag_values MonitorConfigPolicy#valid_tag_values}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b50b7cefee001628d3663f94eb465da5e1d046bb6d10d67b6310161d09b3d960)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument tag_key_required", value=tag_key_required, expected_type=type_hints["tag_key_required"])
            check_type(argname="argument valid_tag_values", value=valid_tag_values, expected_type=type_hints["valid_tag_values"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "tag_key": tag_key,
            "tag_key_required": tag_key_required,
            "valid_tag_values": valid_tag_values,
        }

    @builtins.property
    def tag_key(self) -> builtins.str:
        '''The key of the tag.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#tag_key MonitorConfigPolicy#tag_key}
        '''
        result = self._values.get("tag_key")
        assert result is not None, "Required property 'tag_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def tag_key_required(
        self,
    ) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        '''If a tag key is required for monitor creation.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#tag_key_required MonitorConfigPolicy#tag_key_required}
        '''
        result = self._values.get("tag_key_required")
        assert result is not None, "Required property 'tag_key_required' is missing"
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], result)

    @builtins.property
    def valid_tag_values(self) -> typing.List[builtins.str]:
        '''Valid values for the tag.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#valid_tag_values MonitorConfigPolicy#valid_tag_values}
        '''
        result = self._values.get("valid_tag_values")
        assert result is not None, "Required property 'valid_tag_values' is missing"
        return typing.cast(typing.List[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MonitorConfigPolicyTagPolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class MonitorConfigPolicyTagPolicyOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-datadog.monitorConfigPolicy.MonitorConfigPolicyTagPolicyOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb729c45b9dd70358d898d68a4ed1c662ff7084888f746ea47e92d7b887449e1)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @builtins.property
    @jsii.member(jsii_name="tagKeyInput")
    def tag_key_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "tagKeyInput"))

    @builtins.property
    @jsii.member(jsii_name="tagKeyRequiredInput")
    def tag_key_required_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "tagKeyRequiredInput"))

    @builtins.property
    @jsii.member(jsii_name="validTagValuesInput")
    def valid_tag_values_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "validTagValuesInput"))

    @builtins.property
    @jsii.member(jsii_name="tagKey")
    def tag_key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "tagKey"))

    @tag_key.setter
    def tag_key(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d7adfbee4c7315e9aaec523face67fd5668c3a2f13ff50dab6065003e0078ed)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagKey", value)

    @builtins.property
    @jsii.member(jsii_name="tagKeyRequired")
    def tag_key_required(
        self,
    ) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "tagKeyRequired"))

    @tag_key_required.setter
    def tag_key_required(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__00177c5bd6200c1f585a3edb3f41b9a43371efc19921561597bf8b07c7ed6ca3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagKeyRequired", value)

    @builtins.property
    @jsii.member(jsii_name="validTagValues")
    def valid_tag_values(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "validTagValues"))

    @valid_tag_values.setter
    def valid_tag_values(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__47da151b792bcd0a9e3e581c410a086b4f3c5de45b70f56533753b1a6ca1c237)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "validTagValues", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[MonitorConfigPolicyTagPolicy]:
        return typing.cast(typing.Optional[MonitorConfigPolicyTagPolicy], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[MonitorConfigPolicyTagPolicy],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bf9f7d9dae8fa64f3608ea27dc8be83f73076c509d078e7957ee0ec15d5ec1b6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


__all__ = [
    "MonitorConfigPolicy",
    "MonitorConfigPolicyConfig",
    "MonitorConfigPolicyTagPolicy",
    "MonitorConfigPolicyTagPolicyOutputReference",
]

publication.publish()

def _typecheckingstub__efe9473f7c74ee713bf2b9d392c6be2c3fe55c724e9779c4e5f59a863dc83d11(
    scope: _constructs_77d1e7e8.Construct,
    id_: builtins.str,
    *,
    policy_type: builtins.str,
    id: typing.Optional[builtins.str] = None,
    tag_policy: typing.Optional[typing.Union[MonitorConfigPolicyTagPolicy, typing.Dict[builtins.str, typing.Any]]] = None,
    connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
    count: typing.Optional[jsii.Number] = None,
    depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
    for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
    lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
    provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
    provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__70541a6e299078795e82333e9ee391be37ca64eeccab835001ddd5cf75f08ac5(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__14d9aa39cbdce49e9198d20f50a7ca6a3d9c79c2c3a178a58886ab10b2e24f07(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__5b9a7277e6638b4cb9c312cafee84351151d893c11c2cb958ba31be5775b3fca(
    *,
    connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
    count: typing.Optional[jsii.Number] = None,
    depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
    for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
    lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
    provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
    provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    policy_type: builtins.str,
    id: typing.Optional[builtins.str] = None,
    tag_policy: typing.Optional[typing.Union[MonitorConfigPolicyTagPolicy, typing.Dict[builtins.str, typing.Any]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b50b7cefee001628d3663f94eb465da5e1d046bb6d10d67b6310161d09b3d960(
    *,
    tag_key: builtins.str,
    tag_key_required: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    valid_tag_values: typing.Sequence[builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__bb729c45b9dd70358d898d68a4ed1c662ff7084888f746ea47e92d7b887449e1(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3d7adfbee4c7315e9aaec523face67fd5668c3a2f13ff50dab6065003e0078ed(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__00177c5bd6200c1f585a3edb3f41b9a43371efc19921561597bf8b07c7ed6ca3(
    value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__47da151b792bcd0a9e3e581c410a086b4f3c5de45b70f56533753b1a6ca1c237(
    value: typing.List[builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__bf9f7d9dae8fa64f3608ea27dc8be83f73076c509d078e7957ee0ec15d5ec1b6(
    value: typing.Optional[MonitorConfigPolicyTagPolicy],
) -> None:
    """Type checking stubs"""
    pass
