import builtins
import typing
from enum import Enum

import topk_sdk.data

FlexibleExpr = typing.Union[str, int, float, bool, None, LogicalExpr]
Numeric = typing.Union[int, float, LogicalExpr]
Boolish = typing.Union[bool, LogicalExpr]
Stringy = typing.Union[str, LogicalExpr]
StringyWithList = typing.Union[str, builtins.list[str], LogicalExpr]
Iterable = typing.Union[str, builtins.list[int], builtins.list[float], builtins.list[str], topk_sdk.data.List, LogicalExpr]

class LogicalExpr(Enum):
    def __repr__(self) -> builtins.str: ...
    def _expr_eq(self, other: LogicalExpr) -> builtins.bool: ...
    def is_null(self) -> LogicalExpr: ...
    def is_not_null(self) -> LogicalExpr: ...
    def abs(self) -> LogicalExpr: ...
    def __abs__(self) -> LogicalExpr: ...
    def ln(self) -> LogicalExpr: ...
    def exp(self) -> LogicalExpr: ...
    def sqrt(self) -> LogicalExpr: ...
    def square(self) -> LogicalExpr: ...
    def eq(self, other: FlexibleExpr) -> LogicalExpr: ...
    def __eq__(self, other: FlexibleExpr) -> LogicalExpr: ...
    def ne(self, other: FlexibleExpr) -> LogicalExpr: ...
    def __ne__(self, other: FlexibleExpr) -> LogicalExpr: ...
    def lt(self, other: Numeric) -> LogicalExpr: ...
    def __lt__(self, other: Numeric) -> LogicalExpr: ...
    def __rlt__(self, other: Numeric) -> LogicalExpr: ...
    def lte(self, other: Numeric) -> LogicalExpr: ...
    def __le__(self, other: Numeric) -> LogicalExpr: ...
    def __rle__(self, other: Numeric) -> LogicalExpr: ...
    def gt(self, other: Numeric) -> LogicalExpr: ...
    def __gt__(self, other: Numeric) -> LogicalExpr: ...
    def __rgt__(self, other: Numeric) -> LogicalExpr: ...
    def gte(self, other: Numeric) -> LogicalExpr: ...
    def __ge__(self, other: Numeric) -> LogicalExpr: ...
    def __rge__(self, other: Numeric) -> LogicalExpr: ...
    def add(self, other: Numeric) -> LogicalExpr: ...
    def __add__(self, other: Numeric) -> LogicalExpr: ...
    def __radd__(self, other: Numeric) -> LogicalExpr: ...
    def sub(self, other: Numeric) -> LogicalExpr: ...
    def __sub__(self, other: Numeric) -> LogicalExpr: ...
    def __rsub__(self, other: Numeric) -> LogicalExpr: ...
    def mul(self, other: Numeric) -> LogicalExpr: ...
    def __mul__(self, other: Numeric) -> LogicalExpr: ...
    def __rmul__(self, other: Numeric) -> LogicalExpr: ...
    def div(self, other: Numeric) -> LogicalExpr: ...
    def __div__(self, other: Numeric) -> LogicalExpr: ...
    def __truediv__(self, other: Numeric) -> LogicalExpr: ...
    def __rdiv__(self, other: Numeric) -> LogicalExpr: ...
    def __rtruediv__(self, other: Numeric) -> LogicalExpr: ...
    def min(self, other: Numeric) -> LogicalExpr: ...
    def max(self, other: Numeric) -> LogicalExpr: ...
    def and_(self, other: Boolish) -> LogicalExpr: ...
    def __and__(self, other: Boolish) -> LogicalExpr: ...
    def __rand__(self, other: Boolish) -> LogicalExpr: ...
    def or_(self, other: Boolish) -> LogicalExpr: ...
    def __or__(self, other: Boolish) -> LogicalExpr: ...
    def __ror__(self, other: Boolish) -> LogicalExpr: ...
    def starts_with(self, other: Stringy) -> LogicalExpr: ...
    def contains(self, other: FlexibleExpr) -> LogicalExpr: ...
    def in_(self, other: Iterable) -> LogicalExpr: ...
    def match_all(self, other: StringyWithList) -> LogicalExpr: ...
    def match_any(self, other: StringyWithList) -> LogicalExpr: ...
    def coalesce(self, other: Numeric) -> LogicalExpr: ...
    def choose(self, x: FlexibleExpr, y: FlexibleExpr) -> LogicalExpr: ...
    def boost(self, condition: FlexibleExpr, boost: Numeric) -> LogicalExpr: ...

class FunctionExpr: ...

class TextExpr(Enum):
    def __and__(self, other: TextExpr) -> TextExpr: ...
    def __rand__(self, other: TextExpr) -> TextExpr: ...
    def __or__(self, other: TextExpr) -> TextExpr: ...
    def __ror__(self, other: TextExpr) -> TextExpr: ...

class Query:
    def select(
        self,
        *args: builtins.str,
        **kwargs: typing.Union[LogicalExpr, FunctionExpr],
    ) -> Query: ...
    def filter(self, expr: LogicalExpr | TextExpr) -> Query: ...
    def topk(
        self, expr: LogicalExpr, k: builtins.int, asc: builtins.bool = False
    ) -> Query: ...
    def rerank(
        self,
        model: typing.Optional[builtins.str] = None,
        query: typing.Optional[builtins.str] = None,
        fields: typing.Sequence[builtins.str] = [],
        topk_multiple: typing.Optional[builtins.int] = None,
    ) -> Query: ...
    def count(self) -> Query: ...

def field(name: builtins.str) -> LogicalExpr: ...
def select(
    *args: builtins.str,
    **kwargs: typing.Union[LogicalExpr, FunctionExpr],
) -> Query: ...
def filter(expr: LogicalExpr | TextExpr) -> Query: ...
def literal(value: typing.Any) -> LogicalExpr: ...
def match(
    token: builtins.str,
    field: builtins.str | None = None,
    weight: builtins.float = 1.0,
    all: builtins.bool = False,
) -> LogicalExpr: ...
def not_(expr: LogicalExpr) -> LogicalExpr: ...
def abs(expr: LogicalExpr) -> LogicalExpr: ...
def all(exprs: typing.Sequence[LogicalExpr]) -> LogicalExpr: ...
def any(exprs: typing.Sequence[LogicalExpr]) -> LogicalExpr: ...
def min(left: Numeric, right: Numeric) -> LogicalExpr: ...
def max(left: Numeric, right: Numeric) -> LogicalExpr: ...

class fn:
    @staticmethod
    def vector_distance(
        field: builtins.str,
        vector: typing.Union[
            list[int],
            list[float],
            dict[int, float],
            dict[int, int],
            topk_sdk.data.Value,
            topk_sdk.data.List,
        ],
        skip_refine: builtins.bool = False,
    ) -> FunctionExpr: ...
    @staticmethod
    def semantic_similarity(
        field: builtins.str,
        query: builtins.str,
    ) -> FunctionExpr: ...
    @staticmethod
    def bm25_score() -> FunctionExpr: ...
