"""replace composite runs index

Revision ID: 89b595051e48
Revises: f9ad1c25fd2b
Create Date: 2025-10-06 13:17:09.918439

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "89b595051e48"
down_revision: Union[str, None] = "f9ad1c25fd2b"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_messages_run_err_sequence"), table_name="messages")
    op.create_index("ix_messages_run_sequence", "messages", ["run_id", "sequence_id"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_messages_run_sequence", table_name="messages")
    op.create_index(op.f("ix_messages_run_err_sequence"), "messages", ["run_id", "is_err", "sequence_id"], unique=False)
    # ### end Alembic commands ###
