"""add encrypted columns

Revision ID: b6061da886ee
Revises: 89b595051e48
Create Date: 2025-10-06 14:55:32.554544

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "b6061da886ee"
down_revision: Union[str, None] = "89b595051e48"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("agent_environment_variables", sa.Column("value_enc", sa.Text(), nullable=True))
    op.add_column("mcp_oauth", sa.Column("authorization_code_enc", sa.Text(), nullable=True))
    op.add_column("providers", sa.Column("api_key_enc", sa.Text(), nullable=True))
    op.add_column("providers", sa.Column("access_key_enc", sa.Text(), nullable=True))
    op.add_column("sandbox_environment_variables", sa.Column("value_enc", sa.Text(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("sandbox_environment_variables", "value_enc")
    op.drop_column("providers", "access_key_enc")
    op.drop_column("providers", "api_key_enc")
    op.drop_column("mcp_oauth", "authorization_code_enc")
    op.drop_column("agent_environment_variables", "value_enc")
    # ### end Alembic commands ###
