# Generated by Django 5.1.2 on 2025-05-23 11:08

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    """
    Migration to make the created_by field optional in Job, Unit, and Word models.

    This migration modifies the created_by field in all three models to allow null values
    and blank values, making it optional for objects created without a specific group.
    """

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        ("cmsv2", "0002_alter_job_options_alter_unit_options_and_more"),
    ]

    operations = [
        migrations.AlterField(
            model_name="job",
            name="created_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="job",
                to="auth.group",
                verbose_name="created by",
            ),
        ),
        migrations.AlterField(
            model_name="unit",
            name="created_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="auth.group",
                verbose_name="created by",
            ),
        ),
        migrations.AlterField(
            model_name="word",
            name="created_by",
            field=models.ForeignKey(
                blank=True,
                max_length=255,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="auth.group",
                verbose_name="created by",
            ),
        ),
    ]
