# Generated by Django 5.1.2 on 2025-05-23 14:17

from django.db import migrations, models
import lunes_cms.cmsv2.models.static
import lunes_cms.cmsv2.validators


class Migration(migrations.Migration):
    """
    Migration to alter icon fields in Job and Unit models, and audio field in Word model.

    This migration updates the upload_to path and verbose_name for icon fields,
    and adds validators to the audio field.
    """

    dependencies = [
        ("cmsv2", "0004_rename_title_job_name"),
    ]

    operations = [
        migrations.AlterField(
            model_name="job",
            name="icon",
            field=models.ImageField(
                blank=True,
                upload_to=lunes_cms.cmsv2.models.static.convert_umlaute_images,
                verbose_name="icon",
            ),
        ),
        migrations.AlterField(
            model_name="unit",
            name="icon",
            field=models.ImageField(
                blank=True,
                upload_to=lunes_cms.cmsv2.models.static.convert_umlaute_images,
                verbose_name="icon",
            ),
        ),
        migrations.AlterField(
            model_name="word",
            name="audio",
            field=models.FileField(
                blank=True,
                null=True,
                upload_to=lunes_cms.cmsv2.models.static.convert_umlaute_audio,
                validators=[
                    lunes_cms.cmsv2.validators.validate_file_extension,
                    lunes_cms.cmsv2.validators.validate_file_size,
                    lunes_cms.cmsv2.validators.validate_multiple_extensions,
                ],
                verbose_name="audio",
            ),
        ),
    ]
