# Generated by Django 5.1.2 on 2025-10-29 18:17

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    """
    Add the cms v2 Feedback model
    """

    dependencies = [
        ("cmsv2", "0013_job_v1_id_unit_v1_id_word_v1_id"),
        ("contenttypes", "0002_remove_content_type_name"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Feedback",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "object_id",
                    models.PositiveIntegerField(
                        help_text="The id of the object this feedback entry refers to.",
                        verbose_name="object id",
                    ),
                ),
                ("comment", models.TextField(verbose_name="comment")),
                (
                    "created_date",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="The time and date when the feedback was submitted.",
                        verbose_name="submitted on",
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        help_text="The content type this feedback entry refers to.",
                        limit_choices_to=models.Q(
                            ("app_label", "cmsv2"),
                            ("model__in", ["job", "unit", "word"]),
                        ),
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="feedbackv2_set",
                        to="contenttypes.contenttype",
                        verbose_name="content type",
                    ),
                ),
                (
                    "read_by",
                    models.ForeignKey(
                        blank=True,
                        help_text="The user who marked this feedback as read. If the feedback is unread, this field is empty.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="feedbackv2",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="marked as read by",
                    ),
                ),
            ],
            options={
                "verbose_name": "feedback",
                "verbose_name_plural": "feedback entries",
            },
        ),
    ]
