# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AlarmArgs', 'Alarm']

@pulumi.input_type
class AlarmArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 instance_id: pulumi.Input[_builtins.int],
                 recipients: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]],
                 type: pulumi.Input[_builtins.str],
                 message_type: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 reminder_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 time_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 value_calculation: Optional[pulumi.Input[_builtins.str]] = None,
                 value_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 vhost_regex: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Alarm resource.
        :param pulumi.Input[_builtins.bool] enabled: Enable or disable the alarm to trigger.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] recipients: Identifier for recipient to be notified. Leave empty to notify
               all recipients.
        :param pulumi.Input[_builtins.str] type: The alarm type, see valid options below.
        :param pulumi.Input[_builtins.str] message_type: Message type `(total, unacked, ready)` used by queue alarm type.
               
               Specific argument for `disk` alarm
        :param pulumi.Input[_builtins.str] queue_regex: Regex for which queue to check.
        :param pulumi.Input[_builtins.int] reminder_interval: The reminder interval (in seconds) to resend the alarm if not
               resolved. Set to 0 for no reminders. The Default is 0.
        :param pulumi.Input[_builtins.int] time_threshold: The time interval (in seconds) the `value_threshold` should be
               active before triggering an alarm.
        :param pulumi.Input[_builtins.str] value_calculation: Disk value threshold calculation, `fixed, percentage` of disk
               space remaining.
               
               Based on alarm type, different arguments are flagged as required or optional.
        :param pulumi.Input[_builtins.int] value_threshold: The value to trigger the alarm for.
        :param pulumi.Input[_builtins.str] vhost_regex: Regex for which vhost to check
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "recipients", recipients)
        pulumi.set(__self__, "type", type)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if queue_regex is not None:
            pulumi.set(__self__, "queue_regex", queue_regex)
        if reminder_interval is not None:
            pulumi.set(__self__, "reminder_interval", reminder_interval)
        if time_threshold is not None:
            pulumi.set(__self__, "time_threshold", time_threshold)
        if value_calculation is not None:
            pulumi.set(__self__, "value_calculation", value_calculation)
        if value_threshold is not None:
            pulumi.set(__self__, "value_threshold", value_threshold)
        if vhost_regex is not None:
            pulumi.set(__self__, "vhost_regex", vhost_regex)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Enable or disable the alarm to trigger.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]:
        """
        Identifier for recipient to be notified. Leave empty to notify
        all recipients.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(self, "recipients", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The alarm type, see valid options below.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message type `(total, unacked, ready)` used by queue alarm type.

        Specific argument for `disk` alarm
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_type", value)

    @_builtins.property
    @pulumi.getter(name="queueRegex")
    def queue_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Regex for which queue to check.
        """
        return pulumi.get(self, "queue_regex")

    @queue_regex.setter
    def queue_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_regex", value)

    @_builtins.property
    @pulumi.getter(name="reminderInterval")
    def reminder_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The reminder interval (in seconds) to resend the alarm if not
        resolved. Set to 0 for no reminders. The Default is 0.
        """
        return pulumi.get(self, "reminder_interval")

    @reminder_interval.setter
    def reminder_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reminder_interval", value)

    @_builtins.property
    @pulumi.getter(name="timeThreshold")
    def time_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time interval (in seconds) the `value_threshold` should be
        active before triggering an alarm.
        """
        return pulumi.get(self, "time_threshold")

    @time_threshold.setter
    def time_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_threshold", value)

    @_builtins.property
    @pulumi.getter(name="valueCalculation")
    def value_calculation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Disk value threshold calculation, `fixed, percentage` of disk
        space remaining.

        Based on alarm type, different arguments are flagged as required or optional.
        """
        return pulumi.get(self, "value_calculation")

    @value_calculation.setter
    def value_calculation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value_calculation", value)

    @_builtins.property
    @pulumi.getter(name="valueThreshold")
    def value_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The value to trigger the alarm for.
        """
        return pulumi.get(self, "value_threshold")

    @value_threshold.setter
    def value_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "value_threshold", value)

    @_builtins.property
    @pulumi.getter(name="vhostRegex")
    def vhost_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Regex for which vhost to check
        """
        return pulumi.get(self, "vhost_regex")

    @vhost_regex.setter
    def vhost_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vhost_regex", value)


@pulumi.input_type
class _AlarmState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 message_type: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 reminder_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 time_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value_calculation: Optional[pulumi.Input[_builtins.str]] = None,
                 value_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 vhost_regex: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Alarm resources.
        :param pulumi.Input[_builtins.bool] enabled: Enable or disable the alarm to trigger.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] message_type: Message type `(total, unacked, ready)` used by queue alarm type.
               
               Specific argument for `disk` alarm
        :param pulumi.Input[_builtins.str] queue_regex: Regex for which queue to check.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] recipients: Identifier for recipient to be notified. Leave empty to notify
               all recipients.
        :param pulumi.Input[_builtins.int] reminder_interval: The reminder interval (in seconds) to resend the alarm if not
               resolved. Set to 0 for no reminders. The Default is 0.
        :param pulumi.Input[_builtins.int] time_threshold: The time interval (in seconds) the `value_threshold` should be
               active before triggering an alarm.
        :param pulumi.Input[_builtins.str] type: The alarm type, see valid options below.
        :param pulumi.Input[_builtins.str] value_calculation: Disk value threshold calculation, `fixed, percentage` of disk
               space remaining.
               
               Based on alarm type, different arguments are flagged as required or optional.
        :param pulumi.Input[_builtins.int] value_threshold: The value to trigger the alarm for.
        :param pulumi.Input[_builtins.str] vhost_regex: Regex for which vhost to check
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if queue_regex is not None:
            pulumi.set(__self__, "queue_regex", queue_regex)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)
        if reminder_interval is not None:
            pulumi.set(__self__, "reminder_interval", reminder_interval)
        if time_threshold is not None:
            pulumi.set(__self__, "time_threshold", time_threshold)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value_calculation is not None:
            pulumi.set(__self__, "value_calculation", value_calculation)
        if value_threshold is not None:
            pulumi.set(__self__, "value_threshold", value_threshold)
        if vhost_regex is not None:
            pulumi.set(__self__, "vhost_regex", vhost_regex)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable the alarm to trigger.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message type `(total, unacked, ready)` used by queue alarm type.

        Specific argument for `disk` alarm
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_type", value)

    @_builtins.property
    @pulumi.getter(name="queueRegex")
    def queue_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Regex for which queue to check.
        """
        return pulumi.get(self, "queue_regex")

    @queue_regex.setter
    def queue_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_regex", value)

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Identifier for recipient to be notified. Leave empty to notify
        all recipients.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "recipients", value)

    @_builtins.property
    @pulumi.getter(name="reminderInterval")
    def reminder_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The reminder interval (in seconds) to resend the alarm if not
        resolved. Set to 0 for no reminders. The Default is 0.
        """
        return pulumi.get(self, "reminder_interval")

    @reminder_interval.setter
    def reminder_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reminder_interval", value)

    @_builtins.property
    @pulumi.getter(name="timeThreshold")
    def time_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time interval (in seconds) the `value_threshold` should be
        active before triggering an alarm.
        """
        return pulumi.get(self, "time_threshold")

    @time_threshold.setter
    def time_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_threshold", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alarm type, see valid options below.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="valueCalculation")
    def value_calculation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Disk value threshold calculation, `fixed, percentage` of disk
        space remaining.

        Based on alarm type, different arguments are flagged as required or optional.
        """
        return pulumi.get(self, "value_calculation")

    @value_calculation.setter
    def value_calculation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value_calculation", value)

    @_builtins.property
    @pulumi.getter(name="valueThreshold")
    def value_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The value to trigger the alarm for.
        """
        return pulumi.get(self, "value_threshold")

    @value_threshold.setter
    def value_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "value_threshold", value)

    @_builtins.property
    @pulumi.getter(name="vhostRegex")
    def vhost_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Regex for which vhost to check
        """
        return pulumi.get(self, "vhost_regex")

    @vhost_regex.setter
    def vhost_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vhost_regex", value)


@pulumi.type_token("cloudamqp:index/alarm:Alarm")
class Alarm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 message_type: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 reminder_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 time_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value_calculation: Optional[pulumi.Input[_builtins.str]] = None,
                 value_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 vhost_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        `cloudamqp_alarm` can be imported using the resource identifier together with the CloudAMQP instance

        identifier (CSV separated). To retrieve the resource identifier, use [CloudAMQP API list alarms].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_alarm.alarm

          id = format("<id>,%s", cloudamqp_instance.instance.id)

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/alarm:Alarm alarm <id>,<instance_id>`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Enable or disable the alarm to trigger.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] message_type: Message type `(total, unacked, ready)` used by queue alarm type.
               
               Specific argument for `disk` alarm
        :param pulumi.Input[_builtins.str] queue_regex: Regex for which queue to check.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] recipients: Identifier for recipient to be notified. Leave empty to notify
               all recipients.
        :param pulumi.Input[_builtins.int] reminder_interval: The reminder interval (in seconds) to resend the alarm if not
               resolved. Set to 0 for no reminders. The Default is 0.
        :param pulumi.Input[_builtins.int] time_threshold: The time interval (in seconds) the `value_threshold` should be
               active before triggering an alarm.
        :param pulumi.Input[_builtins.str] type: The alarm type, see valid options below.
        :param pulumi.Input[_builtins.str] value_calculation: Disk value threshold calculation, `fixed, percentage` of disk
               space remaining.
               
               Based on alarm type, different arguments are flagged as required or optional.
        :param pulumi.Input[_builtins.int] value_threshold: The value to trigger the alarm for.
        :param pulumi.Input[_builtins.str] vhost_regex: Regex for which vhost to check
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        `cloudamqp_alarm` can be imported using the resource identifier together with the CloudAMQP instance

        identifier (CSV separated). To retrieve the resource identifier, use [CloudAMQP API list alarms].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_alarm.alarm

          id = format("<id>,%s", cloudamqp_instance.instance.id)

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/alarm:Alarm alarm <id>,<instance_id>`
        ```

        :param str resource_name: The name of the resource.
        :param AlarmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 message_type: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 reminder_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 time_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value_calculation: Optional[pulumi.Input[_builtins.str]] = None,
                 value_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 vhost_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmArgs.__new__(AlarmArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["message_type"] = message_type
            __props__.__dict__["queue_regex"] = queue_regex
            if recipients is None and not opts.urn:
                raise TypeError("Missing required property 'recipients'")
            __props__.__dict__["recipients"] = recipients
            __props__.__dict__["reminder_interval"] = reminder_interval
            __props__.__dict__["time_threshold"] = time_threshold
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["value_calculation"] = value_calculation
            __props__.__dict__["value_threshold"] = value_threshold
            __props__.__dict__["vhost_regex"] = vhost_regex
        super(Alarm, __self__).__init__(
            'cloudamqp:index/alarm:Alarm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            message_type: Optional[pulumi.Input[_builtins.str]] = None,
            queue_regex: Optional[pulumi.Input[_builtins.str]] = None,
            recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            reminder_interval: Optional[pulumi.Input[_builtins.int]] = None,
            time_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            value_calculation: Optional[pulumi.Input[_builtins.str]] = None,
            value_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            vhost_regex: Optional[pulumi.Input[_builtins.str]] = None) -> 'Alarm':
        """
        Get an existing Alarm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Enable or disable the alarm to trigger.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] message_type: Message type `(total, unacked, ready)` used by queue alarm type.
               
               Specific argument for `disk` alarm
        :param pulumi.Input[_builtins.str] queue_regex: Regex for which queue to check.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] recipients: Identifier for recipient to be notified. Leave empty to notify
               all recipients.
        :param pulumi.Input[_builtins.int] reminder_interval: The reminder interval (in seconds) to resend the alarm if not
               resolved. Set to 0 for no reminders. The Default is 0.
        :param pulumi.Input[_builtins.int] time_threshold: The time interval (in seconds) the `value_threshold` should be
               active before triggering an alarm.
        :param pulumi.Input[_builtins.str] type: The alarm type, see valid options below.
        :param pulumi.Input[_builtins.str] value_calculation: Disk value threshold calculation, `fixed, percentage` of disk
               space remaining.
               
               Based on alarm type, different arguments are flagged as required or optional.
        :param pulumi.Input[_builtins.int] value_threshold: The value to trigger the alarm for.
        :param pulumi.Input[_builtins.str] vhost_regex: Regex for which vhost to check
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlarmState.__new__(_AlarmState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["message_type"] = message_type
        __props__.__dict__["queue_regex"] = queue_regex
        __props__.__dict__["recipients"] = recipients
        __props__.__dict__["reminder_interval"] = reminder_interval
        __props__.__dict__["time_threshold"] = time_threshold
        __props__.__dict__["type"] = type
        __props__.__dict__["value_calculation"] = value_calculation
        __props__.__dict__["value_threshold"] = value_threshold
        __props__.__dict__["vhost_regex"] = vhost_regex
        return Alarm(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable or disable the alarm to trigger.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Message type `(total, unacked, ready)` used by queue alarm type.

        Specific argument for `disk` alarm
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter(name="queueRegex")
    def queue_regex(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Regex for which queue to check.
        """
        return pulumi.get(self, "queue_regex")

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> pulumi.Output[Sequence[_builtins.int]]:
        """
        Identifier for recipient to be notified. Leave empty to notify
        all recipients.
        """
        return pulumi.get(self, "recipients")

    @_builtins.property
    @pulumi.getter(name="reminderInterval")
    def reminder_interval(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The reminder interval (in seconds) to resend the alarm if not
        resolved. Set to 0 for no reminders. The Default is 0.
        """
        return pulumi.get(self, "reminder_interval")

    @_builtins.property
    @pulumi.getter(name="timeThreshold")
    def time_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The time interval (in seconds) the `value_threshold` should be
        active before triggering an alarm.
        """
        return pulumi.get(self, "time_threshold")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The alarm type, see valid options below.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="valueCalculation")
    def value_calculation(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Disk value threshold calculation, `fixed, percentage` of disk
        space remaining.

        Based on alarm type, different arguments are flagged as required or optional.
        """
        return pulumi.get(self, "value_calculation")

    @_builtins.property
    @pulumi.getter(name="valueThreshold")
    def value_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The value to trigger the alarm for.
        """
        return pulumi.get(self, "value_threshold")

    @_builtins.property
    @pulumi.getter(name="vhostRegex")
    def vhost_regex(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Regex for which vhost to check
        """
        return pulumi.get(self, "vhost_regex")

