# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IntegrationMetricArgs', 'IntegrationMetric']

@pulumi.input_type
class IntegrationMetricArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.int],
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 include_ad_queues: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_whitelist: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost_whitelist: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IntegrationMetric resource.
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier
        :param pulumi.Input[_builtins.str] access_key_id: AWS access key identifier. (Cloudwatch)
        :param pulumi.Input[_builtins.str] api_key: The API key for the integration service. (Librato)
        :param pulumi.Input[_builtins.str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[_builtins.str] credentials: Base64Encoded credentials. (Stackdriver)
        :param pulumi.Input[_builtins.str] email: The email address registred for the integration service. (Librato)
        :param pulumi.Input[_builtins.str] iam_external_id: External identifier that match the role you created. (Cloudwatch)
        :param pulumi.Input[_builtins.str] iam_role: The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        :param pulumi.Input[_builtins.bool] include_ad_queues: (optional) Include Auto-Delete queues
        :param pulumi.Input[_builtins.str] license_key: The license key registred for the integration service. (New Relic)
        :param pulumi.Input[_builtins.str] name: The name of metrics integration
        :param pulumi.Input[_builtins.str] private_key: The private key. (Stackdriver)
        :param pulumi.Input[_builtins.str] private_key_id: Private key identifier. (Stackdriver)
        :param pulumi.Input[_builtins.str] project_id: Project ID. (Stackdriver)
        :param pulumi.Input[_builtins.str] queue_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[_builtins.str] queue_whitelist: **Deprecated**
        :param pulumi.Input[_builtins.str] region: AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        :param pulumi.Input[_builtins.str] secret_access_key: AWS secret key. (Cloudwatch)
        :param pulumi.Input[_builtins.str] tags: (optional) tags. E.g. env=prod,region=europe
        :param pulumi.Input[_builtins.str] vhost_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[_builtins.str] vhost_whitelist: **Deprecated**
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if iam_external_id is not None:
            pulumi.set(__self__, "iam_external_id", iam_external_id)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if include_ad_queues is not None:
            pulumi.set(__self__, "include_ad_queues", include_ad_queues)
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_id is not None:
            pulumi.set(__self__, "private_key_id", private_key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if queue_allowlist is not None:
            pulumi.set(__self__, "queue_allowlist", queue_allowlist)
        if queue_whitelist is not None:
            warnings.warn("""use queue_allowlist instead""", DeprecationWarning)
            pulumi.log.warn("""queue_whitelist is deprecated: use queue_allowlist instead""")
        if queue_whitelist is not None:
            pulumi.set(__self__, "queue_whitelist", queue_whitelist)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vhost_allowlist is not None:
            pulumi.set(__self__, "vhost_allowlist", vhost_allowlist)
        if vhost_whitelist is not None:
            warnings.warn("""use vhost_allowlist instead""", DeprecationWarning)
            pulumi.log.warn("""vhost_whitelist is deprecated: use vhost_allowlist instead""")
        if vhost_whitelist is not None:
            pulumi.set(__self__, "vhost_whitelist", vhost_whitelist)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        Instance identifier
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS access key identifier. (Cloudwatch)
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API key for the integration service. (Librato)
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client email. (Stackdriver)
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_email", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64Encoded credentials. (Stackdriver)
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address registred for the integration service. (Librato)
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="iamExternalId")
    def iam_external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External identifier that match the role you created. (Cloudwatch)
        """
        return pulumi.get(self, "iam_external_id")

    @iam_external_id.setter
    def iam_external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_external_id", value)

    @_builtins.property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        """
        return pulumi.get(self, "iam_role")

    @iam_role.setter
    def iam_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role", value)

    @_builtins.property
    @pulumi.getter(name="includeAdQueues")
    def include_ad_queues(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (optional) Include Auto-Delete queues
        """
        return pulumi.get(self, "include_ad_queues")

    @include_ad_queues.setter
    def include_ad_queues(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_ad_queues", value)

    @_builtins.property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The license key registred for the integration service. (New Relic)
        """
        return pulumi.get(self, "license_key")

    @license_key.setter
    def license_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of metrics integration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key. (Stackdriver)
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private key identifier. (Stackdriver)
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project ID. (Stackdriver)
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="queueAllowlist")
    def queue_allowlist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "queue_allowlist")

    @queue_allowlist.setter
    def queue_allowlist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_allowlist", value)

    @_builtins.property
    @pulumi.getter(name="queueWhitelist")
    @_utilities.deprecated("""use queue_allowlist instead""")
    def queue_whitelist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **Deprecated**
        """
        return pulumi.get(self, "queue_whitelist")

    @queue_whitelist.setter
    def queue_whitelist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_whitelist", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS secret key. (Cloudwatch)
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_access_key", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (optional) tags. E.g. env=prod,region=europe
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vhostAllowlist")
    def vhost_allowlist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "vhost_allowlist")

    @vhost_allowlist.setter
    def vhost_allowlist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vhost_allowlist", value)

    @_builtins.property
    @pulumi.getter(name="vhostWhitelist")
    @_utilities.deprecated("""use vhost_allowlist instead""")
    def vhost_whitelist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **Deprecated**
        """
        return pulumi.get(self, "vhost_whitelist")

    @vhost_whitelist.setter
    def vhost_whitelist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vhost_whitelist", value)


@pulumi.input_type
class _IntegrationMetricState:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 include_ad_queues: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 license_key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_whitelist: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost_whitelist: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IntegrationMetric resources.
        :param pulumi.Input[_builtins.str] access_key_id: AWS access key identifier. (Cloudwatch)
        :param pulumi.Input[_builtins.str] api_key: The API key for the integration service. (Librato)
        :param pulumi.Input[_builtins.str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[_builtins.str] credentials: Base64Encoded credentials. (Stackdriver)
        :param pulumi.Input[_builtins.str] email: The email address registred for the integration service. (Librato)
        :param pulumi.Input[_builtins.str] iam_external_id: External identifier that match the role you created. (Cloudwatch)
        :param pulumi.Input[_builtins.str] iam_role: The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        :param pulumi.Input[_builtins.bool] include_ad_queues: (optional) Include Auto-Delete queues
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier
        :param pulumi.Input[_builtins.str] license_key: The license key registred for the integration service. (New Relic)
        :param pulumi.Input[_builtins.str] name: The name of metrics integration
        :param pulumi.Input[_builtins.str] private_key: The private key. (Stackdriver)
        :param pulumi.Input[_builtins.str] private_key_id: Private key identifier. (Stackdriver)
        :param pulumi.Input[_builtins.str] project_id: Project ID. (Stackdriver)
        :param pulumi.Input[_builtins.str] queue_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[_builtins.str] queue_whitelist: **Deprecated**
        :param pulumi.Input[_builtins.str] region: AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        :param pulumi.Input[_builtins.str] secret_access_key: AWS secret key. (Cloudwatch)
        :param pulumi.Input[_builtins.str] tags: (optional) tags. E.g. env=prod,region=europe
        :param pulumi.Input[_builtins.str] vhost_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[_builtins.str] vhost_whitelist: **Deprecated**
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if iam_external_id is not None:
            pulumi.set(__self__, "iam_external_id", iam_external_id)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if include_ad_queues is not None:
            pulumi.set(__self__, "include_ad_queues", include_ad_queues)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_id is not None:
            pulumi.set(__self__, "private_key_id", private_key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if queue_allowlist is not None:
            pulumi.set(__self__, "queue_allowlist", queue_allowlist)
        if queue_whitelist is not None:
            warnings.warn("""use queue_allowlist instead""", DeprecationWarning)
            pulumi.log.warn("""queue_whitelist is deprecated: use queue_allowlist instead""")
        if queue_whitelist is not None:
            pulumi.set(__self__, "queue_whitelist", queue_whitelist)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vhost_allowlist is not None:
            pulumi.set(__self__, "vhost_allowlist", vhost_allowlist)
        if vhost_whitelist is not None:
            warnings.warn("""use vhost_allowlist instead""", DeprecationWarning)
            pulumi.log.warn("""vhost_whitelist is deprecated: use vhost_allowlist instead""")
        if vhost_whitelist is not None:
            pulumi.set(__self__, "vhost_whitelist", vhost_whitelist)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS access key identifier. (Cloudwatch)
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API key for the integration service. (Librato)
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client email. (Stackdriver)
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_email", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64Encoded credentials. (Stackdriver)
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address registred for the integration service. (Librato)
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="iamExternalId")
    def iam_external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External identifier that match the role you created. (Cloudwatch)
        """
        return pulumi.get(self, "iam_external_id")

    @iam_external_id.setter
    def iam_external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_external_id", value)

    @_builtins.property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        """
        return pulumi.get(self, "iam_role")

    @iam_role.setter
    def iam_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role", value)

    @_builtins.property
    @pulumi.getter(name="includeAdQueues")
    def include_ad_queues(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (optional) Include Auto-Delete queues
        """
        return pulumi.get(self, "include_ad_queues")

    @include_ad_queues.setter
    def include_ad_queues(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_ad_queues", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance identifier
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The license key registred for the integration service. (New Relic)
        """
        return pulumi.get(self, "license_key")

    @license_key.setter
    def license_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of metrics integration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key. (Stackdriver)
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private key identifier. (Stackdriver)
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project ID. (Stackdriver)
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="queueAllowlist")
    def queue_allowlist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "queue_allowlist")

    @queue_allowlist.setter
    def queue_allowlist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_allowlist", value)

    @_builtins.property
    @pulumi.getter(name="queueWhitelist")
    @_utilities.deprecated("""use queue_allowlist instead""")
    def queue_whitelist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **Deprecated**
        """
        return pulumi.get(self, "queue_whitelist")

    @queue_whitelist.setter
    def queue_whitelist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_whitelist", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS secret key. (Cloudwatch)
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_access_key", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (optional) tags. E.g. env=prod,region=europe
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vhostAllowlist")
    def vhost_allowlist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "vhost_allowlist")

    @vhost_allowlist.setter
    def vhost_allowlist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vhost_allowlist", value)

    @_builtins.property
    @pulumi.getter(name="vhostWhitelist")
    @_utilities.deprecated("""use vhost_allowlist instead""")
    def vhost_whitelist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **Deprecated**
        """
        return pulumi.get(self, "vhost_whitelist")

    @vhost_whitelist.setter
    def vhost_whitelist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vhost_whitelist", value)


@pulumi.type_token("cloudamqp:index/integrationMetric:IntegrationMetric")
class IntegrationMetric(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 include_ad_queues: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 license_key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_whitelist: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost_whitelist: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage, forwarding metrics to third party integrations for a
        CloudAMQP instance. Once configured, the metrics produced will be forward to corresponding
        integration.

        Only available for dedicated subscription plans.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Cloudwatch v1 and v2 metric integration</i>
            </b>
          </summary>

        ***Access key***

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch = cloudamqp.IntegrationMetric("cloudwatch",
            instance_id=instance["id"],
            name="cloudwatch",
            access_key_id=aws_access_key_id,
            secret_access_key=var_aws_secret_acccess_key,
            region=aws_region)
        cloudwatch_v2 = cloudamqp.IntegrationMetric("cloudwatch_v2",
            instance_id=instance["id"],
            name="cloudwatch_v2",
            access_key_id=aws_access_key_id,
            secret_access_key=var_aws_secret_acccess_key,
            region=aws_region)
        ```

        ***Assume role***

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch = cloudamqp.IntegrationMetric("cloudwatch",
            instance_id=instance["id"],
            name="cloudwatch",
            iam_role=aws_iam_role,
            iam_external_id=external_id,
            region=aws_region)
        cloudwatch_v2 = cloudamqp.IntegrationMetric("cloudwatch_v2",
            instance_id=instance["id"],
            name="cloudwatch_v2",
            iam_role=aws_iam_role,
            iam_external_id=external_id,
            region=aws_region)
        ```

        * AWS IAM role: arn:aws:iam::ACCOUNT-ID:role/ROLE-NAME
        * External id: Create own external identifier that match the role created. E.g. "cloudamqp-abc123".

        </details>

        <details>
          <summary>
            <b>
              <i>Datadog v1 and v2 metric integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        datadog = cloudamqp.IntegrationMetric("datadog",
            instance_id=instance["id"],
            name="datadog",
            api_key=datadog_api_key,
            region=datadog_region,
            tags="env=prod,region=us1,version=v1.0")
        datadog_v2 = cloudamqp.IntegrationMetric("datadog_v2",
            instance_id=instance["id"],
            name="datadog_v2",
            api_key=datadog_api_key,
            region=datadog_region,
            tags="env=prod,region=us1,version=v1.0")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Librato metric integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        librato = cloudamqp.IntegrationMetric("librato",
            instance_id=instance["id"],
            name="librato",
            email=librato_email,
            api_key=librato_api_key)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>New relic v2 metric integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        newrelic = cloudamqp.IntegrationMetric("newrelic",
            instance_id=instance["id"],
            name="newrelic_v2",
            api_key=newrelic_api_key,
            region=newrelic_region)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Stackdriver metric integration (v1.20.2 or earlier versions)</i>
            </b>
          </summary>

        Use variable file populated with project_id, private_key and client_email

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        stackdriver = cloudamqp.IntegrationMetric("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=stackdriver_project_id,
            private_key=stackdriver_private_key,
            client_email=stackriver_email)
        ```

        or by using google_service_account_key resource from Google provider

        ## Import

        `cloudamqp_integration_metric`can be imported using the resource identifier together with CloudAMQP

        instance identifier (CSV separated). To retrieve the resource identifier, use

        [CloudAMQP API list integrations].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_alarm.alarm

          id = format("<id>,%s", cloudamqp_instance.instance.id)

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/integrationMetric:IntegrationMetric <resource_name> <resource_id>,<instance_id>`
        ```

        [CloudAMQP API add integrations]: https://docs.cloudamqp.com/cloudamqp_api.html#add-metrics-integration

        [CloudAMQP API list integrations]: https://docs.cloudamqp.com/cloudamqp_api.html#list-metrics-integrations

        [Datadog documentation]: https://docs.datadoghq.com/getting_started/tagging/#define-tags

        [integration type reference]: #integration-type-reference

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key_id: AWS access key identifier. (Cloudwatch)
        :param pulumi.Input[_builtins.str] api_key: The API key for the integration service. (Librato)
        :param pulumi.Input[_builtins.str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[_builtins.str] credentials: Base64Encoded credentials. (Stackdriver)
        :param pulumi.Input[_builtins.str] email: The email address registred for the integration service. (Librato)
        :param pulumi.Input[_builtins.str] iam_external_id: External identifier that match the role you created. (Cloudwatch)
        :param pulumi.Input[_builtins.str] iam_role: The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        :param pulumi.Input[_builtins.bool] include_ad_queues: (optional) Include Auto-Delete queues
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier
        :param pulumi.Input[_builtins.str] license_key: The license key registred for the integration service. (New Relic)
        :param pulumi.Input[_builtins.str] name: The name of metrics integration
        :param pulumi.Input[_builtins.str] private_key: The private key. (Stackdriver)
        :param pulumi.Input[_builtins.str] private_key_id: Private key identifier. (Stackdriver)
        :param pulumi.Input[_builtins.str] project_id: Project ID. (Stackdriver)
        :param pulumi.Input[_builtins.str] queue_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[_builtins.str] queue_whitelist: **Deprecated**
        :param pulumi.Input[_builtins.str] region: AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        :param pulumi.Input[_builtins.str] secret_access_key: AWS secret key. (Cloudwatch)
        :param pulumi.Input[_builtins.str] tags: (optional) tags. E.g. env=prod,region=europe
        :param pulumi.Input[_builtins.str] vhost_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[_builtins.str] vhost_whitelist: **Deprecated**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationMetricArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage, forwarding metrics to third party integrations for a
        CloudAMQP instance. Once configured, the metrics produced will be forward to corresponding
        integration.

        Only available for dedicated subscription plans.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Cloudwatch v1 and v2 metric integration</i>
            </b>
          </summary>

        ***Access key***

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch = cloudamqp.IntegrationMetric("cloudwatch",
            instance_id=instance["id"],
            name="cloudwatch",
            access_key_id=aws_access_key_id,
            secret_access_key=var_aws_secret_acccess_key,
            region=aws_region)
        cloudwatch_v2 = cloudamqp.IntegrationMetric("cloudwatch_v2",
            instance_id=instance["id"],
            name="cloudwatch_v2",
            access_key_id=aws_access_key_id,
            secret_access_key=var_aws_secret_acccess_key,
            region=aws_region)
        ```

        ***Assume role***

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch = cloudamqp.IntegrationMetric("cloudwatch",
            instance_id=instance["id"],
            name="cloudwatch",
            iam_role=aws_iam_role,
            iam_external_id=external_id,
            region=aws_region)
        cloudwatch_v2 = cloudamqp.IntegrationMetric("cloudwatch_v2",
            instance_id=instance["id"],
            name="cloudwatch_v2",
            iam_role=aws_iam_role,
            iam_external_id=external_id,
            region=aws_region)
        ```

        * AWS IAM role: arn:aws:iam::ACCOUNT-ID:role/ROLE-NAME
        * External id: Create own external identifier that match the role created. E.g. "cloudamqp-abc123".

        </details>

        <details>
          <summary>
            <b>
              <i>Datadog v1 and v2 metric integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        datadog = cloudamqp.IntegrationMetric("datadog",
            instance_id=instance["id"],
            name="datadog",
            api_key=datadog_api_key,
            region=datadog_region,
            tags="env=prod,region=us1,version=v1.0")
        datadog_v2 = cloudamqp.IntegrationMetric("datadog_v2",
            instance_id=instance["id"],
            name="datadog_v2",
            api_key=datadog_api_key,
            region=datadog_region,
            tags="env=prod,region=us1,version=v1.0")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Librato metric integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        librato = cloudamqp.IntegrationMetric("librato",
            instance_id=instance["id"],
            name="librato",
            email=librato_email,
            api_key=librato_api_key)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>New relic v2 metric integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        newrelic = cloudamqp.IntegrationMetric("newrelic",
            instance_id=instance["id"],
            name="newrelic_v2",
            api_key=newrelic_api_key,
            region=newrelic_region)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Stackdriver metric integration (v1.20.2 or earlier versions)</i>
            </b>
          </summary>

        Use variable file populated with project_id, private_key and client_email

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        stackdriver = cloudamqp.IntegrationMetric("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=stackdriver_project_id,
            private_key=stackdriver_private_key,
            client_email=stackriver_email)
        ```

        or by using google_service_account_key resource from Google provider

        ## Import

        `cloudamqp_integration_metric`can be imported using the resource identifier together with CloudAMQP

        instance identifier (CSV separated). To retrieve the resource identifier, use

        [CloudAMQP API list integrations].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_alarm.alarm

          id = format("<id>,%s", cloudamqp_instance.instance.id)

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/integrationMetric:IntegrationMetric <resource_name> <resource_id>,<instance_id>`
        ```

        [CloudAMQP API add integrations]: https://docs.cloudamqp.com/cloudamqp_api.html#add-metrics-integration

        [CloudAMQP API list integrations]: https://docs.cloudamqp.com/cloudamqp_api.html#list-metrics-integrations

        [Datadog documentation]: https://docs.datadoghq.com/getting_started/tagging/#define-tags

        [integration type reference]: #integration-type-reference

        :param str resource_name: The name of the resource.
        :param IntegrationMetricArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationMetricArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 include_ad_queues: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 license_key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_whitelist: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost_whitelist: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationMetricArgs.__new__(IntegrationMetricArgs)

            __props__.__dict__["access_key_id"] = access_key_id
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["client_email"] = client_email
            __props__.__dict__["credentials"] = None if credentials is None else pulumi.Output.secret(credentials)
            __props__.__dict__["email"] = email
            __props__.__dict__["iam_external_id"] = iam_external_id
            __props__.__dict__["iam_role"] = iam_role
            __props__.__dict__["include_ad_queues"] = include_ad_queues
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["license_key"] = None if license_key is None else pulumi.Output.secret(license_key)
            __props__.__dict__["name"] = name
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["private_key_id"] = None if private_key_id is None else pulumi.Output.secret(private_key_id)
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["queue_allowlist"] = queue_allowlist
            __props__.__dict__["queue_whitelist"] = queue_whitelist
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_access_key"] = None if secret_access_key is None else pulumi.Output.secret(secret_access_key)
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vhost_allowlist"] = vhost_allowlist
            __props__.__dict__["vhost_whitelist"] = vhost_whitelist
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "credentials", "licenseKey", "privateKey", "privateKeyId", "secretAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IntegrationMetric, __self__).__init__(
            'cloudamqp:index/integrationMetric:IntegrationMetric',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            client_email: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            iam_external_id: Optional[pulumi.Input[_builtins.str]] = None,
            iam_role: Optional[pulumi.Input[_builtins.str]] = None,
            include_ad_queues: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            license_key: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            queue_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
            queue_whitelist: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[_builtins.str]] = None,
            vhost_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
            vhost_whitelist: Optional[pulumi.Input[_builtins.str]] = None) -> 'IntegrationMetric':
        """
        Get an existing IntegrationMetric resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key_id: AWS access key identifier. (Cloudwatch)
        :param pulumi.Input[_builtins.str] api_key: The API key for the integration service. (Librato)
        :param pulumi.Input[_builtins.str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[_builtins.str] credentials: Base64Encoded credentials. (Stackdriver)
        :param pulumi.Input[_builtins.str] email: The email address registred for the integration service. (Librato)
        :param pulumi.Input[_builtins.str] iam_external_id: External identifier that match the role you created. (Cloudwatch)
        :param pulumi.Input[_builtins.str] iam_role: The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        :param pulumi.Input[_builtins.bool] include_ad_queues: (optional) Include Auto-Delete queues
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier
        :param pulumi.Input[_builtins.str] license_key: The license key registred for the integration service. (New Relic)
        :param pulumi.Input[_builtins.str] name: The name of metrics integration
        :param pulumi.Input[_builtins.str] private_key: The private key. (Stackdriver)
        :param pulumi.Input[_builtins.str] private_key_id: Private key identifier. (Stackdriver)
        :param pulumi.Input[_builtins.str] project_id: Project ID. (Stackdriver)
        :param pulumi.Input[_builtins.str] queue_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[_builtins.str] queue_whitelist: **Deprecated**
        :param pulumi.Input[_builtins.str] region: AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        :param pulumi.Input[_builtins.str] secret_access_key: AWS secret key. (Cloudwatch)
        :param pulumi.Input[_builtins.str] tags: (optional) tags. E.g. env=prod,region=europe
        :param pulumi.Input[_builtins.str] vhost_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[_builtins.str] vhost_whitelist: **Deprecated**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationMetricState.__new__(_IntegrationMetricState)

        __props__.__dict__["access_key_id"] = access_key_id
        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["client_email"] = client_email
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["email"] = email
        __props__.__dict__["iam_external_id"] = iam_external_id
        __props__.__dict__["iam_role"] = iam_role
        __props__.__dict__["include_ad_queues"] = include_ad_queues
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["license_key"] = license_key
        __props__.__dict__["name"] = name
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["private_key_id"] = private_key_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["queue_allowlist"] = queue_allowlist
        __props__.__dict__["queue_whitelist"] = queue_whitelist
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_access_key"] = secret_access_key
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vhost_allowlist"] = vhost_allowlist
        __props__.__dict__["vhost_whitelist"] = vhost_whitelist
        return IntegrationMetric(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS access key identifier. (Cloudwatch)
        """
        return pulumi.get(self, "access_key_id")

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The API key for the integration service. (Librato)
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Output[_builtins.str]:
        """
        The client email. (Stackdriver)
        """
        return pulumi.get(self, "client_email")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Base64Encoded credentials. (Stackdriver)
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The email address registred for the integration service. (Librato)
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="iamExternalId")
    def iam_external_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        External identifier that match the role you created. (Cloudwatch)
        """
        return pulumi.get(self, "iam_external_id")

    @_builtins.property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        """
        return pulumi.get(self, "iam_role")

    @_builtins.property
    @pulumi.getter(name="includeAdQueues")
    def include_ad_queues(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (optional) Include Auto-Delete queues
        """
        return pulumi.get(self, "include_ad_queues")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        Instance identifier
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The license key registred for the integration service. (New Relic)
        """
        return pulumi.get(self, "license_key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of metrics integration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        The private key. (Stackdriver)
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        Private key identifier. (Stackdriver)
        """
        return pulumi.get(self, "private_key_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Project ID. (Stackdriver)
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="queueAllowlist")
    def queue_allowlist(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "queue_allowlist")

    @_builtins.property
    @pulumi.getter(name="queueWhitelist")
    @_utilities.deprecated("""use queue_allowlist instead""")
    def queue_whitelist(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        **Deprecated**
        """
        return pulumi.get(self, "queue_whitelist")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS secret key. (Cloudwatch)
        """
        return pulumi.get(self, "secret_access_key")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (optional) tags. E.g. env=prod,region=europe
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vhostAllowlist")
    def vhost_allowlist(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "vhost_allowlist")

    @_builtins.property
    @pulumi.getter(name="vhostWhitelist")
    @_utilities.deprecated("""use vhost_allowlist instead""")
    def vhost_whitelist(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        **Deprecated**
        """
        return pulumi.get(self, "vhost_whitelist")

