# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'ExtraDiskSizeNode',
    'InstanceCopySetting',
    'NotificationResponder',
    'SecurityFirewallRule',
    'GetAccountInstanceResult',
    'GetAccountVpcsVpcResult',
    'GetAlarmsAlarmResult',
    'GetNodesNodeResult',
    'GetNotificationsRecipientResult',
    'GetPluginsCommunityPluginResult',
    'GetPluginsPluginResult',
]

@pulumi.output_type
class ExtraDiskSizeNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalDiskSize":
            suggest = "additional_disk_size"
        elif key == "diskSize":
            suggest = "disk_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtraDiskSizeNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtraDiskSizeNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtraDiskSizeNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_disk_size: Optional[_builtins.int] = None,
                 disk_size: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.int additional_disk_size: Additional added disk size
        :param _builtins.int disk_size: Subscription plan disk size
        :param _builtins.str name: Name of the node.
        """
        if additional_disk_size is not None:
            pulumi.set(__self__, "additional_disk_size", additional_disk_size)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="additionalDiskSize")
    def additional_disk_size(self) -> Optional[_builtins.int]:
        """
        Additional added disk size
        """
        return pulumi.get(self, "additional_disk_size")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[_builtins.int]:
        """
        Subscription plan disk size
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the node.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstanceCopySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceCopySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceCopySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceCopySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 settings: Sequence[_builtins.str],
                 subscription_id: _builtins.str):
        """
        :param Sequence[_builtins.str] settings: Array of one or more settings to be copied. Allowed values:
               [alarms, config, definitions, firewall, logs, metrics, plugins]
               
               See more below, [copy settings].
        :param _builtins.str subscription_id: Instance identifier of the CloudAMQP instance to copy the settings
               from.
        """
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Sequence[_builtins.str]:
        """
        Array of one or more settings to be copied. Allowed values:
        [alarms, config, definitions, firewall, logs, metrics, plugins]

        See more below, [copy settings].
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        """
        Instance identifier of the CloudAMQP instance to copy the settings
        from.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class NotificationResponder(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of responder. [`team`, `user`, `escalation`, `schedule`]
        :param _builtins.str id: Identifier in UUID format
        :param _builtins.str name: Name of the responder
        :param _builtins.str username: Username of the responder
               
               Responders of type `team`, `escalation` and `schedule` can use either id or name.
               While `user` can use either id or username.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of responder. [`team`, `user`, `escalation`, `schedule`]
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Identifier in UUID format
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the responder
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        Username of the responder

        Responders of type `team`, `escalation` and `schedule` can use either id or name.
        While `user` can use either id or username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecurityFirewallRule(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 ports: Optional[Sequence[_builtins.int]] = None,
                 services: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str ip: CIDR address: IP address with CIDR notation (e.g. 10.56.72.0/24)
        :param _builtins.str description: Description name of the rule. e.g. Default.
               
               Pre-defined services for RabbitMQ:
               
               | Service name | Port  |
               |--------------|-------|
               | AMQP         | 5672  |
               | AMQPS        | 5671  |
               | HTTPS        | 443   |
               | MQTT         | 1883  |
               | MQTTS        | 8883  |
               | STOMP        | 61613 |
               | STOMPS       | 61614 |
               | STREAM       | 5552  |
               | STREAM_SSL   | 5551  |
               
               Pre-defined services for LavinMQ:
               
               | Service name | Port  |
               |--------------|-------|
               | AMQP         | 5672  |
               | AMQPS        | 5671  |
               | HTTPS        | 443   |
               | MQTT         | 1883  |
               | MQTTS        | 8883  |
        :param Sequence[_builtins.int] ports: Custom ports to be opened
        :param Sequence[_builtins.str] services: Pre-defined service ports, see table below
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        CIDR address: IP address with CIDR notation (e.g. 10.56.72.0/24)
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description name of the rule. e.g. Default.

        Pre-defined services for RabbitMQ:

        | Service name | Port  |
        |--------------|-------|
        | AMQP         | 5672  |
        | AMQPS        | 5671  |
        | HTTPS        | 443   |
        | MQTT         | 1883  |
        | MQTTS        | 8883  |
        | STOMP        | 61613 |
        | STOMPS       | 61614 |
        | STREAM       | 5552  |
        | STREAM_SSL   | 5551  |

        Pre-defined services for LavinMQ:

        | Service name | Port  |
        |--------------|-------|
        | AMQP         | 5672  |
        | AMQPS        | 5671  |
        | HTTPS        | 443   |
        | MQTT         | 1883  |
        | MQTTS        | 8883  |
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence[_builtins.int]]:
        """
        Custom ports to be opened
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[Sequence[_builtins.str]]:
        """
        Pre-defined service ports, see table below
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class GetAccountInstanceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.int,
                 name: _builtins.str,
                 plan: _builtins.str,
                 region: _builtins.str,
                 tags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.int id: The instance identifier.
        :param _builtins.str name: The name of the instance.
        :param _builtins.str plan: The subscription plan used for the instance.
        :param _builtins.str region: The region were the instanece is located in.
        :param Sequence[_builtins.str] tags: Optional tags set for the instance.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The instance identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        The subscription plan used for the instance.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region were the instanece is located in.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Optional tags set for the instance.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetAccountVpcsVpcResult(dict):
    def __init__(__self__, *,
                 id: _builtins.int,
                 name: _builtins.str,
                 region: _builtins.str,
                 subnet: _builtins.str,
                 vpc_name: _builtins.str,
                 tags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.int id: The VPC identifier.
        :param _builtins.str name: The VPC instance name.
        :param _builtins.str region: The region the VPC is hosted in.
        :param _builtins.str subnet: The VPC subnet.
        :param _builtins.str vpc_name: VPC name given when hosted at the cloud provider.
        :param Sequence[_builtins.str] tags: Optional tags set for the VPC.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc_name", vpc_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The VPC identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The VPC instance name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region the VPC is hosted in.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        The VPC subnet.
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> _builtins.str:
        """
        VPC name given when hosted at the cloud provider.
        """
        return pulumi.get(self, "vpc_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Optional tags set for the VPC.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetAlarmsAlarmResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 message_type: _builtins.str,
                 queue_regex: _builtins.str,
                 recipients: Sequence[_builtins.int],
                 reminder_interval: _builtins.int,
                 time_threshold: _builtins.int,
                 value_threshold: _builtins.int,
                 vhost_regex: _builtins.str,
                 alarm_id: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 value_calculation: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enable/disable status of the alarm.
        :param _builtins.str message_type: Message type `(total, unacked, ready)` used by queue alarm type.
        :param _builtins.str queue_regex: Regular expression for which queue to check.
        :param Sequence[_builtins.int] recipients: Identifier for recipient to be notified.
        :param _builtins.int reminder_interval: The reminder interval (in seconds) to resend the alarm if not resolved.
               Set to 0 for no reminders.
        :param _builtins.int time_threshold: The time interval (in seconds) the `value_threshold` should be active
               before trigger an alarm.
        :param _builtins.int value_threshold: The value threshold that triggers the alarm.
        :param _builtins.str vhost_regex: Regular expression for which vhost to check
        :param _builtins.int alarm_id: The alarm identifier.
        :param _builtins.str type: The alarm type to filter for. Supported
               alarm types.
        :param _builtins.str value_calculation: Disk value threshold calculation, `(fixed, percentage)` of disk space
               remaining.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "message_type", message_type)
        pulumi.set(__self__, "queue_regex", queue_regex)
        pulumi.set(__self__, "recipients", recipients)
        pulumi.set(__self__, "reminder_interval", reminder_interval)
        pulumi.set(__self__, "time_threshold", time_threshold)
        pulumi.set(__self__, "value_threshold", value_threshold)
        pulumi.set(__self__, "vhost_regex", vhost_regex)
        if alarm_id is not None:
            pulumi.set(__self__, "alarm_id", alarm_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value_calculation is not None:
            pulumi.set(__self__, "value_calculation", value_calculation)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable/disable status of the alarm.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> _builtins.str:
        """
        Message type `(total, unacked, ready)` used by queue alarm type.
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter(name="queueRegex")
    def queue_regex(self) -> _builtins.str:
        """
        Regular expression for which queue to check.
        """
        return pulumi.get(self, "queue_regex")

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> Sequence[_builtins.int]:
        """
        Identifier for recipient to be notified.
        """
        return pulumi.get(self, "recipients")

    @_builtins.property
    @pulumi.getter(name="reminderInterval")
    def reminder_interval(self) -> _builtins.int:
        """
        The reminder interval (in seconds) to resend the alarm if not resolved.
        Set to 0 for no reminders.
        """
        return pulumi.get(self, "reminder_interval")

    @_builtins.property
    @pulumi.getter(name="timeThreshold")
    def time_threshold(self) -> _builtins.int:
        """
        The time interval (in seconds) the `value_threshold` should be active
        before trigger an alarm.
        """
        return pulumi.get(self, "time_threshold")

    @_builtins.property
    @pulumi.getter(name="valueThreshold")
    def value_threshold(self) -> _builtins.int:
        """
        The value threshold that triggers the alarm.
        """
        return pulumi.get(self, "value_threshold")

    @_builtins.property
    @pulumi.getter(name="vhostRegex")
    def vhost_regex(self) -> _builtins.str:
        """
        Regular expression for which vhost to check
        """
        return pulumi.get(self, "vhost_regex")

    @_builtins.property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> Optional[_builtins.int]:
        """
        The alarm identifier.
        """
        return pulumi.get(self, "alarm_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The alarm type to filter for. Supported
        alarm types.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="valueCalculation")
    def value_calculation(self) -> Optional[_builtins.str]:
        """
        Disk value threshold calculation, `(fixed, percentage)` of disk space
        remaining.
        """
        return pulumi.get(self, "value_calculation")


@pulumi.output_type
class GetNodesNodeResult(dict):
    def __init__(__self__, *,
                 additional_disk_size: _builtins.int,
                 availability_zone: _builtins.str,
                 configured: _builtins.bool,
                 disk_size: _builtins.int,
                 erlang_version: _builtins.str,
                 hipe: _builtins.bool,
                 hostname: _builtins.str,
                 hostname_internal: _builtins.str,
                 name: _builtins.str,
                 rabbitmq_version: _builtins.str,
                 running: _builtins.bool):
        """
        :param _builtins.int additional_disk_size: Additional added disk size
        :param _builtins.str availability_zone: Availability zone the node is hosted in.
        :param _builtins.bool configured: Is the node configured?
        :param _builtins.int disk_size: Subscription plan disk size
        :param _builtins.str erlang_version: Currently used Erlang version on the node.
        :param _builtins.bool hipe: Enable or disable High-performance Erlang.
        :param _builtins.str hostname: External hostname assigned to the node.
        :param _builtins.str hostname_internal: Internal hostname assigned to the node.
        :param _builtins.str name: Name of the node.
        :param _builtins.str rabbitmq_version: Currently configured Rabbit MQ version on the node.
        :param _builtins.bool running: Is the node running?
        """
        pulumi.set(__self__, "additional_disk_size", additional_disk_size)
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "configured", configured)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "erlang_version", erlang_version)
        pulumi.set(__self__, "hipe", hipe)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "hostname_internal", hostname_internal)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rabbitmq_version", rabbitmq_version)
        pulumi.set(__self__, "running", running)

    @_builtins.property
    @pulumi.getter(name="additionalDiskSize")
    def additional_disk_size(self) -> _builtins.int:
        """
        Additional added disk size
        """
        return pulumi.get(self, "additional_disk_size")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        Availability zone the node is hosted in.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def configured(self) -> _builtins.bool:
        """
        Is the node configured?
        """
        return pulumi.get(self, "configured")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> _builtins.int:
        """
        Subscription plan disk size
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter(name="erlangVersion")
    def erlang_version(self) -> _builtins.str:
        """
        Currently used Erlang version on the node.
        """
        return pulumi.get(self, "erlang_version")

    @_builtins.property
    @pulumi.getter
    def hipe(self) -> _builtins.bool:
        """
        Enable or disable High-performance Erlang.
        """
        return pulumi.get(self, "hipe")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        External hostname assigned to the node.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="hostnameInternal")
    def hostname_internal(self) -> _builtins.str:
        """
        Internal hostname assigned to the node.
        """
        return pulumi.get(self, "hostname_internal")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the node.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="rabbitmqVersion")
    def rabbitmq_version(self) -> _builtins.str:
        """
        Currently configured Rabbit MQ version on the node.
        """
        return pulumi.get(self, "rabbitmq_version")

    @_builtins.property
    @pulumi.getter
    def running(self) -> _builtins.bool:
        """
        Is the node running?
        """
        return pulumi.get(self, "running")


@pulumi.output_type
class GetNotificationsRecipientResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 options: Mapping[str, _builtins.str],
                 recipient_id: _builtins.int,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the recipient.
        :param Mapping[str, _builtins.str] options: Options argument (e.g. `rk` used for VictorOps routing key).
        :param _builtins.int recipient_id: The identifier for the recipient.
        :param _builtins.str type: The type of the recipient.
        :param _builtins.str value: The notification endpoint, where to send the notification.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "recipient_id", recipient_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the recipient.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Mapping[str, _builtins.str]:
        """
        Options argument (e.g. `rk` used for VictorOps routing key).
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="recipientId")
    def recipient_id(self) -> _builtins.int:
        """
        The identifier for the recipient.
        """
        return pulumi.get(self, "recipient_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the recipient.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The notification endpoint, where to send the notification.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetPluginsCommunityPluginResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 name: _builtins.str,
                 require: _builtins.str):
        """
        :param _builtins.str description: Description of what the plugin does.
        :param _builtins.str name: The type of the recipient.
        :param _builtins.str require: Min. required Rabbit MQ version to be used.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "require", require)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of what the plugin does.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The type of the recipient.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def require(self) -> _builtins.str:
        """
        Min. required Rabbit MQ version to be used.
        """
        return pulumi.get(self, "require")


@pulumi.output_type
class GetPluginsPluginResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 enabled: _builtins.bool,
                 name: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str description: Description of what the plugin does.
        :param _builtins.bool enabled: Enable or disable information for the plugin.
        :param _builtins.str name: The type of the recipient.
        :param _builtins.str version: Rabbit MQ version that the plugins are shipped with.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of what the plugin does.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable or disable information for the plugin.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The type of the recipient.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Rabbit MQ version that the plugins are shipped with.
        """
        return pulumi.get(self, "version")


