# Instructions for migrating from git.ligo.org to github.com

We hope that migrating development from [git.ligo.org](https://git.ligo.org/lscsoft/bilby) to [GitHub](https://github.com/bilby-dev/bilby) will be relatively painless.
This document provides instructions for common tasks.

## `main` vs `master`

This is not specifically a difference between Gitlab and GitHub, but we took this opportunity to make the [switch](https://www.theserverside.com/feature/Why-GitHub-renamed-its-master-branch-to-main).
New PRs will automatically be into `main` and new clones will automatically checkout `main`.
If you have existing clones (and muscle memory), make sure you always use `main` as the starting point for new branches.

## Migrating development to GitHub:

- [create a fork of github.com/bilby-dev/bilby if you don't already have one](https://github.com/bilby-dev/bilby/fork)
- if you already have a fork on GitHub, you will likely need to [manually update the default branch to `main`](https://docs.github.com/en/repositories/configuring-branches-and-merges-in-your-repository/managing-branches-in-your-repository/changing-the-default-branch)
- fetch all upstream changes `git fetch --all && git pull`
- if git.ligo.org/lscsoft/bilby or a personal fork on git.ligo.org is in your remotes, remove it. Use `git remote -v` to see remotes and `git remote remove` to remove them (they can be added again if needed)
- add your fork on github as a remote `git remote add origin git@github.com:${ME}/bilby.git` (see, e.g., [here](https://stackoverflow.com/questions/9257533/what-is-the-difference-between-origin-and-upstream-on-github) for remote nomenclature)
- add the main repo `git remote add upstream git@github.com:bilby-dev/bilby.git`
- checkout and update `main` `git checkout upstream/main && git pull`
- checkout the new feature branch `git checkout -b FEATURE-BRANCH-NAME`
- push your feature branch to your fork `git push --set-upstream origin FEATURE-BRANCH-NAME`

## Migrating an MR to GitHub:

This largely follows the above instructions for migrating development.

- [create a fork of github.com/bilby-dev/bilby if you don't already have one](https://github.com/bilby-dev/bilby/fork)
- checkout your feature branch `git checkout FEATURE-BRANCH-NAME`
- add your fork on github as a remote `git remote add origin git@github.com:${ME}/bilby.git`
- push your feature branch to your fork `git push --set-upstream origin FEATURE-BRANCH-NAME` (do *not* push to `github.com/bilby-dev/bilby`)
- open a PR to [github.com/bilby-dev/bilby](https://github.com/bilby-dev/bilby/compare)
- copy the description and summarise relevant discussion
- close the MR on [git.ligo.org](https://git.ligo.org/lscsoft/bilby/-/merge_requests)

## Migrating an issue to GitHub:

This should not be necessary, we plan to automatically bulk migrate all issues (open and closed.)

## Merge requests vs pull requests for maintainers

- PR reviews are largely similar to those on gitlab. Anyone can submit a code review (and is encouraged to). Merging a PR requires two approvals from the set of maintainers in addition to any approvals from other users. Maintainers are specified by adding people as repository members.
- There are [three merge options in GitHub](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/incorporating-changes-from-a-pull-request/about-pull-request-merges). We will take this as an opportunity to remove merge commits. Practically, this is done by choosing the "squash and merge" button when merging.

## Making releases

- Making a new release from GitHub can be done using [the web interface](https://github.com/bilby-dev/bilby/releases/new) (also visible on the repository sidebar). As on gitlab, a new tag should be made for each release.
- If you accidentally make a tag without an associated release, a release can be associated with a pre-existing tag.
- GitHub has an automatic release note generation option which gets close to the notes we currently write in the changelog. For example

  > ### What's Changed
  > * CI: add release workflow by @mj-will in https://github.com/bilby-dev/bilby/pull/35
  > * CI: rename test workflow by @ColmTalbot in https://github.com/bilby-dev/bilby/pull/37
  > 
  > ### New Contributors
  > * @mj-will made their first contribution in https://github.com/bilby-dev/bilby/pull/35
  > 
  > **Full Changelog**: https://github.com/bilby-dev/bilby/compare/v2.3.0...v.2.40

  Two additional notes for the autogenerated release notes:
  - The commit message/PR title should always be updated to describe the change as this is directly pulled into the notes.
  - The change list should then be augmented highlighting and adding more detail for the most relevant changes (similar to existing changelog notes).

  COMMENT: I suggest that we make this the primary source of the changelog going forward. The changelog can be pointed to the release page directly, e.g., [here](https://github.com/ColmTalbot/gwpopulation/releases).
