# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAtlasUserResult',
    'AwaitableGetAtlasUserResult',
    'get_atlas_user',
    'get_atlas_user_output',
]

@pulumi.output_type
class GetAtlasUserResult:
    """
    A collection of values returned by getAtlasUser.
    """
    def __init__(__self__, country=None, created_at=None, email_address=None, first_name=None, id=None, last_auth=None, last_name=None, links=None, mobile_number=None, roles=None, team_ids=None, user_id=None, username=None):
        if country and not isinstance(country, str):
            raise TypeError("Expected argument 'country' to be a str")
        pulumi.set(__self__, "country", country)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if email_address and not isinstance(email_address, str):
            raise TypeError("Expected argument 'email_address' to be a str")
        pulumi.set(__self__, "email_address", email_address)
        if first_name and not isinstance(first_name, str):
            raise TypeError("Expected argument 'first_name' to be a str")
        pulumi.set(__self__, "first_name", first_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_auth and not isinstance(last_auth, str):
            raise TypeError("Expected argument 'last_auth' to be a str")
        pulumi.set(__self__, "last_auth", last_auth)
        if last_name and not isinstance(last_name, str):
            raise TypeError("Expected argument 'last_name' to be a str")
        pulumi.set(__self__, "last_name", last_name)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if mobile_number and not isinstance(mobile_number, str):
            raise TypeError("Expected argument 'mobile_number' to be a str")
        pulumi.set(__self__, "mobile_number", mobile_number)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if team_ids and not isinstance(team_ids, list):
            raise TypeError("Expected argument 'team_ids' to be a list")
        pulumi.set(__self__, "team_ids", team_ids)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def country(self) -> _builtins.str:
        """
        Two alphabet characters that identifies MongoDB Atlas user's geographic location. This parameter uses the ISO 3166-1a2 code format.
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date and time when the current account is created. This value is in the ISO 8601 timestamp format in UTC.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> _builtins.str:
        """
        Email address that belongs to the MongoDB Atlas user.
        """
        return pulumi.get(self, "email_address")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> _builtins.str:
        """
        First or given name that belongs to the MongoDB Atlas user.
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Please use user_id id attribute instead""")
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastAuth")
    def last_auth(self) -> _builtins.str:
        """
        Date and time when the current account last authenticated. This value is in the ISO 8601 timestamp format in UTC.
        """
        return pulumi.get(self, "last_auth")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> _builtins.str:
        """
        Last name, family name, or surname that belongs to the MongoDB Atlas user.
        """
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetAtlasUserLinkResult']:
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="mobileNumber")
    def mobile_number(self) -> _builtins.str:
        """
        Mobile phone number that belongs to the MongoDB Atlas user.
        """
        return pulumi.get(self, "mobile_number")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetAtlasUserRoleResult']:
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="teamIds")
    def team_ids(self) -> Sequence[_builtins.str]:
        """
        List of unique 24-hexadecimal digit strings that identifies the teams to which this MongoDB Atlas user belongs.
        * `links.#.href` - Uniform Resource Locator (URL) that points another API resource to which this response has some relationship. This URL often begins with https://cloud.mongodb.com/api/atlas.
        * `links.#.rel` - Uniform Resource Locator (URL) that defines the semantic relationship between this resource and another API resource. This URL often begins with https://cloud.mongodb.com/api/atlas.
        * `roles.#.group_id` - Unique 24-hexadecimal digit string that identifies the project to which this role belongs. You can set a value for this parameter or orgId but not both in the same request.
        * `roles.#.org_id` - Unique 24-hexadecimal digit string that identifies the organization to which this role belongs. You can set a value for this parameter or groupId but not both in the same request.
        * `roles.#.role_name` - Human-readable label that identifies the collection of privileges that MongoDB Atlas grants a specific API key, user, or team. These roles include organization- and project-level roles. The [MongoDB Documentation](https://www.mongodb.com/docs/atlas/reference/user-roles/#service-user-roles) describes the valid roles that can be assigned.
        """
        return pulumi.get(self, "team_ids")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "username")


class AwaitableGetAtlasUserResult(GetAtlasUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAtlasUserResult(
            country=self.country,
            created_at=self.created_at,
            email_address=self.email_address,
            first_name=self.first_name,
            id=self.id,
            last_auth=self.last_auth,
            last_name=self.last_name,
            links=self.links,
            mobile_number=self.mobile_number,
            roles=self.roles,
            team_ids=self.team_ids,
            user_id=self.user_id,
            username=self.username)


def get_atlas_user(user_id: Optional[_builtins.str] = None,
                   username: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAtlasUserResult:
    """
    ## # Data Source: get_atlas_user

    `get_atlas_user` Provides a MongoDB Atlas User.

    > **NOTE:** If you are the owner of a MongoDB Atlas organization or project, you can also retrieve the user profile for any user with membership in that organization or project.

    ## Example Usage

    ### Using user_id attribute to query
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test = mongodbatlas.get_atlas_user(user_id="<USER_ID>")
    ```

    ### Using username attribute to query
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test = mongodbatlas.get_atlas_user(username="<USERNAME>")
    ```


    :param _builtins.str user_id: Unique 24-hexadecimal digit string that identifies this user.
    :param _builtins.str username: Email address that belongs to the MongoDB Atlas user account. You can't modify this address after creating the user.
           
           > **IMPORTANT:** Either `user_id` or `username` must be configurated.
    """
    __args__ = dict()
    __args__['userId'] = user_id
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getAtlasUser:getAtlasUser', __args__, opts=opts, typ=GetAtlasUserResult).value

    return AwaitableGetAtlasUserResult(
        country=pulumi.get(__ret__, 'country'),
        created_at=pulumi.get(__ret__, 'created_at'),
        email_address=pulumi.get(__ret__, 'email_address'),
        first_name=pulumi.get(__ret__, 'first_name'),
        id=pulumi.get(__ret__, 'id'),
        last_auth=pulumi.get(__ret__, 'last_auth'),
        last_name=pulumi.get(__ret__, 'last_name'),
        links=pulumi.get(__ret__, 'links'),
        mobile_number=pulumi.get(__ret__, 'mobile_number'),
        roles=pulumi.get(__ret__, 'roles'),
        team_ids=pulumi.get(__ret__, 'team_ids'),
        user_id=pulumi.get(__ret__, 'user_id'),
        username=pulumi.get(__ret__, 'username'))
def get_atlas_user_output(user_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          username: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAtlasUserResult]:
    """
    ## # Data Source: get_atlas_user

    `get_atlas_user` Provides a MongoDB Atlas User.

    > **NOTE:** If you are the owner of a MongoDB Atlas organization or project, you can also retrieve the user profile for any user with membership in that organization or project.

    ## Example Usage

    ### Using user_id attribute to query
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test = mongodbatlas.get_atlas_user(user_id="<USER_ID>")
    ```

    ### Using username attribute to query
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test = mongodbatlas.get_atlas_user(username="<USERNAME>")
    ```


    :param _builtins.str user_id: Unique 24-hexadecimal digit string that identifies this user.
    :param _builtins.str username: Email address that belongs to the MongoDB Atlas user account. You can't modify this address after creating the user.
           
           > **IMPORTANT:** Either `user_id` or `username` must be configurated.
    """
    __args__ = dict()
    __args__['userId'] = user_id
    __args__['username'] = username
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getAtlasUser:getAtlasUser', __args__, opts=opts, typ=GetAtlasUserResult)
    return __ret__.apply(lambda __response__: GetAtlasUserResult(
        country=pulumi.get(__response__, 'country'),
        created_at=pulumi.get(__response__, 'created_at'),
        email_address=pulumi.get(__response__, 'email_address'),
        first_name=pulumi.get(__response__, 'first_name'),
        id=pulumi.get(__response__, 'id'),
        last_auth=pulumi.get(__response__, 'last_auth'),
        last_name=pulumi.get(__response__, 'last_name'),
        links=pulumi.get(__response__, 'links'),
        mobile_number=pulumi.get(__response__, 'mobile_number'),
        roles=pulumi.get(__response__, 'roles'),
        team_ids=pulumi.get(__response__, 'team_ids'),
        user_id=pulumi.get(__response__, 'user_id'),
        username=pulumi.get(__response__, 'username')))
