# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMaintenanceWindowResult',
    'AwaitableGetMaintenanceWindowResult',
    'get_maintenance_window',
    'get_maintenance_window_output',
]

@pulumi.output_type
class GetMaintenanceWindowResult:
    """
    A collection of values returned by getMaintenanceWindow.
    """
    def __init__(__self__, auto_defer_once_enabled=None, day_of_week=None, hour_of_day=None, id=None, number_of_deferrals=None, project_id=None, protected_hours=None, start_asap=None, time_zone_id=None):
        if auto_defer_once_enabled and not isinstance(auto_defer_once_enabled, bool):
            raise TypeError("Expected argument 'auto_defer_once_enabled' to be a bool")
        pulumi.set(__self__, "auto_defer_once_enabled", auto_defer_once_enabled)
        if day_of_week and not isinstance(day_of_week, int):
            raise TypeError("Expected argument 'day_of_week' to be a int")
        pulumi.set(__self__, "day_of_week", day_of_week)
        if hour_of_day and not isinstance(hour_of_day, int):
            raise TypeError("Expected argument 'hour_of_day' to be a int")
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if number_of_deferrals and not isinstance(number_of_deferrals, int):
            raise TypeError("Expected argument 'number_of_deferrals' to be a int")
        pulumi.set(__self__, "number_of_deferrals", number_of_deferrals)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if protected_hours and not isinstance(protected_hours, list):
            raise TypeError("Expected argument 'protected_hours' to be a list")
        pulumi.set(__self__, "protected_hours", protected_hours)
        if start_asap and not isinstance(start_asap, bool):
            raise TypeError("Expected argument 'start_asap' to be a bool")
        pulumi.set(__self__, "start_asap", start_asap)
        if time_zone_id and not isinstance(time_zone_id, str):
            raise TypeError("Expected argument 'time_zone_id' to be a str")
        pulumi.set(__self__, "time_zone_id", time_zone_id)

    @_builtins.property
    @pulumi.getter(name="autoDeferOnceEnabled")
    def auto_defer_once_enabled(self) -> _builtins.bool:
        """
        Flag that indicates whether you want to defer all maintenance windows one week they would be triggered.
        """
        return pulumi.get(self, "auto_defer_once_enabled")

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> _builtins.int:
        """
        Day of the week when you would like the maintenance window to start as a 1-based integer: Su=1, M=2, T=3, W=4, T=5, F=6, Sa=7.
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> _builtins.int:
        """
        Hour of the day when you would like the maintenance window to start. This parameter uses the 24-hour clock, where midnight is 0, noon is 12  (Time zone is UTC).
        """
        return pulumi.get(self, "hour_of_day")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="numberOfDeferrals")
    def number_of_deferrals(self) -> _builtins.int:
        """
        Number of times the current maintenance event for this project has been deferred, there can be a maximum of 2 deferrals.
        """
        return pulumi.get(self, "number_of_deferrals")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="protectedHours")
    def protected_hours(self) -> Sequence['outputs.GetMaintenanceWindowProtectedHourResult']:
        """
        (Optional) Defines the time period during which there will be no standard updates to the clusters. See Protected Hours.
        """
        return pulumi.get(self, "protected_hours")

    @_builtins.property
    @pulumi.getter(name="startAsap")
    def start_asap(self) -> _builtins.bool:
        """
        Flag indicating whether project maintenance has been directed to start immediately. If you request that maintenance begin immediately, this field returns true from the time the request was made until the time the maintenance event completes.
        """
        return pulumi.get(self, "start_asap")

    @_builtins.property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> _builtins.str:
        """
        Identifier for the current time zone of the maintenance window. This can only be updated via the Project Settings UI.
        """
        return pulumi.get(self, "time_zone_id")


class AwaitableGetMaintenanceWindowResult(GetMaintenanceWindowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaintenanceWindowResult(
            auto_defer_once_enabled=self.auto_defer_once_enabled,
            day_of_week=self.day_of_week,
            hour_of_day=self.hour_of_day,
            id=self.id,
            number_of_deferrals=self.number_of_deferrals,
            project_id=self.project_id,
            protected_hours=self.protected_hours,
            start_asap=self.start_asap,
            time_zone_id=self.time_zone_id)


def get_maintenance_window(project_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaintenanceWindowResult:
    """
    ## # Data Source: MaintenanceWindow

    `MaintenanceWindow` provides a Maintenance Window entry datasource. Gets information regarding the configured maintenance window for a MongoDB Atlas project.

    > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.

    ## Examples Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test_maintenance_window = mongodbatlas.MaintenanceWindow("test",
        project_id="<your-project-id>",
        day_of_week=3,
        hour_of_day=4,
        auto_defer_once_enabled=True)
    test = mongodbatlas.get_maintenance_window_output(project_id=test_maintenance_window.id)
    ```

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test_maintenance_window = mongodbatlas.MaintenanceWindow("test",
        project_id="<your-project-id>",
        start_asap=True)
    test = mongodbatlas.get_maintenance_window_output(project_id=test_maintenance_window.id)
    ```


    :param _builtins.str project_id: The unique identifier of the project for the Maintenance Window.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getMaintenanceWindow:getMaintenanceWindow', __args__, opts=opts, typ=GetMaintenanceWindowResult).value

    return AwaitableGetMaintenanceWindowResult(
        auto_defer_once_enabled=pulumi.get(__ret__, 'auto_defer_once_enabled'),
        day_of_week=pulumi.get(__ret__, 'day_of_week'),
        hour_of_day=pulumi.get(__ret__, 'hour_of_day'),
        id=pulumi.get(__ret__, 'id'),
        number_of_deferrals=pulumi.get(__ret__, 'number_of_deferrals'),
        project_id=pulumi.get(__ret__, 'project_id'),
        protected_hours=pulumi.get(__ret__, 'protected_hours'),
        start_asap=pulumi.get(__ret__, 'start_asap'),
        time_zone_id=pulumi.get(__ret__, 'time_zone_id'))
def get_maintenance_window_output(project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMaintenanceWindowResult]:
    """
    ## # Data Source: MaintenanceWindow

    `MaintenanceWindow` provides a Maintenance Window entry datasource. Gets information regarding the configured maintenance window for a MongoDB Atlas project.

    > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.

    ## Examples Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test_maintenance_window = mongodbatlas.MaintenanceWindow("test",
        project_id="<your-project-id>",
        day_of_week=3,
        hour_of_day=4,
        auto_defer_once_enabled=True)
    test = mongodbatlas.get_maintenance_window_output(project_id=test_maintenance_window.id)
    ```

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test_maintenance_window = mongodbatlas.MaintenanceWindow("test",
        project_id="<your-project-id>",
        start_asap=True)
    test = mongodbatlas.get_maintenance_window_output(project_id=test_maintenance_window.id)
    ```


    :param _builtins.str project_id: The unique identifier of the project for the Maintenance Window.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getMaintenanceWindow:getMaintenanceWindow', __args__, opts=opts, typ=GetMaintenanceWindowResult)
    return __ret__.apply(lambda __response__: GetMaintenanceWindowResult(
        auto_defer_once_enabled=pulumi.get(__response__, 'auto_defer_once_enabled'),
        day_of_week=pulumi.get(__response__, 'day_of_week'),
        hour_of_day=pulumi.get(__response__, 'hour_of_day'),
        id=pulumi.get(__response__, 'id'),
        number_of_deferrals=pulumi.get(__response__, 'number_of_deferrals'),
        project_id=pulumi.get(__response__, 'project_id'),
        protected_hours=pulumi.get(__response__, 'protected_hours'),
        start_asap=pulumi.get(__response__, 'start_asap'),
        time_zone_id=pulumi.get(__response__, 'time_zone_id')))
