# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetStreamPrivatelinkEndpointResult',
    'AwaitableGetStreamPrivatelinkEndpointResult',
    'get_stream_privatelink_endpoint',
    'get_stream_privatelink_endpoint_output',
]

@pulumi.output_type
class GetStreamPrivatelinkEndpointResult:
    """
    A collection of values returned by getStreamPrivatelinkEndpoint.
    """
    def __init__(__self__, arn=None, dns_domain=None, dns_sub_domains=None, error_message=None, id=None, interface_endpoint_id=None, interface_endpoint_name=None, project_id=None, provider_account_id=None, provider_name=None, region=None, service_endpoint_id=None, state=None, vendor=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if dns_domain and not isinstance(dns_domain, str):
            raise TypeError("Expected argument 'dns_domain' to be a str")
        pulumi.set(__self__, "dns_domain", dns_domain)
        if dns_sub_domains and not isinstance(dns_sub_domains, list):
            raise TypeError("Expected argument 'dns_sub_domains' to be a list")
        pulumi.set(__self__, "dns_sub_domains", dns_sub_domains)
        if error_message and not isinstance(error_message, str):
            raise TypeError("Expected argument 'error_message' to be a str")
        pulumi.set(__self__, "error_message", error_message)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interface_endpoint_id and not isinstance(interface_endpoint_id, str):
            raise TypeError("Expected argument 'interface_endpoint_id' to be a str")
        pulumi.set(__self__, "interface_endpoint_id", interface_endpoint_id)
        if interface_endpoint_name and not isinstance(interface_endpoint_name, str):
            raise TypeError("Expected argument 'interface_endpoint_name' to be a str")
        pulumi.set(__self__, "interface_endpoint_name", interface_endpoint_name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if provider_account_id and not isinstance(provider_account_id, str):
            raise TypeError("Expected argument 'provider_account_id' to be a str")
        pulumi.set(__self__, "provider_account_id", provider_account_id)
        if provider_name and not isinstance(provider_name, str):
            raise TypeError("Expected argument 'provider_name' to be a str")
        pulumi.set(__self__, "provider_name", provider_name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_endpoint_id and not isinstance(service_endpoint_id, str):
            raise TypeError("Expected argument 'service_endpoint_id' to be a str")
        pulumi.set(__self__, "service_endpoint_id", service_endpoint_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vendor and not isinstance(vendor, str):
            raise TypeError("Expected argument 'vendor' to be a str")
        pulumi.set(__self__, "vendor", vendor)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        Amazon Resource Name (ARN). Required for AWS Provider and MSK vendor.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> _builtins.str:
        """
        The domain hostname. Required for the following provider and vendor combinations:\\n\\n- AWS provider with CONFLUENT vendor.\\n\\n- AZURE provider with EVENTHUB or CONFLUENT vendor.
        """
        return pulumi.get(self, "dns_domain")

    @_builtins.property
    @pulumi.getter(name="dnsSubDomains")
    def dns_sub_domains(self) -> Sequence[_builtins.str]:
        """
        Sub-Domain name of Confluent cluster. These are typically your availability zones. Required for AWS Provider and CONFLUENT vendor. If your AWS CONFLUENT cluster doesn't use subdomains, you must set this to the empty array [].
        """
        return pulumi.get(self, "dns_sub_domains")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> _builtins.str:
        """
        Error message if the connection is in a failed state.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Private Link connection.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="interfaceEndpointId")
    def interface_endpoint_id(self) -> _builtins.str:
        """
        Interface endpoint ID that is created from the specified service endpoint ID.
        """
        return pulumi.get(self, "interface_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="interfaceEndpointName")
    def interface_endpoint_name(self) -> _builtins.str:
        """
        Name of interface endpoint that is created from the specified service endpoint ID.
        """
        return pulumi.get(self, "interface_endpoint_name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.\\n\\n**NOTE**: Groups and projects are synonymous terms. Your group id is the same as your project id. For existing groups, your group or project id remains the same. The resource and corresponding endpoints use the term groups.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="providerAccountId")
    def provider_account_id(self) -> _builtins.str:
        """
        Account ID from the cloud provider.
        """
        return pulumi.get(self, "provider_account_id")

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> _builtins.str:
        """
        Provider where the Kafka cluster is deployed. Valid values are AWS and AZURE.
        """
        return pulumi.get(self, "provider_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region of the Provider’s cluster. See [AZURE](https://www.mongodb.com/docs/atlas/reference/microsoft-azure/#stream-processing-instances) and [AWS](https://www.mongodb.com/docs/atlas/reference/amazon-aws/#stream-processing-instances) supported regions. When the vendor is `CONFLUENT`, this is the domain name of Confluent cluster. When the vendor is `MSK`, this is computed by the API from the provided `arn`.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> _builtins.str:
        """
        For AZURE EVENTHUB, this is the [namespace endpoint ID](https://learn.microsoft.com/en-us/rest/api/eventhub/namespaces/get). For AWS CONFLUENT cluster, this is the [VPC Endpoint service name](https://docs.confluent.io/cloud/current/networking/private-links/aws-privatelink.html).
        """
        return pulumi.get(self, "service_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Status of the connection.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def vendor(self) -> _builtins.str:
        """
        Vendor that manages the Kafka cluster. The following are the vendor values per provider:\\n\\n- MSK and CONFLUENT for the AWS provider.\\n\\n- EVENTHUB and CONFLUENT for the AZURE provider.
        """
        return pulumi.get(self, "vendor")


class AwaitableGetStreamPrivatelinkEndpointResult(GetStreamPrivatelinkEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamPrivatelinkEndpointResult(
            arn=self.arn,
            dns_domain=self.dns_domain,
            dns_sub_domains=self.dns_sub_domains,
            error_message=self.error_message,
            id=self.id,
            interface_endpoint_id=self.interface_endpoint_id,
            interface_endpoint_name=self.interface_endpoint_name,
            project_id=self.project_id,
            provider_account_id=self.provider_account_id,
            provider_name=self.provider_name,
            region=self.region,
            service_endpoint_id=self.service_endpoint_id,
            state=self.state,
            vendor=self.vendor)


def get_stream_privatelink_endpoint(id: Optional[_builtins.str] = None,
                                    project_id: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamPrivatelinkEndpointResult:
    """
    ## # Data Source: StreamPrivatelinkEndpoint

    `StreamPrivatelinkEndpoint` describes a Privatelink Endpoint for Streams.

    ## Example Usage

    ### S


    :param _builtins.str id: The ID of the Private Link connection.
    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.\\n\\n**NOTE**: Groups and projects are synonymous terms. Your group id is the same as your project id. For existing groups, your group or project id remains the same. The resource and corresponding endpoints use the term groups.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getStreamPrivatelinkEndpoint:getStreamPrivatelinkEndpoint', __args__, opts=opts, typ=GetStreamPrivatelinkEndpointResult).value

    return AwaitableGetStreamPrivatelinkEndpointResult(
        arn=pulumi.get(__ret__, 'arn'),
        dns_domain=pulumi.get(__ret__, 'dns_domain'),
        dns_sub_domains=pulumi.get(__ret__, 'dns_sub_domains'),
        error_message=pulumi.get(__ret__, 'error_message'),
        id=pulumi.get(__ret__, 'id'),
        interface_endpoint_id=pulumi.get(__ret__, 'interface_endpoint_id'),
        interface_endpoint_name=pulumi.get(__ret__, 'interface_endpoint_name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        provider_account_id=pulumi.get(__ret__, 'provider_account_id'),
        provider_name=pulumi.get(__ret__, 'provider_name'),
        region=pulumi.get(__ret__, 'region'),
        service_endpoint_id=pulumi.get(__ret__, 'service_endpoint_id'),
        state=pulumi.get(__ret__, 'state'),
        vendor=pulumi.get(__ret__, 'vendor'))
def get_stream_privatelink_endpoint_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                           project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamPrivatelinkEndpointResult]:
    """
    ## # Data Source: StreamPrivatelinkEndpoint

    `StreamPrivatelinkEndpoint` describes a Privatelink Endpoint for Streams.

    ## Example Usage

    ### S


    :param _builtins.str id: The ID of the Private Link connection.
    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.\\n\\n**NOTE**: Groups and projects are synonymous terms. Your group id is the same as your project id. For existing groups, your group or project id remains the same. The resource and corresponding endpoints use the term groups.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getStreamPrivatelinkEndpoint:getStreamPrivatelinkEndpoint', __args__, opts=opts, typ=GetStreamPrivatelinkEndpointResult)
    return __ret__.apply(lambda __response__: GetStreamPrivatelinkEndpointResult(
        arn=pulumi.get(__response__, 'arn'),
        dns_domain=pulumi.get(__response__, 'dns_domain'),
        dns_sub_domains=pulumi.get(__response__, 'dns_sub_domains'),
        error_message=pulumi.get(__response__, 'error_message'),
        id=pulumi.get(__response__, 'id'),
        interface_endpoint_id=pulumi.get(__response__, 'interface_endpoint_id'),
        interface_endpoint_name=pulumi.get(__response__, 'interface_endpoint_name'),
        project_id=pulumi.get(__response__, 'project_id'),
        provider_account_id=pulumi.get(__response__, 'provider_account_id'),
        provider_name=pulumi.get(__response__, 'provider_name'),
        region=pulumi.get(__response__, 'region'),
        service_endpoint_id=pulumi.get(__response__, 'service_endpoint_id'),
        state=pulumi.get(__response__, 'state'),
        vendor=pulumi.get(__response__, 'vendor')))
