# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MaintenanceWindowArgs', 'MaintenanceWindow']

@pulumi.input_type
class MaintenanceWindowArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input[_builtins.int],
                 project_id: pulumi.Input[_builtins.str],
                 auto_defer: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_defer_once_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 defer: Optional[pulumi.Input[_builtins.bool]] = None,
                 hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
                 protected_hours: Optional[pulumi.Input['MaintenanceWindowProtectedHoursArgs']] = None,
                 start_asap: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a MaintenanceWindow resource.
        :param pulumi.Input[_builtins.int] day_of_week: Day of the week when you would like the maintenance window to start as a 1-based integer: Su=1, M=2, T=3, W=4, T=5, F=6, Sa=7.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Maintenance Window.
        :param pulumi.Input[_builtins.bool] auto_defer: Defer any scheduled maintenance for the given project for one week.
        :param pulumi.Input[_builtins.bool] auto_defer_once_enabled: Flag that indicates whether you want to defer all maintenance windows one week they would be triggered.
        :param pulumi.Input[_builtins.bool] defer: Defer the next scheduled maintenance for the given project for one week.
        :param pulumi.Input[_builtins.int] hour_of_day: Hour of the day when you would like the maintenance window to start. This parameter uses the 24-hour clock, where midnight is 0, noon is 12 (Time zone is UTC). Defaults to 0.
        :param pulumi.Input[_builtins.bool] start_asap: Flag indicating whether project maintenance has been directed to start immediately. If you request that maintenance begin immediately, this field returns true from the time the request was made until the time the maintenance event completes.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "project_id", project_id)
        if auto_defer is not None:
            pulumi.set(__self__, "auto_defer", auto_defer)
        if auto_defer_once_enabled is not None:
            pulumi.set(__self__, "auto_defer_once_enabled", auto_defer_once_enabled)
        if defer is not None:
            pulumi.set(__self__, "defer", defer)
        if hour_of_day is not None:
            pulumi.set(__self__, "hour_of_day", hour_of_day)
        if protected_hours is not None:
            pulumi.set(__self__, "protected_hours", protected_hours)
        if start_asap is not None:
            pulumi.set(__self__, "start_asap", start_asap)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input[_builtins.int]:
        """
        Day of the week when you would like the maintenance window to start as a 1-based integer: Su=1, M=2, T=3, W=4, T=5, F=6, Sa=7.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the project for the Maintenance Window.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="autoDefer")
    def auto_defer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defer any scheduled maintenance for the given project for one week.
        """
        return pulumi.get(self, "auto_defer")

    @auto_defer.setter
    def auto_defer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_defer", value)

    @_builtins.property
    @pulumi.getter(name="autoDeferOnceEnabled")
    def auto_defer_once_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether you want to defer all maintenance windows one week they would be triggered.
        """
        return pulumi.get(self, "auto_defer_once_enabled")

    @auto_defer_once_enabled.setter
    def auto_defer_once_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_defer_once_enabled", value)

    @_builtins.property
    @pulumi.getter
    def defer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defer the next scheduled maintenance for the given project for one week.
        """
        return pulumi.get(self, "defer")

    @defer.setter
    def defer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "defer", value)

    @_builtins.property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Hour of the day when you would like the maintenance window to start. This parameter uses the 24-hour clock, where midnight is 0, noon is 12 (Time zone is UTC). Defaults to 0.
        """
        return pulumi.get(self, "hour_of_day")

    @hour_of_day.setter
    def hour_of_day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hour_of_day", value)

    @_builtins.property
    @pulumi.getter(name="protectedHours")
    def protected_hours(self) -> Optional[pulumi.Input['MaintenanceWindowProtectedHoursArgs']]:
        return pulumi.get(self, "protected_hours")

    @protected_hours.setter
    def protected_hours(self, value: Optional[pulumi.Input['MaintenanceWindowProtectedHoursArgs']]):
        pulumi.set(self, "protected_hours", value)

    @_builtins.property
    @pulumi.getter(name="startAsap")
    def start_asap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag indicating whether project maintenance has been directed to start immediately. If you request that maintenance begin immediately, this field returns true from the time the request was made until the time the maintenance event completes.
        """
        return pulumi.get(self, "start_asap")

    @start_asap.setter
    def start_asap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_asap", value)


@pulumi.input_type
class _MaintenanceWindowState:
    def __init__(__self__, *,
                 auto_defer: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_defer_once_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 day_of_week: Optional[pulumi.Input[_builtins.int]] = None,
                 defer: Optional[pulumi.Input[_builtins.bool]] = None,
                 hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
                 number_of_deferrals: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_hours: Optional[pulumi.Input['MaintenanceWindowProtectedHoursArgs']] = None,
                 start_asap: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MaintenanceWindow resources.
        :param pulumi.Input[_builtins.bool] auto_defer: Defer any scheduled maintenance for the given project for one week.
        :param pulumi.Input[_builtins.bool] auto_defer_once_enabled: Flag that indicates whether you want to defer all maintenance windows one week they would be triggered.
        :param pulumi.Input[_builtins.int] day_of_week: Day of the week when you would like the maintenance window to start as a 1-based integer: Su=1, M=2, T=3, W=4, T=5, F=6, Sa=7.
        :param pulumi.Input[_builtins.bool] defer: Defer the next scheduled maintenance for the given project for one week.
        :param pulumi.Input[_builtins.int] hour_of_day: Hour of the day when you would like the maintenance window to start. This parameter uses the 24-hour clock, where midnight is 0, noon is 12 (Time zone is UTC). Defaults to 0.
        :param pulumi.Input[_builtins.int] number_of_deferrals: Number of times the current maintenance event for this project has been deferred, there can be a maximum of 2 deferrals.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Maintenance Window.
        :param pulumi.Input[_builtins.bool] start_asap: Flag indicating whether project maintenance has been directed to start immediately. If you request that maintenance begin immediately, this field returns true from the time the request was made until the time the maintenance event completes.
        :param pulumi.Input[_builtins.str] time_zone_id: Identifier for the current time zone of the maintenance window. This can only be updated via the Project Settings UI.
        """
        if auto_defer is not None:
            pulumi.set(__self__, "auto_defer", auto_defer)
        if auto_defer_once_enabled is not None:
            pulumi.set(__self__, "auto_defer_once_enabled", auto_defer_once_enabled)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if defer is not None:
            pulumi.set(__self__, "defer", defer)
        if hour_of_day is not None:
            pulumi.set(__self__, "hour_of_day", hour_of_day)
        if number_of_deferrals is not None:
            pulumi.set(__self__, "number_of_deferrals", number_of_deferrals)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protected_hours is not None:
            pulumi.set(__self__, "protected_hours", protected_hours)
        if start_asap is not None:
            pulumi.set(__self__, "start_asap", start_asap)
        if time_zone_id is not None:
            pulumi.set(__self__, "time_zone_id", time_zone_id)

    @_builtins.property
    @pulumi.getter(name="autoDefer")
    def auto_defer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defer any scheduled maintenance for the given project for one week.
        """
        return pulumi.get(self, "auto_defer")

    @auto_defer.setter
    def auto_defer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_defer", value)

    @_builtins.property
    @pulumi.getter(name="autoDeferOnceEnabled")
    def auto_defer_once_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether you want to defer all maintenance windows one week they would be triggered.
        """
        return pulumi.get(self, "auto_defer_once_enabled")

    @auto_defer_once_enabled.setter
    def auto_defer_once_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_defer_once_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Day of the week when you would like the maintenance window to start as a 1-based integer: Su=1, M=2, T=3, W=4, T=5, F=6, Sa=7.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter
    def defer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defer the next scheduled maintenance for the given project for one week.
        """
        return pulumi.get(self, "defer")

    @defer.setter
    def defer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "defer", value)

    @_builtins.property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Hour of the day when you would like the maintenance window to start. This parameter uses the 24-hour clock, where midnight is 0, noon is 12 (Time zone is UTC). Defaults to 0.
        """
        return pulumi.get(self, "hour_of_day")

    @hour_of_day.setter
    def hour_of_day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hour_of_day", value)

    @_builtins.property
    @pulumi.getter(name="numberOfDeferrals")
    def number_of_deferrals(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of times the current maintenance event for this project has been deferred, there can be a maximum of 2 deferrals.
        """
        return pulumi.get(self, "number_of_deferrals")

    @number_of_deferrals.setter
    def number_of_deferrals(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_deferrals", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the project for the Maintenance Window.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="protectedHours")
    def protected_hours(self) -> Optional[pulumi.Input['MaintenanceWindowProtectedHoursArgs']]:
        return pulumi.get(self, "protected_hours")

    @protected_hours.setter
    def protected_hours(self, value: Optional[pulumi.Input['MaintenanceWindowProtectedHoursArgs']]):
        pulumi.set(self, "protected_hours", value)

    @_builtins.property
    @pulumi.getter(name="startAsap")
    def start_asap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag indicating whether project maintenance has been directed to start immediately. If you request that maintenance begin immediately, this field returns true from the time the request was made until the time the maintenance event completes.
        """
        return pulumi.get(self, "start_asap")

    @start_asap.setter
    def start_asap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_asap", value)

    @_builtins.property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the current time zone of the maintenance window. This can only be updated via the Project Settings UI.
        """
        return pulumi.get(self, "time_zone_id")

    @time_zone_id.setter
    def time_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone_id", value)


@pulumi.type_token("mongodbatlas:index/maintenanceWindow:MaintenanceWindow")
class MaintenanceWindow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_defer: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_defer_once_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 day_of_week: Optional[pulumi.Input[_builtins.int]] = None,
                 defer: Optional[pulumi.Input[_builtins.bool]] = None,
                 hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_hours: Optional[pulumi.Input[Union['MaintenanceWindowProtectedHoursArgs', 'MaintenanceWindowProtectedHoursArgsDict']]] = None,
                 start_asap: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## # Resource: MaintenanceWindow

        `MaintenanceWindow` provides a resource to schedule the maintenance window for your MongoDB Atlas Project and/or set to defer a scheduled maintenance up to two times. Please refer to [Maintenance Windows](https://www.mongodb.com/docs/atlas/tutorial/cluster-maintenance-window/#configure-maintenance-window) documentation for more details.

        > **NOTE:** Only a single maintenance window resource can be defined per project.

        > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.

        ## Maintenance Window Considerations:

        - Urgent Maintenance Activities Cannot Wait: Urgent maintenance activities such as security patches cannot wait for your chosen window. Atlas will start those maintenance activities when needed.

        Once maintenance is scheduled for your cluster, you cannot change your maintenance window until the current maintenance efforts have completed.
        - Maintenance Requires Replica Set Elections: Atlas performs maintenance the same way as the manual maintenance procedure. This requires at least one replica set election during the maintenance window per replica set.
        - Maintenance Starts As Close to the Hour As Possible: Maintenance always begins as close to the scheduled hour as possible, but in-progress cluster updates or expected system issues could delay the start time.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.MaintenanceWindow("test",
            project_id="<your-project-id>",
            day_of_week=3,
            hour_of_day=4,
            protected_hours={
                "start_hour_of_day": 9,
                "end_hour_of_day": 17,
            })
        ```

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.MaintenanceWindow("test",
            project_id="<your-project-id>",
            defer=True)
        ```

        ## Import

        Maintenance Window entries can be imported using project project_id, in the format `PROJECTID`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/maintenanceWindow:MaintenanceWindow test 5d0f1f73cf09a29120e173cf
        ```
        For more information see: [MongoDB Atlas API Reference.](https://docs.atlas.mongodb.com/reference/api/maintenance-windows/)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_defer: Defer any scheduled maintenance for the given project for one week.
        :param pulumi.Input[_builtins.bool] auto_defer_once_enabled: Flag that indicates whether you want to defer all maintenance windows one week they would be triggered.
        :param pulumi.Input[_builtins.int] day_of_week: Day of the week when you would like the maintenance window to start as a 1-based integer: Su=1, M=2, T=3, W=4, T=5, F=6, Sa=7.
        :param pulumi.Input[_builtins.bool] defer: Defer the next scheduled maintenance for the given project for one week.
        :param pulumi.Input[_builtins.int] hour_of_day: Hour of the day when you would like the maintenance window to start. This parameter uses the 24-hour clock, where midnight is 0, noon is 12 (Time zone is UTC). Defaults to 0.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Maintenance Window.
        :param pulumi.Input[_builtins.bool] start_asap: Flag indicating whether project maintenance has been directed to start immediately. If you request that maintenance begin immediately, this field returns true from the time the request was made until the time the maintenance event completes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MaintenanceWindowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: MaintenanceWindow

        `MaintenanceWindow` provides a resource to schedule the maintenance window for your MongoDB Atlas Project and/or set to defer a scheduled maintenance up to two times. Please refer to [Maintenance Windows](https://www.mongodb.com/docs/atlas/tutorial/cluster-maintenance-window/#configure-maintenance-window) documentation for more details.

        > **NOTE:** Only a single maintenance window resource can be defined per project.

        > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.

        ## Maintenance Window Considerations:

        - Urgent Maintenance Activities Cannot Wait: Urgent maintenance activities such as security patches cannot wait for your chosen window. Atlas will start those maintenance activities when needed.

        Once maintenance is scheduled for your cluster, you cannot change your maintenance window until the current maintenance efforts have completed.
        - Maintenance Requires Replica Set Elections: Atlas performs maintenance the same way as the manual maintenance procedure. This requires at least one replica set election during the maintenance window per replica set.
        - Maintenance Starts As Close to the Hour As Possible: Maintenance always begins as close to the scheduled hour as possible, but in-progress cluster updates or expected system issues could delay the start time.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.MaintenanceWindow("test",
            project_id="<your-project-id>",
            day_of_week=3,
            hour_of_day=4,
            protected_hours={
                "start_hour_of_day": 9,
                "end_hour_of_day": 17,
            })
        ```

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.MaintenanceWindow("test",
            project_id="<your-project-id>",
            defer=True)
        ```

        ## Import

        Maintenance Window entries can be imported using project project_id, in the format `PROJECTID`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/maintenanceWindow:MaintenanceWindow test 5d0f1f73cf09a29120e173cf
        ```
        For more information see: [MongoDB Atlas API Reference.](https://docs.atlas.mongodb.com/reference/api/maintenance-windows/)

        :param str resource_name: The name of the resource.
        :param MaintenanceWindowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaintenanceWindowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_defer: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_defer_once_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 day_of_week: Optional[pulumi.Input[_builtins.int]] = None,
                 defer: Optional[pulumi.Input[_builtins.bool]] = None,
                 hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_hours: Optional[pulumi.Input[Union['MaintenanceWindowProtectedHoursArgs', 'MaintenanceWindowProtectedHoursArgsDict']]] = None,
                 start_asap: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaintenanceWindowArgs.__new__(MaintenanceWindowArgs)

            __props__.__dict__["auto_defer"] = auto_defer
            __props__.__dict__["auto_defer_once_enabled"] = auto_defer_once_enabled
            if day_of_week is None and not opts.urn:
                raise TypeError("Missing required property 'day_of_week'")
            __props__.__dict__["day_of_week"] = day_of_week
            __props__.__dict__["defer"] = defer
            __props__.__dict__["hour_of_day"] = hour_of_day
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["protected_hours"] = protected_hours
            __props__.__dict__["start_asap"] = start_asap
            __props__.__dict__["number_of_deferrals"] = None
            __props__.__dict__["time_zone_id"] = None
        super(MaintenanceWindow, __self__).__init__(
            'mongodbatlas:index/maintenanceWindow:MaintenanceWindow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_defer: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_defer_once_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            day_of_week: Optional[pulumi.Input[_builtins.int]] = None,
            defer: Optional[pulumi.Input[_builtins.bool]] = None,
            hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
            number_of_deferrals: Optional[pulumi.Input[_builtins.int]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            protected_hours: Optional[pulumi.Input[Union['MaintenanceWindowProtectedHoursArgs', 'MaintenanceWindowProtectedHoursArgsDict']]] = None,
            start_asap: Optional[pulumi.Input[_builtins.bool]] = None,
            time_zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'MaintenanceWindow':
        """
        Get an existing MaintenanceWindow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_defer: Defer any scheduled maintenance for the given project for one week.
        :param pulumi.Input[_builtins.bool] auto_defer_once_enabled: Flag that indicates whether you want to defer all maintenance windows one week they would be triggered.
        :param pulumi.Input[_builtins.int] day_of_week: Day of the week when you would like the maintenance window to start as a 1-based integer: Su=1, M=2, T=3, W=4, T=5, F=6, Sa=7.
        :param pulumi.Input[_builtins.bool] defer: Defer the next scheduled maintenance for the given project for one week.
        :param pulumi.Input[_builtins.int] hour_of_day: Hour of the day when you would like the maintenance window to start. This parameter uses the 24-hour clock, where midnight is 0, noon is 12 (Time zone is UTC). Defaults to 0.
        :param pulumi.Input[_builtins.int] number_of_deferrals: Number of times the current maintenance event for this project has been deferred, there can be a maximum of 2 deferrals.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Maintenance Window.
        :param pulumi.Input[_builtins.bool] start_asap: Flag indicating whether project maintenance has been directed to start immediately. If you request that maintenance begin immediately, this field returns true from the time the request was made until the time the maintenance event completes.
        :param pulumi.Input[_builtins.str] time_zone_id: Identifier for the current time zone of the maintenance window. This can only be updated via the Project Settings UI.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaintenanceWindowState.__new__(_MaintenanceWindowState)

        __props__.__dict__["auto_defer"] = auto_defer
        __props__.__dict__["auto_defer_once_enabled"] = auto_defer_once_enabled
        __props__.__dict__["day_of_week"] = day_of_week
        __props__.__dict__["defer"] = defer
        __props__.__dict__["hour_of_day"] = hour_of_day
        __props__.__dict__["number_of_deferrals"] = number_of_deferrals
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["protected_hours"] = protected_hours
        __props__.__dict__["start_asap"] = start_asap
        __props__.__dict__["time_zone_id"] = time_zone_id
        return MaintenanceWindow(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoDefer")
    def auto_defer(self) -> pulumi.Output[_builtins.bool]:
        """
        Defer any scheduled maintenance for the given project for one week.
        """
        return pulumi.get(self, "auto_defer")

    @_builtins.property
    @pulumi.getter(name="autoDeferOnceEnabled")
    def auto_defer_once_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag that indicates whether you want to defer all maintenance windows one week they would be triggered.
        """
        return pulumi.get(self, "auto_defer_once_enabled")

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Output[_builtins.int]:
        """
        Day of the week when you would like the maintenance window to start as a 1-based integer: Su=1, M=2, T=3, W=4, T=5, F=6, Sa=7.
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter
    def defer(self) -> pulumi.Output[_builtins.bool]:
        """
        Defer the next scheduled maintenance for the given project for one week.
        """
        return pulumi.get(self, "defer")

    @_builtins.property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> pulumi.Output[_builtins.int]:
        """
        Hour of the day when you would like the maintenance window to start. This parameter uses the 24-hour clock, where midnight is 0, noon is 12 (Time zone is UTC). Defaults to 0.
        """
        return pulumi.get(self, "hour_of_day")

    @_builtins.property
    @pulumi.getter(name="numberOfDeferrals")
    def number_of_deferrals(self) -> pulumi.Output[_builtins.int]:
        """
        Number of times the current maintenance event for this project has been deferred, there can be a maximum of 2 deferrals.
        """
        return pulumi.get(self, "number_of_deferrals")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the project for the Maintenance Window.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="protectedHours")
    def protected_hours(self) -> pulumi.Output[Optional['outputs.MaintenanceWindowProtectedHours']]:
        return pulumi.get(self, "protected_hours")

    @_builtins.property
    @pulumi.getter(name="startAsap")
    def start_asap(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag indicating whether project maintenance has been directed to start immediately. If you request that maintenance begin immediately, this field returns true from the time the request was made until the time the maintenance event completes.
        """
        return pulumi.get(self, "start_asap")

    @_builtins.property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier for the current time zone of the maintenance window. This can only be updated via the Project Settings UI.
        """
        return pulumi.get(self, "time_zone_id")

