# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CommonLicenseManageBigIqArgs', 'CommonLicenseManageBigIq']

@pulumi.input_type
class CommonLicenseManageBigIqArgs:
    def __init__(__self__, *,
                 assignment_type: pulumi.Input[_builtins.str],
                 bigiq_address: pulumi.Input[_builtins.str],
                 bigiq_password: pulumi.Input[_builtins.str],
                 bigiq_user: pulumi.Input[_builtins.str],
                 license_poolname: pulumi.Input[_builtins.str],
                 bigiq_login_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_port: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_token_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 device_license_status: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 skukeyword1: Optional[pulumi.Input[_builtins.str]] = None,
                 skukeyword2: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_of_measure: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CommonLicenseManageBigIq resource.
        :param pulumi.Input[_builtins.str] assignment_type: The type of assignment, which is determined by whether the BIG-IP is unreachable, unmanaged, or managed by BIG-IQ. Possible values: “UNREACHABLE”, “UNMANAGED”, or “MANAGED”.
        :param pulumi.Input[_builtins.str] bigiq_address: BIGIQ License Manager IP Address, variable type `string`
        :param pulumi.Input[_builtins.str] bigiq_password: BIGIQ License Manager password.  variable type `string`
        :param pulumi.Input[_builtins.str] bigiq_user: BIGIQ License Manager username, variable type `string`
        :param pulumi.Input[_builtins.str] license_poolname: A name given to the license pool. type `string`
        :param pulumi.Input[_builtins.str] bigiq_login_ref: BIGIQ Login reference for token authentication
        :param pulumi.Input[_builtins.str] bigiq_port: type `int`, BIGIQ License Manager Port number, specify if port is other than `443`
        :param pulumi.Input[_builtins.bool] bigiq_token_auth: type `bool`, if set to `true` enables Token based Authentication,default is `false`
        :param pulumi.Input[_builtins.str] device_license_status: Status of Licence Assignment
        :param pulumi.Input[_builtins.str] hypervisor: Identifies the platform running the BIG-IP VE. Possible values: “aws”, “azure”, “gce”, “vmware”, “hyperv”, “kvm”, or “xen”. type `string`
        :param pulumi.Input[_builtins.str] key: License Assignment is done with specified `key`, supported only with RegKeypool type License assignement. type `string`
        :param pulumi.Input[_builtins.str] mac_address: MAC address of the BIG-IP. type `string`
        :param pulumi.Input[_builtins.str] skukeyword1: An optional offering name. type `string`
        :param pulumi.Input[_builtins.str] skukeyword2: An optional offering name. type `string`
        :param pulumi.Input[_builtins.str] tenant: For an unreachable BIG-IP, you can provide an optional description for the assignment in this field.
        :param pulumi.Input[_builtins.str] unit_of_measure: The units used to measure billing. For example, “hourly” or “daily”. Type `string`
        """
        pulumi.set(__self__, "assignment_type", assignment_type)
        pulumi.set(__self__, "bigiq_address", bigiq_address)
        pulumi.set(__self__, "bigiq_password", bigiq_password)
        pulumi.set(__self__, "bigiq_user", bigiq_user)
        pulumi.set(__self__, "license_poolname", license_poolname)
        if bigiq_login_ref is not None:
            pulumi.set(__self__, "bigiq_login_ref", bigiq_login_ref)
        if bigiq_port is not None:
            pulumi.set(__self__, "bigiq_port", bigiq_port)
        if bigiq_token_auth is not None:
            pulumi.set(__self__, "bigiq_token_auth", bigiq_token_auth)
        if device_license_status is not None:
            pulumi.set(__self__, "device_license_status", device_license_status)
        if hypervisor is not None:
            pulumi.set(__self__, "hypervisor", hypervisor)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if skukeyword1 is not None:
            pulumi.set(__self__, "skukeyword1", skukeyword1)
        if skukeyword2 is not None:
            pulumi.set(__self__, "skukeyword2", skukeyword2)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if unit_of_measure is not None:
            pulumi.set(__self__, "unit_of_measure", unit_of_measure)

    @_builtins.property
    @pulumi.getter(name="assignmentType")
    def assignment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of assignment, which is determined by whether the BIG-IP is unreachable, unmanaged, or managed by BIG-IQ. Possible values: “UNREACHABLE”, “UNMANAGED”, or “MANAGED”.
        """
        return pulumi.get(self, "assignment_type")

    @assignment_type.setter
    def assignment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "assignment_type", value)

    @_builtins.property
    @pulumi.getter(name="bigiqAddress")
    def bigiq_address(self) -> pulumi.Input[_builtins.str]:
        """
        BIGIQ License Manager IP Address, variable type `string`
        """
        return pulumi.get(self, "bigiq_address")

    @bigiq_address.setter
    def bigiq_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bigiq_address", value)

    @_builtins.property
    @pulumi.getter(name="bigiqPassword")
    def bigiq_password(self) -> pulumi.Input[_builtins.str]:
        """
        BIGIQ License Manager password.  variable type `string`
        """
        return pulumi.get(self, "bigiq_password")

    @bigiq_password.setter
    def bigiq_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bigiq_password", value)

    @_builtins.property
    @pulumi.getter(name="bigiqUser")
    def bigiq_user(self) -> pulumi.Input[_builtins.str]:
        """
        BIGIQ License Manager username, variable type `string`
        """
        return pulumi.get(self, "bigiq_user")

    @bigiq_user.setter
    def bigiq_user(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bigiq_user", value)

    @_builtins.property
    @pulumi.getter(name="licensePoolname")
    def license_poolname(self) -> pulumi.Input[_builtins.str]:
        """
        A name given to the license pool. type `string`
        """
        return pulumi.get(self, "license_poolname")

    @license_poolname.setter
    def license_poolname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "license_poolname", value)

    @_builtins.property
    @pulumi.getter(name="bigiqLoginRef")
    def bigiq_login_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BIGIQ Login reference for token authentication
        """
        return pulumi.get(self, "bigiq_login_ref")

    @bigiq_login_ref.setter
    def bigiq_login_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bigiq_login_ref", value)

    @_builtins.property
    @pulumi.getter(name="bigiqPort")
    def bigiq_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type `int`, BIGIQ License Manager Port number, specify if port is other than `443`
        """
        return pulumi.get(self, "bigiq_port")

    @bigiq_port.setter
    def bigiq_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bigiq_port", value)

    @_builtins.property
    @pulumi.getter(name="bigiqTokenAuth")
    def bigiq_token_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        type `bool`, if set to `true` enables Token based Authentication,default is `false`
        """
        return pulumi.get(self, "bigiq_token_auth")

    @bigiq_token_auth.setter
    def bigiq_token_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bigiq_token_auth", value)

    @_builtins.property
    @pulumi.getter(name="deviceLicenseStatus")
    def device_license_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of Licence Assignment
        """
        return pulumi.get(self, "device_license_status")

    @device_license_status.setter
    def device_license_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device_license_status", value)

    @_builtins.property
    @pulumi.getter
    def hypervisor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the platform running the BIG-IP VE. Possible values: “aws”, “azure”, “gce”, “vmware”, “hyperv”, “kvm”, or “xen”. type `string`
        """
        return pulumi.get(self, "hypervisor")

    @hypervisor.setter
    def hypervisor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hypervisor", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        License Assignment is done with specified `key`, supported only with RegKeypool type License assignement. type `string`
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MAC address of the BIG-IP. type `string`
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter
    def skukeyword1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional offering name. type `string`
        """
        return pulumi.get(self, "skukeyword1")

    @skukeyword1.setter
    def skukeyword1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "skukeyword1", value)

    @_builtins.property
    @pulumi.getter
    def skukeyword2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional offering name. type `string`
        """
        return pulumi.get(self, "skukeyword2")

    @skukeyword2.setter
    def skukeyword2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "skukeyword2", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For an unreachable BIG-IP, you can provide an optional description for the assignment in this field.
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter(name="unitOfMeasure")
    def unit_of_measure(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The units used to measure billing. For example, “hourly” or “daily”. Type `string`
        """
        return pulumi.get(self, "unit_of_measure")

    @unit_of_measure.setter
    def unit_of_measure(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_of_measure", value)


@pulumi.input_type
class _CommonLicenseManageBigIqState:
    def __init__(__self__, *,
                 assignment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_address: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_login_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_password: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_port: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_token_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 bigiq_user: Optional[pulumi.Input[_builtins.str]] = None,
                 device_license_status: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 license_poolname: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 skukeyword1: Optional[pulumi.Input[_builtins.str]] = None,
                 skukeyword2: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_of_measure: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CommonLicenseManageBigIq resources.
        :param pulumi.Input[_builtins.str] assignment_type: The type of assignment, which is determined by whether the BIG-IP is unreachable, unmanaged, or managed by BIG-IQ. Possible values: “UNREACHABLE”, “UNMANAGED”, or “MANAGED”.
        :param pulumi.Input[_builtins.str] bigiq_address: BIGIQ License Manager IP Address, variable type `string`
        :param pulumi.Input[_builtins.str] bigiq_login_ref: BIGIQ Login reference for token authentication
        :param pulumi.Input[_builtins.str] bigiq_password: BIGIQ License Manager password.  variable type `string`
        :param pulumi.Input[_builtins.str] bigiq_port: type `int`, BIGIQ License Manager Port number, specify if port is other than `443`
        :param pulumi.Input[_builtins.bool] bigiq_token_auth: type `bool`, if set to `true` enables Token based Authentication,default is `false`
        :param pulumi.Input[_builtins.str] bigiq_user: BIGIQ License Manager username, variable type `string`
        :param pulumi.Input[_builtins.str] device_license_status: Status of Licence Assignment
        :param pulumi.Input[_builtins.str] hypervisor: Identifies the platform running the BIG-IP VE. Possible values: “aws”, “azure”, “gce”, “vmware”, “hyperv”, “kvm”, or “xen”. type `string`
        :param pulumi.Input[_builtins.str] key: License Assignment is done with specified `key`, supported only with RegKeypool type License assignement. type `string`
        :param pulumi.Input[_builtins.str] license_poolname: A name given to the license pool. type `string`
        :param pulumi.Input[_builtins.str] mac_address: MAC address of the BIG-IP. type `string`
        :param pulumi.Input[_builtins.str] skukeyword1: An optional offering name. type `string`
        :param pulumi.Input[_builtins.str] skukeyword2: An optional offering name. type `string`
        :param pulumi.Input[_builtins.str] tenant: For an unreachable BIG-IP, you can provide an optional description for the assignment in this field.
        :param pulumi.Input[_builtins.str] unit_of_measure: The units used to measure billing. For example, “hourly” or “daily”. Type `string`
        """
        if assignment_type is not None:
            pulumi.set(__self__, "assignment_type", assignment_type)
        if bigiq_address is not None:
            pulumi.set(__self__, "bigiq_address", bigiq_address)
        if bigiq_login_ref is not None:
            pulumi.set(__self__, "bigiq_login_ref", bigiq_login_ref)
        if bigiq_password is not None:
            pulumi.set(__self__, "bigiq_password", bigiq_password)
        if bigiq_port is not None:
            pulumi.set(__self__, "bigiq_port", bigiq_port)
        if bigiq_token_auth is not None:
            pulumi.set(__self__, "bigiq_token_auth", bigiq_token_auth)
        if bigiq_user is not None:
            pulumi.set(__self__, "bigiq_user", bigiq_user)
        if device_license_status is not None:
            pulumi.set(__self__, "device_license_status", device_license_status)
        if hypervisor is not None:
            pulumi.set(__self__, "hypervisor", hypervisor)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if license_poolname is not None:
            pulumi.set(__self__, "license_poolname", license_poolname)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if skukeyword1 is not None:
            pulumi.set(__self__, "skukeyword1", skukeyword1)
        if skukeyword2 is not None:
            pulumi.set(__self__, "skukeyword2", skukeyword2)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if unit_of_measure is not None:
            pulumi.set(__self__, "unit_of_measure", unit_of_measure)

    @_builtins.property
    @pulumi.getter(name="assignmentType")
    def assignment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of assignment, which is determined by whether the BIG-IP is unreachable, unmanaged, or managed by BIG-IQ. Possible values: “UNREACHABLE”, “UNMANAGED”, or “MANAGED”.
        """
        return pulumi.get(self, "assignment_type")

    @assignment_type.setter
    def assignment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assignment_type", value)

    @_builtins.property
    @pulumi.getter(name="bigiqAddress")
    def bigiq_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BIGIQ License Manager IP Address, variable type `string`
        """
        return pulumi.get(self, "bigiq_address")

    @bigiq_address.setter
    def bigiq_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bigiq_address", value)

    @_builtins.property
    @pulumi.getter(name="bigiqLoginRef")
    def bigiq_login_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BIGIQ Login reference for token authentication
        """
        return pulumi.get(self, "bigiq_login_ref")

    @bigiq_login_ref.setter
    def bigiq_login_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bigiq_login_ref", value)

    @_builtins.property
    @pulumi.getter(name="bigiqPassword")
    def bigiq_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BIGIQ License Manager password.  variable type `string`
        """
        return pulumi.get(self, "bigiq_password")

    @bigiq_password.setter
    def bigiq_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bigiq_password", value)

    @_builtins.property
    @pulumi.getter(name="bigiqPort")
    def bigiq_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type `int`, BIGIQ License Manager Port number, specify if port is other than `443`
        """
        return pulumi.get(self, "bigiq_port")

    @bigiq_port.setter
    def bigiq_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bigiq_port", value)

    @_builtins.property
    @pulumi.getter(name="bigiqTokenAuth")
    def bigiq_token_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        type `bool`, if set to `true` enables Token based Authentication,default is `false`
        """
        return pulumi.get(self, "bigiq_token_auth")

    @bigiq_token_auth.setter
    def bigiq_token_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bigiq_token_auth", value)

    @_builtins.property
    @pulumi.getter(name="bigiqUser")
    def bigiq_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BIGIQ License Manager username, variable type `string`
        """
        return pulumi.get(self, "bigiq_user")

    @bigiq_user.setter
    def bigiq_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bigiq_user", value)

    @_builtins.property
    @pulumi.getter(name="deviceLicenseStatus")
    def device_license_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of Licence Assignment
        """
        return pulumi.get(self, "device_license_status")

    @device_license_status.setter
    def device_license_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device_license_status", value)

    @_builtins.property
    @pulumi.getter
    def hypervisor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the platform running the BIG-IP VE. Possible values: “aws”, “azure”, “gce”, “vmware”, “hyperv”, “kvm”, or “xen”. type `string`
        """
        return pulumi.get(self, "hypervisor")

    @hypervisor.setter
    def hypervisor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hypervisor", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        License Assignment is done with specified `key`, supported only with RegKeypool type License assignement. type `string`
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="licensePoolname")
    def license_poolname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name given to the license pool. type `string`
        """
        return pulumi.get(self, "license_poolname")

    @license_poolname.setter
    def license_poolname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_poolname", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MAC address of the BIG-IP. type `string`
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter
    def skukeyword1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional offering name. type `string`
        """
        return pulumi.get(self, "skukeyword1")

    @skukeyword1.setter
    def skukeyword1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "skukeyword1", value)

    @_builtins.property
    @pulumi.getter
    def skukeyword2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional offering name. type `string`
        """
        return pulumi.get(self, "skukeyword2")

    @skukeyword2.setter
    def skukeyword2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "skukeyword2", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For an unreachable BIG-IP, you can provide an optional description for the assignment in this field.
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter(name="unitOfMeasure")
    def unit_of_measure(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The units used to measure billing. For example, “hourly” or “daily”. Type `string`
        """
        return pulumi.get(self, "unit_of_measure")

    @unit_of_measure.setter
    def unit_of_measure(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_of_measure", value)


@pulumi.type_token("f5bigip:index/commonLicenseManageBigIq:CommonLicenseManageBigIq")
class CommonLicenseManageBigIq(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_address: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_login_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_password: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_port: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_token_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 bigiq_user: Optional[pulumi.Input[_builtins.str]] = None,
                 device_license_status: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 license_poolname: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 skukeyword1: Optional[pulumi.Input[_builtins.str]] = None,
                 skukeyword2: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_of_measure: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        `CommonLicenseManageBigIq` This Resource is used for BIGIP/Provider License Management from BIGIQ

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assignment_type: The type of assignment, which is determined by whether the BIG-IP is unreachable, unmanaged, or managed by BIG-IQ. Possible values: “UNREACHABLE”, “UNMANAGED”, or “MANAGED”.
        :param pulumi.Input[_builtins.str] bigiq_address: BIGIQ License Manager IP Address, variable type `string`
        :param pulumi.Input[_builtins.str] bigiq_login_ref: BIGIQ Login reference for token authentication
        :param pulumi.Input[_builtins.str] bigiq_password: BIGIQ License Manager password.  variable type `string`
        :param pulumi.Input[_builtins.str] bigiq_port: type `int`, BIGIQ License Manager Port number, specify if port is other than `443`
        :param pulumi.Input[_builtins.bool] bigiq_token_auth: type `bool`, if set to `true` enables Token based Authentication,default is `false`
        :param pulumi.Input[_builtins.str] bigiq_user: BIGIQ License Manager username, variable type `string`
        :param pulumi.Input[_builtins.str] device_license_status: Status of Licence Assignment
        :param pulumi.Input[_builtins.str] hypervisor: Identifies the platform running the BIG-IP VE. Possible values: “aws”, “azure”, “gce”, “vmware”, “hyperv”, “kvm”, or “xen”. type `string`
        :param pulumi.Input[_builtins.str] key: License Assignment is done with specified `key`, supported only with RegKeypool type License assignement. type `string`
        :param pulumi.Input[_builtins.str] license_poolname: A name given to the license pool. type `string`
        :param pulumi.Input[_builtins.str] mac_address: MAC address of the BIG-IP. type `string`
        :param pulumi.Input[_builtins.str] skukeyword1: An optional offering name. type `string`
        :param pulumi.Input[_builtins.str] skukeyword2: An optional offering name. type `string`
        :param pulumi.Input[_builtins.str] tenant: For an unreachable BIG-IP, you can provide an optional description for the assignment in this field.
        :param pulumi.Input[_builtins.str] unit_of_measure: The units used to measure billing. For example, “hourly” or “daily”. Type `string`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CommonLicenseManageBigIqArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `CommonLicenseManageBigIq` This Resource is used for BIGIP/Provider License Management from BIGIQ

        :param str resource_name: The name of the resource.
        :param CommonLicenseManageBigIqArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CommonLicenseManageBigIqArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_address: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_login_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_password: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_port: Optional[pulumi.Input[_builtins.str]] = None,
                 bigiq_token_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 bigiq_user: Optional[pulumi.Input[_builtins.str]] = None,
                 device_license_status: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 license_poolname: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 skukeyword1: Optional[pulumi.Input[_builtins.str]] = None,
                 skukeyword2: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_of_measure: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CommonLicenseManageBigIqArgs.__new__(CommonLicenseManageBigIqArgs)

            if assignment_type is None and not opts.urn:
                raise TypeError("Missing required property 'assignment_type'")
            __props__.__dict__["assignment_type"] = assignment_type
            if bigiq_address is None and not opts.urn:
                raise TypeError("Missing required property 'bigiq_address'")
            __props__.__dict__["bigiq_address"] = bigiq_address
            __props__.__dict__["bigiq_login_ref"] = None if bigiq_login_ref is None else pulumi.Output.secret(bigiq_login_ref)
            if bigiq_password is None and not opts.urn:
                raise TypeError("Missing required property 'bigiq_password'")
            __props__.__dict__["bigiq_password"] = None if bigiq_password is None else pulumi.Output.secret(bigiq_password)
            __props__.__dict__["bigiq_port"] = None if bigiq_port is None else pulumi.Output.secret(bigiq_port)
            __props__.__dict__["bigiq_token_auth"] = None if bigiq_token_auth is None else pulumi.Output.secret(bigiq_token_auth)
            if bigiq_user is None and not opts.urn:
                raise TypeError("Missing required property 'bigiq_user'")
            __props__.__dict__["bigiq_user"] = None if bigiq_user is None else pulumi.Output.secret(bigiq_user)
            __props__.__dict__["device_license_status"] = device_license_status
            __props__.__dict__["hypervisor"] = hypervisor
            __props__.__dict__["key"] = key
            if license_poolname is None and not opts.urn:
                raise TypeError("Missing required property 'license_poolname'")
            __props__.__dict__["license_poolname"] = license_poolname
            __props__.__dict__["mac_address"] = mac_address
            __props__.__dict__["skukeyword1"] = skukeyword1
            __props__.__dict__["skukeyword2"] = skukeyword2
            __props__.__dict__["tenant"] = tenant
            __props__.__dict__["unit_of_measure"] = unit_of_measure
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["bigiqLoginRef", "bigiqPassword", "bigiqPort", "bigiqTokenAuth", "bigiqUser"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CommonLicenseManageBigIq, __self__).__init__(
            'f5bigip:index/commonLicenseManageBigIq:CommonLicenseManageBigIq',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assignment_type: Optional[pulumi.Input[_builtins.str]] = None,
            bigiq_address: Optional[pulumi.Input[_builtins.str]] = None,
            bigiq_login_ref: Optional[pulumi.Input[_builtins.str]] = None,
            bigiq_password: Optional[pulumi.Input[_builtins.str]] = None,
            bigiq_port: Optional[pulumi.Input[_builtins.str]] = None,
            bigiq_token_auth: Optional[pulumi.Input[_builtins.bool]] = None,
            bigiq_user: Optional[pulumi.Input[_builtins.str]] = None,
            device_license_status: Optional[pulumi.Input[_builtins.str]] = None,
            hypervisor: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            license_poolname: Optional[pulumi.Input[_builtins.str]] = None,
            mac_address: Optional[pulumi.Input[_builtins.str]] = None,
            skukeyword1: Optional[pulumi.Input[_builtins.str]] = None,
            skukeyword2: Optional[pulumi.Input[_builtins.str]] = None,
            tenant: Optional[pulumi.Input[_builtins.str]] = None,
            unit_of_measure: Optional[pulumi.Input[_builtins.str]] = None) -> 'CommonLicenseManageBigIq':
        """
        Get an existing CommonLicenseManageBigIq resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assignment_type: The type of assignment, which is determined by whether the BIG-IP is unreachable, unmanaged, or managed by BIG-IQ. Possible values: “UNREACHABLE”, “UNMANAGED”, or “MANAGED”.
        :param pulumi.Input[_builtins.str] bigiq_address: BIGIQ License Manager IP Address, variable type `string`
        :param pulumi.Input[_builtins.str] bigiq_login_ref: BIGIQ Login reference for token authentication
        :param pulumi.Input[_builtins.str] bigiq_password: BIGIQ License Manager password.  variable type `string`
        :param pulumi.Input[_builtins.str] bigiq_port: type `int`, BIGIQ License Manager Port number, specify if port is other than `443`
        :param pulumi.Input[_builtins.bool] bigiq_token_auth: type `bool`, if set to `true` enables Token based Authentication,default is `false`
        :param pulumi.Input[_builtins.str] bigiq_user: BIGIQ License Manager username, variable type `string`
        :param pulumi.Input[_builtins.str] device_license_status: Status of Licence Assignment
        :param pulumi.Input[_builtins.str] hypervisor: Identifies the platform running the BIG-IP VE. Possible values: “aws”, “azure”, “gce”, “vmware”, “hyperv”, “kvm”, or “xen”. type `string`
        :param pulumi.Input[_builtins.str] key: License Assignment is done with specified `key`, supported only with RegKeypool type License assignement. type `string`
        :param pulumi.Input[_builtins.str] license_poolname: A name given to the license pool. type `string`
        :param pulumi.Input[_builtins.str] mac_address: MAC address of the BIG-IP. type `string`
        :param pulumi.Input[_builtins.str] skukeyword1: An optional offering name. type `string`
        :param pulumi.Input[_builtins.str] skukeyword2: An optional offering name. type `string`
        :param pulumi.Input[_builtins.str] tenant: For an unreachable BIG-IP, you can provide an optional description for the assignment in this field.
        :param pulumi.Input[_builtins.str] unit_of_measure: The units used to measure billing. For example, “hourly” or “daily”. Type `string`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CommonLicenseManageBigIqState.__new__(_CommonLicenseManageBigIqState)

        __props__.__dict__["assignment_type"] = assignment_type
        __props__.__dict__["bigiq_address"] = bigiq_address
        __props__.__dict__["bigiq_login_ref"] = bigiq_login_ref
        __props__.__dict__["bigiq_password"] = bigiq_password
        __props__.__dict__["bigiq_port"] = bigiq_port
        __props__.__dict__["bigiq_token_auth"] = bigiq_token_auth
        __props__.__dict__["bigiq_user"] = bigiq_user
        __props__.__dict__["device_license_status"] = device_license_status
        __props__.__dict__["hypervisor"] = hypervisor
        __props__.__dict__["key"] = key
        __props__.__dict__["license_poolname"] = license_poolname
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["skukeyword1"] = skukeyword1
        __props__.__dict__["skukeyword2"] = skukeyword2
        __props__.__dict__["tenant"] = tenant
        __props__.__dict__["unit_of_measure"] = unit_of_measure
        return CommonLicenseManageBigIq(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assignmentType")
    def assignment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of assignment, which is determined by whether the BIG-IP is unreachable, unmanaged, or managed by BIG-IQ. Possible values: “UNREACHABLE”, “UNMANAGED”, or “MANAGED”.
        """
        return pulumi.get(self, "assignment_type")

    @_builtins.property
    @pulumi.getter(name="bigiqAddress")
    def bigiq_address(self) -> pulumi.Output[_builtins.str]:
        """
        BIGIQ License Manager IP Address, variable type `string`
        """
        return pulumi.get(self, "bigiq_address")

    @_builtins.property
    @pulumi.getter(name="bigiqLoginRef")
    def bigiq_login_ref(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        BIGIQ Login reference for token authentication
        """
        return pulumi.get(self, "bigiq_login_ref")

    @_builtins.property
    @pulumi.getter(name="bigiqPassword")
    def bigiq_password(self) -> pulumi.Output[_builtins.str]:
        """
        BIGIQ License Manager password.  variable type `string`
        """
        return pulumi.get(self, "bigiq_password")

    @_builtins.property
    @pulumi.getter(name="bigiqPort")
    def bigiq_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        type `int`, BIGIQ License Manager Port number, specify if port is other than `443`
        """
        return pulumi.get(self, "bigiq_port")

    @_builtins.property
    @pulumi.getter(name="bigiqTokenAuth")
    def bigiq_token_auth(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        type `bool`, if set to `true` enables Token based Authentication,default is `false`
        """
        return pulumi.get(self, "bigiq_token_auth")

    @_builtins.property
    @pulumi.getter(name="bigiqUser")
    def bigiq_user(self) -> pulumi.Output[_builtins.str]:
        """
        BIGIQ License Manager username, variable type `string`
        """
        return pulumi.get(self, "bigiq_user")

    @_builtins.property
    @pulumi.getter(name="deviceLicenseStatus")
    def device_license_status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of Licence Assignment
        """
        return pulumi.get(self, "device_license_status")

    @_builtins.property
    @pulumi.getter
    def hypervisor(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identifies the platform running the BIG-IP VE. Possible values: “aws”, “azure”, “gce”, “vmware”, “hyperv”, “kvm”, or “xen”. type `string`
        """
        return pulumi.get(self, "hypervisor")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        License Assignment is done with specified `key`, supported only with RegKeypool type License assignement. type `string`
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="licensePoolname")
    def license_poolname(self) -> pulumi.Output[_builtins.str]:
        """
        A name given to the license pool. type `string`
        """
        return pulumi.get(self, "license_poolname")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        MAC address of the BIG-IP. type `string`
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter
    def skukeyword1(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional offering name. type `string`
        """
        return pulumi.get(self, "skukeyword1")

    @_builtins.property
    @pulumi.getter
    def skukeyword2(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional offering name. type `string`
        """
        return pulumi.get(self, "skukeyword2")

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        For an unreachable BIG-IP, you can provide an optional description for the assignment in this field.
        """
        return pulumi.get(self, "tenant")

    @_builtins.property
    @pulumi.getter(name="unitOfMeasure")
    def unit_of_measure(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The units used to measure billing. For example, “hourly” or “daily”. Type `string`
        """
        return pulumi.get(self, "unit_of_measure")

