# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProfileServerSslArgs', 'ProfileServerSsl']

@pulumi.input_type
class ProfileServerSslArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 alert_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticate: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticate_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 c3d_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 c3d_ca_key: Optional[pulumi.Input[_builtins.str]] = None,
                 c3d_ca_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 c3d_cert_extension_custom_oids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 c3d_cert_extension_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 c3d_cert_lifespan: Optional[pulumi.Input[_builtins.int]] = None,
                 c3d_certificate_extensions: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_file: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 chain: Optional[pulumi.Input[_builtins.str]] = None,
                 cipher_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ciphers: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_cert_response_control: Optional[pulumi.Input[_builtins.str]] = None,
                 full_path: Optional[pulumi.Input[_builtins.str]] = None,
                 generation: Optional[pulumi.Input[_builtins.int]] = None,
                 generic_alert: Optional[pulumi.Input[_builtins.str]] = None,
                 handshake_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 mod_ssl_methods: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_cert_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_ca_key: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_ssl: Optional[pulumi.Input[_builtins.str]] = None,
                 renegotiate_period: Optional[pulumi.Input[_builtins.str]] = None,
                 renegotiate_size: Optional[pulumi.Input[_builtins.str]] = None,
                 renegotiation: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_renegotiation: Optional[pulumi.Input[_builtins.str]] = None,
                 server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 session_mirroring: Optional[pulumi.Input[_builtins.str]] = None,
                 session_ticket: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_default: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_require: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_c3d: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_forward_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_forward_proxy_bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_sign_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 strict_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 tm_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unclean_shutdown: Optional[pulumi.Input[_builtins.str]] = None,
                 untrusted_cert_response_control: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProfileServerSsl resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the profile.Name of Profile should be full path,full path is the combination of the `partition + profile name`. For example `/Common/test-serverssl-profile`.
        :param pulumi.Input[_builtins.str] alert_timeout: Alert time out
        :param pulumi.Input[_builtins.str] authenticate: Specifies the frequency of server authentication for an SSL session.When `once`,specifies that the system authenticates the server once for an SSL session.
               When `always`, specifies that the system authenticates the server once for an SSL session and also upon reuse of that session.
        :param pulumi.Input[_builtins.int] authenticate_depth: Client certificate chain traversal depth.  Default 9.
        :param pulumi.Input[_builtins.str] c3d_ca_cert: Specifies the name of the certificate file that is used as the certification authority certificate when SSL client certificate constrained delegation is enabled. The certificate should be generated and installed by you on the system. When selecting this option, type a certificate file name.
        :param pulumi.Input[_builtins.str] c3d_ca_key: Specifies the name of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. The key should be generated and installed by you on the system. When selecting this option, type a key file name.
               
               * `c3d-ca-passphrase` (Optional) Specifies the passphrase of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. When selecting this option, type the passphrase corresponding to the selected c3d-ca-key.
               
               * `c3d-cert-extension-custom-oids` (Optional) Specifies the custom extension OID of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation.
        :param pulumi.Input[_builtins.str] c3d_ca_passphrase: CA Passphrase. Default
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] c3d_cert_extension_custom_oids: Certificate Extensions List.  Default
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] c3d_cert_extension_includes: Specifies the extensions of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation. For example, { basic-constraints }. The default value is { basic-constraints extended-key-usage key-usage subject-alternative-name }. The extensions are:
               
               basic-constraints
               Basic constraints are used to indicate whether the certificate belongs
               to a CA.
               
               extended-key-usage
               Extended Key Usage is used, typically on a leaf certificate, to
               indicate the purpose of the public key contained in the certificate.
               
               key-usage
               Key Usage provides a bitmap specifying the cryptographic operations
               which may be performed using the public key contained in the
               certificate; for example, it could indicate that the key should be
               used for signature but not for encipherment.
               
               subject-alternative-name
               Subject Alternative Name allows identities to be bound to the subject
               of the certificate. These identities may be included in addition to
               or in place of the identity in the subject field of the certificate.
               
               * `c3d-cert-lifespan` Specifies the lifespan of the certificate generated using the SSL client certificate constrained delegation. The default value is 24.
        :param pulumi.Input[_builtins.int] c3d_cert_lifespan: Certificate Lifespan.  Default
        :param pulumi.Input[_builtins.str] c3d_certificate_extensions: CA Passphrase. Default enabled
        :param pulumi.Input[_builtins.str] ca_file: Client certificate file path.  Default None.
        :param pulumi.Input[_builtins.int] cache_size: Cache size (sessions).
        :param pulumi.Input[_builtins.int] cache_timeout: Cache time out
        :param pulumi.Input[_builtins.str] cert: Specifies the name of the certificate that the system uses for server-side SSL processing.
        :param pulumi.Input[_builtins.str] chain: Specifies the certificates-key chain to associate with the SSL profile
        :param pulumi.Input[_builtins.str] cipher_group: Specifies the cipher group for the SSL server profile. It is mutually exclusive with the argument, `ciphers`. The default value is `none`.
        :param pulumi.Input[_builtins.str] ciphers: Specifies the list of ciphers that the system supports. When creating a new profile, the default cipher list is provided by the parent profile.
        :param pulumi.Input[_builtins.str] defaults_from: The parent template of this monitor template. Once this value has been set, it cannot be changed. By default, this value is `/Common/serverssl`.
        :param pulumi.Input[_builtins.str] expire_cert_response_control: Response if the cert is expired (drop / ignore).
        :param pulumi.Input[_builtins.str] full_path: full path of the profile
        :param pulumi.Input[_builtins.int] generation: generation
        :param pulumi.Input[_builtins.str] generic_alert: Generic alerts enabled / disabled.
        :param pulumi.Input[_builtins.str] handshake_timeout: Handshake time out (seconds)
        :param pulumi.Input[_builtins.str] key: Specifies the file name of the SSL key.
        :param pulumi.Input[_builtins.str] mod_ssl_methods: ModSSL Methods enabled / disabled.  Default is disabled.
        :param pulumi.Input[_builtins.str] mode: ModSSL Methods enabled / disabled.  Default is disabled.
        :param pulumi.Input[_builtins.str] partition: name of partition
        :param pulumi.Input[_builtins.str] passphrase: Client Certificate Constrained Delegation CA passphrase
        :param pulumi.Input[_builtins.str] peer_cert_mode: Specifies the way the system handles client certificates.When ignore, specifies that the system ignores certificates from client systems.When require, specifies that the system requires a client to present a valid certificate.When request, specifies that the system requests a valid certificate from a client but always authenticate the client.
        :param pulumi.Input[_builtins.str] proxy_ca_cert: Proxy CA Cert
        :param pulumi.Input[_builtins.str] proxy_ca_key: Proxy CA Key
        :param pulumi.Input[_builtins.str] proxy_ssl: Proxy SSL enabled / disabled.  Default is disabled.
        :param pulumi.Input[_builtins.str] renegotiate_period: Renogotiate Period (seconds)
        :param pulumi.Input[_builtins.str] renegotiate_size: Renogotiate Size
        :param pulumi.Input[_builtins.str] renegotiation: Enables or disables SSL renegotiation.When creating a new profile, the setting is provided by the parent profile
        :param pulumi.Input[_builtins.str] retain_certificate: When `true`, client certificate is retained in SSL session.
        :param pulumi.Input[_builtins.str] secure_renegotiation: Specifies the method of secure renegotiations for SSL connections. When creating a new profile, the setting is provided by the parent profile.
               When `request` is set the system request secure renegotation of SSL connections.
               `require` is a default setting and when set the system permits initial SSL handshakes from clients but terminates renegotiations from unpatched clients.
               The `require-strict` setting the system requires strict renegotiation of SSL connections. In this mode the system refuses connections to insecure servers, and terminates existing SSL connections to insecure servers
        :param pulumi.Input[_builtins.str] server_name: Specifies the fully qualified DNS hostname of the server used in Server Name Indication communications. When creating a new profile, the setting is provided by the parent profile.The server name can also be a wildcard string containing the asterisk `*` character.
        :param pulumi.Input[_builtins.str] session_mirroring: Session Mirroring (enabled / disabled)
        :param pulumi.Input[_builtins.str] session_ticket: Session Ticket (enabled / disabled)
        :param pulumi.Input[_builtins.str] sni_default: Indicates that the system uses this profile as the default SSL profile when there is no match to the server name, or when the client provides no SNI extension support.When creating a new profile, the setting is provided by the parent profile.
               There can be only one SSL profile with this setting enabled.
        :param pulumi.Input[_builtins.str] sni_require: Requires that the network peers also provide SNI support, this setting only takes effect when `sni_default` is set to `true`.When creating a new profile, the setting is provided by the parent profile
        :param pulumi.Input[_builtins.str] ssl_c3d: Enables or disables SSL forward proxy bypass on receiving
               handshake_failure, protocol_version or unsupported_extension alert message during the serverside SSL handshake. When enabled and there is an SSL handshake_failure, protocol_version or unsupported_extension alert during the serverside SSL handshake, SSL traffic bypasses the BIG-IP system untouched, without decryption/encryption. The default value is disabled. Conversely, you can specify enabled to use this feature.
        :param pulumi.Input[_builtins.str] ssl_forward_proxy: Specifies whether SSL forward proxy feature is enabled or not. The default value is disabled.
        :param pulumi.Input[_builtins.str] ssl_forward_proxy_bypass: Specifies whether SSL forward proxy bypass feature is enabled or not. The default value is disabled.
        :param pulumi.Input[_builtins.str] ssl_sign_hash: SSL sign hash (any, sha1, sha256, sha384)
        :param pulumi.Input[_builtins.str] strict_resume: Enables or disables the resumption of SSL sessions after an unclean shutdown.When creating a new profile, the setting is provided by the parent profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tm_options: List of Enabled selection from a set of industry standard options for handling SSL processing.By default,
               Don't insert empty fragments and No TLSv1.3 are listed as Enabled Options. `Usage` : tm_options    = ["dont-insert-empty-fragments","no-tlsv1.3"]
        :param pulumi.Input[_builtins.str] unclean_shutdown: Unclean Shutdown (enabled / disabled)
        :param pulumi.Input[_builtins.str] untrusted_cert_response_control: Unclean Shutdown (drop / ignore)
        """
        pulumi.set(__self__, "name", name)
        if alert_timeout is not None:
            pulumi.set(__self__, "alert_timeout", alert_timeout)
        if authenticate is not None:
            pulumi.set(__self__, "authenticate", authenticate)
        if authenticate_depth is not None:
            pulumi.set(__self__, "authenticate_depth", authenticate_depth)
        if c3d_ca_cert is not None:
            pulumi.set(__self__, "c3d_ca_cert", c3d_ca_cert)
        if c3d_ca_key is not None:
            pulumi.set(__self__, "c3d_ca_key", c3d_ca_key)
        if c3d_ca_passphrase is not None:
            pulumi.set(__self__, "c3d_ca_passphrase", c3d_ca_passphrase)
        if c3d_cert_extension_custom_oids is not None:
            pulumi.set(__self__, "c3d_cert_extension_custom_oids", c3d_cert_extension_custom_oids)
        if c3d_cert_extension_includes is not None:
            pulumi.set(__self__, "c3d_cert_extension_includes", c3d_cert_extension_includes)
        if c3d_cert_lifespan is not None:
            pulumi.set(__self__, "c3d_cert_lifespan", c3d_cert_lifespan)
        if c3d_certificate_extensions is not None:
            pulumi.set(__self__, "c3d_certificate_extensions", c3d_certificate_extensions)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cache_size is not None:
            pulumi.set(__self__, "cache_size", cache_size)
        if cache_timeout is not None:
            pulumi.set(__self__, "cache_timeout", cache_timeout)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)
        if cipher_group is not None:
            pulumi.set(__self__, "cipher_group", cipher_group)
        if ciphers is not None:
            pulumi.set(__self__, "ciphers", ciphers)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if expire_cert_response_control is not None:
            pulumi.set(__self__, "expire_cert_response_control", expire_cert_response_control)
        if full_path is not None:
            pulumi.set(__self__, "full_path", full_path)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if generic_alert is not None:
            pulumi.set(__self__, "generic_alert", generic_alert)
        if handshake_timeout is not None:
            pulumi.set(__self__, "handshake_timeout", handshake_timeout)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if mod_ssl_methods is not None:
            pulumi.set(__self__, "mod_ssl_methods", mod_ssl_methods)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if peer_cert_mode is not None:
            pulumi.set(__self__, "peer_cert_mode", peer_cert_mode)
        if proxy_ca_cert is not None:
            pulumi.set(__self__, "proxy_ca_cert", proxy_ca_cert)
        if proxy_ca_key is not None:
            pulumi.set(__self__, "proxy_ca_key", proxy_ca_key)
        if proxy_ssl is not None:
            pulumi.set(__self__, "proxy_ssl", proxy_ssl)
        if renegotiate_period is not None:
            pulumi.set(__self__, "renegotiate_period", renegotiate_period)
        if renegotiate_size is not None:
            pulumi.set(__self__, "renegotiate_size", renegotiate_size)
        if renegotiation is not None:
            pulumi.set(__self__, "renegotiation", renegotiation)
        if retain_certificate is not None:
            pulumi.set(__self__, "retain_certificate", retain_certificate)
        if secure_renegotiation is not None:
            pulumi.set(__self__, "secure_renegotiation", secure_renegotiation)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if session_mirroring is not None:
            pulumi.set(__self__, "session_mirroring", session_mirroring)
        if session_ticket is not None:
            pulumi.set(__self__, "session_ticket", session_ticket)
        if sni_default is not None:
            pulumi.set(__self__, "sni_default", sni_default)
        if sni_require is not None:
            pulumi.set(__self__, "sni_require", sni_require)
        if ssl_c3d is not None:
            pulumi.set(__self__, "ssl_c3d", ssl_c3d)
        if ssl_forward_proxy is not None:
            pulumi.set(__self__, "ssl_forward_proxy", ssl_forward_proxy)
        if ssl_forward_proxy_bypass is not None:
            pulumi.set(__self__, "ssl_forward_proxy_bypass", ssl_forward_proxy_bypass)
        if ssl_sign_hash is not None:
            pulumi.set(__self__, "ssl_sign_hash", ssl_sign_hash)
        if strict_resume is not None:
            pulumi.set(__self__, "strict_resume", strict_resume)
        if tm_options is not None:
            pulumi.set(__self__, "tm_options", tm_options)
        if unclean_shutdown is not None:
            pulumi.set(__self__, "unclean_shutdown", unclean_shutdown)
        if untrusted_cert_response_control is not None:
            pulumi.set(__self__, "untrusted_cert_response_control", untrusted_cert_response_control)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the profile.Name of Profile should be full path,full path is the combination of the `partition + profile name`. For example `/Common/test-serverssl-profile`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="alertTimeout")
    def alert_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alert time out
        """
        return pulumi.get(self, "alert_timeout")

    @alert_timeout.setter
    def alert_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_timeout", value)

    @_builtins.property
    @pulumi.getter
    def authenticate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the frequency of server authentication for an SSL session.When `once`,specifies that the system authenticates the server once for an SSL session.
        When `always`, specifies that the system authenticates the server once for an SSL session and also upon reuse of that session.
        """
        return pulumi.get(self, "authenticate")

    @authenticate.setter
    def authenticate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authenticate", value)

    @_builtins.property
    @pulumi.getter(name="authenticateDepth")
    def authenticate_depth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Client certificate chain traversal depth.  Default 9.
        """
        return pulumi.get(self, "authenticate_depth")

    @authenticate_depth.setter
    def authenticate_depth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "authenticate_depth", value)

    @_builtins.property
    @pulumi.getter(name="c3dCaCert")
    def c3d_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the certificate file that is used as the certification authority certificate when SSL client certificate constrained delegation is enabled. The certificate should be generated and installed by you on the system. When selecting this option, type a certificate file name.
        """
        return pulumi.get(self, "c3d_ca_cert")

    @c3d_ca_cert.setter
    def c3d_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "c3d_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="c3dCaKey")
    def c3d_ca_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. The key should be generated and installed by you on the system. When selecting this option, type a key file name.

        * `c3d-ca-passphrase` (Optional) Specifies the passphrase of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. When selecting this option, type the passphrase corresponding to the selected c3d-ca-key.

        * `c3d-cert-extension-custom-oids` (Optional) Specifies the custom extension OID of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation.
        """
        return pulumi.get(self, "c3d_ca_key")

    @c3d_ca_key.setter
    def c3d_ca_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "c3d_ca_key", value)

    @_builtins.property
    @pulumi.getter(name="c3dCaPassphrase")
    def c3d_ca_passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA Passphrase. Default
        """
        return pulumi.get(self, "c3d_ca_passphrase")

    @c3d_ca_passphrase.setter
    def c3d_ca_passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "c3d_ca_passphrase", value)

    @_builtins.property
    @pulumi.getter(name="c3dCertExtensionCustomOids")
    def c3d_cert_extension_custom_oids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Certificate Extensions List.  Default
        """
        return pulumi.get(self, "c3d_cert_extension_custom_oids")

    @c3d_cert_extension_custom_oids.setter
    def c3d_cert_extension_custom_oids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "c3d_cert_extension_custom_oids", value)

    @_builtins.property
    @pulumi.getter(name="c3dCertExtensionIncludes")
    def c3d_cert_extension_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the extensions of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation. For example, { basic-constraints }. The default value is { basic-constraints extended-key-usage key-usage subject-alternative-name }. The extensions are:

        basic-constraints
        Basic constraints are used to indicate whether the certificate belongs
        to a CA.

        extended-key-usage
        Extended Key Usage is used, typically on a leaf certificate, to
        indicate the purpose of the public key contained in the certificate.

        key-usage
        Key Usage provides a bitmap specifying the cryptographic operations
        which may be performed using the public key contained in the
        certificate; for example, it could indicate that the key should be
        used for signature but not for encipherment.

        subject-alternative-name
        Subject Alternative Name allows identities to be bound to the subject
        of the certificate. These identities may be included in addition to
        or in place of the identity in the subject field of the certificate.

        * `c3d-cert-lifespan` Specifies the lifespan of the certificate generated using the SSL client certificate constrained delegation. The default value is 24.
        """
        return pulumi.get(self, "c3d_cert_extension_includes")

    @c3d_cert_extension_includes.setter
    def c3d_cert_extension_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "c3d_cert_extension_includes", value)

    @_builtins.property
    @pulumi.getter(name="c3dCertLifespan")
    def c3d_cert_lifespan(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Certificate Lifespan.  Default
        """
        return pulumi.get(self, "c3d_cert_lifespan")

    @c3d_cert_lifespan.setter
    def c3d_cert_lifespan(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "c3d_cert_lifespan", value)

    @_builtins.property
    @pulumi.getter(name="c3dCertificateExtensions")
    def c3d_certificate_extensions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA Passphrase. Default enabled
        """
        return pulumi.get(self, "c3d_certificate_extensions")

    @c3d_certificate_extensions.setter
    def c3d_certificate_extensions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "c3d_certificate_extensions", value)

    @_builtins.property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate file path.  Default None.
        """
        return pulumi.get(self, "ca_file")

    @ca_file.setter
    def ca_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_file", value)

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cache size (sessions).
        """
        return pulumi.get(self, "cache_size")

    @cache_size.setter
    def cache_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_size", value)

    @_builtins.property
    @pulumi.getter(name="cacheTimeout")
    def cache_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cache time out
        """
        return pulumi.get(self, "cache_timeout")

    @cache_timeout.setter
    def cache_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_timeout", value)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the certificate that the system uses for server-side SSL processing.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter
    def chain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the certificates-key chain to associate with the SSL profile
        """
        return pulumi.get(self, "chain")

    @chain.setter
    def chain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chain", value)

    @_builtins.property
    @pulumi.getter(name="cipherGroup")
    def cipher_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cipher group for the SSL server profile. It is mutually exclusive with the argument, `ciphers`. The default value is `none`.
        """
        return pulumi.get(self, "cipher_group")

    @cipher_group.setter
    def cipher_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cipher_group", value)

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the list of ciphers that the system supports. When creating a new profile, the default cipher list is provided by the parent profile.
        """
        return pulumi.get(self, "ciphers")

    @ciphers.setter
    def ciphers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ciphers", value)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parent template of this monitor template. Once this value has been set, it cannot be changed. By default, this value is `/Common/serverssl`.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter(name="expireCertResponseControl")
    def expire_cert_response_control(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Response if the cert is expired (drop / ignore).
        """
        return pulumi.get(self, "expire_cert_response_control")

    @expire_cert_response_control.setter
    def expire_cert_response_control(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_cert_response_control", value)

    @_builtins.property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        full path of the profile
        """
        return pulumi.get(self, "full_path")

    @full_path.setter
    def full_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "full_path", value)

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        generation
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "generation", value)

    @_builtins.property
    @pulumi.getter(name="genericAlert")
    def generic_alert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generic alerts enabled / disabled.
        """
        return pulumi.get(self, "generic_alert")

    @generic_alert.setter
    def generic_alert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generic_alert", value)

    @_builtins.property
    @pulumi.getter(name="handshakeTimeout")
    def handshake_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Handshake time out (seconds)
        """
        return pulumi.get(self, "handshake_timeout")

    @handshake_timeout.setter
    def handshake_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "handshake_timeout", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file name of the SSL key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="modSslMethods")
    def mod_ssl_methods(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ModSSL Methods enabled / disabled.  Default is disabled.
        """
        return pulumi.get(self, "mod_ssl_methods")

    @mod_ssl_methods.setter
    def mod_ssl_methods(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mod_ssl_methods", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ModSSL Methods enabled / disabled.  Default is disabled.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of partition
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client Certificate Constrained Delegation CA passphrase
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passphrase", value)

    @_builtins.property
    @pulumi.getter(name="peerCertMode")
    def peer_cert_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the way the system handles client certificates.When ignore, specifies that the system ignores certificates from client systems.When require, specifies that the system requires a client to present a valid certificate.When request, specifies that the system requests a valid certificate from a client but always authenticate the client.
        """
        return pulumi.get(self, "peer_cert_mode")

    @peer_cert_mode.setter
    def peer_cert_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_cert_mode", value)

    @_builtins.property
    @pulumi.getter(name="proxyCaCert")
    def proxy_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Proxy CA Cert
        """
        return pulumi.get(self, "proxy_ca_cert")

    @proxy_ca_cert.setter
    def proxy_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="proxyCaKey")
    def proxy_ca_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Proxy CA Key
        """
        return pulumi.get(self, "proxy_ca_key")

    @proxy_ca_key.setter
    def proxy_ca_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_ca_key", value)

    @_builtins.property
    @pulumi.getter(name="proxySsl")
    def proxy_ssl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Proxy SSL enabled / disabled.  Default is disabled.
        """
        return pulumi.get(self, "proxy_ssl")

    @proxy_ssl.setter
    def proxy_ssl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_ssl", value)

    @_builtins.property
    @pulumi.getter(name="renegotiatePeriod")
    def renegotiate_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Renogotiate Period (seconds)
        """
        return pulumi.get(self, "renegotiate_period")

    @renegotiate_period.setter
    def renegotiate_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renegotiate_period", value)

    @_builtins.property
    @pulumi.getter(name="renegotiateSize")
    def renegotiate_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Renogotiate Size
        """
        return pulumi.get(self, "renegotiate_size")

    @renegotiate_size.setter
    def renegotiate_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renegotiate_size", value)

    @_builtins.property
    @pulumi.getter
    def renegotiation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables SSL renegotiation.When creating a new profile, the setting is provided by the parent profile
        """
        return pulumi.get(self, "renegotiation")

    @renegotiation.setter
    def renegotiation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renegotiation", value)

    @_builtins.property
    @pulumi.getter(name="retainCertificate")
    def retain_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When `true`, client certificate is retained in SSL session.
        """
        return pulumi.get(self, "retain_certificate")

    @retain_certificate.setter
    def retain_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retain_certificate", value)

    @_builtins.property
    @pulumi.getter(name="secureRenegotiation")
    def secure_renegotiation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the method of secure renegotiations for SSL connections. When creating a new profile, the setting is provided by the parent profile.
        When `request` is set the system request secure renegotation of SSL connections.
        `require` is a default setting and when set the system permits initial SSL handshakes from clients but terminates renegotiations from unpatched clients.
        The `require-strict` setting the system requires strict renegotiation of SSL connections. In this mode the system refuses connections to insecure servers, and terminates existing SSL connections to insecure servers
        """
        return pulumi.get(self, "secure_renegotiation")

    @secure_renegotiation.setter
    def secure_renegotiation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secure_renegotiation", value)

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the fully qualified DNS hostname of the server used in Server Name Indication communications. When creating a new profile, the setting is provided by the parent profile.The server name can also be a wildcard string containing the asterisk `*` character.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_name", value)

    @_builtins.property
    @pulumi.getter(name="sessionMirroring")
    def session_mirroring(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Session Mirroring (enabled / disabled)
        """
        return pulumi.get(self, "session_mirroring")

    @session_mirroring.setter
    def session_mirroring(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_mirroring", value)

    @_builtins.property
    @pulumi.getter(name="sessionTicket")
    def session_ticket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Session Ticket (enabled / disabled)
        """
        return pulumi.get(self, "session_ticket")

    @session_ticket.setter
    def session_ticket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_ticket", value)

    @_builtins.property
    @pulumi.getter(name="sniDefault")
    def sni_default(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates that the system uses this profile as the default SSL profile when there is no match to the server name, or when the client provides no SNI extension support.When creating a new profile, the setting is provided by the parent profile.
        There can be only one SSL profile with this setting enabled.
        """
        return pulumi.get(self, "sni_default")

    @sni_default.setter
    def sni_default(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sni_default", value)

    @_builtins.property
    @pulumi.getter(name="sniRequire")
    def sni_require(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Requires that the network peers also provide SNI support, this setting only takes effect when `sni_default` is set to `true`.When creating a new profile, the setting is provided by the parent profile
        """
        return pulumi.get(self, "sni_require")

    @sni_require.setter
    def sni_require(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sni_require", value)

    @_builtins.property
    @pulumi.getter(name="sslC3d")
    def ssl_c3d(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables SSL forward proxy bypass on receiving
        handshake_failure, protocol_version or unsupported_extension alert message during the serverside SSL handshake. When enabled and there is an SSL handshake_failure, protocol_version or unsupported_extension alert during the serverside SSL handshake, SSL traffic bypasses the BIG-IP system untouched, without decryption/encryption. The default value is disabled. Conversely, you can specify enabled to use this feature.
        """
        return pulumi.get(self, "ssl_c3d")

    @ssl_c3d.setter
    def ssl_c3d(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_c3d", value)

    @_builtins.property
    @pulumi.getter(name="sslForwardProxy")
    def ssl_forward_proxy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether SSL forward proxy feature is enabled or not. The default value is disabled.
        """
        return pulumi.get(self, "ssl_forward_proxy")

    @ssl_forward_proxy.setter
    def ssl_forward_proxy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_forward_proxy", value)

    @_builtins.property
    @pulumi.getter(name="sslForwardProxyBypass")
    def ssl_forward_proxy_bypass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether SSL forward proxy bypass feature is enabled or not. The default value is disabled.
        """
        return pulumi.get(self, "ssl_forward_proxy_bypass")

    @ssl_forward_proxy_bypass.setter
    def ssl_forward_proxy_bypass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_forward_proxy_bypass", value)

    @_builtins.property
    @pulumi.getter(name="sslSignHash")
    def ssl_sign_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SSL sign hash (any, sha1, sha256, sha384)
        """
        return pulumi.get(self, "ssl_sign_hash")

    @ssl_sign_hash.setter
    def ssl_sign_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_sign_hash", value)

    @_builtins.property
    @pulumi.getter(name="strictResume")
    def strict_resume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables the resumption of SSL sessions after an unclean shutdown.When creating a new profile, the setting is provided by the parent profile.
        """
        return pulumi.get(self, "strict_resume")

    @strict_resume.setter
    def strict_resume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "strict_resume", value)

    @_builtins.property
    @pulumi.getter(name="tmOptions")
    def tm_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Enabled selection from a set of industry standard options for handling SSL processing.By default,
        Don't insert empty fragments and No TLSv1.3 are listed as Enabled Options. `Usage` : tm_options    = ["dont-insert-empty-fragments","no-tlsv1.3"]
        """
        return pulumi.get(self, "tm_options")

    @tm_options.setter
    def tm_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tm_options", value)

    @_builtins.property
    @pulumi.getter(name="uncleanShutdown")
    def unclean_shutdown(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unclean Shutdown (enabled / disabled)
        """
        return pulumi.get(self, "unclean_shutdown")

    @unclean_shutdown.setter
    def unclean_shutdown(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unclean_shutdown", value)

    @_builtins.property
    @pulumi.getter(name="untrustedCertResponseControl")
    def untrusted_cert_response_control(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unclean Shutdown (drop / ignore)
        """
        return pulumi.get(self, "untrusted_cert_response_control")

    @untrusted_cert_response_control.setter
    def untrusted_cert_response_control(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "untrusted_cert_response_control", value)


@pulumi.input_type
class _ProfileServerSslState:
    def __init__(__self__, *,
                 alert_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticate: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticate_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 c3d_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 c3d_ca_key: Optional[pulumi.Input[_builtins.str]] = None,
                 c3d_ca_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 c3d_cert_extension_custom_oids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 c3d_cert_extension_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 c3d_cert_lifespan: Optional[pulumi.Input[_builtins.int]] = None,
                 c3d_certificate_extensions: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_file: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 chain: Optional[pulumi.Input[_builtins.str]] = None,
                 cipher_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ciphers: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_cert_response_control: Optional[pulumi.Input[_builtins.str]] = None,
                 full_path: Optional[pulumi.Input[_builtins.str]] = None,
                 generation: Optional[pulumi.Input[_builtins.int]] = None,
                 generic_alert: Optional[pulumi.Input[_builtins.str]] = None,
                 handshake_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 mod_ssl_methods: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_cert_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_ca_key: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_ssl: Optional[pulumi.Input[_builtins.str]] = None,
                 renegotiate_period: Optional[pulumi.Input[_builtins.str]] = None,
                 renegotiate_size: Optional[pulumi.Input[_builtins.str]] = None,
                 renegotiation: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_renegotiation: Optional[pulumi.Input[_builtins.str]] = None,
                 server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 session_mirroring: Optional[pulumi.Input[_builtins.str]] = None,
                 session_ticket: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_default: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_require: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_c3d: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_forward_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_forward_proxy_bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_sign_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 strict_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 tm_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unclean_shutdown: Optional[pulumi.Input[_builtins.str]] = None,
                 untrusted_cert_response_control: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProfileServerSsl resources.
        :param pulumi.Input[_builtins.str] alert_timeout: Alert time out
        :param pulumi.Input[_builtins.str] authenticate: Specifies the frequency of server authentication for an SSL session.When `once`,specifies that the system authenticates the server once for an SSL session.
               When `always`, specifies that the system authenticates the server once for an SSL session and also upon reuse of that session.
        :param pulumi.Input[_builtins.int] authenticate_depth: Client certificate chain traversal depth.  Default 9.
        :param pulumi.Input[_builtins.str] c3d_ca_cert: Specifies the name of the certificate file that is used as the certification authority certificate when SSL client certificate constrained delegation is enabled. The certificate should be generated and installed by you on the system. When selecting this option, type a certificate file name.
        :param pulumi.Input[_builtins.str] c3d_ca_key: Specifies the name of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. The key should be generated and installed by you on the system. When selecting this option, type a key file name.
               
               * `c3d-ca-passphrase` (Optional) Specifies the passphrase of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. When selecting this option, type the passphrase corresponding to the selected c3d-ca-key.
               
               * `c3d-cert-extension-custom-oids` (Optional) Specifies the custom extension OID of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation.
        :param pulumi.Input[_builtins.str] c3d_ca_passphrase: CA Passphrase. Default
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] c3d_cert_extension_custom_oids: Certificate Extensions List.  Default
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] c3d_cert_extension_includes: Specifies the extensions of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation. For example, { basic-constraints }. The default value is { basic-constraints extended-key-usage key-usage subject-alternative-name }. The extensions are:
               
               basic-constraints
               Basic constraints are used to indicate whether the certificate belongs
               to a CA.
               
               extended-key-usage
               Extended Key Usage is used, typically on a leaf certificate, to
               indicate the purpose of the public key contained in the certificate.
               
               key-usage
               Key Usage provides a bitmap specifying the cryptographic operations
               which may be performed using the public key contained in the
               certificate; for example, it could indicate that the key should be
               used for signature but not for encipherment.
               
               subject-alternative-name
               Subject Alternative Name allows identities to be bound to the subject
               of the certificate. These identities may be included in addition to
               or in place of the identity in the subject field of the certificate.
               
               * `c3d-cert-lifespan` Specifies the lifespan of the certificate generated using the SSL client certificate constrained delegation. The default value is 24.
        :param pulumi.Input[_builtins.int] c3d_cert_lifespan: Certificate Lifespan.  Default
        :param pulumi.Input[_builtins.str] c3d_certificate_extensions: CA Passphrase. Default enabled
        :param pulumi.Input[_builtins.str] ca_file: Client certificate file path.  Default None.
        :param pulumi.Input[_builtins.int] cache_size: Cache size (sessions).
        :param pulumi.Input[_builtins.int] cache_timeout: Cache time out
        :param pulumi.Input[_builtins.str] cert: Specifies the name of the certificate that the system uses for server-side SSL processing.
        :param pulumi.Input[_builtins.str] chain: Specifies the certificates-key chain to associate with the SSL profile
        :param pulumi.Input[_builtins.str] cipher_group: Specifies the cipher group for the SSL server profile. It is mutually exclusive with the argument, `ciphers`. The default value is `none`.
        :param pulumi.Input[_builtins.str] ciphers: Specifies the list of ciphers that the system supports. When creating a new profile, the default cipher list is provided by the parent profile.
        :param pulumi.Input[_builtins.str] defaults_from: The parent template of this monitor template. Once this value has been set, it cannot be changed. By default, this value is `/Common/serverssl`.
        :param pulumi.Input[_builtins.str] expire_cert_response_control: Response if the cert is expired (drop / ignore).
        :param pulumi.Input[_builtins.str] full_path: full path of the profile
        :param pulumi.Input[_builtins.int] generation: generation
        :param pulumi.Input[_builtins.str] generic_alert: Generic alerts enabled / disabled.
        :param pulumi.Input[_builtins.str] handshake_timeout: Handshake time out (seconds)
        :param pulumi.Input[_builtins.str] key: Specifies the file name of the SSL key.
        :param pulumi.Input[_builtins.str] mod_ssl_methods: ModSSL Methods enabled / disabled.  Default is disabled.
        :param pulumi.Input[_builtins.str] mode: ModSSL Methods enabled / disabled.  Default is disabled.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the profile.Name of Profile should be full path,full path is the combination of the `partition + profile name`. For example `/Common/test-serverssl-profile`.
        :param pulumi.Input[_builtins.str] partition: name of partition
        :param pulumi.Input[_builtins.str] passphrase: Client Certificate Constrained Delegation CA passphrase
        :param pulumi.Input[_builtins.str] peer_cert_mode: Specifies the way the system handles client certificates.When ignore, specifies that the system ignores certificates from client systems.When require, specifies that the system requires a client to present a valid certificate.When request, specifies that the system requests a valid certificate from a client but always authenticate the client.
        :param pulumi.Input[_builtins.str] proxy_ca_cert: Proxy CA Cert
        :param pulumi.Input[_builtins.str] proxy_ca_key: Proxy CA Key
        :param pulumi.Input[_builtins.str] proxy_ssl: Proxy SSL enabled / disabled.  Default is disabled.
        :param pulumi.Input[_builtins.str] renegotiate_period: Renogotiate Period (seconds)
        :param pulumi.Input[_builtins.str] renegotiate_size: Renogotiate Size
        :param pulumi.Input[_builtins.str] renegotiation: Enables or disables SSL renegotiation.When creating a new profile, the setting is provided by the parent profile
        :param pulumi.Input[_builtins.str] retain_certificate: When `true`, client certificate is retained in SSL session.
        :param pulumi.Input[_builtins.str] secure_renegotiation: Specifies the method of secure renegotiations for SSL connections. When creating a new profile, the setting is provided by the parent profile.
               When `request` is set the system request secure renegotation of SSL connections.
               `require` is a default setting and when set the system permits initial SSL handshakes from clients but terminates renegotiations from unpatched clients.
               The `require-strict` setting the system requires strict renegotiation of SSL connections. In this mode the system refuses connections to insecure servers, and terminates existing SSL connections to insecure servers
        :param pulumi.Input[_builtins.str] server_name: Specifies the fully qualified DNS hostname of the server used in Server Name Indication communications. When creating a new profile, the setting is provided by the parent profile.The server name can also be a wildcard string containing the asterisk `*` character.
        :param pulumi.Input[_builtins.str] session_mirroring: Session Mirroring (enabled / disabled)
        :param pulumi.Input[_builtins.str] session_ticket: Session Ticket (enabled / disabled)
        :param pulumi.Input[_builtins.str] sni_default: Indicates that the system uses this profile as the default SSL profile when there is no match to the server name, or when the client provides no SNI extension support.When creating a new profile, the setting is provided by the parent profile.
               There can be only one SSL profile with this setting enabled.
        :param pulumi.Input[_builtins.str] sni_require: Requires that the network peers also provide SNI support, this setting only takes effect when `sni_default` is set to `true`.When creating a new profile, the setting is provided by the parent profile
        :param pulumi.Input[_builtins.str] ssl_c3d: Enables or disables SSL forward proxy bypass on receiving
               handshake_failure, protocol_version or unsupported_extension alert message during the serverside SSL handshake. When enabled and there is an SSL handshake_failure, protocol_version or unsupported_extension alert during the serverside SSL handshake, SSL traffic bypasses the BIG-IP system untouched, without decryption/encryption. The default value is disabled. Conversely, you can specify enabled to use this feature.
        :param pulumi.Input[_builtins.str] ssl_forward_proxy: Specifies whether SSL forward proxy feature is enabled or not. The default value is disabled.
        :param pulumi.Input[_builtins.str] ssl_forward_proxy_bypass: Specifies whether SSL forward proxy bypass feature is enabled or not. The default value is disabled.
        :param pulumi.Input[_builtins.str] ssl_sign_hash: SSL sign hash (any, sha1, sha256, sha384)
        :param pulumi.Input[_builtins.str] strict_resume: Enables or disables the resumption of SSL sessions after an unclean shutdown.When creating a new profile, the setting is provided by the parent profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tm_options: List of Enabled selection from a set of industry standard options for handling SSL processing.By default,
               Don't insert empty fragments and No TLSv1.3 are listed as Enabled Options. `Usage` : tm_options    = ["dont-insert-empty-fragments","no-tlsv1.3"]
        :param pulumi.Input[_builtins.str] unclean_shutdown: Unclean Shutdown (enabled / disabled)
        :param pulumi.Input[_builtins.str] untrusted_cert_response_control: Unclean Shutdown (drop / ignore)
        """
        if alert_timeout is not None:
            pulumi.set(__self__, "alert_timeout", alert_timeout)
        if authenticate is not None:
            pulumi.set(__self__, "authenticate", authenticate)
        if authenticate_depth is not None:
            pulumi.set(__self__, "authenticate_depth", authenticate_depth)
        if c3d_ca_cert is not None:
            pulumi.set(__self__, "c3d_ca_cert", c3d_ca_cert)
        if c3d_ca_key is not None:
            pulumi.set(__self__, "c3d_ca_key", c3d_ca_key)
        if c3d_ca_passphrase is not None:
            pulumi.set(__self__, "c3d_ca_passphrase", c3d_ca_passphrase)
        if c3d_cert_extension_custom_oids is not None:
            pulumi.set(__self__, "c3d_cert_extension_custom_oids", c3d_cert_extension_custom_oids)
        if c3d_cert_extension_includes is not None:
            pulumi.set(__self__, "c3d_cert_extension_includes", c3d_cert_extension_includes)
        if c3d_cert_lifespan is not None:
            pulumi.set(__self__, "c3d_cert_lifespan", c3d_cert_lifespan)
        if c3d_certificate_extensions is not None:
            pulumi.set(__self__, "c3d_certificate_extensions", c3d_certificate_extensions)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cache_size is not None:
            pulumi.set(__self__, "cache_size", cache_size)
        if cache_timeout is not None:
            pulumi.set(__self__, "cache_timeout", cache_timeout)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)
        if cipher_group is not None:
            pulumi.set(__self__, "cipher_group", cipher_group)
        if ciphers is not None:
            pulumi.set(__self__, "ciphers", ciphers)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if expire_cert_response_control is not None:
            pulumi.set(__self__, "expire_cert_response_control", expire_cert_response_control)
        if full_path is not None:
            pulumi.set(__self__, "full_path", full_path)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if generic_alert is not None:
            pulumi.set(__self__, "generic_alert", generic_alert)
        if handshake_timeout is not None:
            pulumi.set(__self__, "handshake_timeout", handshake_timeout)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if mod_ssl_methods is not None:
            pulumi.set(__self__, "mod_ssl_methods", mod_ssl_methods)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if peer_cert_mode is not None:
            pulumi.set(__self__, "peer_cert_mode", peer_cert_mode)
        if proxy_ca_cert is not None:
            pulumi.set(__self__, "proxy_ca_cert", proxy_ca_cert)
        if proxy_ca_key is not None:
            pulumi.set(__self__, "proxy_ca_key", proxy_ca_key)
        if proxy_ssl is not None:
            pulumi.set(__self__, "proxy_ssl", proxy_ssl)
        if renegotiate_period is not None:
            pulumi.set(__self__, "renegotiate_period", renegotiate_period)
        if renegotiate_size is not None:
            pulumi.set(__self__, "renegotiate_size", renegotiate_size)
        if renegotiation is not None:
            pulumi.set(__self__, "renegotiation", renegotiation)
        if retain_certificate is not None:
            pulumi.set(__self__, "retain_certificate", retain_certificate)
        if secure_renegotiation is not None:
            pulumi.set(__self__, "secure_renegotiation", secure_renegotiation)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if session_mirroring is not None:
            pulumi.set(__self__, "session_mirroring", session_mirroring)
        if session_ticket is not None:
            pulumi.set(__self__, "session_ticket", session_ticket)
        if sni_default is not None:
            pulumi.set(__self__, "sni_default", sni_default)
        if sni_require is not None:
            pulumi.set(__self__, "sni_require", sni_require)
        if ssl_c3d is not None:
            pulumi.set(__self__, "ssl_c3d", ssl_c3d)
        if ssl_forward_proxy is not None:
            pulumi.set(__self__, "ssl_forward_proxy", ssl_forward_proxy)
        if ssl_forward_proxy_bypass is not None:
            pulumi.set(__self__, "ssl_forward_proxy_bypass", ssl_forward_proxy_bypass)
        if ssl_sign_hash is not None:
            pulumi.set(__self__, "ssl_sign_hash", ssl_sign_hash)
        if strict_resume is not None:
            pulumi.set(__self__, "strict_resume", strict_resume)
        if tm_options is not None:
            pulumi.set(__self__, "tm_options", tm_options)
        if unclean_shutdown is not None:
            pulumi.set(__self__, "unclean_shutdown", unclean_shutdown)
        if untrusted_cert_response_control is not None:
            pulumi.set(__self__, "untrusted_cert_response_control", untrusted_cert_response_control)

    @_builtins.property
    @pulumi.getter(name="alertTimeout")
    def alert_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alert time out
        """
        return pulumi.get(self, "alert_timeout")

    @alert_timeout.setter
    def alert_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_timeout", value)

    @_builtins.property
    @pulumi.getter
    def authenticate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the frequency of server authentication for an SSL session.When `once`,specifies that the system authenticates the server once for an SSL session.
        When `always`, specifies that the system authenticates the server once for an SSL session and also upon reuse of that session.
        """
        return pulumi.get(self, "authenticate")

    @authenticate.setter
    def authenticate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authenticate", value)

    @_builtins.property
    @pulumi.getter(name="authenticateDepth")
    def authenticate_depth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Client certificate chain traversal depth.  Default 9.
        """
        return pulumi.get(self, "authenticate_depth")

    @authenticate_depth.setter
    def authenticate_depth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "authenticate_depth", value)

    @_builtins.property
    @pulumi.getter(name="c3dCaCert")
    def c3d_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the certificate file that is used as the certification authority certificate when SSL client certificate constrained delegation is enabled. The certificate should be generated and installed by you on the system. When selecting this option, type a certificate file name.
        """
        return pulumi.get(self, "c3d_ca_cert")

    @c3d_ca_cert.setter
    def c3d_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "c3d_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="c3dCaKey")
    def c3d_ca_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. The key should be generated and installed by you on the system. When selecting this option, type a key file name.

        * `c3d-ca-passphrase` (Optional) Specifies the passphrase of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. When selecting this option, type the passphrase corresponding to the selected c3d-ca-key.

        * `c3d-cert-extension-custom-oids` (Optional) Specifies the custom extension OID of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation.
        """
        return pulumi.get(self, "c3d_ca_key")

    @c3d_ca_key.setter
    def c3d_ca_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "c3d_ca_key", value)

    @_builtins.property
    @pulumi.getter(name="c3dCaPassphrase")
    def c3d_ca_passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA Passphrase. Default
        """
        return pulumi.get(self, "c3d_ca_passphrase")

    @c3d_ca_passphrase.setter
    def c3d_ca_passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "c3d_ca_passphrase", value)

    @_builtins.property
    @pulumi.getter(name="c3dCertExtensionCustomOids")
    def c3d_cert_extension_custom_oids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Certificate Extensions List.  Default
        """
        return pulumi.get(self, "c3d_cert_extension_custom_oids")

    @c3d_cert_extension_custom_oids.setter
    def c3d_cert_extension_custom_oids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "c3d_cert_extension_custom_oids", value)

    @_builtins.property
    @pulumi.getter(name="c3dCertExtensionIncludes")
    def c3d_cert_extension_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the extensions of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation. For example, { basic-constraints }. The default value is { basic-constraints extended-key-usage key-usage subject-alternative-name }. The extensions are:

        basic-constraints
        Basic constraints are used to indicate whether the certificate belongs
        to a CA.

        extended-key-usage
        Extended Key Usage is used, typically on a leaf certificate, to
        indicate the purpose of the public key contained in the certificate.

        key-usage
        Key Usage provides a bitmap specifying the cryptographic operations
        which may be performed using the public key contained in the
        certificate; for example, it could indicate that the key should be
        used for signature but not for encipherment.

        subject-alternative-name
        Subject Alternative Name allows identities to be bound to the subject
        of the certificate. These identities may be included in addition to
        or in place of the identity in the subject field of the certificate.

        * `c3d-cert-lifespan` Specifies the lifespan of the certificate generated using the SSL client certificate constrained delegation. The default value is 24.
        """
        return pulumi.get(self, "c3d_cert_extension_includes")

    @c3d_cert_extension_includes.setter
    def c3d_cert_extension_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "c3d_cert_extension_includes", value)

    @_builtins.property
    @pulumi.getter(name="c3dCertLifespan")
    def c3d_cert_lifespan(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Certificate Lifespan.  Default
        """
        return pulumi.get(self, "c3d_cert_lifespan")

    @c3d_cert_lifespan.setter
    def c3d_cert_lifespan(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "c3d_cert_lifespan", value)

    @_builtins.property
    @pulumi.getter(name="c3dCertificateExtensions")
    def c3d_certificate_extensions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA Passphrase. Default enabled
        """
        return pulumi.get(self, "c3d_certificate_extensions")

    @c3d_certificate_extensions.setter
    def c3d_certificate_extensions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "c3d_certificate_extensions", value)

    @_builtins.property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate file path.  Default None.
        """
        return pulumi.get(self, "ca_file")

    @ca_file.setter
    def ca_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_file", value)

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cache size (sessions).
        """
        return pulumi.get(self, "cache_size")

    @cache_size.setter
    def cache_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_size", value)

    @_builtins.property
    @pulumi.getter(name="cacheTimeout")
    def cache_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cache time out
        """
        return pulumi.get(self, "cache_timeout")

    @cache_timeout.setter
    def cache_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_timeout", value)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the certificate that the system uses for server-side SSL processing.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter
    def chain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the certificates-key chain to associate with the SSL profile
        """
        return pulumi.get(self, "chain")

    @chain.setter
    def chain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chain", value)

    @_builtins.property
    @pulumi.getter(name="cipherGroup")
    def cipher_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cipher group for the SSL server profile. It is mutually exclusive with the argument, `ciphers`. The default value is `none`.
        """
        return pulumi.get(self, "cipher_group")

    @cipher_group.setter
    def cipher_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cipher_group", value)

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the list of ciphers that the system supports. When creating a new profile, the default cipher list is provided by the parent profile.
        """
        return pulumi.get(self, "ciphers")

    @ciphers.setter
    def ciphers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ciphers", value)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parent template of this monitor template. Once this value has been set, it cannot be changed. By default, this value is `/Common/serverssl`.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter(name="expireCertResponseControl")
    def expire_cert_response_control(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Response if the cert is expired (drop / ignore).
        """
        return pulumi.get(self, "expire_cert_response_control")

    @expire_cert_response_control.setter
    def expire_cert_response_control(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_cert_response_control", value)

    @_builtins.property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        full path of the profile
        """
        return pulumi.get(self, "full_path")

    @full_path.setter
    def full_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "full_path", value)

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        generation
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "generation", value)

    @_builtins.property
    @pulumi.getter(name="genericAlert")
    def generic_alert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generic alerts enabled / disabled.
        """
        return pulumi.get(self, "generic_alert")

    @generic_alert.setter
    def generic_alert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generic_alert", value)

    @_builtins.property
    @pulumi.getter(name="handshakeTimeout")
    def handshake_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Handshake time out (seconds)
        """
        return pulumi.get(self, "handshake_timeout")

    @handshake_timeout.setter
    def handshake_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "handshake_timeout", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file name of the SSL key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="modSslMethods")
    def mod_ssl_methods(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ModSSL Methods enabled / disabled.  Default is disabled.
        """
        return pulumi.get(self, "mod_ssl_methods")

    @mod_ssl_methods.setter
    def mod_ssl_methods(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mod_ssl_methods", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ModSSL Methods enabled / disabled.  Default is disabled.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the profile.Name of Profile should be full path,full path is the combination of the `partition + profile name`. For example `/Common/test-serverssl-profile`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of partition
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client Certificate Constrained Delegation CA passphrase
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passphrase", value)

    @_builtins.property
    @pulumi.getter(name="peerCertMode")
    def peer_cert_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the way the system handles client certificates.When ignore, specifies that the system ignores certificates from client systems.When require, specifies that the system requires a client to present a valid certificate.When request, specifies that the system requests a valid certificate from a client but always authenticate the client.
        """
        return pulumi.get(self, "peer_cert_mode")

    @peer_cert_mode.setter
    def peer_cert_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_cert_mode", value)

    @_builtins.property
    @pulumi.getter(name="proxyCaCert")
    def proxy_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Proxy CA Cert
        """
        return pulumi.get(self, "proxy_ca_cert")

    @proxy_ca_cert.setter
    def proxy_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="proxyCaKey")
    def proxy_ca_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Proxy CA Key
        """
        return pulumi.get(self, "proxy_ca_key")

    @proxy_ca_key.setter
    def proxy_ca_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_ca_key", value)

    @_builtins.property
    @pulumi.getter(name="proxySsl")
    def proxy_ssl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Proxy SSL enabled / disabled.  Default is disabled.
        """
        return pulumi.get(self, "proxy_ssl")

    @proxy_ssl.setter
    def proxy_ssl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_ssl", value)

    @_builtins.property
    @pulumi.getter(name="renegotiatePeriod")
    def renegotiate_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Renogotiate Period (seconds)
        """
        return pulumi.get(self, "renegotiate_period")

    @renegotiate_period.setter
    def renegotiate_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renegotiate_period", value)

    @_builtins.property
    @pulumi.getter(name="renegotiateSize")
    def renegotiate_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Renogotiate Size
        """
        return pulumi.get(self, "renegotiate_size")

    @renegotiate_size.setter
    def renegotiate_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renegotiate_size", value)

    @_builtins.property
    @pulumi.getter
    def renegotiation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables SSL renegotiation.When creating a new profile, the setting is provided by the parent profile
        """
        return pulumi.get(self, "renegotiation")

    @renegotiation.setter
    def renegotiation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renegotiation", value)

    @_builtins.property
    @pulumi.getter(name="retainCertificate")
    def retain_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When `true`, client certificate is retained in SSL session.
        """
        return pulumi.get(self, "retain_certificate")

    @retain_certificate.setter
    def retain_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retain_certificate", value)

    @_builtins.property
    @pulumi.getter(name="secureRenegotiation")
    def secure_renegotiation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the method of secure renegotiations for SSL connections. When creating a new profile, the setting is provided by the parent profile.
        When `request` is set the system request secure renegotation of SSL connections.
        `require` is a default setting and when set the system permits initial SSL handshakes from clients but terminates renegotiations from unpatched clients.
        The `require-strict` setting the system requires strict renegotiation of SSL connections. In this mode the system refuses connections to insecure servers, and terminates existing SSL connections to insecure servers
        """
        return pulumi.get(self, "secure_renegotiation")

    @secure_renegotiation.setter
    def secure_renegotiation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secure_renegotiation", value)

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the fully qualified DNS hostname of the server used in Server Name Indication communications. When creating a new profile, the setting is provided by the parent profile.The server name can also be a wildcard string containing the asterisk `*` character.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_name", value)

    @_builtins.property
    @pulumi.getter(name="sessionMirroring")
    def session_mirroring(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Session Mirroring (enabled / disabled)
        """
        return pulumi.get(self, "session_mirroring")

    @session_mirroring.setter
    def session_mirroring(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_mirroring", value)

    @_builtins.property
    @pulumi.getter(name="sessionTicket")
    def session_ticket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Session Ticket (enabled / disabled)
        """
        return pulumi.get(self, "session_ticket")

    @session_ticket.setter
    def session_ticket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_ticket", value)

    @_builtins.property
    @pulumi.getter(name="sniDefault")
    def sni_default(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates that the system uses this profile as the default SSL profile when there is no match to the server name, or when the client provides no SNI extension support.When creating a new profile, the setting is provided by the parent profile.
        There can be only one SSL profile with this setting enabled.
        """
        return pulumi.get(self, "sni_default")

    @sni_default.setter
    def sni_default(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sni_default", value)

    @_builtins.property
    @pulumi.getter(name="sniRequire")
    def sni_require(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Requires that the network peers also provide SNI support, this setting only takes effect when `sni_default` is set to `true`.When creating a new profile, the setting is provided by the parent profile
        """
        return pulumi.get(self, "sni_require")

    @sni_require.setter
    def sni_require(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sni_require", value)

    @_builtins.property
    @pulumi.getter(name="sslC3d")
    def ssl_c3d(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables SSL forward proxy bypass on receiving
        handshake_failure, protocol_version or unsupported_extension alert message during the serverside SSL handshake. When enabled and there is an SSL handshake_failure, protocol_version or unsupported_extension alert during the serverside SSL handshake, SSL traffic bypasses the BIG-IP system untouched, without decryption/encryption. The default value is disabled. Conversely, you can specify enabled to use this feature.
        """
        return pulumi.get(self, "ssl_c3d")

    @ssl_c3d.setter
    def ssl_c3d(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_c3d", value)

    @_builtins.property
    @pulumi.getter(name="sslForwardProxy")
    def ssl_forward_proxy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether SSL forward proxy feature is enabled or not. The default value is disabled.
        """
        return pulumi.get(self, "ssl_forward_proxy")

    @ssl_forward_proxy.setter
    def ssl_forward_proxy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_forward_proxy", value)

    @_builtins.property
    @pulumi.getter(name="sslForwardProxyBypass")
    def ssl_forward_proxy_bypass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether SSL forward proxy bypass feature is enabled or not. The default value is disabled.
        """
        return pulumi.get(self, "ssl_forward_proxy_bypass")

    @ssl_forward_proxy_bypass.setter
    def ssl_forward_proxy_bypass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_forward_proxy_bypass", value)

    @_builtins.property
    @pulumi.getter(name="sslSignHash")
    def ssl_sign_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SSL sign hash (any, sha1, sha256, sha384)
        """
        return pulumi.get(self, "ssl_sign_hash")

    @ssl_sign_hash.setter
    def ssl_sign_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_sign_hash", value)

    @_builtins.property
    @pulumi.getter(name="strictResume")
    def strict_resume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables the resumption of SSL sessions after an unclean shutdown.When creating a new profile, the setting is provided by the parent profile.
        """
        return pulumi.get(self, "strict_resume")

    @strict_resume.setter
    def strict_resume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "strict_resume", value)

    @_builtins.property
    @pulumi.getter(name="tmOptions")
    def tm_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Enabled selection from a set of industry standard options for handling SSL processing.By default,
        Don't insert empty fragments and No TLSv1.3 are listed as Enabled Options. `Usage` : tm_options    = ["dont-insert-empty-fragments","no-tlsv1.3"]
        """
        return pulumi.get(self, "tm_options")

    @tm_options.setter
    def tm_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tm_options", value)

    @_builtins.property
    @pulumi.getter(name="uncleanShutdown")
    def unclean_shutdown(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unclean Shutdown (enabled / disabled)
        """
        return pulumi.get(self, "unclean_shutdown")

    @unclean_shutdown.setter
    def unclean_shutdown(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unclean_shutdown", value)

    @_builtins.property
    @pulumi.getter(name="untrustedCertResponseControl")
    def untrusted_cert_response_control(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unclean Shutdown (drop / ignore)
        """
        return pulumi.get(self, "untrusted_cert_response_control")

    @untrusted_cert_response_control.setter
    def untrusted_cert_response_control(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "untrusted_cert_response_control", value)


@pulumi.type_token("f5bigip:ltm/profileServerSsl:ProfileServerSsl")
class ProfileServerSsl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticate: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticate_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 c3d_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 c3d_ca_key: Optional[pulumi.Input[_builtins.str]] = None,
                 c3d_ca_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 c3d_cert_extension_custom_oids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 c3d_cert_extension_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 c3d_cert_lifespan: Optional[pulumi.Input[_builtins.int]] = None,
                 c3d_certificate_extensions: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_file: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 chain: Optional[pulumi.Input[_builtins.str]] = None,
                 cipher_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ciphers: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_cert_response_control: Optional[pulumi.Input[_builtins.str]] = None,
                 full_path: Optional[pulumi.Input[_builtins.str]] = None,
                 generation: Optional[pulumi.Input[_builtins.int]] = None,
                 generic_alert: Optional[pulumi.Input[_builtins.str]] = None,
                 handshake_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 mod_ssl_methods: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_cert_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_ca_key: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_ssl: Optional[pulumi.Input[_builtins.str]] = None,
                 renegotiate_period: Optional[pulumi.Input[_builtins.str]] = None,
                 renegotiate_size: Optional[pulumi.Input[_builtins.str]] = None,
                 renegotiation: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_renegotiation: Optional[pulumi.Input[_builtins.str]] = None,
                 server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 session_mirroring: Optional[pulumi.Input[_builtins.str]] = None,
                 session_ticket: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_default: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_require: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_c3d: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_forward_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_forward_proxy_bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_sign_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 strict_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 tm_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unclean_shutdown: Optional[pulumi.Input[_builtins.str]] = None,
                 untrusted_cert_response_control: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        `ltm.ProfileServerSsl` Manages server SSL profiles on a BIG-IP

        Resources should be named with their "full path". The full path is the combination of the partition + name (example: /Common/my-pool ) or  partition + directory + name of the resource  (example: /Common/test/my-pool )

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        test__server_ssl = f5bigip.ltm.ProfileServerSsl("test-ServerSsl",
            name="/Common/test-ServerSsl",
            defaults_from="/Common/serverssl",
            authenticate="always",
            ciphers="DEFAULT")
        ```

        ## Importing

        An existing server-ssl profile can be imported into this resource by supplying server-ssl profile Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_profile_server_ssl.test-ServerSsl-import /Common/test-ServerSsl

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alert_timeout: Alert time out
        :param pulumi.Input[_builtins.str] authenticate: Specifies the frequency of server authentication for an SSL session.When `once`,specifies that the system authenticates the server once for an SSL session.
               When `always`, specifies that the system authenticates the server once for an SSL session and also upon reuse of that session.
        :param pulumi.Input[_builtins.int] authenticate_depth: Client certificate chain traversal depth.  Default 9.
        :param pulumi.Input[_builtins.str] c3d_ca_cert: Specifies the name of the certificate file that is used as the certification authority certificate when SSL client certificate constrained delegation is enabled. The certificate should be generated and installed by you on the system. When selecting this option, type a certificate file name.
        :param pulumi.Input[_builtins.str] c3d_ca_key: Specifies the name of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. The key should be generated and installed by you on the system. When selecting this option, type a key file name.
               
               * `c3d-ca-passphrase` (Optional) Specifies the passphrase of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. When selecting this option, type the passphrase corresponding to the selected c3d-ca-key.
               
               * `c3d-cert-extension-custom-oids` (Optional) Specifies the custom extension OID of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation.
        :param pulumi.Input[_builtins.str] c3d_ca_passphrase: CA Passphrase. Default
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] c3d_cert_extension_custom_oids: Certificate Extensions List.  Default
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] c3d_cert_extension_includes: Specifies the extensions of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation. For example, { basic-constraints }. The default value is { basic-constraints extended-key-usage key-usage subject-alternative-name }. The extensions are:
               
               basic-constraints
               Basic constraints are used to indicate whether the certificate belongs
               to a CA.
               
               extended-key-usage
               Extended Key Usage is used, typically on a leaf certificate, to
               indicate the purpose of the public key contained in the certificate.
               
               key-usage
               Key Usage provides a bitmap specifying the cryptographic operations
               which may be performed using the public key contained in the
               certificate; for example, it could indicate that the key should be
               used for signature but not for encipherment.
               
               subject-alternative-name
               Subject Alternative Name allows identities to be bound to the subject
               of the certificate. These identities may be included in addition to
               or in place of the identity in the subject field of the certificate.
               
               * `c3d-cert-lifespan` Specifies the lifespan of the certificate generated using the SSL client certificate constrained delegation. The default value is 24.
        :param pulumi.Input[_builtins.int] c3d_cert_lifespan: Certificate Lifespan.  Default
        :param pulumi.Input[_builtins.str] c3d_certificate_extensions: CA Passphrase. Default enabled
        :param pulumi.Input[_builtins.str] ca_file: Client certificate file path.  Default None.
        :param pulumi.Input[_builtins.int] cache_size: Cache size (sessions).
        :param pulumi.Input[_builtins.int] cache_timeout: Cache time out
        :param pulumi.Input[_builtins.str] cert: Specifies the name of the certificate that the system uses for server-side SSL processing.
        :param pulumi.Input[_builtins.str] chain: Specifies the certificates-key chain to associate with the SSL profile
        :param pulumi.Input[_builtins.str] cipher_group: Specifies the cipher group for the SSL server profile. It is mutually exclusive with the argument, `ciphers`. The default value is `none`.
        :param pulumi.Input[_builtins.str] ciphers: Specifies the list of ciphers that the system supports. When creating a new profile, the default cipher list is provided by the parent profile.
        :param pulumi.Input[_builtins.str] defaults_from: The parent template of this monitor template. Once this value has been set, it cannot be changed. By default, this value is `/Common/serverssl`.
        :param pulumi.Input[_builtins.str] expire_cert_response_control: Response if the cert is expired (drop / ignore).
        :param pulumi.Input[_builtins.str] full_path: full path of the profile
        :param pulumi.Input[_builtins.int] generation: generation
        :param pulumi.Input[_builtins.str] generic_alert: Generic alerts enabled / disabled.
        :param pulumi.Input[_builtins.str] handshake_timeout: Handshake time out (seconds)
        :param pulumi.Input[_builtins.str] key: Specifies the file name of the SSL key.
        :param pulumi.Input[_builtins.str] mod_ssl_methods: ModSSL Methods enabled / disabled.  Default is disabled.
        :param pulumi.Input[_builtins.str] mode: ModSSL Methods enabled / disabled.  Default is disabled.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the profile.Name of Profile should be full path,full path is the combination of the `partition + profile name`. For example `/Common/test-serverssl-profile`.
        :param pulumi.Input[_builtins.str] partition: name of partition
        :param pulumi.Input[_builtins.str] passphrase: Client Certificate Constrained Delegation CA passphrase
        :param pulumi.Input[_builtins.str] peer_cert_mode: Specifies the way the system handles client certificates.When ignore, specifies that the system ignores certificates from client systems.When require, specifies that the system requires a client to present a valid certificate.When request, specifies that the system requests a valid certificate from a client but always authenticate the client.
        :param pulumi.Input[_builtins.str] proxy_ca_cert: Proxy CA Cert
        :param pulumi.Input[_builtins.str] proxy_ca_key: Proxy CA Key
        :param pulumi.Input[_builtins.str] proxy_ssl: Proxy SSL enabled / disabled.  Default is disabled.
        :param pulumi.Input[_builtins.str] renegotiate_period: Renogotiate Period (seconds)
        :param pulumi.Input[_builtins.str] renegotiate_size: Renogotiate Size
        :param pulumi.Input[_builtins.str] renegotiation: Enables or disables SSL renegotiation.When creating a new profile, the setting is provided by the parent profile
        :param pulumi.Input[_builtins.str] retain_certificate: When `true`, client certificate is retained in SSL session.
        :param pulumi.Input[_builtins.str] secure_renegotiation: Specifies the method of secure renegotiations for SSL connections. When creating a new profile, the setting is provided by the parent profile.
               When `request` is set the system request secure renegotation of SSL connections.
               `require` is a default setting and when set the system permits initial SSL handshakes from clients but terminates renegotiations from unpatched clients.
               The `require-strict` setting the system requires strict renegotiation of SSL connections. In this mode the system refuses connections to insecure servers, and terminates existing SSL connections to insecure servers
        :param pulumi.Input[_builtins.str] server_name: Specifies the fully qualified DNS hostname of the server used in Server Name Indication communications. When creating a new profile, the setting is provided by the parent profile.The server name can also be a wildcard string containing the asterisk `*` character.
        :param pulumi.Input[_builtins.str] session_mirroring: Session Mirroring (enabled / disabled)
        :param pulumi.Input[_builtins.str] session_ticket: Session Ticket (enabled / disabled)
        :param pulumi.Input[_builtins.str] sni_default: Indicates that the system uses this profile as the default SSL profile when there is no match to the server name, or when the client provides no SNI extension support.When creating a new profile, the setting is provided by the parent profile.
               There can be only one SSL profile with this setting enabled.
        :param pulumi.Input[_builtins.str] sni_require: Requires that the network peers also provide SNI support, this setting only takes effect when `sni_default` is set to `true`.When creating a new profile, the setting is provided by the parent profile
        :param pulumi.Input[_builtins.str] ssl_c3d: Enables or disables SSL forward proxy bypass on receiving
               handshake_failure, protocol_version or unsupported_extension alert message during the serverside SSL handshake. When enabled and there is an SSL handshake_failure, protocol_version or unsupported_extension alert during the serverside SSL handshake, SSL traffic bypasses the BIG-IP system untouched, without decryption/encryption. The default value is disabled. Conversely, you can specify enabled to use this feature.
        :param pulumi.Input[_builtins.str] ssl_forward_proxy: Specifies whether SSL forward proxy feature is enabled or not. The default value is disabled.
        :param pulumi.Input[_builtins.str] ssl_forward_proxy_bypass: Specifies whether SSL forward proxy bypass feature is enabled or not. The default value is disabled.
        :param pulumi.Input[_builtins.str] ssl_sign_hash: SSL sign hash (any, sha1, sha256, sha384)
        :param pulumi.Input[_builtins.str] strict_resume: Enables or disables the resumption of SSL sessions after an unclean shutdown.When creating a new profile, the setting is provided by the parent profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tm_options: List of Enabled selection from a set of industry standard options for handling SSL processing.By default,
               Don't insert empty fragments and No TLSv1.3 are listed as Enabled Options. `Usage` : tm_options    = ["dont-insert-empty-fragments","no-tlsv1.3"]
        :param pulumi.Input[_builtins.str] unclean_shutdown: Unclean Shutdown (enabled / disabled)
        :param pulumi.Input[_builtins.str] untrusted_cert_response_control: Unclean Shutdown (drop / ignore)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileServerSslArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.ProfileServerSsl` Manages server SSL profiles on a BIG-IP

        Resources should be named with their "full path". The full path is the combination of the partition + name (example: /Common/my-pool ) or  partition + directory + name of the resource  (example: /Common/test/my-pool )

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        test__server_ssl = f5bigip.ltm.ProfileServerSsl("test-ServerSsl",
            name="/Common/test-ServerSsl",
            defaults_from="/Common/serverssl",
            authenticate="always",
            ciphers="DEFAULT")
        ```

        ## Importing

        An existing server-ssl profile can be imported into this resource by supplying server-ssl profile Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_profile_server_ssl.test-ServerSsl-import /Common/test-ServerSsl

        ```

        :param str resource_name: The name of the resource.
        :param ProfileServerSslArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileServerSslArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticate: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticate_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 c3d_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 c3d_ca_key: Optional[pulumi.Input[_builtins.str]] = None,
                 c3d_ca_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 c3d_cert_extension_custom_oids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 c3d_cert_extension_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 c3d_cert_lifespan: Optional[pulumi.Input[_builtins.int]] = None,
                 c3d_certificate_extensions: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_file: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 chain: Optional[pulumi.Input[_builtins.str]] = None,
                 cipher_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ciphers: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_cert_response_control: Optional[pulumi.Input[_builtins.str]] = None,
                 full_path: Optional[pulumi.Input[_builtins.str]] = None,
                 generation: Optional[pulumi.Input[_builtins.int]] = None,
                 generic_alert: Optional[pulumi.Input[_builtins.str]] = None,
                 handshake_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 mod_ssl_methods: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_cert_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_ca_key: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_ssl: Optional[pulumi.Input[_builtins.str]] = None,
                 renegotiate_period: Optional[pulumi.Input[_builtins.str]] = None,
                 renegotiate_size: Optional[pulumi.Input[_builtins.str]] = None,
                 renegotiation: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_renegotiation: Optional[pulumi.Input[_builtins.str]] = None,
                 server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 session_mirroring: Optional[pulumi.Input[_builtins.str]] = None,
                 session_ticket: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_default: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_require: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_c3d: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_forward_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_forward_proxy_bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_sign_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 strict_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 tm_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unclean_shutdown: Optional[pulumi.Input[_builtins.str]] = None,
                 untrusted_cert_response_control: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileServerSslArgs.__new__(ProfileServerSslArgs)

            __props__.__dict__["alert_timeout"] = alert_timeout
            __props__.__dict__["authenticate"] = authenticate
            __props__.__dict__["authenticate_depth"] = authenticate_depth
            __props__.__dict__["c3d_ca_cert"] = c3d_ca_cert
            __props__.__dict__["c3d_ca_key"] = c3d_ca_key
            __props__.__dict__["c3d_ca_passphrase"] = c3d_ca_passphrase
            __props__.__dict__["c3d_cert_extension_custom_oids"] = c3d_cert_extension_custom_oids
            __props__.__dict__["c3d_cert_extension_includes"] = c3d_cert_extension_includes
            __props__.__dict__["c3d_cert_lifespan"] = c3d_cert_lifespan
            __props__.__dict__["c3d_certificate_extensions"] = c3d_certificate_extensions
            __props__.__dict__["ca_file"] = ca_file
            __props__.__dict__["cache_size"] = cache_size
            __props__.__dict__["cache_timeout"] = cache_timeout
            __props__.__dict__["cert"] = cert
            __props__.__dict__["chain"] = chain
            __props__.__dict__["cipher_group"] = cipher_group
            __props__.__dict__["ciphers"] = ciphers
            __props__.__dict__["defaults_from"] = defaults_from
            __props__.__dict__["expire_cert_response_control"] = expire_cert_response_control
            __props__.__dict__["full_path"] = full_path
            __props__.__dict__["generation"] = generation
            __props__.__dict__["generic_alert"] = generic_alert
            __props__.__dict__["handshake_timeout"] = handshake_timeout
            __props__.__dict__["key"] = key
            __props__.__dict__["mod_ssl_methods"] = mod_ssl_methods
            __props__.__dict__["mode"] = mode
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["partition"] = partition
            __props__.__dict__["passphrase"] = None if passphrase is None else pulumi.Output.secret(passphrase)
            __props__.__dict__["peer_cert_mode"] = peer_cert_mode
            __props__.__dict__["proxy_ca_cert"] = proxy_ca_cert
            __props__.__dict__["proxy_ca_key"] = proxy_ca_key
            __props__.__dict__["proxy_ssl"] = proxy_ssl
            __props__.__dict__["renegotiate_period"] = renegotiate_period
            __props__.__dict__["renegotiate_size"] = renegotiate_size
            __props__.__dict__["renegotiation"] = renegotiation
            __props__.__dict__["retain_certificate"] = retain_certificate
            __props__.__dict__["secure_renegotiation"] = secure_renegotiation
            __props__.__dict__["server_name"] = server_name
            __props__.__dict__["session_mirroring"] = session_mirroring
            __props__.__dict__["session_ticket"] = session_ticket
            __props__.__dict__["sni_default"] = sni_default
            __props__.__dict__["sni_require"] = sni_require
            __props__.__dict__["ssl_c3d"] = ssl_c3d
            __props__.__dict__["ssl_forward_proxy"] = ssl_forward_proxy
            __props__.__dict__["ssl_forward_proxy_bypass"] = ssl_forward_proxy_bypass
            __props__.__dict__["ssl_sign_hash"] = ssl_sign_hash
            __props__.__dict__["strict_resume"] = strict_resume
            __props__.__dict__["tm_options"] = tm_options
            __props__.__dict__["unclean_shutdown"] = unclean_shutdown
            __props__.__dict__["untrusted_cert_response_control"] = untrusted_cert_response_control
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["passphrase"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ProfileServerSsl, __self__).__init__(
            'f5bigip:ltm/profileServerSsl:ProfileServerSsl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_timeout: Optional[pulumi.Input[_builtins.str]] = None,
            authenticate: Optional[pulumi.Input[_builtins.str]] = None,
            authenticate_depth: Optional[pulumi.Input[_builtins.int]] = None,
            c3d_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            c3d_ca_key: Optional[pulumi.Input[_builtins.str]] = None,
            c3d_ca_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
            c3d_cert_extension_custom_oids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            c3d_cert_extension_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            c3d_cert_lifespan: Optional[pulumi.Input[_builtins.int]] = None,
            c3d_certificate_extensions: Optional[pulumi.Input[_builtins.str]] = None,
            ca_file: Optional[pulumi.Input[_builtins.str]] = None,
            cache_size: Optional[pulumi.Input[_builtins.int]] = None,
            cache_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            cert: Optional[pulumi.Input[_builtins.str]] = None,
            chain: Optional[pulumi.Input[_builtins.str]] = None,
            cipher_group: Optional[pulumi.Input[_builtins.str]] = None,
            ciphers: Optional[pulumi.Input[_builtins.str]] = None,
            defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
            expire_cert_response_control: Optional[pulumi.Input[_builtins.str]] = None,
            full_path: Optional[pulumi.Input[_builtins.str]] = None,
            generation: Optional[pulumi.Input[_builtins.int]] = None,
            generic_alert: Optional[pulumi.Input[_builtins.str]] = None,
            handshake_timeout: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            mod_ssl_methods: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            partition: Optional[pulumi.Input[_builtins.str]] = None,
            passphrase: Optional[pulumi.Input[_builtins.str]] = None,
            peer_cert_mode: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_ca_key: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_ssl: Optional[pulumi.Input[_builtins.str]] = None,
            renegotiate_period: Optional[pulumi.Input[_builtins.str]] = None,
            renegotiate_size: Optional[pulumi.Input[_builtins.str]] = None,
            renegotiation: Optional[pulumi.Input[_builtins.str]] = None,
            retain_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            secure_renegotiation: Optional[pulumi.Input[_builtins.str]] = None,
            server_name: Optional[pulumi.Input[_builtins.str]] = None,
            session_mirroring: Optional[pulumi.Input[_builtins.str]] = None,
            session_ticket: Optional[pulumi.Input[_builtins.str]] = None,
            sni_default: Optional[pulumi.Input[_builtins.str]] = None,
            sni_require: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_c3d: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_forward_proxy: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_forward_proxy_bypass: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_sign_hash: Optional[pulumi.Input[_builtins.str]] = None,
            strict_resume: Optional[pulumi.Input[_builtins.str]] = None,
            tm_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            unclean_shutdown: Optional[pulumi.Input[_builtins.str]] = None,
            untrusted_cert_response_control: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProfileServerSsl':
        """
        Get an existing ProfileServerSsl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alert_timeout: Alert time out
        :param pulumi.Input[_builtins.str] authenticate: Specifies the frequency of server authentication for an SSL session.When `once`,specifies that the system authenticates the server once for an SSL session.
               When `always`, specifies that the system authenticates the server once for an SSL session and also upon reuse of that session.
        :param pulumi.Input[_builtins.int] authenticate_depth: Client certificate chain traversal depth.  Default 9.
        :param pulumi.Input[_builtins.str] c3d_ca_cert: Specifies the name of the certificate file that is used as the certification authority certificate when SSL client certificate constrained delegation is enabled. The certificate should be generated and installed by you on the system. When selecting this option, type a certificate file name.
        :param pulumi.Input[_builtins.str] c3d_ca_key: Specifies the name of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. The key should be generated and installed by you on the system. When selecting this option, type a key file name.
               
               * `c3d-ca-passphrase` (Optional) Specifies the passphrase of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. When selecting this option, type the passphrase corresponding to the selected c3d-ca-key.
               
               * `c3d-cert-extension-custom-oids` (Optional) Specifies the custom extension OID of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation.
        :param pulumi.Input[_builtins.str] c3d_ca_passphrase: CA Passphrase. Default
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] c3d_cert_extension_custom_oids: Certificate Extensions List.  Default
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] c3d_cert_extension_includes: Specifies the extensions of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation. For example, { basic-constraints }. The default value is { basic-constraints extended-key-usage key-usage subject-alternative-name }. The extensions are:
               
               basic-constraints
               Basic constraints are used to indicate whether the certificate belongs
               to a CA.
               
               extended-key-usage
               Extended Key Usage is used, typically on a leaf certificate, to
               indicate the purpose of the public key contained in the certificate.
               
               key-usage
               Key Usage provides a bitmap specifying the cryptographic operations
               which may be performed using the public key contained in the
               certificate; for example, it could indicate that the key should be
               used for signature but not for encipherment.
               
               subject-alternative-name
               Subject Alternative Name allows identities to be bound to the subject
               of the certificate. These identities may be included in addition to
               or in place of the identity in the subject field of the certificate.
               
               * `c3d-cert-lifespan` Specifies the lifespan of the certificate generated using the SSL client certificate constrained delegation. The default value is 24.
        :param pulumi.Input[_builtins.int] c3d_cert_lifespan: Certificate Lifespan.  Default
        :param pulumi.Input[_builtins.str] c3d_certificate_extensions: CA Passphrase. Default enabled
        :param pulumi.Input[_builtins.str] ca_file: Client certificate file path.  Default None.
        :param pulumi.Input[_builtins.int] cache_size: Cache size (sessions).
        :param pulumi.Input[_builtins.int] cache_timeout: Cache time out
        :param pulumi.Input[_builtins.str] cert: Specifies the name of the certificate that the system uses for server-side SSL processing.
        :param pulumi.Input[_builtins.str] chain: Specifies the certificates-key chain to associate with the SSL profile
        :param pulumi.Input[_builtins.str] cipher_group: Specifies the cipher group for the SSL server profile. It is mutually exclusive with the argument, `ciphers`. The default value is `none`.
        :param pulumi.Input[_builtins.str] ciphers: Specifies the list of ciphers that the system supports. When creating a new profile, the default cipher list is provided by the parent profile.
        :param pulumi.Input[_builtins.str] defaults_from: The parent template of this monitor template. Once this value has been set, it cannot be changed. By default, this value is `/Common/serverssl`.
        :param pulumi.Input[_builtins.str] expire_cert_response_control: Response if the cert is expired (drop / ignore).
        :param pulumi.Input[_builtins.str] full_path: full path of the profile
        :param pulumi.Input[_builtins.int] generation: generation
        :param pulumi.Input[_builtins.str] generic_alert: Generic alerts enabled / disabled.
        :param pulumi.Input[_builtins.str] handshake_timeout: Handshake time out (seconds)
        :param pulumi.Input[_builtins.str] key: Specifies the file name of the SSL key.
        :param pulumi.Input[_builtins.str] mod_ssl_methods: ModSSL Methods enabled / disabled.  Default is disabled.
        :param pulumi.Input[_builtins.str] mode: ModSSL Methods enabled / disabled.  Default is disabled.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the profile.Name of Profile should be full path,full path is the combination of the `partition + profile name`. For example `/Common/test-serverssl-profile`.
        :param pulumi.Input[_builtins.str] partition: name of partition
        :param pulumi.Input[_builtins.str] passphrase: Client Certificate Constrained Delegation CA passphrase
        :param pulumi.Input[_builtins.str] peer_cert_mode: Specifies the way the system handles client certificates.When ignore, specifies that the system ignores certificates from client systems.When require, specifies that the system requires a client to present a valid certificate.When request, specifies that the system requests a valid certificate from a client but always authenticate the client.
        :param pulumi.Input[_builtins.str] proxy_ca_cert: Proxy CA Cert
        :param pulumi.Input[_builtins.str] proxy_ca_key: Proxy CA Key
        :param pulumi.Input[_builtins.str] proxy_ssl: Proxy SSL enabled / disabled.  Default is disabled.
        :param pulumi.Input[_builtins.str] renegotiate_period: Renogotiate Period (seconds)
        :param pulumi.Input[_builtins.str] renegotiate_size: Renogotiate Size
        :param pulumi.Input[_builtins.str] renegotiation: Enables or disables SSL renegotiation.When creating a new profile, the setting is provided by the parent profile
        :param pulumi.Input[_builtins.str] retain_certificate: When `true`, client certificate is retained in SSL session.
        :param pulumi.Input[_builtins.str] secure_renegotiation: Specifies the method of secure renegotiations for SSL connections. When creating a new profile, the setting is provided by the parent profile.
               When `request` is set the system request secure renegotation of SSL connections.
               `require` is a default setting and when set the system permits initial SSL handshakes from clients but terminates renegotiations from unpatched clients.
               The `require-strict` setting the system requires strict renegotiation of SSL connections. In this mode the system refuses connections to insecure servers, and terminates existing SSL connections to insecure servers
        :param pulumi.Input[_builtins.str] server_name: Specifies the fully qualified DNS hostname of the server used in Server Name Indication communications. When creating a new profile, the setting is provided by the parent profile.The server name can also be a wildcard string containing the asterisk `*` character.
        :param pulumi.Input[_builtins.str] session_mirroring: Session Mirroring (enabled / disabled)
        :param pulumi.Input[_builtins.str] session_ticket: Session Ticket (enabled / disabled)
        :param pulumi.Input[_builtins.str] sni_default: Indicates that the system uses this profile as the default SSL profile when there is no match to the server name, or when the client provides no SNI extension support.When creating a new profile, the setting is provided by the parent profile.
               There can be only one SSL profile with this setting enabled.
        :param pulumi.Input[_builtins.str] sni_require: Requires that the network peers also provide SNI support, this setting only takes effect when `sni_default` is set to `true`.When creating a new profile, the setting is provided by the parent profile
        :param pulumi.Input[_builtins.str] ssl_c3d: Enables or disables SSL forward proxy bypass on receiving
               handshake_failure, protocol_version or unsupported_extension alert message during the serverside SSL handshake. When enabled and there is an SSL handshake_failure, protocol_version or unsupported_extension alert during the serverside SSL handshake, SSL traffic bypasses the BIG-IP system untouched, without decryption/encryption. The default value is disabled. Conversely, you can specify enabled to use this feature.
        :param pulumi.Input[_builtins.str] ssl_forward_proxy: Specifies whether SSL forward proxy feature is enabled or not. The default value is disabled.
        :param pulumi.Input[_builtins.str] ssl_forward_proxy_bypass: Specifies whether SSL forward proxy bypass feature is enabled or not. The default value is disabled.
        :param pulumi.Input[_builtins.str] ssl_sign_hash: SSL sign hash (any, sha1, sha256, sha384)
        :param pulumi.Input[_builtins.str] strict_resume: Enables or disables the resumption of SSL sessions after an unclean shutdown.When creating a new profile, the setting is provided by the parent profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tm_options: List of Enabled selection from a set of industry standard options for handling SSL processing.By default,
               Don't insert empty fragments and No TLSv1.3 are listed as Enabled Options. `Usage` : tm_options    = ["dont-insert-empty-fragments","no-tlsv1.3"]
        :param pulumi.Input[_builtins.str] unclean_shutdown: Unclean Shutdown (enabled / disabled)
        :param pulumi.Input[_builtins.str] untrusted_cert_response_control: Unclean Shutdown (drop / ignore)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileServerSslState.__new__(_ProfileServerSslState)

        __props__.__dict__["alert_timeout"] = alert_timeout
        __props__.__dict__["authenticate"] = authenticate
        __props__.__dict__["authenticate_depth"] = authenticate_depth
        __props__.__dict__["c3d_ca_cert"] = c3d_ca_cert
        __props__.__dict__["c3d_ca_key"] = c3d_ca_key
        __props__.__dict__["c3d_ca_passphrase"] = c3d_ca_passphrase
        __props__.__dict__["c3d_cert_extension_custom_oids"] = c3d_cert_extension_custom_oids
        __props__.__dict__["c3d_cert_extension_includes"] = c3d_cert_extension_includes
        __props__.__dict__["c3d_cert_lifespan"] = c3d_cert_lifespan
        __props__.__dict__["c3d_certificate_extensions"] = c3d_certificate_extensions
        __props__.__dict__["ca_file"] = ca_file
        __props__.__dict__["cache_size"] = cache_size
        __props__.__dict__["cache_timeout"] = cache_timeout
        __props__.__dict__["cert"] = cert
        __props__.__dict__["chain"] = chain
        __props__.__dict__["cipher_group"] = cipher_group
        __props__.__dict__["ciphers"] = ciphers
        __props__.__dict__["defaults_from"] = defaults_from
        __props__.__dict__["expire_cert_response_control"] = expire_cert_response_control
        __props__.__dict__["full_path"] = full_path
        __props__.__dict__["generation"] = generation
        __props__.__dict__["generic_alert"] = generic_alert
        __props__.__dict__["handshake_timeout"] = handshake_timeout
        __props__.__dict__["key"] = key
        __props__.__dict__["mod_ssl_methods"] = mod_ssl_methods
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["partition"] = partition
        __props__.__dict__["passphrase"] = passphrase
        __props__.__dict__["peer_cert_mode"] = peer_cert_mode
        __props__.__dict__["proxy_ca_cert"] = proxy_ca_cert
        __props__.__dict__["proxy_ca_key"] = proxy_ca_key
        __props__.__dict__["proxy_ssl"] = proxy_ssl
        __props__.__dict__["renegotiate_period"] = renegotiate_period
        __props__.__dict__["renegotiate_size"] = renegotiate_size
        __props__.__dict__["renegotiation"] = renegotiation
        __props__.__dict__["retain_certificate"] = retain_certificate
        __props__.__dict__["secure_renegotiation"] = secure_renegotiation
        __props__.__dict__["server_name"] = server_name
        __props__.__dict__["session_mirroring"] = session_mirroring
        __props__.__dict__["session_ticket"] = session_ticket
        __props__.__dict__["sni_default"] = sni_default
        __props__.__dict__["sni_require"] = sni_require
        __props__.__dict__["ssl_c3d"] = ssl_c3d
        __props__.__dict__["ssl_forward_proxy"] = ssl_forward_proxy
        __props__.__dict__["ssl_forward_proxy_bypass"] = ssl_forward_proxy_bypass
        __props__.__dict__["ssl_sign_hash"] = ssl_sign_hash
        __props__.__dict__["strict_resume"] = strict_resume
        __props__.__dict__["tm_options"] = tm_options
        __props__.__dict__["unclean_shutdown"] = unclean_shutdown
        __props__.__dict__["untrusted_cert_response_control"] = untrusted_cert_response_control
        return ProfileServerSsl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alertTimeout")
    def alert_timeout(self) -> pulumi.Output[_builtins.str]:
        """
        Alert time out
        """
        return pulumi.get(self, "alert_timeout")

    @_builtins.property
    @pulumi.getter
    def authenticate(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the frequency of server authentication for an SSL session.When `once`,specifies that the system authenticates the server once for an SSL session.
        When `always`, specifies that the system authenticates the server once for an SSL session and also upon reuse of that session.
        """
        return pulumi.get(self, "authenticate")

    @_builtins.property
    @pulumi.getter(name="authenticateDepth")
    def authenticate_depth(self) -> pulumi.Output[_builtins.int]:
        """
        Client certificate chain traversal depth.  Default 9.
        """
        return pulumi.get(self, "authenticate_depth")

    @_builtins.property
    @pulumi.getter(name="c3dCaCert")
    def c3d_ca_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the certificate file that is used as the certification authority certificate when SSL client certificate constrained delegation is enabled. The certificate should be generated and installed by you on the system. When selecting this option, type a certificate file name.
        """
        return pulumi.get(self, "c3d_ca_cert")

    @_builtins.property
    @pulumi.getter(name="c3dCaKey")
    def c3d_ca_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. The key should be generated and installed by you on the system. When selecting this option, type a key file name.

        * `c3d-ca-passphrase` (Optional) Specifies the passphrase of the key file that is used as the certification authority key when SSL client certificate constrained delegation is enabled. When selecting this option, type the passphrase corresponding to the selected c3d-ca-key.

        * `c3d-cert-extension-custom-oids` (Optional) Specifies the custom extension OID of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation.
        """
        return pulumi.get(self, "c3d_ca_key")

    @_builtins.property
    @pulumi.getter(name="c3dCaPassphrase")
    def c3d_ca_passphrase(self) -> pulumi.Output[_builtins.str]:
        """
        CA Passphrase. Default
        """
        return pulumi.get(self, "c3d_ca_passphrase")

    @_builtins.property
    @pulumi.getter(name="c3dCertExtensionCustomOids")
    def c3d_cert_extension_custom_oids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Certificate Extensions List.  Default
        """
        return pulumi.get(self, "c3d_cert_extension_custom_oids")

    @_builtins.property
    @pulumi.getter(name="c3dCertExtensionIncludes")
    def c3d_cert_extension_includes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the extensions of the client certificates to be included in the generated certificates using SSL client certificate constrained delegation. For example, { basic-constraints }. The default value is { basic-constraints extended-key-usage key-usage subject-alternative-name }. The extensions are:

        basic-constraints
        Basic constraints are used to indicate whether the certificate belongs
        to a CA.

        extended-key-usage
        Extended Key Usage is used, typically on a leaf certificate, to
        indicate the purpose of the public key contained in the certificate.

        key-usage
        Key Usage provides a bitmap specifying the cryptographic operations
        which may be performed using the public key contained in the
        certificate; for example, it could indicate that the key should be
        used for signature but not for encipherment.

        subject-alternative-name
        Subject Alternative Name allows identities to be bound to the subject
        of the certificate. These identities may be included in addition to
        or in place of the identity in the subject field of the certificate.

        * `c3d-cert-lifespan` Specifies the lifespan of the certificate generated using the SSL client certificate constrained delegation. The default value is 24.
        """
        return pulumi.get(self, "c3d_cert_extension_includes")

    @_builtins.property
    @pulumi.getter(name="c3dCertLifespan")
    def c3d_cert_lifespan(self) -> pulumi.Output[_builtins.int]:
        """
        Certificate Lifespan.  Default
        """
        return pulumi.get(self, "c3d_cert_lifespan")

    @_builtins.property
    @pulumi.getter(name="c3dCertificateExtensions")
    def c3d_certificate_extensions(self) -> pulumi.Output[_builtins.str]:
        """
        CA Passphrase. Default enabled
        """
        return pulumi.get(self, "c3d_certificate_extensions")

    @_builtins.property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> pulumi.Output[_builtins.str]:
        """
        Client certificate file path.  Default None.
        """
        return pulumi.get(self, "ca_file")

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> pulumi.Output[_builtins.int]:
        """
        Cache size (sessions).
        """
        return pulumi.get(self, "cache_size")

    @_builtins.property
    @pulumi.getter(name="cacheTimeout")
    def cache_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Cache time out
        """
        return pulumi.get(self, "cache_timeout")

    @_builtins.property
    @pulumi.getter
    def cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the certificate that the system uses for server-side SSL processing.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter
    def chain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the certificates-key chain to associate with the SSL profile
        """
        return pulumi.get(self, "chain")

    @_builtins.property
    @pulumi.getter(name="cipherGroup")
    def cipher_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the cipher group for the SSL server profile. It is mutually exclusive with the argument, `ciphers`. The default value is `none`.
        """
        return pulumi.get(self, "cipher_group")

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the list of ciphers that the system supports. When creating a new profile, the default cipher list is provided by the parent profile.
        """
        return pulumi.get(self, "ciphers")

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The parent template of this monitor template. Once this value has been set, it cannot be changed. By default, this value is `/Common/serverssl`.
        """
        return pulumi.get(self, "defaults_from")

    @_builtins.property
    @pulumi.getter(name="expireCertResponseControl")
    def expire_cert_response_control(self) -> pulumi.Output[_builtins.str]:
        """
        Response if the cert is expired (drop / ignore).
        """
        return pulumi.get(self, "expire_cert_response_control")

    @_builtins.property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> pulumi.Output[_builtins.str]:
        """
        full path of the profile
        """
        return pulumi.get(self, "full_path")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> pulumi.Output[_builtins.int]:
        """
        generation
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter(name="genericAlert")
    def generic_alert(self) -> pulumi.Output[_builtins.str]:
        """
        Generic alerts enabled / disabled.
        """
        return pulumi.get(self, "generic_alert")

    @_builtins.property
    @pulumi.getter(name="handshakeTimeout")
    def handshake_timeout(self) -> pulumi.Output[_builtins.str]:
        """
        Handshake time out (seconds)
        """
        return pulumi.get(self, "handshake_timeout")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the file name of the SSL key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="modSslMethods")
    def mod_ssl_methods(self) -> pulumi.Output[_builtins.str]:
        """
        ModSSL Methods enabled / disabled.  Default is disabled.
        """
        return pulumi.get(self, "mod_ssl_methods")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        ModSSL Methods enabled / disabled.  Default is disabled.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the profile.Name of Profile should be full path,full path is the combination of the `partition + profile name`. For example `/Common/test-serverssl-profile`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> pulumi.Output[_builtins.str]:
        """
        name of partition
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> pulumi.Output[_builtins.str]:
        """
        Client Certificate Constrained Delegation CA passphrase
        """
        return pulumi.get(self, "passphrase")

    @_builtins.property
    @pulumi.getter(name="peerCertMode")
    def peer_cert_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the way the system handles client certificates.When ignore, specifies that the system ignores certificates from client systems.When require, specifies that the system requires a client to present a valid certificate.When request, specifies that the system requests a valid certificate from a client but always authenticate the client.
        """
        return pulumi.get(self, "peer_cert_mode")

    @_builtins.property
    @pulumi.getter(name="proxyCaCert")
    def proxy_ca_cert(self) -> pulumi.Output[_builtins.str]:
        """
        Proxy CA Cert
        """
        return pulumi.get(self, "proxy_ca_cert")

    @_builtins.property
    @pulumi.getter(name="proxyCaKey")
    def proxy_ca_key(self) -> pulumi.Output[_builtins.str]:
        """
        Proxy CA Key
        """
        return pulumi.get(self, "proxy_ca_key")

    @_builtins.property
    @pulumi.getter(name="proxySsl")
    def proxy_ssl(self) -> pulumi.Output[_builtins.str]:
        """
        Proxy SSL enabled / disabled.  Default is disabled.
        """
        return pulumi.get(self, "proxy_ssl")

    @_builtins.property
    @pulumi.getter(name="renegotiatePeriod")
    def renegotiate_period(self) -> pulumi.Output[_builtins.str]:
        """
        Renogotiate Period (seconds)
        """
        return pulumi.get(self, "renegotiate_period")

    @_builtins.property
    @pulumi.getter(name="renegotiateSize")
    def renegotiate_size(self) -> pulumi.Output[_builtins.str]:
        """
        Renogotiate Size
        """
        return pulumi.get(self, "renegotiate_size")

    @_builtins.property
    @pulumi.getter
    def renegotiation(self) -> pulumi.Output[_builtins.str]:
        """
        Enables or disables SSL renegotiation.When creating a new profile, the setting is provided by the parent profile
        """
        return pulumi.get(self, "renegotiation")

    @_builtins.property
    @pulumi.getter(name="retainCertificate")
    def retain_certificate(self) -> pulumi.Output[_builtins.str]:
        """
        When `true`, client certificate is retained in SSL session.
        """
        return pulumi.get(self, "retain_certificate")

    @_builtins.property
    @pulumi.getter(name="secureRenegotiation")
    def secure_renegotiation(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the method of secure renegotiations for SSL connections. When creating a new profile, the setting is provided by the parent profile.
        When `request` is set the system request secure renegotation of SSL connections.
        `require` is a default setting and when set the system permits initial SSL handshakes from clients but terminates renegotiations from unpatched clients.
        The `require-strict` setting the system requires strict renegotiation of SSL connections. In this mode the system refuses connections to insecure servers, and terminates existing SSL connections to insecure servers
        """
        return pulumi.get(self, "secure_renegotiation")

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the fully qualified DNS hostname of the server used in Server Name Indication communications. When creating a new profile, the setting is provided by the parent profile.The server name can also be a wildcard string containing the asterisk `*` character.
        """
        return pulumi.get(self, "server_name")

    @_builtins.property
    @pulumi.getter(name="sessionMirroring")
    def session_mirroring(self) -> pulumi.Output[_builtins.str]:
        """
        Session Mirroring (enabled / disabled)
        """
        return pulumi.get(self, "session_mirroring")

    @_builtins.property
    @pulumi.getter(name="sessionTicket")
    def session_ticket(self) -> pulumi.Output[_builtins.str]:
        """
        Session Ticket (enabled / disabled)
        """
        return pulumi.get(self, "session_ticket")

    @_builtins.property
    @pulumi.getter(name="sniDefault")
    def sni_default(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates that the system uses this profile as the default SSL profile when there is no match to the server name, or when the client provides no SNI extension support.When creating a new profile, the setting is provided by the parent profile.
        There can be only one SSL profile with this setting enabled.
        """
        return pulumi.get(self, "sni_default")

    @_builtins.property
    @pulumi.getter(name="sniRequire")
    def sni_require(self) -> pulumi.Output[_builtins.str]:
        """
        Requires that the network peers also provide SNI support, this setting only takes effect when `sni_default` is set to `true`.When creating a new profile, the setting is provided by the parent profile
        """
        return pulumi.get(self, "sni_require")

    @_builtins.property
    @pulumi.getter(name="sslC3d")
    def ssl_c3d(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enables or disables SSL forward proxy bypass on receiving
        handshake_failure, protocol_version or unsupported_extension alert message during the serverside SSL handshake. When enabled and there is an SSL handshake_failure, protocol_version or unsupported_extension alert during the serverside SSL handshake, SSL traffic bypasses the BIG-IP system untouched, without decryption/encryption. The default value is disabled. Conversely, you can specify enabled to use this feature.
        """
        return pulumi.get(self, "ssl_c3d")

    @_builtins.property
    @pulumi.getter(name="sslForwardProxy")
    def ssl_forward_proxy(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether SSL forward proxy feature is enabled or not. The default value is disabled.
        """
        return pulumi.get(self, "ssl_forward_proxy")

    @_builtins.property
    @pulumi.getter(name="sslForwardProxyBypass")
    def ssl_forward_proxy_bypass(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether SSL forward proxy bypass feature is enabled or not. The default value is disabled.
        """
        return pulumi.get(self, "ssl_forward_proxy_bypass")

    @_builtins.property
    @pulumi.getter(name="sslSignHash")
    def ssl_sign_hash(self) -> pulumi.Output[_builtins.str]:
        """
        SSL sign hash (any, sha1, sha256, sha384)
        """
        return pulumi.get(self, "ssl_sign_hash")

    @_builtins.property
    @pulumi.getter(name="strictResume")
    def strict_resume(self) -> pulumi.Output[_builtins.str]:
        """
        Enables or disables the resumption of SSL sessions after an unclean shutdown.When creating a new profile, the setting is provided by the parent profile.
        """
        return pulumi.get(self, "strict_resume")

    @_builtins.property
    @pulumi.getter(name="tmOptions")
    def tm_options(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of Enabled selection from a set of industry standard options for handling SSL processing.By default,
        Don't insert empty fragments and No TLSv1.3 are listed as Enabled Options. `Usage` : tm_options    = ["dont-insert-empty-fragments","no-tlsv1.3"]
        """
        return pulumi.get(self, "tm_options")

    @_builtins.property
    @pulumi.getter(name="uncleanShutdown")
    def unclean_shutdown(self) -> pulumi.Output[_builtins.str]:
        """
        Unclean Shutdown (enabled / disabled)
        """
        return pulumi.get(self, "unclean_shutdown")

    @_builtins.property
    @pulumi.getter(name="untrustedCertResponseControl")
    def untrusted_cert_response_control(self) -> pulumi.Output[_builtins.str]:
        """
        Unclean Shutdown (drop / ignore)
        """
        return pulumi.get(self, "untrusted_cert_response_control")

