# Copyright 2022-2023 Efabless Corporation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
if { ![info exists ::grt_preamble] } {
    set ::grt_preamble 1

    source $::env(SCRIPTS_DIR)/openroad/common/set_routing_layers.tcl
    source $::env(SCRIPTS_DIR)/openroad/common/set_layer_adjustments.tcl

    set_macro_extension $::env(GRT_MACRO_EXTENSION)
}

set arg_list [list]
lappend arg_list -congestion_iterations $::env(GRT_OVERFLOW_ITERS)
lappend arg_list -verbose
if { $::env(GRT_ALLOW_CONGESTION) == 1 } {
    lappend arg_list -allow_congestion
}

log_cmd global_route {*}$arg_list

write_guide $::env(STEP_DIR)/after_grt.guide
