# SPDX-License-Identifier: Apache-2.0.
# Copyright (c) 2024 - 2025 Waldiez and contributors.

"""update tasks model, allow scheduling

Revision ID: dc6dd57db1a5
Revises: c8d44162a7c4
Create Date: 2025-04-23 05:49:05.781702+00:00
"""

# flake8: noqa
# pylint: skip-file
from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "dc6dd57db1a5"
down_revision: Union[str, None] = "c8d44162a7c4"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "tasks", sa.Column("schedule_type", sa.String(), nullable=True)
    )
    op.add_column(
        "tasks",
        sa.Column(
            "scheduled_time",
            sa.DateTime(timezone=True),
            nullable=True,
        ),
    )
    op.add_column(
        "tasks", sa.Column("cron_expression", sa.String(), nullable=True)
    )
    op.add_column(
        "tasks",
        sa.Column(
            "triggered_at",
            sa.DateTime(timezone=True),
            nullable=True,
        ),
    )
    op.add_column(
        "tasks",
        sa.Column(
            "expires_at",
            sa.DateTime(timezone=True),
            nullable=True,
        ),
    )
    op.create_index(
        op.f("ix_tasks_schedule_type"), "tasks", ["schedule_type"], unique=False
    )
    op.create_index(
        op.f("ix_tasks_scheduled_time"),
        "tasks",
        ["scheduled_time"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_tasks_scheduled_time"), table_name="tasks")
    op.drop_index(op.f("ix_tasks_schedule_type"), table_name="tasks")
    op.drop_column("tasks", "expires_at")
    op.drop_column("tasks", "triggered_at")
    op.drop_column("tasks", "cron_expression")
    op.drop_column("tasks", "scheduled_time")
    op.drop_column("tasks", "schedule_type")
    # ### end Alembic commands ###
