# pylint: skip-file
from flexstack.utils.asn1.etsi_its_cdd import ETSI_ITS_CDD_ASN1_DESCRIPTIONS

DENM_ASN1_DESCRIPTIONS = ETSI_ITS_CDD_ASN1_DESCRIPTIONS+\
    """
--! @options: no-fields-header

DENM-PDU-Description {itu-t (0) identified-organization (4) etsi (0) itsDomain (5) wg1 (1) denmPduRelease2 (103831) 
                      major-version-2 (2) minor-version-2 (2)} 

DEFINITIONS AUTOMATIC TAGS ::=

BEGIN

IMPORTS 
 
ActionId, ActionIdList, CauseCodeV2, ClosedLanes, DangerousGoodsExtended, DeltaReferencePosition, DeltaTimeMilliSecondPositive, DeltaTimeSecond, 
EnergyStorageType, EventZone, GeneralizedLanePositions, HeightLonCarr, InformationQuality, ItsPduHeader, IvimReferences, LanePosition, 
LightBarSirenInUse, ItineraryPath, MapReferences, MetaInformation, NumberOfOccupants, ObjectFace, OccupiedLanesWithConfidence, PerceivedObject, 
Position1d, PosLonCarr, PosCentMass, PositionOfPillars, PositioningSolutionType, PosFrontAx, PositionOfOccupants, PathPredictedList, 
RequestResponseIndication, ReferencePosition, RestrictedTypes, RoadConfigurationSectionList, RoadType, StandardLength3b,StandardLength12b, 
StationType, Speed, SpeedLimit, StationId, StationarySince, TimestampIts, Traces, TracesExtended, TrafficDirection, TrafficRule, TurningRadius, 
Temperature, VehicleMass, VehicleIdentification, Wgs84Angle, WheelBaseVehicle 
   
FROM ETSI-ITS-CDD {itu-t (0) identified-organization (4) etsi (0) itsDomain (5) wg1 (1) ts (102894) cdd (2) 
                   major-version-4 (4) minor-version-2 (2)};

/** 
 * This type represents the DENM PDU.
 *
 * It shall include the following components: 
 *
 * @field header: the header of the DENM PDU.
 *
 * @field denm: the payload of the DENM PDU.
*/
DENM ::= SEQUENCE {
	header ItsPduHeader (WITH COMPONENTS {... , protocolVersion (2), messageId(denm)}),
	denm   DenmPayload
}

/** 
 * This type represents the DENM payload.
 *
 * It shall include the following components: 
 *
 * @field management: the Management Container.
 *
 * @field situation: the optional Situation Container.
 *
 * @field location: the optional Location Container.
 *
 * @field alacarte: the optional ALaCarte Container .
 *
*/
DenmPayload ::= SEQUENCE {
    management ManagementContainer,
    situation  SituationContainer OPTIONAL,
    location   LocationContainer OPTIONAL,
    alacarte   AlacarteContainer OPTIONAL
}
((WITH COMPONENTS {..., management (WITH COMPONENTS {..., termination ABSENT}), situation PRESENT, location PRESENT}) |
 (WITH COMPONENTS {..., management (WITH COMPONENTS {..., termination PRESENT}), situation ABSENT, location ABSENT, alacarte ABSENT}))

/** 
 * This type represents the Management Container.
 *
 * It shall include the following components: 
 *
 * @field actionId: the identifier of the DENM.
 *
 * @field detectionTime: the time at which the event is detected.
 *
 * @field referenceTime: the time at which a new DENM, an update DENM or a cancellation DENM is generated
 *
 * @field termination: the optional termination type of the DENM.
 *
 * @field eventPosition: the geographical position used in the definition of the awareness area / relevance zone, see clause 6.1.3.
 *
 * @field awarenessDistance: the optional radius of the circular awareness area, with centre at the event position or at any of the 
 * event history points as defined in clause 6.1.3.1.
 *
 * @field trafficDirection: the optional traffic direction along which the receiving ITS-S may encounter the event, 
 * as defined in clause 6.1.3.
 *
 * @field validityDuration: the validity duration of a DENM. This component represents a time offset in the unit of second since detectionTime.
 *
 * @field transmissionInterval: the optional time interval for DENM transmission as defined by the originating ITS-S. 
 * If the component is not present in DENM, a default value defaultValidity is assumed.
 *
 * @field stationType: the station type information of the originating ITS-S.
 *
*/
ManagementContainer ::= SEQUENCE {
    actionId                  ActionId,
    detectionTime             TimestampIts,
    referenceTime             TimestampIts,
    termination               Termination OPTIONAL,
    eventPosition             ReferencePosition,
    awarenessDistance         StandardLength3b OPTIONAL,
    trafficDirection          TrafficDirection OPTIONAL,
    validityDuration          DeltaTimeSecond DEFAULT defaultValidity, 
    transmissionInterval      DeltaTimeMilliSecondPositive OPTIONAL,
    stationType               StationType,
    ...
}

/** 
 * This type represents the situation container.
 *
 * It shall include the following components: 
 *
 * @field informationQuality: the quality level of the information provided by the ITS-S application of the originating ITS-S. 
 * It indicates the probability of the detected event being truly existent at the event position.
 *
 * @field eventType: the event type, including direct cause and sub cause.
 *
 * @field linkedCause: the optional type of a linked event co-existing at the same time and the same place (same event zone), 
 * including direct cause and sub cause of the linked event, for which no other DENM is sent out.
 *
 * @field eventZone: an optional list of EventPoint, using the position indicated in the component eventPosition of the Management container 
 * as the reference position for the first EventPoint.
 *
 * @field linkedDenms: the optional list of DF ActionId, pointing to DENMs that are semantically connected because applying to consecutive 
 * event zones at the same time.
 *
 * @field eventEnd: the end position of the event along the road that is affected by the event w.r.t. the component eventPosition of the 
 * Management container. This end position is represented by the length of the event along the road. 
 *
*/
SituationContainer ::= SEQUENCE {
    informationQuality InformationQuality,
    eventType          CauseCodeV2,
    linkedCause        CauseCodeV2 OPTIONAL,
    eventZone          EventZone OPTIONAL,
    ...,
[[  linkedDenms        ActionIdList OPTIONAL,
    eventEnd           Position1d OPTIONAL ]]   
}
  ((WITH COMPONENTS {..., eventZone PRESENT, eventEnd ABSENT}) |
   (WITH COMPONENTS {..., eventZone ABSENT, eventEnd PRESENT}) |
   (WITH COMPONENTS {..., eventZone ABSENT, eventEnd ABSENT})) 
 


/** 
 * This type represents the Location Container.
 *
 * It shall include the following components: 
 *
 * @field eventSpeed: optional speed of a detected dynamic event and the confidence of the speed information. 
 *
 * @field eventPositionHeading: the optional heading of a dynamic event and the confidence of the heading information.
 *
 * @field detectionZonesToEventPosition: the detection zone information approaching the event position, see clause 6.1.3.3.
 *
 * @field roadType: the optional road type information at the event position. 
 *
 * @field lanePositions: the optional lane(s) where the event is located, at the position indicated by the component eventPosition 
 * of the Management container and for a given reference direction.
 *
 * @field occupiedLanes: the optional lane(s) that are fully or partially occupied by the event, at the position indicated by the 
 * component eventPosition of the Management container and for a given reference direction.
 *
 * @field linkedIvims: the optional list of DF IvimReference, pointing to IVIMs that are semantically connected because providing information 
 * applying to the road segment(s) covered by the components detectionZonesToEventPosition, detectionZonesToSpecifiedEventPoint and 
 * the SituationContainer component eventZone.
 *
 * @field linkedMapem: the optional list of DF Mapreference, pointing to MAPEMs that are semantically connected because providing information 
 * applying to the road segment(s) covered by the component detectionZonesToEventPosition, detectionZonesToSpecifiedEventPoint and 
 * the SituationContainer component eventZone.
 *
 * @field detectionZonesToSpecifiedEventPoint: the optional detection zone information approaching towards a 
 * specified event point, see clause 6.1.3.3. 
 *
 * @field predictedPaths: the optional list of future paths or trajectories that the event may move along or zones that the event may occupy. 
 *
*/
LocationContainer ::= SEQUENCE {
    eventSpeed                            Speed OPTIONAL,
    eventPositionHeading                  Wgs84Angle OPTIONAL,
    detectionZonesToEventPosition         Traces,
    roadType                              RoadType OPTIONAL,
    ...,
[[	lanePositions                         GeneralizedLanePositions OPTIONAL,
    occupiedLanes                         OccupiedLanesWithConfidence OPTIONAL,
    linkedIvims                           IvimReferences OPTIONAL, 
    linkedMapems                          MapReferences OPTIONAL, 
    detectionZonesToSpecifiedEventPoint   TracesExtended OPTIONAL,
    predictedPaths	          	          PathPredictedList OPTIONAL ]]
}

/** 
 * This type contains detailed information about the vehicle in which the originating ITS-S is mounted, for mitigating the consequences 
 * of a collision.
 *
 * It shall include the following components: 
 *
 * @field heightLonCarrLeft: the height of the left longitudinal carrier of the vehicle from base to top.
 *
 * @field heightLonCarrRight: the height of the right longitudinal carrier of the vehicle from base to top.
 *
 * @field posLonCarrLeft: the position of the left longitudinal carrier of vehicle.
 *
 * @field posLonCarrRight: the position of the right longitudinal carrier of vehicle.
 *
 * @field positionOfPillars: information about the vertical support of the vehicle in which the originating ITS-S is mounted. It shall be 
 * included for passenger vehicles only.
 *
 * @field posCentMass: the position of the centre of mass of the vehicle.
 *
 * @field wheelBaseVehicle: the wheel base of the vehicle.
 *
 * @field turningRadius: the turning radius of the vehicle.
 *
 * @field posFrontAx: the position of the front axle of the vehicle.
 *
 * @field positionOfOccupants: indicates whether an in-vehicle seat is occupied at the moment of generation of the message.
 *
 * @field vehicleMass: the mass of the unloaded vehicle
 *
 * @field requestResponseIndication: indicates whether the originating ITS-S transmitting the impactReduction component is requesting 
 * the receiving ITS-S to provide also its impactReduction component.
 *
*/
ImpactReductionContainer ::= SEQUENCE {
    heightLonCarrLeft         HeightLonCarr,
    heightLonCarrRight        HeightLonCarr,
    posLonCarrLeft            PosLonCarr,
    posLonCarrRight           PosLonCarr,
    positionOfPillars         PositionOfPillars,
    posCentMass               PosCentMass,
    wheelBaseVehicle          WheelBaseVehicle,
    turningRadius             TurningRadius,
    posFrontAx                PosFrontAx,
    positionOfOccupants       PositionOfOccupants,
    vehicleMass               VehicleMass,
    requestResponseIndication RequestResponseIndication
}

/** 
 * This type contains detailed information about an object with which a vehicle and/or the traffic is likely to collide.
 *
 * It shall include the following components: 
 *
 * @field perceivedPreCrashObject: information about a perceived object in the East, North, Up reference frame.
 *
 * @field objectStationId: the optional station Id of the object for which the information is provided.
 *
 * @field timeToCollision: the optional estimated time to collision of a vehicle with the object. 
 *
 * @field impactSection: indication of the object's section where the impact will most likely occur. 
 * When the target object is likely to be a vehicle, then this component should be present, otherwise it should not be provided.  
 *
 * @field estimatedBrakingDistance: the optional estimated distance in which the vehicle would need to come to a complete hold, 
 * if no obstruction was in the way. 
*/
PreCrashContainer ::= SEQUENCE { 
    perceivedPreCrashObject   PerceivedObject, 
    objectStationId           StationId OPTIONAL, 
    timeToCollision           DeltaTimeMilliSecondPositive OPTIONAL, 
    impactSection             ObjectFace OPTIONAL, 
    estimatedBrakingDistance  StandardLength12b OPTIONAL,
    ... 
}

/** 
 * This type contains detailed information about the configuration of road section(s) that are geographically related to the event.
 *
 * It shall include the following components: 
 *
 * @field roadConfigurationConfidence: information about the source of the road configuration and the confidence in the information.
 *
 * @field roadConfigurationSectionList: a list of road configuration information per applicable road section. 
*
*/
RoadConfigurationContainer ::=  SEQUENCE {
    roadConfigurationConfidence     MetaInformation,
    roadConfigurationSectionList    RoadConfigurationSectionList,
    ...
} 

/** 
 * This type contains detailed information of a roadwork zone and specific access conditions.
 *
 * It shall include the following components: 
 *
 * @field lightBarSirenInUse: optionally indicates whether a roadwork vehicle has switched on the light bar or siren. 
 * It is used when the roadwork involves a specific roadwork vehicle
 *
 * @field closedLanes: optionally indicates whether the roadwork has caused the closure of one or several driving lanes. 
 * Optionally, it may indicate whether a hard shoulder lane is closed to traffic or can be used for specific usage (e.g. for stopping).
 *
 * @field restriction: the optional type(s) of vehicles that are restricted to access the road work zone. 
 * More than one vehicle types may be provided by this component if the restriction apply to multiple vehicle types. 
 *
 * @field speedLimit: the optional speed limitation applied to the roadwork zone.
 *
 * @field incidentIndication: the optional incident related to the roadworks to provide additional information of the roadworks zone.
 *
 * @field recommendedPath: the optional recommended itinerary in order to contour the roadworks zone. If present, a recommended path 
 * shall be a list of path points in the order from the starting point closest to the roadworks zone to the end point of the recommended path. 
 *
 * @field startingPointSpeedLimit: the optional effective starting position of a speed limit being applied to the roadwork zone, 
 * with respect to the component eventPosition on the Management Container.
 * This component shall be present if the speed limit is applied at a certain distance prior to the roadwork zone starting position.
 *
 * @field trafficFlowRule: optionally indicates the side of the road to which the traffic should flow around a roadwork.
 *
 * @field referenceDenms: an optional sequence of actionIds for different DENMs that describe the same event. 
 * If it is available, it indicates the actionIds of all other DENMs describing this event.
 *
*/
RoadWorksContainerExtended ::= SEQUENCE {
    lightBarSirenInUse      LightBarSirenInUse OPTIONAL,
    closedLanes             ClosedLanes OPTIONAL,
    restriction             RestrictedTypes OPTIONAL,
    speedLimit              SpeedLimit OPTIONAL,
    incidentIndication      CauseCodeV2 OPTIONAL,
    recommendedPath         ItineraryPath OPTIONAL,
    startingPointSpeedLimit DeltaReferencePosition OPTIONAL,
    trafficFlowRule         TrafficRule OPTIONAL,
    referenceDenms          ActionIdList OPTIONAL
}

/** 
 * This type contains detailed information about a stationary vehicle.
 *
 * It shall include the following components: 
 *
 * @field stationarySince: the optional time duration of the stationary vehicle being stationary.
 *
 * @field stationaryCause: optional additional information to describe causes of the stationary vehicle event such as human problem.
 *
 * @field carryingDangerousGoods: optional information on the type of dangerous goods, the required emergency action and other information.
 *
 * @field numberOfOccupants: the optional estimated number of occupants involved in the stationary vehicle event.
 *
 * @field vehicleIdentification: the optional identification of the stationary vehicle.
 *
 * @field energyStorageType: the optional vehicle energy storage type information of the stationary vehicle, such as electric, diesel, etc.
 *
*/
StationaryVehicleContainer ::= SEQUENCE {
    stationarySince        StationarySince OPTIONAL, 
    stationaryCause        CauseCodeV2 OPTIONAL,
    carryingDangerousGoods DangerousGoodsExtended OPTIONAL,
    numberOfOccupants      NumberOfOccupants OPTIONAL,
    vehicleIdentification  VehicleIdentification OPTIONAL,
    energyStorageType      EnergyStorageType OPTIONAL
}

/** 
 * This type represents the A La Carte Container.
 *
 * It shall include the following components: 
 *
 * @field lanePosition: the optional lane position of the event.
 *
 * @field impactReduction: optional vehicle data for collision mitigation.
 *
 * @field externalTemperature: optional the ambient temperature at the event position.
 *
 * @field roadWorks: optional information of the roadwork zone.
 *
 * @field positioningSolution: optionally indicates the technical solution being used by the originating ITS-S to estimate the event position.
 *
 * @field stationaryVehicle: optional information about a stationary vehicle.
 *
 * @field roadConfiguration: optional information about the configuration of the road.
 *
 * @field precrash: the optional information about perceived objects that represent hazards and/or could be subject of collisions. 
 *
*/
AlacarteContainer ::= SEQUENCE {
    lanePosition        LanePosition OPTIONAL,
    impactReduction     ImpactReductionContainer OPTIONAL,
    externalTemperature Temperature OPTIONAL,
    roadWorks           RoadWorksContainerExtended OPTIONAL,
    positioningSolution PositioningSolutionType OPTIONAL,
    stationaryVehicle   StationaryVehicleContainer OPTIONAL,
    ...,
[[  roadConfiguration 	RoadConfigurationContainer OPTIONAL,
    preCrash            PreCrashContainer OPTIONAL ]]
}

/** 
 * This type specifies the default value for DENM validity duration used for DENM protocol operation.
*/
defaultValidity INTEGER ::= 600

/**
  * This indicates the termination type of generated DENM, i.e. if it is a cancellation DENM or a negation DENM
*/

Termination ::= ENUMERATED {isCancellation(0), isNegation (1)}

END

"""