# mypy-boto3-waf

[![PyPI - mypy-boto3-waf](https://img.shields.io/pypi/v/mypy-boto3-waf.svg?color=blue)](https://pypi.org/project/mypy-boto3-waf)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-waf.svg?color=blue)](https://pypi.org/project/mypy-boto3-waf)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-waf?color=blue)](https://pypistats.org/packages/mypy-boto3-waf)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.WAF 1.17.63](https://boto3.amazonaws.com/v1/documentation/api/1.17.63/reference/services/waf.html#WAF) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.8.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[auto-generated docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_waf/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-waf](#mypy-boto3-waf)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `WAF` service.

```bash
python -m pip install boto3-stubs[waf]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[waf]` in your environment: `python -m pip install 'boto3-stubs[waf]'`

Both type checking and auto-complete should work for `WAF` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[waf]` in your environment: `python -m pip install 'boto3-stubs[waf]'`

Both type checking and auto-complete should work for `WAF` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[waf]` in your environment: `python -m pip install 'boto3-stubs[waf]'`
- Run `mypy` as usual

Type checking should work for `WAF` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[waf]` in your environment: `python -m pip install 'boto3-stubs[waf]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `WAF` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`WAFClient` provides annotations for `boto3.client("waf")`.

```python
import boto3

from mypy_boto3_waf import WAFClient

client: WAFClient = boto3.client("waf")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WAFClient = session.client("waf")
```

### Paginators annotations

`mypy_boto3_waf.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_waf import WAFClient
from mypy_boto3_waf.paginator import (
    GetRateBasedRuleManagedKeysPaginator,
    ListActivatedRulesInRuleGroupPaginator,
    ListByteMatchSetsPaginator,
    ListGeoMatchSetsPaginator,
    ListIPSetsPaginator,
    ListLoggingConfigurationsPaginator,
    ListRateBasedRulesPaginator,
    ListRegexMatchSetsPaginator,
    ListRegexPatternSetsPaginator,
    ListRuleGroupsPaginator,
    ListRulesPaginator,
    ListSizeConstraintSetsPaginator,
    ListSqlInjectionMatchSetsPaginator,
    ListSubscribedRuleGroupsPaginator,
    ListWebACLsPaginator,
    ListXssMatchSetsPaginator,
)

client: WAFClient = boto3.client("waf")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_rate_based_rule_managed_keys_paginator: GetRateBasedRuleManagedKeysPaginator = client.get_paginator("get_rate_based_rule_managed_keys")
list_activated_rules_in_rule_group_paginator: ListActivatedRulesInRuleGroupPaginator = client.get_paginator("list_activated_rules_in_rule_group")
list_byte_match_sets_paginator: ListByteMatchSetsPaginator = client.get_paginator("list_byte_match_sets")
list_geo_match_sets_paginator: ListGeoMatchSetsPaginator = client.get_paginator("list_geo_match_sets")
list_ip_sets_paginator: ListIPSetsPaginator = client.get_paginator("list_ip_sets")
list_logging_configurations_paginator: ListLoggingConfigurationsPaginator = client.get_paginator("list_logging_configurations")
list_rate_based_rules_paginator: ListRateBasedRulesPaginator = client.get_paginator("list_rate_based_rules")
list_regex_match_sets_paginator: ListRegexMatchSetsPaginator = client.get_paginator("list_regex_match_sets")
list_regex_pattern_sets_paginator: ListRegexPatternSetsPaginator = client.get_paginator("list_regex_pattern_sets")
list_rule_groups_paginator: ListRuleGroupsPaginator = client.get_paginator("list_rule_groups")
list_rules_paginator: ListRulesPaginator = client.get_paginator("list_rules")
list_size_constraint_sets_paginator: ListSizeConstraintSetsPaginator = client.get_paginator("list_size_constraint_sets")
list_sql_injection_match_sets_paginator: ListSqlInjectionMatchSetsPaginator = client.get_paginator("list_sql_injection_match_sets")
list_subscribed_rule_groups_paginator: ListSubscribedRuleGroupsPaginator = client.get_paginator("list_subscribed_rule_groups")
list_web_acls_paginator: ListWebACLsPaginator = client.get_paginator("list_web_acls")
list_xss_match_sets_paginator: ListXssMatchSetsPaginator = client.get_paginator("list_xss_match_sets")
```







### Literals

`mypy_boto3_waf.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_waf.literals import (
    ChangeAction,
    ChangeTokenStatus,
    ComparisonOperator,
    GeoMatchConstraintType,
    GeoMatchConstraintValue,
    GetRateBasedRuleManagedKeysPaginatorName,
    IPSetDescriptorType,
    ListActivatedRulesInRuleGroupPaginatorName,
    ListByteMatchSetsPaginatorName,
    ListGeoMatchSetsPaginatorName,
    ListIPSetsPaginatorName,
    ListLoggingConfigurationsPaginatorName,
    ListRateBasedRulesPaginatorName,
    ListRegexMatchSetsPaginatorName,
    ListRegexPatternSetsPaginatorName,
    ListRuleGroupsPaginatorName,
    ListRulesPaginatorName,
    ListSizeConstraintSetsPaginatorName,
    ListSqlInjectionMatchSetsPaginatorName,
    ListSubscribedRuleGroupsPaginatorName,
    ListWebACLsPaginatorName,
    ListXssMatchSetsPaginatorName,
    MatchFieldType,
    PositionalConstraint,
    PredicateType,
    RateKey,
    TextTransformation,
    WafActionType,
    WafOverrideActionType,
    WafRuleType,
)

def check_value(value: ChangeAction) -> bool:
    ...
```



### Typed dictionaries

`mypy_boto3_waf.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_waf.type_defs import (
    ActivatedRuleTypeDef,
    ByteMatchSetSummaryTypeDef,
    ByteMatchSetTypeDef,
    ByteMatchSetUpdateTypeDef,
    ByteMatchTupleTypeDef,
    CreateByteMatchSetResponseTypeDef,
    CreateGeoMatchSetResponseTypeDef,
    CreateIPSetResponseTypeDef,
    CreateRateBasedRuleResponseTypeDef,
    CreateRegexMatchSetResponseTypeDef,
    CreateRegexPatternSetResponseTypeDef,
    CreateRuleGroupResponseTypeDef,
    CreateRuleResponseTypeDef,
    CreateSizeConstraintSetResponseTypeDef,
    CreateSqlInjectionMatchSetResponseTypeDef,
    CreateWebACLMigrationStackResponseTypeDef,
    CreateWebACLResponseTypeDef,
    CreateXssMatchSetResponseTypeDef,
    DeleteByteMatchSetResponseTypeDef,
    DeleteGeoMatchSetResponseTypeDef,
    DeleteIPSetResponseTypeDef,
    DeleteRateBasedRuleResponseTypeDef,
    DeleteRegexMatchSetResponseTypeDef,
    DeleteRegexPatternSetResponseTypeDef,
    DeleteRuleGroupResponseTypeDef,
    DeleteRuleResponseTypeDef,
    DeleteSizeConstraintSetResponseTypeDef,
    DeleteSqlInjectionMatchSetResponseTypeDef,
    DeleteWebACLResponseTypeDef,
    DeleteXssMatchSetResponseTypeDef,
    ExcludedRuleTypeDef,
    FieldToMatchTypeDef,
    GeoMatchConstraintTypeDef,
    GeoMatchSetSummaryTypeDef,
    GeoMatchSetTypeDef,
    GeoMatchSetUpdateTypeDef,
    GetByteMatchSetResponseTypeDef,
    GetChangeTokenResponseTypeDef,
    GetChangeTokenStatusResponseTypeDef,
    GetGeoMatchSetResponseTypeDef,
    GetIPSetResponseTypeDef,
    GetLoggingConfigurationResponseTypeDef,
    GetPermissionPolicyResponseTypeDef,
    GetRateBasedRuleManagedKeysResponseTypeDef,
    GetRateBasedRuleResponseTypeDef,
    GetRegexMatchSetResponseTypeDef,
    GetRegexPatternSetResponseTypeDef,
    GetRuleGroupResponseTypeDef,
    GetRuleResponseTypeDef,
    GetSampledRequestsResponseTypeDef,
    GetSizeConstraintSetResponseTypeDef,
    GetSqlInjectionMatchSetResponseTypeDef,
    GetWebACLResponseTypeDef,
    GetXssMatchSetResponseTypeDef,
    HTTPHeaderTypeDef,
    HTTPRequestTypeDef,
    IPSetDescriptorTypeDef,
    IPSetSummaryTypeDef,
    IPSetTypeDef,
    IPSetUpdateTypeDef,
    ListActivatedRulesInRuleGroupResponseTypeDef,
    ListByteMatchSetsResponseTypeDef,
    ListGeoMatchSetsResponseTypeDef,
    ListIPSetsResponseTypeDef,
    ListLoggingConfigurationsResponseTypeDef,
    ListRateBasedRulesResponseTypeDef,
    ListRegexMatchSetsResponseTypeDef,
    ListRegexPatternSetsResponseTypeDef,
    ListRuleGroupsResponseTypeDef,
    ListRulesResponseTypeDef,
    ListSizeConstraintSetsResponseTypeDef,
    ListSqlInjectionMatchSetsResponseTypeDef,
    ListSubscribedRuleGroupsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListWebACLsResponseTypeDef,
    ListXssMatchSetsResponseTypeDef,
    LoggingConfigurationTypeDef,
    PaginatorConfigTypeDef,
    PredicateTypeDef,
    PutLoggingConfigurationResponseTypeDef,
    RateBasedRuleTypeDef,
    RegexMatchSetSummaryTypeDef,
    RegexMatchSetTypeDef,
    RegexMatchSetUpdateTypeDef,
    RegexMatchTupleTypeDef,
    RegexPatternSetSummaryTypeDef,
    RegexPatternSetTypeDef,
    RegexPatternSetUpdateTypeDef,
    RuleGroupSummaryTypeDef,
    RuleGroupTypeDef,
    RuleGroupUpdateTypeDef,
    RuleSummaryTypeDef,
    RuleTypeDef,
    RuleUpdateTypeDef,
    SampledHTTPRequestTypeDef,
    SizeConstraintSetSummaryTypeDef,
    SizeConstraintSetTypeDef,
    SizeConstraintSetUpdateTypeDef,
    SizeConstraintTypeDef,
    SqlInjectionMatchSetSummaryTypeDef,
    SqlInjectionMatchSetTypeDef,
    SqlInjectionMatchSetUpdateTypeDef,
    SqlInjectionMatchTupleTypeDef,
    SubscribedRuleGroupSummaryTypeDef,
    TagInfoForResourceTypeDef,
    TagTypeDef,
    TimeWindowTypeDef,
    UpdateByteMatchSetResponseTypeDef,
    UpdateGeoMatchSetResponseTypeDef,
    UpdateIPSetResponseTypeDef,
    UpdateRateBasedRuleResponseTypeDef,
    UpdateRegexMatchSetResponseTypeDef,
    UpdateRegexPatternSetResponseTypeDef,
    UpdateRuleGroupResponseTypeDef,
    UpdateRuleResponseTypeDef,
    UpdateSizeConstraintSetResponseTypeDef,
    UpdateSqlInjectionMatchSetResponseTypeDef,
    UpdateWebACLResponseTypeDef,
    UpdateXssMatchSetResponseTypeDef,
    WafActionTypeDef,
    WafOverrideActionTypeDef,
    WebACLSummaryTypeDef,
    WebACLTypeDef,
    WebACLUpdateTypeDef,
    XssMatchSetSummaryTypeDef,
    XssMatchSetTypeDef,
    XssMatchSetUpdateTypeDef,
    XssMatchTupleTypeDef,
)

def get_structure() -> ActivatedRuleTypeDef:
    return {
      ...
    }
```
