"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const r53 = require("aws-cdk-lib/aws-route53");
const s3 = require("aws-cdk-lib/aws-s3");
const _1 = require(".");
const devEnv = {
    account: process.env.CDK_DEFAULT_ACCOUNT,
    region: process.env.CDK_DEFAULT_REGION,
};
const app = new cdk.App();
const stack = new cdk.Stack(app, 'lambda-certbot-dev', { env: devEnv });
new _1.CertbotDnsRoute53Job(stack, 'Demo', {
    certbotOptions: {
        domainName: stack.node.tryGetContext('DOMAIN') ?? '*.example.com',
        email: stack.node.tryGetContext('EMAIL') ?? 'user@example.com',
        customPrefixDirectory: '/',
    },
    zone: r53.HostedZone.fromHostedZoneAttributes(stack, 'myZone', {
        zoneName: stack.node.tryGetContext('ZONENAME') ?? 'example.com',
        hostedZoneId: stack.node.tryGetContext('HOSTZONEID') ?? 'mockId',
    }),
    destinationBucket: s3.Bucket.fromBucketName(stack, 'myBucket', stack.node.tryGetContext('BUCKETNAME') ?? 'mybucket'),
    architecture: lambda.Architecture.X86_64,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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