import { Duration } from 'aws-cdk-lib';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
export interface BashExecFunctionProps {
    /**
     * The path of the shell script to be executed.
     */
    readonly script: string;
    /**
     * The path of your custom dockerfile.
     */
    readonly dockerfile?: string;
    /**
     * Lambda environment variables.
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * The function execution time (in seconds) after which Lambda terminates the function.
     * Because the execution time affects cost, set this value based on the function's expected execution time.
     * @default - Duration.seconds(60)
     * */
    readonly timeout?: Duration;
    /**
     * Custom lambda execution role.
     *
     * @default - auto generated role.
     */
    readonly role?: iam.IRole;
    /**
     * Custom lambda Image Architecture.
     *
     * @default - lambda.Architecture.X86_64
     */
    readonly architecture?: lambda.Architecture;
}
export declare class BashExecFunction extends Construct {
    readonly handler: lambda.DockerImageFunction;
    constructor(scope: Construct, id: string, props: BashExecFunctionProps);
}
