import * as events from 'aws-cdk-lib/aws-events';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as r53 from 'aws-cdk-lib/aws-route53';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
export interface CertbotOptions {
    /**
     * the domain must host on route53 like example.com.
     *
     * @example - `*.example.com` or `a.example.com` .
     */
    readonly domainName: string;
    /**
     * Email address for important account notifications.
     */
    readonly email: string;
    /**
     * Custom prefix directory on s3 bucket object path.
     * @default - `s3://YOUR_BUCKET_NAME/2021-01-01/your.domain.name/`
     *
     * @example - customPrefixDirectory: '/' -> `s3://YOUR_BUCKET_NAME/your.domain.name/`
     *
     * @example - customPrefixDirectory: 'abc' -> `s3://YOUR_BUCKET_NAME/abc/your.domain.name/`
     */
    readonly customPrefixDirectory?: string;
}
export interface CertbotDnsRoute53JobProps {
    /**
     * run the Job with defined schedule
     * @default - no shedule
     */
    readonly schedule?: events.Schedule;
    /**
     * The S3 bucket to store certificate.
     */
    readonly destinationBucket: s3.IBucket;
    /**
     * The HostZone on route53 to dns-01 challenge.
     */
    readonly zone: r53.IHostedZone;
    /**
     * certbot cmd options.
     */
    readonly certbotOptions: CertbotOptions;
    /**
     * Custom lambda Image Architecture.
     *
     * @default - lambda.Architecture.X86_64
     */
    readonly architecture?: lambda.Architecture;
}
export declare class CertbotDnsRoute53Job extends Construct {
    constructor(scope: Construct, id: string, props: CertbotDnsRoute53JobProps);
}
