"""Google address model."""

# pylint: disable=too-many-lines,line-too-long
import datetime
import logging
import zipfile
from collections import namedtuple
from typing import Any

import geocoder  # type: ignore
import pytest_is_running
import requests_cache
from pyhigh import get_elevation  # type: ignore
from timezonefinder import TimezoneFinder  # type: ignore

from ...cache import MEMORY
from ..address_model import AddressModel
from ..weather.multi_weather_model import create_mutli_weather_model

SportsballGeocodeTuple = namedtuple(
    "SportsballGeocodeTuple",
    ["city", "state", "postal", "lat", "lng", "housenumber", "country"],
)
LEVI_STADIUM = SportsballGeocodeTuple(
    city="Santa Clara",
    state="CA",
    postal="95054",
    lat=37.4033165,
    lng=-121.9719523,
    housenumber="4900",
    country="USA",
)
ARROWHEAD_STADIUM = SportsballGeocodeTuple(
    city="Kansas City",
    state="MO",
    postal="64129",
    lat=39.0489647,
    lng=-94.486589,
    housenumber="1",
    country="USA",
)
PAYCOR_STADIUM = SportsballGeocodeTuple(
    city="Cincinnati",
    state="OH",
    postal="45202",
    lat=39.0954576,
    lng=-84.5186326,
    housenumber="1",
    country="USA",
)
LUMEN_FIELD = SportsballGeocodeTuple(
    city="Seattle",
    state="WA",
    postal="98134",
    lat=47.5951518,
    lng=-122.3342143,
    housenumber="800",
    country="USA",
)
CAESARS_SUPERDOME = SportsballGeocodeTuple(
    city="New Orleans",
    state="LA",
    postal="70112",
    lat=29.951061,
    lng=-90.0838191,
    housenumber="1500",
    country="USA",
)
TOM_BENSON_HALL_OF_FAME_STADIUM = SportsballGeocodeTuple(
    city="Canton",
    state="OH",
    postal="44708",
    lat=40.8198713,
    lng=-81.4028911,
    housenumber="",
    country="USA",
)
GILETTE_STADIUM = SportsballGeocodeTuple(
    city="Foxborough",
    state="MA",
    postal="02035",
    lat=42.0909458,
    lng=-71.2669214,
    housenumber="1",
    country="USA",
)
FORD_FIELD = SportsballGeocodeTuple(
    city="Detroit",
    state="MI",
    postal="48226",
    lat=42.3400064,
    lng=-83.0481779,
    housenumber="2000",
    country="USA",
)
HARD_ROCK_STADIUM = SportsballGeocodeTuple(
    city="Miami Gardens",
    state="FL",
    postal="33056",
    lat=25.958326,
    lng=-80.2421728,
    housenumber="100",
    country="USA",
)
RAYMOND_JAMES_STADIUM = SportsballGeocodeTuple(
    city="Tampa",
    state="FL",
    postal="33607",
    lat=27.9758691,
    lng=-82.5059093,
    housenumber="4201",
    country="USA",
)
CLEVELAND_BROWNS_STADIUM = SportsballGeocodeTuple(
    city="Cleveland",
    state="OH",
    postal="44114",
    lat=41.5060535,
    lng=-81.702123,
    housenumber="100",
    country="USA",
)
STATE_FARM_STADIUM = SportsballGeocodeTuple(
    city="Glendale",
    state="AZ",
    postal="85305",
    lat=33.5276247,
    lng=-112.2651342,
    housenumber="1001",
    country="USA",
)
HIGHMARK_STADIUM = SportsballGeocodeTuple(
    city="Orchard Park",
    state="NY",
    postal="14127",
    lat=42.7737546,
    lng=-78.7895472,
    housenumber="1",
    country="USA",
)
SOLDIER_FIELD = SportsballGeocodeTuple(
    city="Chicago",
    state="IL",
    postal="60605",
    lat=41.8623132,
    lng=-87.6192633,
    housenumber="1410",
    country="USA",
)
BANK_OF_AMERICA_STADIUM = SportsballGeocodeTuple(
    city="Charlotte",
    state="NC",
    postal="28202",
    lat=35.2257795,
    lng=-80.8555399,
    housenumber="800",
    country="USA",
)
ATT_STADIUM = SportsballGeocodeTuple(
    city="Arlington",
    state="TX",
    postal="76011",
    lat=32.7479966,
    lng=-97.0959914,
    housenumber="1",
    country="USA",
)
MTT_BANK_STADIUM = SportsballGeocodeTuple(
    city="Baltimore",
    state="FL",
    postal="21230",
    lat=39.2778666,
    lng=-76.6255186,
    housenumber="101",
    country="USA",
)
SOFI_STADIUM = SportsballGeocodeTuple(
    city="Inglewood",
    state="CA",
    postal="90301",
    lat=33.9534651,
    lng=-118.3416145,
    housenumber="1001",
    country="USA",
)
ALLEGIANT_STADIUM = SportsballGeocodeTuple(
    city="Las Vegas",
    state="NV",
    postal="89118",
    lat=36.0908665,
    lng=-115.1858971,
    housenumber="3333",
    country="USA",
)
LINCOLN_FINANCIAL_FIELD = SportsballGeocodeTuple(
    city="Philadelphia",
    state="PA",
    postal="19148",
    lat=39.9013695,
    lng=-75.1700964,
    housenumber="",
    country="USA",
)
METLIFE_STADIUM = SportsballGeocodeTuple(
    city="East Rutherford",
    state="NJ",
    postal="07073",
    lat=40.8135064,
    lng=-74.0770319,
    housenumber="1",
    country="USA",
)
MERCEDES_BANZ_STADIUM = SportsballGeocodeTuple(
    city="Atlanta",
    state="GA",
    postal="30313",
    lat=33.7553232,
    lng=-84.4031654,
    housenumber="1",
    country="USA",
)
NRG_STADIUM = SportsballGeocodeTuple(
    city="Houston",
    state="TX",
    postal="77054",
    lat=29.6847219,
    lng=-95.4132823,
    housenumber="",
    country="USA",
)
ACRISURE_STADIUM = SportsballGeocodeTuple(
    city="Pittsburgh",
    state="PA",
    postal="15212",
    lat=40.4467648,
    lng=-80.0183352,
    housenumber="100",
    country="USA",
)
LUCAS_OIL_STADIUM = SportsballGeocodeTuple(
    city="Indianapolis",
    state="IN",
    postal="46225",
    lat=39.7601007,
    lng=-86.1664626,
    housenumber="500",
    country="USA",
)
LAMBEAU_FIELD = SportsballGeocodeTuple(
    city="Green Bay",
    state="WI",
    postal="54304",
    lat=44.5013406,
    lng=-88.0647832,
    housenumber="1265",
    country="USA",
)
US_BANK_STADIUM = SportsballGeocodeTuple(
    city="Minneapolis",
    state="MN",
    postal="55415",
    lat=44.9736461,
    lng=-93.2600694,
    housenumber="401",
    country="USA",
)
FEDEX_FIELD = SportsballGeocodeTuple(
    city="Landover",
    state="MD",
    postal="20785",
    lat=38.9081324,
    lng=-76.8665633,
    housenumber="1600",
    country="USA",
)
NISSAN_STADIUM = SportsballGeocodeTuple(
    city="Nashville",
    state="TN",
    postal="37213",
    lat=36.166469,
    lng=-86.7738744,
    housenumber="1",
    country="USA",
)
EVERBANK_STADIUM = SportsballGeocodeTuple(
    city="Jacksonville",
    state="FL",
    postal="32202",
    lat=30.3239099,
    lng=-81.6399246,
    housenumber="1",
    country="USA",
)
EMPOWER_FIELD = SportsballGeocodeTuple(
    city="Denver",
    state="CO",
    postal="80204",
    lat=39.7438895,
    lng=-105.0226843,
    housenumber="1701",
    country="USA",
)
WEMBLEY_STADIUM = SportsballGeocodeTuple(
    city="Wembley",
    state="",
    postal="HA9 0WS",
    lat=51.5560247,
    lng=-0.2821926,
    housenumber="",
    country="UK",
)
TOTTENHAM_HOTSPURS_STADIUM = SportsballGeocodeTuple(
    city="London",
    state="",
    postal="N17 0BX",
    lat=51.6042204,
    lng=-0.071094,
    housenumber="782",
    country="UK",
)
DEUTSCHE_BANK_PARK = SportsballGeocodeTuple(
    city="Frankfurt am Main",
    state="",
    postal="60528",
    lat=50.0685807,
    lng=8.6428971,
    housenumber="362",
    country="Germany",
)
ALLIANZ_ARENA = SportsballGeocodeTuple(
    city="München",
    state="",
    postal="80939",
    lat=48.2187966,
    lng=11.6221325,
    housenumber="25",
    country="Germany",
)
GEORGIA_DOME = SportsballGeocodeTuple(
    city="Atlanta",
    state="GA",
    postal="",
    lat=33.758,
    lng=-84.401,
    housenumber="1",
    country="USA",
)
TRANS_WORLD_DOME = SportsballGeocodeTuple(
    city="St. Louis",
    state="MO",
    postal="63101",
    lat=38.6328232,
    lng=-90.1910817,
    housenumber="701",
    country="USA",
)
CANDLESTICK_PARK = SportsballGeocodeTuple(
    city="San Francisco",
    state="CA",
    postal="94124",
    lat=37.7129826,
    lng=-122.4064101,
    housenumber="",
    country="USA",
)
SILVERDOME = SportsballGeocodeTuple(
    city="Pontiac",
    state="MI",
    postal="48342",
    lat=42.6456689,
    lng=-83.2572144,
    housenumber="",
    country="USA",
)
TEXAS_STADIUM = SportsballGeocodeTuple(
    city="Irving",
    state="TX",
    postal="",
    lat=32.839722,
    lng=-96.9146954,
    housenumber="",
    country="USA",
)
SDCCU_STADIUM = SportsballGeocodeTuple(
    city="San Diego",
    state="CA",
    postal="92108",
    lat=32.7809825,
    lng=-117.1244523,
    housenumber="9449",
    country="USA",
)
MOUNTAIN_AMERICA_STADIUM = SportsballGeocodeTuple(
    city="Tempe",
    state="AZ",
    postal="85287",
    lat=33.4264574,
    lng=-111.9374442,
    housenumber="500",
    country="USA",
)
LOS_ANGELES_MEMORIAL_COLESIUM = SportsballGeocodeTuple(
    city="Los Angeles",
    state="CA",
    postal="90037",
    lat=34.0136647,
    lng=-118.2904104,
    housenumber="3911",
    country="USA",
)
KEZAR_STADIUM = SportsballGeocodeTuple(
    city="San Francisco",
    state="CA",
    postal="94118",
    lat=37.7669182,
    lng=-122.4567445,
    housenumber="670",
    country="USA",
)
CITY_STADIUM = SportsballGeocodeTuple(
    city="Green Bay",
    state="WI",
    postal="54301",
    lat=44.5076658,
    lng=-87.9975486,
    housenumber="1500",
    country="USA",
)
COTTON_BOWL = SportsballGeocodeTuple(
    city="Dallas",
    state="TX",
    postal="75215",
    lat=32.7796106,
    lng=-96.7602328,
    housenumber="3750",
    country="USA",
)
WRIGLEY_FIELD = SportsballGeocodeTuple(
    city="Chicago",
    state="IL",
    postal="60613",
    lat=41.9484384,
    lng=-87.6579076,
    housenumber="1060",
    country="USA",
)
YANKEE_STADIUM = SportsballGeocodeTuple(
    city="Bronx",
    state="NY",
    postal="10451",
    lat=40.8296425,
    lng=-73.9310454,
    housenumber="1",
    country="USA",
)
TIGER_STADIUM = SportsballGeocodeTuple(
    city="Baton Rouge",
    state="LA",
    postal="70803",
    lat=30.412035,
    lng=-91.1863912,
    housenumber="",
    country="USA",
)
RFK_STADIUM = SportsballGeocodeTuple(
    city="Washington",
    state="DC",
    postal="20003",
    lat=38.8898525,
    lng=-76.9731573,
    housenumber="2400",
    country="USA",
)
WAR_MEMORIAL_STADIUM = SportsballGeocodeTuple(
    city="Little Rock",
    state="AR",
    postal="72205",
    lat=34.749861,
    lng=-92.3314143,
    housenumber="",
    country="USA",
)
SHEA_STADIUM = SportsballGeocodeTuple(
    city="Flushing",
    state="NY",
    postal="11368",
    lat=40.7570861,
    lng=-73.8653052,
    housenumber="41",
    country="USA",
)
MUNICIPAL_STADIUM = SportsballGeocodeTuple(
    city="Kansas City",
    state="MS",
    postal="",
    lat=39.087,
    lng=-94.558,
    housenumber="2123",
    country="USA",
)
YALE_BOWL = SportsballGeocodeTuple(
    city="New Haven",
    state="CT",
    postal="06515",
    lat=41.3132191,
    lng=-72.9630891,
    housenumber="81",
    country="USA",
)
RICE_STADIUM = SportsballGeocodeTuple(
    city="Houston",
    state="TX",
    postal="77005",
    lat=29.7162887,
    lng=-95.41188622,
    housenumber="6100",
    country="USA",
)
ROSE_BOWL = SportsballGeocodeTuple(
    city="Pasadena",
    state="CA",
    postal="91103",
    lat=34.1613284,
    lng=-118.1702211,
    housenumber="1001",
    country="USA",
)
MILWAUKEE_COUNTY_STADIUM = SportsballGeocodeTuple(
    city="Milwaukee",
    state="WI",
    postal="53208",
    lat=43.0303919,
    lng=-87.9787396,
    housenumber="201",
    country="USA",
)
STANFORD_STADIUM = SportsballGeocodeTuple(
    city="Stanford",
    state="CA",
    postal="94305",
    lat=37.4345298,
    lng=-122.1636976,
    housenumber="625",
    country="USA",
)
LIBERTY_BOWL_MEMORIAL_STADIUM = SportsballGeocodeTuple(
    city="Memphis",
    state="TN",
    postal="38119",
    lat=35.1213707,
    lng=-89.9969239,
    housenumber="959",
    country="USA",
)
NEO_QUIMICA_ARENA = SportsballGeocodeTuple(
    city="São Paulo",
    state="SP",
    postal="08295-005",
    lat=-23.5453134,
    lng=-46.4768041,
    housenumber="111",
    country="Brazil",
)
MCG = SportsballGeocodeTuple(
    city="Richmond",
    state="VIC",
    postal="3002",
    lat=-37.8199668,
    lng=144.9785784,
    housenumber="",
    country="USA",
)
SCG = SportsballGeocodeTuple(
    city="Moore Park",
    state="NSW",
    postal="2021",
    lat=-33.8915316,
    lng=151.2248515,
    housenumber="",
    country="Australia",
)
ENGIE_STADIUM = SportsballGeocodeTuple(
    city="Sydney Olympic Park",
    state="NSW",
    postal="2127",
    lat=-33.8471156,
    lng=151.0608386,
    housenumber="",
    country="Australia",
)
ADELAIDE_OVAL = SportsballGeocodeTuple(
    city="North Adelaide",
    state="SA",
    postal="5006",
    lat=-34.9156273,
    lng=138.5914356,
    housenumber="70",
    country="Australia",
)
GABBA = SportsballGeocodeTuple(
    city="Woolloongabba",
    state="QLD",
    postal="4102",
    lat=-27.4858375,
    lng=153.0332144,
    housenumber="",
    country="Australia",
)
OPTUS_STADIUM = SportsballGeocodeTuple(
    city="Burswood",
    state="WA",
    postal="6100",
    lat=-31.9511597,
    lng=115.884175,
    housenumber="333",
    country="Australia",
)
MARVEL_STADIUM = SportsballGeocodeTuple(
    city="Docklands",
    state="VIC",
    postal="3008",
    lat=-37.8165647,
    lng=144.9449306,
    housenumber="740",
    country="Australia",
)
MARS_STADIUM = SportsballGeocodeTuple(
    city="Wendouree",
    state="VIC",
    postal="3355",
    lat=-37.5386166,
    lng=143.8273839,
    housenumber="725",
    country="Australia",
)
GMHBA_STADIUM = SportsballGeocodeTuple(
    city="South Geelong",
    state="VIC",
    postal="3220",
    lat=-38.1579979,
    lng=144.3520981,
    housenumber="370",
    country="Australia",
)
UTAS_STADIUM = SportsballGeocodeTuple(
    city="Invermay",
    state="TAS",
    postal="7248",
    lat=-41.4259371,
    lng=147.137879,
    housenumber="2",
    country="Australia",
)
PEOPLE_FIRST_STADIUM = SportsballGeocodeTuple(
    city="Carrara",
    state="QLD",
    postal="4211",
    lat=-28.0063039,
    lng=153.3645259,
    housenumber="",
    country="Australia",
)
BLUNDSTONE_ARENA = SportsballGeocodeTuple(
    city="Bellerive",
    state="TAS",
    postal="7018",
    lat=-42.8772962,
    lng=147.3691419,
    housenumber="15",
    country="Australia",
)
MANUKA_OVAL = SportsballGeocodeTuple(
    city="Griffith",
    state="ACT",
    postal="2603",
    lat=-35.3181329,
    lng=149.1297911,
    housenumber="",
    country="Australia",
)
TIO_STADIUM = SportsballGeocodeTuple(
    city="Marrara",
    state="NT",
    postal="0812",
    lat=-12.3991939,
    lng=130.8847367,
    housenumber="70",
    country="Australia",
)
NORWOOD_OVAL = SportsballGeocodeTuple(
    city="Norwood",
    state="SA",
    postal="5067",
    lat=-34.9198089,
    lng=138.6278735,
    housenumber="",
    country="Australia",
)
ADELAIDE_HILLS = SportsballGeocodeTuple(
    city="Mount Barker Summit",
    state="SA",
    postal="5251",
    lat=-35.0779754,
    lng=138.8908443,
    housenumber="304",
    country="Australia",
)
TRAEGER_PARK = SportsballGeocodeTuple(
    city="The Gap",
    state="NT",
    postal="0870",
    lat=-23.7090566,
    lng=133.8701488,
    housenumber="",
    country="Australia",
)
CAZALYS_STADIUM = SportsballGeocodeTuple(
    city="Westcourt",
    state="QLD",
    postal="4870",
    lat=-16.9357343,
    lng=145.7464957,
    housenumber="",
    country="Australia",
)
RIVERWAY_STADIUM = SportsballGeocodeTuple(
    city="Thuringowa Central",
    state="QLD",
    postal="4817",
    lat=-19.3176321,
    lng=146.7270047,
    housenumber="",
    country="Australia",
)
JIANGWAN_STADIUM = SportsballGeocodeTuple(
    city="Shanghai",
    state="",
    postal="200433",
    lat=31.3076026,
    lng=121.5160351,
    housenumber="",
    country="China",
)
DOMAIN_STADIUM = SportsballGeocodeTuple(
    city="Subiaco",
    state="WA",
    postal="6008",
    lat=-31.9444594,
    lng=115.8285952,
    housenumber="304",
    country="Australia",
)
WESTPAC_STADIUM = SportsballGeocodeTuple(
    city="Pipitea",
    state="",
    postal="6140",
    lat=-41.2729198,
    lng=174.7846279,
    housenumber="105",
    country="New Zealand",
)
AAMI_STADIUM = SportsballGeocodeTuple(
    city="West Lakes",
    state="SA",
    postal="5021",
    lat=-34.8797138,
    lng=138.4910204,
    housenumber="",
    country="Australia",
)
BLACKTOWN_PARK = SportsballGeocodeTuple(
    city="Rooty Hill",
    state="NSW",
    postal="2766",
    lat=-33.7695492,
    lng=150.8558658,
    housenumber="",
    country="Australia",
)
PITBULL_STADIUM = SportsballGeocodeTuple(
    city="Miami",
    state="FL",
    postal="33199",
    lat=25.7525,
    lng=-80.377778,
    housenumber="11200",
    country="USA",
)
LANNY_AND_SHARON_MARTIN_STADIUM = SportsballGeocodeTuple(
    city="Evanston",
    state="IL",
    postal="60208",
    lat=42.0584293,
    lng=-87.6707798,
    housenumber="2235",
    country="USA",
)
MIAMI_ORANGE_BOWL = SportsballGeocodeTuple(
    city="Miami",
    state="FL",
    postal="33125",
    lat=25.7781487,
    lng=-80.2221747,
    housenumber="501",
    country="USA",
)
SPECTRUM = SportsballGeocodeTuple(
    city="Philadelphia",
    state="PA",
    postal="",
    lat=39.901111,
    lng=-75.171944,
    housenumber="3601",
    country="USA",
)
MADISON_SQUARE_GARDEN = SportsballGeocodeTuple(
    city="New York",
    state="NY",
    postal="",
    lat=40.750556,
    lng=-73.993611,
    housenumber="4",
    country="USA",
)
MILWAUKEE_ARENA = SportsballGeocodeTuple(
    city="Milwaukee",
    state="WI",
    postal="",
    lat=43.042222,
    lng=-87.916944,
    housenumber="400",
    country="USA",
)
THE_FORUM = SportsballGeocodeTuple(
    city="Inglewood",
    state="CA",
    postal="",
    lat=33.958333,
    lng=-118.341667,
    housenumber="3900",
    country="USA",
)
AMERICA_WEST_ARENA = SportsballGeocodeTuple(
    city="Phoenix",
    state="AZ",
    postal="",
    lat=33.445833,
    lng=-112.071389,
    housenumber="201",
    country="USA",
)
ALAMODOME = SportsballGeocodeTuple(
    city="San Antonio",
    state="TX",
    postal="78203",
    lat=29.416944,
    lng=-98.478889,
    housenumber="100",
    country="USA",
)
AMERICAN_AIRLINES_ARENA = SportsballGeocodeTuple(
    city="Dallas",
    state="TX",
    postal="",
    lat=32.790556,
    lng=-96.810278,
    housenumber="2500",
    country="USA",
)
THOMAS_AND_MACK_CENTER = SportsballGeocodeTuple(
    city="Las Vegas",
    state="NV",
    postal="",
    lat=36.105,
    lng=-115.144167,
    housenumber="4505",
    country="USA",
)
ORLANDO_ARENA = SportsballGeocodeTuple(
    city="Orlando",
    state="FL",
    postal="32801",
    lat=28.548889,
    lng=-81.386667,
    housenumber="600",
    country="USA",
)
TD_GARDEN = SportsballGeocodeTuple(
    city="Boston",
    state="MA",
    postal="",
    lat=42.366303,
    lng=-71.062228,
    housenumber="100",
    country="USA",
)
STATE_FARM_ARENA = SportsballGeocodeTuple(
    city="Atlanta",
    state="GA",
    postal="",
    lat=33.757222,
    lng=-84.396389,
    housenumber="1",
    country="USA",
)
PEPSI_CENTRE = SportsballGeocodeTuple(
    city="Denver",
    state="CO",
    postal="",
    lat=39.748611,
    lng=-105.0075,
    housenumber="1000",
    country="USA",
)
GAINBRIDGE_FIELDHOUSE = SportsballGeocodeTuple(
    city="Indianapolis",
    state="IN",
    postal="",
    lat=39.763889,
    lng=-86.155556,
    housenumber="125",
    country="USA",
)
FISERV_FORUM = SportsballGeocodeTuple(
    city="Milwaukee",
    state="WI",
    postal="",
    lat=43.045028,
    lng=-87.918167,
    housenumber="1111",
    country="USA",
)
STAPLES_CENTRE = SportsballGeocodeTuple(
    city="Los Angeles",
    state="CA",
    postal="90015",
    lat=34.0429909,
    lng=-118.2673753,
    housenumber="1111",
    country="USA",
)
UNITED_CENTER = SportsballGeocodeTuple(
    city="Chicago",
    state="IL",
    postal="",
    lat=41.880556,
    lng=-87.674167,
    housenumber="1901",
    country="USA",
)
FEDEX_FORUM = SportsballGeocodeTuple(
    city="Memphis",
    state="TN",
    postal="",
    lat=35.138333,
    lng=-90.050556,
    housenumber="191",
    country="USA",
)
TARGET_CENTER = SportsballGeocodeTuple(
    city="Minneapolis",
    state="MN",
    postal="",
    lat=44.979444,
    lng=-93.276111,
    housenumber="600",
    country="USA",
)
GOLDEN_1_CENTER = SportsballGeocodeTuple(
    city="Sacramento",
    state="CA",
    postal="",
    lat=38.580361,
    lng=-121.499611,
    housenumber="500",
    country="USA",
)
DELTA_CENTER = SportsballGeocodeTuple(
    city="Salt Lake City",
    state="UT",
    postal="",
    lat=40.768333,
    lng=-111.901111,
    housenumber="301",
    country="USA",
)
ATT_CENTER = SportsballGeocodeTuple(
    city="San Antonio",
    state="TX",
    postal="",
    lat=29.426944,
    lng=-98.4375,
    housenumber="1",
    country="USA",
)
FTX_ARENA = SportsballGeocodeTuple(
    city="Miami",
    state="FL",
    postal="",
    lat=25.781389,
    lng=-80.188056,
    housenumber="601",
    country="USA",
)
VIVINT_ARENA = SportsballGeocodeTuple(
    city="Salt Lake City",
    state="UT",
    postal="",
    lat=40.768333,
    lng=-111.901111,
    housenumber="301",
    country="USA",
)
CHESAPEAKE_ENERGY_ARENA = SportsballGeocodeTuple(
    city="Oklahoma City",
    state="OK",
    postal="",
    lat=35.463333,
    lng=-97.515,
    housenumber="100",
    country="USA",
)
ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX = SportsballGeocodeTuple(
    city="Lake Buena Vista",
    state="FL",
    postal="32830",
    lat=28.337083,
    lng=-81.556,
    housenumber="1375",
    country="USA",
)
QUICKEN_LOANS_ARENA = SportsballGeocodeTuple(
    city="Cleveland",
    state="OH",
    postal="",
    lat=41.496389,
    lng=-81.688056,
    housenumber="1",
    country="USA",
)
KASEYA_CENTER = SportsballGeocodeTuple(
    city="Miami",
    state="FL",
    postal="",
    lat=25.781389,
    lng=-80.188056,
    housenumber="601",
    country="USA",
)
DUNN_OLIVER_ACADOME = SportsballGeocodeTuple(
    city="Montgomery",
    state="AL",
    postal="",
    lat=32.36185,
    lng=-86.293158,
    housenumber="",
    country="USA",
)
OAKLAND_ARENA = SportsballGeocodeTuple(
    city="Oakland",
    state="CA",
    postal="",
    lat=37.750278,
    lng=-122.203056,
    housenumber="7000",
    country="USA",
)
SCOTIABANK_ARENA = SportsballGeocodeTuple(
    city="Toronto",
    state="ON",
    postal="",
    lat=43.643333,
    lng=-79.379167,
    housenumber="40",
    country="Canada",
)
BRADLEY_CENTER = SportsballGeocodeTuple(
    city="Milwaukee",
    state="WI",
    postal="",
    lat=43.043611,
    lng=-87.916944,
    housenumber="1001",
    country="USA",
)
THE_PIT = SportsballGeocodeTuple(
    city="Albuquerque",
    state="NM",
    postal="",
    lat=35.067,
    lng=-106.632,
    housenumber="",
    country="USA",
)
JOHN_GLASER_ARENA = SportsballGeocodeTuple(
    city="Philadelphia",
    state="PA",
    postal="19141",
    lat=40.039993,
    lng=-75.15654,
    housenumber="15",
    country="USA",
)
TEXAS_AM_COMMERCE_FIELD_HOUSE = SportsballGeocodeTuple(
    city="Commerce",
    state="TX",
    postal="75428",
    lat=33.245337,
    lng=-95.907619,
    housenumber="2600",
    country="USA",
)
WISDOM_GYM = SportsballGeocodeTuple(
    city="Stephenville",
    state="TX",
    postal="",
    lat=32.215438,
    lng=-98.220617,
    housenumber="",
    country="USA",
)
ROSE_HILL_GYM = SportsballGeocodeTuple(
    city="Bronx",
    state="NY",
    postal="10458",
    lat=40.862148,
    lng=-73.883824,
    housenumber="",
    country="USA",
)
JOSEPH_J_GENTILES_CENTER = SportsballGeocodeTuple(
    city="Chicago",
    state="IL",
    postal="60626",
    lat=42.000556,
    lng=-87.658889,
    housenumber="6525",
    country="USA",
)
SAVAGE_ARENA = SportsballGeocodeTuple(
    city="Toledo",
    state="OH",
    postal="43606",
    lat=41.660232,
    lng=-83.609795,
    housenumber="2025",
    country="USA",
)
MCDOUGALD_MCLENON_ARENA = SportsballGeocodeTuple(
    city="Durham",
    state="NC",
    postal="27707",
    lat=35.975884,
    lng=-78.897745,
    housenumber="1801",
    country="USA",
)
ATHELTICS_CENTER_ORENA = SportsballGeocodeTuple(
    city="Rochester",
    state="MI",
    postal="",
    lat=42.673972,
    lng=-83.213158,
    housenumber="",
    country="USA",
)
NUTTER_CENTER = SportsballGeocodeTuple(
    city="Dayton",
    state="OH",
    postal="",
    lat=39.781944,
    lng=-84.0525,
    housenumber="3640",
    country="USA",
)
COLONIAL_LIFE_ARENA = SportsballGeocodeTuple(
    city="Columbia",
    state="SC",
    postal="",
    lat=33.995,
    lng=-81.037222,
    housenumber="801",
    country="USA",
)
JAMES_H_HILTON_COLISEUM = SportsballGeocodeTuple(
    city="Ames",
    state="IA",
    postal="50010",
    lat=42.02101,
    lng=-93.634763,
    housenumber="",
    country="USA",
)
BRESLIN_EVENTS_CENTER = SportsballGeocodeTuple(
    city="East Lansing",
    state="MI",
    postal="48824",
    lat=42.728227,
    lng=-84.492396,
    housenumber="534",
    country="USA",
)
CHASE_ATHLETIC_CENTER = SportsballGeocodeTuple(
    city="Cleveland",
    state="OH",
    postal="",
    lat=41.499167,
    lng=-81.694722,
    housenumber="",
    country="USA",
)
MURPHY_ATHELTIC_CENTER = SportsballGeocodeTuple(
    city="Murfreesboro",
    state="TN",
    postal="37132",
    lat=35.852467,
    lng=-86.369803,
    housenumber="2650",
    country="USA",
)
STEPHEN_C_OCONNELL_CENTER = SportsballGeocodeTuple(
    city="Gainesville",
    state="FL",
    postal="32611",
    lat=29.649444,
    lng=-82.351111,
    housenumber="250",
    country="USA",
)
F_G_CLARK_ACTIVITY_CENTER = SportsballGeocodeTuple(
    city="Baton Rouge",
    state="LA",
    postal="",
    lat=30.521667,
    lng=-91.185556,
    housenumber="",
    country="USA",
)
KSU_CONVOCATION_CENTER = SportsballGeocodeTuple(
    city="Kennesaw",
    state="GA",
    postal="30144",
    lat=34.036924,
    lng=-84.580329,
    housenumber="590",
    country="USA",
)
WALKUP_SKYDOME = SportsballGeocodeTuple(
    city="Flagstaff",
    state="AZ",
    postal="",
    lat=35.1805,
    lng=-111.6525,
    housenumber="",
    country="USA",
)
DAHLBERG_ARENA = SportsballGeocodeTuple(
    city="Missoula",
    state="MT",
    postal="",
    lat=46.864,
    lng=-113.983,
    housenumber="32",
    country="USA",
)
GREAT_SOUTHERN_BANK_ARENA = SportsballGeocodeTuple(
    city="Springfield",
    state="MO",
    postal="65897",
    lat=37.2021052,
    lng=-93.2855636,
    housenumber="685",
    country="USA",
)
MCCANN_ARENA = SportsballGeocodeTuple(
    city="Poughkeepsie",
    state="NY",
    postal="",
    lat=41.718431,
    lng=-73.934,
    housenumber="",
    country="USA",
)
COLEMAN_COLISEUM = SportsballGeocodeTuple(
    city="Tuscaloosa",
    state="AL",
    postal="35487",
    lat=33.202939,
    lng=-87.539706,
    housenumber="1201",
    country="USA",
)
ROSS_E_TEMPLETON_CENTER = SportsballGeocodeTuple(
    city="Clinton",
    state="SC",
    postal="29325",
    lat=34.465,
    lng=-81.869,
    housenumber="503",
    country="USA",
)
LEVIEN_GYM = SportsballGeocodeTuple(
    city="New York",
    state="NY",
    postal="",
    lat=40.80979,
    lng=-73.961715,
    housenumber="3030",
    country="USA",
)
CRISLER_CENTER = SportsballGeocodeTuple(
    city="Ann Arbor",
    state="MI",
    postal="48104",
    lat=42.265037,
    lng=-83.746768,
    housenumber="333",
    country="USA",
)
HYNES_ATHELTIC_CENTER = SportsballGeocodeTuple(
    city="New Rochelle",
    state="NY",
    postal="",
    lat=40.92664,
    lng=-73.784325,
    housenumber="",
    country="USA",
)
OLE_MISS = SportsballGeocodeTuple(
    city="Oxford",
    state="MS",
    postal="38677",
    lat=34.363164,
    lng=-89.535453,
    housenumber="",
    country="USA",
)
HOLMES_CENTER = SportsballGeocodeTuple(
    city="Boone",
    state="NC",
    postal="28608",
    lat=36.210624,
    lng=-81.675952,
    housenumber="111",
    country="USA",
)
FARRIS_CENTER = SportsballGeocodeTuple(
    city="Conway",
    state="AR",
    postal="",
    lat=35.081667,
    lng=-92.459444,
    housenumber="",
    country="USA",
)
HTC_CENTER = SportsballGeocodeTuple(
    city="Conway",
    state="SC",
    postal="29579",
    lat=33.799167,
    lng=-79.015556,
    housenumber="104",
    country="USA",
)
GERSTEN_PAVILION = SportsballGeocodeTuple(
    city="Los Angeles",
    state="CA",
    postal="90045",
    lat=33.9675,
    lng=-118.415556,
    housenumber="1",
    country="USA",
)
BOGOTA_SAVINGS_BANK_CENTER = SportsballGeocodeTuple(
    city="Teaneck",
    state="NJ",
    postal="07601",
    lat=40.8967,
    lng=-74.0324,
    housenumber="",
    country="USA",
)
CORBETT_SPORTS_CENTER = SportsballGeocodeTuple(
    city="Greensboro",
    state="NC",
    postal="27411",
    lat=36.076783,
    lng=-79.768849,
    housenumber="1601",
    country="USA",
)
EA_DIDDLE_ARENA = SportsballGeocodeTuple(
    city="Bowling Green",
    state="KY",
    postal="42101",
    lat=36.985833,
    lng=-86.4575,
    housenumber="1526",
    country="USA",
)
JMA_WIRELESS_DOME = SportsballGeocodeTuple(
    city="Syracuse",
    state="NY",
    postal="13244",
    lat=43.036111,
    lng=-76.136389,
    housenumber="900",
    country="USA",
)
AG_SPANOS_CENTER = SportsballGeocodeTuple(
    city="Stockton",
    state="CA",
    postal="95211",
    lat=37.976669,
    lng=-121.315095,
    housenumber="1178",
    country="USA",
)
WAR_MEMORIAL_GYMNASIUM = SportsballGeocodeTuple(
    city="San Francisco",
    state="CA",
    postal="94118",
    lat=37.776944,
    lng=-122.449444,
    housenumber="2335",
    country="USA",
)
HENDERSON_CENTER = SportsballGeocodeTuple(
    city="Huntington",
    state="WV",
    postal="25755",
    lat=38.424517,
    lng=-82.425211,
    housenumber="",
    country="USA",
)
TED_CONSTANT_CONVOCATION_CENTER = SportsballGeocodeTuple(
    city="Norfolk",
    state="VA",
    postal="",
    lat=36.884169,
    lng=-76.301231,
    housenumber="4320",
    country="USA",
)
STONY_BROOK_ARENA = SportsballGeocodeTuple(
    city="Stony Brook",
    state="NY",
    postal="11790",
    lat=40.91741,
    lng=-73.125955,
    housenumber="100",
    country="USA",
)
SPECTRUM_CENTRE = SportsballGeocodeTuple(
    city="Charlotte",
    state="NC",
    postal="",
    lat=35.225,
    lng=-80.839167,
    housenumber="333",
    country="USA",
)
CAPITAL_ONE_ARENA = SportsballGeocodeTuple(
    city="Washington",
    state="DC",
    postal="",
    lat=38.898056,
    lng=-77.020833,
    housenumber="601",
    country="USA",
)
BARCLAYS_CENTER = SportsballGeocodeTuple(
    city="Brooklyn",
    state="NY",
    postal="",
    lat=40.682661,
    lng=-73.975225,
    housenumber="620",
    country="USA",
)
LITTLE_CAESARS_ARENA = SportsballGeocodeTuple(
    city="Detroit",
    state="MI",
    postal="",
    lat=42.341111,
    lng=-83.055,
    housenumber="2645",
    country="USA",
)
PAYCOM_CENTRE = SportsballGeocodeTuple(
    city="Oklahoma City",
    state="OK",
    postal="",
    lat=35.463333,
    lng=-97.515,
    housenumber="100",
    country="USA",
)
KIA_CENTER = SportsballGeocodeTuple(
    city="Orlando",
    state="FL",
    postal="",
    lat=28.539167,
    lng=-81.383611,
    housenumber="400",
    country="USA",
)
INTUIT_DOME = SportsballGeocodeTuple(
    city="Inglewood",
    state="CA",
    postal="",
    lat=33.9451,
    lng=-118.3431,
    housenumber="3930",
    country="USA",
)
MODA_CENTER = SportsballGeocodeTuple(
    city="Portland",
    state="OR",
    postal="",
    lat=45.531667,
    lng=-122.666667,
    housenumber="1",
    country="USA",
)
TOYOTA_CENTRE = SportsballGeocodeTuple(
    city="Houston",
    state="TX",
    postal="",
    lat=29.750833,
    lng=-95.362222,
    housenumber="1510",
    country="USA",
)
ROCKET_MORTGAGE_FIELDHOUSE = SportsballGeocodeTuple(
    city="Cleveland",
    state="OH",
    postal="",
    lat=41.496389,
    lng=-81.688056,
    housenumber="1",
    country="USA",
)
CHASE_CENTER = SportsballGeocodeTuple(
    city="San Francisco",
    state="CA",
    postal="",
    lat=37.768056,
    lng=-122.3875,
    housenumber="1",
    country="USA",
)
FROST_BANK_CENTER = SportsballGeocodeTuple(
    city="San Antonio",
    state="TX",
    postal="",
    lat=29.426944,
    lng=-98.4375,
    housenumber="1",
    country="USA",
)
ACCOR_ARENA = SportsballGeocodeTuple(
    city="Paris",
    state="Ile-de-France",
    postal="",
    lat=48.838611,
    lng=2.378611,
    housenumber="8",
    country="France",
)
ARCO_ARENA = SportsballGeocodeTuple(
    city="Sacramento",
    state="CA",
    postal="",
    lat=38.649167,
    lng=-121.518056,
    housenumber="1",
    country="USA",
)
STAN_SHERIFF_CENTER = SportsballGeocodeTuple(
    city="Honolulu",
    state="HI",
    postal="96822-2312",
    lat=21.294167,
    lng=-157.818889,
    housenumber="1355",
    country="USA",
)
CLIMATE_PLEDGE_ARENA = SportsballGeocodeTuple(
    city="Seattle",
    state="WA",
    postal="",
    lat=47.622,
    lng=-122.354,
    housenumber="334",
    country="USA",
)
THE_PALACE_OF_AUBURN_HILLS = SportsballGeocodeTuple(
    city="Auburn Hills",
    state="MI",
    postal="",
    lat=42.696944,
    lng=-83.245556,
    housenumber="6",
    country="USA",
)
STATE_FARM_FIELDHOUSE = SportsballGeocodeTuple(
    city="Lake Buena Vista",
    state="FL",
    postal="",
    lat=28.337083,
    lng=-81.556,
    housenumber="",
    country="USA",
)
AMALIE_ARENA = SportsballGeocodeTuple(
    city="Tampa",
    state="FL",
    postal="",
    lat=27.942778,
    lng=-82.451944,
    housenumber="401",
    country="USA",
)
TOYOTA_STADIUM = SportsballGeocodeTuple(
    city="Frisco",
    state="TX",
    postal="75033",
    lat=33.154444,
    lng=-96.835278,
    housenumber="9200",
    country="USA",
)
MOODY_CENTER = SportsballGeocodeTuple(
    city="Austin",
    state="TX",
    postal="",
    lat=30.280972,
    lng=-97.730472,
    housenumber="2001",
    country="USA",
)
JERSEY_MIKES_ARENA = SportsballGeocodeTuple(
    city="New Brunswick",
    state="NJ",
    postal="08854",
    lat=40.525278,
    lng=-74.441111,
    housenumber="83",
    country="USA",
)
GSU_CONVOCATION_CENTER = SportsballGeocodeTuple(
    city="Atlanta",
    state="GA",
    postal="30312",
    lat=33.7427,
    lng=-84.38869,
    housenumber="455",
    country="USA",
)
O2_ARENA = SportsballGeocodeTuple(
    city="London",
    state="",
    postal="SE10",
    lat=51.5029,
    lng=0.0032,
    housenumber="",
    country="UK",
)
IMPERIAL_ARENA = SportsballGeocodeTuple(
    city="Nassau",
    state="",
    postal="",
    lat=25.0836,
    lng=-77.318,
    housenumber="1",
    country="Bahamas",
)
PPG_PAINTS_ARENA = SportsballGeocodeTuple(
    city="Pittsburgh",
    state="PA",
    postal="",
    lat=40.439444,
    lng=-79.989167,
    housenumber="1001",
    country="USA",
)
TRUIST_ARENA = SportsballGeocodeTuple(
    city="Highland Heights",
    state="KT",
    postal="41099",
    lat=39.032273,
    lng=-84.458864,
    housenumber="500",
    country="USA",
)
ENTERPRISE_CENTER = SportsballGeocodeTuple(
    city="St. Louis",
    state="MO",
    postal="",
    lat=38.626667,
    lng=-90.2025,
    housenumber="1401",
    country="USA",
)
HARRAHS_CHEROKEE_CENTER = SportsballGeocodeTuple(
    city="Asheville",
    state="NC",
    postal="",
    lat=35.597547,
    lng=-82.555384,
    housenumber="87",
    country="USA",
)
CAREFIRST_ARENA = SportsballGeocodeTuple(
    city="Washington",
    state="DC",
    postal="",
    lat=38.846972,
    lng=-76.991444,
    housenumber="1100",
    country="USA",
)
FORD_CENTER_AT_THE_STAR = SportsballGeocodeTuple(
    city="Frisco",
    state="TX",
    postal="",
    lat=33.1105,
    lng=-96.8281,
    housenumber="9",
    country="USA",
)
DUNKIN_DONUTS_CENTER = SportsballGeocodeTuple(
    city="Providence",
    state="RI",
    postal="",
    lat=41.823611,
    lng=-71.418333,
    housenumber="1",
    country="USA",
)
CHI_HEALTH_CENTER = SportsballGeocodeTuple(
    city="Omaha",
    state="NE",
    postal="",
    lat=41.263,
    lng=-95.928,
    housenumber="455",
    country="USA",
)
RYAN_CENTER = SportsballGeocodeTuple(
    city="Kingston",
    state="RI",
    postal="02881",
    lat=41.4875,
    lng=-71.535556,
    housenumber="1",
    country="USA",
)
GENEROSO_POPE_ATHELTIC_COMPLEX = SportsballGeocodeTuple(
    city="Brooklyn Heights",
    state="NY",
    postal="11201",
    lat=40.693147,
    lng=-73.992164,
    housenumber="180",
    country="USA",
)
ROBERT_A_MOTT_GYMNASIUM = SportsballGeocodeTuple(
    city="San Luis Obispo",
    state="CA",
    postal="93407",
    lat=35.29886,
    lng=-120.65855,
    housenumber="1",
    country="USA",
)
KIBBIE_DOME = SportsballGeocodeTuple(
    city="Moscow",
    state="ID",
    postal="83844",
    lat=46.726,
    lng=-117.017,
    housenumber="",
    country="USA",
)
ELMORE_GYMNASIUM = SportsballGeocodeTuple(
    city="Normal",
    state="AL",
    postal="35762",
    lat=34.7852,
    lng=-86.5752,
    housenumber="4900",
    country="USA",
)
REDHAWK_CENTER = SportsballGeocodeTuple(
    city="Seattle",
    state="WA",
    postal="",
    lat=47.607222,
    lng=-122.313333,
    housenumber="",
    country="USA",
)
VIRGIN_ISLANDS_SPORT_AND_FITNESS_CENTER = SportsballGeocodeTuple(
    city="St. Thomas",
    state="USVI",
    postal="",
    lat=18.340096,
    lng=-64.97306,
    housenumber="",
    country="USA",
)
ANAHEIM_CONVENTION_CENTER = SportsballGeocodeTuple(
    city="Anaheim",
    state="CA",
    postal="92802",
    lat=33.802455,
    lng=-117.919843,
    housenumber="800",
    country="USA",
)
WATSO_CENTER = SportsballGeocodeTuple(
    city="Coral Gables",
    state="FL",
    postal="",
    lat=25.715,
    lng=-80.279167,
    housenumber="1245",
    country="USA",
)
HAMPTON_CONVOCATION_CENTER = SportsballGeocodeTuple(
    city="Hampton",
    state="VA",
    postal="23668",
    lat=37.01974,
    lng=-76.33108,
    housenumber="100",
    country="USA",
)
BINGHAMPTON_UNIVERSITY_EVENTS_CENTER = SportsballGeocodeTuple(
    city="Binghamton",
    state="NY",
    postal="13902-6000",
    lat=42.093333,
    lng=-75.971944,
    housenumber="4400",
    country="USA",
)
ICCU_ARENA = SportsballGeocodeTuple(
    city="Moscow",
    state="ID",
    postal="",
    lat=46.7275,
    lng=-117.018056,
    housenumber="",
    country="USA",
)
YUENGLING_CENTER = SportsballGeocodeTuple(
    city="Tampa",
    state="FL",
    postal="",
    lat=28.059236,
    lng=-82.406472,
    housenumber="12499",
    country="USA",
)
HERTZ_ARENA = SportsballGeocodeTuple(
    city="Estero",
    state="FL",
    postal="",
    lat=26.440668,
    lng=-81.778809,
    housenumber="11000",
    country="USA",
)
IDAHO_CENTRAL_ARENA = SportsballGeocodeTuple(
    city="Boise",
    state="ID",
    postal="",
    lat=43.614,
    lng=-116.204,
    housenumber="233",
    country="USA",
)
CHASE_FAMILY_ARENA = SportsballGeocodeTuple(
    city="Hartford",
    state="CT",
    postal="06117",
    lat=41.8018079,
    lng=-72.7191231,
    housenumber="200",
    country="USA",
)
ROSE_GARDEN = SportsballGeocodeTuple(
    city="Portland",
    state="OR",
    postal="",
    lat=45.531667,
    lng=-122.666667,
    housenumber="1",
    country="USA",
)
DESERT_FINANCIAL_ARENA = SportsballGeocodeTuple(
    city="Tempe",
    state="AZ",
    postal="",
    lat=33.424524,
    lng=-111.930948,
    housenumber="600",
    country="USA",
)
TIMES_UNION_CENTER = SportsballGeocodeTuple(
    city="Albany",
    state="NY",
    postal="",
    lat=42.648611,
    lng=-73.754722,
    housenumber="51",
    country="USA",
)
SIU_ARENA = SportsballGeocodeTuple(
    city="Carbondale",
    state="IL",
    postal="",
    lat=37.708333,
    lng=-89.218611,
    housenumber="",
    country="USA",
)
TOYOTA_CENTER = SportsballGeocodeTuple(
    city="Kennewick",
    state="WA",
    postal="",
    lat=46.22,
    lng=-119.217,
    housenumber="7016",
    country="USA",
)
LLOYD_NOBLE_CENTER = SportsballGeocodeTuple(
    city="Norman",
    state="OK",
    postal="73072",
    lat=35.1875,
    lng=-97.444444,
    housenumber="2900",
    country="USA",
)
PETE_MARAVICH_ASSEMBLY_CENTER = SportsballGeocodeTuple(
    city="Baton Rouge",
    state="LA",
    postal="",
    lat=30.4142,
    lng=-91.1845,
    housenumber="",
    country="USA",
)
CHARLOTTE_COLISEUM = SportsballGeocodeTuple(
    city="Charlotte",
    state="NC",
    postal="",
    lat=35.186389,
    lng=-80.912778,
    housenumber="",
    country="USA",
)
REUNION_ARENA = SportsballGeocodeTuple(
    city="Dallas",
    state="TX",
    postal="75207",
    lat=32.772778,
    lng=-96.808056,
    housenumber="777",
    country="USA",
)
ROGERS_ARENA = SportsballGeocodeTuple(
    city="Vancouver",
    state="BC",
    postal="",
    lat=49.277778,
    lng=-123.108889,
    housenumber="800",
    country="CA",
)
MERRELL_CENTER = SportsballGeocodeTuple(
    city="Katy",
    state="TX",
    postal="77494",
    lat=29.780278,
    lng=-95.832222,
    housenumber="6301",
    country="USA",
)
NASSAU_COLISEUM = SportsballGeocodeTuple(
    city="Uniondale",
    state="NY",
    postal="",
    lat=40.722778,
    lng=-73.590556,
    housenumber="1255",
    country="USA",
)
MCNICHOLS_SPORTS_ARENA = SportsballGeocodeTuple(
    city="Denver",
    state="CO",
    postal="",
    lat=39.742778,
    lng=-105.0225,
    housenumber="1635",
    country="USA",
)
MARKET_SQUARE_ARENA = SportsballGeocodeTuple(
    city="Indianapolis",
    state="IN",
    postal="46204",
    lat=39.768333,
    lng=-86.151944,
    housenumber="300",
    country="USA",
)
HULMAN_CENTER = SportsballGeocodeTuple(
    city="Terre Haute",
    state="IN",
    postal="47809",
    lat=39.468333,
    lng=-87.405,
    housenumber="200",
    country="USA",
)
SAN_DIEGO_SPORTS_ARENA = SportsballGeocodeTuple(
    city="San Diego",
    state="CA",
    postal="",
    lat=32.755278,
    lng=-117.212222,
    housenumber="3500",
    country="USA",
)
ALLEN_COUNTY_WAR_MEMORIAL_COLISEUM = SportsballGeocodeTuple(
    city="Fort Wayne",
    state="IN",
    postal="23173",
    lat=41.115556,
    lng=-85.124444,
    housenumber="4000",
    country="USA",
)
INDIANA_ASSEMBLY_HALL = SportsballGeocodeTuple(
    city="Bloomington",
    state="IN",
    postal="47408-1590",
    lat=39.180833,
    lng=-86.522222,
    housenumber="1001",
    country="USA",
)
SMITH_SPECTRUM = SportsballGeocodeTuple(
    city="Logan",
    state="UT",
    postal="",
    lat=41.748,
    lng=-111.812,
    housenumber="900",
    country="USA",
)
MOBY_ARENA = SportsballGeocodeTuple(
    city="Fort Collins",
    state="CO",
    postal="",
    lat=40.575669,
    lng=-105.093403,
    housenumber="951",
    country="USA",
)
DORTON_ARENA = SportsballGeocodeTuple(
    city="Raleigh",
    state="NC",
    postal="",
    lat=35.793611,
    lng=-78.71,
    housenumber="1025",
    country="USA",
)
CHARLES_KOCH_ARENA = SportsballGeocodeTuple(
    city="Wichita",
    state="KS",
    postal="67260",
    lat=37.721667,
    lng=-97.2975,
    housenumber="",
    country="USA",
)
SAN_JOSE_CIVIC_AUDITORIUM = SportsballGeocodeTuple(
    city="San Jose",
    state="CA",
    postal="95113",
    lat=37.330987,
    lng=-121.890168,
    housenumber="135",
    country="USA",
)
MIAMI_BEACH_CONVENTION_CENTER = SportsballGeocodeTuple(
    city="Miami Beach",
    state="FL",
    postal="33139",
    lat=25.7948,
    lng=-80.1332,
    housenumber="1901",
    country="USA",
)
BOSTON_GARDENS = SportsballGeocodeTuple(
    city="Boston",
    state="MA",
    postal="",
    lat=42.365833,
    lng=-71.061667,
    housenumber="150",
    country="USA",
)
THE_JUNGLE = SportsballGeocodeTuple(
    city="Indianapolis",
    state="IN",
    postal="46202",
    lat=39.770556,
    lng=-86.175,
    housenumber="901",
    country="USA",
)
BAROSSA_PARK = SportsballGeocodeTuple(
    city="Lyndoch",
    state="SA",
    postal="5351",
    lat=-34.5988377,
    lng=138.8028998,
    housenumber="2",
    country="Australia",
)
BUCCANEER_FIELDHOUSE = SportsballGeocodeTuple(
    city="Charleston",
    state="SC",
    postal="29406",
    lat=32.980822,
    lng=-80.067125,
    housenumber="9200",
    country="USA",
)
WELLNESS_AND_EVENTS_CENTER = SportsballGeocodeTuple(
    city="Newark",
    state="NJ",
    postal="07102",
    lat=40.7453,
    lng=-74.183,
    housenumber="100",
    country="USA",
)
CIVIC_ARENA = SportsballGeocodeTuple(
    city="Pittsburgh",
    state="PA",
    postal="15219",
    lat=40.441667,
    lng=-79.99,
    housenumber="66",
    country="USA",
)
SIMMONS_BANK_ARENA = SportsballGeocodeTuple(
    city="North Little Rock",
    state="AR",
    postal="72114",
    lat=34.755111,
    lng=-92.264439,
    housenumber="1",
    country="USA",
)
BOK_CENTER = SportsballGeocodeTuple(
    city="Tulsa",
    state="OK",
    postal="",
    lat=36.152722,
    lng=-95.996333,
    housenumber="200",
    country="USA",
)
LEGACY_CENTER = SportsballGeocodeTuple(
    city="Lake Charles",
    state="LA",
    postal="70607",
    lat=30.1755,
    lng=-93.2095,
    housenumber="",
    country="USA",
)
EXTRAMILE_ARENA = SportsballGeocodeTuple(
    city="Boise",
    state="ID",
    postal="",
    lat=43.6035,
    lng=-116.199,
    housenumber="1401",
    country="USA",
)
REYNOLDS_COLISEUM = SportsballGeocodeTuple(
    city="Raleigh",
    state="NC",
    postal="",
    lat=35.783,
    lng=-78.67,
    housenumber="103",
    country="USA",
)
VANCOUVER_CONVENTION_CENTER = SportsballGeocodeTuple(
    city="Vancouver",
    state="BC",
    postal="",
    lat=49.289167,
    lng=-123.113797,
    housenumber="1055",
    country="Canada",
)
KENDALL_ISAACS_GYMNASIUM = SportsballGeocodeTuple(
    city="Nassau",
    state="",
    postal="",
    lat=25.0524506,
    lng=-77.3627058,
    housenumber="",
    country="Bahamas",
)
SCHAR_CENTER = SportsballGeocodeTuple(
    city="Elon",
    state="NC",
    postal="",
    lat=36.10805,
    lng=-79.51084,
    housenumber="",
    country="USA",
)
STUART_SIEGEL_CENTER = SportsballGeocodeTuple(
    city="Richmond",
    state="VA",
    postal="23284",
    lat=37.552918,
    lng=-77.4529,
    housenumber="1200",
    country="USA",
)
MEMORIAL_COLISEUM = SportsballGeocodeTuple(
    city="Portland",
    state="OR",
    postal="",
    lat=45.532,
    lng=-122.669,
    housenumber="300",
    country="USA",
)
FINNERAN_PAVILION = SportsballGeocodeTuple(
    city="Villanova",
    state="PA",
    postal="19085",
    lat=40.034072,
    lng=-75.336553,
    housenumber="",
    country="USA",
)
SCHEELS_ARENA = SportsballGeocodeTuple(
    city="Fargo",
    state="ND",
    postal="",
    lat=46.900442,
    lng=-96.799025,
    housenumber="1600",
    country="USA",
)
BROOKSHIRE_GROCERY_ARENA = SportsballGeocodeTuple(
    city="Bossier City",
    state="LA",
    postal="",
    lat=32.465167,
    lng=-93.673583,
    housenumber="2000",
    country="USA",
)
NEW_ORLEANS_CITY = SportsballGeocodeTuple(
    city="New Orleans",
    state="LA",
    postal="",
    lat=29.976111,
    lng=-90.078333,
    housenumber="",
    country="USA",
)
PETCO_PARK = SportsballGeocodeTuple(
    city="San Diego",
    state="CA",
    postal="92101",
    lat=32.7073,
    lng=-117.1566,
    housenumber="100",
    country="USA",
)
HART_RECREATION_CENTER = SportsballGeocodeTuple(
    city="Worcester",
    state="MA",
    postal="01610",
    lat=42.235046,
    lng=-71.806381,
    housenumber="1",
    country="USA",
)
CFSB_CENTER = SportsballGeocodeTuple(
    city="Murray",
    state="KY",
    postal="42071",
    lat=36.62267,
    lng=-88.32031,
    housenumber="1401",
    country="USA",
)
TD_BANK_SPORTS_CENTER = SportsballGeocodeTuple(
    city="Hamden",
    state="CT",
    postal="06518",
    lat=41.413833,
    lng=-72.911157,
    housenumber="305",
    country="USA",
)
BANK_OF_COLORADO_ARENA = SportsballGeocodeTuple(
    city="Greeley",
    state="CO",
    postal="80639",
    lat=40.402217,
    lng=-104.703044,
    housenumber="270",
    country="USA",
)
LENOVO_CENTER = SportsballGeocodeTuple(
    city="Raleigh",
    state="NC",
    postal="",
    lat=35.803333,
    lng=-78.721944,
    housenumber="1400",
    country="USA",
)
CABOT_CENTER = SportsballGeocodeTuple(
    city="Boston",
    state="MA",
    postal="02115",
    lat=42.3396,
    lng=-71.0898,
    housenumber="400",
    country="USA",
)
CENTRUM_ARENA = SportsballGeocodeTuple(
    city="Cedar City",
    state="UT",
    postal="84720",
    lat=37.675556,
    lng=-113.073056,
    housenumber="351",
    country="USA",
)
BANK_OF_KENTUCKY_CENTER = SportsballGeocodeTuple(
    city="Highland Heights",
    state="KY",
    postal="41099",
    lat=39.032273,
    lng=-84.458864,
    housenumber="500",
    country="USA",
)
THE_NEST = SportsballGeocodeTuple(
    city="Sacramento",
    state="CA",
    postal="",
    lat=38.561903,
    lng=-121.426878,
    housenumber="",
    country="USA",
)
EAGLEBANK_ARENA = SportsballGeocodeTuple(
    city="Fairfax",
    state="VA",
    postal="",
    lat=38.827,
    lng=-77.31,
    housenumber="4500",
    country="USA",
)
KEYBANK_CENTER = SportsballGeocodeTuple(
    city="Buffalo",
    state="NY",
    postal="",
    lat=42.875,
    lng=-78.876389,
    housenumber="1",
    country="USA",
)
ADDITION_FINANCIAL_ARENA = SportsballGeocodeTuple(
    city="Orlando",
    state="FL",
    postal="",
    lat=28.6068,
    lng=-81.1976,
    housenumber="12777",
    country="USA",
)
UCCU_CENTER = SportsballGeocodeTuple(
    city="Orem",
    state="UT",
    postal="",
    lat=40.278724,
    lng=-111.716956,
    housenumber="800",
    country="USA",
)
STATE_FARM_CENTER = SportsballGeocodeTuple(
    city="Champaign",
    state="IL",
    postal="",
    lat=40.096259,
    lng=-88.235956,
    housenumber="1800",
    country="USA",
)
HARBOR_YARD = SportsballGeocodeTuple(
    city="Bridgeport",
    state="CT",
    postal="06604",
    lat=41.171944,
    lng=-73.1875,
    housenumber="500",
    country="USA",
)
OCEAN_BANK_CONVOCATION_CENTER = SportsballGeocodeTuple(
    city="Miami",
    state="FL",
    postal="33199",
    lat=25.756667,
    lng=-80.379444,
    housenumber="11200",
    country="USA",
)
UTRGV_FIELDHOUSE = SportsballGeocodeTuple(
    city="Edinburg",
    state="TX",
    postal="",
    lat=26.310278,
    lng=-98.178056,
    housenumber="",
    country="USA",
)
UCR_STUDENT_REC_CENTER = SportsballGeocodeTuple(
    city="Riverside",
    state="CA",
    postal="",
    lat=33.9789,
    lng=-117.32813,
    housenumber="",
    country="USA",
)
DEGOL_ARENA = SportsballGeocodeTuple(
    city="Loretto",
    state="PA",
    postal="15940",
    lat=40.504612,
    lng=-78.640901,
    housenumber="140",
    country="USA",
)
RETRIEVER_ACTIVITIES_CENTER = SportsballGeocodeTuple(
    city="Baltimore",
    state="MD",
    postal="21250",
    lat=39.2528994,
    lng=-76.712267,
    housenumber="1000",
    country="USA",
)
AL_LAWSON_CENTER = SportsballGeocodeTuple(
    city="Tallahassee",
    state="FL",
    postal="32310",
    lat=30.424318,
    lng=-84.290473,
    housenumber="1800",
    country="USA",
)
XFINITY_CENTER = SportsballGeocodeTuple(
    city="College Park",
    state="MD",
    postal="",
    lat=38.995278,
    lng=-76.941389,
    housenumber="",
    country="USA",
)
UNITED_SUPERMARKETS_ARENA = SportsballGeocodeTuple(
    city="Lubbock",
    state="TX",
    postal="79409",
    lat=33.581261,
    lng=-101.886636,
    housenumber="1701",
    country="USA",
)
BEASLEY_COLISEUM = SportsballGeocodeTuple(
    city="Pullman",
    state="WA",
    postal="",
    lat=46.735,
    lng=-117.1575,
    housenumber="925",
    country="USA",
)
SCHOLLMAIER_ARENA = SportsballGeocodeTuple(
    city="Fort Worth",
    state="TX",
    postal="76109",
    lat=32.708774,
    lng=-97.36673,
    housenumber="2900",
    country="USA",
)
ALUMNI_HALL = SportsballGeocodeTuple(
    city="Providence",
    state="RI",
    postal="02918",
    lat=41.84575,
    lng=-71.437029,
    housenumber="",
    country="USA",
)
FREDRICK_C_HOBDY_ASSEMBLY_CENTER = SportsballGeocodeTuple(
    city="Grambling",
    state="LA",
    postal="",
    lat=32.520284,
    lng=-92.723578,
    housenumber="1234",
    country="USA",
)
AMERANT_BANK_ARENA = SportsballGeocodeTuple(
    city="Sunrise",
    state="FL",
    postal="",
    lat=26.158333,
    lng=-80.325556,
    housenumber="1",
    country="USA",
)
COLISEO_JUAN_AUBIN_CRUZ_ABREU = SportsballGeocodeTuple(
    city="Manati",
    state="PR",
    postal="00674",
    lat=18.4244569,
    lng=-66.4696945,
    housenumber="670",
    country="USA",
)
COLISEO_RUBEN_RODRIGUEZ = SportsballGeocodeTuple(
    city="Bayamon",
    state="PR",
    postal="",
    lat=18.394958,
    lng=-66.150833,
    housenumber="",
    country="USA",
)
DONALD_L_TUCKER_CENTER = SportsballGeocodeTuple(
    city="Tallahassee",
    state="FL",
    postal="32301-1619",
    lat=30.437842,
    lng=-84.28669,
    housenumber="505",
    country="USA",
)
BEARD_EAVES_MEMORIAL_COLISEUM = SportsballGeocodeTuple(
    city="Auburn",
    state="AL",
    postal="",
    lat=32.600278,
    lng=-85.492222,
    housenumber="101",
    country="USA",
)
JOSE_MIGUEL_AGRELOT_COLISEUM = SportsballGeocodeTuple(
    city="San Juan",
    state="PR",
    postal="",
    lat=18.427717,
    lng=-66.061392,
    housenumber="500",
    country="USA",
)
VIEJAS_ARENA = SportsballGeocodeTuple(
    city="San Diego",
    state="CA",
    postal="",
    lat=32.77375,
    lng=-117.074583,
    housenumber="5500",
    country="USA",
)
OMNI_COLISEUM = SportsballGeocodeTuple(
    city="Atlanta",
    state="GA",
    postal="30303",
    lat=33.7575,
    lng=-84.396667,
    housenumber="100",
    country="USA",
)
MCCAMISH_PAVILION = SportsballGeocodeTuple(
    city="Atlanta",
    state="GA",
    postal="",
    lat=33.780833,
    lng=-84.392778,
    housenumber="965",
    country="USA",
)
TUDOR_FIELDHOUSE = SportsballGeocodeTuple(
    city="Houston",
    state="TX",
    postal="77251",
    lat=29.715102,
    lng=-95.403895,
    housenumber="6100",
    country="USA",
)
HAGAN_ARENA = SportsballGeocodeTuple(
    city="Philadelphia",
    state="PA",
    postal="",
    lat=39.995245,
    lng=-75.234806,
    housenumber="",
    country="USA",
)
COORS_EVENTS_CONFERENCE_CENTER = SportsballGeocodeTuple(
    city="Boulder",
    state="CO",
    postal="",
    lat=40.0047,
    lng=-105.2606,
    housenumber="950",
    country="USA",
)
SPOKANE = SportsballGeocodeTuple(
    city="Spokane",
    state="WA",
    postal="",
    lat=47.658889,
    lng=-117.425,
    housenumber="",
    country="USA",
)
GREENSBORO = SportsballGeocodeTuple(
    city="Greensboro",
    state="NC",
    postal="",
    lat=36.05,
    lng=-79.49,
    housenumber="",
    country="USA",
)
BUFFALO = SportsballGeocodeTuple(
    city="Buffalo",
    state="NY",
    postal="",
    lat=42.886389,
    lng=-78.878056,
    housenumber="",
    country="USA",
)
LOS_ANGELES = SportsballGeocodeTuple(
    city="Los Angeles",
    state="CA",
    postal="",
    lat=34.05,
    lng=-118.25,
    housenumber="700",
    country="USA",
)
LONG_BEACH = SportsballGeocodeTuple(
    city="Long Beach",
    state="CA",
    postal="",
    lat=33.768333,
    lng=-118.195556,
    housenumber="",
    country="USA",
)
PHILADELPHIA = SportsballGeocodeTuple(
    city="Philadelphia",
    state="PA",
    postal="",
    lat=39.952778,
    lng=-75.163611,
    housenumber="",
    country="USA",
)
AKRON = SportsballGeocodeTuple(
    city="Akron",
    state="OH",
    postal="",
    lat=41.080556,
    lng=-81.522222,
    housenumber="",
    country="USA",
)
HEMPSTEAD = SportsballGeocodeTuple(
    city="Hempstead",
    state="NY",
    postal="",
    lat=40.704722,
    lng=-73.617222,
    housenumber="",
    country="USA",
)
RICHMOND = SportsballGeocodeTuple(
    city="Richmond",
    state="VA",
    postal="",
    lat=37.540833,
    lng=-77.436667,
    housenumber="",
    country="USA",
)
INDIANAPOLIS = SportsballGeocodeTuple(
    city="Indianapolis",
    state="IN",
    postal="",
    lat=39.768611,
    lng=-86.158056,
    housenumber="",
    country="USA",
)
DAYTON = SportsballGeocodeTuple(
    city="Dayton",
    state="OH",
    postal="",
    lat=39.759444,
    lng=-84.191667,
    housenumber="",
    country="USA",
)
CLEVELAND = SportsballGeocodeTuple(
    city="Cleveland",
    state="OH",
    postal="",
    lat=41.499167,
    lng=-81.694722,
    housenumber="",
    country="USA",
)
NATCHITOCHES = SportsballGeocodeTuple(
    city="Natchitoches",
    state="LA",
    postal="",
    lat=31.693056,
    lng=-93.095,
    housenumber="",
    country="USA",
)
TAMPA = SportsballGeocodeTuple(
    city="Tampa",
    state="FL",
    postal="",
    lat=27.9475,
    lng=-82.458611,
    housenumber="",
    country="USA",
)
LITTLE_ROCK = SportsballGeocodeTuple(
    city="Little Rock",
    state="AR",
    postal="",
    lat=34.744444,
    lng=-92.288056,
    housenumber="",
    country="USA",
)
PENSACOLA = SportsballGeocodeTuple(
    city="Pensacola",
    state="FL",
    postal="",
    lat=30.421308,
    lng=-87.216914,
    housenumber="",
    country="USA",
)
DALLAS = SportsballGeocodeTuple(
    city="Dallas",
    state="TX",
    postal="",
    lat=32.779167,
    lng=-96.808889,
    housenumber="",
    country="USA",
)
NEW_YORK = SportsballGeocodeTuple(
    city="New York",
    state="NY",
    postal="",
    lat=40.712778,
    lng=-74.006111,
    housenumber="",
    country="USA",
)
WASHINGTON = SportsballGeocodeTuple(
    city="Washington",
    state="DC",
    postal="",
    lat=38.904722,
    lng=-77.016389,
    housenumber="",
    country="USA",
)
JACKSON = SportsballGeocodeTuple(
    city="Jackson",
    state="MS",
    postal="",
    lat=29.762778,
    lng=-95.383056,
    housenumber="",
    country="USA",
)
RALEIGH = SportsballGeocodeTuple(
    city="Raleigh",
    state="NC",
    postal="",
    lat=35.854167,
    lng=-78.761944,
    housenumber="",
    country="USA",
)
JAMAICA = SportsballGeocodeTuple(
    city="Jamaica",
    state="NY",
    postal="",
    lat=40.7,
    lng=-73.8,
    housenumber="",
    country="USA",
)
CHICAGO = SportsballGeocodeTuple(
    city="Chicago",
    state="IL",
    postal="",
    lat=41.881944,
    lng=-87.627778,
    housenumber="",
    country="USA",
)
CORAL_GABLES = SportsballGeocodeTuple(
    city="Coral Gables",
    state="FL",
    postal="",
    lat=25.716667,
    lng=-80.272222,
    housenumber="",
    country="USA",
)
DAYTONA_BEACH = SportsballGeocodeTuple(
    city="Daytona Beach",
    state="FL",
    postal="",
    lat=29.210833,
    lng=-81.022778,
    housenumber="",
    country="USA",
)
WINSTON_SALEM = SportsballGeocodeTuple(
    city="Winston-Salem",
    state="NC",
    postal="",
    lat=36.102778,
    lng=-80.260833,
    housenumber="",
    country="USA",
)
ANCHORAGE = SportsballGeocodeTuple(
    city="Anchorage",
    state="AL",
    postal="",
    lat=61.216667,
    lng=-149.893611,
    housenumber="",
    country="USA",
)
BERKELEY = SportsballGeocodeTuple(
    city="Berkeley",
    state="CA",
    postal="",
    lat=37.871667,
    lng=-122.272778,
    housenumber="",
    country="USA",
)
SHREVEPORT = SportsballGeocodeTuple(
    city="Shreveport",
    state="LA",
    postal="",
    lat=32.463889,
    lng=-93.794444,
    housenumber="",
    country="USA",
)
SEATTLE = SportsballGeocodeTuple(
    city="Seattle",
    state="WA",
    postal="",
    lat=47.603889,
    lng=-122.33,
    housenumber="",
    country="USA",
)
MIAMI = SportsballGeocodeTuple(
    city="Miami",
    state="FL",
    postal="",
    lat=25.766667,
    lng=-80.2,
    housenumber="",
    country="USA",
)
HOUSTON = SportsballGeocodeTuple(
    city="Houston",
    state="TX",
    postal="",
    lat=29.762778,
    lng=-95.383056,
    housenumber="",
    country="USA",
)
MILWAUKEE = SportsballGeocodeTuple(
    city="Milwaukee",
    state="WI",
    postal="",
    lat=43.05,
    lng=-87.95,
    housenumber="",
    country="USA",
)
SAN_FRANCISCO = SportsballGeocodeTuple(
    city="San Francisco",
    state="CA",
    postal="",
    lat=37.783333,
    lng=-122.416667,
    housenumber="",
    country="USA",
)
MEMPHIS = SportsballGeocodeTuple(
    city="Memphis",
    state="TN",
    postal="",
    lat=35.1175,
    lng=-89.971111,
    housenumber="",
    country="USA",
)
ST_LOUIS = SportsballGeocodeTuple(
    city="St. Louis",
    state="MO",
    postal="",
    lat=38.627222,
    lng=-90.197778,
    housenumber="",
    country="USA",
)
DETROIT = SportsballGeocodeTuple(
    city="Detroit",
    state="MI",
    postal="",
    lat=42.333333,
    lng=-83.05,
    housenumber="",
    country="USA",
)
EUGENE = SportsballGeocodeTuple(
    city="Eugene",
    state="OR",
    postal="",
    lat=44.056389,
    lng=-123.1175,
    housenumber="",
    country="USA",
)
SALT_LAKE_CITY = SportsballGeocodeTuple(
    city="Salt Lake City",
    state="UT",
    postal="",
    lat=40.760833,
    lng=-111.891111,
    housenumber="",
    country="USA",
)
COLUMBUS = SportsballGeocodeTuple(
    city="Columbus",
    state="OH",
    postal="",
    lat=39.962222,
    lng=-83.000556,
    housenumber="",
    country="USA",
)
GREENVILLE = SportsballGeocodeTuple(
    city="Greenville",
    state="SC",
    postal="",
    lat=34.844444,
    lng=-82.385556,
    housenumber="",
    country="USA",
)
SAVANNAH = SportsballGeocodeTuple(
    city="Savannah",
    state="GA",
    postal="",
    lat=32.081111,
    lng=-81.091111,
    housenumber="",
    country="USA",
)
ATLANTA = SportsballGeocodeTuple(
    city="Atlanta",
    state="GA",
    postal="",
    lat=33.748889,
    lng=-84.39,
    housenumber="",
    country="USA",
)
BATON_ROUGE = SportsballGeocodeTuple(
    city="Baton Rouge",
    state="LA",
    postal="",
    lat=30.4475,
    lng=-91.178611,
    housenumber="",
    country="USA",
)
RIVERSIDE = SportsballGeocodeTuple(
    city="Riverside",
    state="CA",
    postal="",
    lat=33.948056,
    lng=-117.396111,
    housenumber="",
    country="USA",
)
LOUISVILLE = SportsballGeocodeTuple(
    city="Louisville",
    state="KT",
    postal="",
    lat=38.256111,
    lng=-85.751389,
    housenumber="",
    country="USA",
)
OXFORD = SportsballGeocodeTuple(
    city="Oxford",
    state="OH",
    postal="",
    lat=39.5075,
    lng=-84.746667,
    housenumber="",
    country="USA",
)
PORTLAND = SportsballGeocodeTuple(
    city="Portland",
    state="OR",
    postal="",
    lat=45.52,
    lng=-122.681944,
    housenumber="",
    country="USA",
)
BALTIMORE = SportsballGeocodeTuple(
    city="Baltimore",
    state="MD",
    postal="",
    lat=39.289444,
    lng=-76.615278,
    housenumber="",
    country="USA",
)
SAN_DIEGO = SportsballGeocodeTuple(
    city="San Diego",
    state="CA",
    postal="",
    lat=32.715,
    lng=-117.1625,
    housenumber="",
    country="USA",
)
BRONX = SportsballGeocodeTuple(
    city="Bronx",
    state="NY",
    postal="",
    lat=40.837222,
    lng=-73.886111,
    housenumber="",
    country="USA",
)
YOUNGSTOWN = SportsballGeocodeTuple(
    city="Youngstown",
    state="OH",
    postal="",
    lat=41.1,
    lng=-80.65,
    housenumber="",
    country="USA",
)
ST_PETERSBURG = SportsballGeocodeTuple(
    city="St. Petersburg",
    state="FL",
    postal="",
    lat=27.773056,
    lng=-82.64,
    housenumber="",
    country="USA",
)
PHOENIX = SportsballGeocodeTuple(
    city="Phoenix",
    state="AZ",
    postal="",
    lat=33.448333,
    lng=-112.073889,
    housenumber="",
    country="USA",
)
AMES = SportsballGeocodeTuple(
    city="Ames",
    state="IO",
    postal="",
    lat=42.034722,
    lng=-93.62,
    housenumber="",
    country="USA",
)
HUNTINGTON = SportsballGeocodeTuple(
    city="Huntington",
    state="WV",
    postal="",
    lat=38.41925,
    lng=-82.445153,
    housenumber="",
    country="USA",
)
MINNEAPOLIS = SportsballGeocodeTuple(
    city="Minneapolis",
    state="MN",
    postal="",
    lat=44.981944,
    lng=-93.269167,
    housenumber="",
    country="USA",
)
PEORIA = SportsballGeocodeTuple(
    city="Peoria",
    state="IL",
    postal="",
    lat=40.692778,
    lng=-89.590556,
    housenumber="",
    country="USA",
)
CHARLESTON = SportsballGeocodeTuple(
    city="Charleston",
    state="SC",
    postal="",
    lat=32.783333,
    lng=-79.931944,
    housenumber="",
    country="USA",
)
FORT_WAYNE = SportsballGeocodeTuple(
    city="Fort Wayne",
    state="IN",
    postal="",
    lat=41.088889,
    lng=-85.161389,
    housenumber="",
    country="USA",
)
MONROE = SportsballGeocodeTuple(
    city="Monroe",
    state="LA",
    postal="",
    lat=32.509444,
    lng=-92.118333,
    housenumber="",
    country="USA",
)
YOKOHAMA_ARENA = SportsballGeocodeTuple(
    city="Kanagawa",
    state="",
    postal="",
    lat=35.512389,
    lng=139.620056,
    housenumber="",
    country="Japan",
)
BELL_CENTRE = SportsballGeocodeTuple(
    city="Montreal",
    state="QC",
    postal="",
    lat=45.496111,
    lng=-73.569444,
    housenumber="1909",
    country="CA",
)
CROKE_PARK = SportsballGeocodeTuple(
    city="Dublin",
    state="",
    postal="D03 P6K7",
    lat=53.3609,
    lng=-6.2519,
    housenumber="",
    country="Ireland",
)
MADISON = SportsballGeocodeTuple(
    city="Madison",
    state="WI",
    postal="",
    lat=43.074722,
    lng=-89.384167,
    housenumber="",
    country="USA",
)
SAN_JOSE = SportsballGeocodeTuple(
    city="San Jose",
    state="CA",
    postal="",
    lat=37.336111,
    lng=-121.890556,
    housenumber="",
    country="USA",
)
MIAMI_ARENA = SportsballGeocodeTuple(
    city="Miami",
    state="FL",
    postal="",
    lat=25.781111,
    lng=-80.194722,
    housenumber="721",
    country="USA",
)
SILVIO_O_CONTE_FORUM = SportsballGeocodeTuple(
    city="Chestnut Hill",
    state="MA",
    postal="",
    lat=42.335,
    lng=-71.1675,
    housenumber="",
    country="USA",
)
ROGERS_CENTER = SportsballGeocodeTuple(
    city="Toronto",
    state="ON",
    postal="M5V 1J1",
    lat=43.6415757,
    lng=-79.3942991,
    housenumber="580",
    country="Canada",
)
BIRMINGHAM_JEFFERSON_CIVIC_CENTER = SportsballGeocodeTuple(
    city="Birmingham",
    state="AL",
    postal="35203",
    lat=33.524,
    lng=-86.812,
    housenumber="2100",
    country="USA",
)
FRESNO = SportsballGeocodeTuple(
    city="Fresno",
    state="CA",
    postal="",
    lat=36.75,
    lng=-119.766667,
    housenumber="",
    country="USA",
)
SAP_CENTER = SportsballGeocodeTuple(
    city="San Jose",
    state="CA",
    postal="",
    lat=37.332778,
    lng=-121.901111,
    housenumber="525",
    country="USA",
)
RENO = SportsballGeocodeTuple(
    city="Reno",
    state="NV",
    postal="",
    lat=39.527222,
    lng=-119.821944,
    housenumber="",
    country="USA",
)
TACOMA_DOME = SportsballGeocodeTuple(
    city="Tacoma",
    state="WA",
    postal="98421",
    lat=47.236667,
    lng=-122.426667,
    housenumber="2727",
    country="USA",
)
CHATTANOOGA = SportsballGeocodeTuple(
    city="Chattanooga",
    state="TN",
    postal="",
    lat=35.045556,
    lng=-85.267222,
    housenumber="",
    country="USA",
)
HANDS_OVAL = SportsballGeocodeTuple(
    city="Bunbury",
    state="WA",
    postal="",
    lat=-33.346111,
    lng=115.642778,
    housenumber="",
    country="Australia",
)
CANTON = SportsballGeocodeTuple(
    city="Canton",
    state="OH",
    postal="",
    lat=40.807778,
    lng=-81.395556,
    housenumber="",
    country="USA",
)
CAPITAL_CENTER = SportsballGeocodeTuple(
    city="Landover",
    state="MD",
    postal="",
    lat=38.9025,
    lng=-76.846944,
    housenumber="1",
    country="USA",
)
KNOXVILLE = SportsballGeocodeTuple(
    city="Knoxville",
    state="TN",
    postal="",
    lat=35.9617,
    lng=-83.9232,
    housenumber="",
    country="USA",
)
AUSTIN = SportsballGeocodeTuple(
    city="Austin",
    state="TX",
    postal="",
    lat=30.267222,
    lng=-97.743056,
    housenumber="",
    country="USA",
)
ELON = SportsballGeocodeTuple(
    city="Elon",
    state="NC",
    postal="",
    lat=36.126667,
    lng=-79.495556,
    housenumber="",
    country="USA",
)
CINCINNATI = SportsballGeocodeTuple(
    city="Cincinnati",
    state="OH",
    postal="",
    lat=39.1,
    lng=-84.5125,
    housenumber="",
    country="USA",
)
NACOGDOCHES = SportsballGeocodeTuple(
    city="Nacogdoches",
    state="TX",
    postal="",
    lat=31.63,
    lng=-94.628611,
    housenumber="",
    country="USA",
)
SOUTHAVEN = SportsballGeocodeTuple(
    city="Southaven",
    state="MS",
    postal="",
    lat=34.968889,
    lng=-90.011111,
    housenumber="",
    country="USA",
)
CHARLOTTE = SportsballGeocodeTuple(
    city="Charlotte",
    state="NC",
    postal="",
    lat=35.227222,
    lng=-80.843056,
    housenumber="",
    country="USA",
)
DULUTH = SportsballGeocodeTuple(
    city="Duluth",
    state="GA",
    postal="",
    lat=34.005278,
    lng=-84.149167,
    housenumber="",
    country="USA",
)
PITTSBURGH = SportsballGeocodeTuple(
    city="Pittsburgh",
    state="PA",
    postal="",
    lat=40.439722,
    lng=-79.976389,
    housenumber="",
    country="USA",
)
SPRINGFIELD = SportsballGeocodeTuple(
    city="Springfield",
    state="IL",
    postal="",
    lat=39.7975,
    lng=-89.645,
    housenumber="",
    country="USA",
)
LAS_VEGAS = SportsballGeocodeTuple(
    city="Las Vegas",
    state="NV",
    postal="",
    lat=36.167222,
    lng=-115.148611,
    housenumber="",
    country="USA",
)
PASADENA = SportsballGeocodeTuple(
    city="Pasadena",
    state="CA",
    postal="",
    lat=34.1475,
    lng=-118.143889,
    housenumber="",
    country="USA",
)
ROCK_HILL = SportsballGeocodeTuple(
    city="Rock Hill",
    state="SC",
    postal="",
    lat=34.946667,
    lng=-81.9275,
    housenumber="",
    country="USA",
)
SIOUX_FALLS = SportsballGeocodeTuple(
    city="Sioux Falls",
    state="SD",
    postal="",
    lat=43.536389,
    lng=-96.731667,
    housenumber="",
    country="USA",
)
STOCKTON = SportsballGeocodeTuple(
    city="Stockton",
    state="CA",
    postal="",
    lat=37.975556,
    lng=-121.300833,
    housenumber="",
    country="USA",
)
BOSTON = SportsballGeocodeTuple(
    city="Boston",
    state="MA",
    postal="",
    lat=42.360278,
    lng=-71.057778,
    housenumber="",
    country="USA",
)
ST_GEORGE = SportsballGeocodeTuple(
    city="St. George",
    state="UT",
    postal="",
    lat=37.075,
    lng=-113.576667,
    housenumber="",
    country="USA",
)
MVP_ARENA = SportsballGeocodeTuple(
    city="Albany",
    state="NY",
    postal="",
    lat=42.648611,
    lng=-73.754722,
    housenumber="51",
    country="USA",
)
FAU_STADIUM = SportsballGeocodeTuple(
    city="Boca Raton",
    state="FL",
    postal="33431",
    lat=26.375278,
    lng=-80.100278,
    housenumber="777",
    country="USA",
)
FREEDOM_HALL = SportsballGeocodeTuple(
    city="Louisville",
    state="KY",
    postal="",
    lat=38.200294,
    lng=-85.741886,
    housenumber="937",
    country="USA",
)
PRUDENTIAL_CENTER = SportsballGeocodeTuple(
    city="Newark",
    state="NJ",
    postal="",
    lat=40.733611,
    lng=-74.171111,
    housenumber="25",
    country="USA",
)
ROBERTS_STADIUM = SportsballGeocodeTuple(
    city="Evansville",
    state="IN",
    postal="47711",
    lat=37.97903,
    lng=-87.515926,
    housenumber="2600",
    country="USA",
)
LONG_BEACH_ARENA = SportsballGeocodeTuple(
    city="Long Beach",
    state="CA",
    postal="",
    lat=33.763889,
    lng=-118.188333,
    housenumber="",
    country="USA",
)
MID_SOUTH_COLISEUM = SportsballGeocodeTuple(
    city="Memphis",
    state="TN",
    postal="38104",
    lat=35.118395,
    lng=-89.980366,
    housenumber="996",
    country="USA",
)
DEAN_SMITH_CENTER = SportsballGeocodeTuple(
    city="Chapel Hill",
    state="NC",
    postal="",
    lat=35.899722,
    lng=-79.043889,
    housenumber="300",
    country="USA",
)
CHARLESTON_CIVIC_CENTER = SportsballGeocodeTuple(
    city="Charleston",
    state="WV",
    postal="25301",
    lat=38.35519,
    lng=-81.64152,
    housenumber="200",
    country="USA",
)
GREENSBORO_COLISEUM = SportsballGeocodeTuple(
    city="Greensboro",
    state="NC",
    postal="",
    lat=36.059722,
    lng=-79.825556,
    housenumber="1921",
    country="USA",
)
SELLAND_ARENA = SportsballGeocodeTuple(
    city="Fresno",
    state="CA",
    postal="",
    lat=36.733093,
    lng=-119.78271,
    housenumber="700",
    country="USA",
)
MAPLE_LEAF_GARDENS = SportsballGeocodeTuple(
    city="Toronto",
    state="ON",
    postal="",
    lat=43.662222,
    lng=-79.380278,
    housenumber="60",
    country="CA",
)
AMICA_MUTUAL_PAVILION = SportsballGeocodeTuple(
    city="Providence",
    state="RI",
    postal="",
    lat=41.823611,
    lng=-71.418333,
    housenumber="1",
    country="USA",
)
PEOPLESBANK_ARENA = SportsballGeocodeTuple(
    city="Hartford",
    state="CT",
    postal="",
    lat=41.768333,
    lng=-72.676944,
    housenumber="1",
    country="USA",
)
MISSISSIPPI_COAST_COLISEUM = SportsballGeocodeTuple(
    city="Biloxi",
    state="MS",
    postal="39531",
    lat=30.3935,
    lng=-88.9746,
    housenumber="2350",
    country="USA",
)
UNIVERSITY_OF_ARIZONA = SportsballGeocodeTuple(
    city="Tucson",
    state="AZ",
    postal="",
    lat=32.2319,
    lng=-110.9527,
    housenumber="",
    country="USA",
)
DETROIT_OLYMPIA = SportsballGeocodeTuple(
    city="Detroit",
    state="MI",
    postal="",
    lat=42.354444,
    lng=-83.100556,
    housenumber="5920",
    country="USA",
)
LAKEFRONT_ARENA = SportsballGeocodeTuple(
    city="New Orleans",
    state="LA",
    postal="",
    lat=30.03,
    lng=-90.050556,
    housenumber="6801",
    country="USA",
)
ROGERS_PLACE = SportsballGeocodeTuple(
    city="Edmonton",
    state="AB",
    postal="",
    lat=53.546944,
    lng=-113.497778,
    housenumber="10220",
    country="Canada",
)
LN_FEDERAL_CREDIT_UNION_STADIUM = SportsballGeocodeTuple(
    city="Louisville",
    state="KY",
    postal="40208",
    lat=38.205833,
    lng=-85.758889,
    housenumber="2800",
    country="USA",
)
WICHITA = SportsballGeocodeTuple(
    city="Wichita",
    state="KS",
    postal="",
    lat=29.762778,
    lng=-95.383056,
    housenumber="",
    country="USA",
)
HAVRE_DE_GRACE = SportsballGeocodeTuple(
    city="Havre De Grace",
    state="MD",
    postal="",
    lat=39.548333,
    lng=-76.0975,
    housenumber="",
    country="USA",
)
MOSCOW = SportsballGeocodeTuple(
    city="Moscow",
    state="",
    postal="",
    lat=55.755833,
    lng=37.617778,
    housenumber="",
    country="Russia",
)
LUBBOCK = SportsballGeocodeTuple(
    city="Lubbock",
    state="TX",
    postal="",
    lat=33.585,
    lng=-101.845,
    housenumber="",
    country="USA",
)
SCOTTSDALE = SportsballGeocodeTuple(
    city="Scottsdale",
    state="AZ",
    postal="",
    lat=33.493056,
    lng=-111.926111,
    housenumber="",
    country="USA",
)
ARLINGTON = SportsballGeocodeTuple(
    city="Arlington",
    state="TX",
    postal="",
    lat=32.705,
    lng=-97.122778,
    housenumber="",
    country="USA",
)
CFG_BANK_ARENA = SportsballGeocodeTuple(
    city="Baltimore",
    state="MD",
    postal="",
    lat=39.288611,
    lng=-76.618889,
    housenumber="201",
    country="USA",
)
DUKE_UNIVERSITY = SportsballGeocodeTuple(
    city="Durham",
    state="NC",
    postal="",
    lat=36.001389,
    lng=-78.938333,
    housenumber="",
    country="USA",
)
T_MOBILE_ARENA = SportsballGeocodeTuple(
    city="Las Vegas",
    state="NV",
    postal="",
    lat=36.102778,
    lng=-115.178333,
    housenumber="3780",
    country="USA",
)
NOTRE_DAME_STADIUM = SportsballGeocodeTuple(
    city="Notre Dame",
    state="IN",
    postal="46556",
    lat=41.69833,
    lng=-86.23389,
    housenumber="2010",
    country="USA",
)
CAMP_RANDALL_STADIUM = SportsballGeocodeTuple(
    city="Madison",
    state="WI",
    postal="53711",
    lat=43.07,
    lng=-89.412778,
    housenumber="",
    country="USA",
)
LAVELL_EDWARDS_STADIUM = SportsballGeocodeTuple(
    city="Provo",
    state="UT",
    postal="84604",
    lat=40.258,
    lng=-111.655,
    housenumber="1700",
    country="USA",
)
COMPAQ_CENTER = SportsballGeocodeTuple(
    city="Houston",
    state="TX",
    postal="",
    lat=29.730278,
    lng=-95.435,
    housenumber="3700",
    country="USA",
)
FOLSOM_FIELD = SportsballGeocodeTuple(
    city="Boulder",
    state="CO",
    postal="80305",
    lat=40.009,
    lng=-105.267,
    housenumber="2400",
    country="USA",
)
MARTIN_STADIUM = SportsballGeocodeTuple(
    city="Pullman",
    state="WA",
    postal="99164",
    lat=46.732,
    lng=-117.16,
    housenumber="720",
    country="USA",
)
CAMPING_WORLD_STADIUM = SportsballGeocodeTuple(
    city="Orlando",
    state="FL",
    postal="32805",
    lat=28.5390192,
    lng=-81.4033962,
    housenumber="1",
    country="USA",
)
LEGION_FIELD = SportsballGeocodeTuple(
    city="Birmingham",
    state="AL",
    postal="35204",
    lat=33.511389,
    lng=-86.842778,
    housenumber="400",
    country="USA",
)
TRACK_COLISEUM = SportsballGeocodeTuple(
    city="Wilmington",
    state="NC",
    postal="",
    lat=34.225,
    lng=-77.878333,
    housenumber="",
    country="USA",
)
HUSKIE_STADIUM = SportsballGeocodeTuple(
    city="Dekalb",
    state="IL",
    postal="60115",
    lat=41.934,
    lng=-88.778,
    housenumber="1245",
    country="USA",
)
DIGNITY_HEALTH_SPORTS_PARK = SportsballGeocodeTuple(
    city="Carson",
    state="CA",
    postal="90746",
    lat=33.8643776,
    lng=-118.2660135,
    housenumber="18400",
    country="USA",
)
NEWARK = SportsballGeocodeTuple(
    city="Newark",
    state="NJ",
    postal="",
    lat=40.735556,
    lng=-74.172222,
    housenumber="700",
    country="USA",
)
WALDO_STADIUM = SportsballGeocodeTuple(
    city="Kalamazoo",
    state="MI",
    postal="49008",
    lat=42.285833,
    lng=-85.601111,
    housenumber="1903",
    country="USA",
)
FENWAY_PARK = SportsballGeocodeTuple(
    city="Boston",
    state="MA",
    postal="02297",
    lat=42.34625,
    lng=-71.09775,
    housenumber="4",
    country="USA",
)
UB_STADIUM = SportsballGeocodeTuple(
    city="Buffalo",
    state="NY",
    postal="14228",
    lat=42.999167,
    lng=-78.7775,
    housenumber="",
    country="USA",
)
STARKVILLE = SportsballGeocodeTuple(
    city="Starkville",
    state="MS",
    postal="",
    lat=33.4625,
    lng=-88.82,
    housenumber="",
    country="USA",
)
ROCHESTER = SportsballGeocodeTuple(
    city="Rochester",
    state="NY",
    postal="",
    lat=43.165556,
    lng=-77.616111,
    housenumber="",
    country="USA",
)
BOSTON_COLLEGE = SportsballGeocodeTuple(
    city="Chestnut Hill",
    state="MA",
    postal="",
    lat=42.335,
    lng=-71.170278,
    housenumber="",
    country="USA",
)
KELLY_SHORTS_STADIUM = SportsballGeocodeTuple(
    city="Mount Pleasant",
    state="MI",
    postal="48858",
    lat=43.5775,
    lng=-84.770833,
    housenumber="2300",
    country="USA",
)
GLASS_BOWL = SportsballGeocodeTuple(
    city="Toledo",
    state="OH",
    postal="43606",
    lat=41.656944,
    lng=-83.613611,
    housenumber="3044",
    country="USA",
)
BEAVER_STADIUM = SportsballGeocodeTuple(
    city="University Park",
    state="PA",
    postal="16802",
    lat=40.8121,
    lng=-77.856,
    housenumber="1",
    country="USA",
)
UNIVERSITY_OF_KENTUCKY = SportsballGeocodeTuple(
    city="Lexington",
    state="KY",
    postal="",
    lat=38.0325,
    lng=-84.5025,
    housenumber="",
    country="USA",
)
CALIFORNIA_STATE_UNIVERSITY_FRESNO = SportsballGeocodeTuple(
    city="Fresno",
    state="CA",
    postal="",
    lat=36.813333,
    lng=-119.75,
    housenumber="",
    country="USA",
)
GREEN_BAY = SportsballGeocodeTuple(
    city="Green Bay",
    state="WI",
    postal="",
    lat=44.513333,
    lng=-88.015833,
    housenumber="",
    country="USA",
)
ST_PAUL = SportsballGeocodeTuple(
    city="St. Paul",
    state="MN",
    postal="",
    lat=44.947778,
    lng=-93.103889,
    housenumber="",
    country="USA",
)
VILLANOVA_COLLEGE = SportsballGeocodeTuple(
    city="Villanova",
    state="PA",
    postal="",
    lat=40.03771,
    lng=-75.33755,
    housenumber="",
    country="USA",
)
TEMPE = SportsballGeocodeTuple(
    city="Tempe",
    state="AZ",
    postal="",
    lat=33.412778,
    lng=-111.943056,
    housenumber="",
    country="USA",
)
WAKE_FOREST_COLLEGE = SportsballGeocodeTuple(
    city="Winston-Salem",
    state="NC",
    postal="",
    lat=36.134,
    lng=-80.276,
    housenumber="",
    country="USA",
)
DENVER = SportsballGeocodeTuple(
    city="Denver",
    state="CO",
    postal="",
    lat=39.7392,
    lng=-104.9849,
    housenumber="",
    country="USA",
)
WACO = SportsballGeocodeTuple(
    city="Waco",
    state="TX",
    postal="",
    lat=31.551389,
    lng=-97.155833,
    housenumber="",
    country="USA",
)
NORMAN = SportsballGeocodeTuple(
    city="Norman",
    state="OK",
    postal="",
    lat=35.220833,
    lng=-97.443611,
    housenumber="",
    country="USA",
)
NOTRE_DAME_COLLEGE = SportsballGeocodeTuple(
    city="South Euclid",
    state="OH",
    postal="",
    lat=41.5076,
    lng=-81.5155,
    housenumber="4545",
    country="USA",
)
NORFOLK = SportsballGeocodeTuple(
    city="Norfolk",
    state="VA",
    postal="",
    lat=36.846944,
    lng=-76.285278,
    housenumber="",
    country="USA",
)
BOCA_RATON = SportsballGeocodeTuple(
    city="Boca Raton",
    state="FL",
    postal="",
    lat=26.368611,
    lng=-80.1,
    housenumber="",
    country="USA",
)
TOLEDO = SportsballGeocodeTuple(
    city="Toledo",
    state="OH",
    postal="",
    lat=41.652778,
    lng=-83.537778,
    housenumber="",
    country="USA",
)
WEBER_STATE_COLLEGE = SportsballGeocodeTuple(
    city="Ogden",
    state="UT",
    postal="",
    lat=41.193,
    lng=-111.944,
    housenumber="",
    country="USA",
)
PRINCETON = SportsballGeocodeTuple(
    city="Princeton",
    state="NJ",
    postal="",
    lat=40.358244,
    lng=-74.666728,
    housenumber="",
    country="USA",
)
MANHATTAN = SportsballGeocodeTuple(
    city="Manhattan",
    state="KS",
    postal="",
    lat=39.188611,
    lng=-96.604722,
    housenumber="",
    country="USA",
)
GAINESVILLE = SportsballGeocodeTuple(
    city="Gainesville",
    state="FL",
    postal="",
    lat=29.651997,
    lng=-82.324992,
    housenumber="",
    country="USA",
)
STATEN_ISLAND = SportsballGeocodeTuple(
    city="Staten Island",
    state="NY",
    postal="",
    lat=40.583333,
    lng=-74.15,
    housenumber="",
    country="USA",
)
MONTGOMERY = SportsballGeocodeTuple(
    city="Montgomery",
    state="AL",
    postal="",
    lat=32.3675,
    lng=-86.3,
    housenumber="",
    country="USA",
)
ROBERTSON_STADIUM = SportsballGeocodeTuple(
    city="Houston",
    state="TX",
    postal="77004",
    lat=29.721944,
    lng=-95.349167,
    housenumber="3874",
    country="USA",
)
GONZAGA = SportsballGeocodeTuple(
    city="Spokane",
    state="WA",
    postal="",
    lat=47.6675,
    lng=-117.4025,
    housenumber="",
    country="USA",
)
LANE_STADIUM = SportsballGeocodeTuple(
    city="Blacksburg",
    state="VA",
    postal="24060",
    lat=37.22,
    lng=-80.418056,
    housenumber="285",
    country="USA",
)
M_M_ROBERTS_STADIUM = SportsballGeocodeTuple(
    city="Hattiesburg",
    state="MS",
    postal="39406",
    lat=31.328889,
    lng=-89.331389,
    housenumber="118",
    country="USA",
)
NATIONWIDE_ARENA = SportsballGeocodeTuple(
    city="Columbus",
    state="OH",
    postal="",
    lat=39.969283,
    lng=-83.006111,
    housenumber="200",
    country="USA",
)
CEDAR_FALLS = SportsballGeocodeTuple(
    city="Cedar Falls",
    state="IA",
    postal="",
    lat=42.52352,
    lng=-92.446402,
    housenumber="",
    country="USA",
)
CANADA_LIFE_CENTER = SportsballGeocodeTuple(
    city="Winnipeg",
    state="MB",
    postal="",
    lat=49.892778,
    lng=-97.143611,
    housenumber="300",
    country="Canada",
)
ALUMNI_STADIUM = SportsballGeocodeTuple(
    city="Chestnut Hill",
    state="MA",
    postal="02467",
    lat=42.335,
    lng=-71.166389,
    housenumber="",
    country="USA",
)
KINNICK_STADIUM = SportsballGeocodeTuple(
    city="Iowa City",
    state="IA",
    postal="52240",
    lat=41.658611,
    lng=-91.551111,
    housenumber="886",
    country="USA",
)
SANFORD_STADIUM = SportsballGeocodeTuple(
    city="Athens",
    state="GA",
    postal="30602",
    lat=33.949803,
    lng=-83.373364,
    housenumber="",
    country="USA",
)
_CACHED_GEOCODES: dict[str, Any] = {
    "S.C.G. - Australia": SCG,
    "Victoria Park - Australia": SportsballGeocodeTuple(
        city="Abbotsford",
        state="VIC",
        postal="3067",
        lat=-37.8105167,
        lng=144.9822987,
        housenumber="",
        country="Australia",
    ),
    "Tom Benson Hall of Fame Stadium": TOM_BENSON_HALL_OF_FAME_STADIUM,
    "MetLife Stadium": METLIFE_STADIUM,
    "Gillette Stadium": GILETTE_STADIUM,
    "Acrisure Stadium": ACRISURE_STADIUM,
    "Hard Rock Stadium": HARD_ROCK_STADIUM,
    "M&T Bank Stadium": MTT_BANK_STADIUM,
    "Highmark Stadium": HIGHMARK_STADIUM,
    "U.S. Bank Stadium": US_BANK_STADIUM,
    "Cleveland Browns Stadium": CLEVELAND_BROWNS_STADIUM,
    "EverBank Stadium": EVERBANK_STADIUM,
    "Nissan Stadium": NISSAN_STADIUM,
    "Paycor Stadium": PAYCOR_STADIUM,
    "SoFi Stadium": SOFI_STADIUM,
    "State Farm Stadium": STATE_FARM_STADIUM,
    "Lucas Oil Stadium": LUCAS_OIL_STADIUM,
    "NRG Stadium": NRG_STADIUM,
    "Soldier Field": SOLDIER_FIELD,
    "GEHA Field at Arrowhead Stadium": ARROWHEAD_STADIUM,
    "Bank of America Stadium": BANK_OF_AMERICA_STADIUM,
    "Allegiant Stadium": ALLEGIANT_STADIUM,
    "Empower Field at Mile High": EMPOWER_FIELD,
    "Levi's Stadium": LEVI_STADIUM,
    "Mercedes-Benz Stadium": MERCEDES_BANZ_STADIUM,
    "Raymond James Stadium": RAYMOND_JAMES_STADIUM,
    "Lambeau Field": LAMBEAU_FIELD,
    "Lincoln Financial Field": LINCOLN_FINANCIAL_FIELD,
    "Ford Field": FORD_FIELD,
    "AT&T Stadium": ATT_STADIUM,
    "Lumen Field": LUMEN_FIELD,
    "Caesars Superdome": CAESARS_SUPERDOME,
    "Neo Química Arena": NEO_QUIMICA_ARENA,
    "FedExField": FEDEX_FIELD,
    "Tottenham Hotspur Stadium": TOTTENHAM_HOTSPURS_STADIUM,
    "Wembley Stadium": WEMBLEY_STADIUM,
    "Allianz Arena": ALLIANZ_ARENA,
    "Levi Stadium": LEVI_STADIUM,
    "Levi’s Stadium": LEVI_STADIUM,
    "Deutsche Bank Park": DEUTSCHE_BANK_PARK,
    "Arrowhead Stadium": ARROWHEAD_STADIUM,
    "Paul Brown Stadium": PAYCOR_STADIUM,
    "Trans World Dome": TRANS_WORLD_DOME,
    "Kingdome": LUMEN_FIELD,
    "Georgia Dome": GEORGIA_DOME,
    "Louisiana Superdome": CAESARS_SUPERDOME,
    "Tom Benson Hall of Fame Stadium - Canton - OH - 44708": TOM_BENSON_HALL_OF_FAME_STADIUM,
    "Gillette Stadium - Foxborough - MA - 02035": GILETTE_STADIUM,
    "Lumen Field - Seattle - WA - 98134": LUMEN_FIELD,
    "Paycor Stadium - Cincinnati - OH - 45202": PAYCOR_STADIUM,
    "Ford Field - Detroit - MI - 48226": FORD_FIELD,
    "Hard Rock Stadium - Miami Gardens - FL - 33056": HARD_ROCK_STADIUM,
    "Raymond James Stadium - Tampa - FL - 33607": RAYMOND_JAMES_STADIUM,
    "Huntington Bank Field - Cleveland - OH - 44114": CLEVELAND_BROWNS_STADIUM,
    "State Farm Stadium - Glendale - AZ - 85305": STATE_FARM_STADIUM,
    "Highmark Stadium - Orchard Park - NY - 14127": HIGHMARK_STADIUM,
    "Soldier Field - Chicago - IL - 60605": SOLDIER_FIELD,
    "Bank of America Stadium - Charlotte - NC - 28202": BANK_OF_AMERICA_STADIUM,
    "AT&T Stadium - Arlington - TX - 76011": ATT_STADIUM,
    "M&T Bank Stadium - Baltimore - MD - 21230": MTT_BANK_STADIUM,
    "SoFi Stadium - Inglewood - CA - 90301": SOFI_STADIUM,
    "Caesars Superdome - New Orleans - LA - 70112": CAESARS_SUPERDOME,
    "Allegiant Stadium - Las Vegas - NV - 89118": ALLEGIANT_STADIUM,
    "Lincoln Financial Field - Philadelphia - PA - 19148": LINCOLN_FINANCIAL_FIELD,
    "MetLife Stadium - East Rutherford - NJ - 07073": METLIFE_STADIUM,
    "Mercedes-Benz Stadium - Atlanta - GA - 30313": MERCEDES_BANZ_STADIUM,
    "NRG Stadium - Houston - TX - 77054": NRG_STADIUM,
    "Acrisure Stadium - Pittsburgh - PA - 15212": ACRISURE_STADIUM,
    "Lucas Oil Stadium - Indianapolis - IN - 46225": LUCAS_OIL_STADIUM,
    "Lambeau Field - Green Bay - WI - 54304": LAMBEAU_FIELD,
    "U.S. Bank Stadium - Minneapolis - MN - 55415": US_BANK_STADIUM,
    "Levi's Stadium - Santa Clara - CA - 95054": LEVI_STADIUM,
    "Northwest Stadium - Landover - MD - 20785": FEDEX_FIELD,
    "Nissan Stadium - Nashville - TN - 37213": NISSAN_STADIUM,
    "GEHA Field at Arrowhead Stadium - Kansas City - MO - 64129": ARROWHEAD_STADIUM,
    "EverBank Stadium - Jacksonville - FL - 32202": EVERBANK_STADIUM,
    "Empower Field at Mile High - Denver - CO - 80204": EMPOWER_FIELD,
    "Brunswick St - Australia": SportsballGeocodeTuple(
        city="Fitzroy North",
        state="VIC",
        postal="3068",
        lat=-37.7891016,
        lng=144.9759327,
        housenumber="1",
        country="Australia",
    ),
    "Corio Oval - Australia": SportsballGeocodeTuple(
        city="East Geelong",
        state="VIC",
        postal="3219",
        lat=-38.1525822,
        lng=144.3787522,
        housenumber="5",
        country="Australia",
    ),
    "Lake Oval - Australia": SportsballGeocodeTuple(
        city="Albert Park",
        state="VIC",
        postal="3206",
        lat=-37.8403445,
        lng=144.9458567,
        housenumber="",
        country="Australia",
    ),
    "East Melbourne - Australia": SportsballGeocodeTuple(
        city="Richmond",
        state="VIC",
        postal="3002",
        lat=-37.8174763,
        lng=144.9777351,
        housenumber="",
        country="Australia",
    ),
    "Junction Oval - Australia": SportsballGeocodeTuple(
        city="St Kilda",
        state="VIC",
        postal="3182",
        lat=-37.8559698,
        lng=144.9779958,
        housenumber="",
        country="Australia",
    ),
    "M.C.G. - Australia": MCG,
    "Princes Park - Australia": SportsballGeocodeTuple(
        city="Carlton North",
        state="VIC",
        postal="3054",
        lat=-37.7849821,
        lng=144.9565047,
        housenumber="200-590",
        country="Australia",
    ),
    "Wembley Stadium - London": WEMBLEY_STADIUM,
    "Tottenham Hotspur Stadium - London": TOTTENHAM_HOTSPURS_STADIUM,
    "Punt Rd - Australia": SportsballGeocodeTuple(
        city="East Melbourne",
        state="VIC",
        postal="3002",
        lat=-37.8222208,
        lng=144.9856865,
        housenumber="",
        country="Australia",
    ),
    "Frankfurt Stadium - Frankfurt": DEUTSCHE_BANK_PARK,
    "Windy Hill - Australia": SportsballGeocodeTuple(
        city="Essendon",
        state="VIC",
        postal="3040",
        lat=-37.7515878,
        lng=144.9001347,
        housenumber="",
        country="Australia",
    ),
    "Camping World Stadium - Orlando - FL - 32805": CAMPING_WORLD_STADIUM,
    "Allianz Arena - Munich": ALLIANZ_ARENA,
    "Estadio Azteca - Mexico City": SportsballGeocodeTuple(
        city="Ciudad de México",
        state="CDMX",
        postal="04650",
        lat=19.3028606,
        lng=-99.1553986,
        housenumber="3465",
        country="Mexico",
    ),
    "Glenferrie Oval - Australia": SportsballGeocodeTuple(
        city="Hawthorn",
        state="VIC",
        postal="3122",
        lat=-37.8206183,
        lng=145.0303644,
        housenumber="34",
        country="Australia",
    ),
    "Dignity Health Sports Park - Carson - CA - 90746": DIGNITY_HEALTH_SPORTS_PARK,
    "Arden St - Australia": SportsballGeocodeTuple(
        city="North Melbourne",
        state="VIC",
        postal="3051",
        lat=-37.7989787,
        lng=144.9388898,
        housenumber="204-206",
        country="Australia",
    ),
    "Oakland Coliseum - Oakland - CA - 94621": SportsballGeocodeTuple(
        city="Oakland",
        state="CA",
        postal="94621",
        lat=37.7514142,
        lng=-122.2034855,
        housenumber="204-206",
        country="USA",
    ),
    "Los Angeles Memorial Coliseum - Los Angeles - CA - 90037": LOS_ANGELES_MEMORIAL_COLESIUM,
    "Western Oval - Australia": SportsballGeocodeTuple(
        city="Parkville",
        state="VIC",
        postal="3052",
        lat=-37.7781687,
        lng=144.9505349,
        housenumber="",
        country="Australia",
    ),
    "Twickenham Stadium - London": SportsballGeocodeTuple(
        city="Twickenham",
        state="",
        postal="TW2 7BA",
        lat=51.4559558,
        lng=-0.34408,
        housenumber="200",
        country="UK",
    ),
    "Olympic Park - Australia": SportsballGeocodeTuple(
        city="Heidelberg West",
        state="VIC",
        postal="3081",
        lat=-37.7397886,
        lng=145.0317471,
        housenumber="",
        country="Australia",
    ),
    "Georgia Dome - Atlanta - GA": GEORGIA_DOME,
    "SDCCU Stadium - San Diego - CA": SDCCU_STADIUM,
    "Kardinia Park - Australia": GMHBA_STADIUM,
    "The Dome at America's Center - St. Louis - MO - 63101": TRANS_WORLD_DOME,
    "Huntington Bank Stadium - Minneapolis - MN - 55455": US_BANK_STADIUM,
    "Yarraville Oval - Australia": SportsballGeocodeTuple(
        city="Yarraville",
        state="VIC",
        postal="3013",
        lat=-37.8150875,
        lng=144.8824932,
        housenumber="",
        country="Australia",
    ),
    "Candlestick Park - San Francisco - CA": CANDLESTICK_PARK,
    "Mall of America Field - Minneapolis - MN - 55415": US_BANK_STADIUM,
    "Toorak Park - Australia": SportsballGeocodeTuple(
        city="Armadale",
        state="VIC",
        postal="3143",
        lat=-37.8528107,
        lng=145.0114987,
        housenumber="580",
        country="Australia",
    ),
    "Rogers Centre - Toronto - ON": ROGERS_CENTER,
    "Euroa - Australia": SportsballGeocodeTuple(
        city="Euroa",
        state="VIC",
        postal="3666",
        lat=-36.7464868,
        lng=145.5724273,
        housenumber="",
        country="Australia",
    ),
    "Aloha Stadium - Honolulu - HI - 96818": SportsballGeocodeTuple(
        city="Aiea",
        state="HI",
        postal="96701",
        lat=21.3728016,
        lng=-157.9348645,
        housenumber="99-500",
        country="USA",
    ),
    "Giants Stadium - East Rutherford - NJ": METLIFE_STADIUM,
    "Metrodome - Minneapolis - MN - 55415": US_BANK_STADIUM,
    "North Hobart - Australia": SportsballGeocodeTuple(
        city="North Hobart",
        state="TAS",
        postal="7000",
        lat=-42.8682555,
        lng=147.3146486,
        housenumber="1-5",
        country="Australia",
    ),
    "Texas Stadium - Irving - TX": TEXAS_STADIUM,
    "Yallourn - Australia": SportsballGeocodeTuple(
        city="Yallourn North",
        state="VIC",
        postal="3825",
        lat=-38.1629374,
        lng=146.3595115,
        housenumber="",
        country="Australia",
    ),
    "Albury - Australia": SportsballGeocodeTuple(
        city="Hamilton Valley",
        state="NSW",
        postal="2641",
        lat=-36.0349793,
        lng=146.9073391,
        housenumber="1",
        country="Australia",
    ),
    "Invesco Field - Denver - CO - 80804": EMPOWER_FIELD,
    "Brisbane Exhibition - Australia": SportsballGeocodeTuple(
        city="Bowen Hills",
        state="QLD",
        postal="4006",
        lat=-27.4503048,
        lng=153.0301872,
        housenumber="600",
        country="Australia",
    ),
    "Monster Park - San Francisco - CA - 94124": CANDLESTICK_PARK,
    "RCA Dome - Indianapolis - IN": LUCAS_OIL_STADIUM,
    "Mountain America Stadium - Tempe - AZ - 85287": MOUNTAIN_AMERICA_STADIUM,
    "Veterans Stadium - Philadelphia - PA": LINCOLN_FINANCIAL_FIELD,
    "Silverdome - Pontiac - MI": SILVERDOME,
    "Giants Stadium": METLIFE_STADIUM,
    "Mile High Stadium": EMPOWER_FIELD,
    "Pontiac Silverdome": SILVERDOME,
    "Foxboro Stadium": GILETTE_STADIUM,
    "Veterans Stadium": LINCOLN_FINANCIAL_FIELD,
    "Texas Stadium": TEXAS_STADIUM,
    "Three Rivers Stadium": ACRISURE_STADIUM,
    "Qualcomm Stadium": SDCCU_STADIUM,
    "Sun Devil Stadium": MOUNTAIN_AMERICA_STADIUM,
    "Three Rivers Stadium - Pittsburgh - PA": ACRISURE_STADIUM,
    "Moorabbin Oval - Australia": SportsballGeocodeTuple(
        city="Moorabbin",
        state="VIC",
        postal="3189",
        lat=-37.9371257,
        lng=145.0404112,
        housenumber="3",
        country="Australia",
    ),
    "Vanderbilt Stadium": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="37212",
        lat=36.1438701,
        lng=-86.8284249,
        housenumber="",
        country="USA",
    ),
    "Liberty Bowl Memorial Stadium": LIBERTY_BOWL_MEMORIAL_STADIUM,
    "RFK Stadium": RFK_STADIUM,
    "Astrodome": NRG_STADIUM,
    "Cleveland Municipal Stadium": CLEVELAND_BROWNS_STADIUM,
    "Riverfront Stadium": PAYCOR_STADIUM,
    "Candlestick Park": CANDLESTICK_PARK,
    "Los Angeles Memorial Coliseum": LOS_ANGELES_MEMORIAL_COLESIUM,
    "Coburg Oval - Australia": SportsballGeocodeTuple(
        city="Coburg",
        state="VIC",
        postal="3058",
        lat=-37.7437207,
        lng=144.9671031,
        housenumber="",
        country="Australia",
    ),
    "Waverley Park - Australia": SportsballGeocodeTuple(
        city="Mulgrave",
        state="VIC",
        postal="3170",
        lat=-37.9258818,
        lng=145.1869239,
        housenumber="2A",
        country="Australia",
    ),
    "Rose Bowl": ROSE_BOWL,
    "Miami Orange Bowl": MIAMI_ORANGE_BOWL,
    "Stanford Stadium": STANFORD_STADIUM,
    "Milwaukee County Stadium": MILWAUKEE_COUNTY_STADIUM,
    "Shea Stadium": SHEA_STADIUM,
    "Schaefer Stadium": GILETTE_STADIUM,
    "Yale Bowl": YALE_BOWL,
    "Tiger Stadium": TIGER_STADIUM,
    "War Memorial Stadium": WAR_MEMORIAL_STADIUM,
    "Yankee Stadium": YANKEE_STADIUM,
    "Municipal Stadium": MUNICIPAL_STADIUM,
    "Cotton Bowl": COTTON_BOWL,
    "Kezar Stadium": KEZAR_STADIUM,
    "Franklin Field": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="19104",
        lat=39.9502158,
        lng=-75.1949801,
        housenumber="235",
        country="USA",
    ),
    "Wrigley Field": WRIGLEY_FIELD,
    "City Stadium": CITY_STADIUM,
    "IG Field - Winnipeg - MB": SportsballGeocodeTuple(
        city="Winnipeg",
        state="MB",
        postal="R3T 1Z2",
        lat=49.8077033,
        lng=-97.1456866,
        housenumber="315",
        country="Canada",
    ),
    "Subiaco - Australia": DOMAIN_STADIUM,
    "Rice Stadium": RICE_STADIUM,
    "Gabba - Australia": GABBA,
    "Independence Stadium - 71109": SportsballGeocodeTuple(
        city="Shreveport",
        state="LA",
        postal="71109",
        lat=32.475745,
        lng=-93.7944423,
        housenumber="3301",
        country="USA",
    ),
    "Carrara - Australia": PEOPLE_FIRST_STADIUM,
    "W.A.C.A. - Australia": SportsballGeocodeTuple(
        city="East Perth",
        state="WA",
        postal="6004",
        lat=-31.959812,
        lng=115.874661,
        housenumber="",
        country="Australia",
    ),
    "Los Angeles Memorial Coliseum - Los Angeles, California - United States": LOS_ANGELES_MEMORIAL_COLESIUM,
    "Memorial Stadium (Lincoln) - Terre Haute, Indiana, USA - United States": SportsballGeocodeTuple(
        city="Lincoln",
        state="NE",
        postal="68588",
        lat=40.8206975,
        lng=-96.7081629,
        housenumber="1",
        country="USA",
    ),
    "Kezar Stadium - San Francisco, California - United States": KEZAR_STADIUM,
    "Cotton Bowl - Dallas, Texas - United States": COTTON_BOWL,
    "Wrigley Field - Chicago, Illinois - United States": WRIGLEY_FIELD,
    "Yankee Stadium - Bronx, New York - United States": YANKEE_STADIUM,
    "Tiger Stadium - Baton Rouge, Louisiana, USA - United States": TIGER_STADIUM,
    "Lambeau Field - Green Bay, Wisconsin - United States": LAMBEAU_FIELD,
    "RFK Stadium - Washington DC - United States": RFK_STADIUM,
    "War Memorial Stadium - Little Rock, Arkansas - United States": WAR_MEMORIAL_STADIUM,
    "Three Rivers Stadium - Pittsburgh, PA - United States": ACRISURE_STADIUM,
    "Astrodome - Houston, TX - United States": NRG_STADIUM,
    "Mile High Stadium -  - ": EMPOWER_FIELD,
    "Football Park - Australia": AAMI_STADIUM,
    "Docklands - Australia": MARVEL_STADIUM,
    "Manuka Oval - Australia": MANUKA_OVAL,
    "Stadium Australia - Australia": ENGIE_STADIUM,
    "York Park - Australia": UTAS_STADIUM,
    "Marrara Oval - Australia": TIO_STADIUM,
    "Adelaide Oval - Australia": ADELAIDE_OVAL,
    "Sydney Showground - Australia": ENGIE_STADIUM,
    "Bellerive Oval - Australia": BLUNDSTONE_ARENA,
    "Cazaly's Stadium - Australia": CAZALYS_STADIUM,
    "Wellington - Australia": WESTPAC_STADIUM,
    "Traeger Park - Australia": TRAEGER_PARK,
    "Eureka Stadium - Australia": MARS_STADIUM,
    "Perth Stadium - Australia": OPTUS_STADIUM,
    "Jiangwan Stadium - Australia": JIANGWAN_STADIUM,
    "Soldier Field - Chicago, Illinois - United States": SOLDIER_FIELD,
    "Arrowhead Stadium - Kansas City, Missouri - United States": ARROWHEAD_STADIUM,
    "Yale Bowl - New Haven, Connecticut, USA - United States": YALE_BOWL,
    "Rice Stadium - Houston, Texas, U.S. - United States": RICE_STADIUM,
    "Giants Stadium - New York - United States": METLIFE_STADIUM,
    "Rose Bowl - Hampshire - England": ROSE_BOWL,
    "Riverfront Stadium - Cincinnati, OH - United States": PAYCOR_STADIUM,
    "Kingdome - Seattle, WA - United States": LUMEN_FIELD,
    "Milwaukee County Stadium - Milwaukee, WI - United States": MILWAUKEE_COUNTY_STADIUM,
    "Candlestick Park - San Francisco, CA - United States": CANDLESTICK_PARK,
    "Cleveland Municipal Stadium - Cleveland, OH - United States": CLEVELAND_BROWNS_STADIUM,
    "Stanford Stadium - Stanford, California, USA - United States": STANFORD_STADIUM,
    "Sun Devil Stadium - Tempe, Arizona, USA - United States": MOUNTAIN_AMERICA_STADIUM,
    "Liberty Bowl Memorial Stadium - Memphis, Tennessee, USA - United States": LIBERTY_BOWL_MEMORIAL_STADIUM,
    "Qualcomm Stadium - San Diego, California - United States": SDCCU_STADIUM,
    "Raymond James Stadium - Tampa Bay, Florida, USA - United States": RAYMOND_JAMES_STADIUM,
    "Cleveland Browns Stadium - Cleveland, Ohio - United States": CLEVELAND_BROWNS_STADIUM,
    "Citi Field - Flushing, New York - United States": SHEA_STADIUM,
    "Bruce Stadium - Australia": SportsballGeocodeTuple(
        city="Bruce",
        state="ACT",
        postal="2617",
        lat=-35.249994,
        lng=149.1001351,
        housenumber="",
        country="Australia",
    ),
    "Blacktown - Australia": BLACKTOWN_PARK,
    "Gillette Stadium - Foxborough, Massachusetts - United States": GILETTE_STADIUM,
    "Riverway Stadium - Australia": RIVERWAY_STADIUM,
    "Norwood Oval - Australia": NORWOOD_OVAL,
    "Summit Sports Park - Australia": ADELAIDE_HILLS,
    "Mile High": EMPOWER_FIELD,
    "Nissan Stadium - Nashville, Tennessee, USA - United States": NISSAN_STADIUM,
    "SoFi Stadium - Inglewood, CA - United States": SOFI_STADIUM,
    "Highmark Stadium - Orchard Park, New York - United States": HIGHMARK_STADIUM,
    "Mercedes-Benz Stadium - Atlanta, Georgia - United States": MERCEDES_BANZ_STADIUM,
    "Lucas Oil Stadium - Indianapolis, Indiana, USA - United States": LUCAS_OIL_STADIUM,
    "U.S. Bank Stadium - Minneapolis, Minnesota, USA - United States": US_BANK_STADIUM,
    "Caesars Superdome - New Orleans, Louisiana, United States - United States": CAESARS_SUPERDOME,
    "Acrisure Stadium - Pittsburgh, Pennsylvania, USA - United States": ACRISURE_STADIUM,
    "FedExField - Landover, Maryland, USA - United States": FEDEX_FIELD,
    "M&T Bank Stadium - Baltimore, Maryland - United States": MTT_BANK_STADIUM,
    "Empower Field at Mile High - Denver, Colorado, USA - United States": EMPOWER_FIELD,
    "Lumen Field - Seattle, WA, USA - United States": LUMEN_FIELD,
    "MetLife Stadium - East Rutherford, New Jersey - United States": METLIFE_STADIUM,
    "Lincoln Financial Field - Philadelphia, Pennsylvania - United States": LINCOLN_FINANCIAL_FIELD,
    "Paycor Stadium - Cincinnati, Ohio - United States": PAYCOR_STADIUM,
    "Ford Field - Detroit, Michigan - United States": FORD_FIELD,
    "EverBank Stadium - Jacksonville, Florida - United States": EVERBANK_STADIUM,
    "NRG Stadium - Houston, Texas, USA - United States": NRG_STADIUM,
    "State Farm Stadium - Glendale, Arizona - United States": STATE_FARM_STADIUM,
    "AT&T Stadium - Arlington, Texas, USA - United States": ATT_STADIUM,
    "Bank of America Stadium - Charlotte, NC, United States - United States": BANK_OF_AMERICA_STADIUM,
    "Hard Rock Stadium - Coral Gables, Florida, USA - United States": HARD_ROCK_STADIUM,
    "GEHA Field at Arrowhead Stadium - Kansas City, Missouri, United States - United States": ARROWHEAD_STADIUM,
    "Wembley Stadium - Wembley, London - International": WEMBLEY_STADIUM,
    "Tottenham Hotspur Stadium - Bill Nicholson Way, Tottenham, London - England": TOTTENHAM_HOTSPURS_STADIUM,
    "Deutsche Bank Park - Frankfurt, Germany - Germany": DEUTSCHE_BANK_PARK,
    "Arlington Stadium - Arlington, TX - United States": ATT_STADIUM,
    "Allegiant Stadium - Paradise, Nevada, USA - United States": ALLEGIANT_STADIUM,
    "Neo Química Arena - São Paulo, Brazil - Brazil": NEO_QUIMICA_ARENA,
    "Allianz Arena - Munich, Germany - Germany": ALLIANZ_ARENA,
    "Levi's Stadium - Santa Clara, California, USA - United States": LEVI_STADIUM,
    "MCG": MCG,
    "SCG": SCG,
    "ENGIE Stadium": ENGIE_STADIUM,
    "Adelaide Oval": ADELAIDE_OVAL,
    "Gabba": GABBA,
    "Optus Stadium": OPTUS_STADIUM,
    "Marvel Stadium": MARVEL_STADIUM,
    "Mars Stadium": MARS_STADIUM,
    "GMHBA Stadium": GMHBA_STADIUM,
    "UTAS Stadium": UTAS_STADIUM,
    "People First Stadium": PEOPLE_FIRST_STADIUM,
    "Blundstone Arena": BLUNDSTONE_ARENA,
    "Manuka Oval": MANUKA_OVAL,
    "TIO Stadium": TIO_STADIUM,
    "Norwood Oval": NORWOOD_OVAL,
    "Adelaide Hills": ADELAIDE_HILLS,
    "Traeger Park": TRAEGER_PARK,
    "Cazaly’s Stadium": CAZALYS_STADIUM,
    "Marvl": MARVEL_STADIUM,
    "Accor Stadium": ENGIE_STADIUM,
    "Riverway Stadium": RIVERWAY_STADIUM,
    "Jiangwan Sports Centre": JIANGWAN_STADIUM,
    "Domain Stadium": DOMAIN_STADIUM,
    "Westpac Stadium": WESTPAC_STADIUM,
    "AAMI Stadium": AAMI_STADIUM,
    "Blacktown Park": BLACKTOWN_PARK,
    "Husky Stadium - Seattle - WA - 98195": SportsballGeocodeTuple(
        city="Seattle",
        state="WA",
        postal="98195",
        lat=47.6503,
        lng=-122.3016,
        housenumber="3800",
        country="USA",
    ),
    "L&N Federal Credit Union Stadium - Louisville - KY - 40208": LN_FEDERAL_CREDIT_UNION_STADIUM,
    "Bobcat Stadium (TX) - San Marcos - TX - 78666": SportsballGeocodeTuple(
        city="San Marcos",
        state="TX",
        postal="78666",
        lat=29.891111,
        lng=-97.925556,
        housenumber="1100",
        country="USA",
    ),
    "Rice-Eccles Stadium - Salt Lake City - UT - 84112": SportsballGeocodeTuple(
        city="Salt Lake City",
        state="UT",
        postal="84112",
        lat=40.759975,
        lng=-111.848853,
        housenumber="451",
        country="USA",
    ),
    "Boone Pickens Stadium - Stillwater - OK - 74075": SportsballGeocodeTuple(
        city="Stillwater",
        state="OK",
        postal="74075",
        lat=36.125833,
        lng=-97.066389,
        housenumber="700",
        country="USA",
    ),
    "Cajun Field - Lafayette - LA - 70506": SportsballGeocodeTuple(
        city="Lafayette",
        state="LA",
        postal="70506",
        lat=30.215833,
        lng=-92.041944,
        housenumber="201",
        country="USA",
    ),
    "Ben Hill Griffin Stadium - Gainesville - FL - 32611": SportsballGeocodeTuple(
        city="Gainesville",
        state="FL",
        postal="32611",
        lat=29.6500337,
        lng=-82.3488407,
        housenumber="157",
        country="USA",
    ),
    "Protective Stadium - Birmingham - AL - 35203": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="35203",
        lat=33.5278,
        lng=-86.8092,
        housenumber="",
        country="USA",
    ),
    "Warren McGuirk Alumni Stadium - Amherst - MA - 01003": SportsballGeocodeTuple(
        city="Amherst",
        state="MA",
        postal="01003",
        lat=42.377306,
        lng=-72.536019,
        housenumber="300",
        country="USA",
    ),
    "Doyt L. Perry Stadium - Bowling Green - OH - 43403": SportsballGeocodeTuple(
        city="Bowling Green",
        state="OH",
        postal="43403",
        lat=41.378056,
        lng=-83.6225,
        housenumber="",
        country="USA",
    ),
    "Allegacy Federal Credit Union Stadium - Winston-Salem - NC - 27105": SportsballGeocodeTuple(
        city="Winston-Salem",
        state="NC",
        postal="27105",
        lat=36.130556,
        lng=-80.254722,
        housenumber="411",
        country="USA",
    ),
    "McLane Stadium - Waco - TX - 76704": SportsballGeocodeTuple(
        city="Waco",
        state="TX",
        postal="76704",
        lat=31.5582,
        lng=-97.1157,
        housenumber="1001",
        country="USA",
    ),
    "Autzen Stadium - Eugene - OR - 97401": SportsballGeocodeTuple(
        city="Eugene",
        state="OR",
        postal="97401",
        lat=44.058333,
        lng=-123.068611,
        housenumber="2727",
        country="USA",
    ),
    "Lanny and Sharon Martin Stadium - Evanston - IL - 60208": LANNY_AND_SHARON_MARTIN_STADIUM,
    "Kinnick Stadium - Iowa City - IA - 52240": KINNICK_STADIUM,
    "Carter-Finley Stadium - Raleigh - NC - 27607": SportsballGeocodeTuple(
        city="Raleigh",
        state="NC",
        postal="27607",
        lat=35.800833,
        lng=-78.719444,
        housenumber="4600",
        country="USA",
    ),
    "Bobby Dodd Stadium - Atlanta - GA - 30332": SportsballGeocodeTuple(
        city="Atlanta",
        state="GA",
        postal="30332",
        lat=33.7725,
        lng=-84.392778,
        housenumber="155",
        country="USA",
    ),
    "Aviva Stadium - Dublin": SportsballGeocodeTuple(
        city="Dublin",
        state="",
        postal="D04K5F9",
        lat=53.335278,
        lng=-6.228333,
        housenumber="62",
        country="Ireland",
    ),
    "Doak Campbell Stadium - Tallahassee - FL - 32304": SportsballGeocodeTuple(
        city="Tallahassee",
        state="FL",
        postal="32304",
        lat=30.438056,
        lng=-84.304444,
        housenumber="403",
        country="USA",
    ),
    "Ross-Ade Stadium - West Lafayette - IN - 47906": SportsballGeocodeTuple(
        city="West Lafayette",
        state="IN",
        postal="47906",
        lat=40.434444,
        lng=-86.918333,
        housenumber="850",
        country="USA",
    ),
    "Clarence T.C. Ching Athletics Complex - Honolulu - HI - 96822": SportsballGeocodeTuple(
        city="Honolulu",
        state="HI",
        postal="96822",
        lat=21.294,
        lng=-157.818,
        housenumber="",
        country="USA",
    ),
    "Mackay Stadium - Reno - NV - 89557": SportsballGeocodeTuple(
        city="Reno",
        state="NV",
        postal="89557",
        lat=39.546944,
        lng=-119.8175,
        housenumber="1664",
        country="USA",
    ),
    "Veterans Memorial Stadium (AL) - Troy - AL - 36082": SportsballGeocodeTuple(
        city="Troy",
        state="AL",
        postal="36082",
        lat=31.799444,
        lng=-85.951944,
        housenumber="338",
        country="USA",
    ),
    "Memorial Stadium - Columbia - MO - 65203": SportsballGeocodeTuple(
        city="Columbia",
        state="MO",
        postal="65203",
        lat=38.935833,
        lng=-92.333056,
        housenumber="600",
        country="USA",
    ),
    "Glass Bowl - Toledo - OH - 43606": GLASS_BOWL,
    "Milan Puskar Stadium - Morgantown - WV - 26505": SportsballGeocodeTuple(
        city="Morgantown",
        state="WV",
        postal="26505",
        lat=39.650278,
        lng=-79.954722,
        housenumber="900",
        country="USA",
    ),
    "Ohio Stadium - Columbus - OH - 43210": SportsballGeocodeTuple(
        city="Columbus",
        state="OH",
        postal="43210",
        lat=40.001667,
        lng=-83.019722,
        housenumber="411",
        country="USA",
    ),
    "Memorial Stadium (Bloomington, IN) - Bloomington - IN - 47408": SportsballGeocodeTuple(
        city="Bloomington",
        state="IN",
        postal="47408",
        lat=39.180833,
        lng=-86.525556,
        housenumber="701",
        country="USA",
    ),
    "Jordan-Hare Stadium - Auburn - AL - 36849": SportsballGeocodeTuple(
        city="Auburn",
        state="AL",
        postal="36849",
        lat=32.602222,
        lng=-85.489167,
        housenumber="251",
        country="USA",
    ),
    "Camp Randall Stadium - Madison - WI - 53711": CAMP_RANDALL_STADIUM,
    "War Memorial Stadium (AR) - Little Rock - AR - 72205": SportsballGeocodeTuple(
        city="Little Rock",
        state="AR",
        postal="72205",
        lat=34.749861,
        lng=-92.33,
        housenumber="1",
        country="USA",
    ),
    "AmFirst Stadium - Jacksonville - AL - 36265": SportsballGeocodeTuple(
        city="Jacksonville",
        state="AL",
        postal="36265",
        lat=33.820278,
        lng=-85.766389,
        housenumber="700",
        country="USA",
    ),
    "Jones AT&T Stadium - Lubbock - TX - 79407": SportsballGeocodeTuple(
        city="Lubbock",
        state="TX",
        postal="79407",
        lat=33.591111,
        lng=-101.872778,
        housenumber="2526",
        country="USA",
    ),
    "Bryant-Denny Stadium - Tuscaloosa - AL - 35401": SportsballGeocodeTuple(
        city="Tuscaloosa",
        state="AL",
        postal="35401",
        lat=33.208333,
        lng=-87.550278,
        housenumber="920",
        country="USA",
    ),
    "Dowdy-Ficklen Stadium - Greenville - NC - 37604": SportsballGeocodeTuple(
        city="Greenville",
        state="NC",
        postal="37604",
        lat=35.596389,
        lng=-77.365278,
        housenumber="100",
        country="USA",
    ),
    "SHI Stadium - Piscataway - NJ - 08854": SportsballGeocodeTuple(
        city="Piscataway",
        state="NJ",
        postal="08854",
        lat=40.513611,
        lng=-74.465278,
        housenumber="1",
        country="USA",
    ),
    "Folsom Field - Boulder - CO - 80305": FOLSOM_FIELD,
    "Kroger Field - Lexington - KY - 40506": SportsballGeocodeTuple(
        city="Lexington",
        state="KY",
        postal="40506",
        lat=38.022778,
        lng=-84.505278,
        housenumber="1540",
        country="USA",
    ),
    "Williams Stadium (VA) - Lynchburg - VA - 24502": SportsballGeocodeTuple(
        city="Lynchburg",
        state="VA",
        postal="24502",
        lat=37.354,
        lng=-79.175,
        housenumber="1972",
        country="USA",
    ),
    "JMA Wireless Dome - Syracuse - NY - 13244": JMA_WIRELESS_DOME,
    "Davis Wade Stadium - Starkville - MS - 39762": SportsballGeocodeTuple(
        city="Starkville",
        state="MS",
        postal="39762",
        lat=33.456389,
        lng=-88.793611,
        housenumber="90",
        country="USA",
    ),
    "FBC Mortgage Stadium - Orlando - FL - 32816": SportsballGeocodeTuple(
        city="Orlando",
        state="FL",
        postal="32816",
        lat=28.6091,
        lng=-81.1924,
        housenumber="4465",
        country="USA",
    ),
    "SECU Stadium - College Park - MD - 20742": SportsballGeocodeTuple(
        city="College Park",
        state="MD",
        postal="20742",
        lat=38.990278,
        lng=-76.947222,
        housenumber="90",
        country="USA",
    ),
    "Michigan Stadium - Ann Arbor - MI - 48104": SportsballGeocodeTuple(
        city="Ann Arbor",
        state="MI",
        postal="48104",
        lat=42.2661,
        lng=-83.7508,
        housenumber="1201",
        country="USA",
    ),
    "Memorial Stadium (Champaign, IL) - Champaign - IL - 61820": SportsballGeocodeTuple(
        city="Champaign",
        state="IL",
        postal="61820",
        lat=40.099167,
        lng=-88.235833,
        housenumber="1402",
        country="USA",
    ),
    "Simmons Bank Liberty Stadium - Memphis - TN - 38104": SportsballGeocodeTuple(
        city="Memphis",
        state="TN",
        postal="38104",
        lat=35.121,
        lng=-89.9774,
        housenumber="335",
        country="USA",
    ),
    "Huskie Stadium - Dekalb - IL - 60115": HUSKIE_STADIUM,
    "FirstBank Stadium - Nashville - TN - 37212": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="37212",
        lat=36.144167,
        lng=-86.808889,
        housenumber="",
        country="USA",
    ),
    'Johnny "Red" Floyd Stadium - Murfreesboro - TN - 37130': SportsballGeocodeTuple(
        city="Murfreesboro",
        state="TN",
        postal="37130",
        lat=35.850513,
        lng=-86.368223,
        housenumber="1327",
        country="USA",
    ),
    "Kelly/Shorts Stadium - Mount Pleasant - MI - 48858": KELLY_SHORTS_STADIUM,
    "Kyle Field - College Station - TX - 77840": SportsballGeocodeTuple(
        city="College Station",
        state="TX",
        postal="77840",
        lat=30.6099,
        lng=-96.3405,
        housenumber="756",
        country="USA",
    ),
    "Allen E. Paulson Stadium - Statesboro - GA - 30458": SportsballGeocodeTuple(
        city="Statesboro",
        state="GA",
        postal="30458",
        lat=32.412161,
        lng=-81.783135,
        housenumber="207",
        country="USA",
    ),
    "Stanford Stadium - Stanford - CA - 94305": SportsballGeocodeTuple(
        city="Stanford",
        state="CA",
        postal="94305",
        lat=37.434444,
        lng=-122.161111,
        housenumber="625",
        country="USA",
    ),
    "Wallace Wade Stadium - Durham - NC - 27708": SportsballGeocodeTuple(
        city="Durham",
        state="NC",
        postal="27708",
        lat=35.995278,
        lng=-78.941667,
        housenumber="",
        country="USA",
    ),
    "Vaught-Hemingway Stadium - Oxford - MS - 38655": SportsballGeocodeTuple(
        city="Oxford",
        state="MS",
        postal="38655",
        lat=34.361944,
        lng=-89.534167,
        housenumber="6",
        country="USA",
    ),
    "TDECU Stadium - Houston - TX - 77204": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="77204",
        lat=29.721944,
        lng=-95.349167,
        housenumber="3874",
        country="USA",
    ),
    "Joan C. Edwards Stadium - Huntington - WV - 25703": SportsballGeocodeTuple(
        city="Huntington",
        state="WV",
        postal="25703",
        lat=38.425,
        lng=-82.420833,
        housenumber="2001",
        country="USA",
    ),
    "Hancock Whitney Stadium - Mobile - AL - 36688": SportsballGeocodeTuple(
        city="Mobile",
        state="AL",
        postal="36688",
        lat=30.696904,
        lng=-88.192013,
        housenumber="",
        country="USA",
    ),
    "Maverik Stadium - Logan - UT - 84341": SportsballGeocodeTuple(
        city="Logan",
        state="UT",
        postal="84341",
        lat=41.751667,
        lng=-111.811667,
        housenumber="1000",
        country="USA",
    ),
    "Williams-Brice Stadium - Columbia - SC - 29201": SportsballGeocodeTuple(
        city="Columbia",
        state="SC",
        postal="29201",
        lat=33.973056,
        lng=-81.019167,
        housenumber="1174",
        country="USA",
    ),
    "Spartan Stadium - East Lansing - MI - 48824": SportsballGeocodeTuple(
        city="East Lansing",
        state="MI",
        postal="48824",
        lat=42.728056,
        lng=-84.484722,
        housenumber="1",
        country="USA",
    ),
    "Alamodome - San Antonio - TX - 78203": ALAMODOME,
    "Jack Trice Stadium - Ames - IA - 50011": SportsballGeocodeTuple(
        city="Ames",
        state="IA",
        postal="50011",
        lat=42.014167,
        lng=-93.635833,
        housenumber="1798",
        country="USA",
    ),
    "Arizona Stadium - Tucson - AZ - 85719": SportsballGeocodeTuple(
        city="Tucson",
        state="AZ",
        postal="85719",
        lat=32.229,
        lng=-110.949,
        housenumber="545",
        country="USA",
    ),
    "California Memorial Stadium - Berkeley - CA - 94720": SportsballGeocodeTuple(
        city="Berkeley",
        state="CA",
        postal="94720",
        lat=37.871111,
        lng=-122.250833,
        housenumber="210",
        country="USA",
    ),
    "Memorial Stadium (Norman, OK) - Norman - OK - 73019": SportsballGeocodeTuple(
        city="Norman",
        state="OK",
        postal="73019",
        lat=35.205833,
        lng=-97.4425,
        housenumber="1185",
        country="USA",
    ),
    "Neyland Stadium - Knoxville - TN - 37996": SportsballGeocodeTuple(
        city="Knoxville",
        state="TN",
        postal="37996",
        lat=35.955,
        lng=-83.925,
        housenumber="1235",
        country="USA",
    ),
    "Bill Snyder Family Stadium - Manhattan - KS - 66502": SportsballGeocodeTuple(
        city="Manhattan",
        state="KS",
        postal="66502",
        lat=39.201944,
        lng=-96.593889,
        housenumber="1800",
        country="USA",
    ),
    "Jerry Richardson Stadium - Charlotte - NC - 28223": SportsballGeocodeTuple(
        city="Charlotte",
        state="NC",
        postal="28223",
        lat=35.310556,
        lng=-80.740278,
        housenumber="",
        country="USA",
    ),
    "UB Stadium - Buffalo - NY - 14228": UB_STADIUM,
    "Michie Stadium - West Point - NY - 10996": SportsballGeocodeTuple(
        city="West Point",
        state="NY",
        postal="10996",
        lat=41.3875,
        lng=-73.964167,
        housenumber="700",
        country="USA",
    ),
    "DKR-Texas Memorial Stadium - Austin - TX - 78712": SportsballGeocodeTuple(
        city="Austin",
        state="TX",
        postal="78712",
        lat=30.28367,
        lng=-97.73256,
        housenumber="405",
        country="USA",
    ),
    "Nippert Stadium - Cincinnati - OH - 45221": SportsballGeocodeTuple(
        city="Cincinnati",
        state="OH",
        postal="45221",
        lat=39.1312,
        lng=-84.5162,
        housenumber="2700",
        country="USA",
    ),
    "Rice Stadium - Houston - TX - 77005": RICE_STADIUM,
    "Scott Stadium - Charlottesville - VA - 22903": SportsballGeocodeTuple(
        city="Charlottesville",
        state="VA",
        postal="22903",
        lat=38.031111,
        lng=-78.513611,
        housenumber="1815",
        country="USA",
    ),
    "Memorial Stadium (Lincoln, NE) - Lincoln - NE - 68508": SportsballGeocodeTuple(
        city="Lincoln",
        state="NE",
        postal="68508",
        lat=40.8206,
        lng=-96.706,
        housenumber="600",
        country="USA",
    ),
    "Centennial Bank Stadium - Jonesboro - AR - 72401": SportsballGeocodeTuple(
        city="Jonesboro",
        state="AR",
        postal="72401",
        lat=35.848889,
        lng=-90.667222,
        housenumber="2180",
        country="USA",
    ),
    "Navy-Marine Corps Memorial Stadium - Annapolis - MD - 21401": SportsballGeocodeTuple(
        city="Annapolis",
        state="MD",
        postal="21401",
        lat=38.985,
        lng=-76.507,
        housenumber="550",
        country="USA",
    ),
    "Malone Stadium - Monroe - LA - 71203": SportsballGeocodeTuple(
        city="Monroe",
        state="LA",
        postal="71203",
        lat=32.530833,
        lng=-92.065833,
        housenumber="514",
        country="USA",
    ),
    "Gerald J. Ford Stadium - Dallas - TX - 75205": SportsballGeocodeTuple(
        city="Dallas",
        state="TX",
        postal="75205",
        lat=32.836644,
        lng=-96.783994,
        housenumber="5801",
        country="USA",
    ),
    "CEFCU Stadium - San Jose - CA - 95112": SportsballGeocodeTuple(
        city="San Jose",
        state="CA",
        postal="95112",
        lat=37.31972,
        lng=-121.868333,
        housenumber="1257",
        country="USA",
    ),
    "University Stadium (NM) - Albuquerque - NM - 87106": SportsballGeocodeTuple(
        city="Albuquerque",
        state="NM",
        postal="87106",
        lat=35.066944,
        lng=-106.628333,
        housenumber="1111",
        country="USA",
    ),
    "Snapdragon Stadium - San Diego - CA - 92108": SDCCU_STADIUM,
    "LaVell Edwards Stadium - Provo - UT - 84604": LAVELL_EDWARDS_STADIUM,
    "Joe Aillet Stadium - Ruston - LA - 71270": SportsballGeocodeTuple(
        city="Ruston",
        state="LA",
        postal="71270",
        lat=32.532021,
        lng=-92.655899,
        housenumber="1450",
        country="USA",
    ),
    "Chapman Stadium - Tulsa - OK - 74104": SportsballGeocodeTuple(
        city="Tulsa",
        state="OK",
        postal="74104",
        lat=36.148611,
        lng=-95.943889,
        housenumber="3112",
        country="USA",
    ),
    "Falcon Stadium - USAF Academy - CO - 80840": SportsballGeocodeTuple(
        city="",
        state="CO",
        postal="80840",
        lat=38.997,
        lng=-104.843,
        housenumber="4900",
        country="USA",
    ),
    "Kidd Brewer Stadium - Boone - NC - 28607": SportsballGeocodeTuple(
        city="Boone",
        state="NC",
        postal="28607",
        lat=36.211667,
        lng=-81.685556,
        housenumber="270",
        country="USA",
    ),
    "Aggie Memorial Stadium - Las Cruces - NM - 88003": SportsballGeocodeTuple(
        city="Las Cruces",
        state="NM",
        postal="88003",
        lat=32.27949,
        lng=-106.744288,
        housenumber="",
        country="USA",
    ),
    "Fifth Third Stadium - Kennesaw - GA - 30144": SportsballGeocodeTuple(
        city="Kennesaw",
        state="GA",
        postal="30144",
        lat=34.028967,
        lng=-84.567626,
        housenumber="3200",
        country="USA",
    ),
    "Beaver Stadium - University Park - PA - 16802": BEAVER_STADIUM,
    "Pratt & Whitney Stadium - East Hartford - CT - 06118": SportsballGeocodeTuple(
        city="East Hartford",
        state="CT",
        postal="06118",
        lat=41.759722,
        lng=-72.618889,
        housenumber="615",
        country="USA",
    ),
    "Sanford Stadium - Athens - GA - 30602": SANFORD_STADIUM,
    "Gesa Field - Pullman - WA - 99164": SportsballGeocodeTuple(
        city="Pullman",
        state="WA",
        postal="99164",
        lat=46.732,
        lng=-117.16,
        housenumber="720",
        country="USA",
    ),
    "Houchens Industries-L.T. Smith Stadium - Bowling Green - KY - 42101": SportsballGeocodeTuple(
        city="Bowling Green",
        state="KY",
        postal="42101",
        lat=36.984722,
        lng=-86.459444,
        housenumber="",
        country="USA",
    ),
    "Center Parc Stadium - Atlanta - GA - 30315": SportsballGeocodeTuple(
        city="Atlanta",
        state="GA",
        postal="30315",
        lat=33.735278,
        lng=-84.389444,
        housenumber="755",
        country="USA",
    ),
    "S.B. Ballard Stadium - Norfolk - VA - 23508": SportsballGeocodeTuple(
        city="Norfolk",
        state="VA",
        postal="23508",
        lat=36.8889,
        lng=-76.304878,
        housenumber="5115",
        country="USA",
    ),
    "M. M. Roberts Stadium - Hattiesburg - MS - 39406": M_M_ROBERTS_STADIUM,
    "Tiger Stadium (LA) - Baton Rouge - LA - 70803": SportsballGeocodeTuple(
        city="Baton Rouge",
        state="LA",
        postal="70803",
        lat=30.412222,
        lng=-91.183889,
        housenumber="",
        country="USA",
    ),
    "Valley Children's Stadium - Fresno - CA - 93710": SportsballGeocodeTuple(
        city="Fresno",
        state="CA",
        postal="93710",
        lat=36.814,
        lng=-119.758,
        housenumber="1620",
        country="USA",
    ),
    "Peden Stadium - Athens - OH - 45701": SportsballGeocodeTuple(
        city="Athens",
        state="OH",
        postal="45701",
        lat=39.321111,
        lng=-82.102778,
        housenumber="200",
        country="USA",
    ),
    "Notre Dame Stadium - Notre Dame - IN - 46556": NOTRE_DAME_STADIUM,
    "Lane Stadium - Blacksburg - VA - 24060": LANE_STADIUM,
    "Pitbull Stadium - Miami - FL - 33199": PITBULL_STADIUM,
    "Amon G. Carter Stadium - Fort Worth - TX - 76129": SportsballGeocodeTuple(
        city="Fort Worth",
        state="TX",
        postal="76129",
        lat=32.709722,
        lng=-97.368056,
        housenumber="2850",
        country="USA",
    ),
    "Memorial Stadium (Clemson, SC) - Clemson - SC - 29634": SportsballGeocodeTuple(
        city="Clemson",
        state="SC",
        postal="29634",
        lat=34.678611,
        lng=-82.843056,
        housenumber="",
        country="USA",
    ),
    "Dix Stadium - Kent - OH - 44242": SportsballGeocodeTuple(
        city="Kent",
        state="OH",
        postal="44242",
        lat=41.139167,
        lng=-81.313333,
        housenumber="2227",
        country="USA",
    ),
    "DATCU Stadium - Denton - TX - 76205": SportsballGeocodeTuple(
        city="Denton",
        state="TX",
        postal="76205",
        lat=33.203611,
        lng=-97.159444,
        housenumber="1251",
        country="USA",
    ),
    "FAU Stadium - Boca Raton - FL - 33431": FAU_STADIUM,
    "Kenan Stadium - Chapel Hill - NC - 27514": SportsballGeocodeTuple(
        city="Chapel Hill",
        state="NC",
        postal="27514",
        lat=35.906944,
        lng=-79.047778,
        housenumber="78",
        country="USA",
    ),
    "Brooks Stadium (SC) - Conway - SC - 29526": SportsballGeocodeTuple(
        city="Conway",
        state="SC",
        postal="29526",
        lat=33.7929,
        lng=-79.0175,
        housenumber="540",
        country="USA",
    ),
    "Canvas Stadium - Fort Collins - CO - 80521": SportsballGeocodeTuple(
        city="Fort Collins",
        state="CO",
        postal="80521",
        lat=40.5698965,
        lng=-105.0910097,
        housenumber="751",
        country="USA",
    ),
    "Yulman Stadium - New Orleans - LA - 70118": SportsballGeocodeTuple(
        city="New Orleans",
        state="LA",
        postal="70118",
        lat=29.94482,
        lng=-90.116816,
        housenumber="",
        country="USA",
    ),
    "Bridgeforth Stadium - Harrisonburg - VA - 22807": SportsballGeocodeTuple(
        city="Harrisonburg",
        state="VA",
        postal="22807",
        lat=38.435278,
        lng=-78.873056,
        housenumber="",
        country="USA",
    ),
    "War Memorial Stadium - Laramie - WY - 82070": SportsballGeocodeTuple(
        city="Laramie",
        state="WY",
        postal="82070",
        lat=41.3117075,
        lng=-105.5708596,
        housenumber="",
        country="USA",
    ),
    "Sun Bowl - El Paso - TX - 79902": SportsballGeocodeTuple(
        city="El Paso",
        state="TX",
        postal="79902",
        lat=31.773,
        lng=-106.508,
        housenumber="2701",
        country="USA",
    ),
    "Scheumann Stadium - Muncie - IN - 47304": SportsballGeocodeTuple(
        city="Muncie",
        state="IN",
        postal="47304",
        lat=40.216111,
        lng=-85.416667,
        housenumber="",
        country="USA",
    ),
    "Razorback Stadium - Fayetteville - AR - 72701": SportsballGeocodeTuple(
        city="Fayetteville",
        state="AR",
        postal="72701",
        lat=36.068056,
        lng=-94.178889,
        housenumber="350",
        country="USA",
    ),
    "Reser Stadium - Corvallis - OR - 97331": SportsballGeocodeTuple(
        city="Corvallis",
        state="OR",
        postal="97331",
        lat=44.5595424,
        lng=-123.2839683,
        housenumber="2600",
        country="USA",
    ),
    "Yager Stadium - Oxford - OH - 45056": SportsballGeocodeTuple(
        city="Oxford",
        state="OH",
        postal="45056",
        lat=39.5195227,
        lng=-84.7355128,
        housenumber="",
        country="USA",
    ),
    "Rose Bowl - Pasadena - CA - 91103": ROSE_BOWL,
    "Waldo Stadium - Kalamazoo - MI - 49008": WALDO_STADIUM,
    "InfoCision Stadium - Akron - OH - 44304": SportsballGeocodeTuple(
        city="Akron",
        state="OH",
        postal="44304",
        lat=41.072347,
        lng=-81.508019,
        housenumber="",
        country="USA",
    ),
    "Rynearson Stadium - Ypsilanti - MI - 48197": SportsballGeocodeTuple(
        city="Ypsilanti",
        state="MI",
        postal="48197",
        lat=42.2558889,
        lng=-83.6499574,
        housenumber="799",
        country="USA",
    ),
    "Children's Mercy Park - Kansas City - KS - 66111": SportsballGeocodeTuple(
        city="Kansas City",
        state="KS",
        postal="66111",
        lat=39.12174,
        lng=-94.82318,
        housenumber="1",
        country="USA",
    ),
    "Elliott T. Bowers Stadium - Huntsville - TX - 77340": SportsballGeocodeTuple(
        city="Huntsville",
        state="TX",
        postal="77340",
        lat=30.713889,
        lng=-95.541667,
        housenumber="620",
        country="USA",
    ),
    "Alumni Stadium (Chestnut Hill, MA) - Chestnut Hill - MA - 02467": ALUMNI_STADIUM,
    "Albertsons Stadium - Boise - ID - 83706": SportsballGeocodeTuple(
        city="Boise",
        state="ID",
        postal="83706",
        lat=43.603,
        lng=-116.196,
        housenumber="1400",
        country="USA",
    ),
    "Cotton Bowl - Dallas - TX - 75215": COTTON_BOWL,
    "Wrigley Field - Chicago - IL - 60613": WRIGLEY_FIELD,
    "Yankee Stadium - Bronx - NY - 10451": SportsballGeocodeTuple(
        city="Bronx",
        state="NY",
        postal="10451",
        lat=40.829167,
        lng=-73.926389,
        housenumber="1",
        country="USA",
    ),
    "Cramton Bowl - Montgomery - AL - 36107": SportsballGeocodeTuple(
        city="Montgomery",
        state="AL",
        postal="36107",
        lat=32.37949,
        lng=-86.293002,
        housenumber="1022",
        country="USA",
    ),
    "Fenway Park - Boston - MA - 02297": FENWAY_PARK,
    "Toyota Stadium - Frisco - TX - 75033": TOYOTA_STADIUM,
    "Chase Field - Phoenix - AZ - 85004": SportsballGeocodeTuple(
        city="Phoenix",
        state="AZ",
        postal="85004",
        lat=33.445278,
        lng=-112.066944,
        housenumber="401",
        country="USA",
    ),
    "Thomas A. Robinson National Stadium - Nassau": SportsballGeocodeTuple(
        city="Nassau",
        state="",
        postal="",
        lat=25.054381,
        lng=-77.360217,
        housenumber="",
        country="Bahamas",
    ),
    "Independence Stadium - Shreveport - LA - 71109": SportsballGeocodeTuple(
        city="Shreveport",
        state="LA",
        postal="71109",
        lat=32.475556,
        lng=-93.791944,
        housenumber="",
        country="USA",
    ),
    "David Booth Kansas Memorial Stadium - Lawrence - KS - 66044": SportsballGeocodeTuple(
        city="Lawrence",
        state="KS",
        postal="66044",
        lat=38.963333,
        lng=-95.246389,
        housenumber="1101",
        country="USA",
    ),
    "Riccardo Silva Stadium - Miami - FL - 33199": PITBULL_STADIUM,
    "Ryan Field - Evanston - IL - 60208": LANNY_AND_SHARON_MARTIN_STADIUM,
    "Petco Park - San Diego - CA - 92101": PETCO_PARK,
    "Providence Park - Portland - OR - 97205": SportsballGeocodeTuple(
        city="Portland",
        state="OR",
        postal="97205",
        lat=45.521389,
        lng=-122.691667,
        housenumber="1844",
        country="USA",
    ),
    "Choctaw Stadium - Arlington - TX - 76011": SportsballGeocodeTuple(
        city="Arlington",
        state="TX",
        postal="76011",
        lat=32.751389,
        lng=-97.082778,
        housenumber="1000",
        country="USA",
    ),
    "Inter&Co Stadium - Orlando - FL - 32805": SportsballGeocodeTuple(
        city="Orlando",
        state="FL",
        postal="32805",
        lat=28.5411,
        lng=-81.3893,
        housenumber="655",
        country="USA",
    ),
    "Legion Field (AL) - Birmingham - AL - 35204": LEGION_FIELD,
    "Sam Boyd Stadium - Las Vegas - NV - 89122": SportsballGeocodeTuple(
        city="Las Vegas",
        state="NV",
        postal="89122",
        lat=36.086,
        lng=-115.017,
        housenumber="7000",
        country="USA",
    ),
    "HighPoint.com Stadium - Piscataway - NJ - 08854": SportsballGeocodeTuple(
        city="Piscataway",
        state="NJ",
        postal="08854",
        lat=40.513611,
        lng=-74.465278,
        housenumber="1",
        country="USA",
    ),
    "SDCCU Stadium - San Diego - CA - 92108": SDCCU_STADIUM,
    "Ladd-Peebles Stadium - Mobile - AL - 36604": SportsballGeocodeTuple(
        city="Mobile",
        state="AL",
        postal="36604",
        lat=30.673,
        lng=-88.076,
        housenumber="1621",
        country="USA",
    ),
    "loanDepot park - Miami - FL - 33125": MIAMI_ORANGE_BOWL,
    "Barker-Lane Stadium - Buies Creek - NC - 27546": SportsballGeocodeTuple(
        city="Buies Creek",
        state="NC",
        postal="27546",
        lat=35.4046,
        lng=-78.7427,
        housenumber="558",
        country="USA",
    ),
    "Kibbie Dome - Moscow - ID - 83844": KIBBIE_DOME,
    "Allianz Stadium - Sydney - NSW": SCG,
    "Tropicana Field - St. Petersburg - FL - 33705": SportsballGeocodeTuple(
        city="St. Petersburg",
        state="FL",
        postal="33705",
        lat=27.768333,
        lng=-82.653333,
        housenumber="1",
        country="USA",
    ),
    "ANZ Stadium - Sydney - NSW": ENGIE_STADIUM,
    "Hughes Stadium (CO) - Fort Collins - CO - 80526": SportsballGeocodeTuple(
        city="Fort Collins",
        state="CO",
        postal="80526",
        lat=40.562,
        lng=-105.142,
        housenumber="",
        country="USA",
    ),
    "Bristol Motor Speedway - Bristol - TN - 37620": SportsballGeocodeTuple(
        city="Bristol",
        state="TN",
        postal="37620",
        lat=36.5156,
        lng=-82.2569,
        housenumber="151",
        country="USA",
    ),
    "Rate Field - Chicago - IL - 60616": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="60616",
        lat=41.83,
        lng=-87.633889,
        housenumber="333",
        country="USA",
    ),
    "Croke Park Stadium - Dublin": CROKE_PARK,
    "Yale Bowl - New Haven - CT - 06515": YALE_BOWL,
    "Floyd Casey Stadium - Waco - TX - 76798": SportsballGeocodeTuple(
        city="Waco",
        state="TX",
        postal="76798",
        lat=31.531342,
        lng=-97.148731,
        housenumber="3088",
        country="USA",
    ),
    'William "Dick" Price Stadium - Norfolk - VA - 23504': SportsballGeocodeTuple(
        city="Norfolk",
        state="VA",
        postal="23504",
        lat=36.846964,
        lng=-76.260053,
        housenumber="700",
        country="USA",
    ),
    "Superior Dome - Marquette - MI - 49855": SportsballGeocodeTuple(
        city="Marquette",
        state="MI",
        postal="49855",
        lat=46.56,
        lng=-87.393611,
        housenumber="",
        country="USA",
    ),
    "Robertson Stadium - Houston - TX - 77004": ROBERTSON_STADIUM,
    "Roy Kidd Stadium - Richmond - KY - 40475": SportsballGeocodeTuple(
        city="Richmond",
        state="KY",
        postal="40475",
        lat=37.73439,
        lng=-84.29741,
        housenumber="",
        country="USA",
    ),
    "Capital One Arena, Washington, District of Columbia": CAPITAL_ONE_ARENA,
    "Stan Sheriff Center, Honolulu, Hawaii": STAN_SHERIFF_CENTER,
    "Value City Arena, Columbus, Ohio": SportsballGeocodeTuple(
        city="Columbus",
        state="OH",
        postal="",
        lat=40.007511,
        lng=-83.025102,
        housenumber="555",
        country="USA",
    ),
    "James A. Rhodes Arena, Akron, Ohio": SportsballGeocodeTuple(
        city="Akron",
        state="OH",
        postal="44303",
        lat=41.075833,
        lng=-81.508611,
        housenumber="373",
        country="USA",
    ),
    "Resch Center, Green Bay, Wisconsin": SportsballGeocodeTuple(
        city="Green Bay",
        state="WI",
        postal="",
        lat=44.499547,
        lng=-88.055049,
        housenumber="820",
        country="USA",
    ),
    "Hagan Arena, Philadelphia, Pennsylvania": HAGAN_ARENA,
    "Wells Fargo Center, Philadelphia, Pennsylvania": SPECTRUM,
    "UW-Milwaukee Panther Arena, Milwaukee, Wisconsin": MILWAUKEE_ARENA,
    "Pauley Pavilion, Los Angeles, California": SportsballGeocodeTuple(
        city="Los Angeles",
        state="CA",
        postal="",
        lat=34.070211,
        lng=-118.446775,
        housenumber="301",
        country="USA",
    ),
    "Save Mart Center, Fresno, California": SportsballGeocodeTuple(
        city="Fresno",
        state="CA",
        postal="",
        lat=36.809722,
        lng=-119.738611,
        housenumber="2650",
        country="USA",
    ),
    "The Pit, Albuquerque, New Mexico": THE_PIT,
    "Gill Coliseum, Corvallis, Oregon": SportsballGeocodeTuple(
        city="Corvallis",
        state="OR",
        postal="",
        lat=44.5613,
        lng=-123.2805,
        housenumber="660",
        country="USA",
    ),
    "Liacouras Center, Philadelphia, Pennsylvania": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="",
        lat=39.979722,
        lng=-75.158611,
        housenumber="1776",
        country="USA",
    ),
    "Williams Arena, Minneapolis, Minnesota": SportsballGeocodeTuple(
        city="Minneapolis",
        state="MN",
        postal="55455",
        lat=44.976944,
        lng=-93.228333,
        housenumber="1925",
        country="USA",
    ),
    "John W. Pope Jr. Convocation Center, Buies Creek, North Carolina": SportsballGeocodeTuple(
        city="Buies Creek",
        state="NC",
        postal="27506",
        lat=35.407905,
        lng=-78.736696,
        housenumber="",
        country="USA",
    ),
    "Bob Carpenter Center, Newark, Delaware": SportsballGeocodeTuple(
        city="Newark",
        state="DE",
        postal="",
        lat=39.660556,
        lng=-75.748639,
        housenumber="631",
        country="USA",
    ),
    "FIU Arena, Miami, Florida": SportsballGeocodeTuple(
        city="Miami",
        state="FL",
        postal="33199-2516",
        lat=25.756667,
        lng=-80.379444,
        housenumber="11200",
        country="USA",
    ),
    "UMBC Event Center, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="21250",
        lat=39.252342,
        lng=-76.707431,
        housenumber="1000",
        country="USA",
    ),
    "Ted Constant Convocation Ctr., Norfolk, Virginia": TED_CONSTANT_CONVOCATION_CENTER,
    "Yanitelli Center, Jersey City, New Jersey": SportsballGeocodeTuple(
        city="Jersey City",
        state="NJ",
        postal="07306",
        lat=40.727648,
        lng=-74.073173,
        housenumber="2641",
        country="USA",
    ),
    "Edmunds Center, DeLand, Florida": SportsballGeocodeTuple(
        city="DeLand",
        state="FL",
        postal="32723",
        lat=29.039584,
        lng=-81.301819,
        housenumber="143",
        country="USA",
    ),
    "Pinnacle Bank Arena, Lincoln, Nebraska": SportsballGeocodeTuple(
        city="Lincoln",
        state="NE",
        postal="",
        lat=40.817778,
        lng=-96.713333,
        housenumber="400",
        country="USA",
    ),
    "Welsh-Ryan Arena, Evanston, Illinois": SportsballGeocodeTuple(
        city="Evanston",
        state="IL",
        postal="60201",
        lat=42.066944,
        lng=-87.692778,
        housenumber="2705",
        country="USA",
    ),
    "Gentry Center Complex, Nashville, Tennessee": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.168889,
        lng=-86.829444,
        housenumber="",
        country="USA",
    ),
    "Eblen Center, Cookeville, Tennessee": SportsballGeocodeTuple(
        city="Cookeville",
        state="TN",
        postal="",
        lat=36.178508,
        lng=-85.51,
        housenumber="1100",
        country="USA",
    ),
    "The Thunderdome, Santa Barbara, California": SportsballGeocodeTuple(
        city="Santa Barbara",
        state="CA",
        postal="",
        lat=34.413792,
        lng=-119.851147,
        housenumber="",
        country="USA",
    ),
    "Jenny Craig Pavillion, San Diego, California": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="",
        lat=32.7745,
        lng=-117.1837,
        housenumber="5998",
        country="USA",
    ),
    "Physical Education Complex, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="21216",
        lat=39.315453,
        lng=-76.657381,
        housenumber="2500",
        country="USA",
    ),
    "Estelle and Zoom Fleisher Athletic Center, Newark, New Jersey": SportsballGeocodeTuple(
        city="Newark",
        state="NJ",
        postal="",
        lat=40.743125,
        lng=-74.182161,
        housenumber="",
        country="USA",
    ),
    "SEFCU Arena, Albany, New York": SportsballGeocodeTuple(
        city="Albany",
        state="NY",
        postal="12222",
        lat=42.681667,
        lng=-73.828333,
        housenumber="1400",
        country="USA",
    ),
    "Knights Hall, Louisville, Kentucky": SportsballGeocodeTuple(
        city="Louisville",
        state="KY",
        postal="40205",
        lat=38.2215197,
        lng=-85.7077667,
        housenumber="2000",
        country="USA",
    ),
    "Alico Arena, Fort Myers, Florida": SportsballGeocodeTuple(
        city="Fort Myers",
        state="FL",
        postal="",
        lat=26.471111,
        lng=-81.764722,
        housenumber="",
        country="USA",
    ),
    "The HTC Center, Conway, South Carolina": HTC_CENTER,
    "Daskalakis Athletic Center, Philadelphia, Pennsylvania": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="",
        lat=39.956389,
        lng=-75.190833,
        housenumber="",
        country="USA",
    ),
    "Leo D. Mahoney Arena, Fairfield, Connecticut": SportsballGeocodeTuple(
        city="Fairfield",
        state="CT",
        postal="06824",
        lat=41.159722,
        lng=-73.256667,
        housenumber="",
        country="USA",
    ),
    "Convocation Center, Hampton, Virginia": HAMPTON_CONVOCATION_CENTER,
    "Hynes Athletics Center, New Rochelle, New York": HYNES_ATHELTIC_CENTER,
    "Swisher Gymnasium, Jacksonville, Florida": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="32211",
        lat=30.350278,
        lng=-81.605,
        housenumber="1",
        country="USA",
    ),
    "Pete Mathews Coliseum, Jacksonville, Alabama": SportsballGeocodeTuple(
        city="Jacksonville",
        state="AL",
        postal="36265",
        lat=33.824,
        lng=-85.773,
        housenumber="700",
        country="USA",
    ),
    "Atlantic Union Bank Center, Harrisonburg, Virginia": SportsballGeocodeTuple(
        city="Harrisonburg",
        state="VA",
        postal="",
        lat=38.430437,
        lng=-78.859574,
        housenumber="645",
        country="USA",
    ),
    "KSU Convocation Center , Kennesaw, Georgia": KSU_CONVOCATION_CENTER,
    "Ellis T. Johnson Arena, Morehead, Kentucky": SportsballGeocodeTuple(
        city="Morehead",
        state="KY",
        postal="40351",
        lat=38.188786,
        lng=-83.429006,
        housenumber="111",
        country="USA",
    ),
    "Ellis Corbett Sports Center, Greensboro, North Carolina": CORBETT_SPORTS_CENTER,
    "Trask Coliseum, Wilmington, North Carolina": TRACK_COLISEUM,
    "UNF Arena , Jacksonville, Florida": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="32224",
        lat=30.2734,
        lng=-81.5079,
        housenumber="11852",
        country="USA",
    ),
    "Alumni Gymnasium, Lawrenceville, New Jersey": SportsballGeocodeTuple(
        city="Lawrenceville",
        state="NJ",
        postal="",
        lat=40.2788,
        lng=-74.7354,
        housenumber="",
        country="USA",
    ),
    "MVP Arena, Albany, New York": MVP_ARENA,
    "SECU Arena, Towson, Maryland": SportsballGeocodeTuple(
        city="Towson",
        state="MD",
        postal="21252",
        lat=39.387361,
        lng=-76.617083,
        housenumber="8000",
        country="USA",
    ),
    "Roy L. Patrick Gymnasium, Burlington, Vermont": SportsballGeocodeTuple(
        city="Burlington",
        state="VT",
        postal="",
        lat=44.470264,
        lng=-73.194705,
        housenumber="97",
        country="USA",
    ),
    "Convocation Center, Jonesboro, Arkansas": SportsballGeocodeTuple(
        city="Jonesboro",
        state="AR",
        postal="72401",
        lat=35.845422,
        lng=-90.670319,
        housenumber="217",
        country="USA",
    ),
    "Reed Gym, Pocatello, Idaho": SportsballGeocodeTuple(
        city="Pocatello",
        state="ID",
        postal="",
        lat=42.8645,
        lng=-112.429,
        housenumber="936",
        country="USA",
    ),
    "Scheels Center, Fargo, North Dakota": SCHEELS_ARENA,
    "Findlay Toyota Court at Walkup Skydome, Flagstaff, Arizona": WALKUP_SKYDOME,
    "Sanford Coyote Sports Center, Vermillon, South Dakota": SportsballGeocodeTuple(
        city="Vermillon",
        state="SD",
        postal="57069",
        lat=42.790111,
        lng=-96.927806,
        housenumber="",
        country="USA",
    ),
    "Screaming Eagles Arena, Evansville, Indiana": SportsballGeocodeTuple(
        city="Evansville",
        state="IN",
        postal="47712",
        lat=37.961944,
        lng=-87.674722,
        housenumber="8600",
        country="USA",
    ),
    "Wisdom Gym, Stephenville, Texas": WISDOM_GYM,
    "Skyhawk Arena, Martin, Tennessee": SportsballGeocodeTuple(
        city="Martin",
        state="TN",
        postal="",
        lat=36.343648,
        lng=-88.867185,
        housenumber="95",
        country="USA",
    ),
    "College Park Center, Arlington, Texas": SportsballGeocodeTuple(
        city="Arlington",
        state="TX",
        postal="76019",
        lat=32.730586,
        lng=-97.107972,
        housenumber="600",
        country="USA",
    ),
    "GCU Arena, Phoenix, Arizona": SportsballGeocodeTuple(
        city="Phoenix",
        state="AZ",
        postal="85017",
        lat=33.510152,
        lng=-112.128884,
        housenumber="3300",
        country="USA",
    ),
    "Liberty Arena, Lynchburg, Virginia": SportsballGeocodeTuple(
        city="Lynchburg",
        state="VA",
        postal="",
        lat=37.349356,
        lng=-79.180225,
        housenumber="",
        country="USA",
    ),
    "Bank of Colorado Arena, Greeley, Colorado": BANK_OF_COLORADO_ARENA,
    "Dee Events Center, Ogden, Utah": SportsballGeocodeTuple(
        city="Ogden",
        state="UT",
        postal="",
        lat=41.1825,
        lng=-111.945,
        housenumber="4400",
        country="USA",
    ),
    "Robert A. Mott Athletics Center, San Luis Obispo, California": ROBERT_A_MOTT_GYMNASIUM,
    "Bren Events Center, Irvine, California": SportsballGeocodeTuple(
        city="Irvine",
        state="CA",
        postal="92612",
        lat=33.649167,
        lng=-117.846944,
        housenumber="100",
        country="USA",
    ),
    "The Walter Pyramid, Long Beach, California": SportsballGeocodeTuple(
        city="Long Beach",
        state="CA",
        postal="90840",
        lat=33.787222,
        lng=-118.114167,
        housenumber="1250",
        country="USA",
    ),
    "Albert Gersten Pavilion, Los Angeles, California": GERSTEN_PAVILION,
    "Firestone Fieldhouse, Malibu, California": SportsballGeocodeTuple(
        city="Malibu",
        state="CA",
        postal="",
        lat=34.038571,
        lng=-118.709625,
        housenumber="",
        country="USA",
    ),
    "Chiles Center, Portland, Oregon": SportsballGeocodeTuple(
        city="Portland",
        state="OR",
        postal="",
        lat=45.575,
        lng=-122.728,
        housenumber="",
        country="USA",
    ),
    "Redhawk Center, Seattle, Washington": REDHAWK_CENTER,
    "James H. Hilton Coliseum , Ames, Iowa": JAMES_H_HILTON_COLISEUM,
    "Thompson-Boling Arena, Knoxville, Tennessee": SportsballGeocodeTuple(
        city="Knoxville",
        state="TN",
        postal="37916",
        lat=35.951167,
        lng=-83.925028,
        housenumber="1600",
        country="USA",
    ),
    "Hofheinz Pavilion, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="77004",
        lat=29.724722,
        lng=-95.346944,
        housenumber="3875",
        country="USA",
    ),
    "Breslin Events Center, East Lansing, Michigan": BRESLIN_EVENTS_CENTER,
    "Alaska Airlines Arena, Seattle, Washington": SportsballGeocodeTuple(
        city="Seattle",
        state="WA",
        postal="",
        lat=47.652,
        lng=-122.302,
        housenumber="3870",
        country="USA",
    ),
    "Thomas & Mack Center, Las Vegas, Nevada": THOMAS_AND_MACK_CENTER,
    "Christl Arena, West Point, New York": SportsballGeocodeTuple(
        city="West Point",
        state="NY",
        postal="10996",
        lat=41.38641,
        lng=-73.96571,
        housenumber="600",
        country="USA",
    ),
    "The McKenzie Arena, Chattanooga, Tennessee": SportsballGeocodeTuple(
        city="Chattanooga",
        state="TN",
        postal="37403",
        lat=35.050382,
        lng=-85.30091,
        housenumber="720",
        country="USA",
    ),
    "University of Dayton Arena, Dayton, Ohio": SportsballGeocodeTuple(
        city="Dayton",
        state="OH",
        postal="45417",
        lat=39.7348749,
        lng=-84.2021489,
        housenumber="1801",
        country="USA",
    ),
    "John Glaser Arena, Philadelphia, Pennsylvania": JOHN_GLASER_ARENA,
    "University Center, Hammond, Louisiana": SportsballGeocodeTuple(
        city="Hammond",
        state="LA",
        postal="70401",
        lat=30.52,
        lng=-90.472778,
        housenumber="",
        country="USA",
    ),
    "Donald N. Dedmon Center, Radford, Virginia": SportsballGeocodeTuple(
        city="Radford",
        state="VA",
        postal="24141",
        lat=37.1386,
        lng=-80.541769,
        housenumber="101",
        country="USA",
    ),
    "Knapp Center, Des Moines, Iowa": SportsballGeocodeTuple(
        city="Des Moines",
        state="IA",
        postal="50311",
        lat=41.604444,
        lng=-93.651944,
        housenumber="2601",
        country="USA",
    ),
    "Joseph J. Gentile Center, Chicago, Illinois": JOSEPH_J_GENTILES_CENTER,
    "JQH Arena, Springfield, Missouri": GREAT_SOUTHERN_BANK_ARENA,
    "Case Gym, Boston, Massachusetts": SportsballGeocodeTuple(
        city="Boston",
        state="MA",
        postal="",
        lat=42.353932,
        lng=-71.120355,
        housenumber="285",
        country="USA",
    ),
    "Kimmel Arena, Asheville, North Carolina": SportsballGeocodeTuple(
        city="Asheville",
        state="NC",
        postal="28804",
        lat=35.6181,
        lng=-82.5689,
        housenumber="227",
        country="USA",
    ),
    "Memorial Gymnasium, Nashville, Tennessee": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="37235",
        lat=36.144611,
        lng=-86.80742,
        housenumber="",
        country="USA",
    ),
    "Cameron Hall, Lexington, Virginia": SportsballGeocodeTuple(
        city="Lexington",
        state="VA",
        postal="24450",
        lat=37.788333,
        lng=-79.436389,
        housenumber="401",
        country="USA",
    ),
    "Lawrence Joel Coliseum, Winston-Salem, North Carolina": SportsballGeocodeTuple(
        city="Winston-Salem",
        state="NC",
        postal="27105",
        lat=36.127866,
        lng=-80.257628,
        housenumber="2825",
        country="USA",
    ),
    "Winthrop Coliseum, Rock Hill, South Carolina": SportsballGeocodeTuple(
        city="Rock Hill",
        state="SC",
        postal="29730",
        lat=34.947911,
        lng=-81.014972,
        housenumber="1162",
        country="USA",
    ),
    "Sojka Pavilion, Lewisburg, Pennsylvania": SportsballGeocodeTuple(
        city="Lewisburg",
        state="PA",
        postal="17837",
        lat=40.956964,
        lng=-76.887093,
        housenumber="701",
        country="USA",
    ),
    "Hinkle Fieldhouse, Indianapolis, Indiana": SportsballGeocodeTuple(
        city="Indianapolis",
        state="IN",
        postal="",
        lat=39.843611,
        lng=-86.167222,
        housenumber="510",
        country="USA",
    ),
    "Henry J. Goodman Arena, Cleveland, Ohio": SportsballGeocodeTuple(
        city="Cleveland",
        state="OH",
        postal="",
        lat=41.499167,
        lng=-81.676944,
        housenumber="2000",
        country="USA",
    ),
    "Rose Hill Gym, Bronx, New York": ROSE_HILL_GYM,
    "Bon Secours Wellness Arena, Greenville, South Carolina": SportsballGeocodeTuple(
        city="Greenville",
        state="SC",
        postal="",
        lat=34.852789,
        lng=-82.391458,
        housenumber="650",
        country="USA",
    ),
    "Charles E. Smith Center, Washington, District of Columbia": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="20052",
        lat=38.897755,
        lng=-77.049329,
        housenumber="600",
        country="USA",
    ),
    "Burr Gymnasium, Washington, District of Columbia": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="",
        lat=38.9264,
        lng=-77.0221,
        housenumber="",
        country="USA",
    ),
    "Fant-Ewing Coliseum, Monroe, Louisiana": SportsballGeocodeTuple(
        city="Monroe",
        state="LA",
        postal="",
        lat=32.531,
        lng=-92.069,
        housenumber="4319",
        country="USA",
    ),
    "Alumni Hall, Annapolis, Maryland": SportsballGeocodeTuple(
        city="Annapolis",
        state="MD",
        postal="21402",
        lat=38.984491,
        lng=-76.487782,
        housenumber="461",
        country="USA",
    ),
    "Dean Smith Center, Chapel Hill, North Carolina": DEAN_SMITH_CENTER,
    "Greensboro Coliseum, Greensboro, North Carolina": GREENSBORO_COLISEUM,
    "Athletics Center O'rena, Rochester, Michigan": ATHELTICS_CENTER_ORENA,
    "Yuengling Center, Tampa, Florida": YUENGLING_CENTER,
    "Reilly Center, St. Bonaventure, New York": SportsballGeocodeTuple(
        city="St. Bonaventure",
        state="NY",
        postal="",
        lat=42.079428,
        lng=-78.484998,
        housenumber="",
        country="USA",
    ),
    "Devlin Fieldhouse, New Orleans, Louisiana": SportsballGeocodeTuple(
        city="New Orleans",
        state="LA",
        postal="70118",
        lat=29.938611,
        lng=-90.120556,
        housenumber="",
        country="USA",
    ),
    "Cassell Coliseum, Blacksburg, Virginia": SportsballGeocodeTuple(
        city="Blacksburg",
        state="VA",
        postal="",
        lat=37.222222,
        lng=-80.418889,
        housenumber="675",
        country="USA",
    ),
    "Ervin J. Nutter Center, Dayton, Ohio": NUTTER_CENTER,
    "Carver Arena, Peoria, Illinois": SportsballGeocodeTuple(
        city="Peoria",
        state="IL",
        postal="61602-1423",
        lat=40.691667,
        lng=-89.594167,
        housenumber="201",
        country="USA",
    ),
    "UIC Pavilion, Chicago, Illinois": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="60607",
        lat=41.874722,
        lng=-87.656111,
        housenumber="525",
        country="USA",
    ),
    "Mitchell Center, Mobile, Alabama": SportsballGeocodeTuple(
        city="Mobile",
        state="AL",
        postal="36608",
        lat=30.69229,
        lng=-88.17975,
        housenumber="2195",
        country="USA",
    ),
    "Ed & Rae Schollmaier Arena, Fort Worth, Texas": SCHOLLMAIER_ARENA,
    "Strahan Coliseum, San Marcos, Texas": SportsballGeocodeTuple(
        city="San Marcos",
        state="TX",
        postal="78666",
        lat=29.888611,
        lng=-97.932778,
        housenumber="601",
        country="USA",
    ),
    "Coors Events/Conference Center, Boulder, Colorado": COORS_EVENTS_CONFERENCE_CENTER,
    "Hamilton Gymnasium, Denver, Colorado": SportsballGeocodeTuple(
        city="Denver",
        state="CO",
        postal="",
        lat=39.682106,
        lng=-104.961592,
        housenumber="2240",
        country="USA",
    ),
    "Donald L. Tucker Center, Tallahassee, Florida": DONALD_L_TUCKER_CENTER,
    "John Paul Jones Arena, Charlottesville, Virginia": SportsballGeocodeTuple(
        city="Charlottesville",
        state="VA",
        postal="22903",
        lat=38.046,
        lng=-78.5068,
        housenumber="295",
        country="USA",
    ),
    "Lloyd Noble Center, Norman, Oklahoma": LLOYD_NOBLE_CENTER,
    "Brown Stadium (RI) - Providence - RI - 02906": SportsballGeocodeTuple(
        city="Providence",
        state="RI",
        postal="02906",
        lat=41.842222,
        lng=-71.394444,
        housenumber="400",
        country="USA",
    ),
    "Auburn Arena, Auburn, Alabama": SportsballGeocodeTuple(
        city="Auburn",
        state="AL",
        postal="36849",
        lat=32.60253,
        lng=-85.49301,
        housenumber="250",
        country="USA",
    ),
    "Cameron Indoor Stadium, Durham, North Carolina": SportsballGeocodeTuple(
        city="Durham",
        state="NC",
        postal="",
        lat=35.9976,
        lng=-78.9422,
        housenumber="115",
        country="USA",
    ),
    "Coleman Coliseum , Tuscaloosa, Alabama": COLEMAN_COLISEUM,
    "Stephen C. O'Connell Center, Gainesville, Florida": STEPHEN_C_OCONNELL_CENTER,
    "Wintrust Arena, Chicago, Illinois": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="",
        lat=41.853611,
        lng=-87.621389,
        housenumber="200",
        country="USA",
    ),
    "Rupp Arena, Lexington, Kentucky": SportsballGeocodeTuple(
        city="Lexington",
        state="KY",
        postal="40506",
        lat=38.049444,
        lng=-84.502778,
        housenumber="432",
        country="USA",
    ),
    "Assembly Hall, Bloomington, Indiana": INDIANA_ASSEMBLY_HALL,
    "Kohl Center, Madison, Wisconsin": SportsballGeocodeTuple(
        city="Madison",
        state="WI",
        postal="53715-1206",
        lat=43.06942,
        lng=-89.396972,
        housenumber="601",
        country="USA",
    ),
    "McKale Center, Tucson, Arizona": SportsballGeocodeTuple(
        city="Tucson",
        state="AZ",
        postal="",
        lat=32.23,
        lng=-110.95,
        housenumber="1",
        country="USA",
    ),
    "Memorial Athletic & Convocation Center, Kent, Ohio": SportsballGeocodeTuple(
        city="Kent",
        state="OH",
        postal="44242",
        lat=41.148,
        lng=-81.344,
        housenumber="1025",
        country="USA",
    ),
    "Madison Square Garden (IV), New York, New York": MADISON_SQUARE_GARDEN,
    "Stuart Siegel Center, Richmond, Virginia": STUART_SIEGEL_CENTER,
    "Curb Event Center, Nashville, Tennessee": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="37212",
        lat=36.132222,
        lng=-86.794444,
        housenumber="2002",
        country="USA",
    ),
    "Bramlage Coliseum, Manhattan, Kansas": SportsballGeocodeTuple(
        city="Manhattan",
        state="KS",
        postal="66502",
        lat=39.200361,
        lng=-96.593833,
        housenumber="1800",
        country="USA",
    ),
    "Convocation Center, DeKalb, Illinois": SportsballGeocodeTuple(
        city="DeKalb",
        state="IL",
        postal="60115-2854",
        lat=41.935106,
        lng=-88.785569,
        housenumber="1525",
        country="USA",
    ),
    "McLeod Center, Cedar Falls, Iowa": SportsballGeocodeTuple(
        city="Cedar Falls",
        state="IO",
        postal="",
        lat=42.51395,
        lng=-92.46714,
        housenumber="",
        country="USA",
    ),
    "Desert Financial Arena, Tempe, Arizona": DESERT_FINANCIAL_ARENA,
    "Lawlor Events Center, Reno, Nevada": SportsballGeocodeTuple(
        city="Reno",
        state="NV",
        postal="",
        lat=39.545069,
        lng=-119.818269,
        housenumber="1500",
        country="USA",
    ),
    "San Jose State Event Center, San Jose, California": SportsballGeocodeTuple(
        city="San Jose",
        state="CA",
        postal="95192",
        lat=37.33536,
        lng=-121.87985,
        housenumber="290",
        country="USA",
    ),
    "Galen Center, Los Angeles, California": SportsballGeocodeTuple(
        city="Los Angeles",
        state="CA",
        postal="",
        lat=34.021,
        lng=-118.28,
        housenumber="3400",
        country="USA",
    ),
    "Cintas Center, Cincinnati, Ohio": SportsballGeocodeTuple(
        city="Cincinnati",
        state="OH",
        postal="45207",
        lat=39.150148,
        lng=-84.471881,
        housenumber="1624",
        country="USA",
    ),
    "Stroh Center, Bowling Green, Ohio": SportsballGeocodeTuple(
        city="Bowling Green",
        state="OH",
        postal="43402",
        lat=41.375343,
        lng=-83.624711,
        housenumber="1535",
        country="USA",
    ),
    "McGuirk Arena, Mt. Pleasant, Michigan": SportsballGeocodeTuple(
        city="Mt. Pleasant",
        state="MI",
        postal="",
        lat=43.580888,
        lng=-84.773941,
        housenumber="",
        country="USA",
    ),
    "Williams Arena at Minges Coliseum, Greenville, North Carolina": SportsballGeocodeTuple(
        city="Greenville",
        state="NC",
        postal="27858",
        lat=35.597391,
        lng=-77.367167,
        housenumber="1",
        country="USA",
    ),
    "Convocation Center, Athens, Ohio": SportsballGeocodeTuple(
        city="Athens",
        state="OH",
        postal="45701",
        lat=39.323056,
        lng=-82.105556,
        housenumber="95",
        country="USA",
    ),
    "Carrier Dome, Syracuse, New York": SportsballGeocodeTuple(
        city="Syracuse",
        state="NY",
        postal="",
        lat=43.036111,
        lng=-76.136389,
        housenumber="900",
        country="USA",
    ),
    "Charles Koch Arena, Wichita, Kansas": CHARLES_KOCH_ARENA,
    "CHI Health Center Omaha, Omaha, Nebraska": CHI_HEALTH_CENTER,
    "Tudor Fieldhouse, Houston, Texas": TUDOR_FIELDHOUSE,
    "Show Me Center, Cape Girardeau, Missouri": SportsballGeocodeTuple(
        city="Cape Girardeau",
        state="MO",
        postal="63701",
        lat=37.32,
        lng=-89.5271,
        housenumber="1333",
        country="USA",
    ),
    "ExtraMile Arena, Boise, Idaho": EXTRAMILE_ARENA,
    "Marriott Center, Provo, Utah": SportsballGeocodeTuple(
        city="Provo",
        state="UT",
        postal="",
        lat=40.254,
        lng=-111.649,
        housenumber="701",
        country="USA",
    ),
    "McCamish Pavilion, Atlanta, Georgia": MCCAMISH_PAVILION,
    "Maravich Assembly Center, Baton Rouge, Louisiana": PETE_MARAVICH_ASSEMBLY_CENTER,
    "Viejas Arena, San Diego, California": VIEJAS_ARENA,
    "Reitz Arena, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.346803,
        lng=-76.618615,
        housenumber="4501",
        country="USA",
    ),
    "Xfinity Center, College Park, Maryland": XFINITY_CENTER,
    "Rutgers Athletic Center, New Brunswick, New Jersey": SportsballGeocodeTuple(
        city="New Brunswick",
        state="NJ",
        postal="08854",
        lat=40.525278,
        lng=-74.441111,
        housenumber="83",
        country="USA",
    ),
    "Davey L. Whitney Complex, Alcorn State, Mississippi": SportsballGeocodeTuple(
        city="Alcorn State",
        state="MS",
        postal="",
        lat=31.873225,
        lng=-91.13318,
        housenumber="",
        country="USA",
    ),
    "H.O. Clemmons Arena, Pine Bluff, Arkansas": SportsballGeocodeTuple(
        city="Pine Bluff",
        state="AR",
        postal="",
        lat=34.243825,
        lng=-92.017429,
        housenumber="",
        country="USA",
    ),
    "Assembly Center, Grambling, Louisiana": SportsballGeocodeTuple(
        city="Grambling",
        state="LA",
        postal="",
        lat=32.520284,
        lng=-92.723578,
        housenumber="1234",
        country="USA",
    ),
    "McDermott Center, San Antonio, Texas": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="",
        lat=29.468139,
        lng=-98.469417,
        housenumber="",
        country="USA",
    ),
    "Lee E. Williams Athletics and Assembly Center, Jackson, Mississippi": SportsballGeocodeTuple(
        city="Jackson",
        state="MS",
        postal="39217",
        lat=32.299724,
        lng=-90.211887,
        housenumber="1400",
        country="USA",
    ),
    "Harrison HPER Complex, Itta Bena, Mississippi": SportsballGeocodeTuple(
        city="Itta Bena",
        state="MS",
        postal="",
        lat=33.51406,
        lng=-90.189362,
        housenumber="",
        country="USA",
    ),
    "Hill Field House, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.3425,
        lng=-76.585,
        housenumber="1700",
        country="USA",
    ),
    "McLendon-McDougald Gym, Durham, North Carolina": MCDOUGALD_MCLENON_ARENA,
    "Purcell Pavilion at the Joyce Center, South Bend, Indiana": SportsballGeocodeTuple(
        city="South Bend",
        state="IN",
        postal="46556",
        lat=41.698443,
        lng=-86.231292,
        housenumber="",
        country="USA",
    ),
    "SHM Memorial Center, Orangeburg, South Carolina": SportsballGeocodeTuple(
        city="Orangeburg",
        state="SC",
        postal="29117",
        lat=33.500979,
        lng=-80.846522,
        housenumber="300",
        country="USA",
    ),
    "William Johnson Coliseum, Nacogdoches, Texas": SportsballGeocodeTuple(
        city="Nacogdoches",
        state="TX",
        postal="75964",
        lat=31.622222,
        lng=-94.640833,
        housenumber="700",
        country="USA",
    ),
    "UTRGV Fieldhouse, Edinburg, Texas": UTRGV_FIELDHOUSE,
    "Frank and Lucille Sharp Gymnasium, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="77074",
        lat=29.41,
        lng=-95.31,
        housenumber="7502",
        country="USA",
    ),
    "Montagne Center, Beaumont, Texas": SportsballGeocodeTuple(
        city="Beaumont",
        state="TX",
        postal="77710",
        lat=30.2,
        lng=-94.4,
        housenumber="4400",
        country="USA",
    ),
    "F. G. Clark Activity Center, Baton Rouge, Louisiana": F_G_CLARK_ACTIVITY_CENTER,
    "American Bank Center, Corpus Christi, Texas": SportsballGeocodeTuple(
        city="Corpus Christi",
        state="TX",
        postal="",
        lat=27.807339,
        lng=-97.393561,
        housenumber="1901",
        country="USA",
    ),
    "Schar Center, Elon, North Carolina": SCHAR_CENTER,
    "Bryce Jordan Center, University Park, Pennsylvania": SportsballGeocodeTuple(
        city="University Park",
        state="PA",
        postal="16802",
        lat=40.79578,
        lng=-77.869399,
        housenumber="",
        country="USA",
    ),
    "Mackey Arena, West Lafayette, Indiana": SportsballGeocodeTuple(
        city="West Lafayette",
        state="IN",
        postal="47907",
        lat=40.433322,
        lng=-86.916144,
        housenumber="900",
        country="USA",
    ),
    "Crisler Arena, Ann Arbor, Michigan": CRISLER_CENTER,
    "FAU Arena, Boca Raton, Florida": FAU_STADIUM,
    "Hammel Court, North Andover, Massachusetts": SportsballGeocodeTuple(
        city="North Andover",
        state="MA",
        postal="",
        lat=42.667843,
        lng=-71.119995,
        housenumber="",
        country="USA",
    ),
    "Koessler Athletic Center, Buffalo, New York": SportsballGeocodeTuple(
        city="Buffalo",
        state="NY",
        postal="14208",
        lat=42.920919,
        lng=-78.85754,
        housenumber="1829",
        country="USA",
    ),
    "Detrick Gymnasium, New Britain, Connecticut": SportsballGeocodeTuple(
        city="New Britain",
        state="CT",
        postal="06053",
        lat=41.693,
        lng=-72.7649,
        housenumber="1615",
        country="USA",
    ),
    "Bogota Savings Bank Center, Teaneck, New Jersey": BOGOTA_SAVINGS_BANK_CENTER,
    "Emil and Patricia Jones Convocation Center, Chicago, Illinois": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="60628",
        lat=41.7165,
        lng=-87.6084,
        housenumber="9501",
        country="USA",
    ),
    "McCann Recreation Center, Poughkeepsie, New York": MCCANN_ARENA,
    "Knott Arena, Emmitsburg, Maryland": SportsballGeocodeTuple(
        city="Emmitsburg",
        state="MD",
        postal="21727",
        lat=39.679492,
        lng=-77.346435,
        housenumber="16300",
        country="USA",
    ),
    "Gallagher Center, Niagara University, New York": SportsballGeocodeTuple(
        city="Niagara University",
        state="NY",
        postal="14109",
        lat=43.137035,
        lng=-79.038026,
        housenumber="2009",
        country="USA",
    ),
    "UPMC Events Center, Moon, Pennsylvania": SportsballGeocodeTuple(
        city="Moon",
        state="PA",
        postal="",
        lat=40.520212,
        lng=-80.21476,
        housenumber="",
        country="USA",
    ),
    "Donald W. Reynolds Center, Tulsa, Oklahoma": SportsballGeocodeTuple(
        city="Tulsa",
        state="OK",
        postal="74104",
        lat=36.148611,
        lng=-95.941944,
        housenumber="800",
        country="USA",
    ),
    "Ramsey Center, Cullowhee, North Carolina": SportsballGeocodeTuple(
        city="Cullowhee",
        state="NC",
        postal="28723",
        lat=35.3037,
        lng=-83.1823,
        housenumber="92",
        country="USA",
    ),
    "Jack Stephens Center, Little Rock, Arkansas": SportsballGeocodeTuple(
        city="Little Rock",
        state="AR",
        postal="72204",
        lat=34.727778,
        lng=-92.339722,
        housenumber="2801",
        country="USA",
    ),
    "Moody Center, Austin, Texas": MOODY_CENTER,
    "The Colonial Life Arena, Columbia, South Carolina": COLONIAL_LIFE_ARENA,
    "United Supermarkets Arena, Lubbock, Texas": UNITED_SUPERMARKETS_ARENA,
    "Reed Arena, College Station, Texas": SportsballGeocodeTuple(
        city="College Station",
        state="TX",
        postal="77843",
        lat=30.60578,
        lng=-96.34619,
        housenumber="730",
        country="USA",
    ),
    "Humphrey Coliseum, Starkville, Mississippi": SportsballGeocodeTuple(
        city="Starkville",
        state="MS",
        postal="39762",
        lat=33.461667,
        lng=-88.794444,
        housenumber="55",
        country="USA",
    ),
    "Bud Walton Arena, Fayetteville, Arkansas": SportsballGeocodeTuple(
        city="Fayetteville",
        state="AR",
        postal="72701-5570",
        lat=36.061518,
        lng=-94.178188,
        housenumber="1270",
        country="USA",
    ),
    "Fifth Third Arena, Cincinnati, Ohio": SportsballGeocodeTuple(
        city="Cincinnati",
        state="OH",
        postal="45221",
        lat=39.131101,
        lng=-84.514207,
        housenumber="2700",
        country="USA",
    ),
    "State Farm Center, Champaign, Illinois": STATE_FARM_CENTER,
    "Stegeman Coliseum, Athens, Georgia": SportsballGeocodeTuple(
        city="Athens",
        state="GA",
        postal="30605",
        lat=33.9428,
        lng=-83.378,
        housenumber="100",
        country="USA",
    ),
    "McCarthey Athletic Center, Spokane, Washington": SportsballGeocodeTuple(
        city="Spokane",
        state="WA",
        postal="",
        lat=47.665,
        lng=-117.399,
        housenumber="801",
        country="USA",
    ),
    "FedExForum, Memphis, Tennessee": FEDEX_FORUM,
    "The Pavilion at Ole Miss, Oxford, Mississippi": OLE_MISS,
    "Dee Glen Smith Spectrum, Logan, Utah": SMITH_SPECTRUM,
    "Holmes Convocation Center, Boone, North Carolina": HOLMES_CENTER,
    "Leede Arena, Hanover, New Hampshire": SportsballGeocodeTuple(
        city="Hanover",
        state="NH",
        postal="03755",
        lat=43.703056,
        lng=-72.283333,
        housenumber="",
        country="USA",
    ),
    "Convocation Center, Ypsilanti, Michigan": SportsballGeocodeTuple(
        city="Ypsilanti",
        state="MI",
        postal="48197",
        lat=42.254444,
        lng=-83.647222,
        housenumber="799",
        country="USA",
    ),
    "Kirby Sports Center, Easton, Pennsylvania": SportsballGeocodeTuple(
        city="Easton",
        state="PA",
        postal="18042",
        lat=40.7019,
        lng=-75.2107,
        housenumber="700",
        country="USA",
    ),
    "Memorial Gymnasium, Orono, Maine": SportsballGeocodeTuple(
        city="Orono",
        state="ME",
        postal="",
        lat=44.9037,
        lng=-68.67,
        housenumber="18",
        country="USA",
    ),
    "Henderson Center, Huntington, West Virginia": HENDERSON_CENTER,
    "Costello Athletic Center, Lowell, Massachusetts": SportsballGeocodeTuple(
        city="Lowell",
        state="MA",
        postal="",
        lat=42.6555,
        lng=-71.3242,
        housenumber="",
        country="USA",
    ),
    "Multipurpose Activity Center, West Long Branch, New Jersey": SportsballGeocodeTuple(
        city="West Long Branch",
        state="NJ",
        postal="07764",
        lat=40.279475,
        lng=-74.007583,
        housenumber="400",
        country="USA",
    ),
    "Lundholm Gymnasium, Durham, New Hampshire": SportsballGeocodeTuple(
        city="Durham",
        state="NH",
        postal="03824",
        lat=43.138611,
        lng=-70.938056,
        housenumber="145",
        country="USA",
    ),
    "Petersen Events Center, Pittsburgh, Pennsylvania": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.443777,
        lng=-79.962274,
        housenumber="3719",
        country="USA",
    ),
    "Dunkin' Donuts Center, Providence, Rhode Island": DUNKIN_DONUTS_CENTER,
    "G.B. Hodge Center, Spartanburg, South Carolina": SportsballGeocodeTuple(
        city="Spartanburg",
        state="SC",
        postal="",
        lat=34.996696,
        lng=-81.968774,
        housenumber="",
        country="USA",
    ),
    "Daytona Stadium - Daytona Beach - FL - 32124": SportsballGeocodeTuple(
        city="Daytona Beach",
        state="FL",
        postal="32124",
        lat=29.173056,
        lng=-81.1175,
        housenumber="3777",
        country="USA",
    ),
    "Redbird Arena, Normal, Illinois": SportsballGeocodeTuple(
        city="Normal",
        state="IL",
        postal="61761",
        lat=40.510606,
        lng=-88.999011,
        housenumber="232",
        country="USA",
    ),
    "Carver-Hawkeye Arena, Iowa City, Iowa": SportsballGeocodeTuple(
        city="Iowa City",
        state="IO",
        postal="52242",
        lat=41.663611,
        lng=-91.554444,
        housenumber="1",
        country="USA",
    ),
    "Baxter Arena, Omaha, Nebraska": SportsballGeocodeTuple(
        city="Omaha",
        state="NE",
        postal="",
        lat=41.236,
        lng=-96.013,
        housenumber="2425",
        country="USA",
    ),
    "Pete Hanna Center, Birmingham, Alabama": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.4638,
        lng=-86.7973,
        housenumber="",
        country="USA",
    ),
    "The SIU Arena, Carbondale, Illinois": SIU_ARENA,
    "Moody Coliseum, Dallas, Texas": SportsballGeocodeTuple(
        city="Dallas",
        state="TX",
        postal="75205",
        lat=32.840278,
        lng=-96.780556,
        housenumber="6024",
        country="USA",
    ),
    "Reed Green Coliseum, Hattiesburg, Mississippi": SportsballGeocodeTuple(
        city="Hattiesburg",
        state="MS",
        postal="",
        lat=31.330833,
        lng=-89.337778,
        housenumber="112",
        country="USA",
    ),
    "Convocation Center, San Antonio, Texas": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="78249",
        lat=29.582222,
        lng=-98.621389,
        housenumber="1",
        country="USA",
    ),
    "E.A. Diddle Arena, Bowling Green, Kentucky": EA_DIDDLE_ARENA,
    "Don Haskins Center, El Paso, Texas": SportsballGeocodeTuple(
        city="El Paso",
        state="TX",
        postal="79968",
        lat=31.777608,
        lng=-106.505718,
        housenumber="151",
        country="USA",
    ),
    "Jon M. Huntsman Center, Salt Lake City, Utah": SportsballGeocodeTuple(
        city="Salt Lake City",
        state="UT",
        postal="",
        lat=40.762,
        lng=-111.839,
        housenumber="1825",
        country="USA",
    ),
    "The Pavilion, Davis, California": SportsballGeocodeTuple(
        city="Davis",
        state="CA",
        postal="95616",
        lat=38.541667,
        lng=-121.759444,
        housenumber="1",
        country="USA",
    ),
    "A.G. Spanos Center, Stockton, California": AG_SPANOS_CENTER,
    "Leavey Center, Santa Clara, California": SportsballGeocodeTuple(
        city="Santa Clara",
        state="CA",
        postal="95053",
        lat=37.349111,
        lng=-121.935303,
        housenumber="500",
        country="USA",
    ),
    "Mack Sports Complex, Hempstead, New York": SportsballGeocodeTuple(
        city="Hempstead",
        state="NY",
        postal="11549",
        lat=40.719681,
        lng=-73.596865,
        housenumber="245",
        country="USA",
    ),
    "Hulman Center, Terre Haute, Indiana": HULMAN_CENTER,
    "Worthen Arena, Muncie, Indiana": SportsballGeocodeTuple(
        city="Muncie",
        state="IN",
        postal="",
        lat=40.206944,
        lng=-85.406111,
        housenumber="1699",
        country="USA",
    ),
    "Chace Athletic Center , Smithfield, Rhode Island": SportsballGeocodeTuple(
        city="Smithfield",
        state="RI",
        postal="",
        lat=41.921008,
        lng=-71.539639,
        housenumber="",
        country="USA",
    ),
    "Littlejohn Coliseum, Clemson, South Carolina": SportsballGeocodeTuple(
        city="Clemson",
        state="SC",
        postal="29631",
        lat=34.680278,
        lng=-82.846389,
        housenumber="",
        country="USA",
    ),
    "Cotterell Court, Hamilton, New York": SportsballGeocodeTuple(
        city="Hamilton",
        state="NY",
        postal="13346",
        lat=42.814957,
        lng=-75.542754,
        housenumber="13",
        country="USA",
    ),
    "Levien Gym, New York, New York": LEVIEN_GYM,
    "Belk Arena, Davidson, North Carolina": SportsballGeocodeTuple(
        city="Davidson",
        state="NC",
        postal="",
        lat=35.499278,
        lng=-80.840521,
        housenumber="200",
        country="USA",
    ),
    "EagleBank Arena, Fairfax, Virginia": EAGLEBANK_ARENA,
    "GSU Convocation Center, Atlanta, Georgia": GSU_CONVOCATION_CENTER,
    "Lavietes Pavilion, Boston, Massachusetts": SportsballGeocodeTuple(
        city="Boston",
        state="MA",
        postal="02163",
        lat=42.368218,
        lng=-71.125291,
        housenumber="",
        country="USA",
    ),
    "Stabler Arena, Bethlehem, Pennsylvania": SportsballGeocodeTuple(
        city="Bethlehem",
        state="PA",
        postal="18015",
        lat=40.584444,
        lng=-75.356944,
        housenumber="124",
        country="USA",
    ),
    "Prather Coliseum, Natchitoches, Louisiana": SportsballGeocodeTuple(
        city="Natchitoches",
        state="LA",
        postal="71457",
        lat=31.744028,
        lng=-93.095167,
        housenumber="220",
        country="USA",
    ),
    "Ross E.Templeton Center, Clinton, South Carolina": ROSS_E_TEMPLETON_CENTER,
    "Kaplan Arena at William and Mary Hall, Williamsburg, Virginia": SportsballGeocodeTuple(
        city="Williamsburg",
        state="VA",
        postal="23186",
        lat=37.273472,
        lng=-76.719625,
        housenumber="751",
        country="USA",
    ),
    "John J. Lee Ampitheater, New Haven, Connecticut": SportsballGeocodeTuple(
        city="New Haven",
        state="CT",
        postal="06511",
        lat=41.313611,
        lng=-72.930556,
        housenumber="70",
        country="USA",
    ),
    "Beeghly Center, Youngstown, Ohio": SportsballGeocodeTuple(
        city="Youngstown",
        state="OH",
        postal="44555",
        lat=41.108056,
        lng=-80.648889,
        housenumber="1",
        country="USA",
    ),
    "Clune Arena , Colorado Springs, Colorado": SportsballGeocodeTuple(
        city="Colorado Springs",
        state="CO",
        postal="",
        lat=39.014,
        lng=-104.8833,
        housenumber="2168",
        country="USA",
    ),
    "Silvio O. Conte Forum, Chestnut Hill, Massachusetts": SILVIO_O_CONTE_FORUM,
    "Millett Hall, Oxford, Ohio": SportsballGeocodeTuple(
        city="Oxford",
        state="OH",
        postal="45056",
        lat=39.517236,
        lng=-84.734544,
        housenumber="500",
        country="USA",
    ),
    "Mizzou Arena, Columbia, Missouri": SportsballGeocodeTuple(
        city="Columbia",
        state="MO",
        postal="65211",
        lat=38.93237,
        lng=-92.33303,
        housenumber="1",
        country="USA",
    ),
    "Johnson Coliseum, Huntsville, Texas": SportsballGeocodeTuple(
        city="Huntsville",
        state="TX",
        postal="77340",
        lat=30.712778,
        lng=-95.546111,
        housenumber="1964",
        country="USA",
    ),
    "Bender Arena, Washington, District of Columbia": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="",
        lat=38.937778,
        lng=-77.09,
        housenumber="4400",
        country="USA",
    ),
    "Moby Arena, Fort Collins, Colorado": MOBY_ARENA,
    "Freedom Hall Civic Center, Johnson City, Tennessee": SportsballGeocodeTuple(
        city="Johnson City",
        state="TN",
        postal="37604",
        lat=36.324444,
        lng=-82.375,
        housenumber="1320",
        country="USA",
    ),
    "McBrayer Arena, Richmond, Kentucky": SportsballGeocodeTuple(
        city="Richmond",
        state="KY",
        postal="40475",
        lat=37.737222,
        lng=-84.301389,
        housenumber="521",
        country="USA",
    ),
    "Hyland Performance Arena, Saint Charles, Missouri": SportsballGeocodeTuple(
        city="Saint Charles",
        state="MO",
        postal="",
        lat=38.78912,
        lng=-90.50352,
        housenumber="",
        country="USA",
    ),
    "CFSB Center, Murray, Kentucky": CFSB_CENTER,
    "Echols Memorial Hall, Norfolk, Virginia": SportsballGeocodeTuple(
        city="Norfolk",
        state="VA",
        postal="23504",
        lat=36.847999,
        lng=-76.258157,
        housenumber="700",
        country="USA",
    ),
    "PNC Arena, Raleigh, North Carolina": SportsballGeocodeTuple(
        city="Raleigh",
        state="NC",
        postal="",
        lat=35.803333,
        lng=-78.721944,
        housenumber="1400",
        country="USA",
    ),
    "The Nest, Sacramento, California": THE_NEST,
    "Sam Vadalabene Center , Edwardsville, Illinois": SportsballGeocodeTuple(
        city="Edwardsville",
        state="IL",
        postal="",
        lat=38.795989,
        lng=-89.999883,
        housenumber="35",
        country="USA",
    ),
    "Maples Pavilion, Stanford, California": SportsballGeocodeTuple(
        city="Stanford",
        state="CA",
        postal="",
        lat=37.4296,
        lng=-122.1605,
        housenumber="655",
        country="USA",
    ),
    "Trojan Arena, Troy, Alabama": SportsballGeocodeTuple(
        city="Troy",
        state="AL",
        postal="36082",
        lat=31.802222,
        lng=-85.954722,
        housenumber="5000",
        country="USA",
    ),
    "UCCU Center, Orem, Utah": UCCU_CENTER,
    "Western Hall, Macomb, Illinois": SportsballGeocodeTuple(
        city="Macomb",
        state="IL",
        postal="",
        lat=40.471589,
        lng=-90.685201,
        housenumber="",
        country="USA",
    ),
    "Allen Arena, Nashville, Tennessee": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.103833,
        lng=-86.798836,
        housenumber="1",
        country="USA",
    ),
    "The Legacy Center, Lake Charles, Louisiana": LEGACY_CENTER,
    "Watsco Center, Coral Gables, Florida": WATSO_CENTER,
    "Peter W. Stott Center, Portland, Oregon": SportsballGeocodeTuple(
        city="Portland",
        state="OR",
        postal="97201",
        lat=45.510987,
        lng=-122.687471,
        housenumber="930",
        country="USA",
    ),
    "Haas Pavilion, Berkeley, California": SportsballGeocodeTuple(
        city="Berkeley",
        state="CA",
        postal="",
        lat=37.8694,
        lng=-122.262,
        housenumber="14",
        country="USA",
    ),
    "Murphy Athletic Center, Murfreesboro, Tennessee": MURPHY_ATHELTIC_CENTER,
    "Adams Center/Dahlberg Arena, Missoula, Montana": DAHLBERG_ARENA,
    "Kiefer Lakefront Arena, New Orleans , Louisiana": LAKEFRONT_ARENA,
    "Bank of Kentucky Center, Highland Heights, Kentucky": BANK_OF_KENTUCKY_CENTER,
    "Robins Center, Richmond, Virginia": SportsballGeocodeTuple(
        city="Richmond",
        state="VA",
        postal="23173",
        lat=37.580701,
        lng=-77.538987,
        housenumber="",
        country="USA",
    ),
    "Allen County War Memorial Coliseum, Fort Wayne, Indiana": ALLEN_COUNTY_WAR_MEMORIAL_COLISEUM,
    "Island Federal Credit Union, Stony Brook, New York": STONY_BROOK_ARENA,
    "Cajundome, Lafayette, Louisiana": SportsballGeocodeTuple(
        city="Lafayette",
        state="LA",
        postal="70506",
        lat=30.218444,
        lng=-92.039056,
        housenumber="444",
        country="USA",
    ),
    "Thomas Assembly Center, Ruston, Louisiana": SportsballGeocodeTuple(
        city="Ruston",
        state="LA",
        postal="71272",
        lat=32.5321,
        lng=-92.6584,
        housenumber="1650",
        country="USA",
    ),
    "Worthington Arena, Bozeman, Montana": SportsballGeocodeTuple(
        city="Bozeman",
        state="MT",
        postal="",
        lat=45.6633,
        lng=-111.0506,
        housenumber="1",
        country="USA",
    ),
    "Mabee Center, Tulsa, Oklahoma": SportsballGeocodeTuple(
        city="Tulsa",
        state="OK",
        postal="74171",
        lat=36.04789,
        lng=-95.95573,
        housenumber="7777",
        country="USA",
    ),
    "Centrum, Cedar City, Utah": CENTRUM_ARENA,
    "Schoenecker Arena, St. Paul, Minnesota": SportsballGeocodeTuple(
        city="St. Paul",
        state="MN",
        postal="",
        lat=44.9395,
        lng=-93.1945,
        housenumber="",
        country="USA",
    ),
    "Icardo Center, Bakersfield, California": SportsballGeocodeTuple(
        city="Bakersfield",
        state="CA",
        postal="",
        lat=35.3475,
        lng=-119.102778,
        housenumber="",
        country="USA",
    ),
    "Titan Gym, Fullerton, California": SportsballGeocodeTuple(
        city="Fullerton",
        state="CA",
        postal="92834",
        lat=33.883046,
        lng=-117.88609,
        housenumber="800",
        country="USA",
    ),
    "Burns Arena, St. George, Utah": SportsballGeocodeTuple(
        city="St. George",
        state="UT",
        postal="",
        lat=37.101,
        lng=-113.566,
        housenumber="400",
        country="USA",
    ),
    "RIMAC Arena, La Jolla, California": SportsballGeocodeTuple(
        city="La Jolla",
        state="CA",
        postal="",
        lat=32.885278,
        lng=-117.239223,
        housenumber="9860",
        country="USA",
    ),
    "Climate Pledge Arena, Seattle, Washington": CLIMATE_PLEDGE_ARENA,
    "Draddy Gymnasium, Riverdale, New York": SportsballGeocodeTuple(
        city="Riverdale",
        state="NY",
        postal="",
        lat=40.89073,
        lng=-73.900158,
        housenumber="",
        country="USA",
    ),
    "William H. Pitt Center, Fairfield, Connecticut": SportsballGeocodeTuple(
        city="Fairfield",
        state="CT",
        postal="06825",
        lat=41.219439,
        lng=-73.244628,
        housenumber="5151",
        country="USA",
    ),
    "Alumni Arena, Buffalo, New York": SportsballGeocodeTuple(
        city="Buffalo",
        state="NY",
        postal="14221",
        lat=43.0,
        lng=-78.781111,
        housenumber="175",
        country="USA",
    ),
    "Merkert Gymnasium, Easton, Massachusetts": SportsballGeocodeTuple(
        city="Easton",
        state="MA",
        postal="",
        lat=42.0576,
        lng=-71.0789,
        housenumber="",
        country="USA",
    ),
    "John F. Savage Hall, Toledo, Ohio": SAVAGE_ARENA,
    "War Memorial at The Sobrato Center, San Francisco, California": WAR_MEMORIAL_GYMNASIUM,
    "The Jungle, Indianapolis, Indiana": THE_JUNGLE,
    "Lantz Arena, Charleston, Illinois": SportsballGeocodeTuple(
        city="Charleston",
        state="IL",
        postal="61920",
        lat=39.480403,
        lng=-88.178844,
        housenumber="250",
        country="USA",
    ),
    "Friel Court at Beasley Coliseum, Pullman, Washington": BEASLEY_COLISEUM,
    "The Matadome, Northridge, California": SportsballGeocodeTuple(
        city="Northridge",
        state="CA",
        postal="91330",
        lat=34.241974,
        lng=-118.526484,
        housenumber="18111",
        country="USA",
    ),
    "UC Riverside Student Recreation Center, Riverside, California": UCR_STUDENT_REC_CENTER,
    "Finneran Pavilion, Villanova, Pennsylvania": FINNERAN_PAVILION,
    "Allen Fieldhouse, Lawrence, Kansas": SportsballGeocodeTuple(
        city="Lawrence",
        state="KS",
        postal="",
        lat=38.954306,
        lng=-95.252394,
        housenumber="1651",
        country="USA",
    ),
    "CFE Arena, Orlando, Florida": SportsballGeocodeTuple(
        city="Orlando",
        state="FL",
        postal="",
        lat=28.6068,
        lng=-81.1976,
        housenumber="12777",
        country="USA",
    ),
    "Dale F. Halton Arena, Charlotte, North Carolina": SportsballGeocodeTuple(
        city="Charlotte",
        state="NC",
        postal="28223",
        lat=35.306111,
        lng=-80.734444,
        housenumber="9201",
        country="USA",
    ),
    "A.J. Palumbo Center, Pittsburgh, Pennsylvania": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="15282",
        lat=40.4374,
        lng=-79.9879,
        housenumber="600",
        country="USA",
    ),
    "Thomas M. Ryan Center, Kingston, Rhode Island": RYAN_CENTER,
    "Prudential Center, Newark, New Jersey": PRUDENTIAL_CENTER,
    "Ford Center, Evansville, Indiana": SportsballGeocodeTuple(
        city="Evansville",
        state="IN",
        postal="",
        lat=37.972189,
        lng=-87.567844,
        housenumber="1",
        country="USA",
    ),
    "Super Pit, Denton, Texas": SportsballGeocodeTuple(
        city="Denton",
        state="TX",
        postal="76201",
        lat=33.208333,
        lng=-97.153889,
        housenumber="801",
        country="USA",
    ),
    "Athletics-Recreation Center, Valparaiso, Indiana": SportsballGeocodeTuple(
        city="Valparaiso",
        state="IN",
        postal="46383",
        lat=41.464198,
        lng=-87.048338,
        housenumber="1009",
        country="USA",
    ),
    "CSU Fieldhouse, Charleston, South Carolina": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="29406",
        lat=32.980822,
        lng=-80.067125,
        housenumber="9200",
        country="USA",
    ),
    "Hart Recreation Center, Worcester, Massachusetts": HART_RECREATION_CENTER,
    "McAlister Field House, Charleston, South Carolina": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="29409",
        lat=32.798508,
        lng=-79.962573,
        housenumber="171",
        country="USA",
    ),
    "Paul Porter Arena, Boiling Springs, North Carolina": SportsballGeocodeTuple(
        city="Boiling Springs",
        state="NC",
        postal="",
        lat=35.246538,
        lng=-81.669518,
        housenumber="",
        country="USA",
    ),
    "Mullins Center, Amherst, Massachusetts": SportsballGeocodeTuple(
        city="Amherst",
        state="MA",
        postal="01003",
        lat=42.389381,
        lng=-72.533439,
        housenumber="200",
        country="USA",
    ),
    "Richardson Indoor Stadium, Spartanburg, South Carolina": SportsballGeocodeTuple(
        city="Spartanburg",
        state="SC",
        postal="29303",
        lat=34.963427,
        lng=-81.93363,
        housenumber="601",
        country="USA",
    ),
    "Chaifetz Arena, St. Louis, Missouri": SportsballGeocodeTuple(
        city="St. Louis",
        state="MO",
        postal="63103",
        lat=38.63246,
        lng=-90.22797,
        housenumber="1",
        country="USA",
    ),
    "Fiserv Forum, Milwaukee, Wisconsin": FISERV_FORUM,
    "WVU Coliseum, Morgantown, West Virginia": SportsballGeocodeTuple(
        city="Morgantown",
        state="WV",
        postal="26505",
        lat=39.649167,
        lng=-79.981111,
        housenumber="",
        country="USA",
    ),
    "Bartow Arena, Birmingham, Alabama": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.502164,
        lng=-86.809244,
        housenumber="617",
        country="USA",
    ),
    "McKeon Pavilion, Moraga, California": SportsballGeocodeTuple(
        city="Moraga",
        state="CA",
        postal="",
        lat=37.841247,
        lng=-122.106409,
        housenumber="1928",
        country="USA",
    ),
    "KFC Yum! Center, Louisville, Kentucky": SportsballGeocodeTuple(
        city="Louisville",
        state="KY",
        postal="",
        lat=38.2575,
        lng=-85.753889,
        housenumber="1",
        country="USA",
    ),
    "DiSanto Field - Cleveland - OH - 44106": SportsballGeocodeTuple(
        city="Cleveland",
        state="OH",
        postal="44106",
        lat=41.513444,
        lng=-81.603639,
        housenumber="1747",
        country="USA",
    ),
    "University Arena, Kalamazoo, Michigan": SportsballGeocodeTuple(
        city="Kalamazoo",
        state="MI",
        postal="",
        lat=42.283372,
        lng=-85.60845,
        housenumber="",
        country="USA",
    ),
    "Gallagher-Iba Arena, Stillwater, Oklahoma": SportsballGeocodeTuple(
        city="Stillwater",
        state="OK",
        postal="74078",
        lat=36.125833,
        lng=-97.065,
        housenumber="1046",
        country="USA",
    ),
    "Arena-Auditorium, Laramie, Wyoming": SportsballGeocodeTuple(
        city="Laramie",
        state="WY",
        postal="82071",
        lat=41.313344,
        lng=-105.569419,
        housenumber="1000",
        country="USA",
    ),
    "DunnâOliver Acadome, Montgomery, Alabama": DUNN_OLIVER_ACADOME,
    "Health & Physical Education Arena, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.43,
        lng=-95.21,
        housenumber="",
        country="USA",
    ),
    "Memorial Hall, Dover, Delaware": SportsballGeocodeTuple(
        city="Dover",
        state="DE",
        postal="",
        lat=39.1876,
        lng=-75.5434,
        housenumber="",
        country="USA",
    ),
    "Franklin Field - Philadelphia - PA - 19104": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="19104",
        lat=39.95,
        lng=-75.19,
        housenumber="",
        country="USA",
    ),
    "Texas A&MâCommerce Field House, Commerce, Texas": TEXAS_AM_COMMERCE_FIELD_HOUSE,
    "William J. Nicks Building, Prairie View, Texas": SportsballGeocodeTuple(
        city="Prairie View",
        state="TX",
        postal="77446",
        lat=30.092278,
        lng=-95.993083,
        housenumber="100",
        country="USA",
    ),
    "Matthew Knight Arena, Eugene, Oregon": SportsballGeocodeTuple(
        city="Eugene",
        state="OR",
        postal="97401",
        lat=44.045,
        lng=-123.066,
        housenumber="1390",
        country="USA",
    ),
    "Harry A. Gampel Pavilion, Storrs, Connecticut": SportsballGeocodeTuple(
        city="Storrs",
        state="CT",
        postal="06269",
        lat=41.805292,
        lng=-72.254194,
        housenumber="2095",
        country="USA",
    ),
    "Steinberg Wellness Center, Brooklyn, New York": SportsballGeocodeTuple(
        city="Brooklyn",
        state="NY",
        postal="",
        lat=40.69059,
        lng=-73.979176,
        housenumber="",
        country="USA",
    ),
    "The Palestra, Philadelphia, Pennsylvania": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="19104",
        lat=39.951411,
        lng=-75.188606,
        housenumber="235",
        country="USA",
    ),
    "Spiro Sports Center, Staten Island, New York": SportsballGeocodeTuple(
        city="Staten Island",
        state="NY",
        postal="10301",
        lat=40.614966,
        lng=-74.095729,
        housenumber="",
        country="USA",
    ),
    "Pizzitola Sports Center, Providence, Rhode Island": SportsballGeocodeTuple(
        city="Providence",
        state="RI",
        postal="02906",
        lat=41.831743,
        lng=-71.398043,
        housenumber="",
        country="USA",
    ),
    "Newman Arena, Ithaca, New York": SportsballGeocodeTuple(
        city="Ithaca",
        state="NY",
        postal="14853",
        lat=42.445794,
        lng=-76.476581,
        housenumber="",
        country="USA",
    ),
    "Al Lawson Center, Tallahassee, Florida": AL_LAWSON_CENTER,
    "Hanner Fieldhouse, Statesboro, Georgia": SportsballGeocodeTuple(
        city="Statesboro",
        state="GA",
        postal="30458",
        lat=32.427778,
        lng=-81.779444,
        housenumber="590",
        country="USA",
    ),
    "Carnesecca Arena, Jamaica, New York": SportsballGeocodeTuple(
        city="Jamaica",
        state="NY",
        postal="",
        lat=40.724167,
        lng=-73.794444,
        housenumber="",
        country="USA",
    ),
    "Pan American Center, Las Cruces, New Mexico": SportsballGeocodeTuple(
        city="Las Cruces",
        state="NM",
        postal="88003",
        lat=32.284,
        lng=-106.7422,
        housenumber="1810",
        country="USA",
    ),
    "Jadwin Gymnasium, Princeton, New Jersey": SportsballGeocodeTuple(
        city="Princeton",
        state="NJ",
        postal="08542",
        lat=40.343449,
        lng=-74.648595,
        housenumber="",
        country="USA",
    ),
    "Matthews Arena, Boston, Massachusetts": SportsballGeocodeTuple(
        city="Boston",
        state="MA",
        postal="",
        lat=42.341111,
        lng=-71.084444,
        housenumber="238",
        country="USA",
    ),
    "Calihan Hall, Detroit, Michigan": SportsballGeocodeTuple(
        city="Detroit",
        state="MI",
        postal="48221",
        lat=42.414167,
        lng=-83.135833,
        housenumber="4001",
        country="USA",
    ),
    "Curry Arena, Charlotte, North Carolina": SportsballGeocodeTuple(
        city="Charlotte",
        state="NC",
        postal="28274",
        lat=35.1884989,
        lng=-80.8351236,
        housenumber="2201",
        country="USA",
    ),
    "Events Center, Binghamton, New York": BINGHAMPTON_UNIVERSITY_EVENTS_CENTER,
    "Jeff Farris Center, Conway, Arkansas": FARRIS_CENTER,
    "TD Arena, Charleston, South Carolina": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="29401",
        lat=32.785556,
        lng=-79.934444,
        housenumber="301",
        country="USA",
    ),
    "Betty Engelstad Sioux Center , Grand Forks, North Dakota": SportsballGeocodeTuple(
        city="Grand Forks",
        state="ND",
        postal="58203",
        lat=47.92767,
        lng=-97.07247,
        housenumber="1",
        country="USA",
    ),
    "Reese Court, Cheney, Washington": SportsballGeocodeTuple(
        city="Cheney",
        state="WA",
        postal="",
        lat=47.4914,
        lng=-117.5892,
        housenumber="",
        country="USA",
    ),
    "ICCU Arena, Moscow, Idaho": ICCU_ARENA,
    "Flowers Hall, Florence, Alabama": SportsballGeocodeTuple(
        city="Florence",
        state="AL",
        postal="",
        lat=34.808333,
        lng=-87.683889,
        housenumber="615",
        country="USA",
    ),
    "CBU Events Center, Riverside, California": SportsballGeocodeTuple(
        city="Riverside",
        state="CA",
        postal="",
        lat=33.927501,
        lng=-117.423266,
        housenumber="8431",
        country="USA",
    ),
    "Spokane Veterans Memorial Arena, Spokane, Washington": SportsballGeocodeTuple(
        city="Spokane",
        state="WA",
        postal="",
        lat=47.666,
        lng=-117.423,
        housenumber="720",
        country="USA",
    ),
    "Indiana Farmers Coliseum, Indianapolis, Indiana": SportsballGeocodeTuple(
        city="Indianapolis",
        state="IN",
        postal="",
        lat=39.8275,
        lng=-86.135,
        housenumber="1202",
        country="USA",
    ),
    "Moody Coliseum , Abilene, Texas": SportsballGeocodeTuple(
        city="Abilene",
        state="TX",
        postal="",
        lat=32.470333,
        lng=-99.70925,
        housenumber="",
        country="USA",
    ),
    "Cross Insurance Center, Bangor, Maine": SportsballGeocodeTuple(
        city="Bangor",
        state="ME",
        postal="",
        lat=44.7893,
        lng=-68.7787,
        housenumber="515",
        country="USA",
    ),
    "Klotsche Center, Milwaukee, Wisconsin": SportsballGeocodeTuple(
        city="Milwaukee",
        state="WI",
        postal="53233",
        lat=43.079414,
        lng=-87.879783,
        housenumber="3409",
        country="USA",
    ),
    "Dugan Wellness Center, Corpus Christi, Texas": SportsballGeocodeTuple(
        city="Corpus Christi",
        state="TX",
        postal="78412",
        lat=27.711472,
        lng=-97.324361,
        housenumber="6300",
        country="USA",
    ),
    "Fleming Gymnasium, Greensboro, North Carolina": SportsballGeocodeTuple(
        city="Greensboro",
        state="NC",
        postal="",
        lat=36.069384,
        lng=-79.81268,
        housenumber="",
        country="USA",
    ),
    "Enterprise Center, St. Louis, Missouri": ENTERPRISE_CENTER,
    "Legacy Arena, Birmingham, Alabama": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.52378,
        lng=-86.812935,
        housenumber="2100",
        country="USA",
    ),
    "MassMutual Center, Springfield, Massachusetts": SportsballGeocodeTuple(
        city="Springfield",
        state="MA",
        postal="",
        lat=42.102222,
        lng=-72.586944,
        housenumber="1277",
        country="USA",
    ),
    "Sanford Pentagon, Sioux Falls, South Dakota": SportsballGeocodeTuple(
        city="Sioux Falls",
        state="SD",
        postal="",
        lat=43.593056,
        lng=-96.758611,
        housenumber="2210",
        country="USA",
    ),
    "Barclays Center, Brooklyn, New York": BARCLAYS_CENTER,
    "Orleans Arena, Paradise, Nevada": SportsballGeocodeTuple(
        city="Paradise",
        state="NV",
        postal="",
        lat=36.105833,
        lng=-115.202222,
        housenumber="4500",
        country="USA",
    ),
    "Mohegan Sun Arena, Uncasville, Connecticut": SportsballGeocodeTuple(
        city="Uncasville",
        state="CT",
        postal="",
        lat=41.491111,
        lng=-72.089722,
        housenumber="1",
        country="USA",
    ),
    "Hilliard Gates Sports Center, Fort Wayne, Indiana": SportsballGeocodeTuple(
        city="Fort Wayne",
        state="IN",
        postal="46835",
        lat=41.119,
        lng=-85.1076,
        housenumber="2101",
        country="USA",
    ),
    "XL Center, Hartford, Connecticut": SportsballGeocodeTuple(
        city="Hartford",
        state="CT",
        postal="",
        lat=41.768333,
        lng=-72.676944,
        housenumber="1",
        country="USA",
    ),
    "Spectrum Center, Charlotte, North Carolina": SPECTRUM_CENTRE,
    "Little Caesars Arena, Detroit, Michigan": LITTLE_CAESARS_ARENA,
    "Sprint Center, Kansas City, Missouri": SportsballGeocodeTuple(
        city="Kansas City",
        state="MO",
        postal="",
        lat=39.0975,
        lng=-94.580278,
        housenumber="1407",
        country="USA",
    ),
    "Mississippi Coliseum, Jackson, Mississippi": SportsballGeocodeTuple(
        city="Jackson",
        state="MS",
        postal="",
        lat=32.300126,
        lng=-90.172121,
        housenumber="1207",
        country="USA",
    ),
    "Hytche Athletic Center, Princess Anne, Maryland": SportsballGeocodeTuple(
        city="Princess Anne",
        state="MD",
        postal="",
        lat=38.211184,
        lng=-75.687227,
        housenumber="",
        country="USA",
    ),
    "State Farm Arena, Atlanta, Georgia": STATE_FARM_ARENA,
    "Gainbridge Fieldhouse, Indianapolis, Indiana": GAINBRIDGE_FIELDHOUSE,
    "Mississippi Coast Coliseum, Biloxi, Mississippi": MISSISSIPPI_COAST_COLISEUM,
    "Footprint Center, Phoenix, Arizona": AMERICA_WEST_ARENA,
    "Simmons Bank Arena, North Little Rock, Arkansas": SIMMONS_BANK_ARENA,
    "FLA Live Arena, Sunrise, Florida": SportsballGeocodeTuple(
        city="Sunrise",
        state="FL",
        postal="",
        lat=26.158333,
        lng=-80.325556,
        housenumber="1",
        country="USA",
    ),
    "Dollar Loan Center, Henderson, Nevada": SportsballGeocodeTuple(
        city="Henderson",
        state="NV",
        postal="",
        lat=36.018977,
        lng=-115.081632,
        housenumber="200",
        country="USA",
    ),
    "Vivint Arena, Salt Lake City, Utah": VIVINT_ARENA,
    "Rock Hill Sports & Event Center, Rock Hill, South Carolina": SportsballGeocodeTuple(
        city="Rock Hill",
        state="SC",
        postal="29730",
        lat=34.9318802,
        lng=-81.0299645,
        housenumber="326",
        country="USA",
    ),
    "David Stopher Gymnasium, Thibodaux, Louisiana": SportsballGeocodeTuple(
        city="Thibodaux",
        state="LA",
        postal="",
        lat=29.79235,
        lng=-90.80135,
        housenumber="",
        country="USA",
    ),
    "Dickies Arena, Fort Worth, Texas": SportsballGeocodeTuple(
        city="Fort Worth",
        state="TX",
        postal="",
        lat=32.740891,
        lng=-97.369938,
        housenumber="1911",
        country="USA",
    ),
    "Rolle Activity Center, Flagstaff, Arizona": SportsballGeocodeTuple(
        city="Flagstaff",
        state="AZ",
        postal="86001",
        lat=35.1768307,
        lng=-111.6553593,
        housenumber="",
        country="USA",
    ),
    "Idaho Central Arena, Boise, Idaho": IDAHO_CENTRAL_ARENA,
    "Wellness Center, Brooklyn, New York": SportsballGeocodeTuple(
        city="Brooklyn",
        state="NY",
        postal="",
        lat=40.69059,
        lng=-73.979176,
        housenumber="",
        country="USA",
    ),
    "Baha Mar Convention Center, Nassau": SportsballGeocodeTuple(
        city="Nassau",
        state="",
        postal="",
        lat=25.0703613,
        lng=-77.4001874,
        housenumber="",
        country="Bahamas",
    ),
    "DeGol Arena, Loretto, Pennsylvania": DEGOL_ARENA,
    "MGM Grand Garden Arena, Paradise, Nevada": SportsballGeocodeTuple(
        city="Paradise",
        state="NV",
        postal="",
        lat=36.104808,
        lng=-115.168614,
        housenumber="3799",
        country="USA",
    ),
    "Imperial Arena at Atlantis Resort, Nassau": IMPERIAL_ARENA,
    "State Farm Field House, Lake Buena Vista, Florida": STATE_FARM_FIELDHOUSE,
    "Los Angeles Memorial Sports Arena": LOS_ANGELES_MEMORIAL_COLESIUM,
    "Boston Garden": BOSTON_GARDENS,
    "Cow Palace - Daly City, California - United States": SportsballGeocodeTuple(
        city="Daly City",
        state="CA",
        postal="",
        lat=37.706667,
        lng=-122.418611,
        housenumber="2600",
        country="USA",
    ),
    "The Forum": THE_FORUM,
    "Spectrum": SPECTRUM,
    "Madison Square Garden - New York City, New York - United States": MADISON_SQUARE_GARDEN,
    "Milwaukee Arena": MILWAUKEE_ARENA,
    "Chicago Stadium": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="",
        lat=41.881667,
        lng=-87.672778,
        housenumber="1800",
        country="USA",
    ),
    "Memorial Coliseum - Portland, Oregon - United States": MEMORIAL_COLISEUM,
    "McNichols Sports Arena": MCNICHOLS_SPORTS_ARENA,
    "Kemper Arena": SportsballGeocodeTuple(
        city="Kansas City",
        state="MO",
        postal="",
        lat=39.742778,
        lng=-105.0225,
        housenumber="1800",
        country="USA",
    ),
    "Omni Coliseum": OMNI_COLISEUM,
    "Great Western Forum": THE_FORUM,
    "The Palace of Auburn Hills - Auburn Hills, MI - USA": THE_PALACE_OF_AUBURN_HILLS,
    "America West Arena": AMERICA_WEST_ARENA,
    "Quicken Loans Arena - Cleveland, Ohio - United States": QUICKEN_LOANS_ARENA,
    "Pepsi Center - Denver, Colorado, U.S. - United States": PEPSI_CENTRE,
    "Staples Center": STAPLES_CENTRE,
    "American Airlines Arena": AMERICAN_AIRLINES_ARENA,
    "Chesapeake Energy Arena - Oklahoma City, Oklahoma - United States": CHESAPEAKE_ENERGY_ARENA,
    "AT&T Center - San Antonio, Texas - United States": ATT_CENTER,
    "Oakland Arena - Oakland, California - United States": OAKLAND_ARENA,
    "ESPN Wide World of Sports Complex": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "International Amphitheatre": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="60609",
        lat=41.816111,
        lng=-87.646111,
        housenumber="4220",
        country="USA",
    ),
    "Lahaina Civic Center, Lahaina, Hawaii": SportsballGeocodeTuple(
        city="Lahaina",
        state="HI",
        postal="",
        lat=20.904995,
        lng=-156.683852,
        housenumber="1840",
        country="USA",
    ),
    "San Jose Civic Auditorium": SAN_JOSE_CIVIC_AUDITORIUM,
    "Suncoast Credit Union Arena, Fort Myers, Florida": SportsballGeocodeTuple(
        city="Fort Myers",
        state="FL",
        postal="33919",
        lat=26.5478,
        lng=-81.8869,
        housenumber="13351",
        country="USA",
    ),
    "The Spectrum - Guildford, Surrey, United Kingdom - United Kingdom": SportsballGeocodeTuple(
        city="Surrey",
        state="",
        postal="",
        lat=51.24844,
        lng=-0.56288,
        housenumber="",
        country="UK",
    ),
    "San Diego Sports Arena": SAN_DIEGO_SPORTS_ARENA,
    "Hertz Arena, Estero, Florida": HERTZ_ARENA,
    "Hard Rock Hotel Riviera Maya, Cancun": SportsballGeocodeTuple(
        city="Cancun",
        state="",
        postal="",
        lat=20.5069801,
        lng=-87.215373,
        housenumber="",
        country="Mexico",
    ),
    "T-Mobile Arena, Las Vegas, Nevada": T_MOBILE_ARENA,
    "Ocean Center, Daytona Beach, Florida": SportsballGeocodeTuple(
        city="Daytona Beach",
        state="FL",
        postal="",
        lat=29.2287,
        lng=-81.0106,
        housenumber="101",
        country="USA",
    ),
    "John Gray Gymnasium, Grand Cayman": SportsballGeocodeTuple(
        city="Grand Cayman",
        state="",
        postal="",
        lat=19.279316,
        lng=-81.385651,
        housenumber="73",
        country="UK",
    ),
    "Woodling Gym, Cleveland, Ohio": SportsballGeocodeTuple(
        city="Cleveland",
        state="OH",
        postal="",
        lat=41.503355,
        lng=-81.671269,
        housenumber="",
        country="USA",
    ),
    "Municipal Auditorium": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.167581,
        lng=-86.782244,
        housenumber="417",
        country="USA",
    ),
    "Elridge Wilburn Blake Sports and Fitness Center, St. Thomas": SportsballGeocodeTuple(
        city="St. Thomas",
        state="USVI",
        postal="",
        lat=18.340096,
        lng=-64.97306,
        housenumber="",
        country="USA",
    ),
    "Market Square Arena": MARKET_SQUARE_ARENA,
    "Chase Center, San Francisco, California": CHASE_CENTER,
    "Reunion Arena": REUNION_ARENA,
    "Walsh Gymnasium, South Orange, New Jersey": SportsballGeocodeTuple(
        city="South Orange",
        state="NJ",
        postal="07079",
        lat=40.74169,
        lng=-74.244921,
        housenumber="",
        country="USA",
    ),
    "Alamodome, San Antonio, Texas": ALAMODOME,
    "Moore Gymnasium, Daytona Beach, Florida": SportsballGeocodeTuple(
        city="Daytona Beach",
        state="FL",
        postal="",
        lat=29.210895,
        lng=-81.030977,
        housenumber="",
        country="USA",
    ),
    "Tacoma Dome": TACOMA_DOME,
    "Royal Farms Arena, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.288611,
        lng=-76.618889,
        housenumber="201",
        country="USA",
    ),
    "Joe Louis Arena - Detroit, Michigan - United States": SportsballGeocodeTuple(
        city="Detroit",
        state="MI",
        postal="",
        lat=42.325278,
        lng=-83.051389,
        housenumber="19",
        country="USA",
    ),
    "Arco Arena - Sacramento, California - United States": ARCO_ARENA,
    "Nassau Coliseum, Uniondale, New York": NASSAU_COLISEUM,
    "Bradley Center": BRADLEY_CENTER,
    "Charlotte Coliseum": CHARLOTTE_COLISEUM,
    "Toyota Center, Houston, Texas": TOYOTA_CENTRE,
    "American Airlines Center, Dallas, Texas": AMERICAN_AIRLINES_ARENA,
    "Miami Arena": MIAMI_ARENA,
    "Al McGuire Center, Milwaukee, Wisconsin": SportsballGeocodeTuple(
        city="Milwaukee",
        state="WI",
        postal="53233",
        lat=43.039722,
        lng=-87.926389,
        housenumber="770",
        country="USA",
    ),
    "Orlando Arena": ORLANDO_ARENA,
    "Tokyo Metropolitan Gymnasium": SportsballGeocodeTuple(
        city="Tokyo",
        state="",
        postal="",
        lat=35.679694,
        lng=139.7125,
        housenumber="",
        country="Japan",
    ),
    "Target Center - Minneapolis, Minnesota - United States": TARGET_CENTER,
    "Thomas & Mack Center - Paradise, NV - United States": THOMAS_AND_MACK_CENTER,
    "Delta Center - Salt Lake City, Utah - United States": DELTA_CENTER,
    "Yokohama Arena": YOKOHAMA_ARENA,
    "Anaheim Convention Center": ANAHEIM_CONVENTION_CENTER,
    "TD Banknorth Garden": TD_GARDEN,
    "Amway Arena": ORLANDO_ARENA,
    "TD Garden - Boston, Massachusetts - United States": TD_GARDEN,
    "American Airlines Center - Dallas, Texas, USA - United States": AMERICAN_AIRLINES_ARENA,
    "FTX Arena": FTX_ARENA,
    "Rose Garden": ROSE_GARDEN,
    "Toyota Center - Kennewick, Washington - United States": TOYOTA_CENTER,
    "Philips Arena": STATE_FARM_ARENA,
    "United Center - Chicago, Illinois - United States": UNITED_CENTER,
    "Wachovia Center": SPECTRUM,
    "New Orleans Arena": CAESARS_SUPERDOME,
    "Ball Arena - Denver, CO - United States": PEPSI_CENTRE,
    "Saitama Super Arena - Saitama, Japan - Japan": SportsballGeocodeTuple(
        city="Saitama",
        state="",
        postal="",
        lat=35.894889,
        lng=139.630831,
        housenumber="8",
        country="Japan",
    ),
    "Rogers Place - Edmonton, Alberta, Canada - Canada": ROGERS_PLACE,
    "Etihad Arena - Yas Bay Waterfront, Yas Island, Abu Dhabi - United Arab Emirates": SportsballGeocodeTuple(
        city="Abu Dhabi",
        state="",
        postal="",
        lat=24.4603,
        lng=54.604,
        housenumber="",
        country="UAE",
    ),
    "Gainbridge Fieldhouse - Indianapolis, Indiana - United States": GAINBRIDGE_FIELDHOUSE,
    "Fiserv Forum - Milwaukee, Wisconsin - United States": FISERV_FORUM,
    "Crypto.com Arena - Los Angeles, California, USA - United States": STAPLES_CENTRE,
    "Golden 1 Center - Sacramento, California - United States": GOLDEN_1_CENTER,
    "Moda Center, Portland, Oregon": MODA_CENTER,
    "United Center, Chicago, Illinois": UNITED_CENTER,
    "Rocket Mortgage Fieldhouse, Cleveland, Ohio": ROCKET_MORTGAGE_FIELDHOUSE,
    "FedEx Forum, Memphis, Tennessee": FEDEX_FORUM,
    "Target Center, Minneapolis, Minnesota": TARGET_CENTER,
    "Kia Center, Orlando, Florida": KIA_CENTER,
    "AccorHotels Arena, Paris, France": ACCOR_ARENA,
    "Ball Arena, Denver, Colorado": PEPSI_CENTRE,
    "Crypto.com Arena, Los Angeles, California": STAPLES_CENTRE,
    "Paycom Center, Oklahoma City, Oklahoma": PAYCOM_CENTRE,
    "Golden 1 Center, Sacramento, California": GOLDEN_1_CENTER,
    "Kaseya Center, Miami, Florida": KASEYA_CENTER,
    "Scotiabank Arena, Toronto, Canada": SCOTIABANK_ARENA,
    "Smoothie King Center, New Orleans, Louisiana": CAESARS_SUPERDOME,
    "TD Garden, Boston, Massachusetts": TD_GARDEN,
    "Frost Bank Center, San Antonio, Texas": FROST_BANK_CENTER,
    "Intuit Dome, Inglewood, California": INTUIT_DOME,
    "Delta Center, Salt Lake City, Utah": DELTA_CENTER,
    "AT&T Center, San Antonio, Texas": ATT_CENTER,
    "FTX Arena, Miami, Florida": FTX_ARENA,
    "Vivint Smart Home Arena, Salt Lake City, Utah": VIVINT_ARENA,
    "Chesapeake Energy Arena, Oklahoma City, Oklahoma": CHESAPEAKE_ENERGY_ARENA,
    "The Arena, Bay Lake, Florida": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "HP Field House, Bay Lake, Florida": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Mexico City Arena, Mexico City, Mexico": SportsballGeocodeTuple(
        city="Mexico City",
        state="",
        postal="04650",
        lat=19.496309,
        lng=-99.175429,
        housenumber="",
        country="Mexico",
    ),
    "Amway Center, Orlando, Florida": ORLANDO_ARENA,
    "Phoenix Suns Arena, Phoenix, Arizona": AMERICA_WEST_ARENA,
    "Quicken Loans Arena, Cleveland, Ohio": QUICKEN_LOANS_ARENA,
    "STAPLES Center, Los Angeles, California": STAPLES_CENTRE,
    "Bankers Life Fieldhouse, Indianapolis, Indiana": GAINBRIDGE_FIELDHOUSE,
    "AmericanAirlines Arena, Miami, Florida": KASEYA_CENTER,
    "Amalie Arena, Tampa, Florida": AMALIE_ARENA,
    "Pepsi Center, Denver, Colorado": PEPSI_CENTRE,
    "Visa Athletic Center, Bay Lake, Florida": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Dunn–Oliver Acadome, Montgomery, Alabama": DUNN_OLIVER_ACADOME,
    "Talking Stick Resort Arena, Phoenix, Arizona": AMERICA_WEST_ARENA,
    "Oracle Arena, Oakland, California": OAKLAND_ARENA,
    "The O2 Arena, London, United Kingdom": O2_ARENA,
    "Air Canada Centre, Toronto, Canada": SCOTIABANK_ARENA,
    "BMO Harris Bradley Center, Milwaukee, Wisconsin": BRADLEY_CENTER,
    "Philips Arena, Atlanta, Georgia": STATE_FARM_ARENA,
    "UW–Milwaukee Panther Arena, Milwaukee, Wisconsin": MILWAUKEE_ARENA,
    "Dreamstyle Arena, Albuquerque, New Mexico": THE_PIT,
    "Tom Gola Arena, Philadelphia, Pennsylvania": JOHN_GLASER_ARENA,
    "Texas A&M–Commerce Field House, Commerce, Texas": TEXAS_AM_COMMERCE_FIELD_HOUSE,
    "Detroit, Michigan": DETROIT,
    "Rec Hall, University Park, Pennsylvania": SportsballGeocodeTuple(
        city="University Park",
        state="PA",
        postal="16802",
        lat=40.79578,
        lng=-77.869399,
        housenumber="",
        country="USA",
    ),
    "Dallas, Texas": DALLAS,
    "The Gabba, Brisbane, Australia": GABBA,
    "Sydney Cricket Ground, Sydney, Australia": SCG,
    "People First Stadium, Gold Coast, Australia": PEOPLE_FIRST_STADIUM,
    "Engie Stadium, Sydney, Australia": ENGIE_STADIUM,
    "Melbourne Cricket Ground, Melbourne, Australia": MCG,
    "GMHBA Stadium, Geelong, Australia": GMHBA_STADIUM,
    "Marvel Stadium, Melbourne, Australia": MARVEL_STADIUM,
    "Adelaide Oval, Adelaide, Australia": ADELAIDE_OVAL,
    "Optus Stadium, Perth, Australia": OPTUS_STADIUM,
    "Wisdom Gymnasium, Stephenville, Texas": WISDOM_GYM,
    "Charlotte, North Carolina": CHARLOTTE,
    "Salt Lake City, Utah": SALT_LAKE_CITY,
    "Ferrell Center, Waco, Texas": SportsballGeocodeTuple(
        city="Waco",
        state="TX",
        postal="76706",
        lat=31.547903,
        lng=-97.105969,
        housenumber="1900",
        country="USA",
    ),
    "Princeton, New Jersey": PRINCETON,
    "Nashville, Tennessee": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.162222,
        lng=-86.774444,
        housenumber="",
        country="USA",
    ),
    "Fort Worth, Texas": SportsballGeocodeTuple(
        city="Fort Worth",
        state="TX",
        postal="",
        lat=32.756389,
        lng=-97.3325,
        housenumber="",
        country="USA",
    ),
    "T-Mobile Center, Kansas City, Missouri": SportsballGeocodeTuple(
        city="Kansas City",
        state="MO",
        postal="",
        lat=39.0975,
        lng=-94.580278,
        housenumber="1407",
        country="USA",
    ),
    "Henderson, Nevada": SportsballGeocodeTuple(
        city="Henderson",
        state="NV",
        postal="",
        lat=36.033333,
        lng=-114.983333,
        housenumber="",
        country="USA",
    ),
    "Lake Charles, Louisiana": SportsballGeocodeTuple(
        city="Lake Charles",
        state="LA",
        postal="",
        lat=30.214722,
        lng=-93.208611,
        housenumber="",
        country="USA",
    ),
    "Pensacola Bay Center, Pensacola, Florida": SportsballGeocodeTuple(
        city="Pensacola",
        state="FL",
        postal="32502",
        lat=30.416485,
        lng=-87.209372,
        housenumber="201",
        country="USA",
    ),
    "Rose Hill Gymnasium, Bronx, New York": ROSE_HILL_GYM,
    "Austin, Texas": AUSTIN,
    "Lundholm Gym, Durham, New Hampshire": SportsballGeocodeTuple(
        city="Durham",
        state="NH",
        postal="03824",
        lat=43.138611,
        lng=-70.938056,
        housenumber="145",
        country="USA",
    ),
    "Clune Arena, Colorado Springs, Colorado": SportsballGeocodeTuple(
        city="Colorado Springs",
        state="CO",
        postal="",
        lat=39.014,
        lng=-104.8833,
        housenumber="2168",
        country="USA",
    ),
    "Donald L. Tucker Civic Center, Tallahassee, Florida": SportsballGeocodeTuple(
        city="Tallahassee",
        state="FL",
        postal="32301",
        lat=30.437842,
        lng=-84.28669,
        housenumber="505",
        country="USA",
    ),
    "Denny Sanford Premier Center, Sioux Falls, South Dakota": SportsballGeocodeTuple(
        city="Sioux Falls",
        state="SD",
        postal="",
        lat=43.561667,
        lng=-96.75,
        housenumber="1201",
        country="USA",
    ),
    "Joseph J. Gentile Arena, Chicago, Illinois": JOSEPH_J_GENTILES_CENTER,
    "Dunn-Oliver Acadome, Montgomery, Alabama": DUNN_OLIVER_ACADOME,
    "Oklahoma City, Oklahoma": SportsballGeocodeTuple(
        city="Oklahoma City",
        state="OK",
        postal="",
        lat=35.468611,
        lng=-97.521389,
        housenumber="",
        country="USA",
    ),
    "Harrah's Cherokee Center, Asheville, North Carolina": HARRAHS_CHEROKEE_CENTER,
    "Savage Arena, Toledo, Ohio": SAVAGE_ARENA,
    "Pullman, Washington": SportsballGeocodeTuple(
        city="Pullman",
        state="WA",
        postal="",
        lat=46.733333,
        lng=-117.168611,
        housenumber="87",
        country="USA",
    ),
    "Fairfield, Connecticut": SportsballGeocodeTuple(
        city="Fairfield",
        state="CT",
        postal="",
        lat=41.15,
        lng=-73.266667,
        housenumber="87",
        country="USA",
    ),
    "Talmadge L. Hill Field House, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.3425,
        lng=-76.585,
        housenumber="1700",
        country="USA",
    ),
    "McDougald-McLendon Arena, Durham, North Carolina": MCDOUGALD_MCLENON_ARENA,
    "Athletics Center O''rena, Rochester, Michigan": ATHELTICS_CENTER_ORENA,
    "Nutter Center, Dayton, Ohio": NUTTER_CENTER,
    "Addition Financial Arena, Orlando, Florida": ADDITION_FINANCIAL_ARENA,
    "Colonial Life Arena, Columbia, South Carolina": COLONIAL_LIFE_ARENA,
    "James H. Hilton Coliseum, Ames, Iowa": JAMES_H_HILTON_COLISEUM,
    "Provident Credit Union Event Center, San Jose, California": SportsballGeocodeTuple(
        city="San Jose",
        state="CA",
        postal="95192",
        lat=37.33536,
        lng=-121.87985,
        housenumber="290",
        country="USA",
    ),
    "Denton, Texas": SportsballGeocodeTuple(
        city="Denton",
        state="TX",
        postal="",
        lat=33.216389,
        lng=-97.129167,
        housenumber="",
        country="USA",
    ),
    "Coral Gables, Florida": CORAL_GABLES,
    "Breslin Student Events Center, East Lansing, Michigan": BRESLIN_EVENTS_CENTER,
    "Kingston, Rhode Island": SportsballGeocodeTuple(
        city="Kingston",
        state="KI",
        postal="",
        lat=41.483333,
        lng=-71.533333,
        housenumber="",
        country="USA",
    ),
    "Cleveland, Ohio": CLEVELAND,
    "Chase Athletic Center, Smithfield, Rhode Island": CHASE_ATHLETIC_CENTER,
    "Murphy Center, Murfreesboro, Tennessee": MURPHY_ATHELTIC_CENTER,
    "Stephen C. O''Connell Center, Gainesville, Florida": STEPHEN_C_OCONNELL_CENTER,
    "Chesapeake Employers Insurance Arena, Baltimore, Maryland": CHESAPEAKE_ENERGY_ARENA,
    "F. G. Clark Center, Baton Rouge, Louisiana": F_G_CLARK_ACTIVITY_CENTER,
    "Bozeman, Montana": SportsballGeocodeTuple(
        city="Bozeman",
        state="MT",
        postal="",
        lat=45.685556,
        lng=-111.025,
        housenumber="",
        country="USA",
    ),
    "KSU Convocation Center, Kennesaw, Georgia": KSU_CONVOCATION_CENTER,
    "Fredrick C. Hobdy Assembly Center, Grambling, Louisiana": FREDRICK_C_HOBDY_ASSEMBLY_CENTER,
    "Walkup Skydome, Flagstaff, Arizona": WALKUP_SKYDOME,
    "Dahlberg Arena, Missoula, Montana": DAHLBERG_ARENA,
    "Great Southern Bank Arena, Springfield, Missouri": GREAT_SOUTHERN_BANK_ARENA,
    "Banterra Center, Carbondale, Illinois": SportsballGeocodeTuple(
        city="Carbondale",
        state="IL",
        postal="",
        lat=37.708333,
        lng=-89.218611,
        housenumber="",
        country="USA",
    ),
    "McCann Arena, Poughkeepsie, New York": MCCANN_ARENA,
    "CU Events Center, Boulder, Colorado": SportsballGeocodeTuple(
        city="Boulder",
        state="CO",
        postal="",
        lat=40.0047,
        lng=-105.2606,
        housenumber="950",
        country="USA",
    ),
    "Coleman Coliseum, Tuscaloosa, Alabama": COLEMAN_COLISEUM,
    "Neville Arena, Auburn, Alabama": SportsballGeocodeTuple(
        city="Auburn",
        state="AL",
        postal="36849",
        lat=32.60253,
        lng=-85.49301,
        housenumber="250",
        country="USA",
    ),
    "University Credit Union Pavilion, Moraga, California": SportsballGeocodeTuple(
        city="Moraga",
        state="CA",
        postal="",
        lat=37.841247,
        lng=-122.106409,
        housenumber="1928",
        country="USA",
    ),
    "Bernard Johnson Coliseum, Huntsville, Texas": SportsballGeocodeTuple(
        city="Huntsville",
        state="TX",
        postal="77340",
        lat=30.712778,
        lng=-95.546111,
        housenumber="1964",
        country="USA",
    ),
    "Amica Mutual Pavilion, Providence, Rhode Island": AMICA_MUTUAL_PAVILION,
    "George Gervin GameAbove Center, Ypsilanti, Michigan": SportsballGeocodeTuple(
        city="Ypsilanti",
        state="MI",
        postal="48197",
        lat=42.254444,
        lng=-83.647222,
        housenumber="799",
        country="USA",
    ),
    "Binghamton, New York": SportsballGeocodeTuple(
        city="Binghamton",
        state="NY",
        postal="",
        lat=42.098889,
        lng=-75.910833,
        housenumber="",
        country="USA",
    ),
    "McKenzie Arena, Chattanooga, Tennessee": SportsballGeocodeTuple(
        city="Chattanooga",
        state="TN",
        postal="37403",
        lat=35.050382,
        lng=-85.30091,
        housenumber="720",
        country="USA",
    ),
    "Timmons Arena, Greenville, South Carolina": SportsballGeocodeTuple(
        city="Greenville",
        state="SC",
        postal="29613",
        lat=34.9179345,
        lng=-82.437289,
        housenumber="3300",
        country="USA",
    ),
    "Betty Engelstad Sioux Center, Grand Forks, North Dakota": SportsballGeocodeTuple(
        city="Grand Forks",
        state="ND",
        postal="58203",
        lat=47.92767,
        lng=-97.07247,
        housenumber="1",
        country="USA",
    ),
    "Ross E. Templeton Center, Clinton, South Carolina": ROSS_E_TEMPLETON_CENTER,
    "PPG Paints Arena, Pittsburgh, Pennsylvania": PPG_PAINTS_ARENA,
    "Levien Gymnasium, New York, New York": LEVIEN_GYM,
    "Simon Skjodt Assembly Hall, Bloomington, Indiana": SportsballGeocodeTuple(
        city="Bloomington",
        state="IN",
        postal="47408",
        lat=39.1808334,
        lng=-86.522222,
        housenumber="1001",
        country="USA",
    ),
    "Crisler Center, Ann Arbor, Michigan": CRISLER_CENTER,
    "Jersey Mike's Arena, New Brunswick, New Jersey": JERSEY_MIKES_ARENA,
    "Fertitta Center, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="77004",
        lat=29.724722,
        lng=-95.346944,
        housenumber="3875",
        country="USA",
    ),
    "UMPC Cooper Fieldhouse, Pittsburgh, Pennsylvania": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="15282",
        lat=40.4374,
        lng=-79.9879,
        housenumber="600",
        country="USA",
    ),
    "Davey Whitney Complex, Alcorn State, Mississippi": SportsballGeocodeTuple(
        city="Alcorn State",
        state="MS",
        postal="",
        lat=31.873225,
        lng=-91.13318,
        housenumber="",
        country="USA",
    ),
    "John J. Lee Amphitheater, New Haven, Connecticut": SportsballGeocodeTuple(
        city="New Haven",
        state="CT",
        postal="06511",
        lat=41.313611,
        lng=-72.930556,
        housenumber="70",
        country="USA",
    ),
    "Hynes Athletic Center, New Rochelle, New York": HYNES_ATHELTIC_CENTER,
    "The Sandy and John Black Pavilion at Ole Miss, Oxford, Mississippi": OLE_MISS,
    "Moscow, Idaho": SportsballGeocodeTuple(
        city="Moscow",
        state="ID",
        postal="",
        lat=46.741667,
        lng=-117.0,
        housenumber="",
        country="USA",
    ),
    "Ocean Bank Convocation Center, Miami, Florida": OCEAN_BANK_CONVOCATION_CENTER,
    "Island Federal Credit Union Arena, Stony Brook, New York": STONY_BROOK_ARENA,
    "Phoenix, Arizona": PHOENIX,
    "Evansville, Indiana": SportsballGeocodeTuple(
        city="Evansville",
        state="IN",
        postal="",
        lat=37.977222,
        lng=-87.550556,
        housenumber="",
        country="USA",
    ),
    "America First Event Center, Cedar City, Utah": SportsballGeocodeTuple(
        city="Cedar City",
        state="UT",
        postal="84720",
        lat=37.675556,
        lng=-113.073056,
        housenumber="351",
        country="USA",
    ),
    "St. Paul, Minnesota": ST_PAUL,
    "Jenny Craig Pavilion, San Diego, California": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="",
        lat=32.7745,
        lng=-117.1837,
        housenumber="5998",
        country="USA",
    ),
    "George M. Holmes Convocation Center, Boone, North Carolina": HOLMES_CENTER,
    "Farris Center, Conway, Arkansas": FARRIS_CENTER,
    "HTC Center, Conway, South Carolina": HTC_CENTER,
    "Atlanta, Georgia": ATLANTA,
    "UNF Arena, Jacksonville, Florida": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="32224",
        lat=30.2734,
        lng=-81.5079,
        housenumber="11852",
        country="USA",
    ),
    "Strahan Arena, San Marcos, Texas": SportsballGeocodeTuple(
        city="San Marcos",
        state="TX",
        postal="78666",
        lat=29.888611,
        lng=-97.932778,
        housenumber="601",
        country="USA",
    ),
    "Wellness and Events Center, Newark, New Jersey": WELLNESS_AND_EVENTS_CENTER,
    "Gersten Pavilion, Los Angeles, California": GERSTEN_PAVILION,
    "Rothman Center, Teaneck, New Jersey": BOGOTA_SAVINGS_BANK_CENTER,
    "Corbett Sports Center, Greensboro, North Carolina": CORBETT_SPORTS_CENTER,
    "Easton, Massachusetts": SportsballGeocodeTuple(
        city="Easton",
        state="MA",
        postal="",
        lat=42.024444,
        lng=-71.129167,
        housenumber="",
        country="USA",
    ),
    "University Credit Union Center, Davis, California": SportsballGeocodeTuple(
        city="Davis",
        state="CA",
        postal="95616",
        lat=38.541667,
        lng=-121.759444,
        housenumber="1",
        country="USA",
    ),
    "Buccaneer Field House, Charleston, South Carolina": BUCCANEER_FIELDHOUSE,
    "Credit Union 1 Arena, Chicago, Illinois": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="60607",
        lat=41.874722,
        lng=-87.656111,
        housenumber="525",
        country="USA",
    ),
    "E. A. Diddle Arena, Bowling Green, Kentucky": EA_DIDDLE_ARENA,
    "JMA Wireless Dome, Syracuse, New York": JMA_WIRELESS_DOME,
    "Truist Arena, Highland Heights, Kentucky": TRUIST_ARENA,
    "Kress Events Center, Green Bay, Wisconsin": SportsballGeocodeTuple(
        city="Green Bay",
        state="WI",
        postal="",
        lat=44.530069,
        lng=-87.915967,
        housenumber="",
        country="USA",
    ),
    "OceanFirst Bank Center, West Long Branch, New Jersey": SportsballGeocodeTuple(
        city="West Long Branch",
        state="NJ",
        postal="07764",
        lat=40.279475,
        lng=-74.007583,
        housenumber="400",
        country="USA",
    ),
    "Alex G. Spanos Center, Stockton, California": AG_SPANOS_CENTER,
    "War Memorial Gymnasium, San Francisco, California": WAR_MEMORIAL_GYMNASIUM,
    "First National Bank Arena, Jonesboro, Arkansas": SportsballGeocodeTuple(
        city="Jonesboro",
        state="AR",
        postal="72401",
        lat=35.845422,
        lng=-90.670319,
        housenumber="217",
        country="USA",
    ),
    "Frost Arena, Brookings, South Dakota": SportsballGeocodeTuple(
        city="Brookings",
        state="SD",
        postal="57007",
        lat=44.317984,
        lng=-96.779058,
        housenumber="1165",
        country="USA",
    ),
    "Louisville, Kentucky": LOUISVILLE,
    "Saint Charles, Missouri": SportsballGeocodeTuple(
        city="Saint Charles",
        state="MO",
        postal="",
        lat=38.789,
        lng=-90.514,
        housenumber="",
        country="USA",
    ),
    "Cam Henderson Center, Huntington, West Virginia": HENDERSON_CENTER,
    "Ted Constant Convocaation Center, Norfolk, Virginia": TED_CONSTANT_CONVOCATION_CENTER,
    "Brooklyn, New York": SportsballGeocodeTuple(
        city="Brooklyn",
        state="NY",
        postal="",
        lat=40.65,
        lng=-73.95,
        housenumber="",
        country="USA",
    ),
    "Chicago, Illinois": CHICAGO,
    "Alabama A&M Events Center, Huntsville, Alabama": SportsballGeocodeTuple(
        city="Huntsville",
        state="AL",
        postal="35810",
        lat=34.781139,
        lng=-86.580528,
        housenumber="",
        country="USA",
    ),
    "Vadalabene Center, Edwardsville, Illinois": SportsballGeocodeTuple(
        city="Edwardsville",
        state="IL",
        postal="",
        lat=38.795989,
        lng=-89.999883,
        housenumber="35",
        country="USA",
    ),
    "Corpus Christi, Texas": SportsballGeocodeTuple(
        city="Corpus Christi",
        state="TX",
        postal="",
        lat=27.742778,
        lng=-97.401944,
        housenumber="",
        country="USA",
    ),
    "Island Federal Credit Union Arena, New York, NY, USA": STONY_BROOK_ARENA,
    "Subiaco Oval, Perth, Australia": DOMAIN_STADIUM,
    "University of Tasmania Stadium, Launceston, Australia": UTAS_STADIUM,
    "Mars Stadium, Ballarat, Australia": MARS_STADIUM,
    "Savannah, Georgia": SAVANNAH,
    "Blundstone Arena, Hobart, Australia": BLUNDSTONE_ARENA,
    "Akron, Ohio": AKRON,
    "Michelob Ultra Arena, Paradise, Nevada": SportsballGeocodeTuple(
        city="Paradise",
        state="NV",
        postal="",
        lat=36.090678,
        lng=-115.178981,
        housenumber="3950",
        country="USA",
    ),
    "Sioux Falls, South Dakota": SIOUX_FALLS,
    "TIO Traeger Park, Alice Springs, Australia": TIO_STADIUM,
    "Springfield, Massachusetts": SportsballGeocodeTuple(
        city="Springfield",
        state="MA",
        postal="",
        lat=42.101389,
        lng=-72.590278,
        housenumber="",
        country="USA",
    ),
    "Elmont, New York": SportsballGeocodeTuple(
        city="Elmont",
        state="NY",
        postal="",
        lat=40.701667,
        lng=-73.7025,
        housenumber="",
        country="USA",
    ),
    "Manuka Oval, Canberra, Australia": MANUKA_OVAL,
    "Tulsa, Oklahoma": SportsballGeocodeTuple(
        city="Tulsa",
        state="OK",
        postal="",
        lat=36.131389,
        lng=-95.937222,
        housenumber="",
        country="USA",
    ),
    "Sunrise, Florida": SportsballGeocodeTuple(
        city="Sunrise",
        state="FL",
        postal="",
        lat=26.157222,
        lng=-80.286111,
        housenumber="",
        country="USA",
    ),
    "Paradise, Nevada": SportsballGeocodeTuple(
        city="Paradise",
        state="NV",
        postal="",
        lat=36.081944,
        lng=-115.124722,
        housenumber="",
        country="USA",
    ),
    "Niceville, Florida": SportsballGeocodeTuple(
        city="Niceville",
        state="FL",
        postal="",
        lat=30.516111,
        lng=-86.471667,
        housenumber="",
        country="USA",
    ),
    "Jiangwan Stadium, Shanghai, China": JIANGWAN_STADIUM,
    "Ondrej Nepela Arena, Bratislava, Slovakia": SportsballGeocodeTuple(
        city="Bratislava",
        state="",
        postal="",
        lat=48.16,
        lng=17.135833,
        housenumber="9",
        country="Slovakia",
    ),
    "Cazaly's Stadium, Cairns, Australia": CAZALYS_STADIUM,
    "San Juan Capistrano, California": SportsballGeocodeTuple(
        city="San Juan Capistrano",
        state="CA",
        postal="",
        lat=33.499444,
        lng=-117.661667,
        housenumber="",
        country="USA",
    ),
    "Giants Stadium, East Rutherford, NJ, USA": METLIFE_STADIUM,
    "TIO Stadium, Darwin, Australia": TIO_STADIUM,
    "Fort Myers, Florida": SportsballGeocodeTuple(
        city="Fort Myers",
        state="FL",
        postal="",
        lat=26.616667,
        lng=-81.833333,
        housenumber="",
        country="USA",
    ),
    "Thunderdome Stadium, Nonthaburi, Thailand": SportsballGeocodeTuple(
        city="Nonthaburi",
        state="",
        postal="",
        lat=13.917989,
        lng=100.547411,
        housenumber="",
        country="Thailand",
    ),
    "Norwood Oval, Norwood, Australia": NORWOOD_OVAL,
    "Angel Stadium of Anaheim, Anaheim, CA, USA": SportsballGeocodeTuple(
        city="Anaheim",
        state="CA",
        postal="",
        lat=33.800278,
        lng=-117.882778,
        housenumber="2000",
        country="USA",
    ),
    "Riverway Stadium, Townsville, Australia": RIVERWAY_STADIUM,
    "Adelaide Hills, Mount Barker, Australia": ADELAIDE_HILLS,
    "Marrara Oval, Darwin, Australia": TIO_STADIUM,
    "Accor Stadium, Sydney, Australia": ENGIE_STADIUM,
    "Spotland Stadium, Rochdale, England": SportsballGeocodeTuple(
        city="Rochdale",
        state="",
        postal="OL11 5DR",
        lat=53.620833,
        lng=-2.18,
        housenumber="",
        country="UK",
    ),
    "TD Garden, Boston, MA, USA": TD_GARDEN,
    "Spectrum Center, Charlotte, NC, USA": SPECTRUM_CENTRE,
    "Capital One Arena, Washington, DC, USA": CAPITAL_ONE_ARENA,
    "State Farm Arena, Atlanta, GA, USA": STATE_FARM_ARENA,
    "Barclays Center, New York, NY, USA": BARCLAYS_CENTER,
    "Little Caesars Arena, Detroit, MI, USA": LITTLE_CAESARS_ARENA,
    "Paycom Center, Oklahoma, OK, USA": PAYCOM_CENTRE,
    "Footprint Center, Phoenix, AZ, USA": AMERICA_WEST_ARENA,
    "American Airlines Center, Dallas, TX, USA": AMERICAN_AIRLINES_ARENA,
    "Crypto.com Arena, Los Angeles, CA, USA": STAPLES_CENTRE,
    "Kia Center, Orlando, FL, USA": KIA_CENTER,
    "United Center, Chicago, IL, USA": UNITED_CENTER,
    "FedExForum, Memphis, TN, USA": FEDEX_FORUM,
    "Target Center, Minneapolis, MN, USA": TARGET_CENTER,
    "Madison Square Garden, New York, NY, USA": MADISON_SQUARE_GARDEN,
    "Golden 1 Center, Sacramento, CA, USA": GOLDEN_1_CENTER,
    "Intuit Dome, Inglewood, CA, USA": INTUIT_DOME,
    "Smoothie King Center, New Orleans, LA, USA": CAESARS_SUPERDOME,
    "Moda Center, Portland, OR, USA": MODA_CENTER,
    "Ball Arena, Denver, CO, USA": PEPSI_CENTRE,
    "Delta Center, Salt Lake City, UT, USA": DELTA_CENTER,
    "Toyota Center, Houston, TX, USA": TOYOTA_CENTRE,
    "Fiserv Forum, Milwaukee, WI, USA": FISERV_FORUM,
    "Wells Fargo Center, Philadelphia, PA, USA": SPECTRUM,
    "Scotiabank Arena, Toronto, ON, Canada": SCOTIABANK_ARENA,
    "Rocket Mortgage FieldHouse, Cleveland, OH, USA": ROCKET_MORTGAGE_FIELDHOUSE,
    "Chase Center, San Francisco, CA, USA": CHASE_CENTER,
    "Frost Bank Center, San Antonio, TX, USA": FROST_BANK_CENTER,
    "Gainbridge Fieldhouse, Indianapolis, IN, USA": GAINBRIDGE_FIELDHOUSE,
    "Kaseya Center, Miami, FL, USA": KASEYA_CENTER,
    "Accor Arena, Paris, France": ACCOR_ARENA,
    "ARCO Arena, Sacramento, CA, USA": ARCO_ARENA,
    "AdventHealth Arena, Orlando, FL, USA": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Oracle Arena, Oakland, CA, USA": OAKLAND_ARENA,
    "Intuit Dome - Inglewood, California, U.S. - United States": INTUIT_DOME,
    "Rogers Arena - Vancouver, BC - Canada": ROGERS_ARENA,
    "Rocket Mortgage FieldHouse - Cleveland, Ohio - United States": ROCKET_MORTGAGE_FIELDHOUSE,
    "Paycom Center - Oklahoma City, Oklahoma - United States": PAYCOM_CENTRE,
    "Spectrum Center - Charlotte, North Carolina - United States": SPECTRUM_CENTRE,
    "Little Caesars Arena - Detroit, Michigan - United States": LITTLE_CAESARS_ARENA,
    "Stan Sheriff Center - Honolulu, Hawaii - United States": STAN_SHERIFF_CENTER,
    "Kia Center - Orlando, Florida - United States": KIA_CENTER,
    "Scotiabank Arena - Toronto, Ontario - Canada": SCOTIABANK_ARENA,
    "Climate Pledge Arena - Seattle, Washington - United States": CLIMATE_PLEDGE_ARENA,
    "Wells Fargo Center - Philadelphia, PA - United States": SPECTRUM,
    "State Farm Arena - Atlanta, Georgia - United States": STATE_FARM_ARENA,
    "Bell Centre": BELL_CENTRE,
    "Footprint Center - Phoenix, Arizona - United States": AMERICA_WEST_ARENA,
    "Smoothie King Center - New Orleans, Louisiana, USA - United States": CAESARS_SUPERDOME,
    "Kaseya Center - Miami, Florida - United States": KASEYA_CENTER,
    "Frost Bank Center - San Antonio, Texas - United States": FROST_BANK_CENTER,
    "Moda Center - Portland, Oregon - United States": MODA_CENTER,
    "BOK Center - Tulsa, Oklahoma - United States": BOK_CENTER,
    "Capital One Arena - Washington DC, USA - United States": CAPITAL_ONE_ARENA,
    "The Palace of Auburn Hills, Auburn Hills, MI, USA": THE_PALACE_OF_AUBURN_HILLS,
    "BMO Harris Bradley Center, Milwaukee, WI, USA": BRADLEY_CENTER,
    "State Farm Field House, Orlando, FL, USA": STATE_FARM_FIELDHOUSE,
    "Panjin Jinxiu Stadium, Panjin, China": SportsballGeocodeTuple(
        city="Panjin",
        state="",
        postal="",
        lat=41.110278,
        lng=122.071667,
        housenumber="",
        country="China",
    ),
    "Oriole Park at Camden Yards, Baltimore, MD, USA": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.2838194,
        lng=-76.6242531,
        housenumber="",
        country="USA",
    ),
    "ESPN Wide World of Sports Complex, Bay Lake, FL, USA": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Amalie Arena, Tampa, FL, USA": AMALIE_ARENA,
    "Toyota Stadium, Frisco, TX, USA": TOYOTA_STADIUM,
    "Visa Athletic Center, Orlando, FL, USA": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "The Arena (WWOS), Orlando, FL, USA": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "PayPal Park, San Jose, CA, USA": SportsballGeocodeTuple(
        city="San Jose",
        state="CA",
        postal="",
        lat=37.351389,
        lng=-121.925,
        housenumber="1123",
        country="USA",
    ),
    "Moody Center, Austin, TX, USA": MOODY_CENTER,
    "Robert F. Kennedy Memorial Stadium, Washington, DC, USA": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="",
        lat=38.89,
        lng=-76.972,
        housenumber="2400",
        country="USA",
    ),
    "West Hartford, Connecticut": SportsballGeocodeTuple(
        city="West Hartford",
        state="CT",
        postal="",
        lat=41.767778,
        lng=-72.753889,
        housenumber="",
        country="USA",
    ),
    "Verizon Center, Washington, District of Columbia": CAPITAL_ONE_ARENA,
    "The Palace of Auburn Hills, Auburn Hills, Michigan": THE_PALACE_OF_AUBURN_HILLS,
    "Wells Fargo Arena, Des Moines, Iowa": SportsballGeocodeTuple(
        city="Des Moines",
        state="IO",
        postal="",
        lat=41.592667,
        lng=-93.621139,
        housenumber="233",
        country="USA",
    ),
    "Lake Buena Vista, Florida": SportsballGeocodeTuple(
        city="Lake Buena Vista",
        state="FL",
        postal="",
        lat=28.3775,
        lng=-81.526111,
        housenumber="",
        country="USA",
    ),
    "Place Bell, Laval": SportsballGeocodeTuple(
        city="Laval",
        state="QC",
        postal="",
        lat=45.5558,
        lng=-73.7218,
        housenumber="1950",
        country="CA",
    ),
    "Estero, Florida": SportsballGeocodeTuple(
        city="Estero",
        state="FL",
        postal="",
        lat=26.427778,
        lng=-81.795,
        housenumber="",
        country="USA",
    ),
    "McDonough Field House, Albany, New York": SportsballGeocodeTuple(
        city="Albany",
        state="NY",
        postal="",
        lat=42.6970529,
        lng=-73.6817757,
        housenumber="",
        country="USA",
    ),
    "Uncasville, Connecticut": SportsballGeocodeTuple(
        city="Uncasville",
        state="CT",
        postal="",
        lat=41.434542,
        lng=-72.109799,
        housenumber="",
        country="USA",
    ),
    "Sacramento, California": SportsballGeocodeTuple(
        city="Sacramento",
        state="CA",
        postal="",
        lat=38.581667,
        lng=-121.494444,
        housenumber="",
        country="USA",
    ),
    "Jersey Mike''s Arena, New Brunswick, New Jersey": JERSEY_MIKES_ARENA,
    "Ford Center at the Star, Frisco, Texas": FORD_CENTER_AT_THE_STAR,
    "Willett Hall, Farmville, Virginia": SportsballGeocodeTuple(
        city="Farmville",
        state="VA",
        postal="",
        lat=37.2975,
        lng=-78.3955,
        housenumber="23909",
        country="USA",
    ),
    "Indianapolis, Indiana": INDIANAPOLIS,
    "Milwaukee, Wisconsin": MILWAUKEE,
    "GSU Sports Arena, Atlanta, Georgia": GSU_CONVOCATION_CENTER,
    "High Point, North Carolina": SportsballGeocodeTuple(
        city="High Point",
        state="NC",
        postal="",
        lat=35.991111,
        lng=-79.993611,
        housenumber="",
        country="USA",
    ),
    "Winfield Dunn Center, Clarksville, Tennessee": SportsballGeocodeTuple(
        city="Clarksville",
        state="TN",
        postal="",
        lat=36.536111,
        lng=-87.356944,
        housenumber="",
        country="USA",
    ),
    "Harry A. Campel Pavilion, Storrs, Connecticut": SportsballGeocodeTuple(
        city="Storrs",
        state="CT",
        postal="06269",
        lat=41.805292,
        lng=-72.254194,
        housenumber="2095",
        country="USA",
    ),
    "Santa Cruz, California": SportsballGeocodeTuple(
        city="Santa Cruz",
        state="CA",
        postal="",
        lat=36.971944,
        lng=-122.026389,
        housenumber="",
        country="USA",
    ),
    "South Padre Island, Texas": SportsballGeocodeTuple(
        city="South Padre Island",
        state="TX",
        postal="",
        lat=26.111944,
        lng=-97.169722,
        housenumber="",
        country="USA",
    ),
    "Houston, Texas": HOUSTON,
    "Wichita, Kansas": WICHITA,
    "Jackson, Mississippi": JACKSON,
    "Union, New Jersey": SportsballGeocodeTuple(
        city="Union",
        state="NJ",
        postal="",
        lat=40.695266,
        lng=-74.269078,
        housenumber="",
        country="USA",
    ),
    "Lucas Oil Stadium, Indianapolis, IN, USA": LUCAS_OIL_STADIUM,
    "NRG Stadium, Houston, TX, USA": NRG_STADIUM,
    "State Farm Stadium, Glendale, AZ, USA": STATE_FARM_STADIUM,
    "Caesars Superdome, New Orleans, LA, USA": CAESARS_SUPERDOME,
    "U.S. Bank Stadium, Minneapolis, MN, USA": US_BANK_STADIUM,
    "Time Warner Cable Arena, Charlotte, North Carolina": SPECTRUM_CENTRE,
    "The O2 Arena, London": O2_ARENA,
    "People's United Center, Hamden, Connecticut": SportsballGeocodeTuple(
        city="Hamden",
        state="CT",
        postal="06518",
        lat=41.413833,
        lng=-72.911157,
        housenumber="305",
        country="USA",
    ),
    "Taylorsville, Utah": SportsballGeocodeTuple(
        city="Taylorsville",
        state="UT",
        postal="",
        lat=40.655,
        lng=-111.949444,
        housenumber="",
        country="USA",
    ),
    "Flagstaff, Arizona": SportsballGeocodeTuple(
        city="Flagstaff",
        state="AZ",
        postal="",
        lat=35.180556,
        lng=-111.62,
        housenumber="",
        country="USA",
    ),
    "Portland, Oregon": PORTLAND,
    "Laie, Hawaii": SportsballGeocodeTuple(
        city="Laie",
        state="HI",
        postal="",
        lat=21.648611,
        lng=-157.925556,
        housenumber="",
        country="USA",
    ),
    "Copper Box Arena, London": SportsballGeocodeTuple(
        city="London",
        state="",
        postal="",
        lat=51.5444,
        lng=-0.0201,
        housenumber="",
        country="UK",
    ),
    "Imperial Arena at Atlantis Resort, Paradise Island": IMPERIAL_ARENA,
    "Anaheim, California": SportsballGeocodeTuple(
        city="Anaheim",
        state="CA",
        postal="",
        lat=33.836111,
        lng=-117.889722,
        housenumber="",
        country="USA",
    ),
    "Lahaina, Hawaii": SportsballGeocodeTuple(
        city="Lahaina",
        state="HI",
        postal="",
        lat=20.873889,
        lng=-156.6775,
        housenumber="",
        country="USA",
    ),
    "Edinburg, Texas": SportsballGeocodeTuple(
        city="Edinburg",
        state="TX",
        postal="",
        lat=26.304167,
        lng=-98.163889,
        housenumber="",
        country="USA",
    ),
    "Spokane, Washington": SPOKANE,
    "Montego Bay Convention Centre, Montego Bay": SportsballGeocodeTuple(
        city="Montego Bay",
        state="",
        postal="",
        lat=18.5198974,
        lng=-77.8204727,
        housenumber="",
        country="Jamaica",
    ),
    "National Basketball Arena, South Dublin": SportsballGeocodeTuple(
        city="South Dublin",
        state="",
        postal="",
        lat=53.292222,
        lng=-6.334444,
        housenumber="",
        country="Ireland",
    ),
    "Generoso Pope Athletic Complex, Brooklyn Heights, New York": GENEROSO_POPE_ATHELTIC_COMPLEX,
    "Youngstown, Ohio": YOUNGSTOWN,
    "Kansas City, Kansas": SportsballGeocodeTuple(
        city="Kansas City",
        state="KS",
        postal="",
        lat=39.106667,
        lng=-94.676389,
        housenumber="",
        country="USA",
    ),
    "San Diego, California": SAN_DIEGO,
    "Sleep Train Arena, Sacramento, California": ARCO_ARENA,
    "CONSOL Energy Center, Pittsburgh, Pennsylvania": PPG_PAINTS_ARENA,
    "UNT Coliseum, Denton, Texas": SportsballGeocodeTuple(
        city="Denton",
        state="TX",
        postal="76201",
        lat=33.208333,
        lng=-97.153889,
        housenumber="801",
        country="USA",
    ),
    "The Center, Philadelphia, Pennsylvania": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="",
        lat=39.952,
        lng=-75.164,
        housenumber="",
        country="USA",
    ),
    "Grand Canyon University Arena, Phoenix, Arizona": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="85017",
        lat=33.510152,
        lng=-112.128884,
        housenumber="3300",
        country="USA",
    ),
    "Wolstein Center, Cleveland, Ohio": SportsballGeocodeTuple(
        city="Cleveland",
        state="OH",
        postal="",
        lat=41.499167,
        lng=-81.676944,
        housenumber="2000",
        country="USA",
    ),
    "Elmore Gymnasium, Normal, Alabama": ELMORE_GYMNASIUM,
    "Teague Special Events Center, Abilene, Texas": SportsballGeocodeTuple(
        city="Abilene",
        state="TX",
        postal="79601",
        lat=32.4712266,
        lng=-99.7083714,
        housenumber="1600",
        country="USA",
    ),
    "BB&T Arena, Highland Heights, Kentucky": TRUIST_ARENA,
    "Webster Bank Arena, Bridgeport, Connecticut": SportsballGeocodeTuple(
        city="Bridgeport",
        state="CT",
        postal="79601",
        lat=41.1732,
        lng=-73.187,
        housenumber="600",
        country="USA",
    ),
    "Scottrade Center, St. Louis, Missouri": ENTERPRISE_CENTER,
    "U.S. Cellular Center, Asheville, North Carolina": HARRAHS_CHEROKEE_CENTER,
    "Entertainment & Sports Arena, Washington, District of Columbia": CAREFIRST_ARENA,
    "St. Elizabeths East Entertainment & Sports Arena, Washington, District of Columbia": CAREFIRST_ARENA,
    "Ford Center at The Star, Frisco, Texas": FORD_CENTER_AT_THE_STAR,
    "Rocket Mortgage FieldHouse, Cleveland, Ohio": ROCKET_MORTGAGE_FIELDHOUSE,
    "Boardwalk Hall, Atlantic City, New Jersey": SportsballGeocodeTuple(
        city="Atlantic City",
        state="NJ",
        postal="",
        lat=39.355,
        lng=-74.438611,
        housenumber="2301",
        country="USA",
    ),
    "Norfolk Scope, Norfolk, Virginia": SportsballGeocodeTuple(
        city="Norfolk",
        state="VA",
        postal="23510",
        lat=36.853275,
        lng=-76.286722,
        housenumber="201",
        country="USA",
    ),
    "Beasley Coliseum, Pullman, Washington": BEASLEY_COLISEUM,
    "KeyBank Center, Buffalo, New York": KEYBANK_CENTER,
    "Times Union Center , Albany, New York": TIMES_UNION_CENTER,
    "Dunkin Donuts Center, Providence, Rhode Island": DUNKIN_DONUTS_CENTER,
    "CenturyLink Center Omaha, Omaha, Nebraska": CHI_HEALTH_CENTER,
    "Ryan Center, Kingston, Rhode Island": RYAN_CENTER,
    "Pope Physical Education Center, Brooklyn Heights, New York": GENEROSO_POPE_ATHELTIC_COMPLEX,
    "Eastwood High School Gym, El Paso, Texas": SportsballGeocodeTuple(
        city="El Paso",
        state="TX",
        postal="",
        lat=31.7718,
        lng=-106.3547,
        housenumber="2430",
        country="USA",
    ),
    "Millis Center, High Point, North Carolina": SportsballGeocodeTuple(
        city="High Point",
        state="NC",
        postal="27262",
        lat=35.973456,
        lng=-79.995706,
        housenumber="922",
        country="USA",
    ),
    "George Bisacca Court at Alumni Hall, Fairfield, Connecticut": SportsballGeocodeTuple(
        city="Fairfield",
        state="CT",
        postal="",
        lat=41.159854,
        lng=-73.256646,
        housenumber="",
        country="USA",
    ),
    "Life University Gym, Marietta, Georgia": SportsballGeocodeTuple(
        city="Marietta",
        state="GA",
        postal="30062",
        lat=33.9313785,
        lng=-84.5223277,
        housenumber="1269",
        country="USA",
    ),
    "Robert A. Mott Gymnasium, San Luis Obispo, California": ROBERT_A_MOTT_GYMNASIUM,
    "John J. Moore Athletic Center, Jersey City, New Jersey": SportsballGeocodeTuple(
        city="Jersey City",
        state="NJ",
        postal="07305",
        lat=40.7129524,
        lng=-74.0891177,
        housenumber="110",
        country="USA",
    ),
    "Cowan Spectrum, Moscow, Idaho": KIBBIE_DOME,
    "Elmore Health Science Building , Normal, Alabama": ELMORE_GYMNASIUM,
    "McDonough Gymnasium, Washington, District of Columbia": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="20057",
        lat=38.9075,
        lng=-77.0775,
        housenumber="",
        country="USA",
    ),
    "M.O. Campbell Center, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="77032",
        lat=29.932222,
        lng=-95.359722,
        housenumber="1865",
        country="USA",
    ),
    "Alumni Recreation Center, Loudonville, New York": SportsballGeocodeTuple(
        city="Loudonville",
        state="NY",
        postal="12211",
        lat=42.7174,
        lng=-73.7487,
        housenumber="515",
        country="USA",
    ),
    "Max Worthington Arena, Bozeman, Montana": SportsballGeocodeTuple(
        city="Bozeman",
        state="MT",
        postal="",
        lat=45.6633,
        lng=-111.0506,
        housenumber="1",
        country="USA",
    ),
    "Alumni Hall (RI), Providence, Rhode Island": ALUMNI_HALL,
    "Michelob Ulta Arena, Paradise, Nevada": SportsballGeocodeTuple(
        city="Paradise",
        state="NV",
        postal="",
        lat=36.090678,
        lng=-115.178981,
        housenumber="3950",
        country="USA",
    ),
    "Leonard E. Merrell Center, Katy, Texas": MERRELL_CENTER,
    "Bridgestone Arena, Nashville, Tennessee": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.159167,
        lng=-86.778611,
        housenumber="501",
        country="USA",
    ),
    "Comerica, Frisco, Texas": SportsballGeocodeTuple(
        city="Frisco",
        state="TX",
        postal="",
        lat=33.101026,
        lng=-96.819624,
        housenumber="2601",
        country="USA",
    ),
    "Lucas Oil Stadium, Indianapolis, Indiana": LUCAS_OIL_STADIUM,
    "Connolly Center, Seattle, Washington": REDHAWK_CENTER,
    "Chase Family Arena, Hartford, Connecticut": CHASE_FAMILY_ARENA,
    "Virgin Islands Sport & Fitness Center , St. Thomas": VIRGIN_ISLANDS_SPORT_AND_FITNESS_CENTER,
    "Virgin Islands Sport & Fitness Center, St. Thomas": VIRGIN_ISLANDS_SPORT_AND_FITNESS_CENTER,
    "McArthur Gymnasium, St. Petersburg, Florida": SportsballGeocodeTuple(
        city="St. Petersburg",
        state="FL",
        postal="",
        lat=27.717097,
        lng=-82.688406,
        housenumber="",
        country="USA",
    ),
    "St. Petersburg, Florida": ST_PETERSBURG,
    "Anaheim Convention Center, Anaheim, California": ANAHEIM_CONVENTION_CENTER,
    "CenturyLink Center, Omaha, Nebraska": CHI_HEALTH_CENTER,
    "Hawkins Arena, Macon, Georgia": SportsballGeocodeTuple(
        city="Macon",
        state="GA",
        postal="31207",
        lat=32.829722,
        lng=-83.651944,
        housenumber="1730",
        country="USA",
    ),
    "Frank Erwin Center, Austin, Texas": SportsballGeocodeTuple(
        city="Austin",
        state="TX",
        postal="",
        lat=30.277,
        lng=-97.7322,
        housenumber="1701",
        country="USA",
    ),
    "BankUnited Center, Coral Gables, Florida": WATSO_CENTER,
    "Binghamton University Events Center, Vestal, New York": BINGHAMPTON_UNIVERSITY_EVENTS_CENTER,
    "US Airways Center, Phoenix, Arizona": AMERICA_WEST_ARENA,
    "EnergySolutions Arena, Salt Lake City, Utah": DELTA_CENTER,
    "Kaiser Permanente Arena, Santa Cruz, California": SportsballGeocodeTuple(
        city="Santa Cruz",
        state="CA",
        postal="",
        lat=36.968611,
        lng=-122.023611,
        housenumber="",
        country="USA",
    ),
    "Rip Griffin Center, Lubbock, Texas": SportsballGeocodeTuple(
        city="Lubbock",
        state="TX",
        postal="",
        lat=33.57186,
        lng=-101.93188,
        housenumber="",
        country="USA",
    ),
    "Hampton Convocation Center, Hampton, Virginia": HAMPTON_CONVOCATION_CENTER,
    "Ability360 Sports & Fitness Center, Phoenix, Arizona": SportsballGeocodeTuple(
        city="Phoenix",
        state="AZ",
        postal="85034",
        lat=33.4451355,
        lng=-111.9737363,
        housenumber="5031",
        country="USA",
    ),
    "Lawrence Joel Veterans Memorial Coliseum, Winston-Salem, North Carolina": SportsballGeocodeTuple(
        city="Winston-Salem",
        state="NC",
        postal="27105",
        lat=36.127866,
        lng=-80.257628,
        housenumber="2825",
        country="USA",
    ),
    "Indiana Convention Center, Indianapolis, Indiana": SportsballGeocodeTuple(
        city="Indianapolis",
        state="IN",
        postal="",
        lat=39.765278,
        lng=-86.1625,
        housenumber="100",
        country="USA",
    ),
    "Cabot Center Gym, Boston, Massachusetts": CABOT_CENTER,
    "Holt Arena, Pocatello, Idaho": ICCU_ARENA,
    "Sun Dome, Tampa, Florida": YUENGLING_CENTER,
    "Covelli Centre, Youngstown, Ohio": SportsballGeocodeTuple(
        city="Youngstown",
        state="OH",
        postal="44503",
        lat=41.096145,
        lng=-80.647943,
        housenumber="229",
        country="USA",
    ),
    "Burton Coliseum, Lake Charles, Louisiana": SportsballGeocodeTuple(
        city="Lake Charles",
        state="LA",
        postal="70607",
        lat=30.136989,
        lng=-93.211476,
        housenumber="7001",
        country="USA",
    ),
    "Bert Ogden Arena, Edinburg, Texas": SportsballGeocodeTuple(
        city="Edinburg",
        state="TX",
        postal="78539",
        lat=26.256568,
        lng=-98.164631,
        housenumber="4900",
        country="USA",
    ),
    "Reynolds Coliseum, Raleigh, North Carolina": REYNOLDS_COLISEUM,
    "Walter E. Washington Convention Center, Washington, District of Columbia": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="",
        lat=38.9051,
        lng=-77.023,
        housenumber="801",
        country="USA",
    ),
    "Germain Arena, Estero, Florida": HERTZ_ARENA,
    "Mabee Fieldhouse, Kansas City, Kansas": SportsballGeocodeTuple(
        city="Kansas City",
        state="KS",
        postal="64145",
        lat=38.911069,
        lng=-94.5921775,
        housenumber="11901",
        country="USA",
    ),
    "CenturyLink Arena, Boise, Idaho": IDAHO_CENTRAL_ARENA,
    "Lynchburg, Virginia": SportsballGeocodeTuple(
        city="Lynchburg",
        state="VA",
        postal="",
        lat=37.403611,
        lng=-79.17,
        housenumber="",
        country="USA",
    ),
    "New Orleans Arena, New Orleans, Louisiana": CAESARS_SUPERDOME,
    "Lowell, Massachusetts": SportsballGeocodeTuple(
        city="Lowell",
        state="MA",
        postal="",
        lat=42.639444,
        lng=-71.314722,
        housenumber="",
        country="USA",
    ),
    "Swinney Recreation Center, Kansas City, Missouri": SportsballGeocodeTuple(
        city="Kansas City",
        state="MO",
        postal="64110",
        lat=39.03555,
        lng=-94.57876,
        housenumber="5030",
        country="USA",
    ),
    "Chase Family Arena at Reich Family Pavilion, Hartford, Connecticut": CHASE_FAMILY_ARENA,
    "Rose Garden Arena, Portland, Oregon": ROSE_GARDEN,
    "JMU Convocation Center, Harrisonburg, Virginia": SportsballGeocodeTuple(
        city="Harrisonburg",
        state="VA",
        postal="",
        lat=38.431892,
        lng=-78.868854,
        housenumber="",
        country="USA",
    ),
    "Denver, Colorado": DENVER,
    "Wells Fargo Arena, Tempe, Arizona": DESERT_FINANCIAL_ARENA,
    "Times Union Center, Albany, New York": TIMES_UNION_CENTER,
    "Louis Brown Athletic Center, New Brunswick, New Jersey": JERSEY_MIKES_ARENA,
    "Carmichael Arena, Chapel Hill, North Carolina": SportsballGeocodeTuple(
        city="Chapel Hill",
        state="NC",
        postal="27599",
        lat=35.909526,
        lng=-79.045408,
        housenumber="310",
        country="USA",
    ),
    "Harrisonburg, Virginia": SportsballGeocodeTuple(
        city="Harrisonburg",
        state="VA",
        postal="",
        lat=38.449444,
        lng=-78.868889,
        housenumber="",
        country="USA",
    ),
    "76ers Fieldhouse, Wilmington, Delaware": SportsballGeocodeTuple(
        city="Wilmington",
        state="DE",
        postal="",
        lat=39.727582,
        lng=-75.554497,
        housenumber="401",
        country="USA",
    ),
    "Pittsburgh, Pennsylvania": PITTSBURGH,
    "Prescott Valley, Arizona": SportsballGeocodeTuple(
        city="Prescott Valley",
        state="AZ",
        postal="",
        lat=34.61,
        lng=-112.315833,
        housenumber="",
        country="USA",
    ),
    "Vines Center, Lynchburg, Virginia": SportsballGeocodeTuple(
        city="Lynchburg",
        state="VA",
        postal="24502",
        lat=37.349068,
        lng=-79.180998,
        housenumber="1971",
        country="USA",
    ),
    "HP Field House, Orlando, Florida": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Tsongas Center, Lowell, Massachusetts": SportsballGeocodeTuple(
        city="Lowell",
        state="MA",
        postal="",
        lat=42.650228,
        lng=-71.313248,
        housenumber="300",
        country="USA",
    ),
    "The Arena, Niceville, Florida": SportsballGeocodeTuple(
        city="Niceville",
        state="FL",
        postal="",
        lat=30.5394,
        lng=-86.4756,
        housenumber="300",
        country="USA",
    ),
    "Las Vegas, Nevada": LAS_VEGAS,
    "Fort Wayne, Indiana": FORT_WAYNE,
    "Portland, Maine": SportsballGeocodeTuple(
        city="Portland",
        state="ME",
        postal="",
        lat=43.66,
        lng=-70.255,
        housenumber="",
        country="USA",
    ),
    "Gateway Christian Academy, Bimini": SportsballGeocodeTuple(
        city="",
        state="Bimini",
        postal="",
        lat=25.7433101,
        lng=-79.2883217,
        housenumber="",
        country="Bahamas",
    ),
    "Orlando, Florida": SportsballGeocodeTuple(
        city="Orlando",
        state="FL",
        postal="",
        lat=28.54,
        lng=-81.38,
        housenumber="",
        country="USA",
    ),
    "Kissimmee, Florida": SportsballGeocodeTuple(
        city="Kissimmee",
        state="FL",
        postal="",
        lat=28.304167,
        lng=-81.412778,
        housenumber="",
        country="USA",
    ),
    "Alaska Airlines Center, Anchorage, Alaska": SportsballGeocodeTuple(
        city="Anchorage",
        state="AL",
        postal="",
        lat=61.188056,
        lng=-149.812222,
        housenumber="3550",
        country="USA",
    ),
    "Baoshan Sports Center, Shanghai": SportsballGeocodeTuple(
        city="Shanghai",
        state="",
        postal="",
        lat=31.395225,
        lng=121.491842,
        housenumber="",
        country="China",
    ),
    "New Brunswick, New Jersey": SportsballGeocodeTuple(
        city="New Brunswick",
        state="NJ",
        postal="",
        lat=40.486678,
        lng=-74.444414,
        housenumber="",
        country="USA",
    ),
    "SIU Arena, Carbondale, Illinois": SIU_ARENA,
    "Boise, Idaho": SportsballGeocodeTuple(
        city="Boise",
        state="ID",
        postal="",
        lat=43.615833,
        lng=-116.201667,
        housenumber="",
        country="USA",
    ),
    "Kansas City, Missouri": SportsballGeocodeTuple(
        city="Kansas City",
        state="MO",
        postal="",
        lat=39.099722,
        lng=-94.578333,
        housenumber="",
        country="USA",
    ),
    "Power Balance Pavilion, Sacramento, California": ARCO_ARENA,
    "Conseco Fieldhouse, Indianapolis, Indiana": GAINBRIDGE_FIELDHOUSE,
    "Von Braun Center, Hunstville, Alabama": SportsballGeocodeTuple(
        city="Huntsville",
        state="AL",
        postal="",
        lat=34.72699,
        lng=-86.590887,
        housenumber="700",
        country="USA",
    ),
    "Bradley Center, Milwaukee, Wisconsin": BRADLEY_CENTER,
    "Toyota Center, Kennewick, Washington": TOYOTA_CENTER,
    "Los Angeles, California": LOS_ANGELES,
    "Staples Center, Los Angeles, California": STAPLES_CENTRE,
    "Newark, New Jersey": NEWARK,
    "SSE Arena, Belfast": SportsballGeocodeTuple(
        city="Belfast",
        state="",
        postal="BT3 9QQ",
        lat=54.604167,
        lng=-5.915,
        housenumber="2",
        country="UK",
    ),
    "Pocatello, Idaho": SportsballGeocodeTuple(
        city="Pocatello",
        state="ID",
        postal="",
        lat=42.862222,
        lng=-112.450556,
        housenumber="",
        country="USA",
    ),
    "Seattle, Washington": SEATTLE,
    "Amway Arena, Orlando, Florida": ORLANDO_ARENA,
    "Oklahoma City Arena, Oklahoma City, Oklahoma": PAYCOM_CENTRE,
    "Izod Center, East Rutherford, New Jersey": SportsballGeocodeTuple(
        city="East Rutherford",
        state="NJ",
        postal="",
        lat=40.811667,
        lng=-74.0675,
        housenumber="50",
        country="USA",
    ),
    "Wachovia Center, Philadelphia, Pennsylvania": SPECTRUM,
    "Baltimore, Maryland": BALTIMORE,
    "Coraopolis, Pennsylvania": SportsballGeocodeTuple(
        city="Coraopolis",
        state="PA",
        postal="",
        lat=40.515817,
        lng=-80.162792,
        housenumber="",
        country="USA",
    ),
    "Tiger Arena, Savannah, Georgia": SportsballGeocodeTuple(
        city="Savannah",
        state="GA",
        postal="",
        lat=32.02376,
        lng=-81.0658,
        housenumber="",
        country="USA",
    ),
    "TD Banknorth Garden, Boston, Massachusetts": TD_GARDEN,
    "ARCO Arena (II), Sacramento, California": ARCO_ARENA,
    "Ford Center, Oklahoma City, Oklahoma": PAYCOM_CENTRE,
    "Nashville Municipal Auditorium, Nashville, Tennessee": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.10,
        lng=-86.46,
        housenumber="417",
        country="USA",
    ),
    "Rosemont, Illinois": SportsballGeocodeTuple(
        city="Rosemont",
        state="IL",
        postal="",
        lat=41.990833,
        lng=-87.873889,
        housenumber="",
        country="USA",
    ),
    "Greensboro, North Carolina": GREENSBORO,
    "Elon, North Carolina": ELON,
    "Charlotte Bobcats Arena, Charlotte, North Carolina": SPECTRUM_CENTRE,
    "Mercedes-Benz Arena, Shanghai": SportsballGeocodeTuple(
        city="Shanghai",
        state="",
        postal="",
        lat=31.91,
        lng=121.48,
        housenumber="",
        country="China",
    ),
    "KeyArena at Seattle Center, Seattle, Washington": CLIMATE_PLEDGE_ARENA,
    "Rocket Arena, Cleveland, Ohio": ROCKET_MORTGAGE_FIELDHOUSE,
    "Continental Airlines Arena, East Rutherford, New Jersey": SportsballGeocodeTuple(
        city="East Rutherford",
        state="NJ",
        postal="",
        lat=40.811667,
        lng=-74.0675,
        housenumber="50",
        country="USA",
    ),
    "Brooks Gym, Johnson City, Tennessee": SportsballGeocodeTuple(
        city="Johnson City",
        state="TN",
        postal="37614",
        lat=36.3025963,
        lng=-82.3703615,
        housenumber="1127",
        country="USA",
    ),
    "Qubein Center, High Point, North Carolina": SportsballGeocodeTuple(
        city="High Point",
        state="NC",
        postal="27262",
        lat=35.978333,
        lng=-79.996667,
        housenumber="1050",
        country="USA",
    ),
    "America West Arena, Phoenix, Arizona": AMERICA_WEST_ARENA,
    "SBC Center, San Antonio, Texas": FROST_BANK_CENTER,
    "Gund Arena, Cleveland, Ohio": ROCKET_MORTGAGE_FIELDHOUSE,
    "MCI Center, Washington, District of Columbia": CAPITAL_ONE_ARENA,
    "Oakland Arena, Oakland, California": OAKLAND_ARENA,
    "TD Waterhouse Centre, Orlando, Florida": ORLANDO_ARENA,
    "LLoyd Noble Center, Norman, Oklahoma": LLOYD_NOBLE_CENTER,
    "Pete Maravich Assembly Center, Baton Rouge, Louisiana": PETE_MARAVICH_ASSEMBLY_CENTER,
    "FleetCenter, Boston, Massachusetts": TD_GARDEN,
    "Charlotte Coliseum, Charlotte, North Carolina": CHARLOTTE_COLISEUM,
    "Pyramid Arena, Memphis, Tennessee": SportsballGeocodeTuple(
        city="Memphis",
        state="TN",
        postal="",
        lat=35.155556,
        lng=-90.051944,
        housenumber="1",
        country="USA",
    ),
    "The Arena in Oakland, Oakland, California": OAKLAND_ARENA,
    "Cox Pavilion, Las Vegas, Nevada": SportsballGeocodeTuple(
        city="Las Vegas",
        state="NV",
        postal="",
        lat=36.104167,
        lng=-115.143056,
        housenumber="",
        country="USA",
    ),
    "Renaissance Coliseum, Peoria, Illinois": SportsballGeocodeTuple(
        city="Peoria",
        state="IL",
        postal="",
        lat=40.699167,
        lng=-89.617778,
        housenumber="",
        country="USA",
    ),
    "First Union Center, Philadelphia, Pennsylvania": SPECTRUM,
    "Compaq Center, Houston, Texas": COMPAQ_CENTER,
    "Reunion Arena, Dallas, Texas": REUNION_ARENA,
    "General Motors Place, Vancouver, Canada": ROGERS_ARENA,
    "Merrell Center, Katy, Texas": MERRELL_CENTER,
    "Nassau Veterans Memorial Coliseum, Uniondale, New York": NASSAU_COLISEUM,
    "McNichols Sports Arena, Denver, Colorado": MCNICHOLS_SPORTS_ARENA,
    "Freedom Hall, Louisville, Kentucky": FREEDOM_HALL,
    "HemisFair Arena, San Antonio, Texas": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="78203",
        lat=29.420134,
        lng=-98.483299,
        housenumber="601",
        country="USA",
    ),
    "Market Square Arena, Indianapolis, Indiana": MARKET_SQUARE_ARENA,
    "Hampton Coliseum, Hampton, Virginia": SportsballGeocodeTuple(
        city="Hampton",
        state="VA",
        postal="23666",
        lat=37.034725,
        lng=-76.381339,
        housenumber="1000",
        country="USA",
    ),
    "St. Louis Arena, St. Louis, Missouri": ENTERPRISE_CENTER,
    "Richmond Coliseum, Richmond, Virginia": SportsballGeocodeTuple(
        city="Richmond",
        state="VA",
        postal="23219",
        lat=37.544705,
        lng=-77.434484,
        housenumber="601",
        country="USA",
    ),
    "Salt Palace, Salt Lake City, Utah": SportsballGeocodeTuple(
        city="Salt Lake City",
        state="UT",
        postal="",
        lat=40.766944,
        lng=-111.895,
        housenumber="100",
        country="USA",
    ),
    "Cincinnati Riverfront Coliseum, Cincinnati, Ohio": PAYCOR_STADIUM,
    "Hulman Civic-University Center, Terre Haute, Indiana": HULMAN_CENTER,
    "San Diego Sports Arena, San Diego, California": SAN_DIEGO_SPORTS_ARENA,
    "Denver Auditorium Arena, Denver, Colorado": SportsballGeocodeTuple(
        city="Denver",
        state="CO",
        postal="80204",
        lat=39.744444,
        lng=-104.9975,
        housenumber="1323",
        country="USA",
    ),
    "Mid-South Coliseum, Memphis, Tennessee": MID_SOUTH_COLISEUM,
    "Memorial Coliseum, Lexington, Kentucky": SportsballGeocodeTuple(
        city="Lexington",
        state="KT",
        postal="40508",
        lat=38.0394636,
        lng=-84.5004952,
        housenumber="",
        country="USA",
    ),
    "Indiana State Fair Coliseum, Indianapolis, Indiana": SportsballGeocodeTuple(
        city="Indianapolis",
        state="IN",
        postal="",
        lat=39.8275,
        lng=-86.135,
        housenumber="1202",
        country="USA",
    ),
    "Golden Hall, San Diego, California": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="92101",
        lat=32.7507735,
        lng=-117.1008248,
        housenumber="9",
        country="USA",
    ),
    "Tuscaloosa, Alabama": SportsballGeocodeTuple(
        city="Tuscaloosa",
        state="AL",
        postal="",
        lat=33.209722,
        lng=-87.569167,
        housenumber="",
        country="USA",
    ),
    "Lubbock, Texas": LUBBOCK,
    "Chestnut Hill, Massachusetts": SportsballGeocodeTuple(
        city="Chestnut Hill",
        state="MA",
        postal="",
        lat=42.330556,
        lng=-71.166111,
        housenumber="",
        country="USA",
    ),
    "Minneapolis, Minnesota": MINNEAPOLIS,
    "Ann Arbor, Michigan": SportsballGeocodeTuple(
        city="Ann Arbor",
        state="MI",
        postal="",
        lat=42.281389,
        lng=-83.748333,
        housenumber="",
        country="USA",
    ),
    "Norman, Oklahoma": NORMAN,
    "Greenville, South Carolina": GREENVILLE,
    "Storrs, Connecticut": SportsballGeocodeTuple(
        city="Storrs",
        state="CT",
        postal="",
        lat=41.808333,
        lng=-72.249444,
        housenumber="",
        country="USA",
    ),
    "Muncie, Indiana": SportsballGeocodeTuple(
        city="Muncie",
        state="IN",
        postal="",
        lat=40.196667,
        lng=-85.375,
        housenumber="",
        country="USA",
    ),
    "Bowling Green, Ohio": SportsballGeocodeTuple(
        city="Bowling Green",
        state="OH",
        postal="",
        lat=41.373889,
        lng=-83.650833,
        housenumber="",
        country="USA",
    ),
    "Annapolis, Maryland": SportsballGeocodeTuple(
        city="Annapolis",
        state="MD",
        postal="",
        lat=38.973056,
        lng=-76.501111,
        housenumber="",
        country="USA",
    ),
    "Providence, Rhode Island": SportsballGeocodeTuple(
        city="Providence",
        state="RI",
        postal="",
        lat=41.823611,
        lng=-71.422222,
        housenumber="",
        country="USA",
    ),
    "St. Bonaventure, New York": SportsballGeocodeTuple(
        city="St. Bonaventure",
        state="NY",
        postal="",
        lat=42.080278,
        lng=-78.475,
        housenumber="",
        country="USA",
    ),
    "Pensacola, Florida": PENSACOLA,
    "Johnson City, Tennessee": SportsballGeocodeTuple(
        city="Johnson City",
        state="TN",
        postal="",
        lat=36.333333,
        lng=-82.366667,
        housenumber="",
        country="USA",
    ),
    "Hamilton, New York": SportsballGeocodeTuple(
        city="Hamilton",
        state="NY",
        postal="",
        lat=42.829167,
        lng=-75.552778,
        housenumber="",
        country="USA",
    ),
    "Washington, District of Columbia": WASHINGTON,
    "New Britain, Connecticut": SportsballGeocodeTuple(
        city="New Britain",
        state="CT",
        postal="",
        lat=41.675,
        lng=-72.787222,
        housenumber="",
        country="USA",
    ),
    "Cincinnati, Ohio": CINCINNATI,
    "Teaneck, New Jersey": SportsballGeocodeTuple(
        city="Teaneck",
        state="NJ",
        postal="",
        lat=40.890317,
        lng=-74.011478,
        housenumber="",
        country="USA",
    ),
    "Bronx, New York": BRONX,
    "Fairfax, Virginia": SportsballGeocodeTuple(
        city="Fairfax",
        state="VA",
        postal="",
        lat=38.8525,
        lng=-77.304167,
        housenumber="",
        country="USA",
    ),
    "Oxford, Ohio": OXFORD,
    "Raleigh, North Carolina": RALEIGH,
    "DeKalb, Illinois": SportsballGeocodeTuple(
        city="DeKalb",
        state="IL",
        postal="",
        lat=41.931389,
        lng=-88.750278,
        housenumber="",
        country="USA",
    ),
    "Natchitoches, Louisiana": NATCHITOCHES,
    "Athens, Ohio": SportsballGeocodeTuple(
        city="Athens",
        state="OH",
        postal="",
        lat=39.329167,
        lng=-82.096111,
        housenumber="",
        country="USA",
    ),
    "Philadelphia, Pennsylvania": PHILADELPHIA,
    "South Bend, Indiana": SportsballGeocodeTuple(
        city="South Bend",
        state="IN",
        postal="",
        lat=41.676389,
        lng=-86.269444,
        housenumber="",
        country="USA",
    ),
    "Laramie, Wyoming": SportsballGeocodeTuple(
        city="Laramie",
        state="WY",
        postal="",
        lat=41.311111,
        lng=-105.593611,
        housenumber="",
        country="USA",
    ),
    "College Station, Texas": SportsballGeocodeTuple(
        city="College Station",
        state="TX",
        postal="",
        lat=30.601389,
        lng=-96.314444,
        housenumber="",
        country="USA",
    ),
    "Ames, Iowa": AMES,
    "San Antonio, Texas": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="",
        lat=29.425,
        lng=-98.493889,
        housenumber="",
        country="USA",
    ),
    "West Lafayette, Indiana": SportsballGeocodeTuple(
        city="West Lafayette",
        state="IN",
        postal="",
        lat=40.443333,
        lng=-86.923611,
        housenumber="",
        country="USA",
    ),
    "Lexington, Kentucky": SportsballGeocodeTuple(
        city="Lexington",
        state="KT",
        postal="",
        lat=38.046389,
        lng=-84.496944,
        housenumber="",
        country="USA",
    ),
    "Tucson, Arizona": SportsballGeocodeTuple(
        city="Tucson",
        state="AZ",
        postal="",
        lat=32.221667,
        lng=-110.926389,
        housenumber="",
        country="USA",
    ),
    "Starkville, Mississippi": STARKVILLE,
    "Smithfield, Rhode Island": SportsballGeocodeTuple(
        city="Smithfield",
        state="RI",
        postal="",
        lat=41.9,
        lng=-71.533333,
        housenumber="",
        country="USA",
    ),
    "Dayton, Ohio": DAYTON,
    "Greenville, North Carolina": SportsballGeocodeTuple(
        city="Greenville",
        state="NC",
        postal="",
        lat=35.594444,
        lng=-77.376111,
        housenumber="",
        country="USA",
    ),
    "Orono, Maine": SportsballGeocodeTuple(
        city="Orono",
        state="ME",
        postal="",
        lat=44.883333,
        lng=-68.672222,
        housenumber="",
        country="USA",
    ),
    "Columbus, Ohio": COLUMBUS,
    "Reno, Nevada": RENO,
    "San Jose, California": SAN_JOSE,
    "Columbia, South Carolina": SportsballGeocodeTuple(
        city="Columbia",
        state="SC",
        postal="",
        lat=34.000556,
        lng=-81.034722,
        housenumber="",
        country="USA",
    ),
    "Birmingham, Alabama": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.5175,
        lng=-86.809444,
        housenumber="",
        country="USA",
    ),
    "Buffalo, New York": BUFFALO,
    "Boca Raton, Florida": BOCA_RATON,
    "Easton, Pennsylvania": SportsballGeocodeTuple(
        city="Easton",
        state="PA",
        postal="",
        lat=40.688333,
        lng=-75.216389,
        housenumber="",
        country="USA",
    ),
    "Highland Heights, Kentucky": SportsballGeocodeTuple(
        city="Highland Heights",
        state="KT",
        postal="",
        lat=39.035556,
        lng=-84.456667,
        housenumber="",
        country="USA",
    ),
    "Rochester, Michigan": SportsballGeocodeTuple(
        city="Rochester",
        state="MI",
        postal="",
        lat=42.680556,
        lng=-83.133889,
        housenumber="",
        country="USA",
    ),
    "Toledo, Ohio": TOLEDO,
    "Burlington, Vermont": SportsballGeocodeTuple(
        city="Burlington",
        state="VT",
        postal="",
        lat=44.475833,
        lng=-73.211944,
        housenumber="",
        country="USA",
    ),
    "Blacksburg, Virginia": SportsballGeocodeTuple(
        city="Blacksburg",
        state="VI",
        postal="",
        lat=37.23,
        lng=-80.417778,
        housenumber="",
        country="USA",
    ),
    "Kalamazoo, Michigan": SportsballGeocodeTuple(
        city="Kalamazoo",
        state="MI",
        postal="",
        lat=42.29,
        lng=-85.585833,
        housenumber="",
        country="USA",
    ),
    "Colorado Springs, Colorado": SportsballGeocodeTuple(
        city="Colorado Springs",
        state="CO",
        postal="",
        lat=38.833889,
        lng=-104.825278,
        housenumber="",
        country="USA",
    ),
    "Fort Collins, Colorado": SportsballGeocodeTuple(
        city="Fort Collins",
        state="CO",
        postal="",
        lat=40.559167,
        lng=-105.078056,
        housenumber="",
        country="USA",
    ),
    "Eugene, Oregon": EUGENE,
    "Charlottesville, Virginia": SportsballGeocodeTuple(
        city="Charlottesville",
        state="VI",
        postal="",
        lat=38.0299,
        lng=-78.479,
        housenumber="",
        country="USA",
    ),
    "Fresno, California": FRESNO,
    "War Memorial Coliseum, Fort Wayne, Indiana": ALLEN_COUNTY_WAR_MEMORIAL_COLISEUM,
    "Peterson Gym, San Diego, California": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="",
        lat=32.7742,
        lng=-117.0768,
        housenumber="5340",
        country="USA",
    ),
    "St. Paul Civic Center, St. Paul, Minnesota": SportsballGeocodeTuple(
        city="St. Paul",
        state="MN",
        postal="55102",
        lat=39.4285806,
        lng=-85.6296931,
        housenumber="143",
        country="USA",
    ),
    "Riverdale, New York": SportsballGeocodeTuple(
        city="Riverdale",
        state="NY",
        postal="",
        lat=40.894,
        lng=-73.913,
        housenumber="",
        country="USA",
    ),
    "North Andover, Massachusetts": SportsballGeocodeTuple(
        city="North Andover",
        state="MA",
        postal="",
        lat=42.698611,
        lng=-71.135556,
        housenumber="",
        country="USA",
    ),
    "Niagara University, New York": SportsballGeocodeTuple(
        city="Niagara University",
        state="NY",
        postal="",
        lat=43.138,
        lng=-79.037,
        housenumber="",
        country="USA",
    ),
    "Wilmington, North Carolina": SportsballGeocodeTuple(
        city="Wilmington",
        state="NC",
        postal="",
        lat=34.21,
        lng=-77.886667,
        housenumber="",
        country="USA",
    ),
    "Jersey City, New Jersey": SportsballGeocodeTuple(
        city="Jersey City",
        state="NJ",
        postal="",
        lat=40.71,
        lng=-74.06,
        housenumber="",
        country="USA",
    ),
    "Orangeburg, South Carolina": SportsballGeocodeTuple(
        city="Orangeburg",
        state="SC",
        postal="",
        lat=33.491944,
        lng=-80.855278,
        housenumber="",
        country="USA",
    ),
    "Pine Bluff, Arkansas": SportsballGeocodeTuple(
        city="Pine Bluff",
        state="AR",
        postal="",
        lat=34.228333,
        lng=-92.0,
        housenumber="",
        country="USA",
    ),
    "Grambling, Louisiana": SportsballGeocodeTuple(
        city="Grambling",
        state="LA",
        postal="",
        lat=32.5275,
        lng=-92.713889,
        housenumber="",
        country="USA",
    ),
    "Murfreesboro, Tennessee": SportsballGeocodeTuple(
        city="Murfreesboro",
        state="TN",
        postal="",
        lat=35.846111,
        lng=-86.391944,
        housenumber="",
        country="USA",
    ),
    "Itta Bena, Mississippi": SportsballGeocodeTuple(
        city="Itta Bena",
        state="MS",
        postal="",
        lat=33.4975,
        lng=-90.324444,
        housenumber="",
        country="USA",
    ),
    "Huntsville, Texas": SportsballGeocodeTuple(
        city="Huntsville",
        state="TX",
        postal="",
        lat=30.722222,
        lng=-95.553333,
        housenumber="",
        country="USA",
    ),
    "Baton Rouge, Louisiana": BATON_ROUGE,
    "Bowling Green, Kentucky": SportsballGeocodeTuple(
        city="Bowling Green",
        state="KT",
        postal="",
        lat=36.981667,
        lng=-86.444444,
        housenumber="",
        country="USA",
    ),
    "Davis, California": SportsballGeocodeTuple(
        city="Davis",
        state="CA",
        postal="",
        lat=38.553889,
        lng=-121.738056,
        housenumber="",
        country="USA",
    ),
    "ExploreAsheville.com Arena, Asheville, North Carolina": HARRAHS_CHEROKEE_CENTER,
    "St. Louis, Missouri": ST_LOUIS,
    "Dover, Delaware": SportsballGeocodeTuple(
        city="Dover",
        state="DE",
        postal="",
        lat=39.158056,
        lng=-75.524444,
        housenumber="",
        country="USA",
    ),
    "Moon, Pennsylvania": SportsballGeocodeTuple(
        city="Moon",
        state="PA",
        postal="",
        lat=40.516667,
        lng=-80.233333,
        housenumber="",
        country="USA",
    ),
    "Fair Park, Birmingham, Alabama": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.4968,
        lng=-86.8714,
        housenumber="",
        country="USA",
    ),
    "Broadview Center, Albany, New York": SportsballGeocodeTuple(
        city="Albany",
        state="NY",
        postal="12222",
        lat=42.681667,
        lng=-73.828333,
        housenumber="1400",
        country="USA",
    ),
    "Newark, Delaware": SportsballGeocodeTuple(
        city="Newark",
        state="DE",
        postal="",
        lat=39.683611,
        lng=-75.749722,
        housenumber="",
        country="USA",
    ),
    "Hempstead, New York": HEMPSTEAD,
    "Boston, Massachusetts": BOSTON,
    "Lewisburg, Pennsylvania": SportsballGeocodeTuple(
        city="Lewisburg",
        state="PA",
        postal="",
        lat=40.963889,
        lng=-76.888056,
        housenumber="",
        country="USA",
    ),
    "Miami, Florida": MIAMI,
    "Terre Haute, Indiana": SportsballGeocodeTuple(
        city="Terre Haute",
        state="IN",
        postal="",
        lat=39.469722,
        lng=-87.389722,
        housenumber="",
        country="USA",
    ),
    "Ruston, Louisiana": SportsballGeocodeTuple(
        city="Ruston",
        state="LA",
        postal="",
        lat=32.529722,
        lng=-92.640556,
        housenumber="",
        country="USA",
    ),
    "Poughkeepsie, New York": SportsballGeocodeTuple(
        city="Poughkeepsie",
        state="NY",
        postal="",
        lat=41.703889,
        lng=-73.93,
        housenumber="",
        country="USA",
    ),
    "Springfield, Missouri": SportsballGeocodeTuple(
        city="Springfield",
        state="MO",
        postal="",
        lat=37.215278,
        lng=-93.298333,
        housenumber="",
        country="USA",
    ),
    "West Long Branch, New Jersey": SportsballGeocodeTuple(
        city="West Long Branch",
        state="NJ",
        postal="",
        lat=40.287904,
        lng=-74.020019,
        housenumber="",
        country="USA",
    ),
    "Emmitsburg, Maryland": SportsballGeocodeTuple(
        city="Emmitsburg",
        state="MD",
        postal="",
        lat=39.704167,
        lng=-77.321111,
        housenumber="",
        country="USA",
    ),
    "Florence, Alabama": SportsballGeocodeTuple(
        city="Florence",
        state="AL",
        postal="",
        lat=34.83035,
        lng=-87.665419,
        housenumber="",
        country="USA",
    ),
    "Lawrenceville, New Jersey": SportsballGeocodeTuple(
        city="Lawrenceville",
        state="NJ",
        postal="",
        lat=40.302787,
        lng=-74.738004,
        housenumber="",
        country="USA",
    ),
    "Albany, New York": SportsballGeocodeTuple(
        city="Albany",
        state="NY",
        postal="",
        lat=42.6525,
        lng=-73.757222,
        housenumber="",
        country="USA",
    ),
    "Carbondale, Illinois": SportsballGeocodeTuple(
        city="Carbondale",
        state="IL",
        postal="",
        lat=37.722222,
        lng=-89.258333,
        housenumber="",
        country="USA",
    ),
    "Staten Island, New York": STATEN_ISLAND,
    "Abilene, Texas": SportsballGeocodeTuple(
        city="Abilene",
        state="TX",
        postal="",
        lat=32.45,
        lng=-99.75,
        housenumber="",
        country="USA",
    ),
    "Green Bay, Wisconsin": GREEN_BAY,
    "Las Cruces, New Mexico": SportsballGeocodeTuple(
        city="Las Cruces",
        state="NM",
        postal="",
        lat=32.314444,
        lng=-106.778889,
        housenumber="",
        country="USA",
    ),
    "Stephenville, Texas": SportsballGeocodeTuple(
        city="Stephenville",
        state="TX",
        postal="",
        lat=32.209722,
        lng=-98.2375,
        housenumber="",
        country="USA",
    ),
    "Orem, Utah": SportsballGeocodeTuple(
        city="Orem",
        state="UT",
        postal="",
        lat=40.290556,
        lng=-111.729722,
        housenumber="",
        country="USA",
    ),
    "Bakersfield, California": SportsballGeocodeTuple(
        city="Bakersfield",
        state="CA",
        postal="",
        lat=35.373333,
        lng=-119.018889,
        housenumber="",
        country="USA",
    ),
    "Northridge, California": SportsballGeocodeTuple(
        city="Northridge",
        state="CA",
        postal="",
        lat=34.228056,
        lng=-118.535833,
        housenumber="",
        country="USA",
    ),
    "Irvine, California": SportsballGeocodeTuple(
        city="Irvine",
        state="CA",
        postal="",
        lat=33.669444,
        lng=-117.823056,
        housenumber="",
        country="USA",
    ),
    "St. George, Utah": ST_GEORGE,
    "Long Beach, California": LONG_BEACH,
    "El Paso, Texas": SportsballGeocodeTuple(
        city="El Paso",
        state="TX",
        postal="",
        lat=31.759167,
        lng=-106.488611,
        housenumber="",
        country="USA",
    ),
    "San Luis Obispo, California": SportsballGeocodeTuple(
        city="San Luis Obispo",
        state="CA",
        postal="",
        lat=35.274167,
        lng=-120.663056,
        housenumber="",
        country="USA",
    ),
    "Fullerton, California": SportsballGeocodeTuple(
        city="Fullerton",
        state="CA",
        postal="",
        lat=33.88,
        lng=-117.928611,
        housenumber="",
        country="USA",
    ),
    "Riverside, California": RIVERSIDE,
    "La Jolla, California": SportsballGeocodeTuple(
        city="La Jolla",
        state="CA",
        postal="",
        lat=32.84,
        lng=-117.276944,
        housenumber="",
        country="USA",
    ),
    "Indiana Assembly Hall, Bloomington, Indiana": INDIANA_ASSEMBLY_HALL,
    "Anderson High School Wigwam, Anderson, Indiana": SportsballGeocodeTuple(
        city="Anderson",
        state="IN",
        postal="",
        lat=40.103056,
        lng=-85.685833,
        housenumber="1229",
        country="USA",
    ),
    "Miami-Dade Junior College North, Miami, Florida": SportsballGeocodeTuple(
        city="Miami",
        state="FL",
        postal="",
        lat=25.777778,
        lng=-80.190556,
        housenumber="1229",
        country="USA",
    ),
    "Miami Beach Convention Hall, Miami Beach, Florida": MIAMI_BEACH_CONVENTION_CENTER,
    "Tucson Community Center, Tucson, Arizona": SportsballGeocodeTuple(
        city="Tucson",
        state="AZ",
        postal="",
        lat=32.218333,
        lng=-110.974167,
        housenumber="260",
        country="USA",
    ),
    "Pittsburgh Civic Arena, Pittsburgh, Pennsylvania": CIVIC_ARENA,
    "Curtis Hixon Hall, Tampa, Florida": SportsballGeocodeTuple(
        city="Tampa",
        state="FL",
        postal="",
        lat=27.949167,
        lng=-82.461944,
        housenumber="",
        country="USA",
    ),
    "Winston-Salem Memorial Coliseum, Winston-Salem, North Carolina": SportsballGeocodeTuple(
        city="Winston-Salem",
        state="NC",
        postal="",
        lat=36.1262,
        lng=-80.2581,
        housenumber="",
        country="USA",
    ),
    "Uniontown High School, Uniontown, Pennsylvania": SportsballGeocodeTuple(
        city="Uniontown",
        state="PA",
        postal="",
        lat=39.89632,
        lng=-79.72016,
        housenumber="",
        country="USA",
    ),
    "Island Garden, West Hempstead, New York": SportsballGeocodeTuple(
        city="West Hempstead",
        state="NY",
        postal="",
        lat=40.707222,
        lng=-73.656667,
        housenumber="",
        country="USA",
    ),
    "Roanoke Civic Center, Roanoke, Virginia": SportsballGeocodeTuple(
        city="Roanoke",
        state="VA",
        postal="24016",
        lat=37.280171,
        lng=-79.935669,
        housenumber="710",
        country="USA",
    ),
    "Maple Leaf Gardens, Toronto, Canada": MAPLE_LEAF_GARDENS,
    "Utah State Spectrum, Logan, Utah": SMITH_SPECTRUM,
    "Bayfront Arena, St. Petersburg, Florida": SportsballGeocodeTuple(
        city="St. Petersburg",
        state="FL",
        postal="",
        lat=27.766583,
        lng=-82.631694,
        housenumber="400",
        country="USA",
    ),
    "Richmond Arena, Richmond, Virginia": SportsballGeocodeTuple(
        city="Richmond",
        state="VA",
        postal="",
        lat=37.569855,
        lng=-77.462411,
        housenumber="400",
        country="USA",
    ),
    "Mt. Pleasant, Michigan": SportsballGeocodeTuple(
        city="Mt. Pleasant",
        state="MI",
        postal="",
        lat=43.597778,
        lng=-84.7675,
        housenumber="",
        country="USA",
    ),
    "Conway, Arkansas": SportsballGeocodeTuple(
        city="Conway",
        state="AR",
        postal="",
        lat=35.087222,
        lng=-92.453333,
        housenumber="",
        country="USA",
    ),
    "Kent, Ohio": SportsballGeocodeTuple(
        city="Kent",
        state="OH",
        postal="",
        lat=41.149167,
        lng=-81.360833,
        housenumber="",
        country="USA",
    ),
    "Hofstra Physical Fitness Center, Hempstead, New York": SportsballGeocodeTuple(
        city="Hempstead",
        state="NY",
        postal="",
        lat=40.7216566,
        lng=-73.5998583,
        housenumber="",
        country="USA",
    ),
    "Jacksonville Coliseum, Jacksonville, Florida": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="32202",
        lat=30.324596,
        lng=-81.640901,
        housenumber="1145",
        country="USA",
    ),
    "Moby Gym, Ft. Collins, Colorado": MOBY_ARENA,
    "Salem Civic Center, Salem, Virginia": SportsballGeocodeTuple(
        city="Salem",
        state="VA",
        postal="",
        lat=37.283889,
        lng=-80.040833,
        housenumber="",
        country="USA",
    ),
    "Tarrant County Convention Center, Ft. Worth, Texas": SportsballGeocodeTuple(
        city="Ft. Worth",
        state="TX",
        postal="76102",
        lat=32.749,
        lng=-97.3277,
        housenumber="12",
        country="USA",
    ),
    "Lubbock Municipal Coliseum, Lubbock, Texas": SportsballGeocodeTuple(
        city="Lubbock",
        state="TX",
        postal="79409",
        lat=33.59,
        lng=-101.8775,
        housenumber="2720",
        country="USA",
    ),
    "Dorton Arena, Raleigh, North Carolina": DORTON_ARENA,
    "J.S. Dorton Arena, Raleigh, North Carolina": DORTON_ARENA,
    "West Palm Beach Auditorium, West Palm Beach, Florida": SportsballGeocodeTuple(
        city="West Palm Beach",
        state="FL",
        postal="33401",
        lat=26.723611,
        lng=-80.082222,
        housenumber="1610",
        country="USA",
    ),
    "Sikeston Field House, Sikeston, Missouri": SportsballGeocodeTuple(
        city="Sikeston",
        state="MO",
        postal="63801",
        lat=36.87943,
        lng=-89.57209,
        housenumber="200",
        country="USA",
    ),
    "Swenson Gym, Ogden, Utah": SportsballGeocodeTuple(
        city="Ogden",
        state="UT",
        postal="",
        lat=41.190833,
        lng=-111.941944,
        housenumber="1356",
        country="USA",
    ),
    "Los Angeles Memorial Sports Arena, Los Angeles, California": LOS_ANGELES_MEMORIAL_COLESIUM,
    "Auburn, Alabama": SportsballGeocodeTuple(
        city="Auburn",
        state="AL",
        postal="",
        lat=32.597778,
        lng=-85.480833,
        housenumber="",
        country="USA",
    ),
    "Chapel Hill, North Carolina": SportsballGeocodeTuple(
        city="Chapel Hill",
        state="NC",
        postal="",
        lat=35.927222,
        lng=-79.039167,
        housenumber="",
        country="USA",
    ),
    "Knoxville, Tennessee": KNOXVILLE,
    "Gainesville, Florida": GAINESVILLE,
    "Tempe, Arizona": TEMPE,
    "Manhattan, Kansas": MANHATTAN,
    "Clemson, South Carolina": SportsballGeocodeTuple(
        city="Clemson",
        state="SC",
        postal="",
        lat=34.685,
        lng=-82.814722,
        housenumber="",
        country="USA",
    ),
    "Madison, Wisconsin": MADISON,
    "College Park, Maryland": SportsballGeocodeTuple(
        city="College Park",
        state="MD",
        postal="",
        lat=38.996667,
        lng=-76.9275,
        housenumber="",
        country="USA",
    ),
    "Columbia, Missouri": SportsballGeocodeTuple(
        city="Columbia",
        state="MO",
        postal="",
        lat=38.9475,
        lng=-92.326667,
        housenumber="",
        country="USA",
    ),
    "Provo, Utah": SportsballGeocodeTuple(
        city="Provo",
        state="UT",
        postal="",
        lat=40.244444,
        lng=-111.660833,
        housenumber="",
        country="USA",
    ),
    "Lawrence, Kansas": SportsballGeocodeTuple(
        city="Lawrence",
        state="KS",
        postal="",
        lat=38.959722,
        lng=-95.264167,
        housenumber="",
        country="USA",
    ),
    "Fayetteville, Arkansas": SportsballGeocodeTuple(
        city="Fayetteville",
        state="AR",
        postal="",
        lat=36.0625,
        lng=-94.1575,
        housenumber="",
        country="USA",
    ),
    "Buies Creek, North Carolina": SportsballGeocodeTuple(
        city="Buies Creek",
        state="NC",
        postal="",
        lat=35.408056,
        lng=-78.741389,
        housenumber="",
        country="USA",
    ),
    "Charleston, South Carolina": CHARLESTON,
    "Ithaca, New York": SportsballGeocodeTuple(
        city="Ithaca",
        state="NY",
        postal="",
        lat=42.443333,
        lng=-76.5,
        housenumber="",
        country="USA",
    ),
    "Bloomington, Indiana": SportsballGeocodeTuple(
        city="Bloomington",
        state="IN",
        postal="",
        lat=39.162222,
        lng=-86.522222,
        housenumber="",
        country="USA",
    ),
    "Kennesaw, Georgia": SportsballGeocodeTuple(
        city="Kennesaw",
        state="GA",
        postal="",
        lat=34.023333,
        lng=-84.615278,
        housenumber="",
        country="USA",
    ),
    "Amherst, Massachusetts": SportsballGeocodeTuple(
        city="Amherst",
        state="MA",
        postal="",
        lat=42.383333,
        lng=-72.516667,
        housenumber="",
        country="USA",
    ),
    "Richmond, Virginia": RICHMOND,
    "Syracuse, New York": SportsballGeocodeTuple(
        city="Syracuse",
        state="NY",
        postal="",
        lat=43.046944,
        lng=-76.144444,
        housenumber="",
        country="USA",
    ),
    "Morgantown, West Virginia": SportsballGeocodeTuple(
        city="Morgantown",
        state="WV",
        postal="",
        lat=39.633611,
        lng=-79.950556,
        housenumber="",
        country="USA",
    ),
    "Omaha, Nebraska": SportsballGeocodeTuple(
        city="Omaha",
        state="NE",
        postal="",
        lat=41.258611,
        lng=-95.9375,
        housenumber="",
        country="USA",
    ),
    "Santa Barbara, California": SportsballGeocodeTuple(
        city="Santa Barbara",
        state="CA",
        postal="",
        lat=34.416667,
        lng=-119.7,
        housenumber="",
        country="USA",
    ),
    "Stony Brook, New York": SportsballGeocodeTuple(
        city="Stony Brook",
        state="NY",
        postal="",
        lat=40.906389,
        lng=-73.128333,
        housenumber="",
        country="USA",
    ),
    "Winston-Salem, North Carolina": WINSTON_SALEM,
    "Hanover, New Hampshire": SportsballGeocodeTuple(
        city="Hanover",
        state="NH",
        postal="",
        lat=43.702222,
        lng=-72.289444,
        housenumber="",
        country="USA",
    ),
    "Davidson, North Carolina": SportsballGeocodeTuple(
        city="Davidson",
        state="NC",
        postal="",
        lat=35.500556,
        lng=-80.846944,
        housenumber="",
        country="USA",
    ),
    "Ypsilanti, Michigan": SportsballGeocodeTuple(
        city="Ypsilanti",
        state="MI",
        postal="",
        lat=42.242778,
        lng=-83.618333,
        housenumber="",
        country="USA",
    ),
    "Daytona Beach, Florida": DAYTONA_BEACH,
    "Richmond, Kentucky": SportsballGeocodeTuple(
        city="Richmond",
        state="KT",
        postal="",
        lat=37.731111,
        lng=-84.293889,
        housenumber="",
        country="USA",
    ),
    "Jacksonville, Alabama": SportsballGeocodeTuple(
        city="Jacksonville",
        state="AL",
        postal="",
        lat=33.815833,
        lng=-85.760556,
        housenumber="",
        country="USA",
    ),
    "Stillwater, Oklahoma": SportsballGeocodeTuple(
        city="Stillwater",
        state="OK",
        postal="",
        lat=36.116,
        lng=-97.059,
        housenumber="",
        country="USA",
    ),
    "Arlington, Texas": ARLINGTON,
    "Boulder, Colorado": SportsballGeocodeTuple(
        city="Boulder",
        state="CO",
        postal="",
        lat=40.015,
        lng=-105.2705,
        housenumber="",
        country="USA",
    ),
    "Tallahassee, Florida": SportsballGeocodeTuple(
        city="Tallahassee",
        state="FL",
        postal="",
        lat=30.438333,
        lng=-84.280556,
        housenumber="",
        country="USA",
    ),
    "New Rochelle, New York": SportsballGeocodeTuple(
        city="New Rochelle",
        state="NY",
        postal="",
        lat=40.908611,
        lng=-73.781944,
        housenumber="",
        country="USA",
    ),
    "Logan, Utah": SportsballGeocodeTuple(
        city="Logan",
        state="UT",
        postal="",
        lat=41.763889,
        lng=-111.8725,
        housenumber="",
        country="USA",
    ),
    "Prairie View, Texas": SportsballGeocodeTuple(
        city="Prairie View",
        state="TX",
        postal="",
        lat=30.082222,
        lng=-95.991667,
        housenumber="",
        country="USA",
    ),
    "Bangor, Maine": SportsballGeocodeTuple(
        city="Bangor",
        state="ME",
        postal="",
        lat=44.803056,
        lng=-68.7675,
        housenumber="",
        country="USA",
    ),
    "Louisville Convention Center, Louisville, Kentucky": SportsballGeocodeTuple(
        city="Louisville",
        state="KT",
        postal="",
        lat=38.254194,
        lng=-85.755111,
        housenumber="",
        country="USA",
    ),
    "Long Beach Arena, Long Beach, California": LONG_BEACH_ARENA,
    "Uline Arena, Washington, District of Columbia": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="",
        lat=38.905,
        lng=-77.003056,
        housenumber="",
        country="USA",
    ),
    "Selland Arena, Fresno, California": SELLAND_ARENA,
    "Reid Gymnasium, Cullowhee, North Carolina": SportsballGeocodeTuple(
        city="Cullowhee",
        state="NC",
        postal="",
        lat=35.3102321,
        lng=-83.1838092,
        housenumber="",
        country="USA",
    ),
    "Levitt Arena, Wichita, Kansas": CHARLES_KOCH_ARENA,
    "Community Arena, Steubenville, Ohio": SportsballGeocodeTuple(
        city="Steubenville",
        state="OH",
        postal="",
        lat=40.369477,
        lng=-80.662254,
        housenumber="",
        country="USA",
    ),
    "Dinner Key Auditorium, Miami, Florida": SportsballGeocodeTuple(
        city="Miami",
        state="FL",
        postal="33133",
        lat=25.728391,
        lng=-80.236465,
        housenumber="2700",
        country="USA",
    ),
    "Oakland-Alameda County Coliseum Arena, Oakland, California": OAKLAND_ARENA,
    "Loyola Field House, New Orleans, Louisiana": SportsballGeocodeTuple(
        city="New Orleans",
        state="LA",
        postal="",
        lat=29.937556,
        lng=-90.119944,
        housenumber="",
        country="USA",
    ),
    "Metropolitan Sports Center, Bloomington, Minnesota": SportsballGeocodeTuple(
        city="Bloomington",
        state="MN",
        postal="55420",
        lat=44.858333,
        lng=-93.24,
        housenumber="7901",
        country="USA",
    ),
    "Sam Houston Coliseum, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.761453,
        lng=-95.369546,
        housenumber="",
        country="USA",
    ),
    "Long Island Arena, Commack, New York": SportsballGeocodeTuple(
        city="Commack",
        state="NY",
        postal="",
        lat=40.838333,
        lng=-73.283333,
        housenumber="",
        country="USA",
    ),
    "St. Paul Auditorium, St. Paul, Minnesota": SportsballGeocodeTuple(
        city="St. Paul",
        state="MN",
        postal="",
        lat=44.944853,
        lng=-93.099445,
        housenumber="175",
        country="USA",
    ),
    "East Lansing, Michigan": SportsballGeocodeTuple(
        city="East Lansing",
        state="MI",
        postal="",
        lat=42.748056,
        lng=-84.483611,
        housenumber="",
        country="USA",
    ),
    "Honolulu, Hawaii": SportsballGeocodeTuple(
        city="Honolulu",
        state="HI",
        postal="",
        lat=21.306944,
        lng=-157.858333,
        housenumber="",
        country="USA",
    ),
    "Lincoln, Nebraska": SportsballGeocodeTuple(
        city="Lincoln",
        state="NE",
        postal="",
        lat=40.809167,
        lng=-96.678056,
        housenumber="",
        country="USA",
    ),
    "New Orleans, Louisiana": NEW_ORLEANS_CITY,
    "San Jose Civic Auditorium, San Jose, California": SAN_JOSE_CIVIC_AUDITORIUM,
    "Blackham Coliseum, Lafeyette, Louisiana": SportsballGeocodeTuple(
        city="Lafeyette",
        state="LA",
        postal="70506",
        lat=30.210554,
        lng=-92.033122,
        housenumber="444",
        country="USA",
    ),
    "Duluth Arena Auditorium, Duluth, Minnesota": SportsballGeocodeTuple(
        city="Duluth",
        state="MN",
        postal="55802",
        lat=46.781389,
        lng=-92.098056,
        housenumber="350",
        country="USA",
    ),
    "Baltimore Civic Center, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.288611,
        lng=-76.618889,
        housenumber="201",
        country="USA",
    ),
    "Melbourne Cricket Ground, Melbourne, Austrália": MCG,
    "Marvel Stadium, Melbourne, Austrália": MARVEL_STADIUM,
    "Adelaide Oval, Adelaide, Austrália": ADELAIDE_OVAL,
    "The Gabba, Brisbane, Austrália": GABBA,
    "Detroit Olympia, Detroit, Michigan": DETROIT_OLYMPIA,
    "Convention Hall, Philadelphia, Pennsylvania": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="",
        lat=39.947368,
        lng=-75.195043,
        housenumber="3400",
        country="USA",
    ),
    "Miami Beach Auditorium, Miami Beach, Florida": MIAMI_BEACH_CONVENTION_CENTER,
    "Kiel Auditorium, St. Louis, Missouri": SportsballGeocodeTuple(
        city="St. Louis",
        state="MO",
        postal="63103",
        lat=38.627972,
        lng=-90.201782,
        housenumber="1401",
        country="USA",
    ),
    "Onondaga War Memorial, Syracuse, New York": SportsballGeocodeTuple(
        city="Syracuse",
        state="NY",
        postal="",
        lat=43.044722,
        lng=-76.148333,
        housenumber="515",
        country="USA",
    ),
    "New York, New York": NEW_YORK,
    "69th Regiment Armory, New York, New York": SportsballGeocodeTuple(
        city="New York",
        state="NY",
        postal="",
        lat=40.741389,
        lng=-73.984167,
        housenumber="68",
        country="USA",
    ),
    "Boston Garden, Boston, Massachusetts": BOSTON_GARDENS,
    "Madison Square Garden (III), New York, New York": MADISON_SQUARE_GARDEN,
    "West Point, New York": SportsballGeocodeTuple(
        city="West Point",
        state="NY",
        postal="",
        lat=41.395,
        lng=-73.955,
        housenumber="",
        country="USA",
    ),
    "Bethlehem, Pennsylvania": SportsballGeocodeTuple(
        city="Bethlehem",
        state="PA",
        postal="",
        lat=40.626111,
        lng=-75.375556,
        housenumber="",
        country="USA",
    ),
    "Memphis, Tennessee": MEMPHIS,
    "Champaign, Illinois": SportsballGeocodeTuple(
        city="Champaign",
        state="IL",
        postal="",
        lat=40.116389,
        lng=-88.243611,
        housenumber="",
        country="USA",
    ),
    "Iowa City, Iowa": SportsballGeocodeTuple(
        city="Iowa City",
        state="IO",
        postal="",
        lat=41.66,
        lng=-91.53,
        housenumber="",
        country="USA",
    ),
    "Cedar City, Utah": SportsballGeocodeTuple(
        city="Cedar City",
        state="UT",
        postal="",
        lat=37.6775,
        lng=-113.095278,
        housenumber="",
        country="USA",
    ),
    "Oxford, Mississippi": SportsballGeocodeTuple(
        city="Oxford",
        state="MS",
        postal="",
        lat=34.372222,
        lng=-89.508056,
        housenumber="",
        country="USA",
    ),
    "Massimino Court, West Palm Beach, Florida": SportsballGeocodeTuple(
        city="West Palm Beach",
        state="FL",
        postal="33409",
        lat=26.7163158,
        lng=-80.1098274,
        housenumber="2300",
        country="USA",
    ),
    "Brookshire Grocery Arena, Bossier City, Louisiana": BROOKSHIRE_GROCERY_ARENA,
    "Roberto Clemente Coliseum, San Juan": SportsballGeocodeTuple(
        city="San Juan",
        state="PR",
        postal="",
        lat=18.4159,
        lng=-66.0754,
        housenumber="",
        country="USA",
    ),
    "Trojan Fieldhouse, Little Rock, Arkansas": SportsballGeocodeTuple(
        city="Little Rock",
        state="AR",
        postal="37210",
        lat=36.1407945,
        lng=-86.7555075,
        housenumber="410",
        country="USA",
    ),
    "George Q. Cannon Activities Center, Laie, Hawaii": SportsballGeocodeTuple(
        city="Laie",
        state="HI",
        postal="96762",
        lat=21.641036,
        lng=-157.9224658,
        housenumber="55",
        country="USA",
    ),
    "The Arena at Northwest Florida State College, Niceville, Florida": SportsballGeocodeTuple(
        city="Niceville",
        state="FL",
        postal="",
        lat=30.5394,
        lng=-86.4756,
        housenumber="",
        country="USA",
    ),
    "South Point Arena, Enterprise, Nevada": SportsballGeocodeTuple(
        city="Enterprise",
        state="NV",
        postal="89183",
        lat=36.011426,
        lng=-115.1753,
        housenumber="9777",
        country="USA",
    ),
    "McGonigle Hall, Philadelphia, Pennsylvania": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="19121",
        lat=39.981029,
        lng=-75.158033,
        housenumber="1800",
        country="USA",
    ),
    "Municipal Auditorium, Columbus, Georgia": SportsballGeocodeTuple(
        city="Columbus",
        state="GA",
        postal="",
        lat=32.5029979,
        lng=-84.9441475,
        housenumber="",
        country="USA",
    ),
    "IUPUI Gymnasium, Indianapolis, Indiana": THE_JUNGLE,
    "Daniel Lynch '38 Gymnasium, Brooklyn, New York": GENEROSO_POPE_ATHELTIC_COMPLEX,
    "TD Bank Sports Center, Hamden, Connecticut": TD_BANK_SPORTS_CENTER,
    "University of Tasmania Stadium, Launceston, Austrália": UTAS_STADIUM,
    "Optus Stadium, Perth, Austrália": OPTUS_STADIUM,
    "San Francisco, California": SAN_FRANCISCO,
    "Villanova, Pennsylvania": SportsballGeocodeTuple(
        city="Villanova",
        state="PA",
        postal="",
        lat=40.037222,
        lng=-75.349167,
        housenumber="",
        country="USA",
    ),
    "Normal, Illinois": SportsballGeocodeTuple(
        city="Normal",
        state="IL",
        postal="",
        lat=40.512222,
        lng=-88.988611,
        housenumber="",
        country="USA",
    ),
    "Troy, Alabama": SportsballGeocodeTuple(
        city="Troy",
        state="AL",
        postal="",
        lat=31.808889,
        lng=-85.97,
        housenumber="",
        country="USA",
    ),
    "Fargo, North Dakota": SportsballGeocodeTuple(
        city="Fargo",
        state="ND",
        postal="",
        lat=46.873333,
        lng=-96.827222,
        housenumber="",
        country="USA",
    ),
    "Savannah Civic Center, Savannah, Georgia": SportsballGeocodeTuple(
        city="Savannah",
        state="GA",
        postal="31401",
        lat=32.0769645,
        lng=-81.0995252,
        housenumber="301",
        country="USA",
    ),
    "Barossa Park, Lyndoch, Australia": BAROSSA_PARK,
    "Peoria, Illinois": PEORIA,
    "Lenovo Center, Raleigh, North Carolina": LENOVO_CENTER,
    "Durham, North Carolina": SportsballGeocodeTuple(
        city="Durham",
        state="NC",
        postal="",
        lat=35.978611,
        lng=-78.9,
        housenumber="",
        country="USA",
    ),
    "South Orange, New Jersey": SportsballGeocodeTuple(
        city="South Orange",
        state="NJ",
        postal="",
        lat=40.748811,
        lng=-74.261512,
        housenumber="",
        country="USA",
    ),
    "Foster Pavilion, Waco, Texas": SportsballGeocodeTuple(
        city="Waco",
        state="TX",
        postal="",
        lat=31.556698,
        lng=-97.121613,
        housenumber="",
        country="USA",
    ),
    "Santa Clara, California": SportsballGeocodeTuple(
        city="Santa Clara",
        state="CA",
        postal="",
        lat=37.354444,
        lng=-121.969167,
        housenumber="",
        country="USA",
    ),
    "Stanford, California": SportsballGeocodeTuple(
        city="Stanford",
        state="CA",
        postal="",
        lat=37.4225,
        lng=-122.165278,
        housenumber="",
        country="USA",
    ),
    "Intrust Bank Arena, Wichita, Kansas": SportsballGeocodeTuple(
        city="Wichita",
        state="KS",
        postal="",
        lat=37.683056,
        lng=-97.331389,
        housenumber="500",
        country="USA",
    ),
    "Chattanooga, Tennessee": CHATTANOOGA,
    "Norfolk, Virginia": NORFOLK,
    "Des Moines, Iowa": SportsballGeocodeTuple(
        city="Des Moines",
        state="IA",
        postal="",
        lat=41.590833,
        lng=-93.620833,
        housenumber="",
        country="USA",
    ),
    "Conway, South Carolina": SportsballGeocodeTuple(
        city="Conway",
        state="SC",
        postal="",
        lat=33.838056,
        lng=-79.056111,
        housenumber="",
        country="USA",
    ),
    "Macomb, Illinois": SportsballGeocodeTuple(
        city="Macomb",
        state="IL",
        postal="",
        lat=40.470833,
        lng=-90.680833,
        housenumber="",
        country="USA",
    ),
    "Stockton, California": STOCKTON,
    "Jonesboro, Arkansas": SportsballGeocodeTuple(
        city="Jonesboro",
        state="AR",
        postal="",
        lat=35.811111,
        lng=-90.696944,
        housenumber="",
        country="USA",
    ),
    "Alcorn State, Mississippi": SportsballGeocodeTuple(
        city="Alcorn State",
        state="MI",
        postal="",
        lat=31.8769,
        lng=-91.1411,
        housenumber="",
        country="USA",
    ),
    "Evanston, Illinois": SportsballGeocodeTuple(
        city="Evanston",
        state="IL",
        postal="",
        lat=42.046389,
        lng=-87.694722,
        housenumber="",
        country="USA",
    ),
    "Missoula, Montana": SportsballGeocodeTuple(
        city="Missoula",
        state="MT",
        postal="",
        lat=46.892778,
        lng=-114.021667,
        housenumber="",
        country="USA",
    ),
    "Cheney, Washington": SportsballGeocodeTuple(
        city="Cheney",
        state="WA",
        postal="",
        lat=47.488611,
        lng=-117.578611,
        housenumber="",
        country="USA",
    ),
    "Jacksonville, Florida": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="",
        lat=30.336944,
        lng=-81.661389,
        housenumber="",
        country="USA",
    ),
    "Nacogdoches, Texas": NACOGDOCHES,
    "Commerce, Texas": SportsballGeocodeTuple(
        city="Commerce",
        state="TX",
        postal="",
        lat=33.245,
        lng=-95.894444,
        housenumber="",
        country="USA",
    ),
    "Beaumont, Texas": SportsballGeocodeTuple(
        city="Beaumont",
        state="TX",
        postal="",
        lat=30.08,
        lng=-94.126667,
        housenumber="",
        country="USA",
    ),
    "Greeley, Colorado": SportsballGeocodeTuple(
        city="Greeley",
        state="CO",
        postal="",
        lat=40.423333,
        lng=-104.709167,
        housenumber="",
        country="USA",
    ),
    "Ogden, Utah": SportsballGeocodeTuple(
        city="Ogden",
        state="UT",
        postal="",
        lat=41.227778,
        lng=-111.968333,
        housenumber="",
        country="USA",
    ),
    "University Park, Pennsylvania": SportsballGeocodeTuple(
        city="University Park",
        state="PA",
        postal="",
        lat=40.806667,
        lng=-77.880278,
        housenumber="",
        country="USA",
    ),
    "Barossa Park": BAROSSA_PARK,
    "Moraga, California": SportsballGeocodeTuple(
        city="Moraga",
        state="CA",
        postal="",
        lat=37.835,
        lng=-122.129722,
        housenumber="",
        country="USA",
    ),
    "Hammond, Louisiana": SportsballGeocodeTuple(
        city="Hammond",
        state="LA",
        postal="",
        lat=30.5025,
        lng=-90.475,
        housenumber="",
        country="USA",
    ),
    "Macon, Georgia": SportsballGeocodeTuple(
        city="Macon",
        state="GA",
        postal="",
        lat=32.834722,
        lng=-83.651667,
        housenumber="",
        country="USA",
    ),
    "Radford, Virginia": SportsballGeocodeTuple(
        city="Radford",
        state="VA",
        postal="",
        lat=37.1275,
        lng=-80.569444,
        housenumber="",
        country="USA",
    ),
    "Spartanburg, South Carolina": SportsballGeocodeTuple(
        city="Spartanburg",
        state="SC",
        postal="",
        lat=34.946667,
        lng=-81.9275,
        housenumber="",
        country="USA",
    ),
    "Rock Hill, South Carolina": ROCK_HILL,
    "Montgomery, Alabama": MONTGOMERY,
    "Elma Roane Fieldhouse, Memphis, Tennessee": SportsballGeocodeTuple(
        city="Memphis",
        state="TN",
        postal="38152",
        lat=35.118369,
        lng=-89.935675,
        housenumber="495",
        country="USA",
    ),
    "Murray, Kentucky": SportsballGeocodeTuple(
        city="Murray",
        state="KY",
        postal="",
        lat=36.609444,
        lng=-88.315556,
        housenumber="",
        country="USA",
    ),
    "Grand Forks, North Dakota": SportsballGeocodeTuple(
        city="Grand Forks",
        state="ND",
        postal="",
        lat=47.921264,
        lng=-97.088339,
        housenumber="",
        country="USA",
    ),
    "Cookeville, Tennessee": SportsballGeocodeTuple(
        city="Cookeville",
        state="TN",
        postal="",
        lat=36.164167,
        lng=-85.504167,
        housenumber="",
        country="USA",
    ),
    "Malibu, California": SportsballGeocodeTuple(
        city="Malibu",
        state="CA",
        postal="",
        lat=34.035,
        lng=-118.695,
        housenumber="",
        country="USA",
    ),
    "Boiling Springs, North Carolina": SportsballGeocodeTuple(
        city="Boiling Springs",
        state="NC",
        postal="",
        lat=35.251944,
        lng=-81.663611,
        housenumber="",
        country="USA",
    ),
    "Lexington, Virginia": SportsballGeocodeTuple(
        city="Lexington",
        state="VA",
        postal="",
        lat=37.783889,
        lng=-79.442778,
        housenumber="",
        country="USA",
    ),
    "Buccaneer Fieldhouse, Charleston, South Carolina": BUCCANEER_FIELDHOUSE,
    "Charleston, Illinois": SportsballGeocodeTuple(
        city="Charleston",
        state="IL",
        postal="",
        lat=39.484167,
        lng=-88.178056,
        housenumber="",
        country="USA",
    ),
    "Worcester, Massachusetts": SportsballGeocodeTuple(
        city="Worcester",
        state="MA",
        postal="",
        lat=42.271389,
        lng=-71.798889,
        housenumber="",
        country="USA",
    ),
    "Joan Perry Brock Center, Farmville, Virginia": SportsballGeocodeTuple(
        city="Farmville",
        state="VA",
        postal="",
        lat=37.298333,
        lng=-78.395556,
        housenumber="405",
        country="USA",
    ),
    "Princess Anne, Maryland": SportsballGeocodeTuple(
        city="Princess Anne",
        state="MD",
        postal="",
        lat=38.209722,
        lng=-75.695,
        housenumber="",
        country="USA",
    ),
    "The Sandy and John Black Pavilion at Ole Miss, University, Mississippi": OLE_MISS,
    "Joel and Diane Bloom Wellness and Events Center, Newark, New Jersey": WELLNESS_AND_EVENTS_CENTER,
    "Asheville, North Carolina": SportsballGeocodeTuple(
        city="Asheville",
        state="NC",
        postal="",
        lat=35.595556,
        lng=-82.551944,
        housenumber="",
        country="USA",
    ),
    "Clinton, South Carolina": SportsballGeocodeTuple(
        city="Clinton",
        state="SC",
        postal="",
        lat=34.471389,
        lng=-81.875,
        housenumber="",
        country="USA",
    ),
    "Edwardsville, Illinois": SportsballGeocodeTuple(
        city="Edwardsville",
        state="IL",
        postal="",
        lat=38.803889,
        lng=-89.958333,
        housenumber="",
        country="USA",
    ),
    "DeLand, Florida": SportsballGeocodeTuple(
        city="DeLand",
        state="FL",
        postal="",
        lat=29.0225,
        lng=-81.286389,
        housenumber="",
        country="USA",
    ),
    "Martin, Tennessee": SportsballGeocodeTuple(
        city="Martin",
        state="TN",
        postal="",
        lat=36.341944,
        lng=-88.851667,
        housenumber="",
        country="USA",
    ),
    "The Coliseum, Carrollton, Georgia": SportsballGeocodeTuple(
        city="Carrollton",
        state="GA",
        postal="",
        lat=33.5761,
        lng=-85.1039,
        housenumber="",
        country="USA",
    ),
    "Williamsburg, Virginia": SportsballGeocodeTuple(
        city="Williamsburg",
        state="VA",
        postal="",
        lat=37.270833,
        lng=-76.706944,
        housenumber="",
        country="USA",
    ),
    "Cedar Falls, Iowa": CEDAR_FALLS,
    "Towson, Maryland": SportsballGeocodeTuple(
        city="Towson",
        state="MD",
        postal="",
        lat=39.393056,
        lng=-76.609444,
        housenumber="",
        country="USA",
    ),
    "Vermillon, South Dakota": SportsballGeocodeTuple(
        city="Vermillon",
        state="SD",
        postal="",
        lat=42.781389,
        lng=-96.925278,
        housenumber="",
        country="USA",
    ),
    "Francis A. Levien Gymnasium, New York, New York": LEVIEN_GYM,
    "Tampa, Florida": TAMPA,
    "Berkeley, California": BERKELEY,
    "Barossa Oval - Australia": BAROSSA_PARK,
    "Civic Arena, Pittsburgh, Pennsylvania": CIVIC_ARENA,
    "Verizon Arena, North Little Rock, Arkansas": SIMMONS_BANK_ARENA,
    "BB&T Center, Sunrise, Florida": AMERANT_BANK_ARENA,
    "BOK Center, Tulsa, Oklahoma": BOK_CENTER,
    "Alamodome, San Antonio, TX, USA": ALAMODOME,
    "KeyArena, Seattle, Washington": CLIMATE_PLEDGE_ARENA,
    "Naples, Florida": SportsballGeocodeTuple(
        city="Naples",
        state="FL",
        postal="",
        lat=26.136111,
        lng=-81.794444,
        housenumber="",
        country="USA",
    ),
    "Henrico Sports & Events Center, Henrico, Virginia": SportsballGeocodeTuple(
        city="Henrico",
        state="VA",
        postal="23059",
        lat=37.6771948,
        lng=-77.4528141,
        housenumber="1",
        country="USA",
    ),
    "College Park, Georgia": SportsballGeocodeTuple(
        city="College Park",
        state="GA",
        postal="",
        lat=33.6175,
        lng=-84.4675,
        housenumber="",
        country="USA",
    ),
    "Ralston, Nebraska": SportsballGeocodeTuple(
        city="Ralston",
        state="NE",
        postal="",
        lat=41.200556,
        lng=-96.035556,
        housenumber="",
        country="USA",
    ),
    "Bill Greehey Arena, San Antonio, Texas": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="78228",
        lat=29.451858,
        lng=-98.5643022,
        housenumber="1",
        country="USA",
    ),
    "Hartsell Arena, Pensacola, Florida": SportsballGeocodeTuple(
        city="Pensacola",
        state="FL",
        postal="32504",
        lat=30.4793276,
        lng=-87.1995723,
        housenumber="",
        country="USA",
    ),
    "Kerr Fitness Center, Pittsburgh, Pennsylvania": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="15237",
        lat=40.5691309,
        lng=-80.01166,
        housenumber="9000",
        country="USA",
    ),
    "Titan Field House, Melbourne, Florida": SportsballGeocodeTuple(
        city="Melbourne",
        state="FL",
        postal="3865",
        lat=28.16992,
        lng=-80.66588,
        housenumber="32935",
        country="USA",
    ),
    "H&HP Complex, Lake Charles, Louisiana": LEGACY_CENTER,
    "Bill Harris Arena, Birmingham, Alabama": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="35208",
        lat=33.495,
        lng=-86.874,
        housenumber="2331",
        country="USA",
    ),
    "Rochester, New York": ROCHESTER,
    "North Little Rock, Arkansas": SportsballGeocodeTuple(
        city="North Little Rock",
        state="AR",
        postal="",
        lat=34.780833,
        lng=-92.256944,
        housenumber="",
        country="USA",
    ),
    "Taco Bell Arena, Boise, Idaho": EXTRAMILE_ARENA,
    "Kent, Washington": SportsballGeocodeTuple(
        city="Kent",
        state="WA",
        postal="",
        lat=47.382778,
        lng=-122.226944,
        housenumber="",
        country="USA",
    ),
    "Magness Arena, Denver, Colorado": SportsballGeocodeTuple(
        city="Denver",
        state="CO",
        postal="",
        lat=39.682106,
        lng=-104.961592,
        housenumber="2240",
        country="USA",
    ),
    "ESPN Wide World of Sports, Orlando, Florida": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Scotiabank Arena, Toronto": SCOTIABANK_ARENA,
    "Chaparral Center, Midland, Texas": SportsballGeocodeTuple(
        city="Midland",
        state="TX",
        postal="",
        lat=32.028,
        lng=-102.103,
        housenumber="2240",
        country="USA",
    ),
    "U.S. Bank Stadium, Minneapolis, Minnesota": US_BANK_STADIUM,
    "Honda Center, Anaheim, California": SportsballGeocodeTuple(
        city="Anaheim",
        state="CA",
        postal="",
        lat=33.807778,
        lng=-117.876667,
        housenumber="2695",
        country="USA",
    ),
    "NJIT Wellness and Events Center, Newark, New Jersey": WELLNESS_AND_EVENTS_CENTER,
    "McGrath-Phillips Arena, Chicago, Illinois": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="60604",
        lat=41.923901,
        lng=-87.653167,
        housenumber="2323",
        country="USA",
    ),
    "Nationwide Arena, Columbus, Ohio": NATIONWIDE_ARENA,
    "Jacksonville Veteran's Memorial Arena, Jacksonville, Florida": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="32202",
        lat=30.325769,
        lng=-81.645069,
        housenumber="300",
        country="USA",
    ),
    "James T. Valvano Arena, Raleigh, North Carolina": REYNOLDS_COLISEUM,
    "North Charleston Coliseum, Charleston, South Carolina": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="29418",
        lat=32.8656,
        lng=-80.0224,
        housenumber="5001",
        country="USA",
    ),
    "Fiserv Forum,": FISERV_FORUM,
    "First Horizon Coliseum, Greensboro, North Carolina": SportsballGeocodeTuple(
        city="Greensboro",
        state="NC",
        postal="",
        lat=36.0596,
        lng=-79.8257,
        housenumber="1921",
        country="USA",
    ),
    "North Athletic Complex, Pittsburgh, Pennsylvania": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.519083,
        lng=-80.212405,
        housenumber="",
        country="USA",
    ),
    "Georgetown, Kentucky": SportsballGeocodeTuple(
        city="Georgetown",
        state="KY",
        postal="",
        lat=38.209722,
        lng=-84.56,
        housenumber="",
        country="USA",
    ),
    "Gold Dome, Shreveport, Louisiana": SportsballGeocodeTuple(
        city="Shreveport",
        state="LA",
        postal="71134",
        lat=32.480921,
        lng=-93.729818,
        housenumber="2911",
        country="USA",
    ),
    "American Airlines Arena, Miami, Florida": KASEYA_CENTER,
    "Vancouver Convention Centre,": VANCOUVER_CONVENTION_CENTER,
    "Vancouver Convention Centre, Vancouver": VANCOUVER_CONVENTION_CENTER,
    "Kendal Isaacs Gymnasium, Nassau": KENDALL_ISAACS_GYMNASIUM,
    "Kendal Isaacs Gymnasium, Nassau, The Bahamas": KENDALL_ISAACS_GYMNASIUM,
    "Otter Sports Center, Marina, California": SportsballGeocodeTuple(
        city="Marina",
        state="CA",
        postal="93933",
        lat=36.6544526,
        lng=-121.8081741,
        housenumber="2050",
        country="USA",
    ),
    "SimpliFi Arena at Stan Sheriff Center, Honolulu, Hawaii": SportsballGeocodeTuple(
        city="Marina",
        state="CA",
        postal="93933",
        lat=36.6544526,
        lng=-121.8081741,
        housenumber="2050",
        country="USA",
    ),
    "ShoWare Center, Kent, Washington": SportsballGeocodeTuple(
        city="Kent",
        state="WA",
        postal="",
        lat=47.388333,
        lng=-122.24,
        housenumber="625",
        country="USA",
    ),
    "Schar Center,": SCHAR_CENTER,
    "Fort Bliss, El Paso, Texas": SportsballGeocodeTuple(
        city="El Paso",
        state="TX",
        postal="",
        lat=31.801847,
        lng=-106.424608,
        housenumber="",
        country="USA",
    ),
    "Huntington, West Virginia": HUNTINGTON,
    "St. John Arena, Columbus, Ohio": SportsballGeocodeTuple(
        city="Columbus",
        state="OH",
        postal="43210",
        lat=40.005278,
        lng=-83.018889,
        housenumber="410",
        country="USA",
    ),
    "Delmar-Tusa Fieldhouse, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="77092",
        lat=29.802778,
        lng=-95.456944,
        housenumber="2020",
        country="USA",
    ),
    "Reno Events Center, Reno, Nevada": SportsballGeocodeTuple(
        city="Reno",
        state="NV",
        postal="",
        lat=39.5309,
        lng=-119.8125,
        housenumber="400",
        country="USA",
    ),
    "E.J. Wade Arena at Stuart C. Siegel Center, Richmond, Virginia": STUART_SIEGEL_CENTER,
    "Allstate Arena, Rosemont, Illinois": SportsballGeocodeTuple(
        city="Rosemont",
        state="IL",
        postal="",
        lat=42.005278,
        lng=-87.887778,
        housenumber="400",
        country="USA",
    ),
    "KeyArena at Seattle Center , Seattle, Washington": CLIMATE_PLEDGE_ARENA,
    "Municipal Auditorium, Kansas City, Missouri": SportsballGeocodeTuple(
        city="Kansas City",
        state="MO",
        postal="",
        lat=39.098353,
        lng=-94.586416,
        housenumber="301",
        country="USA",
    ),
    "Hattiesburg, Mississippi": SportsballGeocodeTuple(
        city="Hattiesburg",
        state="MS",
        postal="",
        lat=31.315833,
        lng=-89.308611,
        housenumber="",
        country="USA",
    ),
    "Hampton University Convocation Center, Hampton, Virginia": HAMPTON_CONVOCATION_CENTER,
    "Alumni Gym, Elon, North Carolina": SportsballGeocodeTuple(
        city="Elon",
        state="NC",
        postal="",
        lat=36.109018,
        lng=-79.506705,
        housenumber="",
        country="USA",
    ),
    "Jack and Ruth Ann Hill Convocation Center, Statesboro, Georgia": SportsballGeocodeTuple(
        city="Statesboro",
        state="GA",
        postal="30458",
        lat=32.40625,
        lng=-81.783056,
        housenumber="284",
        country="USA",
    ),
    "CONSOL Enegery Center, Pittsburgh, Pennsylvania": PPG_PAINTS_ARENA,
    "Chase Center - San Francisco, California, USA - United States": CHASE_CENTER,
    "San Marcos, Texas": SportsballGeocodeTuple(
        city="San Marcos",
        state="TX",
        postal="",
        lat=29.879444,
        lng=-97.938889,
        housenumber="",
        country="USA",
    ),
    "Retriever Activities Center, Baltimore, Maryland": RETRIEVER_ACTIVITIES_CENTER,
    "Memorial Coliseum, Portland, Oregon": MEMORIAL_COLISEUM,
    "Charles L. Sewall Center, Coraopolis, Pennsylvania": SportsballGeocodeTuple(
        city="Coraopolis",
        state="PA",
        postal="",
        lat=40.520212,
        lng=-80.21476,
        housenumber="",
        country="USA",
    ),
    "The Pavilion, Villanova, Pennsylvania": FINNERAN_PAVILION,
    "Scheels Arena, Fargo, North Dakota": SCHEELS_ARENA,
    "DakotaDome , Vermillion, South Dakota": SportsballGeocodeTuple(
        city="Vermillion",
        state="SD",
        postal="",
        lat=42.791111,
        lng=-96.927778,
        housenumber="1101",
        country="USA",
    ),
    "Benjamin Johnson Arena, Spartanburg, South Carolina": SportsballGeocodeTuple(
        city="Spartanburg",
        state="SC",
        postal="",
        lat=34.960278,
        lng=-81.932778,
        housenumber="",
        country="USA",
    ),
    "Hartford, Connecticut": SportsballGeocodeTuple(
        city="Hartford",
        state="CT",
        postal="",
        lat=41.7625,
        lng=-72.674167,
        housenumber="",
        country="USA",
    ),
    "Quest MultiSport, Chicago, Illinois": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="60612",
        lat=41.8733479,
        lng=-87.6923655,
        housenumber="2641",
        country="USA",
    ),
    "ICI Center (Embry-Riddle), Daytona Beach, Florida": SportsballGeocodeTuple(
        city="Daytona Beach",
        state="FL",
        postal="32114",
        lat=29.1886,
        lng=-81.0487,
        housenumber="1",
        country="USA",
    ),
    "South Point Arena, Las Vegas, Nevada": SportsballGeocodeTuple(
        city="Las Vegas",
        state="NV",
        postal="89183",
        lat=36.0112358,
        lng=-115.1752286,
        housenumber="9777",
        country="USA",
    ),
    "Abrams Physical Fitness Center, Fort Hood, Texas": SportsballGeocodeTuple(
        city="Fort Hood",
        state="TX",
        postal="76544",
        lat=31.1382238,
        lng=-97.7772131,
        housenumber="",
        country="USA",
    ),
    "CenturyLink Center (LA), Bossier City, Louisiana": BROOKSHIRE_GROCERY_ARENA,
    "Dothan Civic Center, Dothan, Alabama": SportsballGeocodeTuple(
        city="Dothan",
        state="AL",
        postal="",
        lat=31.224722,
        lng=-85.39,
        housenumber="",
        country="USA",
    ),
    "Stockton Arena, Stockton, California": SportsballGeocodeTuple(
        city="Stockton",
        state="CA",
        postal="95203",
        lat=37.9561651,
        lng=-121.2960735,
        housenumber="248",
        country="USA",
    ),
    "Le Moyne Events Center, Syracuse, New York": SportsballGeocodeTuple(
        city="Syracuse",
        state="NY",
        postal="13214",
        lat=43.0502,
        lng=-76.0848,
        housenumber="500",
        country="USA",
    ),
    "Bloch Arena, Honolulu, Hawaii": SportsballGeocodeTuple(
        city="Honolulu",
        state="HI",
        postal="96818",
        lat=21.3477415,
        lng=-157.9412764,
        housenumber="224",
        country="USA",
    ),
    "Charleston Civic Center, Charleston, West Virginia": CHARLESTON_CIVIC_CENTER,
    "Kezar Pavillion, San Francisco, California": KEZAR_STADIUM,
    "H.E.B. Center at Cedar Park, Cedar Park, Texas": SportsballGeocodeTuple(
        city="Cedar Park",
        state="TX",
        postal="",
        lat=30.5414,
        lng=-97.8202,
        housenumber="2100",
        country="USA",
    ),
    "Tom Golisano Field House, Ave Maria, Florida": SportsballGeocodeTuple(
        city="Ave Maria",
        state="FL",
        postal="34142",
        lat=26.3396049,
        lng=-81.4410362,
        housenumber="4810",
        country="USA",
    ),
    "Tuba City HS Gym, Tuba City, Arizona": SportsballGeocodeTuple(
        city="Tuba City",
        state="AZ",
        postal="86045",
        lat=36.126661,
        lng=-111.223479,
        housenumber="",
        country="USA",
    ),
    "Lakeland Center, Lakeland, Florida": SportsballGeocodeTuple(
        city="Lakeland",
        state="FL",
        postal="33815",
        lat=28.041053,
        lng=-81.963619,
        housenumber="701",
        country="USA",
    ),
    "'Iolani School Gym, Honolulu, Hawaii": SportsballGeocodeTuple(
        city="Honolulu",
        state="HI",
        postal="96826",
        lat=21.2865,
        lng=-157.824567,
        housenumber="563",
        country="USA",
    ),
    "Mercyhurst Athletic Center, Erie, Pennsylvania": SportsballGeocodeTuple(
        city="Erie",
        state="PA",
        postal="",
        lat=42.1046,
        lng=-80.0556,
        housenumber="",
        country="USA",
    ),
    "Monroe, Louisiana": MONROE,
    "Bison Sports Arena, Fargo, North Dakota": SCHEELS_ARENA,
    "F&M Bank Arena, Clarksville, Tennessee": SportsballGeocodeTuple(
        city="Clarksville",
        state="TN",
        postal="",
        lat=36.529444,
        lng=-87.359722,
        housenumber="101",
        country="USA",
    ),
    "C.M. Tad Smith Coliseum, University, Mississippi": SportsballGeocodeTuple(
        city="University",
        state="MS",
        postal="38677",
        lat=34.362197,
        lng=-89.539303,
        housenumber="",
        country="USA",
    ),
    "Verties Sails Gymnasium, Memphis, Tennessee": SportsballGeocodeTuple(
        city="Memphis",
        state="TN",
        postal="38107",
        lat=35.1565496,
        lng=-89.9896643,
        housenumber="",
        country="USA",
    ),
    "Thibodaux, Louisiana": SportsballGeocodeTuple(
        city="Thibodaux",
        state="LA",
        postal="",
        lat=29.792222,
        lng=-90.82,
        housenumber="",
        country="USA",
    ),
    "New Orleans , Louisiana": NEW_ORLEANS_CITY,
    "First Bank & Trust Arena, Brookings, South Dakota": SportsballGeocodeTuple(
        city="Brookings",
        state="SD",
        postal="57007",
        lat=44.317984,
        lng=-96.779058,
        housenumber="1165",
        country="USA",
    ),
    "Cambria County War Memorial Arena, Johnstown, Pennsylvania": SportsballGeocodeTuple(
        city="Johnstown",
        state="PA",
        postal="15901",
        lat=40.32296,
        lng=-78.922654,
        housenumber="326",
        country="USA",
    ),
    "Petco Park, San Diego, California": PETCO_PARK,
    "Esby Gym, Glassboro, New Jersey": SportsballGeocodeTuple(
        city="Glassboro",
        state="NJ",
        postal="08028",
        lat=39.7106001,
        lng=-75.1186627,
        housenumber="300",
        country="USA",
    ),
    "Boone, North Carolina": SportsballGeocodeTuple(
        city="Boone",
        state="NC",
        postal="",
        lat=36.211111,
        lng=-81.666944,
        housenumber="",
        country="USA",
    ),
    "FedExForum - Memphis, Tennessee - United States": FEDEX_FORUM,
    "Kia Center, Orlando, FL, EUA": KIA_CENTER,
    "Davis Field House, Greenville, South Carolina": SportsballGeocodeTuple(
        city="Greenville",
        state="SC",
        postal="",
        lat=34.8725,
        lng=-82.361944,
        housenumber="",
        country="USA",
    ),
    "Rimrock Auto Arena at MetraPark, Billings, Montana": SportsballGeocodeTuple(
        city="Billings",
        state="MT",
        postal="59101",
        lat=45.800103,
        lng=-108.477201,
        housenumber="308",
        country="USA",
    ),
    "Corvallis, Oregon": SportsballGeocodeTuple(
        city="Corvallis",
        state="OR",
        postal="",
        lat=44.569722,
        lng=-123.278333,
        housenumber="",
        country="USA",
    ),
    "Mabee Center, Liberty, Missouri": SportsballGeocodeTuple(
        city="Liberty",
        state="MO",
        postal="64068",
        lat=39.24962892,
        lng=-94.4087267,
        housenumber="924",
        country="USA",
    ),
    "Durham, New Hampshire": SportsballGeocodeTuple(
        city="Durham",
        state="NH",
        postal="",
        lat=43.133889,
        lng=-70.926389,
        housenumber="",
        country="USA",
    ),
    "Morehead, Kentucky": SportsballGeocodeTuple(
        city="Morehead",
        state="KY",
        postal="",
        lat=38.190833,
        lng=-83.4475,
        housenumber="",
        country="USA",
    ),
    "Hart Center Arena, Worcester, Massachusetts": HART_RECREATION_CENTER,
    "Regional Special Events Center, Murray, Kentucky": CFSB_CENTER,
    "M&T Bank Arena, Hamden, Connecticut": TD_BANK_SPORTS_CENTER,
    "Cape Girardeau, Missouri": SportsballGeocodeTuple(
        city="Cape Girardeau",
        state="MO",
        postal="",
        lat=37.310833,
        lng=-89.559722,
        housenumber="",
        country="USA",
    ),
    "Memorial Center, Johnson City, Tennessee": SportsballGeocodeTuple(
        city="Johnson City",
        state="TN",
        postal="37601",
        lat=36.3037181,
        lng=-82.3707852,
        housenumber="",
        country="USA",
    ),
    "New Haven, Connecticut": SportsballGeocodeTuple(
        city="New Haven",
        state="CT",
        postal="",
        lat=41.308333,
        lng=-72.925,
        housenumber="",
        country="USA",
    ),
    "Ralston Arena, Ralston, Nebraska": SportsballGeocodeTuple(
        city="Ralston",
        state="NE",
        postal="",
        lat=41.206944,
        lng=-96.026944,
        housenumber="7300",
        country="USA",
    ),
    "Butler Hancock Sports Pavilion, Greeley, Colorado": BANK_OF_COLORADO_ARENA,
    "Avron B. Fogelman Arena, New Orleans, Louisiana": SportsballGeocodeTuple(
        city="New Orleans",
        state="LA",
        postal="70118",
        lat=29.938611,
        lng=-90.120556,
        housenumber="",
        country="USA",
    ),
    "Georgia Dome, Atlanta, Georgia": GEORGIA_DOME,
    "Pritchard Gymnasium, Stony Brook, New York": SportsballGeocodeTuple(
        city="Stony Brook",
        state="NY",
        postal="11790",
        lat=40.917238,
        lng=-73.124638,
        housenumber="",
        country="USA",
    ),
    "Agganis Arena, Boston, Massachusetts": SportsballGeocodeTuple(
        city="Boston",
        state="MA",
        postal="02215",
        lat=42.352231,
        lng=-71.117792,
        housenumber="925",
        country="USA",
    ),
    "Valparaiso, Indiana": SportsballGeocodeTuple(
        city="Valparaisos",
        state="IN",
        postal="",
        lat=41.476111,
        lng=-87.040278,
        housenumber="",
        country="USA",
    ),
    "Asheville Civic Center, Asheville, North Carolina": HARRAHS_CHEROKEE_CENTER,
    "RBC Center, Raleigh, North Carolina": LENOVO_CENTER,
    "1st Mariner Arena, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.288611,
        lng=-76.618889,
        housenumber="201",
        country="USA",
    ),
    "ASU Acadome, Montgomery, Alabama": DUNN_OLIVER_ACADOME,
    "K.L. Johnson HPER Complex, Pine Bluff, Arkansas": SportsballGeocodeTuple(
        city="Pine Bluff",
        state="AR",
        postal="71601",
        lat=34.243825,
        lng=-92.017429,
        housenumber="1401",
        country="USA",
    ),
    "Qwest Center OMAHA, Omaha, Nebraska": CHI_HEALTH_CENTER,
    "Solomon Court at Cabot Center, Boston, Massachusetts": CABOT_CENTER,
    "University, Mississippi": SportsballGeocodeTuple(
        city="University",
        state="MS",
        postal="",
        lat=34.365556,
        lng=-89.537778,
        housenumber="",
        country="USA",
    ),
    "Centrum Arena, Cedar City, Utah": CENTRUM_ARENA,
    "Mount Pleasant, Michigan": SportsballGeocodeTuple(
        city="Mount Pleasant",
        state="MI",
        postal="",
        lat=43.597778,
        lng=-84.7675,
        housenumber="",
        country="USA",
    ),
    "Hampton, Virginia": SportsballGeocodeTuple(
        city="Hampton",
        state="VI",
        postal="",
        lat=37.026389,
        lng=-76.344444,
        housenumber="",
        country="USA",
    ),
    "Albuquerque, New Mexico": SportsballGeocodeTuple(
        city="Albuquerque",
        state="NM",
        postal="",
        lat=35.084444,
        lng=-106.650278,
        housenumber="",
        country="USA",
    ),
    "The Bank of Kentucky Center, Highland Heights, Kentucky": BANK_OF_KENTUCKY_CENTER,
    "Little Rock, Arkansas": LITTLE_ROCK,
    "Bridgeport, Connecticut": SportsballGeocodeTuple(
        city="Bridgeport",
        state="CT",
        postal="",
        lat=41.186389,
        lng=-73.195556,
        housenumber="",
        country="USA",
    ),
    "Consol Energy Center, Pittsburgh, Pennsylvania": PPG_PAINTS_ARENA,
    "Loretto, Pennsylvania": SportsballGeocodeTuple(
        city="Loretto",
        state="PA",
        postal="",
        lat=40.506389,
        lng=-78.636111,
        housenumber="",
        country="USA",
    ),
    "Vermillion, South Dakota": SportsballGeocodeTuple(
        city="Vermillion",
        state="SD",
        postal="",
        lat=42.781389,
        lng=-96.925278,
        housenumber="",
        country="USA",
    ),
    "Ninja Stadium, Bellerive, Australia": BLUNDSTONE_ARENA,
    "Hornets Nest, Sacramento, California": THE_NEST,
    "Patriot Center, Fairfax, Virginia": EAGLEBANK_ARENA,
    "Carolina First Arena, Charleston, South Carolina": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="",
        lat=32.789444,
        lng=-79.929444,
        housenumber="",
        country="USA",
    ),
    "Road Town": SportsballGeocodeTuple(
        city="Road Town",
        state="",
        postal="",
        lat=18.431389,
        lng=-64.623056,
        housenumber="",
        country="British Virgin Islands",
    ),
    "D.J. Sokol Arena, Omaha, Nebraska": SportsballGeocodeTuple(
        city="Omaha",
        state="NE",
        postal="",
        lat=41.266146,
        lng=-95.940471,
        housenumber="",
        country="USA",
    ),
    "Enterprise, Nevada": SportsballGeocodeTuple(
        city="Enterprise",
        state="NV",
        postal="",
        lat=36.031389,
        lng=-115.198056,
        housenumber="",
        country="USA",
    ),
    "Templeton Center, Clinton, South Carolina": ROSS_E_TEMPLETON_CENTER,
    "Tupelo, Mississippi": SportsballGeocodeTuple(
        city="Tupelo",
        state="MS",
        postal="",
        lat=34.259722,
        lng=-88.725833,
        housenumber="",
        country="USA",
    ),
    "HSBC Arena, Buffalo, New York": KEYBANK_CENTER,
    "New UCF Arena, Orlando, Florida": ADDITION_FINANCIAL_ARENA,
    "McKay Events Center, Orem, Utah": UCCU_CENTER,
    "Mobile, Alabama": SportsballGeocodeTuple(
        city="Mobile",
        state="AL",
        postal="",
        lat=30.6675,
        lng=-88.101111,
        housenumber="",
        country="USA",
    ),
    "Assembly Hall, Champaign, Illinois": STATE_FARM_CENTER,
    "Harbor Yard, Bridgeport, Connecticut": HARBOR_YARD,
    "Arena at Harbor Yard, Bridgeport, Connecticut": HARBOR_YARD,
    "Alltel Pavilion at the Stuart C. Siegel Center, Richmond, Virginia": STUART_SIEGEL_CENTER,
    "US Century Bank Arena, Miami, Florida": OCEAN_BANK_CONVOCATION_CENTER,
    "Chase Arena at Reich Family Pavilion, West Hartford, Connecticut": CHASE_FAMILY_ARENA,
    "University Center, Macon, Georgia": SportsballGeocodeTuple(
        city="Macon",
        state="GA",
        postal="",
        lat=32.829167,
        lng=-83.648611,
        housenumber="",
        country="USA",
    ),
    "The Pit/Bob King Court, Albuquerque, New Mexico": THE_PIT,
    "UTPA Fieldhouse, Edinburg, Texas": UTRGV_FIELDHOUSE,
    "Cowboy's Stadium, Arlington, Texas": ATT_STADIUM,
    "Rabobank Arena, Bakersfield, California": SportsballGeocodeTuple(
        city="Bakersfield",
        state="CA",
        postal="",
        lat=35.37208,
        lng=-119.013723,
        housenumber="1001",
        country="USA",
    ),
    "UCR Student Rec Center, Riverside, California": UCR_STUDENT_REC_CENTER,
    "Maurice Stokes Athletic Center, Loretto, Pennsylvania": DEGOL_ARENA,
    "RAC Arena, Baltimore, Maryland": RETRIEVER_ACTIVITIES_CENTER,
    "Alfond Arena, Orono, Maine": SportsballGeocodeTuple(
        city="Orono",
        state="ME",
        postal="04473",
        lat=44.904539,
        lng=-68.673617,
        housenumber="",
        country="USA",
    ),
    "The Milk House, Lake Buena Vista, Florida": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Sullivan Arena, Anchorage, Alaska": SportsballGeocodeTuple(
        city="Anchorage",
        state="AL",
        postal="04473",
        lat=61.205556,
        lng=-149.8725,
        housenumber="1600",
        country="USA",
    ),
    "Rose Arena, Mount Pleasant, Michigan": SportsballGeocodeTuple(
        city="Mount Pleasant",
        state="MI",
        postal="",
        lat=43.580888,
        lng=-84.773941,
        housenumber="",
        country="USA",
    ),
    "Towson Center, Towson, Maryland": SportsballGeocodeTuple(
        city="Towson",
        state="MD",
        postal="21252",
        lat=39.386375,
        lng=-76.616238,
        housenumber="7500",
        country="USA",
    ),
    "Multipurpose Center and Teaching Gym, Tallahassee, Florida": AL_LAWSON_CENTER,
    "Puerto Vallarta International Convention Center, Puerto Vallarta": SportsballGeocodeTuple(
        city="Puerto Vallarta",
        state="",
        postal="",
        lat=20.6799474,
        lng=-105.2334998,
        housenumber="",
        country="Mexico",
    ),
    "Bank of America Arena, Seattle, Washington": SportsballGeocodeTuple(
        city="Seattle",
        state="WA",
        postal="",
        lat=47.652,
        lng=-122.302,
        housenumber="3870",
        country="USA",
    ),
    "Comcast Center, College Park, Maryland": XFINITY_CENTER,
    "Atlantis Resort Arena, Nassau": IMPERIAL_ARENA,
    "United Spirit Arena, Lubbock, Texas": UNITED_SUPERMARKETS_ARENA,
    "Aventura Spa Palace Resort, Riviera Maya": SportsballGeocodeTuple(
        city="Playa del Carmen",
        state="QR",
        postal="77710",
        lat=20.5069801,
        lng=-87.215373,
        housenumber="72",
        country="Mexico",
    ),
    "U.S. Cellular Arena, Milwaukee, Wisconsin": MILWAUKEE_ARENA,
    "Friel Court, Pullman, Washington": BEASLEY_COLISEUM,
    "Lafayette, Louisiana": SportsballGeocodeTuple(
        city="Lafayette",
        state="LA",
        postal="",
        lat=30.208056,
        lng=-92.0325,
        housenumber="",
        country="USA",
    ),
    "Corbin J. Robertson Center, Georgetown, Texas": SportsballGeocodeTuple(
        city="Georgetown",
        state="TX",
        postal="78626",
        lat=30.6361364,
        lng=-97.6633265,
        housenumber="930",
        country="USA",
    ),
    "Daniel-Meyer Coliseum, Fort Worth, Texas": SCHOLLMAIER_ARENA,
    "Statesboro, Georgia": SportsballGeocodeTuple(
        city="Statesboro",
        state="GA",
        postal="",
        lat=32.445278,
        lng=-81.779167,
        housenumber="",
        country="USA",
    ),
    "Times Warner Cable Arena, Charlotte, North Carolina": SPECTRUM_CENTRE,
    "UHY Center, Loudonville, New York": SportsballGeocodeTuple(
        city="Loudonville",
        state="NY",
        postal="12211",
        lat=42.7174,
        lng=-73.7487,
        housenumber="515",
        country="USA",
    ),
    "Frank L. Forbes Arena, Atlanta, Georgia": SportsballGeocodeTuple(
        city="Atlanta",
        state="GA",
        postal="",
        lat=33.748471,
        lng=-84.417106,
        housenumber="",
        country="USA",
    ),
    "Earl C. Sams Gymnasium, San Antonio, Texas": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="78212",
        lat=29.4618769,
        lng=-98.4859131,
        housenumber="1",
        country="USA",
    ),
    "Mullaney Gymnasium, Providence, Rhode Island": ALUMNI_HALL,
    "Camp Humphreys, Anjeong-ri": SportsballGeocodeTuple(
        city="Anjeong-ri",
        state="",
        postal="",
        lat=36.9684272,
        lng=126.9811043,
        housenumber="",
        country="South Korea",
    ),
    "Curtis Culwell Center, Garland, Texas": SportsballGeocodeTuple(
        city="Garland",
        state="TX",
        postal="",
        lat=32.95956,
        lng=-96.64191,
        housenumber="4999",
        country="USA",
    ),
    "Summit Arena, Hot Springs, Arkansas": SportsballGeocodeTuple(
        city="Hot Springs",
        state="AR",
        postal="",
        lat=34.509722,
        lng=-93.049167,
        housenumber="398",
        country="USA",
    ),
    "Sioux Falls Arena, Sioux Falls, South Dakota": SportsballGeocodeTuple(
        city="Sioux Falls",
        state="SD",
        postal="57104",
        lat=43.562081,
        lng=-96.749333,
        housenumber="1201",
        country="USA",
    ),
    "Bob Devaney Sports Center, Lincoln, Nebraska": SportsballGeocodeTuple(
        city="Lincoln",
        state="NE",
        postal="",
        lat=40.830207,
        lng=-96.697644,
        housenumber="1600",
        country="USA",
    ),
    "HPER Complex, Grambling, Louisiana": FREDRICK_C_HOBDY_ASSEMBLY_CENTER,
    "Jamaica, New York": JAMAICA,
    "Waco, Texas": WACO,
    "Rebecca D. Lockhart Arena, Orem, Utah": SportsballGeocodeTuple(
        city="Orem",
        state="UT",
        postal="84058",
        lat=40.2787192,
        lng=-111.7155783,
        housenumber="785",
        country="USA",
    ),
    "Reliant Stadium, Houston, Texas": NRG_STADIUM,
    "South Padre Island Convention Centre, South Padre Island, Texas": SportsballGeocodeTuple(
        city="South Padre Island",
        state="TX",
        postal="78597",
        lat=26.140556,
        lng=-97.175,
        housenumber="7355",
        country="USA",
    ),
    "Moon Palace Resort, Cancun": SportsballGeocodeTuple(
        city="Cancun",
        state="QR",
        postal="77500",
        lat=20.9886511,
        lng=-86.826701,
        housenumber="340",
        country="Mexico",
    ),
    "Meeks Family Fieldhouse at Carson Center, Evansville, Indiana": SportsballGeocodeTuple(
        city="Evansville",
        state="IN",
        postal="",
        lat=37.9963496,
        lng=-87.6993641,
        housenumber="",
        country="USA",
    ),
    "José Miguel Agrelot Coliseum, San Juan": JOSE_MIGUEL_AGRELOT_COLISEUM,
    "USB Sports Complex, Stony Brook, New York": SportsballGeocodeTuple(
        city="Stony Brook",
        state="NY",
        postal="11790",
        lat=40.917417,
        lng=-73.124722,
        housenumber="100",
        country="USA",
    ),
    "L. A. Sports Arena, Los Angeles, California": LOS_ANGELES_MEMORIAL_COLESIUM,
    "Kimbel Arena, Conway, South Carolina": SportsballGeocodeTuple(
        city="Conway",
        state="SC",
        postal="",
        lat=33.79382,
        lng=-79.013243,
        housenumber="",
        country="USA",
    ),
    "Sapp Fieldhouse, Ralston, Nebraska": SportsballGeocodeTuple(
        city="Ralston",
        state="NE",
        postal="68132",
        lat=41.2574,
        lng=-96.00922,
        housenumber="6311",
        country="USA",
    ),
    "Texas Hall, Arlington, Texas": SportsballGeocodeTuple(
        city="Arlington",
        state="TX",
        postal="76010",
        lat=32.7297,
        lng=-97.1154,
        housenumber="701",
        country="USA",
    ),
    "Grand Exhibition Hall at Harrah's Cherokee Casino, Cherokee, North Carolina": HARRAHS_CHEROKEE_CENTER,
    "The Arena at Gwinnett Center, Duluth, Georgia": SportsballGeocodeTuple(
        city="Duluth",
        state="GA",
        postal="",
        lat=33.991389,
        lng=-84.094167,
        housenumber="6400",
        country="USA",
    ),
    "Birmingham-Jefferson Civic Center, Birmingham, Alabama": BIRMINGHAM_JEFFERSON_CIVIC_CENTER,
    "War Memorial Gymnasium, Maui, Hawaii": SportsballGeocodeTuple(
        city="Maui",
        state="HI",
        postal="96793",
        lat=20.8919129,
        lng=-156.4902234,
        housenumber="700",
        country="USA",
    ),
    "BankAtlantic Center, Sunrise, Florida": AMERANT_BANK_ARENA,
    "University of Tampa Sports Arena, Tampa, Florida": SportsballGeocodeTuple(
        city="Tampa",
        state="FL",
        postal="",
        lat=27.946944,
        lng=-82.468889,
        housenumber="",
        country="USA",
    ),
    "Sears Centre , Hoffman Estates, Illinois": SportsballGeocodeTuple(
        city="Hoffman Estates",
        state="IL",
        postal="",
        lat=42.071694,
        lng=-88.209456,
        housenumber="5333",
        country="USA",
    ),
    "Nassau": SportsballGeocodeTuple(
        city="Nassau",
        state="",
        postal="",
        lat=25.044167,
        lng=-77.350278,
        housenumber="",
        country="Bahamas",
    ),
    "Qwest Arena, Boise, Idaho": IDAHO_CENTRAL_ARENA,
    "Coliseo Juan AubÃ­n Cruz Abreu, ManatÃ­": COLISEO_JUAN_AUBIN_CRUZ_ABREU,
    "St. Pete Times Forum, Tampa, Florida": AMALIE_ARENA,
    "Alltel Arena, North Little Rock, Arkansas": SIMMONS_BANK_ARENA,
    "Mohegan Arena at Casey Plaza, Wilkes-Barre, Pennsylvania": SportsballGeocodeTuple(
        city="Wilkes-Barre",
        state="PA",
        postal="",
        lat=41.240471,
        lng=-75.848504,
        housenumber="255",
        country="USA",
    ),
    "St. Thomas": SportsballGeocodeTuple(
        city="St. Thomas",
        state="VI",
        postal="",
        lat=18.333333,
        lng=-64.916667,
        housenumber="255",
        country="USA",
    ),
    "Cancun": SportsballGeocodeTuple(
        city="Cancun",
        state="QR",
        postal="",
        lat=21.160556,
        lng=-86.8475,
        housenumber="",
        country="Mexico",
    ),
    "Roberts Stadium, Evansville, Indiana": ROBERTS_STADIUM,
    "Mullett Arena, Tempe, Arizona": SportsballGeocodeTuple(
        city="Tempe",
        state="AZ",
        postal="",
        lat=33.426667,
        lng=-111.928611,
        housenumber="411",
        country="USA",
    ),
    "Anderson Arena, Bowling Green, Ohio": SportsballGeocodeTuple(
        city="Bowling Green",
        state="OH",
        postal="",
        lat=41.376944,
        lng=-83.636389,
        housenumber="",
        country="USA",
    ),
    "Coliseo Juan Aubín Cruz Abreu, Manatí": COLISEO_JUAN_AUBIN_CRUZ_ABREU,
    "Coppin Center, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.311111,
        lng=-76.657778,
        housenumber="",
        country="USA",
    ),
    "San Juan": SportsballGeocodeTuple(
        city="San Juan",
        state="PR",
        postal="",
        lat=18.406389,
        lng=-66.063889,
        housenumber="",
        country="USA",
    ),
    "Charlie Justice Center, Asheville, North Carolina": SportsballGeocodeTuple(
        city="Asheville",
        state="NC",
        postal="",
        lat=35.617507,
        lng=-82.567711,
        housenumber="",
        country="USA",
    ),
    "McArthur Court, Eugene, Oregon": SportsballGeocodeTuple(
        city="Eugene",
        state="OR",
        postal="",
        lat=44.0416,
        lng=-123.074,
        housenumber="1601",
        country="USA",
    ),
    "Poliforum Benito Juarez, Cancun": SportsballGeocodeTuple(
        city="Cancun",
        state="QR",
        postal="",
        lat=21.101111,
        lng=-86.835,
        housenumber="1601",
        country="Mexico",
    ),
    "Alario Center, Westwego, Louisiana": SportsballGeocodeTuple(
        city="Westwego",
        state="LA",
        postal="",
        lat=29.90516,
        lng=-90.16283,
        housenumber="2000",
        country="USA",
    ),
    "Blue Cross Arena, Rochester, New York": SportsballGeocodeTuple(
        city="Rochester",
        state="NY",
        postal="",
        lat=43.153694,
        lng=-77.610778,
        housenumber="1",
        country="USA",
    ),
    "Walter Athletic Complex, Tampa, Florida": SportsballGeocodeTuple(
        city="Tampa",
        state="FL",
        postal="33606",
        lat=27.9471998,
        lng=-82.4713179,
        housenumber="400",
        country="USA",
    ),
    "CenturyTel Center, Bossier City, Louisiana": BROOKSHIRE_GROCERY_ARENA,
    "Glens Falls Civic Center, Glens Falls, New York": SportsballGeocodeTuple(
        city="Glens Falls",
        state="NY",
        postal="12801",
        lat=43.308169,
        lng=-73.641782,
        housenumber="1",
        country="USA",
    ),
    "VisitLethbridge.com Arena, Lethbridge": SportsballGeocodeTuple(
        city="Lethbridge",
        state="AB",
        postal="",
        lat=49.666947,
        lng=-112.805428,
        housenumber="2510",
        country="Canada",
    ),
    "Memorial Gym, Moscow, Idaho": SportsballGeocodeTuple(
        city="Moscow",
        state="ID",
        postal="",
        lat=46.7265,
        lng=-117.014,
        housenumber="1001",
        country="USA",
    ),
    "Grand Cayman": SportsballGeocodeTuple(
        city="Grand Cayman",
        state="",
        postal="",
        lat=19.33,
        lng=-81.24,
        housenumber="",
        country="UK",
    ),
    "Coliseum, Cincinnati, Ohio": PAYCOR_STADIUM,
    "Riverfront Coliseum, Cincinnati, Ohio": PAYCOR_STADIUM,
    "Coliseo Rubén Rodríguez, Bayamon": COLISEO_RUBEN_RODRIGUEZ,
    "BankCorp South Arena, Tupelo, Mississippi": SportsballGeocodeTuple(
        city="Tupelo",
        state="MS",
        postal="38804",
        lat=34.26,
        lng=-88.7,
        housenumber="375",
        country="USA",
    ),
    "Coliseo RubÃ©n RodrÃ­guez, Bayamon": COLISEO_RUBEN_RODRIGUEZ,
    "Tim's Toyota Center, Prescott, Arizona": SportsballGeocodeTuple(
        city="Prescott",
        state="AZ",
        postal="",
        lat=34.589242,
        lng=-112.336361,
        housenumber="3201",
        country="USA",
    ),
    "Acrisure Arena, Thousand Palms, California": SportsballGeocodeTuple(
        city="Thousand Palms",
        state="CA",
        postal="",
        lat=33.779167,
        lng=-116.338889,
        housenumber="75702",
        country="USA",
    ),
    "Qwest Center Omaha, Omaha, Nebraska": CHI_HEALTH_CENTER,
    "Bossier City, Louisiana": SportsballGeocodeTuple(
        city="Bossier City",
        state="LA",
        postal="",
        lat=32.517778,
        lng=-93.691389,
        housenumber="",
        country="USA",
    ),
    "Seabury Center, Berea, Ohio": SportsballGeocodeTuple(
        city="Berea",
        state="OH",
        postal="40404",
        lat=37.5742278,
        lng=-84.2930863,
        housenumber="313",
        country="USA",
    ),
    "Anchorage, Alaska": ANCHORAGE,
    "Mott Gymn, San Luis Obispo, California": SportsballGeocodeTuple(
        city="San Luis Obispo",
        state="CA",
        postal="",
        lat=35.29886,
        lng=-120.65855,
        housenumber="1",
        country="USA",
    ),
    "Beard–Eaves–Memorial Coliseum, Auburn, Alabama": BEARD_EAVES_MEMORIAL_COLISEUM,
    "Colonial Hall at The Greenbrier, White Sulphur Springs, West Virginia": SportsballGeocodeTuple(
        city="White Sulphur Springs",
        state="WV",
        postal="36832",
        lat=37.7854,
        lng=-80.3083,
        housenumber="",
        country="USA",
    ),
    "Tallahassee-Leon County Civic Center, Tallahassee, Florida": DONALD_L_TUCKER_CENTER,
    "CFG Bank Arena, Baltimore, Maryland": CFG_BANK_ARENA,
    "BeardâEavesâMemorial Coliseum, Auburn, Alabama": BEARD_EAVES_MEMORIAL_COLISEUM,
    "Vibrant Arena at The MARK, Moline, Illinois": SportsballGeocodeTuple(
        city="Moline",
        state="IL",
        postal="61265",
        lat=41.507837,
        lng=-90.520437,
        housenumber="1201",
        country="USA",
    ),
    "Ninja Stadium": BLUNDSTONE_ARENA,
    "Summit Arena, Rapid City, South Dakota": SportsballGeocodeTuple(
        city="Rapid City",
        state="SD",
        postal="",
        lat=44.08854,
        lng=-103.225816,
        housenumber="444",
        country="USA",
    ),
    "Charleston, West Virginia": SportsballGeocodeTuple(
        city="Charleston",
        state="WV",
        postal="",
        lat=38.349819,
        lng=-81.632622,
        housenumber="",
        country="USA",
    ),
    "Shreveport, Louisiana": SHREVEPORT,
    "Tahoe Blue Event Center, Stateline, Nevada": SportsballGeocodeTuple(
        city="Stateline",
        state="NV",
        postal="89449",
        lat=38.96275,
        lng=-119.938472,
        housenumber="75",
        country="USA",
    ),
    "Greenville, Mississippi": SportsballGeocodeTuple(
        city="Greenville",
        state="MS",
        postal="",
        lat=33.384722,
        lng=-91.048333,
        housenumber="",
        country="USA",
    ),
    "Adidas Arena, Paris": SportsballGeocodeTuple(
        city="Paris",
        state="",
        postal="75018",
        lat=48.89959,
        lng=2.36075,
        housenumber="58",
        country="France",
    ),
    "Gulfport, Mississippi": SportsballGeocodeTuple(
        city="Gulfport",
        state="MS",
        postal="",
        lat=30.401667,
        lng=-89.076111,
        housenumber="",
        country="USA",
    ),
    "East Rutherford, New Jersey": SportsballGeocodeTuple(
        city="East Rutherford",
        state="NJ",
        postal="",
        lat=40.817097,
        lng=-74.085024,
        housenumber="",
        country="USA",
    ),
    "Duluth, Georgia": DULUTH,
    "Kennewick, Washington": SportsballGeocodeTuple(
        city="Kennewick",
        state="WA",
        postal="",
        lat=46.195278,
        lng=-119.173056,
        housenumber="",
        country="USA",
    ),
    "Southaven, Mississippi": SOUTHAVEN,
    "Casper, Wyoming": SportsballGeocodeTuple(
        city="Casper",
        state="WY",
        postal="",
        lat=42.85,
        lng=-106.325,
        housenumber="",
        country="USA",
    ),
    "Beard-Eaves-Memorial, Auburn, Alabama": BEARD_EAVES_MEMORIAL_COLISEUM,
    "DCU Center, Worcester, Massachusetts": SportsballGeocodeTuple(
        city="Worcester",
        state="MA",
        postal="",
        lat=42.266111,
        lng=-71.798333,
        housenumber="50",
        country="USA",
    ),
    "Wooden Family Fieldhouse, Xenia, Ohio": SportsballGeocodeTuple(
        city="Xenia",
        state="OH",
        postal="45385",
        lat=39.665597,
        lng=-83.9246487,
        housenumber="1310",
        country="USA",
    ),
    "JosÃ© Miguel Agrelot Coliseum, San Juan": JOSE_MIGUEL_AGRELOT_COLISEUM,
    "Sun National Bank Center, Trenton, New Jersey": SportsballGeocodeTuple(
        city="Trenton",
        state="NJ",
        postal="08611",
        lat=40.212778,
        lng=-74.757561,
        housenumber="81",
        country="USA",
    ),
    "Cox Arena, San Diego, California": VIEJAS_ARENA,
    "The Omni, Atlanta, Georgia": OMNI_COLISEUM,
    "TD Banknorth Sports Center, Hamden, Connecticut": TD_BANK_SPORTS_CENTER,
    "The Event Center, San Jose, California": SportsballGeocodeTuple(
        city="San Jose",
        state="CA",
        postal="95192",
        lat=37.33536,
        lng=-121.87985,
        housenumber="290",
        country="USA",
    ),
    "TIO Stadium, Darwin": TIO_STADIUM,
    "SCG, Sydney": SCG,
    "MCG, Melbourne": MCG,
    "Adelaide Oval, Adelaide": ADELAIDE_OVAL,
    "ENGIE Stadium, Sydney": ENGIE_STADIUM,
    "Marvel Stadium, Melbourne": MARVEL_STADIUM,
    "Gabba, Brisbane": GABBA,
    "Optus Stadium, Perth": OPTUS_STADIUM,
    "Ball Arena - Denver, Colorado, USA - United States": PEPSI_CENTRE,
    "Alexander Memorial Coliseum, Atlanta, Georgia": MCCAMISH_PAVILION,
    "Alltell Arena, North Little Rock, Arkansas": SIMMONS_BANK_ARENA,
    "Auburn Hills, Michigan": SportsballGeocodeTuple(
        city="Auburn Hills",
        state="MI",
        postal="",
        lat=42.6875,
        lng=-83.234167,
        housenumber="",
        country="USA",
    ),
    "Guaynabo": SportsballGeocodeTuple(
        city="Guaynabo",
        state="PR",
        postal="",
        lat=18.366667,
        lng=-66.1,
        housenumber="",
        country="USA",
    ),
    "Biloxi, Mississippi": SportsballGeocodeTuple(
        city="Biloxi",
        state="MS",
        postal="",
        lat=30.411944,
        lng=-88.927778,
        housenumber="",
        country="USA",
    ),
    "Glendale, Arizona": SportsballGeocodeTuple(
        city="Glendale",
        state="AZ",
        postal="",
        lat=33.538611,
        lng=-112.186389,
        housenumber="",
        country="USA",
    ),
    "GMHBA Stadium, Geelong": GMHBA_STADIUM,
    "Paycom Center, Oklahoma City, OK": PAYCOM_CENTRE,
    "Kentucky International Convention Center, Louisville, Kentucky": SportsballGeocodeTuple(
        city="Louisville",
        state="KY",
        postal="",
        lat=38.254194,
        lng=-85.755111,
        housenumber="",
        country="USA",
    ),
    "Madison Square Garden, New York, NY": MADISON_SQUARE_GARDEN,
    "Hoffman Estates, Illinois": SportsballGeocodeTuple(
        city="Hoffman Estates",
        state="IL",
        postal="",
        lat=42.063889,
        lng=-88.146944,
        housenumber="",
        country="USA",
    ),
    "Bojangles Coliseum, Charlotte, North Carolina": SportsballGeocodeTuple(
        city="Charlotte",
        state="NC",
        postal="",
        lat=35.205164,
        lng=-80.795103,
        housenumber="2700",
        country="USA",
    ),
    "Rice Gymnasium, Houston, Texas": TUDOR_FIELDHOUSE,
    "Alumni Memorial Fieldhouse, Philadelphia, Pennsylvania": HAGAN_ARENA,
    "Colonial Center, Columbia, South Carolina": COLONIAL_LIFE_ARENA,
    "F. Mitchell Johnson Center, Charleston, South Carolina": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="",
        lat=32.785278,
        lng=-79.934167,
        housenumber="",
        country="USA",
    ),
    "Coors Events Center, Boulder, Colorado": COORS_EVENTS_CONFERENCE_CENTER,
    "Target Center, Minneapolis, MN": TARGET_CENTER,
    "Hammons Student Center, Springfield, Missouri": SportsballGeocodeTuple(
        city="Springfield",
        state="MO",
        postal="",
        lat=37.202222,
        lng=-93.284444,
        housenumber="",
        country="USA",
    ),
    "Curragh Racecourse, Ireland": SportsballGeocodeTuple(
        city="",
        state="County Kildare",
        postal="",
        lat=53.165278,
        lng=-6.845278,
        housenumber="",
        country="Ireland",
    ),
    "Doomben Racecourse, Australia": SportsballGeocodeTuple(
        city="Ascot",
        state="QLD",
        postal="",
        lat=-27.426319,
        lng=153.076033,
        housenumber="",
        country="Australia",
    ),
    "Tokyo Racecourse, Japan": SportsballGeocodeTuple(
        city="Tokyo",
        state="",
        postal="",
        lat=35.663,
        lng=139.485,
        housenumber="",
        country="Japan",
    ),
    "Newbury Racecourse, United Kingdom": SportsballGeocodeTuple(
        city="Newbury",
        state="Berkshire",
        postal="",
        lat=51.394444,
        lng=-1.300556,
        housenumber="",
        country="UK",
    ),
    "ParisLongchamp Racecourse, France": SportsballGeocodeTuple(
        city="Paris",
        state="",
        postal="",
        lat=48.85875,
        lng=2.232778,
        housenumber="",
        country="France",
    ),
    "Morphettville Racecourse, Australia": SportsballGeocodeTuple(
        city="Adelaide",
        state="SA",
        postal="",
        lat=-34.978076,
        lng=138.542747,
        housenumber="",
        country="Australia",
    ),
    "Newmarket Racecourse, United Kingdom": SportsballGeocodeTuple(
        city="Suffolk",
        state="",
        postal="",
        lat=52.230861,
        lng=0.38225,
        housenumber="",
        country="UK",
    ),
    "Nakayama Racecourse, Japan": SportsballGeocodeTuple(
        city="Funabashi",
        state="Chiba",
        postal="",
        lat=35.725556,
        lng=139.9625,
        housenumber="",
        country="Japan",
    ),
    "Randwick Racecourse, Australia": SportsballGeocodeTuple(
        city="Sydney",
        state="NSW",
        postal="",
        lat=-33.910833,
        lng=151.230278,
        housenumber="",
        country="Australia",
    ),
    "Hanshin Racecourse, Japan": SportsballGeocodeTuple(
        city="Takarazuka",
        state="Hyogo",
        postal="",
        lat=34.780222,
        lng=135.3625,
        housenumber="",
        country="Japan",
    ),
    "Meydan Racecourse, United Arab Emirates": SportsballGeocodeTuple(
        city="Dubai",
        state="",
        postal="",
        lat=25.156102,
        lng=55.306549,
        housenumber="",
        country="UAE",
    ),
    "Chukyo Racecourse, Japan": SportsballGeocodeTuple(
        city="Toyoake",
        state="Aichi",
        postal="",
        lat=35.066736,
        lng=136.989444,
        housenumber="1225",
        country="Japan",
    ),
    "Flemington Racecourse, Australia": SportsballGeocodeTuple(
        city="Melbourne",
        state="VIC",
        postal="",
        lat=-37.790278,
        lng=144.9125,
        housenumber="",
        country="Australia",
    ),
    "Turffontein Racecourse, South Africa": SportsballGeocodeTuple(
        city="Johannesburg",
        state="",
        postal="",
        lat=-26.238056,
        lng=28.046944,
        housenumber="",
        country="South Africa",
    ),
    "Ellerslie Racecourse, New Zealand": SportsballGeocodeTuple(
        city="Auckland",
        state="",
        postal="",
        lat=-36.889292,
        lng=174.805769,
        housenumber="",
        country="New Zealand",
    ),
    "Caulfield Racecourse, Australia": SportsballGeocodeTuple(
        city="Melbourne",
        state="VIC",
        postal="",
        lat=-37.881,
        lng=145.04,
        housenumber="",
        country="Australia",
    ),
    "King Abdulaziz Racecourse, Saudi Arabia": SportsballGeocodeTuple(
        city="Riyadh",
        state="",
        postal="",
        lat=24.985861,
        lng=46.785194,
        housenumber="",
        country="Saudi Arabia",
    ),
    "Kenilworth Racecourse, South Africa": SportsballGeocodeTuple(
        city="Cape Town",
        state="",
        postal="",
        lat=-33.998611,
        lng=18.479722,
        housenumber="",
        country="South Africa",
    ),
    "San Isidro Racecourse, Argentina": SportsballGeocodeTuple(
        city="San Isidro",
        state="",
        postal="",
        lat=-34.483058,
        lng=-58.519072,
        housenumber="",
        country="Argentina",
    ),
    "Kyoto Racecourse, Japan": SportsballGeocodeTuple(
        city="Fushimi-ku",
        state="Kyoto",
        postal="",
        lat=34.906667,
        lng=135.725,
        housenumber="",
        country="Japan",
    ),
    "Munich Racecourse, Germany": SportsballGeocodeTuple(
        city="Munich",
        state="",
        postal="81929",
        lat=48.1438687,
        lng=11.6556131,
        housenumber="36",
        country="Germany",
    ),
    "Del Mar Racecourse, United States of America": SportsballGeocodeTuple(
        city="Del Mar",
        state="CA",
        postal="",
        lat=32.976111,
        lng=-117.261944,
        housenumber="",
        country="USA",
    ),
    "Sha Tin, China": SportsballGeocodeTuple(
        city="Hong Kong",
        state="",
        postal="",
        lat=22.399444,
        lng=114.206667,
        housenumber="",
        country="China",
    ),
    "IRE": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=53.3543083,
        lng=-10.8559015,
        housenumber="",
        country="Ireland",
    ),
    "West Palm Beach, Florida, United States": SportsballGeocodeTuple(
        city="West Palm Beach",
        state="FL",
        postal="",
        lat=26.709722,
        lng=-80.064167,
        housenumber="",
        country="USA",
    ),
    "East Liverpool, Ohio, United States": SportsballGeocodeTuple(
        city="East Liverpool",
        state="OH",
        postal="",
        lat=40.628611,
        lng=-80.571944,
        housenumber="",
        country="USA",
    ),
    "Spokane, Washington, United States": SPOKANE,
    "Greensboro, North Carolina, United States": GREENSBORO,
    "Clinton, Maryland, United States": SportsballGeocodeTuple(
        city="Clinton",
        state="MD",
        postal="",
        lat=38.763611,
        lng=-76.895556,
        housenumber="",
        country="USA",
    ),
    "Lynwood, California, United States": SportsballGeocodeTuple(
        city="Lynwood",
        state="CA",
        postal="",
        lat=33.924722,
        lng=-118.201944,
        housenumber="",
        country="USA",
    ),
    "Buffalo, New York, United States": BUFFALO,
    "Battle Ground, Washington, United States": SportsballGeocodeTuple(
        city="Battle Ground",
        state="WA",
        postal="",
        lat=45.762778,
        lng=-122.530556,
        housenumber="",
        country="USA",
    ),
    "Los Angeles, California, United States": LOS_ANGELES,
    "Long Beach, California, United States": LONG_BEACH,
    "Philadelphia, Pennsylvania, United States": PHILADELPHIA,
    "Rockaway, New York, United States": SportsballGeocodeTuple(
        city="Rockaway",
        state="NY",
        postal="",
        lat=40.585833,
        lng=-73.816944,
        housenumber="",
        country="USA",
    ),
    "Pineville, Louisiana, United States": SportsballGeocodeTuple(
        city="Pineville",
        state="LA",
        postal="",
        lat=31.338889,
        lng=-92.4125,
        housenumber="",
        country="USA",
    ),
    "Sao Carlos, Brazil": SportsballGeocodeTuple(
        city="Sao Carlos",
        state="Sao Paulo",
        postal="",
        lat=-22.0,
        lng=-47.890833,
        housenumber="",
        country="Brazil",
    ),
    "Akron, Ohio, United States": AKRON,
    "Canton, Mississippi, United States": SportsballGeocodeTuple(
        city="Canton",
        state="MS",
        postal="",
        lat=32.611944,
        lng=-90.023333,
        housenumber="",
        country="USA",
    ),
    "East Chicago, Indiana, United States": SportsballGeocodeTuple(
        city="East Chicago",
        state="IN",
        postal="",
        lat=41.638889,
        lng=-87.459444,
        housenumber="",
        country="USA",
    ),
    "Hempstead, New York, United States": HEMPSTEAD,
    "Canton, Ohio, United States": CANTON,
    "Harlem, New York, United States": SportsballGeocodeTuple(
        city="Harlem",
        state="NY",
        postal="",
        lat=40.808889,
        lng=-73.948333,
        housenumber="",
        country="USA",
    ),
    "Bethlehem, Mississippi, United States": SportsballGeocodeTuple(
        city="Bethlehem",
        state="MS",
        postal="",
        lat=34.577222,
        lng=-89.328889,
        housenumber="",
        country="USA",
    ),
    "Richmond, Virginia, United States": RICHMOND,
    "Coeur d'Alene, Idaho, United States": SportsballGeocodeTuple(
        city="Coeur d'Alene",
        state="ID",
        postal="",
        lat=47.692778,
        lng=-116.78,
        housenumber="",
        country="USA",
    ),
    "Sant'Angelo Lodigiano, Italy": SportsballGeocodeTuple(
        city="Sant'Angelo Lodigiano",
        state="LO",
        postal="",
        lat=45.233333,
        lng=9.4,
        housenumber="",
        country="Italy",
    ),
    "Orange City, Iowa, United States": SportsballGeocodeTuple(
        city="Orange City",
        state="IO",
        postal="",
        lat=42.995833,
        lng=-96.054722,
        housenumber="",
        country="USA",
    ),
    "Indianapolis, Indiana, United States": INDIANAPOLIS,
    "Rocky Mount, North Carolina, United States": SportsballGeocodeTuple(
        city="Rocky Mount",
        state="NC",
        postal="",
        lat=35.968333,
        lng=-77.804444,
        housenumber="",
        country="USA",
    ),
    "Reynoldsburg, Ohio, United States": SportsballGeocodeTuple(
        city="Reynoldsburg",
        state="OH",
        postal="",
        lat=39.96,
        lng=-82.784722,
        housenumber="",
        country="USA",
    ),
    "St. Petersburg, Russia": SportsballGeocodeTuple(
        city="St. Petersburg",
        state="",
        postal="",
        lat=59.9375,
        lng=30.308611,
        housenumber="",
        country="Russia",
    ),
    "Dayton, Ohio, United States": DAYTON,
    "Cleveland, Ohio, United States": CLEVELAND,
    "Valhalla, New York, United States": SportsballGeocodeTuple(
        city="Valhalla",
        state="NY",
        postal="",
        lat=41.075,
        lng=-73.775278,
        housenumber="",
        country="USA",
    ),
    "Trebinje, Bosnia and Herzegovina": SportsballGeocodeTuple(
        city="Trebinje",
        state="",
        postal="",
        lat=42.711944,
        lng=18.346111,
        housenumber="",
        country="Bosnia and Herzegovina",
    ),
    "Orange, New Jersey, United States": SportsballGeocodeTuple(
        city="Orange",
        state="NJ",
        postal="",
        lat=40.76804,
        lng=-74.235692,
        housenumber="",
        country="USA",
    ),
    "Vevey, Switzerland": SportsballGeocodeTuple(
        city="Vevey",
        state="Vaud",
        postal="",
        lat=46.466667,
        lng=6.85,
        housenumber="",
        country="Switzerland",
    ),
    "Bastrop, Louisiana, United States": SportsballGeocodeTuple(
        city="Bastrop",
        state="LA",
        postal="",
        lat=32.756944,
        lng=-91.890278,
        housenumber="",
        country="USA",
    ),
    "Natchitoches, Louisiana, United States": NATCHITOCHES,
    "Tampa, Florida, United States": TAMPA,
    "Palma de Mallorca, Spain": SportsballGeocodeTuple(
        city="Palma de Mallorca",
        state="",
        postal="",
        lat=39.566667,
        lng=2.65,
        housenumber="",
        country="Spain",
    ),
    "Burnsville, Minnesota, United States": SportsballGeocodeTuple(
        city="Burnsville",
        state="MN",
        postal="",
        lat=44.767778,
        lng=-93.2775,
        housenumber="",
        country="USA",
    ),
    "McLeansboro, Illinois, United States": SportsballGeocodeTuple(
        city="McLeansboro",
        state="IL",
        postal="",
        lat=38.090278,
        lng=-88.538611,
        housenumber="",
        country="USA",
    ),
    "Little Rock, Arkansas, United States": LITTLE_ROCK,
    "Pensacola, Florida, United States": PENSACOLA,
    "Portland, Tennessee, United States": SportsballGeocodeTuple(
        city="Portland",
        state="TN",
        postal="",
        lat=36.581709,
        lng=-86.516383,
        housenumber="",
        country="USA",
    ),
    "Nederland, Texas, United States": SportsballGeocodeTuple(
        city="Nederland",
        state="TX",
        postal="",
        lat=29.968889,
        lng=-94.000833,
        housenumber="",
        country="USA",
    ),
    "Indianola, Mississippi, United States": SportsballGeocodeTuple(
        city="Indianola",
        state="MS",
        postal="",
        lat=33.451111,
        lng=-90.6375,
        housenumber="",
        country="USA",
    ),
    "Dallas, Texas, United States": DALLAS,
    "Belgrade, Serbia": SportsballGeocodeTuple(
        city="Belgrade",
        state="",
        postal="",
        lat=44.817778,
        lng=20.456944,
        housenumber="",
        country="Serbia",
    ),
    "New York, New York, United States": NEW_YORK,
    "Washington, District of Columbia, United States": WASHINGTON,
    "Hoke, North Carolina, United States": SportsballGeocodeTuple(
        city="Hoke",
        state="NC",
        postal="",
        lat=35.017,
        lng=-79.24,
        housenumber="",
        country="USA",
    ),
    "Jackson, Mississippi, United States": JACKSON,
    "Raleigh, North Carolina, United States": RALEIGH,
    "Jamaica, New York, United States": JAMAICA,
    "Brazzaville, Republic of the Congo": SportsballGeocodeTuple(
        city="Brazzaville",
        state="",
        postal="",
        lat=-1.44,
        lng=15.556,
        housenumber="",
        country="Republic of the Congo",
    ),
    "Mullens, West Virginia, United States": SportsballGeocodeTuple(
        city="Mullens",
        state="WV",
        postal="",
        lat=37.584722,
        lng=-81.384722,
        housenumber="",
        country="USA",
    ),
    "Kinston, North Carolina, United States": SportsballGeocodeTuple(
        city="Kinston",
        state="NC",
        postal="",
        lat=35.274722,
        lng=-77.593611,
        housenumber="",
        country="USA",
    ),
    "Harvey, Illinois, United States": SportsballGeocodeTuple(
        city="Harvey",
        state="IL",
        postal="",
        lat=41.610833,
        lng=-87.651944,
        housenumber="",
        country="USA",
    ),
    "Pointe-a-Pitre, Guadeloupe": SportsballGeocodeTuple(
        city="Pointe-a-Pitre",
        state="",
        postal="",
        lat=16.2411,
        lng=-61.5331,
        housenumber="",
        country="Guadeloupe",
    ),
    "Chicago, Illinois, United States": CHICAGO,
    "Amherst, Virginia, United States": SportsballGeocodeTuple(
        city="Amherst",
        state="VA",
        postal="",
        lat=37.576944,
        lng=-79.050556,
        housenumber="",
        country="USA",
    ),
    "Coral Gables, Florida, United States": CORAL_GABLES,
    "Bijelo Polje, Montenegro": SportsballGeocodeTuple(
        city="Bijelo Polje",
        state="",
        postal="",
        lat=43.04,
        lng=19.75,
        housenumber="",
        country="Montenegro",
    ),
    "Daytona Beach, Florida, United States": DAYTONA_BEACH,
    "Birmingham, Michigan, United States": SportsballGeocodeTuple(
        city="Birmingham",
        state="MI",
        postal="",
        lat=42.546667,
        lng=-83.211389,
        housenumber="",
        country="USA",
    ),
    "Winston-Salem, North Carolina, United States": WINSTON_SALEM,
    "Anchorage, Alaska, United States": ANCHORAGE,
    "Berkeley, California, United States": BERKELEY,
    "Harper, Kansas, United States": SportsballGeocodeTuple(
        city="Harper",
        state="KS",
        postal="",
        lat=37.285,
        lng=-98.0275,
        housenumber="",
        country="USA",
    ),
    "Shreveport, Louisiana, United States": SHREVEPORT,
    "Seattle, Washington, United States": SEATTLE,
    "Miami, Florida, United States": MIAMI,
    "Houston, Texas, United States": HOUSTON,
    "Milwaukee, Wisconsin, United States": MILWAUKEE,
    "Wallace, North Carolina, United States": SportsballGeocodeTuple(
        city="Wallace",
        state="NC",
        postal="",
        lat=34.737778,
        lng=-77.990556,
        housenumber="",
        country="USA",
    ),
    "Ft. Lauderdale, Florida, United States": SportsballGeocodeTuple(
        city="Ft. Lauderdale",
        state="FL",
        postal="",
        lat=26.133333,
        lng=-80.15,
        housenumber="",
        country="USA",
    ),
    "San Francisco, California, United States": SAN_FRANCISCO,
    "Le Robert, Martinique": SportsballGeocodeTuple(
        city="Le Robert",
        state="",
        postal="",
        lat=14.6792,
        lng=-60.9403,
        housenumber="",
        country="Martinique",
    ),
    "Memphis, Tennessee, United States": MEMPHIS,
    "St. Louis, Missouri, United States": ST_LOUIS,
    "Lake Wales, Florida, United States": SportsballGeocodeTuple(
        city="Lake Wales",
        state="FL",
        postal="",
        lat=27.919444,
        lng=-81.596111,
        housenumber="",
        country="USA",
    ),
    "Hibbing, Minnesota, United States": SportsballGeocodeTuple(
        city="Hibbing",
        state="MN",
        postal="",
        lat=47.417222,
        lng=-92.938333,
        housenumber="",
        country="USA",
    ),
    "Beijing, China": SportsballGeocodeTuple(
        city="Beijing",
        state="",
        postal="",
        lat=39.906667,
        lng=116.3975,
        housenumber="",
        country="China",
    ),
    "Mitchell, South Dakota, United States": SportsballGeocodeTuple(
        city="Mitchell",
        state="SD",
        postal="",
        lat=43.729444,
        lng=-98.033611,
        housenumber="",
        country="USA",
    ),
    "Bedford, Texas, United States": SportsballGeocodeTuple(
        city="Bedford",
        state="TX",
        postal="",
        lat=32.847778,
        lng=-97.122222,
        housenumber="",
        country="USA",
    ),
    "Tacoma, Washington, United States": SportsballGeocodeTuple(
        city="Tacoma",
        state="WA",
        postal="",
        lat=47.245833,
        lng=-122.459444,
        housenumber="",
        country="USA",
    ),
    "Sao Paulo, Brazil": SportsballGeocodeTuple(
        city="Sao Paulo",
        state="Sao Paulo",
        postal="",
        lat=-23.55,
        lng=-46.633333,
        housenumber="",
        country="Brazil",
    ),
    "West Baden, Indiana, United States": SportsballGeocodeTuple(
        city="West Baden",
        state="IN",
        postal="",
        lat=38.5675,
        lng=-86.611944,
        housenumber="",
        country="USA",
    ),
    "Melrose Park, Illinois, United States": SportsballGeocodeTuple(
        city="Melrose Park",
        state="IL",
        postal="",
        lat=41.907778,
        lng=-87.864444,
        housenumber="",
        country="USA",
    ),
    "Rouen, France": SportsballGeocodeTuple(
        city="Rouen",
        state="Normandy",
        postal="",
        lat=49.442778,
        lng=1.088611,
        housenumber="",
        country="France",
    ),
    "Detroit, Michigan, United States": DETROIT,
    "Palmdale, California, United States": SportsballGeocodeTuple(
        city="Palmdale",
        state="CA",
        postal="",
        lat=34.581111,
        lng=-118.100556,
        housenumber="",
        country="USA",
    ),
    "Lincolnton, North Carolina, United States": SportsballGeocodeTuple(
        city="Lincolnton",
        state="NC",
        postal="",
        lat=35.475,
        lng=-81.238611,
        housenumber="",
        country="USA",
    ),
    "Ostrava, Czechia": SportsballGeocodeTuple(
        city="Ostrava",
        state="Moravian-Silesian",
        postal="",
        lat=49.835556,
        lng=18.2925,
        housenumber="",
        country="Czechia",
    ),
    "Waukegan, Illinois, United States": SportsballGeocodeTuple(
        city="Waukegan",
        state="IL",
        postal="",
        lat=42.370278,
        lng=-87.871111,
        housenumber="",
        country="USA",
    ),
    "Eugene, Oregon, United States": EUGENE,
    "Wyoming, Michigan, United States": SportsballGeocodeTuple(
        city="Wyoming",
        state="MI",
        postal="",
        lat=42.876389,
        lng=-85.7575,
        housenumber="",
        country="USA",
    ),
    "Morrisville, Pennsylvania, United States": SportsballGeocodeTuple(
        city="Morrisville",
        state="PA",
        postal="",
        lat=40.2075,
        lng=-74.78,
        housenumber="",
        country="USA",
    ),
    "Toronto, Ontario, Canada": SportsballGeocodeTuple(
        city="Toronto",
        state="ON",
        postal="",
        lat=43.65,
        lng=-79.38,
        housenumber="",
        country="Canada",
    ),
    "Salt Lake City, Utah, United States": SALT_LAKE_CITY,
    "Jasper, Florida, United States": SportsballGeocodeTuple(
        city="Jasper",
        state="FL",
        postal="",
        lat=30.518889,
        lng=-82.951111,
        housenumber="",
        country="USA",
    ),
    "North Canton, Ohio, United States": SportsballGeocodeTuple(
        city="North Canton",
        state="OH",
        postal="",
        lat=40.875,
        lng=-81.397222,
        housenumber="",
        country="USA",
    ),
    "Edmonds, Washington, United States": SportsballGeocodeTuple(
        city="Edmonds",
        state="WA",
        postal="",
        lat=47.806944,
        lng=-122.346667,
        housenumber="",
        country="USA",
    ),
    "Wurzburg, Germany": SportsballGeocodeTuple(
        city="Wurzburg",
        state="Bavaria",
        postal="",
        lat=49.783333,
        lng=9.933333,
        housenumber="",
        country="Germany",
    ),
    "Havre De Grace, Maryland, United States": HAVRE_DE_GRACE,
    "Paw Paw, Michigan, United States": SportsballGeocodeTuple(
        city="Paw Paw",
        state="MI",
        postal="",
        lat=42.217222,
        lng=-85.89,
        housenumber="",
        country="USA",
    ),
    "Columbus, Ohio, United States": COLUMBUS,
    "East Spencer, North Carolina, United States": SportsballGeocodeTuple(
        city="East Spencer",
        state="NC",
        postal="",
        lat=35.681667,
        lng=-80.422778,
        housenumber="",
        country="USA",
    ),
    "Greenville, South Carolina, United States": GREENVILLE,
    "Savannah, Georgia, United States": SAVANNAH,
    "Maywood, Illinois, United States": SportsballGeocodeTuple(
        city="Maywood",
        state="IL",
        postal="",
        lat=41.881111,
        lng=-87.843333,
        housenumber="",
        country="USA",
    ),
    "Clarksdale, Mississippi, United States": SportsballGeocodeTuple(
        city="Clarksdale",
        state="MS",
        postal="",
        lat=34.2,
        lng=-90.566667,
        housenumber="",
        country="USA",
    ),
    "Tolono, Illinois, United States": SportsballGeocodeTuple(
        city="Tolono",
        state="IL",
        postal="",
        lat=39.986111,
        lng=-88.259722,
        housenumber="",
        country="USA",
    ),
    "Phoenix, Illinois, United States": SportsballGeocodeTuple(
        city="Phoenix",
        state="IL",
        postal="",
        lat=41.612222,
        lng=-87.630556,
        housenumber="",
        country="USA",
    ),
    "Atlanta, Georgia, United States": ATLANTA,
    "Villa Rica, Georgia, United States": SportsballGeocodeTuple(
        city="Villa Rica",
        state="GA",
        postal="",
        lat=33.731944,
        lng=-84.92,
        housenumber="",
        country="USA",
    ),
    "Peekskill, New York, United States": SportsballGeocodeTuple(
        city="Peekskill",
        state="NY",
        postal="",
        lat=41.283333,
        lng=-73.916667,
        housenumber="",
        country="USA",
    ),
    "Baton Rouge, Louisiana, United States": BATON_ROUGE,
    "Freehold, New Jersey, United States": SportsballGeocodeTuple(
        city="Freehold",
        state="NJ",
        postal="",
        lat=40.224382,
        lng=-74.299051,
        housenumber="",
        country="USA",
    ),
    "Riverside, California, United States": RIVERSIDE,
    "Gary, Indiana, United States": SportsballGeocodeTuple(
        city="Gary",
        state="IN",
        postal="",
        lat=41.590556,
        lng=-87.346944,
        housenumber="",
        country="USA",
    ),
    "Canton, Georgia, United States": SportsballGeocodeTuple(
        city="Canton",
        state="GA",
        postal="",
        lat=34.227222,
        lng=-84.494722,
        housenumber="",
        country="USA",
    ),
    "Visalia, California, United States": SportsballGeocodeTuple(
        city="Visalia",
        state="CA",
        postal="",
        lat=36.330278,
        lng=-119.2925,
        housenumber="",
        country="USA",
    ),
    "Teaneck, New Jersey, United States": SportsballGeocodeTuple(
        city="Teaneck",
        state="NJ",
        postal="",
        lat=40.890317,
        lng=-74.011478,
        housenumber="",
        country="USA",
    ),
    "Louisville, Kentucky, United States": LOUISVILLE,
    "Santa Teresa, Brazil": SportsballGeocodeTuple(
        city="Santa Teresa",
        state="Rio de Janeiro",
        postal="",
        lat=-22.9175,
        lng=-43.188056,
        housenumber="",
        country="Brazil",
    ),
    "Tomsk, Russia": SportsballGeocodeTuple(
        city="Tomsk",
        state="",
        postal="",
        lat=56.5,
        lng=84.966667,
        housenumber="",
        country="Russia",
    ),
    "Oxford, Ohio, United States": OXFORD,
    "Newberry, South Carolina, United States": SportsballGeocodeTuple(
        city="Newberry",
        state="SC",
        postal="",
        lat=34.277778,
        lng=-81.616667,
        housenumber="",
        country="USA",
    ),
    "Irvington, New Jersey, United States": SportsballGeocodeTuple(
        city="Irvington",
        state="NJ",
        postal="",
        lat=40.723859,
        lng=-74.232522,
        housenumber="",
        country="USA",
    ),
    "Portland, Oregon, United States": PORTLAND,
    "Randolph, Wisconsin, United States": SportsballGeocodeTuple(
        city="Randolph",
        state="WI",
        postal="",
        lat=43.577778,
        lng=-89.054167,
        housenumber="",
        country="USA",
    ),
    "Racine, Wisconsin, United States": SportsballGeocodeTuple(
        city="Racine",
        state="WI",
        postal="",
        lat=42.726111,
        lng=-87.805833,
        housenumber="",
        country="USA",
    ),
    "Santa Monica, California, United States": SportsballGeocodeTuple(
        city="Santa Monica",
        state="CA",
        postal="",
        lat=34.021944,
        lng=-118.481389,
        housenumber="",
        country="USA",
    ),
    "Baltimore, Maryland, United States": BALTIMORE,
    "San Diego, California, United States": SAN_DIEGO,
    "Athens, Greece": SportsballGeocodeTuple(
        city="Athens",
        state="Attica",
        postal="",
        lat=37.984167,
        lng=23.728056,
        housenumber="",
        country="Greece",
    ),
    "Bronx, New York, United States": BRONX,
    "Merced, California, United States": SportsballGeocodeTuple(
        city="Merced",
        state="CA",
        postal="",
        lat=37.3,
        lng=-120.483333,
        housenumber="",
        country="USA",
    ),
    "Milwaukee, WI, USA": MILWAUKEE,
    "Oak Park, Illinois, United States": SportsballGeocodeTuple(
        city="Oak Park",
        state="IL",
        postal="",
        lat=41.888333,
        lng=-87.789444,
        housenumber="",
        country="USA",
    ),
    "Milton, Florida, United States": SportsballGeocodeTuple(
        city="Milton",
        state="FL",
        postal="",
        lat=30.632414,
        lng=-87.039689,
        housenumber="",
        country="USA",
    ),
    "Melbourne, Australia": SportsballGeocodeTuple(
        city="Melbourne",
        state="VIC",
        postal="",
        lat=-37.814167,
        lng=144.963056,
        housenumber="",
        country="Australia",
    ),
    "Caracas, Venezuela": SportsballGeocodeTuple(
        city="Caracas",
        state="",
        postal="",
        lat=10.480556,
        lng=-66.903611,
        housenumber="",
        country="Venezuela",
    ),
    "Flint, Michigan, United States": SportsballGeocodeTuple(
        city="Flint",
        state="MI",
        postal="",
        lat=43.018889,
        lng=-83.693333,
        housenumber="",
        country="USA",
    ),
    "Bar, Montenegro": SportsballGeocodeTuple(
        city="Bar",
        state="",
        postal="",
        lat=42.1,
        lng=19.1,
        housenumber="",
        country="Montenegro",
    ),
    "Benin City, Nigeria": SportsballGeocodeTuple(
        city="Benin City",
        state="Edo",
        postal="",
        lat=6.333333,
        lng=5.622222,
        housenumber="",
        country="Nigeria",
    ),
    "Cortlandt Manor, New York, United States": SportsballGeocodeTuple(
        city="Cortlandt Manor",
        state="NY",
        postal="",
        lat=41.28,
        lng=-73.87,
        housenumber="",
        country="USA",
    ),
    "New Orleans, Louisiana, United States": NEW_ORLEANS_CITY,
    "Riviera Beach, Florida, United States": SportsballGeocodeTuple(
        city="Riviera Beach",
        state="FL",
        postal="",
        lat=26.78,
        lng=-80.067222,
        housenumber="",
        country="USA",
    ),
    "Youngstown, Ohio, United States": YOUNGSTOWN,
    "Pasadena, California, United States": PASADENA,
    "St. Petersburg, Florida, United States": ST_PETERSBURG,
    "Paterson, New Jersey, United States": SportsballGeocodeTuple(
        city="Paterson",
        state="NJ",
        postal="",
        lat=40.914746,
        lng=-74.162826,
        housenumber="",
        country="USA",
    ),
    "Phoenix, Arizona, United States": PHOENIX,
    "Kinna, Sweden": SportsballGeocodeTuple(
        city="Kinna",
        state="Västergötland",
        postal="",
        lat=57.516667,
        lng=12.683333,
        housenumber="",
        country="Sweden",
    ),
    "Les Abymes, Guadeloupe": SportsballGeocodeTuple(
        city="Les Abymes",
        state="",
        postal="",
        lat=16.27,
        lng=-61.52,
        housenumber="",
        country="Guadeloupe",
    ),
    "Oakland, California, United States": SportsballGeocodeTuple(
        city="Oakland",
        state="CA",
        postal="",
        lat=37.804444,
        lng=-122.270833,
        housenumber="",
        country="USA",
    ),
    "Flower Mound, Texas, United States": SportsballGeocodeTuple(
        city="Flower Mound",
        state="TX",
        postal="",
        lat=33.034167,
        lng=-97.113889,
        housenumber="",
        country="USA",
    ),
    "Cleveland, Mississippi, United States": SportsballGeocodeTuple(
        city="Cleveland",
        state="MS",
        postal="",
        lat=33.742222,
        lng=-90.741667,
        housenumber="",
        country="USA",
    ),
    "Ames, Iowa, United States": AMES,
    "Springfield, Illinois, United States": SPRINGFIELD,
    "Chesapeake, Virginia, United States": SportsballGeocodeTuple(
        city="Chesapeake",
        state="VA",
        postal="",
        lat=36.767398,
        lng=-76.287405,
        housenumber="",
        country="USA",
    ),
    "Huntington, West Virginia, United States": HUNTINGTON,
    "Saginaw, Michigan, United States": SportsballGeocodeTuple(
        city="Saginaw",
        state="MI",
        postal="",
        lat=43.42,
        lng=-83.95,
        housenumber="",
        country="USA",
    ),
    "Joinville, Brazil": SportsballGeocodeTuple(
        city="Joinville",
        state="Santa Catarina",
        postal="",
        lat=-26.3204,
        lng=-48.8437,
        housenumber="",
        country="Brazil",
    ),
    "Minneapolis, Minnesota, United States": MINNEAPOLIS,
    "Peoria, Illinois, United States": PEORIA,
    "Braunschweig, Germany": SportsballGeocodeTuple(
        city="Braunschweig",
        state="Lower Saxony",
        postal="",
        lat=52.266667,
        lng=10.516667,
        housenumber="",
        country="Germany",
    ),
    "Hamilton, Massachusetts, United States": SportsballGeocodeTuple(
        city="Hamilton",
        state="MA",
        postal="",
        lat=42.619708,
        lng=-70.854789,
        housenumber="",
        country="USA",
    ),
    "Charleston, South Carolina, United States": CHARLESTON,
    "Lancaster, Pennsylvania, United States": SportsballGeocodeTuple(
        city="Lancaster",
        state="PA",
        postal="",
        lat=40.039722,
        lng=-76.304444,
        housenumber="",
        country="USA",
    ),
    "Brampton, Ontario, Canada": SportsballGeocodeTuple(
        city="Brampton",
        state="ON",
        postal="",
        lat=43.688333,
        lng=-79.760833,
        housenumber="",
        country="Canada",
    ),
    "Maio, Cabo Verde": SportsballGeocodeTuple(
        city="Maio",
        state="",
        postal="",
        lat=15.216667,
        lng=-23.166667,
        housenumber="",
        country="Cabo Verde",
    ),
    "Cayenne, French Guiana": SportsballGeocodeTuple(
        city="Cayenne",
        state="",
        postal="",
        lat=4.9372,
        lng=-52.326,
        housenumber="",
        country="French Guiana",
    ),
    "Orinda, California, United States": SportsballGeocodeTuple(
        city="Orinda",
        state="CA",
        postal="",
        lat=37.882778,
        lng=-122.179722,
        housenumber="",
        country="USA",
    ),
    "Fort Wayne, Indiana, United States": FORT_WAYNE,
    "Kelford, North Carolina, United States": SportsballGeocodeTuple(
        city="Kelford",
        state="NC",
        postal="",
        lat=36.181111,
        lng=-77.224167,
        housenumber="",
        country="USA",
    ),
    "Libertyville, Illinois, United States": SportsballGeocodeTuple(
        city="Libertyville",
        state="IL",
        postal="",
        lat=42.284222,
        lng=-87.960673,
        housenumber="",
        country="USA",
    ),
    "Sioux City, Iowa, United States": SportsballGeocodeTuple(
        city="Sioux City",
        state="IA",
        postal="",
        lat=42.498056,
        lng=-96.395556,
        housenumber="",
        country="USA",
    ),
    "Lakewood, California, United States": SportsballGeocodeTuple(
        city="Lakewood",
        state="CA",
        postal="",
        lat=33.8475,
        lng=-118.12,
        housenumber="",
        country="USA",
    ),
    "Monroe, Louisiana, United States": MONROE,
    "St. Louis Park, Minnesota, United States": SportsballGeocodeTuple(
        city="St. Louis Park",
        state="MN",
        postal="",
        lat=44.948333,
        lng=-93.348056,
        housenumber="",
        country="USA",
    ),
    "Puerto Plata, Dominican Republic": SportsballGeocodeTuple(
        city="Puerto Plata",
        state="",
        postal="",
        lat=19.8,
        lng=-70.683333,
        housenumber="",
        country="Dominican Republic",
    ),
    "GB": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=55.0,
        lng=-3.0,
        housenumber="",
        country="UK",
    ),
    "AUS": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=-25.0,
        lng=133.0,
        housenumber="",
        country="Australia",
    ),
    "USA": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=40.0,
        lng=-100.0,
        housenumber="",
        country="USA",
    ),
    "NZ": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=-42.0,
        lng=173.0,
        housenumber="",
        country="New Zealand",
    ),
    "SAF": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=-30.0,
        lng=25.0,
        housenumber="",
        country="South Africa",
    ),
    "BRZ": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=-10.0,
        lng=-52.0,
        housenumber="",
        country="Brazil",
    ),
    "FR": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=47.0,
        lng=2.0,
        housenumber="",
        country="France",
    ),
    "People First Stadium, Gold Coast": PEOPLE_FIRST_STADIUM,
    "CHI": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=35.0,
        lng=103.0,
        housenumber="",
        country="China",
    ),
    "ARG": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=-34.0,
        lng=-64.0,
        housenumber="",
        country="Argentina",
    ),
    "GER": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=51.0,
        lng=9.0,
        housenumber="",
        country="Germany",
    ),
    "Hally Valley, China": SportsballGeocodeTuple(
        city="Hong Kong",
        state="",
        postal="",
        lat=22.272778,
        lng=114.182222,
        housenumber="",
        country="China",
    ),
    "JPN": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=36.0,
        lng=138.0,
        housenumber="",
        country="Japan",
    ),
    "ITY": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=43.0,
        lng=12.0,
        housenumber="",
        country="Italy",
    ),
    "TIO Traeger Park, Alice Springs": TIO_STADIUM,
    "Hard Rock Stadium, Miami Gardens, FL, USA": HARD_ROCK_STADIUM,
    "Yokohama Arena - Yokohama, Kanagawa - Japan": YOKOHAMA_ARENA,
    "Centre Bell - Montreal, Quebec, Canada - Canada": BELL_CENTRE,
    "Yankee Stadium - Bronx, New York, USA - United States": YANKEE_STADIUM,
    "Allegiant Stadium, Paradise, NV, USA": ALLEGIANT_STADIUM,
    "Arrowhead Stadium, Kansas City, MO, USA": ARROWHEAD_STADIUM,
    "SPA": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=40.0,
        lng=-4.0,
        housenumber="",
        country="Spain",
    ),
    "Corinthians Arena - Sao Paulo": SportsballGeocodeTuple(
        city="Sao Paulo",
        state="",
        postal="",
        lat=-23.54525,
        lng=-46.474278,
        housenumber="",
        country="Brazil",
    ),
    "AT&T Stadium, Arlington, TX, USA": ATT_STADIUM,
    "Brandon, MS, USA": SportsballGeocodeTuple(
        city="Brandon",
        state="MS",
        postal="",
        lat=32.280278,
        lng=-89.998333,
        housenumber="",
        country="USA",
    ),
    "Croke Park - Dublin": CROKE_PARK,
    "Pittsburg, CA, USA": SportsballGeocodeTuple(
        city="Pittsburg",
        state="CA",
        postal="",
        lat=38.028056,
        lng=-121.884722,
        housenumber="",
        country="USA",
    ),
    "Olympic Stadium Berlin - Berlin": SportsballGeocodeTuple(
        city="Berlin",
        state="",
        postal="",
        lat=52.514722,
        lng=13.239444,
        housenumber="",
        country="Germany",
    ),
    "Kahuku, HI, USA": SportsballGeocodeTuple(
        city="Kahuku",
        state="HI",
        postal="",
        lat=21.680278,
        lng=-157.950278,
        housenumber="",
        country="USA",
    ),
    "Sunnyside, New York, United States": SportsballGeocodeTuple(
        city="Sunnyside",
        state="NY",
        postal="",
        lat=40.743,
        lng=-73.92,
        housenumber="",
        country="USA",
    ),
    "Santiago Bernabéu - Madrid": SportsballGeocodeTuple(
        city="Madrid",
        state="",
        postal="",
        lat=40.453056,
        lng=-3.688333,
        housenumber="",
        country="Spain",
    ),
    "CAN": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=60.0,
        lng=-110.0,
        housenumber="",
        country="Canada",
    ),
    "Camarillo, CA, USA": SportsballGeocodeTuple(
        city="Camarillo",
        state="CA",
        postal="",
        lat=34.233333,
        lng=-119.033333,
        housenumber="",
        country="USA",
    ),
    "GR": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=39.0,
        lng=22.0,
        housenumber="",
        country="Greece",
    ),
    "Camden, New Jersey, United States": SportsballGeocodeTuple(
        city="Camden",
        state="NJ",
        postal="",
        lat=39.94,
        lng=-75.105,
        housenumber="",
        country="USA",
    ),
    "Madison, Wisconsin, United States": MADISON,
    "Schenectady, New York, United States": SportsballGeocodeTuple(
        city="Schenectady",
        state="NY",
        postal="",
        lat=42.814167,
        lng=-73.937222,
        housenumber="",
        country="USA",
    ),
    "Bellevue, WA, USA": SportsballGeocodeTuple(
        city="Bellevue",
        state="WA",
        postal="",
        lat=47.614444,
        lng=-122.153611,
        housenumber="",
        country="USA",
    ),
    "ZIM": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=-19.0,
        lng=30.0,
        housenumber="",
        country="Zimbabwe",
    ),
    "Corroboree Group Oval Manuka, Canberra": MANUKA_OVAL,
    "Hands Oval, Bunbury": HANDS_OVAL,
    "Inkster, Michigan, United States": SportsballGeocodeTuple(
        city="Inkster",
        state="MI",
        postal="",
        lat=42.2925,
        lng=-83.314167,
        housenumber="",
        country="USA",
    ),
    "Danville, Virginia, United States": SportsballGeocodeTuple(
        city="Danville",
        state="VA",
        postal="",
        lat=36.587222,
        lng=-79.404444,
        housenumber="",
        country="USA",
    ),
    "Antioch, CA, USA": SportsballGeocodeTuple(
        city="Antioch",
        state="CA",
        postal="",
        lat=38.005,
        lng=-121.805833,
        housenumber="",
        country="USA",
    ),
    "San Jose, CA, USA": SAN_JOSE,
    "Miami Arena, Miami, Florida": MIAMI_ARENA,
    "Silvio O. Conte Forum, Boston, Massachusetts": SILVIO_O_CONTE_FORUM,
    "IND": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=21.0,
        lng=78.0,
        housenumber="",
        country="India",
    ),
    "Tokyo Dome, Tokyo, Japan": SportsballGeocodeTuple(
        city="Tokyo",
        state="",
        postal="",
        lat=35.705556,
        lng=139.751944,
        housenumber="3",
        country="Japan",
    ),
    "NH": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=52.0,
        lng=6.0,
        housenumber="",
        country="Netherlands",
    ),
    "Federal Way, WA, USA": SportsballGeocodeTuple(
        city="Federal Way",
        state="WA",
        postal="",
        lat=47.313333,
        lng=-122.372222,
        housenumber="",
        country="USA",
    ),
    "SkyDome, Toronto, Canada": ROGERS_CENTER,
    "CoreStates Center, Philadelphia, Pennsylvania": SPECTRUM,
    "BJCC Arena, Birmingham, Alabama": BIRMINGHAM_JEFFERSON_CIVIC_CENTER,
    "Long Beach, CA, USA": LONG_BEACH,
    "Kirkland, WA, USA": SportsballGeocodeTuple(
        city="Kirkland",
        state="WA",
        postal="",
        lat=47.7,
        lng=-122.225,
        housenumber="",
        country="USA",
    ),
    "Seffner, FL, USA": SportsballGeocodeTuple(
        city="Seffner",
        state="FL",
        postal="",
        lat=27.992222,
        lng=-82.276667,
        housenumber="",
        country="USA",
    ),
    "Woodinville, WA, USA": SportsballGeocodeTuple(
        city="Woodinville",
        state="WA",
        postal="",
        lat=47.7525,
        lng=-122.143056,
        housenumber="",
        country="USA",
    ),
    "Hawthorne, CA, USA": SportsballGeocodeTuple(
        city="Hawthorne",
        state="CA",
        postal="",
        lat=33.917222,
        lng=-118.348611,
        housenumber="",
        country="USA",
    ),
    "Fresno, CA, USA": FRESNO,
    "Jamestown, NY, USA": SportsballGeocodeTuple(
        city="Jamestown",
        state="NY",
        postal="",
        lat=42.095556,
        lng=-79.238611,
        housenumber="",
        country="USA",
    ),
    "The Summit, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.730278,
        lng=-95.435,
        housenumber="3700",
        country="USA",
    ),
    "Folsom, CA, USA": SportsballGeocodeTuple(
        city="Folsom",
        state="CA",
        postal="",
        lat=38.672222,
        lng=-121.157778,
        housenumber="",
        country="USA",
    ),
    "Carlson Center, Fairbanks, Alaska": SportsballGeocodeTuple(
        city="Fairbanks",
        state="AL",
        postal="99701",
        lat=64.842244,
        lng=-147.764081,
        housenumber="2010",
        country="USA",
    ),
    "San Jose Arena, San Jose, California": SAP_CENTER,
    "US Airways Arena, Landover, Maryland": CAPITAL_CENTER,
    "Orlando Arena, Orlando, Florida": ORLANDO_ARENA,
    "Reno, NV, USA": RENO,
    "Larkspur, CA, USA": SportsballGeocodeTuple(
        city="Larkspur",
        state="CA",
        postal="",
        lat=37.934167,
        lng=-122.535278,
        housenumber="",
        country="USA",
    ),
    "Crawford Hall, Irvine, California": SportsballGeocodeTuple(
        city="Irvine",
        state="CA",
        postal="",
        lat=33.647778,
        lng=-117.848056,
        housenumber="",
        country="USA",
    ),
    "Hartford Civic Center, Hartford, Connecticut": PEOPLESBANK_ARENA,
    "CoreStates Spectrum, Philadelphia, Pennsylvania": SPECTRUM,
    "RBC Arena, Raleigh, North Carolina": LENOVO_CENTER,
    "Tacoma Dome, Tacoma, Washington": TACOMA_DOME,
    "Union Multipurpose Activity Center, Tulsa, Oklahoma": SportsballGeocodeTuple(
        city="Tulsa",
        state="OK",
        postal="",
        lat=36.064005,
        lng=-95.869403,
        housenumber="",
        country="USA",
    ),
    "Great Western Forum, Inglewood, California": SportsballGeocodeTuple(
        city="Inglewood",
        state="CA",
        postal="",
        lat=33.958333,
        lng=-118.341667,
        housenumber="3900",
        country="USA",
    ),
    "Hamden, Connecticut": SportsballGeocodeTuple(
        city="Hamden",
        state="CT",
        postal="",
        lat=41.397778,
        lng=-72.921667,
        housenumber="",
        country="USA",
    ),
    "Chattanooga, Tennessee, United States": CHATTANOOGA,
    "Coliseum at Richfield, Richfield, Ohio": SportsballGeocodeTuple(
        city="Richfield",
        state="OH",
        postal="",
        lat=41.245278,
        lng=-81.593889,
        housenumber="2923",
        country="USA",
    ),
    "Joe L. Reed Acadome, Montgomery, Alabama": DUNN_OLIVER_ACADOME,
    "Seattle Center Coliseum, Seattle, Washington": CLIMATE_PLEDGE_ARENA,
    "Omni Coliseum, Atlanta, Georgia": OMNI_COLISEUM,
    "Caldwell, ID, USA": SportsballGeocodeTuple(
        city="Caldwell",
        state="ID",
        postal="",
        lat=43.644444,
        lng=-116.646944,
        housenumber="",
        country="USA",
    ),
    "Calgary, AB, Canada": SportsballGeocodeTuple(
        city="Calgary",
        state="AB",
        postal="",
        lat=51.05,
        lng=-114.066667,
        housenumber="",
        country="Canada",
    ),
    "Hands Oval - Australia": HANDS_OVAL,
    "UTAS Stadium, Launceston": UTAS_STADIUM,
    "Hands Oval": HANDS_OVAL,
    "University of Tasmania Stadium, Launceston": UTAS_STADIUM,
    "Auburn, WA, USA": SportsballGeocodeTuple(
        city="Auburn",
        state="WA",
        postal="",
        lat=47.303889,
        lng=-122.227222,
        housenumber="",
        country="USA",
    ),
    "Quitman, MS, USA": SportsballGeocodeTuple(
        city="Quitman",
        state="MS",
        postal="",
        lat=32.043056,
        lng=-88.720833,
        housenumber="",
        country="USA",
    ),
    "Rancho Cucamonga, CA, USA": SportsballGeocodeTuple(
        city="Rancho Cucamonga",
        state="CA",
        postal="",
        lat=34.123333,
        lng=-117.579444,
        housenumber="",
        country="USA",
    ),
    "The Spectrum, Philadelphia, Pennsylvania": SPECTRUM,
    "Carson, CA, USA": SportsballGeocodeTuple(
        city="Carson",
        state="CA",
        postal="",
        lat=33.839722,
        lng=-118.259722,
        housenumber="",
        country="USA",
    ),
    "Allen, TX, USA": SportsballGeocodeTuple(
        city="Allen",
        state="TX",
        postal="",
        lat=33.126944,
        lng=-96.663056,
        housenumber="",
        country="USA",
    ),
    "Detroit, MI, USA": DETROIT,
    "Claremont, CA, USA": SportsballGeocodeTuple(
        city="Claremont",
        state="CA",
        postal="",
        lat=34.11,
        lng=-117.719722,
        housenumber="",
        country="USA",
    ),
    "Canton, OH, USA": CANTON,
    "South Jordan, UT, USA": SportsballGeocodeTuple(
        city="South Jordan",
        state="UT",
        postal="",
        lat=40.561667,
        lng=-111.960833,
        housenumber="",
        country="USA",
    ),
    "Snellville, GA, USA": SportsballGeocodeTuple(
        city="Snellville",
        state="GA",
        postal="",
        lat=40.561667,
        lng=-111.960833,
        housenumber="",
        country="USA",
    ),
    "Spring Valley, CA, USA": SportsballGeocodeTuple(
        city="Spring Valley",
        state="CA",
        postal="",
        lat=32.734444,
        lng=-116.981389,
        housenumber="",
        country="USA",
    ),
    "Shreveport, LA, USA": SHREVEPORT,
    "Brendan Byrne Arena, East Rutherford, New Jersey": SportsballGeocodeTuple(
        city="East Rutherford",
        state="NJ",
        postal="",
        lat=40.811667,
        lng=-74.0675,
        housenumber="50",
        country="USA",
    ),
    "Beaverton, OR, USA": SportsballGeocodeTuple(
        city="Beaverton",
        state="OR",
        postal="",
        lat=45.477778,
        lng=-122.816667,
        housenumber="",
        country="USA",
    ),
    "Hamburg, Germany": SportsballGeocodeTuple(
        city="Hamburg",
        state="",
        postal="",
        lat=53.55,
        lng=10.0,
        housenumber="",
        country="Germany",
    ),
    "Memphis, TN, USA": MEMPHIS,
    "Sumner, WA, USA": SportsballGeocodeTuple(
        city="Sumner",
        state="WA",
        postal="",
        lat=47.225,
        lng=-122.246667,
        housenumber="",
        country="USA",
    ),
    "White Castle, LA, USA": SportsballGeocodeTuple(
        city="White Castle",
        state="LA",
        postal="",
        lat=30.161111,
        lng=-91.149444,
        housenumber="",
        country="USA",
    ),
    "Capital Centre, Landover, Maryland": CAPITAL_CENTER,
    "Mission Hills, CA, USA": SportsballGeocodeTuple(
        city="Mission Hills",
        state="CA",
        postal="",
        lat=34.257222,
        lng=-118.467222,
        housenumber="",
        country="USA",
    ),
    "Mishawaka, IN, USA": SportsballGeocodeTuple(
        city="Mishawaka",
        state="IN",
        postal="",
        lat=41.654167,
        lng=-86.163333,
        housenumber="",
        country="USA",
    ),
    "Tumwater, WA, USA": SportsballGeocodeTuple(
        city="Tumwater",
        state="WA",
        postal="",
        lat=47.007778,
        lng=-122.911111,
        housenumber="",
        country="USA",
    ),
    "Anderson, SC, USA": SportsballGeocodeTuple(
        city="Anderson",
        state="SC",
        postal="",
        lat=34.503333,
        lng=-82.650278,
        housenumber="",
        country="USA",
    ),
    "Canyon Country, CA, USA": SportsballGeocodeTuple(
        city="Canyon Country",
        state="CA",
        postal="",
        lat=34.42,
        lng=-118.45,
        housenumber="",
        country="USA",
    ),
    "Port Neches, TX, USA": SportsballGeocodeTuple(
        city="Port Neches",
        state="TX",
        postal="",
        lat=29.988889,
        lng=-93.961667,
        housenumber="",
        country="USA",
    ),
    "Seibert Hall, Birmingham, Alabama": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.4643,
        lng=-86.7959,
        housenumber="",
        country="USA",
    ),
    "Martinsburg, WV, USA": SportsballGeocodeTuple(
        city="Martinsburg",
        state="WV",
        postal="",
        lat=39.453611,
        lng=-77.995556,
        housenumber="",
        country="USA",
    ),
    "Lehi, UT, USA": SportsballGeocodeTuple(
        city="Lehi",
        state="UT",
        postal="",
        lat=40.387778,
        lng=-111.871667,
        housenumber="",
        country="USA",
    ),
    "Ontario, CA, USA": SportsballGeocodeTuple(
        city="Ontario",
        state="CA",
        postal="",
        lat=34.052778,
        lng=-117.627778,
        housenumber="",
        country="USA",
    ),
    "Brentwood, CA, USA": SportsballGeocodeTuple(
        city="Brentwood",
        state="CA",
        postal="",
        lat=37.931944,
        lng=-121.695833,
        housenumber="",
        country="USA",
    ),
    "Scottsdale, AZ, USA": SCOTTSDALE,
    "Moorhead, MN, USA": SportsballGeocodeTuple(
        city="Moorhead",
        state="MN",
        postal="",
        lat=46.873889,
        lng=-96.767222,
        housenumber="",
        country="USA",
    ),
    "Orange, CA, USA": SportsballGeocodeTuple(
        city="Orange",
        state="CA",
        postal="",
        lat=33.803056,
        lng=-117.8325,
        housenumber="",
        country="USA",
    ),
    "Puyallup, WA, USA": SportsballGeocodeTuple(
        city="Puyallup",
        state="WA",
        postal="",
        lat=47.175556,
        lng=-122.272222,
        housenumber="",
        country="USA",
    ),
    "Valdosta, GA, USA": SportsballGeocodeTuple(
        city="Valdosta",
        state="GA",
        postal="",
        lat=30.846667,
        lng=-83.283056,
        housenumber="",
        country="USA",
    ),
    "Columbia, MO, USA": SportsballGeocodeTuple(
        city="Columbia",
        state="MO",
        postal="",
        lat=38.9475,
        lng=-92.326667,
        housenumber="",
        country="USA",
    ),
    "Homestead, FL, USA": SportsballGeocodeTuple(
        city="Homestead",
        state="FL",
        postal="",
        lat=25.468722,
        lng=-80.477557,
        housenumber="",
        country="USA",
    ),
    "Virginia Beach, VA, USA": SportsballGeocodeTuple(
        city="Virginia Beach",
        state="VA",
        postal="",
        lat=36.85,
        lng=-75.977778,
        housenumber="",
        country="USA",
    ),
    "Greer, SC, USA": SportsballGeocodeTuple(
        city="Greer",
        state="SC",
        postal="",
        lat=34.930278,
        lng=-82.225,
        housenumber="",
        country="USA",
    ),
    "Eminence, KY, USA": SportsballGeocodeTuple(
        city="Eminence",
        state="KY",
        postal="",
        lat=38.363611,
        lng=-85.177778,
        housenumber="",
        country="USA",
    ),
    "St. Petersburg, FL, USA": ST_PETERSBURG,
    "Nicholls, GA, USA": SportsballGeocodeTuple(
        city="Nicholls",
        state="GA",
        postal="",
        lat=31.516944,
        lng=-82.637778,
        housenumber="",
        country="USA",
    ),
    "Columbus, GA, USA": SportsballGeocodeTuple(
        city="Columbus",
        state="GA",
        postal="",
        lat=32.492222,
        lng=-84.940278,
        housenumber="",
        country="USA",
    ),
    "Ascot, England": SportsballGeocodeTuple(
        city="Ascot",
        state="",
        postal="",
        lat=51.4084,
        lng=-0.6707,
        housenumber="",
        country="UK",
    ),
    "Douglasville, GA, USA": SportsballGeocodeTuple(
        city="Douglasville",
        state="GA",
        postal="",
        lat=33.751389,
        lng=-84.747778,
        housenumber="",
        country="USA",
    ),
    "Miami, FL, USA": MIAMI,
    "Knoxville, TN, USA": KNOXVILLE,
    "Bradenton, FL, USA": SportsballGeocodeTuple(
        city="Bradenton",
        state="FL",
        postal="",
        lat=27.483333,
        lng=-82.583333,
        housenumber="",
        country="USA",
    ),
    "Henderson, KY, USA": SportsballGeocodeTuple(
        city="Henderson",
        state="KY",
        postal="",
        lat=37.835556,
        lng=-87.580833,
        housenumber="",
        country="USA",
    ),
    "Inglewood, CA, USA": SportsballGeocodeTuple(
        city="Inglewood",
        state="CA",
        postal="",
        lat=33.9575,
        lng=-118.346111,
        housenumber="",
        country="USA",
    ),
    "Saline, MI, USA": SportsballGeocodeTuple(
        city="Saline",
        state="MI",
        postal="",
        lat=42.170833,
        lng=-83.779722,
        housenumber="",
        country="USA",
    ),
    "Tampa, FL, USA": TAMPA,
    "Hebron, KY, USA": SportsballGeocodeTuple(
        city="Hebron",
        state="KY",
        postal="",
        lat=39.0625,
        lng=-84.709722,
        housenumber="",
        country="USA",
    ),
    "Lagrange, KY, USA": SportsballGeocodeTuple(
        city="Lagrange",
        state="KY",
        postal="",
        lat=38.398611,
        lng=-85.375,
        housenumber="",
        country="USA",
    ),
    "Lilburn, GA, USA": SportsballGeocodeTuple(
        city="Lilburn",
        state="GA",
        postal="",
        lat=33.888889,
        lng=-84.140833,
        housenumber="",
        country="USA",
    ),
    "Austin, TX, USA": AUSTIN,
    "Noblesville, IN, USA": SportsballGeocodeTuple(
        city="Noblesville",
        state="IN",
        postal="",
        lat=40.025,
        lng=-85.952778,
        housenumber="",
        country="USA",
    ),
    "Forsyth, GA, USA": SportsballGeocodeTuple(
        city="Forsyth",
        state="GA",
        postal="",
        lat=33.035,
        lng=-83.938056,
        housenumber="",
        country="USA",
    ),
    "Cleveland, OH, USA": CLEVELAND,
    "Sunnyvale, TX, USA": SportsballGeocodeTuple(
        city="Sunnyvale",
        state="TX",
        postal="",
        lat=32.803611,
        lng=-96.569722,
        housenumber="",
        country="USA",
    ),
    "Farrell, PA, USA": SportsballGeocodeTuple(
        city="Farrell",
        state="PA",
        postal="",
        lat=41.211667,
        lng=-80.494167,
        housenumber="",
        country="USA",
    ),
    "Shelby, NC, USA": SportsballGeocodeTuple(
        city="Shelby",
        state="NC",
        postal="",
        lat=35.290278,
        lng=-81.545278,
        housenumber="",
        country="USA",
    ),
    "Jacksonville, AR, USA": SportsballGeocodeTuple(
        city="Jacksonville",
        state="AR",
        postal="",
        lat=34.873056,
        lng=-92.115278,
        housenumber="",
        country="USA",
    ),
    "Louisville, KY, USA": LOUISVILLE,
    "Irondale, AL, USA": SportsballGeocodeTuple(
        city="Irondale",
        state="AL",
        postal="",
        lat=33.531944,
        lng=-86.686944,
        housenumber="",
        country="USA",
    ),
    "Overland Park, KS, USA": SportsballGeocodeTuple(
        city="Overland Park",
        state="KS",
        postal="",
        lat=38.886944,
        lng=-94.686944,
        housenumber="",
        country="USA",
    ),
    "Elon, NC, USA": ELON,
    "Alabaster, AL, USA": SportsballGeocodeTuple(
        city="Alabaster",
        state="AL",
        postal="",
        lat=33.231162,
        lng=-86.823829,
        housenumber="",
        country="USA",
    ),
    "Germantown, TN, USA": SportsballGeocodeTuple(
        city="Germantown",
        state="TN",
        postal="",
        lat=35.088889,
        lng=-89.793889,
        housenumber="",
        country="USA",
    ),
    "UFCU Stadium - San Marcos - TX - 78666": SportsballGeocodeTuple(
        city="San Marcos",
        state="TX",
        postal="78666",
        lat=29.891111,
        lng=-97.925556,
        housenumber="1100",
        country="USA",
    ),
    "Lithia, FL, USA": SportsballGeocodeTuple(
        city="Lithia",
        state="FL",
        postal="",
        lat=27.850278,
        lng=-82.174722,
        housenumber="",
        country="USA",
    ),
    "Houston, TX, USA": HOUSTON,
    "Midlothian, TX, USA": SportsballGeocodeTuple(
        city="Midlothian",
        state="TX",
        postal="",
        lat=32.506944,
        lng=-97.006944,
        housenumber="",
        country="USA",
    ),
    "Cincinnati, OH, USA": CINCINNATI,
    "Crosby, TX, USA": SportsballGeocodeTuple(
        city="Crosby",
        state="TX",
        postal="",
        lat=29.910577,
        lng=-95.060882,
        housenumber="",
        country="USA",
    ),
    "Edna, TX, USA": SportsballGeocodeTuple(
        city="Edna",
        state="TX",
        postal="",
        lat=28.978611,
        lng=-96.646111,
        housenumber="",
        country="USA",
    ),
    "Nacogdoches, TX, USA": NACOGDOCHES,
    "Madisonville, TX, USA": SportsballGeocodeTuple(
        city="Madisonville",
        state="TX",
        postal="",
        lat=30.950833,
        lng=-95.9125,
        housenumber="",
        country="USA",
    ),
    "Ennis, TX, USA": SportsballGeocodeTuple(
        city="Ennis",
        state="TX",
        postal="",
        lat=32.329444,
        lng=-96.625278,
        housenumber="",
        country="USA",
    ),
    "Phenix City, AL, USA": SportsballGeocodeTuple(
        city="Phenix City",
        state="AL",
        postal="",
        lat=32.470833,
        lng=-85.002778,
        housenumber="",
        country="USA",
    ),
    "Liberty Hill, TX, USA": SportsballGeocodeTuple(
        city="Liberty Hill",
        state="TX",
        postal="",
        lat=30.655556,
        lng=-97.913889,
        housenumber="",
        country="USA",
    ),
    "Southaven, MS, USA": SOUTHAVEN,
    "Chagrin Falls, OH, USA": SportsballGeocodeTuple(
        city="Chagrin Falls",
        state="OH",
        postal="",
        lat=41.431111,
        lng=-81.388611,
        housenumber="",
        country="USA",
    ),
    "Lynwood, CA, USA": SportsballGeocodeTuple(
        city="Lynwood",
        state="CA",
        postal="",
        lat=33.924722,
        lng=-118.201944,
        housenumber="",
        country="USA",
    ),
    "Hebron, TX, USA": SportsballGeocodeTuple(
        city="Hebron",
        state="TX",
        postal="",
        lat=33.026389,
        lng=-96.863611,
        housenumber="",
        country="USA",
    ),
    "Pensacola, FL, USA": PENSACOLA,
    "Frisco, TX, USA": SportsballGeocodeTuple(
        city="Frisco",
        state="TX",
        postal="",
        lat=33.141667,
        lng=-96.821667,
        housenumber="",
        country="USA",
    ),
    "Rowlett, TX, USA": SportsballGeocodeTuple(
        city="Rowlett",
        state="TX",
        postal="",
        lat=32.902778,
        lng=-96.544444,
        housenumber="",
        country="USA",
    ),
    "Charlotte, NC, USA": CHARLOTTE,
    "Sugar Land, TX, USA": SportsballGeocodeTuple(
        city="Sugar Land",
        state="TX",
        postal="",
        lat=29.599444,
        lng=-95.614167,
        housenumber="",
        country="USA",
    ),
    "Elgin, TX, USA": SportsballGeocodeTuple(
        city="Elgin",
        state="TX",
        postal="",
        lat=30.348611,
        lng=-97.3725,
        housenumber="",
        country="USA",
    ),
    "Duluth, GA, USA": DULUTH,
    "Pittsburgh, PA, USA": PITTSBURGH,
    "Ashtabula, OH, USA": SportsballGeocodeTuple(
        city="Ashtabula",
        state="OH",
        postal="",
        lat=41.874444,
        lng=-80.795833,
        housenumber="",
        country="USA",
    ),
    "Salem, OR, USA": SportsballGeocodeTuple(
        city="Salem",
        state="OR",
        postal="",
        lat=44.923056,
        lng=-123.024444,
        housenumber="",
        country="USA",
    ),
    "Mansfield, OH, USA": SportsballGeocodeTuple(
        city="Mansfield",
        state="OH",
        postal="",
        lat=40.753333,
        lng=-82.504444,
        housenumber="",
        country="USA",
    ),
    "Springfield, IL, USA": SPRINGFIELD,
    "Carrollton, TX, USA": SportsballGeocodeTuple(
        city="Carrollton",
        state="TX",
        postal="",
        lat=32.953611,
        lng=-96.890278,
        housenumber="",
        country="USA",
    ),
    "Little Rock, AR, USA": LITTLE_ROCK,
    "Plaquemine, LA, USA": SportsballGeocodeTuple(
        city="Plaquemine",
        state="LA",
        postal="",
        lat=30.281389,
        lng=-91.248889,
        housenumber="",
        country="USA",
    ),
    "Ahoskie, NC, USA": SportsballGeocodeTuple(
        city="Ahoskie",
        state="NC",
        postal="",
        lat=36.284167,
        lng=-76.99,
        housenumber="",
        country="USA",
    ),
    "Nashville, AR, USA": SportsballGeocodeTuple(
        city="Nashville",
        state="AR",
        postal="",
        lat=33.94826,
        lng=-93.84704,
        housenumber="",
        country="USA",
    ),
    "New Braunfels, TX, USA": SportsballGeocodeTuple(
        city="New Braunfels",
        state="TX",
        postal="",
        lat=29.725,
        lng=-98.125556,
        housenumber="",
        country="USA",
    ),
    "Lee, FL, USA": SportsballGeocodeTuple(
        city="Lee",
        state="FL",
        postal="",
        lat=30.419444,
        lng=-83.299722,
        housenumber="",
        country="USA",
    ),
    "Dana Point, CA, USA": SportsballGeocodeTuple(
        city="Dana Point",
        state="CA",
        postal="",
        lat=33.467222,
        lng=-117.698056,
        housenumber="",
        country="USA",
    ),
    "Atlanta, GA, USA": ATLANTA,
    "Waynesville, MO, USA": SportsballGeocodeTuple(
        city="Waynesville",
        state="MO",
        postal="",
        lat=37.82,
        lng=-92.220278,
        housenumber="",
        country="USA",
    ),
    "Waterford, MI, USA": SportsballGeocodeTuple(
        city="Waterford",
        state="MI",
        postal="",
        lat=42.658333,
        lng=-83.386111,
        housenumber="",
        country="USA",
    ),
    "Leander, TX, USA": SportsballGeocodeTuple(
        city="Leander",
        state="TX",
        postal="",
        lat=30.578889,
        lng=-97.853056,
        housenumber="",
        country="USA",
    ),
    "Waxahachie, TX, USA": SportsballGeocodeTuple(
        city="Waxahachie",
        state="TX",
        postal="",
        lat=32.391667,
        lng=-96.844444,
        housenumber="",
        country="USA",
    ),
    "Sumter, SC, USA": SportsballGeocodeTuple(
        city="Sumter",
        state="SC",
        postal="",
        lat=33.920556,
        lng=-80.341667,
        housenumber="",
        country="USA",
    ),
    "Newport, KY, USA": SportsballGeocodeTuple(
        city="Newport",
        state="KY",
        postal="",
        lat=39.088611,
        lng=-84.490278,
        housenumber="",
        country="USA",
    ),
    "Midland, TX, USA": SportsballGeocodeTuple(
        city="Midland",
        state="TX",
        postal="",
        lat=32.0,
        lng=-102.1,
        housenumber="",
        country="USA",
    ),
    "Cleveland, TX, USA": SportsballGeocodeTuple(
        city="Cleveland",
        state="TX",
        postal="",
        lat=30.345,
        lng=-95.083611,
        housenumber="",
        country="USA",
    ),
    "La Mirada, CA, USA": SportsballGeocodeTuple(
        city="La Mirada",
        state="CA",
        postal="",
        lat=33.902222,
        lng=-118.009722,
        housenumber="",
        country="USA",
    ),
    "New Orleans, LA, USA": NEW_ORLEANS_CITY,
    "Slidell, LA, USA": SportsballGeocodeTuple(
        city="Slidell",
        state="LA",
        postal="",
        lat=30.279167,
        lng=-89.777778,
        housenumber="",
        country="USA",
    ),
    "Bryan, TX, USA": SportsballGeocodeTuple(
        city="Bryan",
        state="TX",
        postal="",
        lat=30.674444,
        lng=-96.37,
        housenumber="",
        country="USA",
    ),
    "Marseille, France": SportsballGeocodeTuple(
        city="Marseille",
        state="",
        postal="",
        lat=43.2964,
        lng=5.37,
        housenumber="",
        country="France",
    ),
    "Rusk, TX, USA": SportsballGeocodeTuple(
        city="Rusk",
        state="TX",
        postal="",
        lat=31.795556,
        lng=-95.15,
        housenumber="",
        country="USA",
    ),
    "Stafford, TX, USA": SportsballGeocodeTuple(
        city="Stafford",
        state="TX",
        postal="",
        lat=29.624167,
        lng=-95.563333,
        housenumber="",
        country="USA",
    ),
    "Cypress, TX, USA": SportsballGeocodeTuple(
        city="Cypress",
        state="TX",
        postal="",
        lat=29.970833,
        lng=-95.697222,
        housenumber="",
        country="USA",
    ),
    "Plano, TX, USA": SportsballGeocodeTuple(
        city="Plano",
        state="TX",
        postal="",
        lat=33.050278,
        lng=-96.698889,
        housenumber="",
        country="USA",
    ),
    "Lumberton, TX, USA": SportsballGeocodeTuple(
        city="Lumberton",
        state="TX",
        postal="",
        lat=30.236111,
        lng=-94.229722,
        housenumber="",
        country="USA",
    ),
    "Brisbane, QLD, Australia": SportsballGeocodeTuple(
        city="Brisbane",
        state="QLD",
        postal="",
        lat=-27.467778,
        lng=153.028056,
        housenumber="",
        country="Australia",
    ),
    "Anna, TX, USA": SportsballGeocodeTuple(
        city="Anna",
        state="TX",
        postal="",
        lat=33.355556,
        lng=-96.561944,
        housenumber="",
        country="USA",
    ),
    "Kilgore, TX, USA": SportsballGeocodeTuple(
        city="Kilgore",
        state="TX",
        postal="",
        lat=32.385556,
        lng=-94.868611,
        housenumber="",
        country="USA",
    ),
    "Aubrey, TX, USA": SportsballGeocodeTuple(
        city="Aubrey",
        state="TX",
        postal="",
        lat=33.307222,
        lng=-96.983889,
        housenumber="",
        country="USA",
    ),
    "Nolensville, TN, USA": SportsballGeocodeTuple(
        city="Nolensville",
        state="TN",
        postal="",
        lat=35.956667,
        lng=-86.666944,
        housenumber="",
        country="USA",
    ),
    "Humble, TX, USA": SportsballGeocodeTuple(
        city="Aubrey",
        state="TX",
        postal="",
        lat=29.995,
        lng=-95.265,
        housenumber="",
        country="USA",
    ),
    "Deer Park, TX, USA": SportsballGeocodeTuple(
        city="Aubrey",
        state="TX",
        postal="",
        lat=29.692003,
        lng=-95.118108,
        housenumber="",
        country="USA",
    ),
    "Ventura, CA, USA": SportsballGeocodeTuple(
        city="Ventura",
        state="CA",
        postal="",
        lat=34.275,
        lng=-119.227778,
        housenumber="",
        country="USA",
    ),
    "Bendigo, VIC, Australia": SportsballGeocodeTuple(
        city="Bendigo",
        state="VIC",
        postal="",
        lat=-36.75,
        lng=144.266667,
        housenumber="",
        country="Australia",
    ),
    "Providence, UT, USA": SportsballGeocodeTuple(
        city="Providence",
        state="UT",
        postal="",
        lat=41.703333,
        lng=-111.813333,
        housenumber="",
        country="USA",
    ),
    "West Jordan, UT, USA": SportsballGeocodeTuple(
        city="West Jordan",
        state="UT",
        postal="",
        lat=40.606389,
        lng=-111.976111,
        housenumber="",
        country="USA",
    ),
    "Las Vegas, NV, USA": LAS_VEGAS,
    "Aledo, TX, USA": SportsballGeocodeTuple(
        city="Aledo",
        state="TX",
        postal="",
        lat=32.705,
        lng=-97.615556,
        housenumber="",
        country="USA",
    ),
    "Minneola, FL, USA": SportsballGeocodeTuple(
        city="Minneola",
        state="FL",
        postal="",
        lat=28.606667,
        lng=-81.732222,
        housenumber="",
        country="USA",
    ),
    "Rigby, ID, USA": SportsballGeocodeTuple(
        city="Rigby",
        state="ID",
        postal="",
        lat=43.673333,
        lng=-111.913333,
        housenumber="",
        country="USA",
    ),
    "Woods Cross, UT, USA": SportsballGeocodeTuple(
        city="Woods Cross",
        state="UT",
        postal="",
        lat=40.876667,
        lng=-111.916111,
        housenumber="",
        country="USA",
    ),
    "Winter Haven, FL, USA": SportsballGeocodeTuple(
        city="Winter Haven",
        state="FL",
        postal="",
        lat=28.023056,
        lng=-81.734444,
        housenumber="",
        country="USA",
    ),
    "San Mateo, CA, USA": SportsballGeocodeTuple(
        city="San Mateo",
        state="CA",
        postal="",
        lat=37.554167,
        lng=-122.313056,
        housenumber="",
        country="USA",
    ),
    "Idaho Falls, ID, USA": SportsballGeocodeTuple(
        city="Idaho Falls",
        state="ID",
        postal="",
        lat=43.500556,
        lng=-112.027778,
        housenumber="",
        country="USA",
    ),
    "Mission Viejo, CA, USA": SportsballGeocodeTuple(
        city="Mission Viejo",
        state="CA",
        postal="",
        lat=33.596944,
        lng=-117.658333,
        housenumber="",
        country="USA",
    ),
    "Magna, UT, USA": SportsballGeocodeTuple(
        city="Magna",
        state="UT",
        postal="",
        lat=40.722222,
        lng=-112.076667,
        housenumber="",
        country="USA",
    ),
    "Pasadena, CA, USA": PASADENA,
    "Rock Hill, SC, USA": ROCK_HILL,
    "Rocklin, CA, USA": SportsballGeocodeTuple(
        city="Rocklin",
        state="CA",
        postal="",
        lat=38.8,
        lng=-121.246667,
        housenumber="",
        country="USA",
    ),
    "Rancho Santa Margarita, CA, USA": SportsballGeocodeTuple(
        city="Rancho Santa Margarita",
        state="CA",
        postal="",
        lat=33.641389,
        lng=-117.594444,
        housenumber="",
        country="USA",
    ),
    "Los Angeles, CA, USA": LOS_ANGELES,
    "Auckland, New Zealand": SportsballGeocodeTuple(
        city="Auckland",
        state="",
        postal="",
        lat=-36.849167,
        lng=174.765278,
        housenumber="",
        country="New Zealand",
    ),
    "Rosenberg, TX, USA": SportsballGeocodeTuple(
        city="Rosenberg",
        state="TX",
        postal="",
        lat=29.5525,
        lng=-95.805,
        housenumber="",
        country="USA",
    ),
    "Gold Coast, QLD, Australia": SportsballGeocodeTuple(
        city="Gold Coast",
        state="QLD",
        postal="",
        lat=-28.016667,
        lng=153.4,
        housenumber="",
        country="Australia",
    ),
    "Pleasant Grove, UT, USA": SportsballGeocodeTuple(
        city="Pleasant Grove",
        state="UT",
        postal="",
        lat=40.370278,
        lng=-111.748056,
        housenumber="",
        country="USA",
    ),
    "Hauula, HI, USA": SportsballGeocodeTuple(
        city="Hauula",
        state="HI",
        postal="",
        lat=21.613889,
        lng=-157.913611,
        housenumber="",
        country="USA",
    ),
    "Midvale, UT, USA": SportsballGeocodeTuple(
        city="Midvale",
        state="UT",
        postal="",
        lat=40.613889,
        lng=-111.888333,
        housenumber="",
        country="USA",
    ),
    "Bluffdale, UT, USA": SportsballGeocodeTuple(
        city="Bluffdale",
        state="UT",
        postal="",
        lat=40.473333,
        lng=-111.944444,
        housenumber="",
        country="USA",
    ),
    "Rahway, NJ, USA": SportsballGeocodeTuple(
        city="Rahway",
        state="NJ",
        postal="",
        lat=40.607152,
        lng=-74.280531,
        housenumber="",
        country="USA",
    ),
    "American Fork, UT, USA": SportsballGeocodeTuple(
        city="American Fork",
        state="UT",
        postal="",
        lat=40.361111,
        lng=-111.790556,
        housenumber="",
        country="USA",
    ),
    "Queen Creek, AZ, USA": SportsballGeocodeTuple(
        city="Queen Creek",
        state="AZ",
        postal="",
        lat=33.248611,
        lng=-111.634167,
        housenumber="",
        country="USA",
    ),
    "Monument, CO, USA": SportsballGeocodeTuple(
        city="Monument",
        state="CO",
        postal="",
        lat=39.081111,
        lng=-104.8625,
        housenumber="",
        country="USA",
    ),
    "Prosper, TX, USA": SportsballGeocodeTuple(
        city="Prosper",
        state="TX",
        postal="",
        lat=33.245833,
        lng=-96.840833,
        housenumber="",
        country="USA",
    ),
    "Peoria, AZ, USA": SportsballGeocodeTuple(
        city="Peoria",
        state="AZ",
        postal="",
        lat=33.5825,
        lng=-112.238611,
        housenumber="",
        country="USA",
    ),
    "Vienna, VA, USA": SportsballGeocodeTuple(
        city="Vienna",
        state="VA",
        postal="",
        lat=38.9,
        lng=-77.266667,
        housenumber="",
        country="USA",
    ),
    "Sioux Falls, SD, USA": SIOUX_FALLS,
    "Richmond, TX, USA": SportsballGeocodeTuple(
        city="Richmond",
        state="TX",
        postal="",
        lat=29.582222,
        lng=-95.760833,
        housenumber="",
        country="USA",
    ),
    "Stockton, CA, USA": STOCKTON,
    "Anahuac, TX, USA": SportsballGeocodeTuple(
        city="Anahuac",
        state="TX",
        postal="",
        lat=29.756944,
        lng=-94.681389,
        housenumber="",
        country="USA",
    ),
    "Pomona, CA, USA": SportsballGeocodeTuple(
        city="Pomona",
        state="CA",
        postal="",
        lat=34.060833,
        lng=-117.755833,
        housenumber="",
        country="USA",
    ),
    "North Salt Lake, UT, USA": SportsballGeocodeTuple(
        city="North Salt Lake",
        state="UT",
        postal="",
        lat=40.840278,
        lng=-111.904167,
        housenumber="",
        country="USA",
    ),
    "Boston, MA, USA": BOSTON,
    "Spanish Fork, UT, USA": SportsballGeocodeTuple(
        city="Spanish Fork",
        state="UT",
        postal="",
        lat=40.115,
        lng=-111.638333,
        housenumber="",
        country="USA",
    ),
    "Fairfield, CA, USA": SportsballGeocodeTuple(
        city="Fairfield",
        state="CA",
        postal="",
        lat=38.257778,
        lng=-122.054167,
        housenumber="",
        country="USA",
    ),
    "Winchester, VA, USA": SportsballGeocodeTuple(
        city="Winchester",
        state="VA",
        postal="",
        lat=39.183333,
        lng=-78.166667,
        housenumber="",
        country="USA",
    ),
    "Bellflower, CA, USA": SportsballGeocodeTuple(
        city="Bellflower",
        state="CA",
        postal="",
        lat=33.888056,
        lng=-118.1275,
        housenumber="",
        country="USA",
    ),
    "Randolph, MA, USA": SportsballGeocodeTuple(
        city="Randolph",
        state="MA",
        postal="",
        lat=42.1625,
        lng=-71.041667,
        housenumber="",
        country="USA",
    ),
    "Phoenix, AZ, USA": PHOENIX,
    "St. George, UT, USA": ST_GEORGE,
    "Garland, UT, USA": SportsballGeocodeTuple(
        city="Garland",
        state="UT",
        postal="",
        lat=41.736111,
        lng=-112.162778,
        housenumber="",
        country="USA",
    ),
    "ARCO Arena (I), Sacramento, California": ARCO_ARENA,
    "Pepsi Arena, Albany, New York": MVP_ARENA,
    "Martin Stadium - Evanston - IL - 60208": LANNY_AND_SHARON_MARTIN_STADIUM,
    "Arizona Veterans Memorial Coliseum, Phoenix, Arizona": SportsballGeocodeTuple(
        city="Phoenix",
        state="AZ",
        postal="",
        lat=33.469444,
        lng=-112.096667,
        housenumber="1826",
        country="USA",
    ),
    "Pontiac Silverdome, Pontiac, Michigan": SILVERDOME,
    "Tylertown, Mississippi, United States": SportsballGeocodeTuple(
        city="Tylertown",
        state="MS",
        postal="",
        lat=31.116111,
        lng=-90.142778,
        housenumber="",
        country="USA",
    ),
    "MECCA Arena, Milwaukee, Wisconsin": MILWAUKEE_ARENA,
    "Seattle Kingdome, Seattle, Washington": LUMEN_FIELD,
    "Martin Stadium - Pullman - WA - 99164": MARTIN_STADIUM,
    "Northwest Stadium - Landover, Maryland, USA - United States": FEDEX_FIELD,
    "Flagler Credit Union Stadium - Boca Raton - FL - 33431": FAU_STADIUM,
    "Freedom Hall - Louisville, Kentucky - United States": FREEDOM_HALL,
    "Finneran Pavilion - Villanova, Pennsylvania - United States": FINNERAN_PAVILION,
    "University of Phoenix Stadium": STATE_FARM_STADIUM,
    "Alamodome - San Antonio, Texas, USA - United States": ALAMODOME,
    "Prudential Center - Newark, New Jersey, USA - United States": PRUDENTIAL_CENTER,
    "Roberts Stadium": ROBERTS_STADIUM,
    "Sports Arena": ARCO_ARENA,
    "Veterans Memorial Auditorium": SportsballGeocodeTuple(
        city="Providence",
        state="RI",
        postal="",
        lat=41.829847,
        lng=-71.417425,
        housenumber="",
        country="USA",
    ),
    "Pittsburgh Civic Arena": CIVIC_ARENA,
    "University Arena, Albuquerque, New Mexico": THE_PIT,
    "Long Beach Arena": LONG_BEACH_ARENA,
    "Las Vegas Convention Center": SportsballGeocodeTuple(
        city="Las Vegas",
        state="NV",
        postal="",
        lat=36.131516,
        lng=-115.151507,
        housenumber="3150",
        country="USA",
    ),
    "Mid-South Coliseum": MID_SOUTH_COLISEUM,
    "Dean Smith Center - Chapel Hill, North Carolina, USA - United States": DEAN_SMITH_CENTER,
    "Charleston Civic Center": CHARLESTON_CIVIC_CENTER,
    "Greensboro Coliseum": GREENSBORO_COLISEUM,
    "Montreal Forum": SportsballGeocodeTuple(
        city="Montreal",
        state="QC",
        postal="",
        lat=45.490278,
        lng=-73.584722,
        housenumber="2313",
        country="Canada",
    ),
    "Roberts Municipal Stadium": SportsballGeocodeTuple(
        city="Evansville",
        state="IN",
        postal="47711",
        lat=37.97903,
        lng=-87.515926,
        housenumber="2600",
        country="USA",
    ),
    "Selland Arena": SELLAND_ARENA,
    "Carolina Coliseum": SportsballGeocodeTuple(
        city="Columbia",
        state="SC",
        postal="29201",
        lat=37.97903,
        lng=-87.515926,
        housenumber="701",
        country="USA",
    ),
    "Washington College": SportsballGeocodeTuple(
        city="Chestertown",
        state="MD",
        postal="",
        lat=39.218056,
        lng=-76.069444,
        housenumber="",
        country="USA",
    ),
    "Illinois State College": SportsballGeocodeTuple(
        city="Normal",
        state="IL",
        postal="",
        lat=40.511,
        lng=-88.993,
        housenumber="",
        country="USA",
    ),
    "BankUnited Center": WATSO_CENTER,
    "Maple Leaf Gardens - Toronto, Ontario - United States": MAPLE_LEAF_GARDENS,
    "El Paso County Coliseum": SportsballGeocodeTuple(
        city="El Paso",
        state="TX",
        postal="79905",
        lat=31.766389,
        lng=-106.443056,
        housenumber="4100",
        country="USA",
    ),
    "Providence Civic Center": AMICA_MUTUAL_PAVILION,
    "Hartford Civic Center - Hartford, Connecticut - United States": PEOPLESBANK_ARENA,
    "Nassau Veterans Memorial Coliseum - Uniondale, New York, USA - United States": NASSAU_COLISEUM,
    "Sacramento State College": SportsballGeocodeTuple(
        city="Sacramento",
        state="CA",
        postal="",
        lat=38.560222,
        lng=-121.424111,
        housenumber="",
        country="USA",
    ),
    "Weber State College": WEBER_STATE_COLLEGE,
    "Mississippi Coast Coliseum": MISSISSIPPI_COAST_COLISEUM,
    "University of Arizona": UNIVERSITY_OF_ARIZONA,
    "Riverside Centroplex": SportsballGeocodeTuple(
        city="Baton Rouge",
        state="LA",
        postal="",
        lat=30.4448,
        lng=-91.1894,
        housenumber="",
        country="USA",
    ),
    "Duke University": DUKE_UNIVERSITY,
    "Bowling Green College": SportsballGeocodeTuple(
        city="Bowling Green",
        state="OH",
        postal="",
        lat=41.38,
        lng=-83.63,
        housenumber="",
        country="USA",
    ),
    "New Mexico State College": SportsballGeocodeTuple(
        city="Las Cruces",
        state="NM",
        postal="",
        lat=32.283,
        lng=-106.748,
        housenumber="",
        country="USA",
    ),
    "Eastern Michigan College": SportsballGeocodeTuple(
        city="Ypsilanti",
        state="MI",
        postal="",
        lat=42.250154,
        lng=-83.624454,
        housenumber="",
        country="USA",
    ),
    "Kentucky College": UNIVERSITY_OF_KENTUCKY,
    "Iowa College": SportsballGeocodeTuple(
        city="Iowa City",
        state="IA",
        postal="",
        lat=41.661667,
        lng=-91.536389,
        housenumber="",
        country="USA",
    ),
    "UConn College": SportsballGeocodeTuple(
        city="Storrs",
        state="CT",
        postal="",
        lat=41.807222,
        lng=-72.2525,
        housenumber="",
        country="USA",
    ),
    "Marshall College": SportsballGeocodeTuple(
        city="Huntington",
        state="WV",
        postal="",
        lat=38.42508,
        lng=-82.42046,
        housenumber="",
        country="USA",
    ),
    "Miami (FL) College": SportsballGeocodeTuple(
        city="Miami",
        state="FL",
        postal="",
        lat=25.7216,
        lng=-80.2793,
        housenumber="",
        country="USA",
    ),
    "TCU College": SportsballGeocodeTuple(
        city="Fort Worth",
        state="TX",
        postal="",
        lat=32.7096,
        lng=-97.364,
        housenumber="",
        country="USA",
    ),
    "Maryland College": SportsballGeocodeTuple(
        city="College Park",
        state="MD",
        postal="",
        lat=38.988,
        lng=-76.943,
        housenumber="",
        country="USA",
    ),
    "Bowling Green State University": SportsballGeocodeTuple(
        city="Bowling Green",
        state="OH",
        postal="",
        lat=41.38,
        lng=-83.63,
        housenumber="",
        country="USA",
    ),
    "University of Florida": SportsballGeocodeTuple(
        city="Gainesville",
        state="FL",
        postal="",
        lat=29.6475,
        lng=-82.345,
        housenumber="",
        country="USA",
    ),
    "University of Cincinnati": SportsballGeocodeTuple(
        city="Cincinnati",
        state="OH",
        postal="",
        lat=39.132778,
        lng=-84.515278,
        housenumber="",
        country="USA",
    ),
    "Arizona College": UNIVERSITY_OF_ARIZONA,
    "LSU College": SportsballGeocodeTuple(
        city="Baton Rouge",
        state="LA",
        postal="",
        lat=30.4145,
        lng=-91.17826,
        housenumber="",
        country="USA",
    ),
    "University of Rhode Island": SportsballGeocodeTuple(
        city="Kingston",
        state="RI",
        postal="",
        lat=41.48071,
        lng=-71.5258,
        housenumber="",
        country="USA",
    ),
    "Army College": SportsballGeocodeTuple(
        city="West Point",
        state="NY",
        postal="",
        lat=41.393,
        lng=-73.958,
        housenumber="",
        country="USA",
    ),
    "San Jose State College": SportsballGeocodeTuple(
        city="San Jose",
        state="CA",
        postal="",
        lat=37.3353,
        lng=-121.8813,
        housenumber="",
        country="USA",
    ),
    "Toledo College": SportsballGeocodeTuple(
        city="Toledo",
        state="OH",
        postal="",
        lat=41.657716,
        lng=-83.61366,
        housenumber="",
        country="USA",
    ),
    "Eastern Illinois College": SportsballGeocodeTuple(
        city="Charleston",
        state="IL",
        postal="",
        lat=39.484444,
        lng=-88.175278,
        housenumber="",
        country="USA",
    ),
    "University of Alabama": SportsballGeocodeTuple(
        city="Tuscaloosa",
        state="AL",
        postal="",
        lat=33.210833,
        lng=-87.546111,
        housenumber="",
        country="USA",
    ),
    "Boston College College": BOSTON_COLLEGE,
    "UNLV College": SportsballGeocodeTuple(
        city="Las Vegas",
        state="NV",
        postal="",
        lat=36.10779,
        lng=-115.14376,
        housenumber="",
        country="USA",
    ),
    "Amerant Bank Arena, Sunrise, FL, USA": AMERANT_BANK_ARENA,
    "Olympia Stadium": DETROIT_OLYMPIA,
    "Lakefront Arena - New Orleans, Louisiana - United States": LAKEFRONT_ARENA,
    "Michigan College": SportsballGeocodeTuple(
        city="Ann Arbor",
        state="MI",
        postal="",
        lat=42.276944,
        lng=-83.738056,
        housenumber="",
        country="USA",
    ),
    "Mary Hardin-Baylor College": SportsballGeocodeTuple(
        city="Belton",
        state="TX",
        postal="",
        lat=31.0665,
        lng=-97.464,
        housenumber="",
        country="USA",
    ),
    "Holy Cross College": SportsballGeocodeTuple(
        city="Worcester",
        state="MA",
        postal="",
        lat=42.239167,
        lng=-71.808333,
        housenumber="",
        country="USA",
    ),
    "West Texas A&M College": SportsballGeocodeTuple(
        city="Canyon",
        state="TX",
        postal="",
        lat=34.9844,
        lng=-101.9134,
        housenumber="",
        country="USA",
    ),
    "Rogers Place, Edmonton, AB, Canada": ROGERS_PLACE,
    "Oklahoma College": SportsballGeocodeTuple(
        city="Norman",
        state="OK",
        postal="",
        lat=35.2088,
        lng=-97.4457,
        housenumber="",
        country="USA",
    ),
    "Bethune-Cookman College": SportsballGeocodeTuple(
        city="Daytona Beach",
        state="FL",
        postal="",
        lat=29.2103,
        lng=-81.0306,
        housenumber="",
        country="USA",
    ),
    "Lenovo Center, Raleigh, NC, USA": LENOVO_CENTER,
    "Papa John's Cardinal Stadium": LN_FEDERAL_CREDIT_UNION_STADIUM,
    "Nevada College": SportsballGeocodeTuple(
        city="Reno",
        state="NV",
        postal="",
        lat=39.537778,
        lng=-119.813889,
        housenumber="",
        country="USA",
    ),
    "Wisconsin College": SportsballGeocodeTuple(
        city="Madison",
        state="WI",
        postal="",
        lat=43.075278,
        lng=-89.404167,
        housenumber="",
        country="USA",
    ),
    "BYU College": SportsballGeocodeTuple(
        city="Provo",
        state="UT",
        postal="",
        lat=40.25,
        lng=-111.649,
        housenumber="",
        country="USA",
    ),
    "Amerant Bank Arena": AMERANT_BANK_ARENA,
    "Manitoba, Canada": SportsballGeocodeTuple(
        city="",
        state="MB",
        postal="",
        lat=55.0,
        lng=-97.0,
        housenumber="",
        country="Canada",
    ),
    "Robbinsdale, Minnesota, United States": SportsballGeocodeTuple(
        city="Robbinsdale",
        state="MN",
        postal="",
        lat=45.032222,
        lng=-93.338611,
        housenumber="",
        country="USA",
    ),
    "Cole Harbour, Nova Scotia, Canada": SportsballGeocodeTuple(
        city="Cole Harbour",
        state="NS",
        postal="",
        lat=44.671667,
        lng=-63.489722,
        housenumber="",
        country="Canada",
    ),
    "Borlange, Sweden": SportsballGeocodeTuple(
        city="Borlange",
        state="",
        postal="",
        lat=60.485556,
        lng=15.436389,
        housenumber="",
        country="Sweden",
    ),
    "Vasteras, Sweden": SportsballGeocodeTuple(
        city="Vasteras",
        state="",
        postal="",
        lat=59.616111,
        lng=16.552778,
        housenumber="",
        country="Sweden",
    ),
    "Regina, Saskatchewan, Canada": SportsballGeocodeTuple(
        city="Regina",
        state="SK",
        postal="",
        lat=50.454722,
        lng=-104.606667,
        housenumber="",
        country="Canada",
    ),
    "Burnaby, British Columbia, Canada": SportsballGeocodeTuple(
        city="Burnaby",
        state="BC",
        postal="",
        lat=49.266667,
        lng=-122.966667,
        housenumber="",
        country="Canada",
    ),
    "Lagos, Nigeria": SportsballGeocodeTuple(
        city="Lagos",
        state="",
        postal="",
        lat=6.455027,
        lng=3.384082,
        housenumber="",
        country="Nigeria",
    ),
    "Oakville, Ontario, Canada": SportsballGeocodeTuple(
        city="Oakville",
        state="ON",
        postal="",
        lat=43.456389,
        lng=-79.713889,
        housenumber="",
        country="Canada",
    ),
    "Moscow, USSR": MOSCOW,
    "Ljubljana, Slovenia": SportsballGeocodeTuple(
        city="Ljubljana",
        state="",
        postal="",
        lat=46.051389,
        lng=14.506111,
        housenumber="",
        country="Slovenia",
    ),
    "Wichita, Kansas, United States": WICHITA,
    "Austin, Texas, United States": AUSTIN,
    "Stockholm, Sweden": SportsballGeocodeTuple(
        city="Stockholm",
        state="",
        postal="",
        lat=59.329444,
        lng=18.068611,
        housenumber="",
        country="Sweden",
    ),
    "Hinesville, Georgia, United States": SportsballGeocodeTuple(
        city="Robbinsdale",
        state="MN",
        postal="",
        lat=45.032222,
        lng=-93.338611,
        housenumber="",
        country="USA",
    ),
    "Floral, Saskatchewan, Canada": SportsballGeocodeTuple(
        city="Floral",
        state="SK",
        postal="",
        lat=52.056944,
        lng=-106.511111,
        housenumber="",
        country="Canada",
    ),
    "Yaounde, Cameroon": SportsballGeocodeTuple(
        city="Yaounde",
        state="",
        postal="",
        lat=3.866667,
        lng=11.516667,
        housenumber="",
        country="Cameroon",
    ),
    "Vancouver, British Columbia, Canada": SportsballGeocodeTuple(
        city="Vancouver",
        state="BC",
        postal="",
        lat=49.260833,
        lng=-123.113889,
        housenumber="",
        country="Canada",
    ),
    "Boston, Massachusetts, United States": BOSTON,
    "Richmond Hill, Ontario, Canada": SportsballGeocodeTuple(
        city="Richmond Hill",
        state="ON",
        postal="",
        lat=43.871389,
        lng=-79.437222,
        housenumber="",
        country="Canada",
    ),
    "Kuopio, Finland": SportsballGeocodeTuple(
        city="Kuopio",
        state="",
        postal="",
        lat=62.8925,
        lng=27.678333,
        housenumber="",
        country="Finland",
    ),
    "Vienna, Austria": SportsballGeocodeTuple(
        city="Vienna",
        state="",
        postal="",
        lat=48.208333,
        lng=16.3725,
        housenumber="",
        country="Austria",
    ),
    "Edmonton, Alberta, Canada": SportsballGeocodeTuple(
        city="Edmonton",
        state="AB",
        postal="",
        lat=53.534444,
        lng=-113.490278,
        housenumber="",
        country="Canada",
    ),
    "Havre de Grace, Maryland, United States": HAVRE_DE_GRACE,
    "Anahim Lake, British Columbia, Canada": SportsballGeocodeTuple(
        city="Anahim Lake",
        state="BC",
        postal="",
        lat=52.466667,
        lng=-125.316667,
        housenumber="",
        country="Canada",
    ),
    "Las Vegas, Nevada, United States": LAS_VEGAS,
    "Brantford, Ontario, Canada": SportsballGeocodeTuple(
        city="Brantford",
        state="ON",
        postal="",
        lat=43.156944,
        lng=-80.2575,
        housenumber="",
        country="Canada",
    ),
    "Gothenburg, Sweden": SportsballGeocodeTuple(
        city="Gothenburg",
        state="",
        postal="",
        lat=57.7075,
        lng=11.9675,
        housenumber="",
        country="Sweden",
    ),
    "Castries, Saint Lucia": SportsballGeocodeTuple(
        city="Castries",
        state="",
        postal="",
        lat=14.010833,
        lng=-60.989444,
        housenumber="",
        country="Saint Lucia",
    ),
    "Rayville, Louisiana, United States": SportsballGeocodeTuple(
        city="Rayville",
        state="LA",
        postal="",
        lat=32.47,
        lng=-91.7575,
        housenumber="",
        country="USA",
    ),
    "Maykop, Russia": SportsballGeocodeTuple(
        city="Maykop",
        state="",
        postal="",
        lat=44.6,
        lng=40.083333,
        housenumber="",
        country="Russia",
    ),
    "Le Chesnay, France": SportsballGeocodeTuple(
        city="Le Chesnay",
        state="",
        postal="",
        lat=48.8211,
        lng=2.1311,
        housenumber="",
        country="France",
    ),
    "Cologne, Germany": SportsballGeocodeTuple(
        city="Cologne",
        state="",
        postal="",
        lat=50.936389,
        lng=6.952778,
        housenumber="",
        country="Germany",
    ),
    "Baham, Cameroon": SportsballGeocodeTuple(
        city="Baham",
        state="",
        postal="",
        lat=5.333333,
        lng=10.4,
        housenumber="",
        country="Cameroon",
    ),
    "Peterborough, Ontario, Canada": SportsballGeocodeTuple(
        city="Peterborough",
        state="ON",
        postal="",
        lat=44.301111,
        lng=-78.333333,
        housenumber="",
        country="Canada",
    ),
    "Martins Ferry, Ohio, United States": SportsballGeocodeTuple(
        city="Martins Ferry",
        state="OH",
        postal="",
        lat=40.119444,
        lng=-80.718056,
        housenumber="",
        country="USA",
    ),
    "Victoria, British Columbia, Canada": SportsballGeocodeTuple(
        city="Victoria",
        state="BC",
        postal="",
        lat=48.428333,
        lng=-123.364722,
        housenumber="",
        country="Canada",
    ),
    "Montreal, Quebec, Canada": SportsballGeocodeTuple(
        city="Montreal",
        state="QC",
        postal="",
        lat=45.508889,
        lng=-73.554167,
        housenumber="",
        country="Canada",
    ),
    "Winnipeg, Manitoba, Canada": SportsballGeocodeTuple(
        city="Winnipeg",
        state="MB",
        postal="",
        lat=49.895556,
        lng=-97.138611,
        housenumber="",
        country="Canada",
    ),
    "London, Ontario, Canada": SportsballGeocodeTuple(
        city="London",
        state="ON",
        postal="",
        lat=42.9675,
        lng=-81.2325,
        housenumber="",
        country="Canada",
    ),
    "Kladno, Czechoslovakia": SportsballGeocodeTuple(
        city="Kladno",
        state="",
        postal="",
        lat=50.143056,
        lng=14.105278,
        housenumber="",
        country="Czech Republic",
    ),
    "Franklin, Tennessee, United States": SportsballGeocodeTuple(
        city="Franklin",
        state="TN",
        postal="",
        lat=35.929167,
        lng=-86.8575,
        housenumber="",
        country="USA",
    ),
    "Bendigo, Australia": SportsballGeocodeTuple(
        city="Bendigo",
        state="VIC",
        postal="",
        lat=-36.75,
        lng=144.266667,
        housenumber="",
        country="Czech Republic",
    ),
    "Moscow, Russia": MOSCOW,
    "Lubbock, Texas, United States": LUBBOCK,
    "Hamilton, Ontario, Canada": SportsballGeocodeTuple(
        city="Hamilton",
        state="ON",
        postal="",
        lat=43.242778,
        lng=-79.989444,
        housenumber="",
        country="Canada",
    ),
    "Halifax, Nova Scotia, Canada": SportsballGeocodeTuple(
        city="Halifax",
        state="NS",
        postal="",
        lat=44.6475,
        lng=-63.590556,
        housenumber="",
        country="Canada",
    ),
    "Wausau, Wisconsin, United States": SportsballGeocodeTuple(
        city="Wausau",
        state="WI",
        postal="",
        lat=44.95,
        lng=-89.633333,
        housenumber="",
        country="USA",
    ),
    "Grand Rapids, Michigan, United States": SportsballGeocodeTuple(
        city="Grand Rapids",
        state="MI",
        postal="",
        lat=42.963333,
        lng=-85.667778,
        housenumber="",
        country="USA",
    ),
    "Geneva, Switzerland": SportsballGeocodeTuple(
        city="Geneva",
        state="",
        postal="",
        lat=46.201667,
        lng=6.146944,
        housenumber="",
        country="Switzerland",
    ),
    "Richardson, Texas, United States": SportsballGeocodeTuple(
        city="Richardson",
        state="TX",
        postal="",
        lat=32.991667,
        lng=-96.703889,
        housenumber="",
        country="USA",
    ),
    "Strakonice, Czechia": SportsballGeocodeTuple(
        city="Strakonice",
        state="",
        postal="",
        lat=40.889398,
        lng=-74.045698,
        housenumber="",
        country="Czech Republic",
    ),
    "Hackensack, New Jersey, United States": SportsballGeocodeTuple(
        city="Hackensack",
        state="NJ",
        postal="",
        lat=40.889398,
        lng=-74.045698,
        housenumber="",
        country="USA",
    ),
    "Dakar, Senegal": SportsballGeocodeTuple(
        city="Dakar",
        state="",
        postal="",
        lat=14.692778,
        lng=-17.446667,
        housenumber="",
        country="Senegal",
    ),
    "Malaga, Spain": SportsballGeocodeTuple(
        city="Malaga",
        state="",
        postal="",
        lat=36.719444,
        lng=-4.42,
        housenumber="",
        country="Spain",
    ),
    "West Vancouver, British Columbia, Canada": SportsballGeocodeTuple(
        city="West Vancouver",
        state="BC",
        postal="",
        lat=49.366667,
        lng=-123.166667,
        housenumber="",
        country="Canada",
    ),
    "Joliette, Quebec, Canada": SportsballGeocodeTuple(
        city="Joliette",
        state="QC",
        postal="",
        lat=46.016667,
        lng=-73.45,
        housenumber="",
        country="Canada",
    ),
    "Espoo, Finland": SportsballGeocodeTuple(
        city="Espoo",
        state="",
        postal="",
        lat=60.205556,
        lng=24.655556,
        housenumber="",
        country="Finland",
    ),
    "Windsor, Ontario, Canada": SportsballGeocodeTuple(
        city="Windsor",
        state="ON",
        postal="",
        lat=42.302222,
        lng=-82.993611,
        housenumber="",
        country="Canada",
    ),
    "Kiiminki, Finland": SportsballGeocodeTuple(
        city="Kiiminki",
        state="",
        postal="",
        lat=65.133333,
        lng=25.775,
        housenumber="",
        country="Finland",
    ),
    "Pardubice, Czechoslovakia": SportsballGeocodeTuple(
        city="Pardubice",
        state="",
        postal="",
        lat=50.038611,
        lng=15.779167,
        housenumber="",
        country="Czech Republic",
    ),
    "Novokuznetsk, USSR": SportsballGeocodeTuple(
        city="Novokuznetsk",
        state="",
        postal="",
        lat=53.766667,
        lng=87.133333,
        housenumber="",
        country="Russia",
    ),
    "Whitby, Ontario, Canada": SportsballGeocodeTuple(
        city="Whitby",
        state="ON",
        postal="",
        lat=43.9325,
        lng=-78.954444,
        housenumber="",
        country="Canada",
    ),
    "Lipetsk, USSR": SportsballGeocodeTuple(
        city="Lipetsk",
        state="",
        postal="",
        lat=52.616667,
        lng=39.6,
        housenumber="",
        country="Russia",
    ),
    "Holland Landing, Ontario, Canada": SportsballGeocodeTuple(
        city="Holland Landing",
        state="ON",
        postal="",
        lat=44.089444,
        lng=-79.495,
        housenumber="",
        country="Canada",
    ),
    "St. Cloud, Minnesota, United States": SportsballGeocodeTuple(
        city="St. Cloud",
        state="MN",
        postal="",
        lat=45.534167,
        lng=-94.171667,
        housenumber="",
        country="USA",
    ),
    "Scottsdale, Arizona, United States": SCOTTSDALE,
    "Linkoping, Sweden": SportsballGeocodeTuple(
        city="Linkoping",
        state="",
        postal="",
        lat=58.415833,
        lng=15.625278,
        housenumber="",
        country="Sweden",
    ),
    "Siilinjarvi, Finland": SportsballGeocodeTuple(
        city="Siilinjarvi",
        state="",
        postal="",
        lat=63.075,
        lng=27.66,
        housenumber="",
        country="Finland",
    ),
    "Tampere, Finland": SportsballGeocodeTuple(
        city="Tampere",
        state="",
        postal="",
        lat=61.498056,
        lng=23.76,
        housenumber="",
        country="Finland",
    ),
    "Arlington, Texas, United States": ARLINGTON,
    "Baltimore Arena": CFG_BANK_ARENA,
    "Colorado College": SportsballGeocodeTuple(
        city="Colorado Springs",
        state="CO",
        postal="",
        lat=38.8479,
        lng=-104.8228,
        housenumber="",
        country="USA",
    ),
    "University of Houston": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.7189,
        lng=-95.3392,
        housenumber="",
        country="USA",
    ),
    "Canada Life Centre, Winnipeg, MB, Canada": CANADA_LIFE_CENTER,
    "Duke College": DUKE_UNIVERSITY,
    "University of Connecticut": SportsballGeocodeTuple(
        city="Storrs",
        state="CT",
        postal="",
        lat=41.807222,
        lng=-72.2525,
        housenumber="",
        country="USA",
    ),
    "Idaho State College": SportsballGeocodeTuple(
        city="Pocatello",
        state="ID",
        postal="",
        lat=42.861,
        lng=-112.434,
        housenumber="",
        country="USA",
    ),
    "Rogers Place": ROGERS_PLACE,
    "T-Mobile Arena, Las Vegas, NV, USA": T_MOBILE_ARENA,
    "Southern Miss College": SportsballGeocodeTuple(
        city="Hattiesburg",
        state="MS",
        postal="",
        lat=31.329638,
        lng=-89.333847,
        housenumber="",
        country="USA",
    ),
    "Rice College": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.716944,
        lng=-95.402778,
        housenumber="",
        country="USA",
    ),
    "Olten, Switzerland": SportsballGeocodeTuple(
        city="Olten",
        state="",
        postal="",
        lat=47.35,
        lng=7.9,
        housenumber="",
        country="Switzerland",
    ),
    "Enterprise Center, St. Louis, MO, USA": ENTERPRISE_CENTER,
    "Penn State College": SportsballGeocodeTuple(
        city="University Park",
        state="PA",
        postal="",
        lat=40.798333,
        lng=-77.86,
        housenumber="",
        country="USA",
    ),
    "California College": SportsballGeocodeTuple(
        city="Berkeley",
        state="CA",
        postal="",
        lat=37.871944,
        lng=-122.258333,
        housenumber="",
        country="USA",
    ),
    "University of Pittsburgh": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.4446,
        lng=-79.9533,
        housenumber="",
        country="USA",
    ),
    "Gardner-Webb College": SportsballGeocodeTuple(
        city="Boiling Springs",
        state="NC",
        postal="",
        lat=35.247456,
        lng=-81.670622,
        housenumber="",
        country="USA",
    ),
    "Purdue College": SportsballGeocodeTuple(
        city="West Lafayette",
        state="IN",
        postal="",
        lat=40.425,
        lng=-86.923056,
        housenumber="",
        country="USA",
    ),
    "Oulu, Finland": SportsballGeocodeTuple(
        city="Oulu",
        state="",
        postal="",
        lat=65.014167,
        lng=25.471944,
        housenumber="",
        country="Finland",
    ),
    "Grand Casino Arena, Saint Paul, MN, USA": SportsballGeocodeTuple(
        city="Saint Paul",
        state="MN",
        postal="",
        lat=44.944722,
        lng=-93.101111,
        housenumber="",
        country="USA",
    ),
    "Fayetteville, Georgia, United States": SportsballGeocodeTuple(
        city="Fayetteville",
        state="GA",
        postal="",
        lat=33.447778,
        lng=-84.461667,
        housenumber="",
        country="USA",
    ),
    "New York University": SportsballGeocodeTuple(
        city="New York",
        state="NY",
        postal="",
        lat=40.73,
        lng=-73.995,
        housenumber="",
        country="USA",
    ),
    "Stanford College": SportsballGeocodeTuple(
        city="Stanford",
        state="CA",
        postal="",
        lat=37.4275,
        lng=-122.17,
        housenumber="",
        country="USA",
    ),
    "Pittsburgh College": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.4446,
        lng=-79.9533,
        housenumber="",
        country="USA",
    ),
    "Villanova College": VILLANOVA_COLLEGE,
    "Canadian Tire Centre, Ottawa, ON, Canada": SportsballGeocodeTuple(
        city="Ottawa",
        state="ON",
        postal="",
        lat=45.296944,
        lng=-75.927222,
        housenumber="",
        country="Canada",
    ),
    "American Airlines Center": AMERICAN_AIRLINES_ARENA,
    "notre-dame": NOTRE_DAME_STADIUM,
    "Camp Randall Stadium - Madison, Wisconsin, USA - United States": CAMP_RANDALL_STADIUM,
    "Lenovo Center": LENOVO_CENTER,
    "Namur, Belgium": SportsballGeocodeTuple(
        city="Namur",
        state="",
        postal="",
        lat=50.466667,
        lng=4.866667,
        housenumber="",
        country="Belgium",
    ),
    "Mercedes-Benz Stadium, Atlanta, GA, USA": MERCEDES_BANZ_STADIUM,
    "LaVell Edwards Stadium - Provo, Utah, USA - United States": LAVELL_EDWARDS_STADIUM,
    "Gaylord Family Oklahoma Memorial Stadium": SportsballGeocodeTuple(
        city="Norman",
        state="OK",
        postal="",
        lat=35.205833,
        lng=-97.4425,
        housenumber="",
        country="USA",
    ),
    "Compaq Center": COMPAQ_CENTER,
    "Raymond James Stadium, Tampa, FL, USA": RAYMOND_JAMES_STADIUM,
    "Folsom Field - Boulder, Colorado, USA - United States": FOLSOM_FIELD,
    "University of Virginia": SportsballGeocodeTuple(
        city="Charlottesville",
        state="VA",
        postal="",
        lat=38.035556,
        lng=-78.503333,
        housenumber="",
        country="USA",
    ),
    "Martin Stadium": MARTIN_STADIUM,
    "Camping World Stadium, Orlando, FL, USA": CAMPING_WORLD_STADIUM,
    "Fredricksburg, VA, USA": SportsballGeocodeTuple(
        city="Fredricksburg",
        state="VA",
        postal="",
        lat=38.301829,
        lng=-77.470778,
        housenumber="",
        country="USA",
    ),
    "Legion Field - Birmingham, Alabama, USA - United States": LEGION_FIELD,
    "Bell Centre, Montreal, QC, Canada": BELL_CENTRE,
    "Newark, New Jersey, United States": NEWARK,
    "Trask Coliseum - Wilmington, North Carolina - United States": TRACK_COLISEUM,
    "Brigham Field at Huskie Stadium": HUSKIE_STADIUM,
    "Dignity Health Sports Park, Carson, CA, USA": DIGNITY_HEALTH_SPORTS_PARK,
    "Prudential Center, Newark, NJ, USA": PRUDENTIAL_CENTER,
    "Wrigley Field, Chicago, IL, USA": WRIGLEY_FIELD,
    "Waldo Stadium": WALDO_STADIUM,
    "Fenway Park - Boston, USA - United States": FENWAY_PARK,
    "UB Stadium - Buffalo, New York, USA - United States": UB_STADIUM,
    "Tyler, TX, USA": SportsballGeocodeTuple(
        city="Tyler",
        state="TX",
        postal="",
        lat=32.351389,
        lng=-95.301111,
        housenumber="",
        country="USA",
    ),
    "Central, SC, USA": SportsballGeocodeTuple(
        city="Central",
        state="SC",
        postal="",
        lat=34.723889,
        lng=-82.779722,
        housenumber="",
        country="USA",
    ),
    "Leominster, MA, USA": SportsballGeocodeTuple(
        city="Leominster",
        state="MA",
        postal="",
        lat=42.525,
        lng=-71.760278,
        housenumber="",
        country="USA",
    ),
    "Smyrna, TN, USA": SportsballGeocodeTuple(
        city="Smyrna",
        state="TN",
        postal="",
        lat=35.979444,
        lng=-86.521111,
        housenumber="",
        country="USA",
    ),
    "Pewaukee, WI, USA": SportsballGeocodeTuple(
        city="Pewaukee",
        state="WI",
        postal="",
        lat=43.066667,
        lng=-88.25,
        housenumber="",
        country="USA",
    ),
    "Willoughby, OH, USA": SportsballGeocodeTuple(
        city="Willoughby",
        state="OH",
        postal="",
        lat=41.634722,
        lng=-81.408333,
        housenumber="",
        country="USA",
    ),
    "Foley, AL, USA": SportsballGeocodeTuple(
        city="Foley",
        state="AL",
        postal="",
        lat=30.4055942,
        lng=-87.681509,
        housenumber="",
        country="USA",
    ),
    "Lima, OH, USA": SportsballGeocodeTuple(
        city="Lima",
        state="OH",
        postal="",
        lat=40.746389,
        lng=-84.123333,
        housenumber="",
        country="USA",
    ),
    "Westlake, OH, USA": SportsballGeocodeTuple(
        city="Westlake",
        state="OH",
        postal="",
        lat=41.454444,
        lng=-81.928611,
        housenumber="",
        country="USA",
    ),
    "Hollywood, FL, USA": SportsballGeocodeTuple(
        city="Hollywood",
        state="FL",
        postal="",
        lat=26.021389,
        lng=-80.175,
        housenumber="",
        country="USA",
    ),
    "Jackson, AL, USA": SportsballGeocodeTuple(
        city="Jackson",
        state="AL",
        postal="",
        lat=31.521685,
        lng=-87.891113,
        housenumber="",
        country="USA",
    ),
    "Chico, CA, USA": SportsballGeocodeTuple(
        city="Chico",
        state="CA",
        postal="",
        lat=39.74,
        lng=-121.835556,
        housenumber="",
        country="USA",
    ),
    "Baltimore, MD, USA": BALTIMORE,
    "Bridgeville, PA, USA": SportsballGeocodeTuple(
        city="Bridgeville",
        state="PA",
        postal="",
        lat=40.356944,
        lng=-80.108611,
        housenumber="",
        country="USA",
    ),
    "Vineland, NJ, USA": SportsballGeocodeTuple(
        city="Vineland",
        state="NJ",
        postal="",
        lat=39.465,
        lng=-75.006389,
        housenumber="",
        country="USA",
    ),
    "College Park, GA, USA": SportsballGeocodeTuple(
        city="College Park",
        state="GA",
        postal="",
        lat=33.6175,
        lng=-84.4675,
        housenumber="",
        country="USA",
    ),
    "Madison, WI, USA": MADISON,
    "Starkville, MS, USA": STARKVILLE,
    "Britton, SD, USA": SportsballGeocodeTuple(
        city="Britton",
        state="SD",
        postal="",
        lat=45.792222,
        lng=-97.752778,
        housenumber="",
        country="USA",
    ),
    "Oakhurst, NJ, USA": SportsballGeocodeTuple(
        city="Oakhurst",
        state="NJ",
        postal="",
        lat=40.261486,
        lng=-74.02655,
        housenumber="",
        country="USA",
    ),
    "Bronx, NY, USA": BRONX,
    "Newark, NJ, USA": NEWARK,
    "Dover, OH, USA": SportsballGeocodeTuple(
        city="Dover",
        state="OH",
        postal="",
        lat=40.526667,
        lng=-81.477778,
        housenumber="",
        country="USA",
    ),
    "Yazoo City, MS, USA": SportsballGeocodeTuple(
        city="Yazoo City",
        state="MS",
        postal="",
        lat=32.866667,
        lng=-90.403333,
        housenumber="",
        country="USA",
    ),
    "Amite City, LA, USA": SportsballGeocodeTuple(
        city="Amite City",
        state="LA",
        postal="",
        lat=30.728611,
        lng=-90.508611,
        housenumber="",
        country="USA",
    ),
    "Huntingdon Valley, Pennsylvania, United States": SportsballGeocodeTuple(
        city="Huntingdon Valley",
        state="PA",
        postal="",
        lat=40.116667,
        lng=-75.049722,
        housenumber="",
        country="USA",
    ),
    "Burlington, Kansas, United States": SportsballGeocodeTuple(
        city="Burlington",
        state="KS",
        postal="",
        lat=38.193611,
        lng=-95.745278,
        housenumber="",
        country="USA",
    ),
    "Rochester, New York, United States": ROCHESTER,
    "Boston College": BOSTON_COLLEGE,
    "Paulsboro, New Jersey, United States": SportsballGeocodeTuple(
        city="Paulsboro",
        state="NJ",
        postal="",
        lat=39.839975,
        lng=-75.23996,
        housenumber="",
        country="USA",
    ),
    "Saint Mary's College of California": SportsballGeocodeTuple(
        city="Moraga",
        state="CA",
        postal="",
        lat=37.841389,
        lng=-122.109167,
        housenumber="",
        country="USA",
    ),
    "Ohio State University": SportsballGeocodeTuple(
        city="Columbus",
        state="OH",
        postal="",
        lat=40.0,
        lng=-83.0125,
        housenumber="",
        country="USA",
    ),
    "Michigan State University": SportsballGeocodeTuple(
        city="East Lansing",
        state="MI",
        postal="",
        lat=42.725,
        lng=-84.48,
        housenumber="",
        country="USA",
    ),
    "Mississauga, Ontario, Canada": SportsballGeocodeTuple(
        city="Mississauga",
        state="ON",
        postal="",
        lat=43.6,
        lng=-79.65,
        housenumber="",
        country="Canada",
    ),
    "Duncanville, Texas, United States": SportsballGeocodeTuple(
        city="Duncanville",
        state="TX",
        postal="",
        lat=32.634722,
        lng=-96.906667,
        housenumber="",
        country="USA",
    ),
    "Progressive Field, Cleveland, OH, USA": SportsballGeocodeTuple(
        city="Cleveland",
        state="OH",
        postal="",
        lat=41.495833,
        lng=-81.685278,
        housenumber="2401",
        country="USA",
    ),
    "LoanDepot Park, Miami, FL, USA": MIAMI_ORANGE_BOWL,
    "Kelly/Shorts Stadium": KELLY_SHORTS_STADIUM,
    "Levi's Stadium, Santa Clara, CA, USA": LEVI_STADIUM,
    "Tulsa College": SportsballGeocodeTuple(
        city="Tulsa",
        state="OK",
        postal="",
        lat=36.152222,
        lng=-95.946389,
        housenumber="",
        country="USA",
    ),
    "Louisiana Tech College": SportsballGeocodeTuple(
        city="Ruston",
        state="LA",
        postal="",
        lat=32.5275,
        lng=-92.6475,
        housenumber="",
        country="USA",
    ),
    "Monmouth College": SportsballGeocodeTuple(
        city="Monmouth",
        state="IL",
        postal="",
        lat=40.914444,
        lng=-90.637222,
        housenumber="",
        country="USA",
    ),
    "Florida International College": SportsballGeocodeTuple(
        city="Westchester",
        state="FL",
        postal="",
        lat=25.757,
        lng=-80.374,
        housenumber="",
        country="USA",
    ),
    "South Alabama College": SportsballGeocodeTuple(
        city="Mobile",
        state="AL",
        postal="",
        lat=30.69671,
        lng=-88.17873,
        housenumber="",
        country="USA",
    ),
    "App State College": SportsballGeocodeTuple(
        city="Boone",
        state="NC",
        postal="",
        lat=36.213843,
        lng=-81.678621,
        housenumber="",
        country="USA",
    ),
    "Washington State College": SportsballGeocodeTuple(
        city="Pullman",
        state="WA",
        postal="",
        lat=46.73,
        lng=-117.16,
        housenumber="",
        country="USA",
    ),
    "UL Monroe College": SportsballGeocodeTuple(
        city="Monroe",
        state="LA",
        postal="",
        lat=32.527,
        lng=-92.074,
        housenumber="",
        country="USA",
    ),
    "Southeast Missouri State College": SportsballGeocodeTuple(
        city="Cape Girardeau",
        state="MO",
        postal="",
        lat=37.315125,
        lng=-89.529392,
        housenumber="",
        country="USA",
    ),
    "East Carolina College": SportsballGeocodeTuple(
        city="Greenville",
        state="NC",
        postal="",
        lat=35.6075,
        lng=-77.37,
        housenumber="",
        country="USA",
    ),
    "Auburn College": SportsballGeocodeTuple(
        city="Auburn",
        state="AL",
        postal="",
        lat=32.603,
        lng=-85.486,
        housenumber="",
        country="USA",
    ),
    "Liberty College": SportsballGeocodeTuple(
        city="Lynchburg",
        state="VA",
        postal="",
        lat=37.352,
        lng=-79.18,
        housenumber="",
        country="USA",
    ),
    "Mississippi State College": SportsballGeocodeTuple(
        city="Mississippi State",
        state="MS",
        postal="",
        lat=33.454,
        lng=-88.789,
        housenumber="",
        country="USA",
    ),
    "Illinois College": SportsballGeocodeTuple(
        city="Jacksonville",
        state="IL",
        postal="",
        lat=39.730278,
        lng=-90.246667,
        housenumber="",
        country="USA",
    ),
    "UCF College": SportsballGeocodeTuple(
        city="Orlando",
        state="FL",
        postal="",
        lat=28.6016,
        lng=-81.2005,
        housenumber="",
        country="USA",
    ),
    "Ole Miss College": SportsballGeocodeTuple(
        city="Lafayette County",
        state="MS",
        postal="38677",
        lat=34.3662492,
        lng=-89.5379687,
        housenumber="",
        country="USA",
    ),
    "Kansas State College": SportsballGeocodeTuple(
        city="Manhattan",
        state="KS",
        postal="",
        lat=39.1914,
        lng=-96.5809,
        housenumber="",
        country="USA",
    ),
    "Louisiana College": SportsballGeocodeTuple(
        city="Pineville",
        state="LA",
        postal="",
        lat=31.325278,
        lng=-92.426667,
        housenumber="",
        country="USA",
    ),
    "Missouri College": SportsballGeocodeTuple(
        city="Brentwood",
        state="MO",
        postal="",
        lat=38.62724,
        lng=-90.33558,
        housenumber="",
        country="USA",
    ),
    "Notre Dame College": NOTRE_DAME_COLLEGE,
    "Texas A&M College": SportsballGeocodeTuple(
        city="College Station",
        state="TX",
        postal="",
        lat=30.610278,
        lng=-96.343611,
        housenumber="",
        country="USA",
    ),
    "Fresno State College": CALIFORNIA_STATE_UNIVERSITY_FRESNO,
    "Clemson College": SportsballGeocodeTuple(
        city="Clemson",
        state="SC",
        postal="",
        lat=34.678333,
        lng=-82.839167,
        housenumber="",
        country="USA",
    ),
    "North Dakota State College": SportsballGeocodeTuple(
        city="Fargo",
        state="ND",
        postal="",
        lat=46.8917,
        lng=-96.8,
        housenumber="",
        country="USA",
    ),
    "South Dakota College": SportsballGeocodeTuple(
        city="Vermillion",
        state="SD",
        postal="",
        lat=42.786111,
        lng=-96.925278,
        housenumber="",
        country="USA",
    ),
    "West Florida College": SportsballGeocodeTuple(
        city="Pensacola",
        state="FL",
        postal="",
        lat=30.5495,
        lng=-87.2181,
        housenumber="",
        country="USA",
    ),
    "South Carolina College": SportsballGeocodeTuple(
        city="Columbia",
        state="SC",
        postal="",
        lat=33.9975,
        lng=-81.025278,
        housenumber="",
        country="USA",
    ),
    "Northwestern College": SportsballGeocodeTuple(
        city="Orange City",
        state="IO",
        postal="",
        lat=42.999,
        lng=-96.057,
        housenumber="",
        country="USA",
    ),
    "Minnesota College": SportsballGeocodeTuple(
        city="Minneapolis-Saint Paul",
        state="MN",
        postal="",
        lat=44.975,
        lng=-93.235278,
        housenumber="",
        country="USA",
    ),
    "British Columbia College": SportsballGeocodeTuple(
        city="Vancouver",
        state="BC",
        postal="",
        lat=49.271667,
        lng=-123.095278,
        housenumber="",
        country="Canada",
    ),
    "Indiana College": SportsballGeocodeTuple(
        city="Bloomington",
        state="IN",
        postal="",
        lat=39.166667,
        lng=-86.5,
        housenumber="",
        country="USA",
    ),
    "Tennessee College": SportsballGeocodeTuple(
        city="Knoxville",
        state="TN",
        postal="",
        lat=35.951667,
        lng=-83.93,
        housenumber="",
        country="USA",
    ),
    "Florida College": SportsballGeocodeTuple(
        city="Temple Terrace",
        state="FL",
        postal="",
        lat=28.034559,
        lng=-82.383495,
        housenumber="",
        country="USA",
    ),
    "Alabama College": SportsballGeocodeTuple(
        city="Tuscaloosa",
        state="AL",
        postal="",
        lat=33.210833,
        lng=-87.546111,
        housenumber="",
        country="USA",
    ),
    "North Carolina State College": SportsballGeocodeTuple(
        city="Raleigh",
        state="NC",
        postal="",
        lat=35.787222,
        lng=-78.670556,
        housenumber="",
        country="USA",
    ),
    "UCLA College": SportsballGeocodeTuple(
        city="Los Angeles",
        state="CA",
        postal="",
        lat=34.0722,
        lng=-118.4427,
        housenumber="",
        country="USA",
    ),
    "USC College": SportsballGeocodeTuple(
        city="Los Angeles",
        state="CA",
        postal="",
        lat=34.0206,
        lng=-118.2848,
        housenumber="",
        country="USA",
    ),
    "Michigan State College": SportsballGeocodeTuple(
        city="East Lansing",
        state="MI",
        postal="",
        lat=42.725,
        lng=-84.48,
        housenumber="",
        country="USA",
    ),
    "Texas Tech College": SportsballGeocodeTuple(
        city="Lubbock",
        state="TX",
        postal="",
        lat=33.584,
        lng=-101.878,
        housenumber="",
        country="USA",
    ),
    "Iowa State College": SportsballGeocodeTuple(
        city="Ames",
        state="IO",
        postal="",
        lat=42.0262,
        lng=-93.648,
        housenumber="",
        country="USA",
    ),
    "Middle Tennessee College": SportsballGeocodeTuple(
        city="Murfreesboro",
        state="TN",
        postal="",
        lat=35.849,
        lng=-86.365,
        housenumber="",
        country="USA",
    ),
    "Oregon College": SportsballGeocodeTuple(
        city="Eugene",
        state="OR",
        postal="",
        lat=44.0443,
        lng=-123.0758,
        housenumber="",
        country="USA",
    ),
    "Ohio State College": SportsballGeocodeTuple(
        city="Columbus",
        state="OH",
        postal="",
        lat=40.0,
        lng=-83.0125,
        housenumber="",
        country="USA",
    ),
    "Colorado State College": SportsballGeocodeTuple(
        city="Columbus",
        state="OH",
        postal="",
        lat=40.5762,
        lng=-105.0808,
        housenumber="",
        country="USA",
    ),
    "Utah State College": SportsballGeocodeTuple(
        city="Logan",
        state="UT",
        postal="",
        lat=41.7425,
        lng=-111.8125,
        housenumber="",
        country="USA",
    ),
    "California (PA) College": SportsballGeocodeTuple(
        city="California",
        state="PA",
        postal="",
        lat=40.06678,
        lng=-79.88482,
        housenumber="",
        country="USA",
    ),
    "Boise State College": SportsballGeocodeTuple(
        city="Boise",
        state="ID",
        postal="",
        lat=43.604,
        lng=-116.204,
        housenumber="",
        country="USA",
    ),
    "Oregon State College": SportsballGeocodeTuple(
        city="Corvallis",
        state="OR",
        postal="",
        lat=44.5639,
        lng=-123.2747,
        housenumber="",
        country="USA",
    ),
    "Wake Forest College": WAKE_FOREST_COLLEGE,
    "North Carolina College": SportsballGeocodeTuple(
        city="Chapel Hill",
        state="NC",
        postal="",
        lat=35.908611,
        lng=-79.049167,
        housenumber="",
        country="USA",
    ),
    "Western Michigan College": SportsballGeocodeTuple(
        city="Kalamazoo",
        state="MI",
        postal="",
        lat=42.283333,
        lng=-85.613889,
        housenumber="",
        country="USA",
    ),
    "Texas College": SportsballGeocodeTuple(
        city="Tyler",
        state="TX",
        postal="",
        lat=32.3756,
        lng=-95.3124,
        housenumber="",
        country="USA",
    ),
    "Georgia Tech College": SportsballGeocodeTuple(
        city="Atlanta",
        state="GA",
        postal="",
        lat=33.776,
        lng=-84.396,
        housenumber="",
        country="USA",
    ),
    "North Texas College": SportsballGeocodeTuple(
        city="Denton",
        state="TX",
        postal="",
        lat=33.209722,
        lng=-97.15,
        housenumber="",
        country="USA",
    ),
    "Florida A&M College": SportsballGeocodeTuple(
        city="Tallahassee",
        state="FL",
        postal="",
        lat=30.4178,
        lng=-84.2845,
        housenumber="",
        country="USA",
    ),
    "Virginia Tech College": SportsballGeocodeTuple(
        city="Blacksburg",
        state="VA",
        postal="",
        lat=37.225,
        lng=-80.425,
        housenumber="",
        country="USA",
    ),
    "Oklahoma State College": SportsballGeocodeTuple(
        city="Stillwater",
        state="OK",
        postal="",
        lat=36.1224,
        lng=-97.0698,
        housenumber="",
        country="USA",
    ),
    "Central Michigan College": SportsballGeocodeTuple(
        city="Mount Pleasant",
        state="MI",
        postal="",
        lat=43.5898,
        lng=-84.7775,
        housenumber="",
        country="USA",
    ),
    "Central Missouri State College": SportsballGeocodeTuple(
        city="Warrensburg",
        state="MO",
        postal="",
        lat=38.757,
        lng=-93.741,
        housenumber="",
        country="USA",
    ),
    "Cortland College": SportsballGeocodeTuple(
        city="Cortland",
        state="NY",
        postal="",
        lat=42.597,
        lng=-76.189333,
        housenumber="",
        country="USA",
    ),
    "Augustana University (SD) College": SportsballGeocodeTuple(
        city="Sioux Falls",
        state="SD",
        postal="",
        lat=43.526861,
        lng=-96.737028,
        housenumber="",
        country="USA",
    ),
    "Wingate College": SportsballGeocodeTuple(
        city="Wingate",
        state="NC",
        postal="",
        lat=34.986111,
        lng=-80.444167,
        housenumber="",
        country="USA",
    ),
    "Miami (OH) College": SportsballGeocodeTuple(
        city="Oxford",
        state="OH",
        postal="",
        lat=39.511905,
        lng=-84.734674,
        housenumber="",
        country="USA",
    ),
    "Glass Bowl - Toledo, Ohio, USA - United States": GLASS_BOWL,
    "Sam Houston College": SportsballGeocodeTuple(
        city="Huntsville",
        state="TX",
        postal="",
        lat=30.713889,
        lng=-95.547222,
        housenumber="",
        country="USA",
    ),
    "UTEP College": SportsballGeocodeTuple(
        city="El Paso",
        state="TX",
        postal="",
        lat=31.77,
        lng=-106.505,
        housenumber="",
        country="USA",
    ),
    "Navy College": SportsballGeocodeTuple(
        city="Annapolis",
        state="MD",
        postal="",
        lat=38.9828,
        lng=-76.4851,
        housenumber="",
        country="USA",
    ),
    "Air Force College": SportsballGeocodeTuple(
        city="Air Force Academy",
        state="CO",
        postal="",
        lat=38.9985,
        lng=-104.8541,
        housenumber="",
        country="USA",
    ),
    "Arkansas State College": SportsballGeocodeTuple(
        city="Jonesboro",
        state="AK",
        postal="",
        lat=35.841082,
        lng=-90.679586,
        housenumber="",
        country="USA",
    ),
    "James Madison College": SportsballGeocodeTuple(
        city="Harrisonburg",
        state="VA",
        postal="",
        lat=38.438444,
        lng=-78.87375,
        housenumber="",
        country="USA",
    ),
    "Old Dominion College": SportsballGeocodeTuple(
        city="Norfolk",
        state="VA",
        postal="",
        lat=36.88654,
        lng=-76.30522,
        housenumber="",
        country="USA",
    ),
    "Gillette Stadium, Foxborough, MA, USA": GILETTE_STADIUM,
    "Citi Field, New York, NY, USA": SHEA_STADIUM,
    "Humacao, PR": SportsballGeocodeTuple(
        city="Humacao",
        state="PR",
        postal="",
        lat=18.149722,
        lng=-65.8275,
        housenumber="",
        country="USA",
    ),
    "Greensboro, NC, United States": GREENSBORO,
    "Beaver Stadium - University Park, PA - United States": BEAVER_STADIUM,
    "New Mexico College": SportsballGeocodeTuple(
        city="Albuquerque",
        state="NM",
        postal="",
        lat=35.08389,
        lng=-106.61861,
        housenumber="",
        country="USA",
    ),
    "Ball State College": SportsballGeocodeTuple(
        city="Muncie",
        state="IN",
        postal="",
        lat=40.198322,
        lng=-85.408943,
        housenumber="",
        country="USA",
    ),
    "Kent State College": SportsballGeocodeTuple(
        city="Kent",
        state="OH",
        postal="",
        lat=41.1469442,
        lng=-81.343333,
        housenumber="",
        country="USA",
    ),
    "San Diego State College": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="",
        lat=32.775278,
        lng=-117.072222,
        housenumber="",
        country="USA",
    ),
    "Wyoming College": SportsballGeocodeTuple(
        city="Laramie",
        state="WY",
        postal="",
        lat=41.313056,
        lng=-105.581389,
        housenumber="",
        country="USA",
    ),
    "Western Kentucky College": SportsballGeocodeTuple(
        city="Bowling Green",
        state="KY",
        postal="",
        lat=36.986111,
        lng=-86.455556,
        housenumber="",
        country="USA",
    ),
    "Coastal Carolina College": SportsballGeocodeTuple(
        city="Conway",
        state="SC",
        postal="",
        lat=33.794722,
        lng=-79.011667,
        housenumber="",
        country="USA",
    ),
    "UTSA College": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="",
        lat=29.583333,
        lng=-98.620833,
        housenumber="",
        country="USA",
    ),
    "Lambeau Field, Green Bay, WI, USA": LAMBEAU_FIELD,
    "Truist Park, Atlanta, GA, USA": SportsballGeocodeTuple(
        city="Atlanta",
        state="GA",
        postal="",
        lat=33.89,
        lng=-84.468,
        housenumber="755",
        country="USA",
    ),
    "South Carolina State College": SportsballGeocodeTuple(
        city="Orangeburg",
        state="SC",
        postal="",
        lat=33.497222,
        lng=-80.85,
        housenumber="",
        country="USA",
    ),
    "Yale College": SportsballGeocodeTuple(
        city="New Haven",
        state="CT",
        postal="",
        lat=41.311667,
        lng=-72.925278,
        housenumber="",
        country="USA",
    ),
    "Vanderbilt College": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.1475,
        lng=-86.8025,
        housenumber="",
        country="USA",
    ),
    "Eastern Kentucky College": SportsballGeocodeTuple(
        city="Richmond",
        state="KY",
        postal="",
        lat=37.734155,
        lng=-84.301434,
        housenumber="",
        country="USA",
    ),
    "Texas State College": SportsballGeocodeTuple(
        city="San Marcos",
        state="TX",
        postal="",
        lat=29.888889,
        lng=-97.938889,
        housenumber="",
        country="USA",
    ),
    "Tulane College": SportsballGeocodeTuple(
        city="New Orleans",
        state="LA",
        postal="",
        lat=29.94,
        lng=-90.12,
        housenumber="",
        country="USA",
    ),
    "Kansas College": SportsballGeocodeTuple(
        city="Lawrence",
        state="KS",
        postal="",
        lat=38.9584,
        lng=-95.2478,
        housenumber="",
        country="USA",
    ),
    "Northern Iowa College": SportsballGeocodeTuple(
        city="Cedar Falls",
        state="IO",
        postal="",
        lat=42.515,
        lng=-92.460556,
        housenumber="",
        country="USA",
    ),
    "Arkansas-Pine Bluff College": SportsballGeocodeTuple(
        city="Pine Bluff",
        state="AK",
        postal="",
        lat=34.2423,
        lng=-92.0203,
        housenumber="",
        country="USA",
    ),
    "North Carolina A&T College": SportsballGeocodeTuple(
        city="Greensboro",
        state="NC",
        postal="",
        lat=36.075352,
        lng=-79.773628,
        housenumber="",
        country="USA",
    ),
    "Pittsburg State College": SportsballGeocodeTuple(
        city="Pittsburg",
        state="KS",
        postal="",
        lat=37.3913,
        lng=-94.7024,
        housenumber="",
        country="USA",
    ),
    "Sherman Oaks, CA, United States": SportsballGeocodeTuple(
        city="Sherman Oaks",
        state="CA",
        postal="",
        lat=34.151111,
        lng=-118.448333,
        housenumber="",
        country="USA",
    ),
    "University of Kentucky": UNIVERSITY_OF_KENTUCKY,
    "California State University, Fresno": CALIFORNIA_STATE_UNIVERSITY_FRESNO,
    "Paris, France": SportsballGeocodeTuple(
        city="Paris",
        state="",
        postal="",
        lat=48.856667,
        lng=2.352222,
        housenumber="",
        country="France",
    ),
    "University of California, Los Angeles": SportsballGeocodeTuple(
        city="Los Angeles",
        state="CA",
        postal="",
        lat=34.0722,
        lng=-118.4427,
        housenumber="",
        country="USA",
    ),
    "University of Colorado": SportsballGeocodeTuple(
        city="Boulder",
        state="CO",
        postal="",
        lat=40.0073,
        lng=-105.2678,
        housenumber="",
        country="USA",
    ),
    "New Castle, Delaware, United States": SportsballGeocodeTuple(
        city="New Castle",
        state="DE",
        postal="",
        lat=39.661944,
        lng=-75.566389,
        housenumber="",
        country="USA",
    ),
    "South Bend, Indiana, United States": SportsballGeocodeTuple(
        city="South Bend",
        state="IN",
        postal="",
        lat=41.676389,
        lng=-86.269444,
        housenumber="",
        country="USA",
    ),
    "University of Texas at Austin": SportsballGeocodeTuple(
        city="Austin",
        state="TX",
        postal="",
        lat=30.285,
        lng=-97.735,
        housenumber="",
        country="USA",
    ),
    "Fayetteville, New York, United States": SportsballGeocodeTuple(
        city="Fayetteville",
        state="NY",
        postal="",
        lat=43.028611,
        lng=-76.004167,
        housenumber="",
        country="USA",
    ),
    "Gonzaga University": GONZAGA,
    "University of Kansas": SportsballGeocodeTuple(
        city="Lawrence",
        state="KS",
        postal="",
        lat=38.9584,
        lng=-95.2478,
        housenumber="",
        country="USA",
    ),
    "University of Nevada, Las Vegas": SportsballGeocodeTuple(
        city="Paradise",
        state="NV",
        postal="",
        lat=36.10779,
        lng=-115.14376,
        housenumber="",
        country="USA",
    ),
    "University of North Carolina": SportsballGeocodeTuple(
        city="Chapel Hill",
        state="NC",
        postal="",
        lat=35.908611,
        lng=-79.049167,
        housenumber="",
        country="USA",
    ),
    "University of Michigan": SportsballGeocodeTuple(
        city="Ann Arbor",
        state="MI",
        postal="",
        lat=42.276944,
        lng=-83.738056,
        housenumber="",
        country="USA",
    ),
    "Stanford University": SportsballGeocodeTuple(
        city="Stanford",
        state="CA",
        postal="",
        lat=37.4275,
        lng=-122.17,
        housenumber="",
        country="USA",
    ),
    "Goma, Democratic Republic of the Congo": SportsballGeocodeTuple(
        city="Goma",
        state="",
        postal="",
        lat=-1.679444,
        lng=29.233611,
        housenumber="",
        country="Democratic Republic of the Congo",
    ),
    "Green Bay, Wisconsin, United States": GREEN_BAY,
    "Washington State University": SportsballGeocodeTuple(
        city="Pullman",
        state="WA",
        postal="",
        lat=46.73,
        lng=-117.16,
        housenumber="",
        country="USA",
    ),
    "Pescara, Italy": SportsballGeocodeTuple(
        city="Pescara",
        state="",
        postal="",
        lat=42.463889,
        lng=14.214167,
        housenumber="",
        country="Italy",
    ),
    "University of Missouri": SportsballGeocodeTuple(
        city="Columbia",
        state="MO",
        postal="",
        lat=38.9453,
        lng=-92.3288,
        housenumber="",
        country="USA",
    ),
    "University of Tulsa": SportsballGeocodeTuple(
        city="Tulsa",
        state="OK",
        postal="",
        lat=36.152222,
        lng=-95.946389,
        housenumber="",
        country="USA",
    ),
    "San Diego State University": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="",
        lat=32.775278,
        lng=-117.072222,
        housenumber="",
        country="USA",
    ),
    "Eustis, Florida, United States": SportsballGeocodeTuple(
        city="Eustis",
        state="FL",
        postal="",
        lat=28.856389,
        lng=-81.677222,
        housenumber="",
        country="USA",
    ),
    "Canberra, Australia": SportsballGeocodeTuple(
        city="Canberra",
        state="",
        postal="",
        lat=-35.293056,
        lng=149.126944,
        housenumber="",
        country="Australia",
    ),
    "Cedar Rapids, Iowa, United States": SportsballGeocodeTuple(
        city="Cedar Rapids",
        state="IO",
        postal="",
        lat=41.983056,
        lng=-91.668611,
        housenumber="",
        country="USA",
    ),
    "University of Maryland": SportsballGeocodeTuple(
        city="College Park",
        state="MD",
        postal="",
        lat=38.988,
        lng=-76.943,
        housenumber="",
        country="USA",
    ),
    "Salzgitter, Germany": SportsballGeocodeTuple(
        city="Salzgitter",
        state="",
        postal="",
        lat=52.15,
        lng=10.333333,
        housenumber="",
        country="Germany",
    ),
    "St. Paul, Minnesota, United States": ST_PAUL,
    "Florida": SportsballGeocodeTuple(
        city="",
        state="FL",
        postal="",
        lat=28.0,
        lng=-82.0,
        housenumber="",
        country="USA",
    ),
    "Aurora, Ontario, Canada": SportsballGeocodeTuple(
        city="Aurora",
        state="ON",
        postal="",
        lat=43.9975,
        lng=-79.47,
        housenumber="",
        country="Canada",
    ),
    "Duquesne University": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.436111,
        lng=-79.993056,
        housenumber="",
        country="USA",
    ),
    "Arizona": SportsballGeocodeTuple(
        city="",
        state="AZ",
        postal="",
        lat=35.0,
        lng=-112.0,
        housenumber="",
        country="USA",
    ),
    "Nassau, Bahamas": SportsballGeocodeTuple(
        city="Nassau",
        state="",
        postal="",
        lat=25.044167,
        lng=-77.350278,
        housenumber="",
        country="Bahamas",
    ),
    "Villanova": VILLANOVA_COLLEGE,
    "Tempe, Arizona, United States": TEMPE,
    "University of Southern California": SportsballGeocodeTuple(
        city="Los Angeles",
        state="CA",
        postal="",
        lat=34.0206,
        lng=-118.2848,
        housenumber="",
        country="USA",
    ),
    "Wake Forest": WAKE_FOREST_COLLEGE,
    "Layton, Utah, United States": SportsballGeocodeTuple(
        city="Layton",
        state="UT",
        postal="",
        lat=41.071667,
        lng=-111.996944,
        housenumber="",
        country="USA",
    ),
    "Fort Smith, Arkansas, United States": SportsballGeocodeTuple(
        city="Fort Smith",
        state="AK",
        postal="",
        lat=35.379722,
        lng=-94.381944,
        housenumber="",
        country="USA",
    ),
    "Denver, Colorado, United States": DENVER,
    "TCU": SportsballGeocodeTuple(
        city="Forth Worth",
        state="TX",
        postal="",
        lat=32.7096,
        lng=-97.364,
        housenumber="",
        country="USA",
    ),
    "Waco, Texas, United States": WACO,
    "Oklahoma State": SportsballGeocodeTuple(
        city="Stillwater",
        state="OK",
        postal="",
        lat=36.1224,
        lng=-97.0698,
        housenumber="",
        country="USA",
    ),
    "Norman, Oklahoma, United States": NORMAN,
    "Villeneuve-sur-Lot, France": SportsballGeocodeTuple(
        city="Villeneuve-sur-Lot",
        state="",
        postal="",
        lat=44.4081,
        lng=0.705,
        housenumber="",
        country="France",
    ),
    "Guymon, Oklahoma, United States": SportsballGeocodeTuple(
        city="Guymon",
        state="OK",
        postal="",
        lat=36.682804,
        lng=-101.481549,
        housenumber="",
        country="USA",
    ),
    "University of Tennessee": SportsballGeocodeTuple(
        city="Knoxville",
        state="TN",
        postal="",
        lat=35.951667,
        lng=-83.93,
        housenumber="",
        country="USA",
    ),
    "University of Louisville": SportsballGeocodeTuple(
        city="Louisville",
        state="KY",
        postal="",
        lat=38.215,
        lng=-85.760278,
        housenumber="",
        country="USA",
    ),
    "Creighton University": SportsballGeocodeTuple(
        city="Omaha",
        state="NB",
        postal="",
        lat=41.264722,
        lng=-95.946111,
        housenumber="",
        country="USA",
    ),
    "University of Notre Dame": NOTRE_DAME_COLLEGE,
    "Norfolk, Virginia, United States": NORFOLK,
    "Belleville, Illinois, United States": SportsballGeocodeTuple(
        city="Belleville",
        state="IL",
        postal="",
        lat=38.521667,
        lng=-89.995278,
        housenumber="",
        country="USA",
    ),
    "Lehigh University": SportsballGeocodeTuple(
        city="Bethlehem",
        state="PA",
        postal="",
        lat=40.606111,
        lng=-75.377222,
        housenumber="",
        country="USA",
    ),
    "Florida State": SportsballGeocodeTuple(
        city="Tallahassee",
        state="FL",
        postal="",
        lat=30.442,
        lng=-84.298,
        housenumber="",
        country="USA",
    ),
    "Oregon": SportsballGeocodeTuple(
        city="",
        state="OR",
        postal="",
        lat=44.0,
        lng=-121.0,
        housenumber="",
        country="USA",
    ),
    "Douala, Cameroon": SportsballGeocodeTuple(
        city="Douala",
        state="",
        postal="",
        lat=4.05,
        lng=9.7,
        housenumber="",
        country="Cameroon",
    ),
    "Georgetown University": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="",
        lat=38.907222,
        lng=-77.072778,
        housenumber="",
        country="USA",
    ),
    "Boca Raton, Florida, United States": BOCA_RATON,
    "Toledo, Ohio, United States": TOLEDO,
    "Port Arthur, Texas, United States": SportsballGeocodeTuple(
        city="Port Arthur",
        state="TX",
        postal="",
        lat=29.868333,
        lng=-93.89,
        housenumber="",
        country="USA",
    ),
    "Cordova, Tennessee, United States": SportsballGeocodeTuple(
        city="Cordova",
        state="TN",
        postal="",
        lat=35.155556,
        lng=-89.776111,
        housenumber="",
        country="USA",
    ),
    "Arlington Heights, Illinois, United States": SportsballGeocodeTuple(
        city="Arlington Heights",
        state="IL",
        postal="",
        lat=42.095,
        lng=-87.980833,
        housenumber="",
        country="USA",
    ),
    "Portsmouth, Rhode Island, United States": SportsballGeocodeTuple(
        city="Portsmouth",
        state="RI",
        postal="",
        lat=41.6,
        lng=-71.25,
        housenumber="",
        country="USA",
    ),
    "Weber State University": WEBER_STATE_COLLEGE,
    "Longwood, Florida, United States": SportsballGeocodeTuple(
        city="Longwood",
        state="FL",
        postal="",
        lat=28.701389,
        lng=-81.348611,
        housenumber="",
        country="USA",
    ),
    "Syracuse University": SportsballGeocodeTuple(
        city="Syracuse",
        state="NY",
        postal="",
        lat=43.0376,
        lng=-76.134,
        housenumber="",
        country="USA",
    ),
    "Miami (FL)": MIAMI,
    "Princeton, New Jersey, United States": PRINCETON,
    "University of Georgia": SportsballGeocodeTuple(
        city="Athens",
        state="GA",
        postal="",
        lat=33.9558,
        lng=-83.3745,
        housenumber="",
        country="USA",
    ),
    "Beverly Hills, California, United States": SportsballGeocodeTuple(
        city="Beverly Hills",
        state="CA",
        postal="",
        lat=34.073056,
        lng=-118.399444,
        housenumber="",
        country="USA",
    ),
    "Wake Forest University": WAKE_FOREST_COLLEGE,
    "Traralgon, Australia": SportsballGeocodeTuple(
        city="Traralgon",
        state="VIC",
        postal="",
        lat=-38.195833,
        lng=146.540278,
        housenumber="",
        country="Australia",
    ),
    "Portsmouth, Virginia, United States": SportsballGeocodeTuple(
        city="Portsmouth",
        state="VA",
        postal="",
        lat=36.834444,
        lng=-76.341667,
        housenumber="",
        country="USA",
    ),
    "Manhattan, Kansas, United States": MANHATTAN,
    "Gainesville, Florida, United States": GAINESVILLE,
    "Texas": SportsballGeocodeTuple(
        city="",
        state="TX",
        postal="",
        lat=31.0,
        lng=-99.0,
        housenumber="",
        country="USA",
    ),
    "Staten Island, New York, United States": STATEN_ISLAND,
    "North Carolina State University": SportsballGeocodeTuple(
        city="Raleigh",
        state="NC",
        postal="",
        lat=35.787222,
        lng=-78.670556,
        housenumber="",
        country="USA",
    ),
    "Milwaukee , Wisconsin, United States": MILWAUKEE,
    "Utah": SportsballGeocodeTuple(
        city="",
        state="UT",
        postal="",
        lat=39.0,
        lng=-111.0,
        housenumber="",
        country="USA",
    ),
    "La Crosse, Wisconsin, United States": SportsballGeocodeTuple(
        city="La Crosse",
        state="WI",
        postal="",
        lat=43.813333,
        lng=-91.233056,
        housenumber="",
        country="USA",
    ),
    "Montgomery, Alabama, United States": MONTGOMERY,
    "Indiana University": SportsballGeocodeTuple(
        city="Bloomington",
        state="IN",
        postal="",
        lat=39.166667,
        lng=-86.5,
        housenumber="",
        country="USA",
    ),
    "University of Oklahoma": SportsballGeocodeTuple(
        city="Norman",
        state="OK",
        postal="",
        lat=35.2088,
        lng=-97.4457,
        housenumber="",
        country="USA",
    ),
    "Leicester, United Kingdom": SportsballGeocodeTuple(
        city="Leicester",
        state="",
        postal="",
        lat=52.636111,
        lng=-1.133056,
        housenumber="",
        country="UK",
    ),
    "Marquette University": SportsballGeocodeTuple(
        city="Milwaukee",
        state="WI",
        postal="",
        lat=43.039167,
        lng=-87.9325,
        housenumber="",
        country="USA",
    ),
    "Pontiac, Michigan, United States": SportsballGeocodeTuple(
        city="Pontiac",
        state="MI",
        postal="",
        lat=42.646111,
        lng=-83.2925,
        housenumber="",
        country="USA",
    ),
    "Butler University": SportsballGeocodeTuple(
        city="Indianapolis",
        state="IN",
        postal="",
        lat=39.839444,
        lng=-86.171389,
        housenumber="",
        country="USA",
    ),
    "Pendleton, South Carolina, United States": SportsballGeocodeTuple(
        city="Pendleton",
        state="SC",
        postal="",
        lat=34.650556,
        lng=-82.780833,
        housenumber="",
        country="USA",
    ),
    "Robertson Stadium": ROBERTSON_STADIUM,
    "Northern Illinois College": SportsballGeocodeTuple(
        city="DeKalb",
        state="IL",
        postal="",
        lat=41.933889,
        lng=-88.777778,
        housenumber="",
        country="USA",
    ),
    "SMU College": SportsballGeocodeTuple(
        city="University Park",
        state="TX",
        postal="",
        lat=32.83855,
        lng=-96.78294,
        housenumber="",
        country="USA",
    ),
    "Troy College": SportsballGeocodeTuple(
        city="Troy",
        state="AL",
        postal="",
        lat=31.798056,
        lng=-85.953889,
        housenumber="",
        country="USA",
    ),
    "Charlotte College": SportsballGeocodeTuple(
        city="Charlotte",
        state="NC",
        postal="",
        lat=35.306389,
        lng=-80.733333,
        housenumber="",
        country="USA",
    ),
    "Hawai'i' College": SportsballGeocodeTuple(
        city="Honolulu",
        state="HI",
        postal="",
        lat=21.297,
        lng=-157.817,
        housenumber="",
        country="USA",
    ),
    "Florida Atlantic College": SportsballGeocodeTuple(
        city="Boca Raton",
        state="FL",
        postal="",
        lat=26.371,
        lng=-80.102,
        housenumber="",
        country="USA",
    ),
    "Florida State College": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="",
        lat=30.334722,
        lng=-81.659722,
        housenumber="",
        country="USA",
    ),
    "Virginia College": SportsballGeocodeTuple(
        city="Charlottesville",
        state="VA",
        postal="",
        lat=38.035556,
        lng=-78.503333,
        housenumber="",
        country="USA",
    ),
    "M&T Bank Stadium, Baltimore, MD, USA": MTT_BANK_STADIUM,
    "Indianapolis, IN, United States": INDIANAPOLIS,
    "Arlington, WA, United States": SportsballGeocodeTuple(
        city="Arlington",
        state="WA",
        postal="",
        lat=48.181111,
        lng=-122.138889,
        housenumber="",
        country="USA",
    ),
    "Allentown, Pennsylvania, United States": SportsballGeocodeTuple(
        city="Allentown",
        state="PA",
        postal="",
        lat=40.601667,
        lng=-75.477222,
        housenumber="",
        country="USA",
    ),
    "Kentucky": SportsballGeocodeTuple(
        city="",
        state="KY",
        postal="",
        lat=37.0,
        lng=-86.0,
        housenumber="",
        country="USA",
    ),
    "Gonzaga": GONZAGA,
    "University of Washington": SportsballGeocodeTuple(
        city="Seattle",
        state="WA",
        postal="",
        lat=47.654167,
        lng=-122.308056,
        housenumber="",
        country="USA",
    ),
    "Oklahoma State University": SportsballGeocodeTuple(
        city="Stillwater",
        state="OK",
        postal="",
        lat=36.1224,
        lng=-97.0698,
        housenumber="",
        country="USA",
    ),
    "Lane Stadium": LANE_STADIUM,
    "Utah College": SportsballGeocodeTuple(
        city="Salt Lake City",
        state="UT",
        postal="",
        lat=40.7642,
        lng=-111.8465,
        housenumber="",
        country="USA",
    ),
    "Houston College": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.7189,
        lng=-95.3392,
        housenumber="",
        country="USA",
    ),
    "Georgia Southern College": SportsballGeocodeTuple(
        city="Statesboro",
        state="GA",
        postal="",
        lat=32.419448,
        lng=-81.776698,
        housenumber="",
        country="USA",
    ),
    "Buffalo College": SportsballGeocodeTuple(
        city="Buffalo",
        state="NY",
        postal="",
        lat=43.0,
        lng=-78.789167,
        housenumber="",
        country="USA",
    ),
    "Ohio College": SportsballGeocodeTuple(
        city="Athens",
        state="OH",
        postal="",
        lat=39.324,
        lng=-82.102,
        housenumber="",
        country="USA",
    ),
    "Memphis College": SportsballGeocodeTuple(
        city="Memphis",
        state="TN",
        postal="",
        lat=35.118889,
        lng=-89.937222,
        housenumber="",
        country="USA",
    ),
    "Jacksonville State College": SportsballGeocodeTuple(
        city="Jacksonville",
        state="AL",
        postal="",
        lat=33.822,
        lng=-85.766,
        housenumber="",
        country="USA",
    ),
    "Georgia State College": SportsballGeocodeTuple(
        city="Atlanta",
        state="GA",
        postal="",
        lat=33.753694,
        lng=-84.385972,
        housenumber="",
        country="USA",
    ),
    "Georgia Dome, Atlanta, GA, USA": GEORGIA_DOME,
    "Grand Valley State College": SportsballGeocodeTuple(
        city="Allendale",
        state="MI",
        postal="",
        lat=42.963611,
        lng=-85.888611,
        housenumber="",
        country="USA",
    ),
    "Randolph-Macon College": SportsballGeocodeTuple(
        city="Ashland",
        state="VA",
        postal="",
        lat=37.763,
        lng=-77.477,
        housenumber="",
        country="USA",
    ),
    "Rutgers College": SportsballGeocodeTuple(
        city="New Brunswick",
        state="NJ",
        postal="",
        lat=40.501667,
        lng=-74.448056,
        housenumber="",
        country="USA",
    ),
    "Alabama State College": SportsballGeocodeTuple(
        city="Montgomery",
        state="AL",
        postal="",
        lat=32.364,
        lng=-86.295,
        housenumber="",
        country="USA",
    ),
    "Jackson State College": SportsballGeocodeTuple(
        city="Jackson",
        state="MS",
        postal="",
        lat=32.296111,
        lng=-90.207778,
        housenumber="",
        country="USA",
    ),
    "Lenoir-Rhyne College": SportsballGeocodeTuple(
        city="Hickory",
        state="NC",
        postal="",
        lat=35.740235,
        lng=-81.325501,
        housenumber="",
        country="USA",
    ),
    "Northwest Missouri State College": SportsballGeocodeTuple(
        city="Maryville",
        state="MO",
        postal="",
        lat=40.353306,
        lng=-94.8834,
        housenumber="",
        country="USA",
    ),
    "Chattanooga College": SportsballGeocodeTuple(
        city="Chattanooga",
        state="TN",
        postal="",
        lat=35.0458,
        lng=-85.2999,
        housenumber="",
        country="USA",
    ),
    "Baylor College": SportsballGeocodeTuple(
        city="Waco",
        state="TX",
        postal="",
        lat=31.548,
        lng=-97.116,
        housenumber="",
        country="USA",
    ),
    "Arizona State College": SportsballGeocodeTuple(
        city="Tempe",
        state="AZ",
        postal="",
        lat=33.4209,
        lng=-111.934,
        housenumber="",
        country="USA",
    ),
    "Morgan State College": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.343889,
        lng=-76.584722,
        housenumber="",
        country="USA",
    ),
    "South Florida College": SportsballGeocodeTuple(
        city="Highlands County",
        state="FL",
        postal="",
        lat=27.56909,
        lng=-81.50958,
        housenumber="",
        country="USA",
    ),
    "Arkansas College": SportsballGeocodeTuple(
        city="Fayetteville",
        state="AK",
        postal="",
        lat=36.068611,
        lng=-94.176111,
        housenumber="",
        country="USA",
    ),
    "Eastern Washington College": SportsballGeocodeTuple(
        city="Cheney",
        state="WA",
        postal="",
        lat=47.491389,
        lng=-117.583056,
        housenumber="",
        country="USA",
    ),
    "Georgia College": SportsballGeocodeTuple(
        city="Milledgeville",
        state="GA",
        postal="",
        lat=33.081389,
        lng=-83.230556,
        housenumber="",
        country="USA",
    ),
    "Friends University College": SportsballGeocodeTuple(
        city="Wichita",
        state="KS",
        postal="",
        lat=37.678333,
        lng=-97.366667,
        housenumber="",
        country="USA",
    ),
    "Idaho College": SportsballGeocodeTuple(
        city="Caldwell",
        state="ID",
        postal="",
        lat=43.653,
        lng=-116.676,
        housenumber="",
        country="USA",
    ),
    "Saginaw Valley State College": SportsballGeocodeTuple(
        city="University Center",
        state="MI",
        postal="",
        lat=43.5141,
        lng=-83.96156,
        housenumber="",
        country="USA",
    ),
    "Temple College": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="",
        lat=39.981389,
        lng=-75.154444,
        housenumber="",
        country="USA",
    ),
    "Southern Illinois College": SportsballGeocodeTuple(
        city="Carbondale",
        state="IL",
        postal="",
        lat=37.710426,
        lng=-89.219306,
        housenumber="",
        country="USA",
    ),
    "Grambling College": SportsballGeocodeTuple(
        city="Grambling",
        state="LA",
        postal="",
        lat=32.5252,
        lng=-92.7153,
        housenumber="",
        country="USA",
    ),
    "Western Colorado College": SportsballGeocodeTuple(
        city="Gunnison",
        state="CO",
        postal="",
        lat=38.549,
        lng=-106.92,
        housenumber="",
        country="USA",
    ),
    "Harvard College": SportsballGeocodeTuple(
        city="Cambridge",
        state="MA",
        postal="",
        lat=42.374,
        lng=-71.117,
        housenumber="",
        country="USA",
    ),
    "Wayne State (MI) College": SportsballGeocodeTuple(
        city="Detroit",
        state="MI",
        postal="",
        lat=42.357344,
        lng=-83.070106,
        housenumber="",
        country="USA",
    ),
    "Cincinnati College": SportsballGeocodeTuple(
        city="Cincinnati",
        state="OH",
        postal="",
        lat=39.132778,
        lng=-84.515278,
        housenumber="",
        country="USA",
    ),
    "UAB College": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.502,
        lng=-86.8079,
        housenumber="",
        country="USA",
    ),
    "Concordia-St. Paul College": SportsballGeocodeTuple(
        city="Saint Paul",
        state="MN",
        postal="",
        lat=44.949722,
        lng=-93.155,
        housenumber="",
        country="USA",
    ),
    "Peru State College College": SportsballGeocodeTuple(
        city="Peru",
        state="NB",
        postal="",
        lat=40.475,
        lng=-95.7325,
        housenumber="",
        country="USA",
    ),
    "Alberta College": SportsballGeocodeTuple(
        city="Edmonton",
        state="AL",
        postal="",
        lat=53.524444,
        lng=-113.524444,
        housenumber="",
        country="USA",
    ),
    "Syracuse College": SportsballGeocodeTuple(
        city="Syracuse",
        state="NY",
        postal="",
        lat=43.0376,
        lng=-76.134,
        housenumber="",
        country="USA",
    ),
    "Louisville College": SportsballGeocodeTuple(
        city="Louisville",
        state="KY",
        postal="",
        lat=38.215,
        lng=-85.760278,
        housenumber="",
        country="USA",
    ),
    "West Virginia College": SportsballGeocodeTuple(
        city="Morgantown",
        state="WV",
        postal="",
        lat=39.6458,
        lng=-79.9697,
        housenumber="",
        country="USA",
    ),
    "Sioux Falls College": SportsballGeocodeTuple(
        city="Sioux Falls",
        state="SD",
        postal="",
        lat=43.530778,
        lng=-96.738694,
        housenumber="",
        country="USA",
    ),
    "Nebraska College": SportsballGeocodeTuple(
        city="Lincoln",
        state="NB",
        postal="",
        lat=40.8175,
        lng=-96.701389,
        housenumber="",
        country="USA",
    ),
    "Norfolk State College": SportsballGeocodeTuple(
        city="Norfolk",
        state="VA",
        postal="",
        lat=36.8487,
        lng=-76.2625,
        housenumber="",
        country="USA",
    ),
    "Delaware College": SportsballGeocodeTuple(
        city="Newark",
        state="DE",
        postal="",
        lat=39.678333,
        lng=-75.751111,
        housenumber="",
        country="USA",
    ),
    "Massachusetts College": SportsballGeocodeTuple(
        city="North Adams",
        state="MA",
        postal="",
        lat=42.6917,
        lng=-73.1039,
        housenumber="",
        country="USA",
    ),
    "Indiana-Pennsylvania College": SportsballGeocodeTuple(
        city="Indiana",
        state="PA",
        postal="",
        lat=40.617,
        lng=-79.16,
        housenumber="",
        country="USA",
    ),
    "Youngstown State College": SportsballGeocodeTuple(
        city="Youngstown",
        state="OH",
        postal="",
        lat=41.1067,
        lng=-80.6503,
        housenumber="",
        country="USA",
    ),
    "Wisconsin-Whitewater College": SportsballGeocodeTuple(
        city="Whitewater",
        state="WI",
        postal="",
        lat=42.838339,
        lng=-88.743246,
        housenumber="",
        country="USA",
    ),
    "Dayton College": SportsballGeocodeTuple(
        city="Dayton",
        state="OH",
        postal="",
        lat=39.740415,
        lng=-84.179213,
        housenumber="",
        country="USA",
    ),
    "Indiana State College": SportsballGeocodeTuple(
        city="Terre Haute",
        state="IN",
        postal="",
        lat=39.47,
        lng=-87.41,
        housenumber="",
        country="USA",
    ),
    "Central Arkansas College": SportsballGeocodeTuple(
        city="Conway",
        state="AK",
        postal="",
        lat=35.077,
        lng=-92.457,
        housenumber="",
        country="USA",
    ),
    "Stephen F. Austin College": SportsballGeocodeTuple(
        city="Nacogdoches",
        state="TX",
        postal="",
        lat=31.619167,
        lng=-94.648333,
        housenumber="",
        country="USA",
    ),
    "Montana State College": SportsballGeocodeTuple(
        city="Bozeman",
        state="MT",
        postal="",
        lat=45.668333,
        lng=-111.05,
        housenumber="",
        country="USA",
    ),
    "Baldwin-Wallace College": SportsballGeocodeTuple(
        city="Berea",
        state="OH",
        postal="",
        lat=41.371111,
        lng=-81.847778,
        housenumber="",
        country="USA",
    ),
    "Culver-Stockton College College": SportsballGeocodeTuple(
        city="Canton",
        state="MO",
        postal="",
        lat=40.1295,
        lng=-91.5309,
        housenumber="",
        country="USA",
    ),
    "Ferris State College": SportsballGeocodeTuple(
        city="Big Rapids",
        state="MI",
        postal="",
        lat=43.69739,
        lng=-85.4839,
        housenumber="",
        country="USA",
    ),
    "Sacred Heart College": SportsballGeocodeTuple(
        city="Fairfield",
        state="CT",
        postal="",
        lat=41.2214,
        lng=-73.2419,
        housenumber="",
        country="USA",
    ),
    "Towson College": SportsballGeocodeTuple(
        city="Towson",
        state="MD",
        postal="",
        lat=39.394444,
        lng=-76.608333,
        housenumber="",
        country="USA",
    ),
    "Fort Hays State College": SportsballGeocodeTuple(
        city="Hays",
        state="KS",
        postal="",
        lat=38.873333,
        lng=-99.343333,
        housenumber="",
        country="USA",
    ),
    "Dartmouth College": SportsballGeocodeTuple(
        city="Hanover",
        state="NH",
        postal="",
        lat=43.703333,
        lng=-72.288333,
        housenumber="",
        country="USA",
    ),
    "Elon College": SportsballGeocodeTuple(
        city="Elon",
        state="NC",
        postal="",
        lat=36.106389,
        lng=-79.500833,
        housenumber="",
        country="USA",
    ),
    "Mars Hill College": SportsballGeocodeTuple(
        city="Mars Hill",
        state="NC",
        postal="",
        lat=35.82603,
        lng=-82.5507,
        housenumber="",
        country="USA",
    ),
    "East Tennessee State College": SportsballGeocodeTuple(
        city="Mars Hill",
        state="NC",
        postal="",
        lat=36.30333,
        lng=-82.36917,
        housenumber="",
        country="USA",
    ),
    "Rhode Island College": SportsballGeocodeTuple(
        city="Providence",
        state="RI",
        postal="",
        lat=41.842199,
        lng=-71.461161,
        housenumber="",
        country="USA",
    ),
    "South Dakota State College": SportsballGeocodeTuple(
        city="Brookings",
        state="SD",
        postal="",
        lat=44.318056,
        lng=-96.783333,
        housenumber="",
        country="USA",
    ),
    "Stony Brook College": SportsballGeocodeTuple(
        city="Stony Brook",
        state="NY",
        postal="",
        lat=40.917,
        lng=-73.124,
        housenumber="",
        country="USA",
    ),
    "Findlay College": SportsballGeocodeTuple(
        city="Findlay",
        state="OH",
        postal="",
        lat=41.055,
        lng=-83.655,
        housenumber="",
        country="USA",
    ),
    "Framingham State College": SportsballGeocodeTuple(
        city="Framingham",
        state="MA",
        postal="",
        lat=42.2977,
        lng=-71.4366,
        housenumber="",
        country="USA",
    ),
    "Marist College": SportsballGeocodeTuple(
        city="Poughkeepsie Town",
        state="NY",
        postal="",
        lat=41.725974,
        lng=-73.93354,
        housenumber="",
        country="USA",
    ),
    "Bemidji State College": SportsballGeocodeTuple(
        city="Bemidji",
        state="MN",
        postal="",
        lat=47.48175,
        lng=-94.87557,
        housenumber="",
        country="USA",
    ),
    "Akron College": SportsballGeocodeTuple(
        city="Akron",
        state="OH",
        postal="",
        lat=41.0752,
        lng=-81.5115,
        housenumber="",
        country="USA",
    ),
    "Canisius College": SportsballGeocodeTuple(
        city="Buffalo",
        state="NY",
        postal="",
        lat=42.925278,
        lng=-78.852778,
        housenumber="",
        country="USA",
    ),
    "Pennsylvania College": SportsballGeocodeTuple(
        city="Williamsport",
        state="PA",
        postal="",
        lat=41.235,
        lng=-77.021,
        housenumber="",
        country="USA",
    ),
    "North Carolina Central College": SportsballGeocodeTuple(
        city="Durham",
        state="NC",
        postal="",
        lat=35.974167,
        lng=-78.898611,
        housenumber="",
        country="USA",
    ),
    "Missouri Western College": SportsballGeocodeTuple(
        city="St. Joseph",
        state="MO",
        postal="",
        lat=39.7581,
        lng=-94.7856,
        housenumber="",
        country="USA",
    ),
    "Minnesota-Duluth College": SportsballGeocodeTuple(
        city="Duluth",
        state="MN",
        postal="",
        lat=46.8187754,
        lng=-92.0843306,
        housenumber="",
        country="USA",
    ),
    "Lane College College": SportsballGeocodeTuple(
        city="Jackson",
        state="TN",
        postal="",
        lat=35.62805,
        lng=-88.8063527,
        housenumber="",
        country="USA",
    ),
    "East Texas A&M College": SportsballGeocodeTuple(
        city="Commerce",
        state="TX",
        postal="",
        lat=33.2423,
        lng=-95.9077,
        housenumber="",
        country="USA",
    ),
    "Northern Colorado College": SportsballGeocodeTuple(
        city="Greeley",
        state="CO",
        postal="",
        lat=40.404853,
        lng=-104.696741,
        housenumber="",
        country="USA",
    ),
    "Colorado State-Pueblo College": SportsballGeocodeTuple(
        city="Pueblo",
        state="CO",
        postal="",
        lat=38.3075,
        lng=-104.578333,
        housenumber="",
        country="USA",
    ),
    "Stetson College": SportsballGeocodeTuple(
        city="DeLand",
        state="FL",
        postal="",
        lat=29.035,
        lng=-81.3026,
        housenumber="",
        country="USA",
    ),
    "North Dakota College": SportsballGeocodeTuple(
        city="Grand Forks",
        state="ND",
        postal="",
        lat=47.9222,
        lng=-97.0734,
        housenumber="",
        country="USA",
    ),
    "Western Carolina College": SportsballGeocodeTuple(
        city="Cullowhee",
        state="NC",
        postal="",
        lat=35.309722,
        lng=-83.183333,
        housenumber="",
        country="USA",
    ),
    "Brown College": SportsballGeocodeTuple(
        city="Providence",
        state="RI",
        postal="",
        lat=41.826111,
        lng=-71.403056,
        housenumber="",
        country="USA",
    ),
    "Minnesota State College": SportsballGeocodeTuple(
        city="Mankato",
        state="MN",
        postal="",
        lat=44.147,
        lng=-93.998,
        housenumber="",
        country="USA",
    ),
    "Loyola New Orleans College": SportsballGeocodeTuple(
        city="New Orleans",
        state="LA",
        postal="",
        lat=29.935,
        lng=-90.120833,
        housenumber="",
        country="USA",
    ),
    "Princeton College": SportsballGeocodeTuple(
        city="Princeton",
        state="NJ",
        postal="",
        lat=40.345278,
        lng=-74.656111,
        housenumber="",
        country="USA",
    ),
    "Mercer College": SportsballGeocodeTuple(
        city="Macon",
        state="GA",
        postal="",
        lat=32.829167,
        lng=-83.648611,
        housenumber="",
        country="USA",
    ),
    "Howard College": SportsballGeocodeTuple(
        city="Big Spring",
        state="TX",
        postal="",
        lat=32.2506,
        lng=-101.4511,
        housenumber="",
        country="USA",
    ),
    "Houston Christian College": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.694,
        lng=-95.515,
        housenumber="",
        country="USA",
    ),
    "Samford College": SportsballGeocodeTuple(
        city="Homewood",
        state="AL",
        postal="",
        lat=33.4649,
        lng=-86.7937,
        housenumber="",
        country="USA",
    ),
    "New Haven College": SportsballGeocodeTuple(
        city="West Haven",
        state="CT",
        postal="",
        lat=41.2919,
        lng=-72.9622,
        housenumber="",
        country="USA",
    ),
    "Valdosta State College": SportsballGeocodeTuple(
        city="Valdosta",
        state="GA",
        postal="",
        lat=30.847,
        lng=-83.2896,
        housenumber="",
        country="USA",
    ),
    "Lock Haven University College": SportsballGeocodeTuple(
        city="Lock Haven",
        state="PA",
        postal="",
        lat=41.141111,
        lng=-77.461111,
        housenumber="",
        country="USA",
    ),
    "Assumption College": SportsballGeocodeTuple(
        city="Worcester",
        state="MA",
        postal="",
        lat=42.2905,
        lng=-71.8295,
        housenumber="",
        country="USA",
    ),
    "Lafayette College": SportsballGeocodeTuple(
        city="Easton",
        state="PA",
        postal="",
        lat=40.698611,
        lng=-75.208056,
        housenumber="",
        country="USA",
    ),
    "San Diego College": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="",
        lat=32.71745,
        lng=-117.15255,
        housenumber="",
        country="USA",
    ),
    "Azusa Pacific College": SportsballGeocodeTuple(
        city="Azusa",
        state="CA",
        postal="",
        lat=34.12971,
        lng=-117.88888,
        housenumber="",
        country="USA",
    ),
    "Campbell College": SportsballGeocodeTuple(
        city="Buies Creek",
        state="NC",
        postal="",
        lat=35.408333,
        lng=-78.739444,
        housenumber="",
        country="USA",
    ),
    "Alcorn State College": SportsballGeocodeTuple(
        city="Alcorn State",
        state="MS",
        postal="",
        lat=31.8769,
        lng=-91.1411,
        housenumber="",
        country="USA",
    ),
    "Northern Arizona College": SportsballGeocodeTuple(
        city="Flagstaff",
        state="AZ",
        postal="",
        lat=35.1875,
        lng=-111.655,
        housenumber="",
        country="USA",
    ),
    "UC Davis College": SportsballGeocodeTuple(
        city="Davis",
        state="CA",
        postal="",
        lat=38.54,
        lng=-121.75,
        housenumber="",
        country="USA",
    ),
    "UAlbany College": SportsballGeocodeTuple(
        city="Albany",
        state="NY",
        postal="",
        lat=42.686,
        lng=-73.824,
        housenumber="",
        country="USA",
    ),
    "Fort Valley State College": SportsballGeocodeTuple(
        city="Fort Valley",
        state="GA",
        postal="",
        lat=32.534417,
        lng=-83.896056,
        housenumber="",
        country="USA",
    ),
    "Washburn College": SportsballGeocodeTuple(
        city="Topeka",
        state="KS",
        postal="",
        lat=39.033786,
        lng=-95.698975,
        housenumber="",
        country="USA",
    ),
    "Shepherd College": SportsballGeocodeTuple(
        city="Shepherdstown",
        state="WV",
        postal="",
        lat=39.436389,
        lng=-77.808333,
        housenumber="",
        country="USA",
    ),
    "Central Connecticut College": SportsballGeocodeTuple(
        city="New Britain",
        state="CT",
        postal="",
        lat=41.693,
        lng=-72.765,
        housenumber="",
        country="USA",
    ),
    "William & Mary College": SportsballGeocodeTuple(
        city="Williamsburg",
        state="VA",
        postal="",
        lat=37.270833,
        lng=-76.708333,
        housenumber="",
        country="USA",
    ),
    "Kutztown College": SportsballGeocodeTuple(
        city="Kutztown",
        state="PA",
        postal="",
        lat=40.511,
        lng=-75.783,
        housenumber="",
        country="USA",
    ),
    "Charleston (WV) College": SportsballGeocodeTuple(
        city="Charleston",
        state="WV",
        postal="",
        lat=38.332917,
        lng=-81.616524,
        housenumber="",
        country="USA",
    ),
    "University of Laval College": SportsballGeocodeTuple(
        city="Quebec City",
        state="QC",
        postal="",
        lat=46.78,
        lng=-71.274722,
        housenumber="",
        country="Canada",
    ),
    "Bryant College": SportsballGeocodeTuple(
        city="Smithfield",
        state="RI",
        postal="",
        lat=41.92545,
        lng=-71.53241,
        housenumber="",
        country="USA",
    ),
    "Virginia State College": SportsballGeocodeTuple(
        city="Petersburg",
        state="VA",
        postal="",
        lat=37.238379,
        lng=-77.419818,
        housenumber="",
        country="USA",
    ),
    "East Central (OK) College": SportsballGeocodeTuple(
        city="Ada",
        state="OK",
        postal="",
        lat=34.774444,
        lng=-96.664722,
        housenumber="",
        country="USA",
    ),
    "Wagner College": SportsballGeocodeTuple(
        city="Staten Island",
        state="NY",
        postal="",
        lat=40.615,
        lng=-74.094,
        housenumber="",
        country="USA",
    ),
    "Minot State Universi College": SportsballGeocodeTuple(
        city="Minot",
        state="ND",
        postal="",
        lat=48.246,
        lng=-101.301,
        housenumber="",
        country="USA",
    ),
    "Furman College": SportsballGeocodeTuple(
        city="Greenville",
        state="SC",
        postal="",
        lat=34.925833,
        lng=-82.435556,
        housenumber="",
        country="USA",
    ),
    "Saint John's (MN) College": SportsballGeocodeTuple(
        city="St. Joseph",
        state="MN",
        postal="",
        lat=45.5812104,
        lng=-94.3942241,
        housenumber="",
        country="USA",
    ),
    "Drake College": SportsballGeocodeTuple(
        city="Des Moines",
        state="IO",
        postal="",
        lat=41.602222,
        lng=-93.654167,
        housenumber="",
        country="USA",
    ),
    "Fordham College": SportsballGeocodeTuple(
        city="New York",
        state="NY",
        postal="",
        lat=40.861944,
        lng=-73.886111,
        housenumber="",
        country="USA",
    ),
    "New Hampshire College": SportsballGeocodeTuple(
        city="Durham",
        state="NH",
        postal="",
        lat=43.136389,
        lng=-70.932222,
        housenumber="",
        country="USA",
    ),
    "Lindenwood College": SportsballGeocodeTuple(
        city="St. Charles",
        state="MO",
        postal="",
        lat=38.787,
        lng=-90.503,
        housenumber="",
        country="USA",
    ),
    "Prairie View A&M College": SportsballGeocodeTuple(
        city="Prairie View",
        state="TX",
        postal="",
        lat=30.09194,
        lng=-95.98944,
        housenumber="",
        country="USA",
    ),
    "Barton College College": SportsballGeocodeTuple(
        city="Wilson",
        state="NC",
        postal="",
        lat=35.73536,
        lng=-77.913175,
        housenumber="",
        country="USA",
    ),
    "SE Louisiana College": SportsballGeocodeTuple(
        city="Hammond",
        state="LA",
        postal="",
        lat=30.513889,
        lng=-90.468333,
        housenumber="",
        country="USA",
    ),
    "The Citadel College": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="",
        lat=32.797222,
        lng=-79.961111,
        housenumber="",
        country="USA",
    ),
    "Regina (Canada) College": SportsballGeocodeTuple(
        city="Regina",
        state="SK",
        postal="",
        lat=50.415553,
        lng=-104.587953,
        housenumber="",
        country="Canada",
    ),
    "Tusculum College": SportsballGeocodeTuple(
        city="Tusculum",
        state="TN",
        postal="",
        lat=36.173,
        lng=-82.7616,
        housenumber="",
        country="USA",
    ),
    "Northwestern State College": SportsballGeocodeTuple(
        city="Natchitoches",
        state="LA",
        postal="",
        lat=31.75,
        lng=-93.0972,
        housenumber="",
        country="USA",
    ),
    "Manitoba College": SportsballGeocodeTuple(
        city="Winnipeg",
        state="MB",
        postal="",
        lat=49.809444,
        lng=-97.132778,
        housenumber="",
        country="Canada",
    ),
    "Bucknell College": SportsballGeocodeTuple(
        city="Lewisburg",
        state="PA",
        postal="",
        lat=40.954722,
        lng=-76.883611,
        housenumber="",
        country="USA",
    ),
    "Southern College": SportsballGeocodeTuple(
        city="Baton Rouge",
        state="LA",
        postal="",
        lat=30.524674,
        lng=-91.190034,
        housenumber="",
        country="USA",
    ),
    "Slippery Rock College": SportsballGeocodeTuple(
        city="Slippery Rock",
        state="PA",
        postal="",
        lat=41.062,
        lng=-80.043,
        housenumber="",
        country="USA",
    ),
    "Ithaca College": SportsballGeocodeTuple(
        city="Ithaca",
        state="NY",
        postal="",
        lat=42.4218,
        lng=-76.4947,
        housenumber="",
        country="USA",
    ),
    "Northern Michigan College": SportsballGeocodeTuple(
        city="Marquette",
        state="MI",
        postal="",
        lat=46.55901,
        lng=-87.40525,
        housenumber="",
        country="USA",
    ),
    "Richmond College": SportsballGeocodeTuple(
        city="Richmond",
        state="VA",
        postal="",
        lat=37.5775,
        lng=-77.537778,
        housenumber="",
        country="USA",
    ),
    "Maine College": SportsballGeocodeTuple(
        city="Orono",
        state="ME",
        postal="",
        lat=44.902,
        lng=-68.668,
        housenumber="",
        country="USA",
    ),
    "Austin Peay College": SportsballGeocodeTuple(
        city="Clarksville",
        state="TN",
        postal="",
        lat=36.5323,
        lng=-87.35457,
        housenumber="",
        country="USA",
    ),
    "Malone University College": SportsballGeocodeTuple(
        city="Canton",
        state="OH",
        postal="",
        lat=40.826,
        lng=-81.3765,
        housenumber="",
        country="USA",
    ),
    "Albany State College": SportsballGeocodeTuple(
        city="Albany",
        state="GA",
        postal="",
        lat=31.569,
        lng=-84.142,
        housenumber="",
        country="USA",
    ),
    "Tarleton State College": SportsballGeocodeTuple(
        city="Stephenville",
        state="TX",
        postal="",
        lat=32.2139,
        lng=-98.2154,
        housenumber="",
        country="USA",
    ),
    "Virginia Commonwealth College": SportsballGeocodeTuple(
        city="Richmond",
        state="VA",
        postal="",
        lat=37.5466,
        lng=-77.4533,
        housenumber="",
        country="USA",
    ),
    "UNC Pembroke College": SportsballGeocodeTuple(
        city="Pembroke",
        state="NC",
        postal="",
        lat=34.6876,
        lng=-79.202,
        housenumber="",
        country="USA",
    ),
    "Bowie State College": SportsballGeocodeTuple(
        city="Bowie",
        state="MD",
        postal="",
        lat=39.02158,
        lng=-76.75684,
        housenumber="",
        country="USA",
    ),
    "KeyBank Center, Buffalo, NY, USA": KEYBANK_CENTER,
    "Scotiabank Arena": SCOTIABANK_ARENA,
    "Citizens Bank Park, Philadelphia, PA, USA": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="",
        lat=39.905833,
        lng=-75.166389,
        housenumber="",
        country="USA",
    ),
    "Louisiana Tech University": SportsballGeocodeTuple(
        city="Ruston",
        state="LA",
        postal="",
        lat=32.5275,
        lng=-92.6475,
        housenumber="",
        country="USA",
    ),
    "Newport, Maine, United States": SportsballGeocodeTuple(
        city="Newport",
        state="ME",
        postal="",
        lat=44.836667,
        lng=-69.2725,
        housenumber="",
        country="USA",
    ),
    "M. M. Roberts Stadium": M_M_ROBERTS_STADIUM,
    "Los Angeles Memorial Coliseum, Los Angeles, CA, USA": LOS_ANGELES_MEMORIAL_COLESIUM,
    "Murray State College": SportsballGeocodeTuple(
        city="Tishomingo",
        state="OK",
        postal="",
        lat=34.222222,
        lng=-96.675833,
        housenumber="",
        country="USA",
    ),
    "Fayetteville State College": SportsballGeocodeTuple(
        city="Fayetteville",
        state="NC",
        postal="",
        lat=35.072,
        lng=-78.8945,
        housenumber="",
        country="USA",
    ),
    "West Alabama College": SportsballGeocodeTuple(
        city="Livingston",
        state="AL",
        postal="",
        lat=32.59,
        lng=-88.186,
        housenumber="",
        country="USA",
    ),
    "Chur, Switzerland": SportsballGeocodeTuple(
        city="Chur",
        state="",
        postal="",
        lat=46.85,
        lng=9.533333,
        housenumber="",
        country="Switzerland",
    ),
    "Nationwide Arena, Columbus, OH, USA": NATIONWIDE_ARENA,
    "PNC Park, Pittsburgh, PA, USA": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.446944,
        lng=-80.005833,
        housenumber="115",
        country="USA",
    ),
    "Wurzburg, Bavaria, DE": SportsballGeocodeTuple(
        city="Wurzburg",
        state="Bavaria",
        postal="",
        lat=49.783333,
        lng=9.933333,
        housenumber="",
        country="Germany",
    ),
    "Atlanta, GA, United States": ATLANTA,
    "McDonald Township, OH, United States": SportsballGeocodeTuple(
        city="McDonald Township",
        state="OH",
        postal="",
        lat=41.163611,
        lng=-80.723333,
        housenumber="",
        country="Germany",
    ),
    "Cedar Falls, Iowa, United States": CEDAR_FALLS,
    "Maryland Stadium": SportsballGeocodeTuple(
        city="College Park",
        state="MD",
        postal="20742",
        lat=38.990278,
        lng=-76.947222,
        housenumber="90",
        country="USA",
    ),
    "Highmark Stadium, Orchard Park, NY, USA": HIGHMARK_STADIUM,
    "Canada Life Centre": CANADA_LIFE_CENTER,
    "Comiskey Park - Chicago, IL - United States": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="",
        lat=41.831667,
        lng=-87.634167,
        housenumber="324",
        country="USA",
    ),
    "Southern Utah College": SportsballGeocodeTuple(
        city="Cedar City",
        state="UT",
        postal="",
        lat=37.675448,
        lng=-113.071632,
        housenumber="",
        country="USA",
    ),
    "Southern Arkansas College": SportsballGeocodeTuple(
        city="Magnolia",
        state="AK",
        postal="",
        lat=33.291667,
        lng=-93.236111,
        housenumber="",
        country="USA",
    ),
    "Humboldt State College": SportsballGeocodeTuple(
        city="Arcata",
        state="CA",
        postal="",
        lat=40.876,
        lng=-124.079,
        housenumber="",
        country="USA",
    ),
    "Missouri S&T College": SportsballGeocodeTuple(
        city="Rolla",
        state="MO",
        postal="",
        lat=37.955544,
        lng=-91.773513,
        housenumber="",
        country="USA",
    ),
    "Montana College": SportsballGeocodeTuple(
        city="Missoula",
        state="MT",
        postal="",
        lat=46.86,
        lng=-113.985278,
        housenumber="",
        country="USA",
    ),
    "Duquesne College": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.436111,
        lng=-79.993056,
        housenumber="",
        country="USA",
    ),
    "Missouri State College": SportsballGeocodeTuple(
        city="Springfield",
        state="MO",
        postal="",
        lat=37.19971,
        lng=-93.28079,
        housenumber="",
        country="USA",
    ),
    "UT Martin College": SportsballGeocodeTuple(
        city="Martin",
        state="TN",
        postal="",
        lat=36.341754,
        lng=-88.867097,
        housenumber="",
        country="USA",
    ),
    "Western Illinois College": SportsballGeocodeTuple(
        city="Macomb",
        state="IL",
        postal="",
        lat=40.470392,
        lng=-90.68774,
        housenumber="",
        country="USA",
    ),
    "Greenville College": SportsballGeocodeTuple(
        city="Greenville",
        state="IL",
        postal="",
        lat=38.893611,
        lng=-89.408611,
        housenumber="",
        country="USA",
    ),
    "St. John's University": SportsballGeocodeTuple(
        city="New York",
        state="NY",
        postal="",
        lat=40.721944,
        lng=-73.795556,
        housenumber="",
        country="USA",
    ),
    "Alumni Stadium": ALUMNI_STADIUM,
    "Acrisure Stadium, Pittsburgh, PA, USA": ACRISURE_STADIUM,
    "PPG Paints Arena, Pittsburgh, PA, USA": PPG_PAINTS_ARENA,
    "Capital One Arena": CAPITAL_ONE_ARENA,
    "Nevada": SportsballGeocodeTuple(
        city="",
        state="NV",
        postal="",
        lat=39.0,
        lng=-117.0,
        housenumber="",
        country="USA",
    ),
    "Legacy Center": LEGACY_CENTER,
    "Kinnick Stadium - Iowa City, Iowa, USA - United States": KINNICK_STADIUM,
    "Lincoln Financial Field, Philadelphia, PA, USA": LINCOLN_FINANCIAL_FIELD,
    "Wainwright, Alberta, Canada": SportsballGeocodeTuple(
        city="Wainwright",
        state="AL",
        postal="",
        lat=52.833333,
        lng=-110.866667,
        housenumber="",
        country="Canada",
    ),
    "SAP Center, San Jose, CA, USA": SportsballGeocodeTuple(
        city="San Jose",
        state="CA",
        postal="",
        lat=37.332778,
        lng=-121.901111,
        housenumber="525",
        country="USA",
    ),
    "T-Mobile Arena": T_MOBILE_ARENA,
    "Commonwealth Stadium - Edmonton, AB - Canada": SportsballGeocodeTuple(
        city="Edmonton",
        state="AB",
        postal="",
        lat=53.558333,
        lng=-113.475,
        housenumber="",
        country="Canada",
    ),
    "EverBank Stadium, Jacksonville, FL, USA": EVERBANK_STADIUM,
    "Enterprise Center": ENTERPRISE_CENTER,
    "Sanford Stadium - Athens, Georgia, USA - United States": SANFORD_STADIUM,
    "Lumen Field, Seattle, WA, USA": LUMEN_FIELD,
    "Rogers Arena, Vancouver, BC, Canada": ROGERS_ARENA,
    "Nationals Park, Washington, DC, USA": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="",
        lat=38.872778,
        lng=-77.0075,
        housenumber="1500",
        country="USA",
    ),
    "Ball Arena": PEPSI_CENTRE,
    "Kauffman Stadium - Kansas City, MO - United States": SportsballGeocodeTuple(
        city="Kansas City",
        state="MO",
        postal="",
        lat=39.051389,
        lng=-94.480556,
        housenumber="1",
        country="USA",
    ),
    "Katy, TX, United States": SportsballGeocodeTuple(
        city="Katy",
        state="TX",
        postal="",
        lat=29.785786,
        lng=-95.824394,
        housenumber="",
        country="USA",
    ),
    "Panama, Panama, Panama": SportsballGeocodeTuple(
        city="Panama",
        state="",
        postal="",
        lat=8.971111,
        lng=-79.534722,
        housenumber="",
        country="Panama",
    ),
}


def _create_google_address_model(
    query: str, session: requests_cache.CachedSession, dt: datetime.datetime | None
) -> AddressModel:
    query = query.replace("\n", "").replace("&nbsp;", " ")
    g = _CACHED_GEOCODES.get(query)
    if g is None:
        logging.warning("Failed to find query: %s", query)
        g = geocoder.google(query, session=session)
        _CACHED_GEOCODES[query] = g
    latitude = g.lat
    longitude = g.lng
    weather_model = None
    tz = "UTC"
    altitude = None
    if latitude is not None and longitude is not None:
        tf = TimezoneFinder()
        timezone = tf.timezone_at(lng=longitude, lat=latitude)
        if timezone is not None:
            tz = timezone
        if dt is not None:
            weather_model = create_mutli_weather_model(
                session,
                latitude,
                longitude,
                dt,  # pyright: ignore
                tz,
            )
        if not pytest_is_running.is_running():
            try:
                altitude = get_elevation(lat=latitude, lon=longitude)
            except zipfile.BadZipFile:
                url = f"https://api.opentopodata.org/v1/aster30m?locations={latitude},{longitude}"
                r = session.get(url)
                r.raise_for_status()
                data = r.json()
                altitude = data["results"][0]["elevation"]
    try:
        return AddressModel(
            city=g.city,
            state=g.state,
            zipcode=g.postal,
            latitude=latitude,
            longitude=longitude,
            housenumber=g.housenumber,
            weather=weather_model,  # pyright: ignore
            timezone=tz,
            country=g.country,
            altitude=altitude,
        )
    except Exception as exc:
        logging.warning('Failed to retrieve address model for query "%s"', query)
        raise ValueError(f'AddressModel failed to validate: "{query}"') from exc


@MEMORY.cache(ignore=["session"])
def _cached_create_google_address_model(
    query: str, session: requests_cache.CachedSession, dt: datetime.datetime | None
) -> AddressModel:
    return _create_google_address_model(query=query, session=session, dt=dt)


def create_google_address_model(
    query: str, session: requests_cache.CachedSession, dt: datetime.datetime | None
) -> AddressModel:
    """Create address model from google."""
    if not pytest_is_running.is_running():
        return _cached_create_google_address_model(query=query, session=session, dt=dt)
    with session.cache_disabled():
        return _create_google_address_model(query=query, session=session, dt=dt)
