"""Added mission_logs table

Revision ID: 14e268184cc5
Revises: d4cc3d4afdb9
Create Date: 2024-10-15 20:28:12.426250

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '14e268184cc5'
down_revision = 'd4cc3d4afdb9'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('mission_logs',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('content', sa.String(length=255), nullable=False),
    sa.Column('creator_uid', sa.String(length=255), nullable=False),
    sa.Column('entry_uid', sa.String(length=255), nullable=False),
    sa.Column('mission_name', sa.String(length=255), nullable=False),
    sa.Column('server_time', sa.DateTime(), nullable=False),
    sa.Column('dtg', sa.DateTime(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('content_hash', sa.String(length=255), nullable=True),
    sa.Column('keywords', sa.JSON(), nullable=False),
    sa.ForeignKeyConstraint(['mission_name'], ['missions.name'], name="mission_logs"),
    sa.PrimaryKeyConstraint('id')
    )
    with op.batch_alter_table('mission_invitations', schema=None) as batch_op:
        batch_op.create_foreign_key('euds', 'euds', ['client_uid'], ['uid'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('mission_invitations', schema=None) as batch_op:
        batch_op.drop_constraint('euds', type_='foreignkey')

    op.drop_table('mission_logs')
    # ### end Alembic commands ###
