"""Fixed mission_changes and mission_uids relationship

Revision ID: 21fb5a21f356
Revises: 795ebb9262d8
Create Date: 2024-11-08 14:09:41.129561

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '21fb5a21f356'
down_revision = '795ebb9262d8'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('mission_changes', schema=None) as batch_op:
        batch_op.add_column(sa.Column('mission_uid', sa.String(length=255), nullable=True))
        batch_op.create_foreign_key('mission_change_uid', 'mission_uids', ['mission_uid'], ['uid'], ondelete='CASCADE')

    with op.batch_alter_table('mission_uids', schema=None) as batch_op:
        batch_op.drop_constraint('mission_change', type_='foreignkey')
        batch_op.drop_column('mission_change_id')

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('mission_uids', schema=None) as batch_op:
        batch_op.add_column(sa.Column('mission_change_id', sa.INTEGER(), nullable=True))
        batch_op.create_foreign_key('mission_change', 'mission_changes', ['mission_change_id'], ['id'])

    with op.batch_alter_table('mission_changes', schema=None) as batch_op:
        batch_op.drop_constraint('mission_change_uid', type_='foreignkey')
        batch_op.drop_column('mission_uid')

    # ### end Alembic commands ###
