"""Added device_profile and package tables

Revision ID: 414b87c32cc2
Revises: d91957bb59a0
Create Date: 2024-09-05 19:17:20.979466

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '414b87c32cc2'
down_revision = 'd91957bb59a0'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('device_profiles',
    sa.Column('preference_key', sa.String(length=255), nullable=False),
    sa.Column('preference_value', sa.String(length=255), nullable=False),
    sa.Column('value_class', sa.String(length=255), nullable=False),
    sa.Column('enrollment', sa.Boolean(), nullable=True),
    sa.Column('connection', sa.Boolean(), nullable=True),
    sa.Column('tool', sa.String(length=255), nullable=True),
    sa.Column('active', sa.Boolean(), nullable=False),
    sa.Column('publish_time', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.PrimaryKeyConstraint('preference_key')
    )
    op.create_table('packages',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('platform', sa.String(length=255), nullable=False),
    sa.Column('plugin_type', sa.String(length=255), nullable=False),
    sa.Column('package_name', sa.String(length=255), nullable=False),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.Column('file_name', sa.String(length=255), nullable=False),
    sa.Column('version', sa.String(length=255), nullable=False),
    sa.Column('revision_code', sa.Integer(), nullable=True),
    sa.Column('description', sa.Integer(), nullable=True),
    sa.Column('apk_hash', sa.Integer(), nullable=True),
    sa.Column('os_requirement', sa.Integer(), nullable=True),
    sa.Column('tak_prereq', sa.Integer(), nullable=True),
    sa.Column('file_size', sa.Integer(), nullable=False),
    sa.Column('icon', sa.LargeBinary(), nullable=True),
    sa.Column('icon_filename', sa.String(length=255), nullable=True),
    sa.Column('install_on_enrollment', sa.Boolean(), nullable=True),
    sa.Column('install_on_connection', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('package_name')
    )
    with op.batch_alter_table('data_packages', schema=None) as batch_op:
        batch_op.add_column(sa.Column('install_on_enrollment', sa.Boolean(), nullable=True))
        batch_op.add_column(sa.Column('install_on_connection', sa.Boolean(), nullable=True))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('data_packages', schema=None) as batch_op:
        batch_op.drop_column('install_on_connection')
        batch_op.drop_column('install_on_enrollment')

    op.drop_table('packages')
    op.drop_table('device_profiles')
    # ### end Alembic commands ###
