"""Updated groups_users table

Revision ID: ab719ee9b322
Revises: e8bd877719e2
Create Date: 2025-10-28 19:10:38.181780

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'ab719ee9b322'
down_revision = 'e8bd877719e2'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('groups', schema=None) as batch_op:
        batch_op.create_unique_constraint("groups_name_key", ['name'])

    with op.batch_alter_table('groups_users', schema=None) as batch_op:
        batch_op.drop_column('id')
        batch_op.create_primary_key("groups_users_pkey", ["user_id", "group_id", "direction"])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('groups_users', schema=None) as batch_op:
        batch_op.add_column(sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False))

    with op.batch_alter_table('groups', schema=None) as batch_op:
        batch_op.drop_constraint("groups_name_key", type_='unique')

    # ### end Alembic commands ###
