"""Added mission_logs table

Revision ID: bde915ea136e
Revises: d31bff4a15c7
Create Date: 2024-10-10 18:13:29.597437

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'bde915ea136e'
down_revision = 'd31bff4a15c7'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('mission_logs',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('content', sa.String(length=255), nullable=False),
    sa.Column('creator_uid', sa.String(length=255), nullable=False),
    sa.Column('entry_uid', sa.String(length=255), nullable=False),
    sa.Column('mission_name', sa.String(length=255), nullable=False),
    sa.Column('server_time', sa.DateTime(), nullable=False),
    sa.Column('dtg', sa.DateTime(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('content_hash', sa.String(length=255), nullable=True),
    sa.Column('keywords', sa.JSON(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    with op.batch_alter_table('mission_content', schema=None) as batch_op:
        batch_op.alter_column('hash',
               existing_type=sa.String(length=255),
               nullable=False)
        #batch_op.drop_index('hash_index')
        batch_op.create_unique_constraint("hash_index", ['hash'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('mission_content', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='unique')
        batch_op.create_index('hash_index', ['hash'], unique=1)
        batch_op.alter_column('hash',
               existing_type=sa.String(length=255),
               nullable=True)

    op.drop_table('mission_logs')
    # ### end Alembic commands ###
