"""Update for group support

Revision ID: e8bd877719e2
Revises: 3a7ea7ead17b
Create Date: 2025-10-08 18:56:33.910860

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'e8bd877719e2'
down_revision = '3a7ea7ead17b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('groups_users',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('group_id', sa.Integer(), nullable=False),
    sa.Column('direction', sa.String(length=255), nullable=False),
    sa.Column('enabled', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['group_id'], ['groups.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.drop_table('groups_euds')

    with op.batch_alter_table('groups', schema=None) as batch_op:
        batch_op.add_column(sa.Column('name', sa.String(length=255), nullable=False))
        batch_op.add_column(sa.Column('distinguishedName', sa.String(length=255), nullable=True))
        batch_op.add_column(sa.Column('type', sa.String(length=255), nullable=False))
        batch_op.add_column(sa.Column('description', sa.String(), nullable=True))
        batch_op.drop_column('group_type')
        batch_op.drop_column('group_name')

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('groups', schema=None) as batch_op:
        batch_op.add_column(sa.Column('group_name', sa.VARCHAR(length=255), autoincrement=False, nullable=False))
        batch_op.add_column(sa.Column('group_type', sa.VARCHAR(length=255), autoincrement=False, nullable=False))
        batch_op.drop_column('description')
        batch_op.drop_column('type')
        batch_op.drop_column('distinguishedName')
        batch_op.drop_column('name')

    op.create_table('groups_euds',
    sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
    sa.Column('group_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('direction', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('active', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('description', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('eud_uid', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['eud_uid'], ['euds.uid'], name=op.f('group_eud'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['group_id'], ['groups.id'], name=op.f('group')),
    sa.PrimaryKeyConstraint('id', name=op.f('groups_euds_pkey'))
    )
    op.drop_table('groups_users')
    # ### end Alembic commands ###
