# generated by datamodel-codegen:
#   filename:  api/data/createSearchIndex.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import searchIndex
from ...type import basic, entityReferenceList, lifeCycle, tagLabel


class CreateSearchIndexRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this SearchIndex instance uniquely.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this SearchIndex.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='Description of the SearchIndex instance. What it has and how to use it.',
        ),
    ]
    service: Annotated[
        basic.FullyQualifiedEntityName,
        Field(
            description='Fully qualified name of the search service where this searchIndex is hosted in'
        ),
    ]
    fields: Annotated[
        List[searchIndex.SearchIndexField],
        Field(description='Fields in this SearchIndex.'),
    ]
    searchIndexSettings: Annotated[
        Optional[searchIndex.SearchIndexSettings],
        Field(None, description='Contains key/value pair of searchIndex settings.'),
    ]
    indexType: Annotated[
        Optional[searchIndex.IndexType],
        Field(
            searchIndex.IndexType.Index,
            description='Whether the entity is index or index template.',
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this SearchIndex'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this SearchIndex'),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    domains: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='Fully qualified names of the domains the SearchIndex belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
