# generated by datamodel-codegen:
#   filename:  api/data/createStoredProcedure.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import storedProcedure
from ...type import basic, entityReferenceList, lifeCycle, tagLabel


class CreateStoredProcedureRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[basic.EntityName, Field(description='Name of a Stored Procedure.')]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this Stored Procedure.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Stored Procedure.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this entity'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this StoredProcedure.'),
    ]
    storedProcedureCode: Annotated[
        storedProcedure.StoredProcedureCode, Field(description='SQL Query definition.')
    ]
    storedProcedureType: Annotated[
        Optional[storedProcedure.StoredProcedureType],
        Field(
            storedProcedure.StoredProcedureType.StoredProcedure,
            description='Type of the Stored Procedure.',
        ),
    ]
    databaseSchema: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description='Link to the database schema fully qualified name where this stored procedure is hosted in',
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(None, description='Source URL of database schema.'),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Stored Procedure belongs to.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
