# generated by datamodel-codegen:
#   filename:  api/data/createWorksheet.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import table
from ...type import basic, entityReferenceList, lifeCycle, tagLabel


class CreateWorksheetRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this worksheet.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this worksheet.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the worksheet.'),
    ]
    spreadsheet: Annotated[
        basic.FullyQualifiedEntityName,
        Field(description='Link to the parent spreadsheet fully qualified name'),
    ]
    service: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description='Link to the drive service fully qualified name where this worksheet is hosted in',
        ),
    ]
    worksheetId: Annotated[
        Optional[str], Field(None, description='Native worksheet/tab ID')
    ]
    index: Annotated[
        Optional[int],
        Field(None, description='Position/index of the worksheet in the spreadsheet'),
    ]
    rowCount: Annotated[
        Optional[int], Field(None, description='Number of rows in the worksheet')
    ]
    columnCount: Annotated[
        Optional[int], Field(None, description='Number of columns in the worksheet')
    ]
    columns: Annotated[
        Optional[List[table.Column]],
        Field([], description='Column definitions if structured data'),
    ]
    isHidden: Annotated[
        Optional[bool], Field(False, description='Whether the worksheet is hidden')
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl], Field(None, description='Source URL of worksheet.')
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Worksheet.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this worksheet'),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    domains: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='Fully qualified names of the domains the Worksheet belongs to.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
