# generated by datamodel-codegen:
#   filename:  api/mcp/mcpSearchResponse.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from typing import Any, Dict, List, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import table
from ...type import entityReference, tagLabel


class SearchResultEntity(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[Optional[str], Field(None, description='Name of the entity')]
    displayName: Annotated[
        Optional[str], Field(None, description='Display name of the entity')
    ]
    fullyQualifiedName: Annotated[
        Optional[str], Field(None, description='Fully qualified name of the entity')
    ]
    description: Annotated[
        Optional[str], Field(None, description='Description of the entity')
    ]
    entityType: Annotated[
        Optional[str],
        Field(None, description='Type of the entity (table, topic, dashboard, etc.)'),
    ]
    service: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Service reference containing the entity'),
    ]
    database: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Database reference (for table entities)'),
    ]
    databaseSchema: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Database schema reference (for table entities)'),
    ]
    serviceType: Annotated[
        Optional[str], Field(None, description='Type of the service')
    ]
    href: Annotated[
        Optional[AnyUrl],
        Field(None, description='Link to the entity in OpenMetadata UI'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags associated with the entity'),
    ]
    owners: Annotated[
        Optional[List[entityReference.EntityReference]],
        Field(None, description='Owners of the entity'),
    ]
    tier: Annotated[
        Optional[tagLabel.TagLabel],
        Field(None, description='Tier information for the entity'),
    ]
    tableType: Annotated[
        Optional[str], Field(None, description='Type of table (for table entities)')
    ]
    columnNames: Annotated[
        Optional[List[str]],
        Field(None, description='List of column names (for table entities)'),
    ]
    columns: Annotated[
        Optional[List[table.Column]],
        Field(None, description='Detailed column information (when requested)'),
    ]
    schemaDefinition: Annotated[
        Optional[str], Field(None, description='Schema definition (when requested)')
    ]
    queries: Annotated[
        Optional[List[str]], Field(None, description='Sample queries (when requested)')
    ]
    upstreamLineage: Annotated[
        Optional[Dict[str, Any]],
        Field(None, description='Upstream lineage information (when requested)'),
    ]
    entityRelationship: Annotated[
        Optional[Dict[str, Any]],
        Field(None, description='Entity relationships (when requested)'),
    ]


class McpSearchResponse(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    results: Annotated[
        List[SearchResultEntity], Field(description='Array of search result entities')
    ]
    totalFound: Annotated[
        int,
        Field(
            description='Total number of entities found matching the search criteria'
        ),
    ]
    returnedCount: Annotated[
        int, Field(description='Number of entities returned in this response')
    ]
    query: Annotated[str, Field(description='The original search query used')]
    message: Annotated[
        Optional[str],
        Field(None, description='Informational message about the search results'),
    ]
    hasMore: Annotated[
        Optional[bool],
        Field(None, description='Whether there are more results available'),
    ]
