# generated by datamodel-codegen:
#   filename:  api/services/createDatabaseService.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.services import databaseService
from ...type import basic, entityReference, entityReferenceList, tagLabel


class CreateDatabaseServiceRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies the this entity instance uniquely'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this database service.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of Database entity.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Database Service.'),
    ]
    serviceType: databaseService.DatabaseServiceType
    connection: Optional[databaseService.DatabaseConnection] = None
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this database service.'),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Database Service belongs to.',
        ),
    ]
    ingestionRunner: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='The ingestion agent responsible for executing the ingestion pipeline. It will be defined at runtime based on the Ingestion Agent of the service.',
        ),
    ]
