# generated by datamodel-codegen:
#   filename:  api/teams/createPersona.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic


class CreatePersonaRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: basic.EntityName
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description="Optional name used for display purposes. Example 'Data Steward'.",
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Optional description of the team.'),
    ]
    users: Annotated[
        Optional[List[basic.Uuid]],
        Field(
            None,
            description='Optional IDs of users that are going to assign a Persona.',
        ),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Persona belongs to.',
        ),
    ]
    default: Annotated[
        Optional[bool],
        Field(
            False,
            description="When true, this persona is the system-wide default persona that will be applied to users who don't have any persona assigned or no default persona set.",
        ),
    ]
