# generated by datamodel-codegen:
#   filename:  auth/refreshToken.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic
from . import emailVerificationToken


class RefreshToken(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    token: Annotated[basic.Uuid, Field(description='Unique Refresh Token for user')]
    userId: Annotated[
        basic.Uuid,
        Field(description='User Id of the User this refresh token is given to'),
    ]
    tokenType: Annotated[
        Optional[emailVerificationToken.TokenType],
        Field(emailVerificationToken.TokenType.REFRESH_TOKEN, description='Token Type'),
    ]
    refreshCount: Annotated[Optional[int], Field(None, description='Refresh Count')]
    maxRefreshCount: Annotated[Optional[int], Field(None, description='Refresh Count')]
    expiryDate: Annotated[
        basic.Timestamp, Field(description='Expiry Date-Time of the token')
    ]
